/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.json;

import com.google.common.io.Files;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import name.abuchen.portfolio.json.JTransaction;
import name.abuchen.portfolio.json.impl.LocalDateSerializer;
import name.abuchen.portfolio.json.impl.LocalTimeSerializer;
import name.abuchen.portfolio.model.TransactionPair;

public class JClient {
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new LocalDateSerializer()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeSerializer()).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    private int version = 1;
    private List<JTransaction> transactions;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Stream<JTransaction> getTransactions() {
        return this.transactions == null ? Stream.empty() : this.transactions.stream();
    }

    public void addTransaction(JTransaction transaction) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<JTransaction>();
        }
        this.transactions.add(transaction);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static JClient from(List<TransactionPair<?>> transactions) {
        JClient client = new JClient();
        transactions.stream().map(JTransaction::from).forEach(client::addTransaction);
        return client;
    }

    public static JClient from(String file) throws IOException {
        return (JClient)GSON.fromJson(Files.asCharSource((File)new File(file), (Charset)StandardCharsets.UTF_8).read(), JClient.class);
    }
}

