/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.Values;

public abstract class SwissBasedPDFExtractor
extends AbstractPDFExtractor {
    private final DecimalFormat swissNumberFormat = (DecimalFormat)DecimalFormat.getInstance(new Locale("de", "CH"));

    public SwissBasedPDFExtractor(Client client) {
        super(client);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator('\'');
        this.swissNumberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    @Override
    protected long asAmount(String value) {
        return this.asValue(value, Values.Amount);
    }

    @Override
    protected long asShares(String value) {
        return this.asValue(value, Values.Share);
    }

    protected long asValue(String value, Values<Long> valueType) {
        try {
            return Math.abs(Math.round(this.swissNumberFormat.parse(value).doubleValue() * (double)valueType.factor()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected BigDecimal asExchangeRate(String value) {
        try {
            return BigDecimal.valueOf(this.swissNumberFormat.parse(value).doubleValue());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

