/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import name.abuchen.portfolio.datatransfer.Extractor;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.util.PDFTextStripper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class PDFInputFile
extends Extractor.InputFile {
    private String text;
    private String author;

    public PDFInputFile(File file) {
        super(file);
    }

    public PDFInputFile(File file, String extractedText) {
        this(file);
        this.text = extractedText;
    }

    public static List<Extractor.InputFile> loadTestCase(Class<?> testCase, String ... filenames) {
        ArrayList<Extractor.InputFile> answer = new ArrayList<Extractor.InputFile>();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            answer.add(PDFInputFile.loadSingleTestCase(testCase, filename));
            ++n2;
        }
        return answer;
    }

    public static PDFInputFile loadSingleTestCase(Class<?> testCase, String filename) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(testCase.getResourceAsStream(filename), StandardCharsets.UTF_8.name());){
            String extractedText = scanner.useDelimiter("\\A").next();
            return new PDFInputFile(new File(filename), extractedText);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<Extractor.InputFile> createTestCase(String filename, String text) {
        ArrayList<Extractor.InputFile> answer = new ArrayList<Extractor.InputFile>();
        answer.add(new PDFInputFile(new File(filename), text));
        return answer;
    }

    public String getText() {
        return this.text;
    }

    public String getAuthor() {
        return this.author;
    }

    public Version getPDFBoxVersion() {
        return FrameworkUtil.getBundle(PDDocument.class).getVersion();
    }

    public void convertPDFtoText() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PDDocument document = PDDocument.load((File)this.getFile());){
                PDDocumentInformation pdd;
                boolean isProtected = document.isEncrypted();
                if (isProtected) {
                    document.decrypt("");
                    document.setAllSecurityToBeRemoved(true);
                }
                this.author = (pdd = document.getDocumentInformation()).getAuthor() == null ? "" : pdd.getAuthor();
                PDFTextStripper textStripper = new PDFTextStripper();
                textStripper.setSortByPosition(true);
                this.text = textStripper.getText(document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CryptographyException e) {
            throw new IOException(e);
        }
    }
}

