/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class OnvistaPDFExtractor
extends AbstractPDFExtractor {
    public OnvistaPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("");
        this.addBankIdentifier("onvista bank");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addTaxReturnTransaction();
        this.addChangeTransaction();
        this.addPayingTransaction();
        this.addDividendTransaction();
        this.addTransferInTransaction();
        this.addCapitalReductionTransaction();
        this.addCapitalIncreaseTransaction();
        this.addAddDididendRightsTransaction();
        this.addRemoveDididendRightsTransaction();
        this.addExchangeTransaction();
        this.addCompensationTransaction();
        this.addFusionTransaction();
        this.addDepositTransaction();
        this.addAccountStatementTransaction();
        this.addAccountStatementTransaction2017();
        this.addRegistrationFeeTransaction();
        this.addTaxVorabpauschaleTransaction();
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wir haben f\u00fcr Sie gekauft");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wir haben f\u00fcr Sie gekauft(.*)", "(Dieser Beleg wird|Finanzamt)(.*)");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin", "currency").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").find("Nominal Kurs").match("^\\w{3} ([\\d,\\.]*) (?<currency>\\w{3}) ([\\d,\\.]*)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal Kurs").match("(?<notation>^\\w{3}) (?<shares>[\\d,\\.]*) (?<currency>\\w{3}) ([\\d,\\.]*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("date").match("Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}) (.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("time").optional().match("Handelszeit (?<time>\\d+:\\d+)(.*)").assign((t, v) -> {
            LocalTime time = this.asTime((String)v.get("time"));
            t.setDate(t.getPortfolioTransaction().getDateTime().with(time));
        }).oneOf(section -> section.attributes("amount", "currency").find("Wert(\\s+)Konto-Nr. Betrag zu Ihren Lasten(\\s*)$").match("(\\d+\\.\\d+\\.\\d{4}) (\\d{6,12}) (?<currency>\\w{3}) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency", "forex", "exchangeRate").find("Wert(\\s+)Konto-Nr. Devisenkurs Betrag zu Ihren Lasten(\\s*)$").match("(\\d+\\.\\d+\\.\\d{4}) (\\d{6,12}) .../(?<forex>\\w{3}) (?<exchangeRate>[\\d,\\.]*) (?<currency>\\w{3}) (?<amount>[\\d,\\.]*)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            String forex = this.asCurrencyCode((String)v.get("forex"));
            if (t.getPortfolioTransaction().getSecurity().getCurrencyCode().equals(forex)) {
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                BigDecimal reverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxAmount = exchangeRate.multiply(BigDecimal.valueOf(t.getPortfolioTransaction().getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue();
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, t.getPortfolioTransaction().getMonetaryAmount(), Money.of(forex, fxAmount), reverseRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        })).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wir haben f\u00fcr Sie verkauft");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wir haben f\u00fcr Sie verkauft(.*)", "(Dieser Beleg wird|Finanzamt)(.*)");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal Kurs").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("date").match("Handelstag (?<date>\\d+\\.\\d+\\.\\d{4}) (.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("time").optional().match("Handelszeit (?<time>\\d+:\\d+)(.*)").assign((t, v) -> {
            LocalTime time = this.asTime((String)v.get("time"));
            t.setDate(t.getPortfolioTransaction().getDateTime().with(time));
        }).oneOf(section -> section.attributes("amount", "currency").find("Wert(\\s+)Konto-Nr. Betrag zu Ihren Gunsten(\\s*)$").match("(\\d+\\.\\d+\\.\\d{4}) (\\d{6,12}) (?<currency>\\w{3}) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency", "forex", "exchangeRate").find("Wert(\\s+)Konto-Nr. Devisenkurs Betrag zu Ihren Gunsten(\\s*)$").match("(\\d+\\.\\d+\\.\\d{4}) (\\d{6,12}) .../(?<forex>\\w{3}) (?<exchangeRate>[\\d,\\.]*) (?<currency>\\w{3}) (?<amount>[\\d,\\.]*)$").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            String forex = this.asCurrencyCode((String)v.get("forex"));
            if (t.getPortfolioTransaction().getSecurity().getCurrencyCode().equals(forex)) {
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                BigDecimal reverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                long fxAmount = exchangeRate.multiply(BigDecimal.valueOf(t.getPortfolioTransaction().getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue();
                Transaction.Unit grossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, t.getPortfolioTransaction().getMonetaryAmount(), Money.of(forex, fxAmount), reverseRate);
                t.getPortfolioTransaction().addUnit(grossValue);
            }
        })).wrap(Extractor.BuySellEntryItem::new);
        this.addTaxesSectionsTransaction(pdfTransaction);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addChangeTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Best\u00e4tigung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Best\u00e4tigung(.*)");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal Kurs").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("date", "amount", "currency").find("Wert(\\s+)Konto-Nr. Betrag zu Ihren Lasten(\\s*)$").match("(?<date>\\d+.\\d+.\\d{4}+) (\\d{6,12}) (?<currency>\\w{3}+) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)$").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addPayingTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gutschriftsanzeige");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Gutschriftsanzeige(.*)");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung (.*) ISIN").match("(?<name>.*) (.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal Einl\u00f6sung(.*)$").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)$").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("date", "amount", "currency").find("Wert(\\s+)Konto-Nr. Betrag zu Ihren Gunsten$").match("(?<date>\\d+.\\d+.\\d{4}+) (\\d{6,12}) (?<currency>\\w{3}+) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addTaxesSectionsTransaction(pdfTransaction);
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Ertr\u00e4gnisgutschrift", (context, lines) -> {
            Pattern pCurrency = Pattern.compile("^.* (?<currencypair>\\w{3}+/\\w{3}+) (?<exchangeRate>[\\d,.]+) .*$");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pCurrency.matcher(line);
                if (m.matches()) {
                    context.put(m.group("currencypair"), m.group("exchangeRate"));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Dividendengutschrift.*|Kupongutschrift.*|Ertr\u00e4gnisgutschrift.*(\\d+.\\d+.\\d{4})|Ertr\u00e4gnisgutschrift");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin", "currency").find("Gattungsbezeichnung(.*) ISIN").match("(?<name>.*?) (\\d+.\\d+.\\d{4} ){0,2}(?<isin>[^ ]\\S*)$").match(".* (?<currency>\\w{3}+) [\\d,.]+$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares", "date").match("(?<notation>^\\w{3}+) (?<shares>[\\d.]+(,\\d{3,})?) (\\d+.\\d+.\\d{4}+ )?(?<date>\\d+\\.\\d+\\.\\d{4}+) .*").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !"STK".equalsIgnoreCase(notation)) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setDateTime(this.asDate((String)v.get("date")));
        }).oneOf(section -> section.attributes("amount", "currency").match("(?<date>\\d+.\\d+.\\d{4}+) [^ ]* (?<currency>\\w{3}+) (?<amount>[\\d,.]+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency").match("Leistungen aus dem steuerlichen Einlagenkonto .* (?<currency>\\w{3}+) (?<amount>[\\d,.]+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }), section -> section.attributes("amount", "currency", "exchangeRate", "fxCurrency").match("(?<date>\\d+.\\d+.\\d{4}+) [^ ]* (\\w{3}+)/(?<fxCurrency>\\w{3}+) (?<exchangeRate>[\\d,.]+) (?<currency>\\w{3}+) (?<amount>[\\d,.]+)").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
            long fxAmount = exchangeRate.multiply(BigDecimal.valueOf(t.getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue();
            Money forex = Money.of(this.asCurrencyCode((String)v.get("fxCurrency")), fxAmount);
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, t.getMonetaryAmount(), forex, BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN));
            if (unit.getForex().getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(unit);
            }
        }));
        BiConsumer<AccountTransaction, Map> taxAssignment = (t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (t.getCurrencyCode().equals(tax.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
                return;
            }
            Optional<Transaction.Unit> grossValue = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            if (grossValue.isPresent() && grossValue.get().getForex().getCurrencyCode().equals(tax.getCurrencyCode())) {
                Transaction.Unit gv = grossValue.get();
                Money money = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(gv.getExchangeRate()).setScale(0, RoundingMode.HALF_DOWN).longValue());
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money, tax, gv.getExchangeRate()));
                t.removeUnit(grossValue.get());
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(gv.getAmount().getCurrencyCode(), grossValue.get().getAmount().getAmount() + money.getAmount()), Money.of(gv.getForex().getCurrencyCode(), gv.getForex().getAmount() + tax.getAmount()), gv.getExchangeRate()));
            } else if (type.getCurrentContext().containsKey(String.valueOf(t.getCurrencyCode()) + "/" + tax.getCurrencyCode())) {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get(String.valueOf(t.getCurrencyCode()) + "/" + tax.getCurrencyCode()));
                Money money = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).divide(exchangeRate, 0, RoundingMode.HALF_DOWN).longValue());
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, money));
            }
        };
        pdfTransaction.section("tax", "currency").optional().match("^davon anrechenbare US-Quellensteuer ([0-9,]+% )?(?<currency>\\w{3}+)\\s+(?<tax>[\\d.,]*)").assign(taxAssignment).section("tax", "currency").optional().match("^ausl\u00e4ndische Quellensteuer [0-9,]+% (?<currency>\\w{3}+)\\s+(?<tax>[\\d.,]+)").assign(taxAssignment).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(pdfTransaction);
        block = new PDFParser.Block("Reinvestierung.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("date").match("(^\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{3})?) (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+)?(.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("name", "isin").find("Die Dividende wurde wie folgt in neue Aktien reinvestiert:").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares", "amount", "currency").find("Nominal Reinvestierungspreis").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?) (?<currency>\\w{3}+) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")) * this.asAmount((String)v.get("shares")) / 100L);
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addTransferInTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wir erhielten zu Gunsten Ihres Depots");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wir erhielten zu Gunsten Ihres Depots(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares", "date").find("Nominal Schlusstag Wert").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?) (\\d+.\\d+.\\d{4}+) (?<date>\\d+.\\d+.\\d{4}+)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addCapitalReductionTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kapitalherabsetzung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Aus|Ein)buchung:(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date").optional().match("(^\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{3})?) (?<date>\\d+.\\d+.\\d{4}+)?(.*)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            type.getCurrentContext().put("date", (String)v.get("date"));
        }).section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("transactiontype").match("^(?<transactiontype>.*buchung:)(.*)").assign((t, v) -> {
            String transactiontype = (String)v.get("transactiontype");
            if ("Einbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            } else if ("Ausbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            }
        }).section("notation", "shares").find("Nominal(.*)").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
            if (t.getDateTime() == null) {
                t.setDateTime(this.asDate(type.getCurrentContext().get("date")));
            }
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addCapitalIncreaseTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kapitalerh\u00f6hung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Kapitalerh\u00f6hung(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date").match("(.*), (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("name", "isin").find("Einbuchung:(\\s*)").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal(.*)").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addAddDididendRightsTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Einbuchung von Rechten f\u00fcr die");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Einbuchung von Rechten f\u00fcr die(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("date").match("(.*), (?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("name", "isin").find("Einbuchung:(\\s*)").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares").find("Nominal(.*)").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addRemoveDididendRightsTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertlose Ausbuchung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertlose Ausbuchung(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Ausbuchung:(\\s*)").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("notation", "shares", "date").find("Nominal Ex-Tag").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?) (?<date>\\d+.\\d+.\\d{4}+)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addExchangeTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Umtausch", (context, lines) -> {
            Pattern pDate = Pattern.compile("(^|.* / )(?<contextDate>\\d{2}\\.\\d{2}\\.\\d{4}) .*");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pDate.matcher(line);
                if (m.matches()) {
                    context.put("contextDate", m.group(2));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Aus|Ein)buchung:(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            type.getCurrentContext().put("isin", (String)v.get("isin"));
        }).section("transactiontype").match("^(?<transactiontype>.*buchung:)(.*)").assign((t, v) -> {
            String transactiontype = (String)v.get("transactiontype");
            if ("Einbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            } else if ("Ausbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            }
        }).section("date").optional().find("(.*)(Schlusstag|Ex-Tag|Wert Konto-Nr.*)").match("(.*)(^|\\s+)(?<date>\\d+\\.\\d+\\.\\d{4}+).*").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            type.getCurrentContext().put("contextDate", (String)v.get("date"));
        }).section("notation", "shares").find("Nominal(.*)").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
            if (t.getDateTime() == null) {
                t.setDateTime(this.asDate(type.getCurrentContext().get("contextDate")));
            }
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxBlock(type);
    }

    private void addCompensationTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Abfindung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Ausbuchung(.*)");
        type.addBlock(block);
        PDFParser.Transaction<BuySellEntry> pdfTransaction = new PDFParser.Transaction<BuySellEntry>();
        pdfTransaction.subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("transactiontype").match("^(?<transactiontype>.*buchung:)(.*)").assign((t, v) -> {
            String transactiontype = (String)v.get("transactiontype");
            if ("Einbuchung:".equalsIgnoreCase(transactiontype)) {
                t.getAccountTransaction().setType(AccountTransaction.Type.BUY);
                t.getPortfolioTransaction().setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            } else if ("Ausbuchung:".equalsIgnoreCase(transactiontype)) {
                t.getAccountTransaction().setType(AccountTransaction.Type.SELL);
                t.getPortfolioTransaction().setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            }
        }).section("notation", "shares", "date").find("Nominal Ex-Tag").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?) (?<date>\\d+.\\d+.\\d{4}+)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setDate(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode(t.getPortfolioTransaction().getSecurity().getCurrencyCode()));
        }).section("date", "amount", "currency").find("Wert(\\s+)Konto-Nr. Betrag zu Ihren Gunsten(\\s*)$").match("(?<date>\\d+.\\d+.\\d{4}+) (\\d{6,12}) (?<currency>\\w{3}+) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.BuySellEntryItem::new);
        this.addFeesSectionsTransaction(pdfTransaction);
    }

    private void addFusionTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(Fusion|Einstellung der Zertifizierung)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(Aus|Ein)buchung:(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("transactiontype").match("^(?<transactiontype>.*buchung:)(.*)").assign((t, v) -> {
            String transactiontype = (String)v.get("transactiontype");
            if ("Einbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            } else if ("Ausbuchung:".equalsIgnoreCase(transactiontype)) {
                t.setType(PortfolioTransaction.Type.DELIVERY_OUTBOUND);
            }
        }).section("date").optional().find("(.*)(Schlusstag|Ex-Tag)").match("(.*)(?<date>\\d+.\\d+.\\d{4}+)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            type.getCurrentContext().put("date", (String)v.get("date"));
        }).section("notation", "shares").find("Nominal(.*)").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            t.setCurrencyCode(this.asCurrencyCode(t.getSecurity().getCurrencyCode()));
            if (t.getDateTime() == null) {
                t.setDateTime(this.asDate(type.getCurrentContext().get("date")));
            }
        }).wrap(Extractor.TransactionItem::new);
        this.addTaxesSectionsTransaction(pdfTransaction);
        this.addTaxBlock(type);
    }

    private void addRegistrationFeeTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Registrierung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Registrierungsgeb.*(\\d+.\\d+.\\d{4})");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.FEES);
            return transaction;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("name", "isin").find("Gattungsbezeichnung(.*) ISIN").match("(?<name>.*?) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date", "currency", "amount").find("Wert(\\s*)Konto-Nr. Betrag zu Ihren Lasten(\\s*)$").match("(?<date>\\d+.\\d+.\\d{4}+) (\\d{6,12}) (?<currency>\\w{3}+) (?<amount>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addDepositTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Depotauszug", (context, lines) -> {
            Pattern pDate = Pattern.compile(".*epotauszug per (\\d+.\\d+.\\d{4}+)?(.*)");
            Pattern pCurrency = Pattern.compile("(.*)Bewertung in[ ]+(\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pDate.matcher(line);
                if (m.matches()) {
                    context.put("date", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(2));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("(^\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{3})?)(.*)");
        type.addBlock(block);
        PDFParser.Transaction<PortfolioTransaction> pdfTransaction = new PDFParser.Transaction<PortfolioTransaction>();
        pdfTransaction.subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("notation", "shares", "nameP1").optional().match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?) (?<nameP1>.*)").assign((t, v) -> {
            type.getCurrentContext().put("nameP1", (String)v.get("nameP1"));
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("nameP3").optional().find("(^\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{3})?) (.*)").match("(?<nameP3>^[A-Za-z-]*)(\\s*)").assign((t, v) -> {
            String string = type.getCurrentContext().put("nameP3", (String)v.get("nameP3"));
        }).oneOf(section -> section.attributes("nameP2", "isin").match("(?<nameP2>.* )(?<isin>\\w{12}) *([0-9.]{10} )?Girosammelverwahrung .*").assign((t, v) -> {
            type.getCurrentContext().put("nameP2", (String)v.get("nameP2"));
            type.getCurrentContext().put("isin", (String)v.get("isin"));
        }), section -> section.attributes("notation", "shares", "nameP1", "isin").match("(?<notation>^\\w{3}+) (?<shares>\\d{1,3}(\\.\\d{3})*(,\\d{3,})?)(?<nameP1>((?:\\S|\\s(?!\\s))*))(\\s)(?<isin>.*)(\\s)(Girosammelverwahrung|Wertpapierrechnung)(.*)").assign((t, v) -> {
            type.getCurrentContext().put("nameP1", (String)v.get("nameP1"));
            type.getCurrentContext().put("isin", ((String)v.get("isin")).replaceAll("\\s", ""));
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("STK")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
            v.put("isin", ((String)v.get("isin")).replaceAll("\\s", ""));
        })).section("nameP4").optional().find("^(.*) (\\w{12}+) (.*)").match("^(?<nameP4>^.*\\.*)$").assign((t, v) -> {
            String string = type.getCurrentContext().put("nameP4", (String)v.get("nameP4"));
        }).section("combine").match("(?<combine>.*)").assign((t, v) -> {
            v.put("isin", type.getCurrentContext().get("isin"));
            StringBuilder sbName = new StringBuilder(type.getCurrentContext().get("nameP1"));
            int i = 2;
            while (i <= 4) {
                if (type.getCurrentContext().get("nameP" + i) != null) {
                    sbName.append(type.getCurrentContext().get("nameP" + i));
                }
                ++i;
            }
            String name = sbName.toString();
            if (name.indexOf((String)v.get("isin")) > -1) {
                name = name.substring(0, name.indexOf((String)v.get("isin")));
            }
            if (name.indexOf("STK ") > -1) {
                name = name.substring(0, name.indexOf("STK "));
            }
            name = name.replaceAll("\\s+", " ");
            name = name.replaceAll("0+%", "%");
            name = name.replaceAll("\\s+\\.", ".");
            v.put("name", name);
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            if (t.getDateTime() == null) {
                t.setDateTime(this.asDate(type.getCurrentContext().get("date")));
            }
            if (t.getCurrencyCode() == null) {
                t.setCurrencyCode(this.asCurrencyCode(type.getCurrentContext().get("currency")));
            }
        }).wrap(Extractor.TransactionItem::new);
    }

    private void addAccountStatementTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("KONTOAUSZUG Nr.", (context, lines) -> {
            Pattern pYear = Pattern.compile("KONTOAUSZUG Nr. \\d+ per \\d+.\\d+.(\\d{4}+)?(.*)");
            Pattern pCurrency = Pattern.compile("(.*)Customer Cash Account[ ]+(\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pYear.matcher(line);
                if (m.matches()) {
                    context.put("year", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(2));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^\\d+\\.\\d+\\.\\s+\\d+\\.\\d+\\.\\s+REF:\\s+\\d+\\s+[\\d.-]+,\\d+[+-]?(.*)");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DEPOSIT);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("valuta", "amount", "sign").match("^\\d+\\.\\d+\\.\\s+(?<valuta>\\d+\\.\\d+\\.)\\s+REF:\\s+\\d+\\s+(?<amount>[\\d.-]+,\\d+)(?<sign>[+-]?)(.*)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            String sign = (String)v.get("sign");
            if ("-".equals(sign)) {
                t.setType(AccountTransaction.Type.REMOVAL);
            }
        }).section("postingtype").find("\\d+\\.\\d+\\.\\s+\\d+\\.\\d+\\. REF:(.*)").match("(?<postingtype>.*?)").assign((t, v) -> {
            block26: {
                String postingtype = (String)v.get("postingtype");
                if (postingtype == null) break block26;
                switch (postingtype) {
                    case "Sollbuchung HSBC": 
                    case "Wertpapierkauf": 
                    case "Umtausch/Bezug": {
                        t.setType(AccountTransaction.Type.BUY);
                        break;
                    }
                    case "Spitze Verkauf": 
                    case "Habenbuchung HSBC": 
                    case "Tilgung": 
                    case "Wertpapierverkauf": {
                        t.setType(AccountTransaction.Type.SELL);
                        break;
                    }
                    case "Zinsen/Dividenden": {
                        t.setType(AccountTransaction.Type.DIVIDENDS);
                        break;
                    }
                    case "AbgSt. Optimierung": {
                        t.setType(AccountTransaction.Type.TAX_REFUND);
                        break;
                    }
                }
            }
        }).wrap(t -> {
            if (t.getType() != AccountTransaction.Type.DIVIDENDS && t.getType() != AccountTransaction.Type.BUY && t.getType() != AccountTransaction.Type.SELL && t.getType() != AccountTransaction.Type.TAX_REFUND) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        });
    }

    private void addAccountStatementTransaction2017() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kontoauszug Nr.", (context, lines) -> {
            Pattern pYear = Pattern.compile("^Kontoauszug Nr. (\\d{4}) / .*\\.(\\d{4})$");
            Pattern pCurrency = Pattern.compile("^(\\w{3}+) - Verrechnungskonto: .*$");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pYear.matcher(line);
                if (m.matches()) {
                    context.put("year", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^\\d+\\.\\d+\\.\\s+\\d+\\.\\d+\\.\\s+REF:\\s+\\d+\\s+[\\d.-]+,\\d+[+-]?(.*)");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> pdfTransaction = new PDFParser.Transaction<AccountTransaction>();
        pdfTransaction.subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.DEPOSIT);
            return entry;
        });
        block.set(pdfTransaction);
        pdfTransaction.section("valuta", "amount", "sign").match("^\\d+\\.\\d+\\.\\s+(?<valuta>\\d+\\.\\d+\\.)\\s+REF:\\s+\\d+\\s+(?<amount>[\\d.-]+,\\d+)(?<sign>[+-]?)(.*)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            String sign = (String)v.get("sign");
            if ("-".equals(sign)) {
                t.setType(AccountTransaction.Type.REMOVAL);
            }
        }).section("postingtype").find("\\d+\\.\\d+\\.\\s+\\d+\\.\\d+\\. REF:(.*)").match("(?<postingtype>.*?)").assign((t, v) -> {
            block26: {
                String postingtype = (String)v.get("postingtype");
                if (postingtype == null) break block26;
                switch (postingtype) {
                    case "Sollbuchung HSBC": 
                    case "Wertpapierkauf": 
                    case "Umtausch/Bezug": {
                        t.setType(AccountTransaction.Type.BUY);
                        break;
                    }
                    case "Spitze Verkauf": 
                    case "Habenbuchung HSBC": 
                    case "Tilgung": 
                    case "Wertpapierverkauf": {
                        t.setType(AccountTransaction.Type.SELL);
                        break;
                    }
                    case "Zinsen/Dividenden": {
                        t.setType(AccountTransaction.Type.DIVIDENDS);
                        break;
                    }
                    case "AbgSt. Optimierung": {
                        t.setType(AccountTransaction.Type.TAX_REFUND);
                        break;
                    }
                }
            }
        }).wrap(t -> {
            if (t.getType() != AccountTransaction.Type.DIVIDENDS && t.getType() != AccountTransaction.Type.BUY && t.getType() != AccountTransaction.Type.SELL && t.getType() != AccountTransaction.Type.TAX_REFUND) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        });
    }

    private <T extends PDFParser.Transaction<?>> void addTaxesSectionsTransaction(T pdfTransaction) {
        pdfTransaction.section("tax", "withheld", "sign").optional().match("(?<withheld>\\w+|^(Verwahrart\\s.*)?|^(Lagerland\\s.*)?)(\\s*)Kapitalertragsteuer(\\s*)(?<currency>\\w{3}+)(\\s+)(?<tax>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(?<sign>-|\\s+|$)?").assign((t, v) -> {
            if ("-".equalsIgnoreCase((String)v.get("sign")) || "einbehaltene".equalsIgnoreCase((String)v.get("withheld"))) {
                if (t instanceof Transaction) {
                    ((Transaction)t).addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
                } else {
                    ((BuySellEntry)t).getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))));
                }
            }
        }).section("soli", "withheld", "sign").optional().match("(?<withheld>\\w+|^|.*)(\\s*)Solidarit\u00e4tszuschlag(\\s*)(?<currency>\\w{3}+)(\\s+)(?<soli>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(?<sign>-|\\s+|$)?").assign((t, v) -> {
            if ("-".equalsIgnoreCase((String)v.get("sign")) || "einbehaltener".equalsIgnoreCase((String)v.get("withheld"))) {
                if (t instanceof Transaction) {
                    ((Transaction)t).addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("soli")))));
                } else {
                    ((BuySellEntry)t).getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("soli")))));
                }
            }
        }).section("kirchenst", "withheld", "sign").optional().match("(?<withheld>\\w+|^)(\\s*)Kirchensteuer(\\s*)(?<currency>\\w{3}+)(\\s+)(?<kirchenst>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(?<sign>-|\\s+|$)?").assign((t, v) -> {
            if ("-".equalsIgnoreCase((String)v.get("sign")) || "einbehaltene".equalsIgnoreCase((String)v.get("withheld"))) {
                if (t instanceof Transaction) {
                    ((Transaction)t).addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("kirchenst")))));
                } else {
                    ((BuySellEntry)t).getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("kirchenst")))));
                }
            }
        });
    }

    private void addFeesSectionsTransaction(PDFParser.Transaction<BuySellEntry> pdfTransaction) {
        BiConsumer<BuySellEntry, Map> feeProcessor = (t, v) -> {
            String currency = this.asCurrencyCode((String)v.get("currency"));
            if (t.getPortfolioTransaction().getCurrencyCode().equals(currency)) {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))));
            } else {
                Optional<Transaction.Unit> grossValue = t.getPortfolioTransaction().getUnit(Transaction.Unit.Type.GROSS_VALUE);
                if (grossValue.isPresent() && grossValue.get().getForex().getCurrencyCode().equals(currency)) {
                    Transaction.Unit gv = grossValue.get();
                    Money forex = Money.of(currency, this.asAmount((String)v.get("fee")));
                    Money amount = Money.of(t.getPortfolioTransaction().getCurrencyCode(), gv.getExchangeRate().multiply(BigDecimal.valueOf(forex.getAmount())).setScale(0, RoundingMode.HALF_DOWN).longValue());
                    t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, amount, forex, gv.getExchangeRate()));
                    t.getPortfolioTransaction().removeUnit(gv);
                    Transaction.Unit newGrossValue = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of(gv.getAmount().getCurrencyCode(), gv.getAmount().getAmount() - amount.getAmount()), Money.of(gv.getForex().getCurrencyCode(), gv.getForex().getAmount() - forex.getAmount()), gv.getExchangeRate());
                    t.getPortfolioTransaction().addUnit(newGrossValue);
                }
            }
        };
        pdfTransaction.section("fee", "currency").optional().match("(^.*)(Orderprovision) (?<currency>\\w{3}) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign(feeProcessor).section("fee", "currency").optional().match("(^.*) (B\\Drsengeb\\Dhr) (?<currency>\\w{3}) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign(feeProcessor).section("fee", "currency").optional().match("(^.*) (Handelsplatzgeb\\Dhr) (?<currency>\\w{3}) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign(feeProcessor).section("fee", "currency").optional().match("(^.*)(Maklercourtage)(\\s+)(?<currency>\\w{3}) (?<fee>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign(feeProcessor);
    }

    private void addTaxReturnTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Steuerausgleich nach \u00a7 43a");
        this.addDocumentTyp(type);
        PDFParser.Block block1 = new PDFParser.Block("Wir haben f\u00fcr Sie (ge|ver)kauft(.*)");
        type.addBlock(block1);
        PDFParser.Block block2 = new PDFParser.Block("Gutschriftsanzeige|(Aus|Ein)buchung:(.*)");
        type.addBlock(block2);
        PDFParser.Transaction<AccountTransaction> taxRefundTransaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAX_REFUND);
            return entry;
        }).section("name", "isin").find("Gattungsbezeichnung (.*)ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("tax").optional().match("^Kapitalertragsteuer (?<currency>\\w{3}+) (?<tax>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).section("soli").optional().match("^Solidarit\u00e4tszuschlag (?<currency>\\w{3}+) (?<soli>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("soli")));
        }).section("kirchenst").optional().match("^Kirchensteuer (?<currency>\\w{3}+) (?<kirchenst>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("kirchenst")));
        }).section("date", "currency").optional().find("Wert(\\s+)Konto-Nr.(\\s+)Abrechnungs-Nr.(\\s+)Betrag zu Ihren Gunsten(\\s*)$").match("(^|\\s+)(?<date>\\d+\\.\\d+\\.\\d{4}+)(\\s)(\\d+)?(\\s)?(\\d+)?(\\s)(?<currency>\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : null);
        block1.set(taxRefundTransaction);
        block2.set(taxRefundTransaction);
    }

    private void addTaxBlock(PDFParser.DocumentType type) {
        PDFParser.Block block = new PDFParser.Block("(Kapitalertragsteuer)(.*)-$");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAXES);
            return entry;
        }).section("tax", "currency").optional().match("^Kapitalertragsteuer (?<currency>\\w{3}+) (?<tax>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).section("soli", "currency").optional().match("^Solidarit\u00e4tszuschlag (?<currency>\\w{3}+) (?<soli>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("soli")));
        }).section("kirchenst", "currency").optional().match("^Kirchensteuer (?<currency>\\w{3}+) (?<kirchenst>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)(-)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(t.getAmount() + this.asAmount((String)v.get("kirchenst")));
        }).section("date", "currency").optional().find("Wert(\\s+)Konto-Nr.(\\s+)Betrag zu Ihren Lasten(\\s*)$").match("(^|\\s+)(?<date>\\d+\\.\\d+\\.\\d{4}+)(\\s)(\\d+)(\\s)(?<currency>\\w{3}+) (\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            v.put("isin", type.getCurrentContext().get("isin"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("date", "currency", "exchangeRate", "amountSum").optional().find("Wert(\\s+)Konto-Nr.(\\s+)(Devisenkurs\\s+)Betrag zu Ihren Lasten(\\s*)$").match("(^|\\s+)(?<date>\\d+\\.\\d+\\.\\d{4}+)(\\s)(\\d+)(\\s)(\\w{3}+\\/\\w{3}+ )(?<exchangeRate>[\\d,]+)[\\s]?(?<currency>\\w{3}+) (?<amountSum>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            v.put("isin", type.getCurrentContext().get("isin"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setDateTime(this.asDate((String)v.get("date")));
            String currencyCodeFx = t.getCurrencyCode();
            if (t.getSecurity().getCurrencyCode().equalsIgnoreCase(currencyCodeFx)) {
                Money mTaxesFx = Money.of(currencyCodeFx, t.getAmount());
                Money mTaxesFxInEUR = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amountSum")));
                BigDecimal inverseRate = BigDecimal.valueOf(this.asAmount((String)v.get("amountSum"))).divide(BigDecimal.valueOf(t.getAmount()), 10, RoundingMode.HALF_DOWN);
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, mTaxesFxInEUR, mTaxesFx, inverseRate));
                t.setAmount(this.asAmount((String)v.get("amountSum")));
            } else {
                t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
                t.setAmount(this.asAmount((String)v.get("amountSum")));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addTaxVorabpauschaleTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Steuerpflichtige Vorabpauschale");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Steuerpflichtige Vorabpauschale(.*)");
        type.addBlock(block);
        PDFParser.Transaction<AccountTransaction> taxVorabpauschaleTransaction = new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAXES);
            return entry;
        }).section("name", "isin").find("Gattungsbezeichnung ISIN").match("(?<name>.*) (?<isin>[^ ]\\S*)$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("tax", "currency").optional().match("^Wert Konto-Nr. Betrag zu Ihren Lasten").match("(\\d+\\.\\d+\\.\\d{4}+) .* (?<currency>\\w{3}+) (?<tax>\\d{1,3}(\\.\\d{3})*(,\\d{2})?)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("tax")));
        }).section("date").optional().match("^Nominal Ex-Tag Zahltag Jahreswert Vorabpauschale pro St\u00fcck").match("STK .* (?<exdate>\\d+\\.\\d+\\.\\d{4}+) (?<date>\\d+\\.\\d+\\.\\d{4}+) (?<currency>\\w{3}+) .*").assign((t, v) -> {
            if (t.getCurrencyCode() == null) {
                t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            }
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> t.getAmount() != 0L ? new Extractor.TransactionItem((AccountTransaction)t) : new Extractor.NonImportableItem("Steuerpflichtige Vorabpauschale mit 0 " + t.getCurrencyCode()));
        block.set(taxVorabpauschaleTransaction);
    }

    @Override
    public String getLabel() {
        return "Onvista-Bank";
    }
}

