/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.json.JPDFExtractorDefinition;
import name.abuchen.portfolio.json.JSecurity;
import name.abuchen.portfolio.json.JTransaction;
import name.abuchen.portfolio.json.JTransactionUnit;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.util.TextUtil;

public class JSONPDFExtractor
extends AbstractPDFExtractor {
    private JPDFExtractorDefinition definition;

    public JSONPDFExtractor(Client client, String resource) {
        super(client);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/name/abuchen/portfolio/datatransfer/pdf/" + resource), StandardCharsets.UTF_8);){
                this.definition = (JPDFExtractorDefinition)new Gson().fromJson((Reader)in, JPDFExtractorDefinition.class);
                this.addBankIdentifier("");
                this.addTransaction();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void addTransaction() {
        PDFParser.DocumentType document = new PDFParser.DocumentType(this.definition.getPattern().stream().map(Pattern::compile).collect(Collectors.toList()));
        this.addDocumentTyp(document);
        for (JPDFExtractorDefinition.JTransactionMatcher jtx : this.definition.getTransactions()) {
            PDFParser.Block block = new PDFParser.Block(jtx.getStartsWith(), jtx.getEndsWith());
            document.addBlock(block);
            PDFParser.Transaction<JTransaction> pdftx = new PDFParser.Transaction<JTransaction>();
            block.set(pdftx);
            pdftx.subject(() -> {
                JTransaction t = new JTransaction();
                t.setType(jtx.getType());
                return t;
            });
            this.addSections(jtx, pdftx);
            switch (jtx.getType()) {
                case PURCHASE: {
                    pdftx.wrap(t -> this.wrapBuySell((JTransaction)t, PortfolioTransaction.Type.BUY));
                    break;
                }
                case SALE: {
                    pdftx.wrap(t -> this.wrapBuySell((JTransaction)t, PortfolioTransaction.Type.SELL));
                    break;
                }
                case DIVIDEND: {
                    pdftx.wrap(t -> this.wrapAccountTransaction((JTransaction)t, AccountTransaction.Type.DIVIDENDS));
                    break;
                }
                case INBOUND_DELIVERY: {
                    pdftx.wrap(t -> this.wrapPortfolioTransaction((JTransaction)t, PortfolioTransaction.Type.DELIVERY_INBOUND));
                    break;
                }
                case OUTBOUND_DELIVERY: {
                    pdftx.wrap(t -> this.wrapPortfolioTransaction((JTransaction)t, PortfolioTransaction.Type.DELIVERY_OUTBOUND));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void addSections(JPDFExtractorDefinition.JTransactionMatcher transaction, PDFParser.Transaction<JTransaction> tx) {
        for (JPDFExtractorDefinition.JSection section : transaction.getSections()) {
            ArrayList<String> attributes = new ArrayList<String>();
            for (String regexp : section.getPattern()) {
                Pattern p = Pattern.compile("\\(\\?\\<([A-Za-z0-9]*)\\>");
                Matcher matcher = p.matcher(regexp);
                while (matcher.find()) {
                    attributes.add(matcher.group(1));
                }
            }
            PDFParser.Section<JTransaction> sec = tx.section(attributes.toArray(new String[0]));
            if (section.isOptional()) {
                sec.optional();
            }
            for (String regexp : section.getPattern()) {
                sec.match(regexp);
            }
            sec.assign((t, v) -> {
                HashMap<String, String> values = new HashMap<String, String>();
                if (section.getAttributes() != null) {
                    values.putAll(section.getAttributes());
                }
                values.putAll((Map<String, String>)v);
                if (section.getContext() == JPDFExtractorDefinition.JSectionContext.SECURITY) {
                    this.setValuesToSecurity((JTransaction)t, (Map<String, String>)values);
                } else if (section.getContext() == JPDFExtractorDefinition.JSectionContext.UNIT) {
                    this.setValuesToUnit((JTransaction)t, (Map<String, String>)values);
                } else {
                    this.setValues((JTransaction)t, (Map<String, String>)values);
                }
            });
        }
    }

    private void setValues(JTransaction t, Map<String, String> v) {
        this.asDouble(v.get("amount")).ifPresent(t::setAmount);
        if (v.containsKey("currency")) {
            t.setCurrency(v.get("currency"));
        }
        this.asLocalDate(v.get("date")).ifPresent(t::setDate);
        this.asLocalTime(v.get("time")).ifPresent(t::setTime);
        this.asDouble(v.get("shares")).ifPresent(t::setShares);
    }

    private void setValuesToSecurity(JTransaction t, Map<String, String> v) {
        JSecurity security = new JSecurity();
        security.setName(TextUtil.strip(v.get("name")));
        security.setIsin(v.get("isin"));
        security.setTicker(v.get("ticker"));
        security.setWkn(v.get("wkn"));
        security.setCurrency(this.asCurrencyCode(v.get("currency")));
        t.setSecurity(security);
    }

    private void setValuesToUnit(JTransaction t, Map<String, String> v) {
        JTransactionUnit unit = new JTransactionUnit();
        unit.setType(Transaction.Unit.Type.valueOf(v.get("type")));
        this.asDouble(v.get("amount")).ifPresent(unit::setAmount);
        this.asDouble(v.get("fxAmount")).ifPresent(unit::setFxAmount);
        this.asDouble(v.get("fxRateToBase")).ifPresent(d -> unit.setFxRateToBase(BigDecimal.valueOf(d)));
        if (v.containsKey("fxCurrency")) {
            unit.setFxCurrency(this.asCurrencyCode(v.get("fxCurrency")));
        }
        t.addUnit(unit);
    }

    private Optional<Double> asDouble(String value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.GERMANY);
            return Optional.of(Math.abs(numberFormat.parse(value).doubleValue()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Optional<LocalDate> asLocalDate(String value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.asDate(value).toLocalDate());
    }

    private Optional<LocalTime> asLocalTime(String value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm")));
        }
        catch (Exception e) {
            return Optional.of(LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm:ss")).withSecond(0));
        }
    }

    private Extractor.Item wrapBuySell(JTransaction t, PortfolioTransaction.Type txType) {
        BuySellEntry entry = new BuySellEntry();
        entry.setType(txType);
        if (t.getTime() != null) {
            entry.setDate(t.getDate().atTime(t.getTime()));
        } else {
            entry.setDate(t.getDate().atStartOfDay());
        }
        entry.setAmount(Values.Amount.factorize(t.getAmount()));
        entry.setCurrencyCode(t.getCurrency());
        entry.setShares(Values.Share.factorize(t.getShares()));
        Security security = this.convertToSecurity(t);
        entry.setSecurity(security);
        t.getUnits().map(u -> this.convertToUnit(security, t, (JTransactionUnit)u)).filter(Objects::nonNull).forEach(u -> entry.getPortfolioTransaction().addUnit((Transaction.Unit)u));
        Extractor.BuySellEntryItem item = new Extractor.BuySellEntryItem(entry);
        item.setData(t);
        return item;
    }

    private Extractor.Item wrapAccountTransaction(JTransaction t, AccountTransaction.Type type) {
        AccountTransaction tx = new AccountTransaction();
        tx.setType(type);
        this.fillIn(t, tx);
        Extractor.TransactionItem item = new Extractor.TransactionItem(tx);
        item.setData(t);
        return item;
    }

    private Extractor.Item wrapPortfolioTransaction(JTransaction t, PortfolioTransaction.Type type) {
        PortfolioTransaction tx = new PortfolioTransaction();
        tx.setType(type);
        this.fillIn(t, tx);
        Extractor.TransactionItem item = new Extractor.TransactionItem(tx);
        item.setData(t);
        return item;
    }

    private void fillIn(JTransaction t, Transaction tx) {
        tx.setAmount(Values.Amount.factorize(t.getAmount()));
        tx.setCurrencyCode(t.getCurrency());
        tx.setShares(Values.Share.factorize(t.getShares()));
        if (t.getTime() != null) {
            tx.setDateTime(t.getDate().atTime(t.getTime()));
        } else {
            tx.setDateTime(t.getDate().atStartOfDay());
        }
        Security security = this.convertToSecurity(t);
        tx.setSecurity(security);
        t.getUnits().map(u -> this.convertToUnit(security, t, (JTransactionUnit)u)).filter(Objects::nonNull).forEach(tx::addUnit);
    }

    private Security convertToSecurity(JTransaction t) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("name", t.getSecurity().getName());
        values.put("isin", t.getSecurity().getIsin());
        values.put("tickerSymbol", t.getSecurity().getTicker());
        values.put("wkn", t.getSecurity().getWkn());
        values.put("currency", t.getSecurity().getCurrency());
        return this.getOrCreateSecurity(values);
    }

    private Transaction.Unit convertToUnit(Security security, JTransaction jtx, JTransactionUnit junit) {
        long forexAmount;
        String fxCurrency;
        Money amount;
        String txCurrency = jtx.getCurrency();
        if (txCurrency.equals(security.getCurrencyCode())) {
            if (junit.getType() != Transaction.Unit.Type.GROSS_VALUE) {
                if (junit.getAmount() != null && junit.getAmount() != 0.0) {
                    return new Transaction.Unit(junit.getType(), Money.of(txCurrency, Values.Amount.factorize(junit.getAmount())));
                }
                if (junit.getFxAmount() != null && junit.getFxAmount() != 0.0 && junit.getFxRateToBase() != null && junit.getFxRateToBase().compareTo(BigDecimal.ZERO) != 0) {
                    double value = BigDecimal.valueOf(junit.getFxAmount()).divide(junit.getFxRateToBase(), 2, RoundingMode.HALF_DOWN).doubleValue();
                    Money amount2 = Money.of(txCurrency, Values.Amount.factorize(value));
                    return new Transaction.Unit(junit.getType(), amount2);
                }
            }
            return null;
        }
        Money money = amount = junit.getAmount() != null ? Money.of(txCurrency, Values.Amount.factorize(junit.getAmount())) : Money.of(txCurrency, Values.Amount.factorize(0.0));
        if (amount.isZero()) {
            if (junit.getFxAmount() != null && junit.getFxAmount() != 0.0 && junit.getFxRateToBase() != null && junit.getFxRateToBase().compareTo(BigDecimal.ZERO) != 0) {
                double value = BigDecimal.valueOf(junit.getFxAmount()).divide(junit.getFxRateToBase(), 2, RoundingMode.HALF_DOWN).doubleValue();
                junit.setAmount(value);
                amount = Money.of(txCurrency, Values.Amount.factorize(value));
            } else {
                return null;
            }
        }
        if ((fxCurrency = junit.getFxCurrency()) == null || fxCurrency.equals(txCurrency)) {
            junit.setFxAmount(null);
            junit.setFxCurrency(null);
            junit.setFxRateToBase(null);
            return new Transaction.Unit(junit.getType(), amount);
        }
        long l = forexAmount = junit.getFxAmount() != null ? Values.Amount.factorize(junit.getFxAmount()) : 0L;
        if (forexAmount == 0L) {
            if (junit.getFxRateToBase() != null) {
                forexAmount = BigDecimal.valueOf(amount.getAmount()).multiply(junit.getFxRateToBase()).setScale(0, RoundingMode.HALF_DOWN).longValue();
            } else {
                return null;
            }
        }
        Money forex = Money.of(fxCurrency, forexAmount);
        BigDecimal fxRateToBase = junit.getFxRateToBase();
        fxRateToBase = fxRateToBase == null ? BigDecimal.valueOf(amount.getAmount()).divide(BigDecimal.valueOf(forex.getAmount()), 10, RoundingMode.HALF_DOWN) : BigDecimal.ONE.divide(fxRateToBase, 10, RoundingMode.HALF_DOWN);
        return new Transaction.Unit(junit.getType(), amount, Money.of(fxCurrency, forexAmount), fxRateToBase);
    }

    @Override
    public String getLabel() {
        return this.definition.getName();
    }
}

