/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;

public class FinTechGroupBankPDFExtractor
extends AbstractPDFExtractor {
    public FinTechGroupBankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("biw AG");
        this.addBankIdentifier("FinTech Group Bank AG");
        this.addBankIdentifier("flatex Bank AG");
        this.addBuySellTransaction();
        this.addBuyTransaction();
        this.addBuyfromSavingsplanTransaction();
        this.addDepositAndWithdrawalTransaction();
        this.addDividendTransaction();
        this.addForeignDividendTransaction();
        this.addSellTransaction();
        this.addTransferInOutTransaction();
        this.addTransferOutTransaction();
        this.addRemoveTransaction();
        this.addRemoveNewFormatTransaction();
        this.addOverdraftinterestTransaction();
        this.addTaxoptimisationTransaction();
        this.addVorabpauschaleTransaction();
    }

    private void addBuySellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Sammelabrechnung \\(Wertpapierkauf/-verkauf\\)");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Nr.(\\d*)/(\\d*) *Kauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("wkn", "isin", "name").match("Nr.[0-9A-Za-z]*/(\\d*) *Kauf *(?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "date", "time").match("^davon ausgef\\. *: (?<shares>[.\\d]+,\\d*) St\\. *Schlusstag *: *(?<date>\\d+.\\d+.\\d{4}+), (?<time>\\d+:\\d+)(.+)?").assign((t, v) -> {
            t.setShares(this.asShares((String)v.get("shares")));
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("amount", "currency").match(".* Endbetrag *: *(?<amount>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match(".* Provision *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new));
        block = new PDFParser.Block("Nr.(\\d*)/(\\d*) *Verkauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("wkn", "isin", "name").match("Nr.(\\d*)/(\\d*) *Verkauf *(?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "date", "time").match("^davon ausgef\\. *: (?<shares>[.\\d]+,\\d*) St\\. *Schlusstag *: *(?<date>\\d+.\\d+.\\d{4}+), (?<time>\\d+:\\d+)(.+)?").assign((t, v) -> {
            t.setShares(this.asShares((String)v.get("shares")));
            if (v.get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("amount", "currency").match(".* Endbetrag *: *(?<amount>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match(".* Provision *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen *: *(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("exchangeRate").optional().match("^Devisenkurs\\s*:\\s*(?<exchangeRate>\\d+,\\d+).*").assign((t, v) -> type.getCurrentContext().put("exchangeRate", (String)v.get("exchangeRate"))).section("tax", "currency").optional().match(".* \\*\\*Einbeh. Steuer *: *(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")));
            if (!t.getPortfolioTransaction().getCurrencyCode().equals(tax.getCurrencyCode())) {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get("exchangeRate"));
                Money txTax = Money.of(t.getPortfolioTransaction().getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue());
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax));
            } else {
                t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("taxreturn", "currency").optional().match(".* \\*\\*Einbeh. Steuer *: *(?<taxreturn>-[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.setAmount(t.getPortfolioTransaction().getAmount() - this.asAmount((String)v.get("taxreturn")))).wrap(Extractor.BuySellEntryItem::new));
        this.addTaxReturnBlock(type);
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung Kauf Fonds/Zertifikate");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".*Auftragsdatum.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("time").optional().match(".*Ausf\u00fchrungszeit[\\s:]*(?<time>\\d+:\\d+).+").assign((t, v) -> type.getCurrentContext().put("time", (String)v.get("time"))).section("date").match(".*[Schlusstag|Handelstag]\\s*(?<date>\\d+.\\d+.\\d{4}).*").assign((t, v) -> {
            if (type.getCurrentContext().get("time") != null) {
                t.setDate(this.asDate((String)v.get("date"), type.getCurrentContext().get("time")));
            } else {
                t.setDate(this.asDate((String)v.get("date")));
            }
        }).section("wkn", "isin", "name").match("Nr.[0-9A-Za-z]*/(\\d*) *Kauf *(?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^Ausgef\u00fchrt[\\s:]*(?<shares>[\\.\\d]+(,\\d*)?) *St\\..*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).oneOf(section -> section.attributes("amount", "currency").match(".* Endbetrag[\\s:]*(?<currency>\\w{3}+) *(?<amount>[\\d.-]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }), section -> section.attributes("amount", "currency").match(".* Endbetrag[\\s:]*(?<amount>[\\d.-]+,\\d+)\\s(?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        })).section("fee", "currency").optional().match(".* Provision[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Provision[\\s:]*(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen[\\s:]*(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen[\\s:]*(?<fee>[\\d.-]+,\\d+) *(?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addBuyfromSavingsplanTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Sammelabrechnung aus Sparplan");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Auftrags-Nr :.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name").match("ISIN *: (?<isin>[^/]*)").match("Bezeichnung *: (?<name>.*)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date", "shares", "amount").match("^Kauf *(\\d+.\\d+.\\d{4}) *(?<date>\\d+.\\d+.\\d{4}) *(?<shares>[\\.\\d]+(,\\d*)?) *([\\d.-]+,\\d+) *(\\w{3}+) *(?<amount>[\\d.-]+,\\d+) *(?<currency>\\w{3}+)").assign((t, v) -> {
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addDepositAndWithdrawalTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kontoauszug Nr:", (context, lines) -> {
            Pattern pYear = Pattern.compile("Kontoauszug Nr:[ ]*\\d+/(\\d+).*");
            Pattern pCurrency = Pattern.compile("Kontow.hrung:[ ]+(\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pYear.matcher(line);
                if (m.matches()) {
                    context.put("year", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("\\d+\\.\\d+\\.[ ]+\\d+\\.\\d+\\.[ ]+.berweisung[ ]+[\\d.-]+,\\d+[+-]");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("valuta", "amount", "sign").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+.berweisung[ ]+(?<amount>[\\d.-]+,\\d+)(?<sign>[+-])").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            String sign = (String)v.get("sign");
            if ("-".equals(sign)) {
                t.setType(AccountTransaction.Type.REMOVAL);
            }
        }).wrap(Extractor.TransactionItem::new));
        block = new PDFParser.Block("\\d+\\.\\d+\\.[ ]+\\d+\\.\\d+\\.[ ]+.Lastschrift[ ]+[\\d.-]+,\\d+[+-]");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("valuta", "amount", "sign").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+Lastschrift[ ]+(?<amount>[\\d.-]+,\\d+)(?<sign>[+-])").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        block = new PDFParser.Block("\\d+\\.\\d+\\.[ ]+\\d+\\.\\d+\\.[ ]+Geb.hr Kapitaltransaktion Ausland[ ]+[\\d.-]+,\\d+[-]");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("valuta", "amount", "isin").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+Geb.hr Kapitaltransaktion Ausland[ ]+(?<amount>[\\d.-]+,\\d+)[-]").match("\\s*(?<isin>\\w{12})").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setNote("Geb\u00fchr Kapitaltransaktion Ausland");
        }).wrap(Extractor.TransactionItem::new));
        block = new PDFParser.Block("\\d+.\\d+.[ ]+\\d+.\\d+.[ ]+Depotgeb.hren[ ]+\\d{2}.\\d{2}.\\d{4}[ -]+\\d{2}.\\d{2}.\\d{4},[ ]+[\\d.-]+,\\d+[-]");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("valuta", "amount", "text").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+(?<text>Depotgeb.hren[ ]+\\d{2}.\\d{2}.\\d{4}[ -]+\\d{2}.\\d{2}.\\d{4}),[ ]+(?<amount>[\\d.-]+,\\d+)[-]").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setNote((String)v.get("text"));
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type1 = new PDFParser.DocumentType("([^ ]Dividendengutschrift f\u00fcr inl\u00e4ndische Wertpapiere)|(Dividendengutschrift[^ ])");
        PDFParser.DocumentType type2 = new PDFParser.DocumentType("Ertragsmitteilung");
        PDFParser.DocumentType type3 = new PDFParser.DocumentType("Zinsgutschrift");
        this.addDocumentTyp(type1);
        this.addDocumentTyp(type2);
        this.addDocumentTyp(type3);
        PDFParser.Block block = new PDFParser.Block("Ihre Depotnummer.*");
        type1.addBlock(block);
        type2.addBlock(block);
        type3.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("wkn", "isin", "name").match("Nr\\.(\\d*) * (?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("^St\\.[^:]+: *(?<shares>[\\.\\d]+(,\\d*)?).*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match(".* Endbetrag *: *(?<amount>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("tax", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("date").match("Valuta * : *(?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("amountFx", "currencyFx", "exchangeRate").optional().match(".*Devisenkurs *: *(?<exchangeRate>[.\\d]+,\\d+).*").match(".*Gez. Quellenst.*: *(?<amountFx>[.\\d]+,\\d{2}) (?<currencyFx>\\w{3})").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currencyFx")), this.asAmount((String)v.get("amountFx")));
            if (tax.getCurrencyCode().equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            } else {
                BigDecimal exchangeRate = this.asExchangeRate((String)v.get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                Money txTax = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(inverseRate).setScale(0, RoundingMode.HALF_UP).longValue());
                if (t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax));
                } else {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax, tax, inverseRate));
                }
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    private void addForeignDividendTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("[^ ](Dividendengutschrift f\u00fcr ausl\u00e4ndische Wertpapiere)", (context, lines) -> {
            Pattern pCurrencyFx = Pattern.compile(".* Bruttodividende *: *[.\\d]+,\\d{2} (?<currencyFx>\\w{3})");
            Pattern pExchangeRate = Pattern.compile(".*Devisenkurs *: *(?<exchangeRate>[.\\d]+,\\d+).*");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pCurrencyFx.matcher(line);
                if (m.matches()) {
                    context.put("currencyFx", m.group(1));
                }
                if ((m = pExchangeRate.matcher(line)).matches()) {
                    context.put("exchangeRate", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Ihre Depotnummer.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("wkn", "isin", "name").match("Nr\\.(\\d*) * (?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currencyFx"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("shares").match("^St\\.[^:]+: *(?<shares>[\\.\\d]+(,\\d*)?).*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("amount", "currency").match(".* Endbetrag *: *(?<amount>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("amountGrossFx", "currencyFx").match(".* Bruttodividende *: *(?<amountGrossFx>[.\\d]+,\\d{2}) (?<currencyFx>\\w{3})").assign((t, v) -> {
            String currencyCodeFx;
            Map<String, String> context = type.getCurrentContext();
            String currencyCode = t.getCurrencyCode();
            if (!t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode()) && !currencyCode.equalsIgnoreCase(currencyCodeFx = this.asCurrencyCode((String)v.get("currencyFx")))) {
                BigDecimal exchangeRate = this.asExchangeRate(context.get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                Money mAmountGrossFx = Money.of(currencyCodeFx, this.asAmount((String)v.get("amountGrossFx")));
                BigDecimal amountGrossFxInEUR = BigDecimal.valueOf(mAmountGrossFx.getAmount()).divide(exchangeRate, 10, RoundingMode.HALF_DOWN).setScale(0, RoundingMode.HALF_DOWN);
                Money mAmountGrossFxInEUR = Money.of(currencyCode, amountGrossFxInEUR.longValue());
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, mAmountGrossFxInEUR, mAmountGrossFx, inverseRate));
            }
        }).section("amountFx", "currencyFx").optional().match(".*Gez. Quellenst.*: *(?<amountFx>[.\\d]+,\\d{2}) (?<currencyFx>\\w{3})").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currencyFx")), this.asAmount((String)v.get("amountFx")));
            if (tax.getCurrencyCode().equals(t.getCurrencyCode())) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            } else if (type.getCurrentContext().containsKey("exchangeRate")) {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get("exchangeRate"));
                BigDecimal inverseRate = BigDecimal.ONE.divide(exchangeRate, 10, RoundingMode.HALF_DOWN);
                Money txTax = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(inverseRate).setScale(0, RoundingMode.HALF_UP).longValue());
                if (t.getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax));
                } else {
                    t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax, tax, inverseRate));
                }
            }
        }).section("amount", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<amount>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            Money tax = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("amount")));
            if (!t.getCurrencyCode().equals(tax.getCurrencyCode())) {
                BigDecimal exchangeRate = this.asExchangeRate(type.getCurrentContext().get("exchangeRate"));
                Money txTax = Money.of(t.getCurrencyCode(), BigDecimal.valueOf(tax.getAmount()).multiply(exchangeRate).setScale(0, RoundingMode.HALF_UP).longValue());
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, txTax));
            } else {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, tax));
            }
        }).section("date").match("Valuta * : *(?<date>\\d+.\\d+.\\d{4}+).*").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).wrap(Extractor.TransactionItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung Verkauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".*Auftragsdatum.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date").optional().match(".*Schlusstag *(?<date>\\d+.\\d+.\\d{4}).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("date").optional().match(".*Handelstag *(?<date>\\d+.\\d+.\\d{4}).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("wkn", "isin", "name").match("Nr.(\\d*)/(\\d*) *Verkauf *(?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "notation").match("^Ausgef\u00fchrt[ :]*(?<shares>[\\.\\d]+(,\\d*)?) *(?<notation>St\\.|\\w{3}+).*").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("St.")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).oneOf(section -> section.attributes("amount", "currency").match(".* Endbetrag *(?<currency>\\w{3}+) *(?<amount>[\\d.-]+,\\d+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }), section -> section.attributes("amount", "currency").match(".* Endbetrag[ :]*(?<amount>[\\d.-]+,\\d+)\\s(?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        })).section("fee", "currency").optional().match(".* Provision[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Provision[\\s:]*(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen[\\s:]*(?<fee>[\\d.-]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen[\\s:]*(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen[\\s:]*(?<fee>[\\d.-]+,\\d+) *(?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addTransferInOutTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gutschrifts-/Belastungsanzeige");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Depoteingang .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<PortfolioTransaction>().subject(() -> {
            PortfolioTransaction entry = new PortfolioTransaction();
            entry.setType(PortfolioTransaction.Type.DELIVERY_INBOUND);
            return entry;
        }).section("date").match("Datum(\\s*):(\\s+)(?<date>\\d+.\\d+.\\d{4})").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).section("isin", "name").match("Depoteingang *(?<name>.*) *\\((?<isin>[^/]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "notation").match("^Stk\\.\\/Nominale(\\s*):(\\s+)(?<shares>[\\.\\d]+(,\\d*)?) *(?<notation>St\\.|\\w{3}+)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("Stk")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("rate", "currency").match("^Kurs(\\s*):(\\s+)(?<rate>[\\d.]+,\\d+)(\\s+)(?<currency>\\w{3}+)(\\s+)(.*)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("rate")) * t.getShares() / (long)Values.Share.factor());
        }).section("tax", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(Extractor.TransactionItem::new));
    }

    private void addTransferOutTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Depotausgang");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Depotausgang(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date").match("F\u00e4lligkeitstag(\\s*):(\\s+)(?<date>\\d+.\\d+.\\d{4})(.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("isin", "name").match("Depotausgang *(?<name>.*) *\\((?<isin>[^/]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "notation").match("^Stk\\.\\/Nominale(\\s*):(\\s+)(?<shares>[\\.\\d]+(,\\d*)?) *(?<notation>St\\.|\\w{3}+)(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("Stk")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("amount", "currency").match("(.*)Geldgegenwert\\*\\*(.*)(\\s*):(\\s*)(?<amount>[\\d.]+,\\d+)(\\s+)(?<currency>\\w{3}+)(.*)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match(".* Provision *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addRemoveTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Bestandsausbuchung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Bestandsausbuchung(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("date").match("F\u00e4lligkeitstag(\\s*):(\\s+)(?<date>\\d+.\\d+.\\d{4})(.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("isin", "name").match("Bestandsausbuchung *(?<name>.*) *\\((?<isin>[^/]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares", "notation").match("^Stk\\.\\/Nominale(.*):(\\s+)(?<shares>[\\.\\d]+(,\\d*)?)(\\s*)(?<notation>\\w{3}+)(.*)[Einbeh]+(.*)").assign((t, v) -> {
            String notation = (String)v.get("notation");
            if (notation != null && !notation.equalsIgnoreCase("Stk")) {
                t.setShares(this.asShares((String)v.get("shares")) / 100L);
            } else {
                t.setShares(this.asShares((String)v.get("shares")));
            }
        }).section("amount", "currency").optional().match("(.*)Geldgegenwert\\*\\*(.*)(\\s*):(\\s*)(?<amount>[\\d.]+,\\d+)(\\s+)(?<currency>\\w{3}+)(.*)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section(new String[0]).optional().match("(.*)Bestand haben wir wertlos ausgebucht(.*)").assign((t, v) -> {
            t.setCurrencyCode(t.getAccountTransaction().getSecurity().getCurrencyCode());
            t.setAmount(0L);
            t.getPortfolioTransaction().setType(PortfolioTransaction.Type.TRANSFER_OUT);
            t.setType(PortfolioTransaction.Type.TRANSFER_OUT);
        }).section("fee", "currency").optional().match(".* Provision *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addRemoveNewFormatTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Gutschrifts- / Belastungsanzeige");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Kundennummer(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("wkn", "isin", "name", "shares").match("(?s)(?<wkn>\\w{6}+)(\\s+)(?<isin>\\w{12}+)(\\s+)(?<name>.*?)(\\s+)(?<shares>[\\.\\d]+(,\\d*)?)(.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("date").match("F\u00e4lligkeitstag(\\s*):(\\s+)(?<date>\\d+.\\d+.\\d{4})(.*)").assign((t, v) -> t.setDate(this.asDate((String)v.get("date")))).section("amount", "currency").optional().match("(.*)Geldgegenwert(\\*{1,3})(.*)(\\s*):(\\s*)(?<amount>[\\d.]+,\\d+)(\\s+)(?<currency>\\w{3}+)(.*)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section(new String[0]).optional().match("(.*)Bestand haben wir wertlos ausgebucht(.*)").assign((t, v) -> {
            t.setCurrencyCode(t.getAccountTransaction().getSecurity().getCurrencyCode());
            t.setAmount(0L);
            t.getPortfolioTransaction().setType(PortfolioTransaction.Type.TRANSFER_OUT);
            t.setType(PortfolioTransaction.Type.TRANSFER_OUT);
        }).section("fee", "currency").optional().match(".* Provision *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* Eigene Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("fee", "currency").optional().match(".* \\*Fremde Spesen *(?<currency>\\w{3}+) *(?<fee>[\\d.-]+,\\d+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).section("tax", "currency").optional().match("(.*)Einbeh. Steuer(.*):(\\s*)(?<tax>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addOverdraftinterestTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kontoauszug Nr:", (context, lines) -> {
            Pattern pYear = Pattern.compile("Kontoauszug Nr:[ ]*\\d+/(\\d+).*");
            Pattern pCurrency = Pattern.compile("Kontow.hrung:[ ]+(\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pYear.matcher(line);
                if (m.matches()) {
                    context.put("year", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("\\d+\\.\\d+\\.[ ]+\\d+\\.\\d+\\.[ ]+Zinsabschluss[ ]+(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.INTEREST_CHARGE);
            return t;
        }).section("valuta", "amount", "sign").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+Zinsabschluss[ ]+(\\d+.\\d+.\\d{4})(\\s+)-(\\s+)(\\d+.\\d+.\\d{4})(\\s+)(?<amount>[\\d.-]+,\\d+)(?<sign>[+-])").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setNote((String)v.get("text"));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            String sign = (String)v.get("sign");
            if ("+".equals(sign)) {
                t.setType(AccountTransaction.Type.INTEREST);
            }
        }).wrap(t -> {
            if (t.getAmount() != 0L) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        }));
    }

    private void addTaxoptimisationTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Kontoauszug Nr:", (context, lines) -> {
            Pattern pYear = Pattern.compile("Kontoauszug Nr:[ ]*\\d+/(\\d+).*");
            Pattern pCurrency = Pattern.compile("Kontow.hrung:[ ]+(\\w{3}+)");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pYear.matcher(line);
                if (m.matches()) {
                    context.put("year", m.group(1));
                }
                if ((m = pCurrency.matcher(line)).matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("\\d+\\.\\d+\\.[ ]+\\d+\\.\\d+\\.[ ]+Steuertopfoptimierung[ ]+(.*)");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).section("valuta", "amount", "sign").match("\\d+.\\d+.[ ]+(?<valuta>\\d+.\\d+.)[ ]+Steuertopfoptimierung[ ]+(\\d{4})(\\s+)(?<amount>[\\d.-]+,\\d+)(?<sign>[+-])").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            String date = (String)v.get("valuta");
            if (date != null) {
                t.setDateTime(this.asDate(String.valueOf(date) + context.get("year")));
            }
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            String sign = (String)v.get("sign");
            if ("-".equals(sign)) {
                t.setType(AccountTransaction.Type.TAXES);
            }
        }).wrap(t -> {
            if (t.getAmount() != 0L) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        }));
    }

    private void addTaxReturnBlock(PDFParser.DocumentType type) {
        PDFParser.Block block = new PDFParser.Block("Nr.(\\d*)/(\\d*) *Verkauf.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction entry = new AccountTransaction();
            entry.setType(AccountTransaction.Type.TAX_REFUND);
            return entry;
        }).section("taxreturn").optional().match(".* \\*\\*Einbeh. Steuer *: *(?<taxreturn>-[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("taxreturn")));
        }).section("wkn", "isin", "name").match("Nr.(\\d*)/(\\d*) *Verkauf *(?<name>.*) *\\((?<isin>[^/]*)/(?<wkn>[^)]*)\\)").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("date").match("^davon ausgef\\. *: ([.\\d]+,\\d*) St\\. *Schlusstag *: *(?<date>\\d+.\\d+.\\d{4}+), \\d+:\\d+.+").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).wrap(t -> {
            if (t.getCurrencyCode() != null && t.getAmount() != 0L) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        }));
    }

    private void addVorabpauschaleTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung Vorabpauschale", (context, lines) -> {
            Pattern pDate = Pattern.compile("Buchungsdatum +(?<date>\\d+.\\d+.\\d{4}+) *");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pDate.matcher(line);
                if (m.matches()) {
                    context.put("buchungsdatum", m.group("date"));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Wertpapierabrechnung Vorabpauschale .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAXES);
            return t;
        }).section("wkn", "isin", "name").match("^Depotinhaber: .*").match("^(?<name>.*) +(?<isin>[^ ]+)/(?<wkn>[^ ]+) *$").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("amount", "currency").match(".* Einbeh. Steuer * (?<amount>[\\d.,]+) (?<currency>\\w{3}+) *").assign((t, v) -> {
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode("currency"));
        }).section("date").match("Gesamtbestand .*zum +(?<date>\\d+.\\d+.\\d{4}+) *").assign((t, v) -> {
            String buchungsdatum = type.getCurrentContext().get("buchungsdatum");
            t.setDateTime(this.asDate(buchungsdatum != null ? buchungsdatum : (String)v.get("date")));
        }).section("shares").match("Gesamtbestand * (?<shares>[\\d,.]+) St.*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).wrap(t -> {
            if (t.getAmount() != 0L) {
                return new Extractor.TransactionItem((AccountTransaction)t);
            }
            return null;
        }));
    }

    @Override
    public String getLabel() {
        return "FinTech Group Bank AG / flatex / Whitebox";
    }
}

