/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;

public class DeutscheBankPDFExtractor
extends AbstractPDFExtractor {
    public DeutscheBankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Deutsche Bank");
        this.addBankIdentifier("DB Privat- und Firmenkundenbank AG");
        this.addDividendTransaction("Ertragsgutschrift");
        this.addDividendTransaction("Dividendengutschrift");
    }

    private void addDividendTransaction(String nameOfTransaction) {
        PDFParser.DocumentType type = new PDFParser.DocumentType(nameOfTransaction);
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(nameOfTransaction);
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction transaction = new AccountTransaction();
            transaction.setType(AccountTransaction.Type.DIVIDENDS);
            return transaction;
        }).section("wkn", "isin", "name", "currency").find("St\u00fcck WKN ISIN").match("([\\d.]+,\\d*) (?<wkn>\\S*) (?<isin>\\S*)").match("^(?<name>.*)$").match("Bruttoertrag ([\\d.]+,\\d+) (?<currency>\\w{3}+).*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("(?<shares>[\\d.]+,\\d*) (\\S*) (\\S*)").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").match("Gutschrift mit Wert (?<date>\\d+.\\d+.\\d{4}+) (?<amount>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
        }).section("grossValue", "currency").optional().match("Bruttoertrag (?<grossValue>[\\d.]+,\\d+) (?<currency>\\w{3}+)").assign((t, v) -> {
            Money grossValue = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("grossValue")));
            Money taxes = MutableMoney.of(t.getCurrencyCode()).add(grossValue).subtract(t.getMonetaryAmount()).toMoney();
            if (!taxes.isZero()) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, taxes));
            }
        }).section("forexSum", "forexCurrency", "grossValue", "currency", "exchangeRate").optional().match("Bruttoertrag (?<forexSum>[\\d.]+,\\d+) (?<forexCurrency>\\w{3}+) (?<grossValue>[\\d.]+,\\d+) (?<currency>\\w{3}+)").match("Umrechnungskurs (\\w{3}+) zu (\\w{3}+) (?<exchangeRate>[\\d.]+,\\d+)").assign((t, v) -> {
            Money taxes;
            BigDecimal exchangeRate;
            Money forex;
            Money grossValue = Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("grossValue")));
            Transaction.Unit unit = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, grossValue, forex = Money.of(this.asCurrencyCode((String)v.get("forexCurrency")), this.asAmount((String)v.get("forexSum"))), exchangeRate = BigDecimal.ONE.divide(this.asExchangeRate((String)v.get("exchangeRate")), 10, RoundingMode.HALF_DOWN));
            if (unit.getForex().getCurrencyCode().equals(t.getSecurity().getCurrencyCode())) {
                t.addUnit(unit);
            }
            if (!(taxes = MutableMoney.of(t.getCurrencyCode()).add(grossValue).subtract(t.getMonetaryAmount()).toMoney()).isZero()) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, taxes));
            }
        }).wrap(Extractor.TransactionItem::new));
    }

    @Override
    public String getLabel() {
        return "Deutsche Bank";
    }
}

