/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.pdf;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.pdf.AbstractPDFExtractor;
import name.abuchen.portfolio.datatransfer.pdf.PDFParser;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.Money;

public class BaaderBankPDFExtractor
extends AbstractPDFExtractor {
    public BaaderBankPDFExtractor(Client client) {
        super(client);
        this.addBankIdentifier("Baader Bank");
        this.addBankIdentifier("Scalable Capital");
        this.addBankIdentifier("GRATISBROKER GmbH");
        this.addBuyTransaction();
        this.addSellTransaction();
        this.addDividendTransaction();
        this.addTaxAdjustmentTransaction();
        this.addPreTaxTransaction();
        this.addFeesAssetManagerTransaction();
        this.addPeriodenauszugTransactions();
    }

    @Override
    public String getPDFAuthor() {
        return "Scalable Capital Verm\u00f6gensverwaltung GmbH";
    }

    private void addBuyTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung: Kauf");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block(".* Portfolio: .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "wkn", "name").match("Nominale *ISIN: *(?<isin>[^ ]*) *WKN: *(?<wkn>[^ ]*) *Kurs *").match("STK [^ ]* (?<name>.*) (?<currency>\\w{3}) [\\d.,]+,\\d{2,}+").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("STK *(?<shares>[\\.\\d]+[,\\d]*) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).oneOf(section -> section.attributes("date", "time").find("Handelsdatum *Handelsuhrzeit").match("^(?<date>\\d+\\.\\d+\\.\\d{4}) (?<time>\\d+:\\d+).*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))), section -> section.attributes("date", "time").find("Nominale Kurs Ausf\u00fchrungsplatz datum uhrzeit").match("^STK .* (?<date>\\d+\\.\\d+\\.\\d{4}) (?<time>\\d+:\\d+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time"))))).section("amount", "currency").match("Zu Lasten Konto \\d+ Valuta: \\d+\\.\\d+\\.\\d{4} *(?<currency>\\w{3}) *(?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("fee", "currency").optional().match("Provision *(?<currency>\\w{3}) *(?<fee>[\\d.]+,\\d{2})").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(Extractor.BuySellEntryItem::new));
    }

    private void addSellTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Wertpapierabrechnung: Verkauf.*");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Auftragsdatum.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("name", "isin", "wkn", "currency").match("Nominale *ISIN: *(?<isin>[^ ]*) *WKN: *(?<wkn>[^ ]*) .*").match("STK [^ ]+ +(?<name>.*) (?<currency>\\w{3}) [\\d.,]+").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("STK *(?<shares>[\\.\\d]+[,\\d]*) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).oneOf(section -> section.attributes("date", "time").find("Handelsdatum *Handelsuhrzeit").match("^(?<date>\\d+\\.\\d+\\.\\d{4}) (?<time>\\d+:\\d+).*$").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time")))), section -> section.attributes("date", "time").find("Nominale Kurs Ausf\u00fchrungsplatz datum uhrzeit").match("^STK .* (?<date>\\d+\\.\\d+\\.\\d{4}) (?<time>\\d+:\\d+).*").assign((t, v) -> t.setDate(this.asDate((String)v.get("date"), (String)v.get("time"))))).section("amount", "currency").match("Zu Gunsten Konto \\d+ Valuta: \\d+\\.\\d+\\.\\d{4} *(?<currency>\\w{3}) *(?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("tax", "currency").optional().match("Kapitalertragsteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Kirchensteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Solidarit\u00e4tszuschlag (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("fee", "currency").optional().match("Provision (?<currency>\\w{3}) (?<fee>[\\d.]+,\\d{2}) -").assign((t, v) -> t.getPortfolioTransaction().addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("fee")))))).wrap(t -> new Extractor.BuySellEntryItem((BuySellEntry)t)));
    }

    private void addDividendTransaction() {
        PDFParser.DocumentType type1 = new PDFParser.DocumentType("Fondsaussch\u00fcttung");
        PDFParser.DocumentType type2 = new PDFParser.DocumentType("Ertragsthesaurierung");
        PDFParser.DocumentType type3 = new PDFParser.DocumentType("Dividendenabrechnung");
        this.addDocumentTyp(type1);
        this.addDocumentTyp(type2);
        this.addDocumentTyp(type3);
        PDFParser.Block block = new PDFParser.Block("^Ex-Tag.*");
        type1.addBlock(block);
        type2.addBlock(block);
        type3.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("isin", "wkn").match("Nominale *ISIN: *(?<isin>[^ ]*) *WKN: *(?<wkn>[^ ]*) .*").assign((t, v) -> t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v))).section("shares").match("STK *(?<shares>[\\.\\d]+[,\\d]*) .*").assign((t, v) -> t.setShares(this.asShares((String)v.get("shares")))).section("date", "amount", "currency").match("Zu Gunsten Konto \\d+ Valuta: (?<date>\\d+.\\d+.\\d{4}) *(?<currency>\\w{3}) *(?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("tax", "currency").optional().match("Kapitalertragsteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Kirchensteuer (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("Solidarit\u00e4tszuschlag (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).section("tax", "currency").optional().match("(US-Quellensteuer|Quellensteuer) (?<currency>\\w{3}) (?<tax>[\\d.]+,\\d{2}) -").assign((t, v) -> t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of(this.asCurrencyCode((String)v.get("currency")), this.asAmount((String)v.get("tax")))))).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addTaxAdjustmentTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Steuerausgleichsrechnung");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Seite .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAX_REFUND);
            return t;
        }).oneOf(section -> section.attributes("date").match("Unterschlei\u00dfheim, (?<date>\\d+.\\d+.\\d{4})").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))), section -> section.attributes("date").match("^(?<date>\\d+.\\d+.\\d{4})").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date"))))).section("amount", "currency").match("Erstattung *(?<currency>\\w{3}) *(?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addPreTaxTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Vorabpauschale");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("^Ex-Tag.*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.TAXES);
            return t;
        }).section("isin", "wkn", "name", "shares").match("^Nominale *ISIN: *(?<isin>[^ ]*) *WKN: *(?<wkn>[^ ]*)$").match("^STK (?<shares>[\\.\\d]+[,\\d]*) (?<name>.*)").assign((t, v) -> {
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
            t.setShares(this.asShares((String)v.get("shares")));
        }).section("amount", "currency", "date").match("Zu Lasten Konto \\d+ Valuta: (?<date>\\d+\\.\\d+\\.\\d{4}) *(?<currency>\\w{3}) *(?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
            t.setDateTime(this.asDate((String)v.get("date")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addFeesAssetManagerTransaction() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("Verg\u00fctung des Verm\u00f6gensverwalters");
        this.addDocumentTyp(type);
        PDFParser.Block block = new PDFParser.Block("Rechnung f\u00fcr .*");
        type.addBlock(block);
        block.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("currency", "amount").match("Leistungen Betr\u00e4ge \\((?<currency>\\w{3})\\).*").match("Rechnungsbetrag *(?<amount>[\\d.]+,\\d{2}).*").assign((t, v) -> {
            t.setCurrencyCode(this.asCurrencyCode((String)v.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).section("date").match("Abbuchungsdatum: (?<date>\\d+.\\d+.\\d{4})").assign((t, v) -> t.setDateTime(this.asDate((String)v.get("date")))).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    private void addPeriodenauszugTransactions() {
        PDFParser.DocumentType type = new PDFParser.DocumentType("(Perioden-Kontoauszug|Tageskontoauszug)", (context, lines) -> {
            Pattern pCurrency = Pattern.compile("(Perioden-Kontoauszug|Tageskontoauszug):[ ]+(\\w{3})-Konto");
            String[] stringArray = lines;
            int n = ((String[])lines).length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher m = pCurrency.matcher(line);
                if (m.matches()) {
                    context.put("currency", m.group(1));
                }
                ++n2;
            }
        });
        this.addDocumentTyp(type);
        PDFParser.Block depositBlock = new PDFParser.Block("(\\d+\\.\\d+\\.\\d{4}) (Lastschrift aktiv|Gutschrift) (\\d+\\.\\d+\\.\\d{4}) ([\\d.]+,\\d{2})");
        type.addBlock(depositBlock);
        depositBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DEPOSIT);
            return t;
        }).section("valuta", "amount").match("(\\d+\\.\\d+\\.\\d{4}) (Lastschrift aktiv|Gutschrift) (?<valuta>\\d+\\.\\d+\\.\\d{4}) (?<amount>[\\d.]+,\\d{2})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block removalBlock = new PDFParser.Block("(\\d+\\.\\d+\\.\\d{4}) (SEPA-Ueberweisung) (\\d+\\.\\d+\\.\\d{4}) ([\\d.]+,\\d{2}) (-)");
        type.addBlock(removalBlock);
        removalBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.REMOVAL);
            return t;
        }).section("valuta", "amount").match("(\\d+\\.\\d+\\.\\d{4}) (SEPA-Ueberweisung) (?<valuta>\\d+\\.\\d+\\.\\d{4}) (?<amount>[\\d.]+,\\d{2}) (-)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block feesBlock = new PDFParser.Block("(\\d+\\.\\d+\\.\\d{4}) (Lastschrift aktiv|Transaktionskostenpauschale o. MwSt.) (?<valuta>\\d+\\.\\d+\\.\\d{4}) (?<amount>[\\d.]+,\\d{2}) (-)");
        type.addBlock(feesBlock);
        feesBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.FEES);
            return t;
        }).section("valuta", "amount").match("(\\d+\\.\\d+\\.\\d{4}) (Lastschrift aktiv|Transaktionskostenpauschale o. MwSt.) (?<valuta>\\d+\\.\\d+\\.\\d{4}) (?<amount>[\\d.]+,\\d{2}) (-)").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setDateTime(this.asDate((String)v.get("valuta")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
        PDFParser.Block buyBlock = new PDFParser.Block("(\\d+.\\d+.\\d{4}+) (Kauf) (\\d+.\\d+.\\d{4}+).*");
        type.addBlock(buyBlock);
        buyBlock.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.BUY);
            return entry;
        }).section("isin", "name").match("(\\d+.\\d+.\\d{4}+) (Kauf) (\\d+.\\d+.\\d{4}+).*").match("^(?<name>.*)$").match("^ISIN (?<isin>.{12})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "date", "shares").match("(?<date>\\d+.\\d+.\\d{4}+) (Kauf) (\\d+.\\d+.\\d{4}+) (?<amount>[\\d.,]+).*").match("^(.*)$").match("^ISIN .{12}").match("^STK *(?<shares>[\\d.,]+).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.BuySellEntryItem::new));
        PDFParser.Block sellBlock = new PDFParser.Block("(\\d+.\\d+.\\d{4}+) (Verkauf) (\\d+.\\d+.\\d{4}+).*");
        type.addBlock(sellBlock);
        sellBlock.set(new PDFParser.Transaction<BuySellEntry>().subject(() -> {
            BuySellEntry entry = new BuySellEntry();
            entry.setType(PortfolioTransaction.Type.SELL);
            return entry;
        }).section("isin", "name").match("(\\d+.\\d+.\\d{4}+) (Verkauf) (\\d+.\\d+.\\d{4}+).*").match("^(?<name>.*)$").match("^ISIN (?<isin>.{12})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "date", "shares").match("(?<date>\\d+.\\d+.\\d{4}+) (Verkauf) (\\d+.\\d+.\\d{4}+) (?<amount>[\\d.,]+).*").match("^(.*)$").match("^ISIN .{12}").match("^STK *(?<shares>[\\d.,]+).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setDate(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(Extractor.BuySellEntryItem::new));
        PDFParser.Block dividendBlock = new PDFParser.Block("(\\d+.\\d+.\\d{4}+) (Coupons/Dividende) (\\d+.\\d+.\\d{4}+).*");
        type.addBlock(dividendBlock);
        dividendBlock.set(new PDFParser.Transaction<AccountTransaction>().subject(() -> {
            AccountTransaction t = new AccountTransaction();
            t.setType(AccountTransaction.Type.DIVIDENDS);
            return t;
        }).section("isin", "name").match("(\\d+.\\d+.\\d{4}+) (Coupons/Dividende) (\\d+.\\d+.\\d{4}+).*").match("^(?<name>.*)$").match("^(ISIN )*(?<isin>.{12})").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            v.put("currency", context.get("currency"));
            t.setSecurity(this.getOrCreateSecurity((Map<String, String>)v));
        }).section("amount", "date", "shares").match("(\\d+.\\d+.\\d{4}+) (Coupons/Dividende) (?<date>\\d+.\\d+.\\d{4}+) (?<amount>[\\d.,]+).*").match("^(.*)$").match("^(.*)$").match("^STK *(?<shares>[\\d.,]+).*").assign((t, v) -> {
            Map<String, String> context = type.getCurrentContext();
            t.setDateTime(this.asDate((String)v.get("date")));
            t.setShares(this.asShares((String)v.get("shares")));
            t.setCurrencyCode(this.asCurrencyCode(context.get("currency")));
            t.setAmount(this.asAmount((String)v.get("amount")));
        }).wrap(t -> new Extractor.TransactionItem((AccountTransaction)t)));
    }

    @Override
    public String getLabel() {
        return "Baader Bank / Scalable Capital";
    }
}

