/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.actions;

import java.text.MessageFormat;
import java.util.EnumSet;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.money.Values;

public class CheckSecurityRelatedValuesAction
implements ImportAction {
    @Override
    public ImportAction.Status process(AccountTransaction transaction, Account account) {
        boolean hasSecurity = transaction.getSecurity() != null;
        EnumSet<AccountTransaction.Type> typesWithOptionalSecurity = EnumSet.of(AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND);
        if (hasSecurity && !typesWithOptionalSecurity.contains((Object)transaction.getType())) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckTransactionTypeCannotHaveASecurity, new Object[]{transaction.getType(), transaction.getSecurity().getName()}));
        }
        if (!hasSecurity && transaction.getType() == AccountTransaction.Type.DIVIDENDS) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, Messages.MsgCheckDividendsMustHaveASecurity);
        }
        if (!(transaction.getShares() == 0L || hasSecurity && typesWithOptionalSecurity.contains((Object)transaction.getType()))) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckTransactionTypeCannotHaveShares, new Object[]{transaction.getType(), Values.Share.format(transaction.getShares())}));
        }
        return ImportAction.Status.OK_STATUS;
    }
}

