/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.datatransfer.actions;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;

public class CheckCurrenciesAction
implements ImportAction {
    private static final Set<AccountTransaction.Type> TRANSACTIONS_WO_UNITS = EnumSet.of(AccountTransaction.Type.BUY, AccountTransaction.Type.SELL, AccountTransaction.Type.TRANSFER_IN);

    @Override
    public ImportAction.Status process(Security security) {
        String currency = security.getCurrencyCode();
        CurrencyUnit unit = CurrencyUnit.getInstance(currency);
        return unit != null ? ImportAction.Status.OK_STATUS : new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckUnsupportedCurrency, currency));
    }

    @Override
    public ImportAction.Status process(AccountTransaction transaction, Account account) {
        if (!account.getCurrencyCode().equals(transaction.getCurrencyCode())) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckTransactionCurrencyDoesNotMatchAccount, transaction.getCurrencyCode(), account.getCurrencyCode()));
        }
        if (transaction.getSecurity() != null) {
            if (TRANSACTIONS_WO_UNITS.contains((Object)transaction.getType())) {
                if (transaction.getUnits().findAny().isPresent()) {
                    return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckTransactionMustNotHaveGrossAmount, new Object[]{transaction.getType()}));
                }
            } else {
                ImportAction.Status status = this.checkGrossValueAndUnitsAgainstSecurity(transaction);
                if (status.getCode() != ImportAction.Status.Code.OK) {
                    return status;
                }
            }
        }
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(PortfolioTransaction transaction, Portfolio portfolio) {
        Security security = transaction.getSecurity();
        if (security == null) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckMissingSecurity, transaction.getType().toString()));
        }
        ImportAction.Status status = this.checkGrossValueAndUnitsAgainstSecurity(transaction);
        if (status.getCode() != ImportAction.Status.Code.OK) {
            return status;
        }
        if (transaction.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND || transaction.getType() == PortfolioTransaction.Type.BUY) {
            Money taxAndFees = transaction.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.TAX || u.getType() == Transaction.Unit.Type.FEE).map(Transaction.Unit::getAmount).collect(MoneyCollectors.sum(transaction.getCurrencyCode()));
            if (!transaction.getMonetaryAmount().isGreaterOrEqualThan(taxAndFees)) {
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckTaxAndFeesTooHigh, Values.Money.format(transaction.getMonetaryAmount()), Values.Money.format(taxAndFees)));
            }
        }
        return ImportAction.Status.OK_STATUS;
    }

    @Override
    public ImportAction.Status process(BuySellEntry entry, Account account, Portfolio portfolio) {
        AccountTransaction t = entry.getAccountTransaction();
        ImportAction.Status status = this.process(t, account);
        if (status.getCode() != ImportAction.Status.Code.OK) {
            return status;
        }
        return this.process(entry.getPortfolioTransaction(), portfolio);
    }

    @Override
    public ImportAction.Status process(AccountTransferEntry entry, Account source, Account target) {
        AccountTransaction t = entry.getSourceTransaction();
        ImportAction.Status status = this.process(t, source);
        if (status.getCode() != ImportAction.Status.Code.OK) {
            return status;
        }
        return this.process(entry.getTargetTransaction(), target);
    }

    @Override
    public ImportAction.Status process(PortfolioTransferEntry entry, Portfolio source, Portfolio target) {
        PortfolioTransaction t = entry.getSourceTransaction();
        ImportAction.Status status = this.process(t, source);
        if (status.getCode() != ImportAction.Status.Code.OK) {
            return status;
        }
        return this.process(entry.getTargetTransaction(), target);
    }

    private ImportAction.Status checkGrossValueAndUnitsAgainstSecurity(Transaction transaction) {
        String securityCurrency = transaction.getSecurity().getCurrencyCode();
        if (securityCurrency == null) {
            return new ImportAction.Status(ImportAction.Status.Code.ERROR, Messages.MsgCheckSecurityWithoutCurrency);
        }
        if (transaction.getCurrencyCode().equals(securityCurrency)) {
            Optional<Transaction.Unit> grossValue = transaction.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            if (grossValue.isPresent()) {
                String grossValueCurrencyCode = grossValue.get().getForex() != null ? grossValue.get().getForex().getCurrencyCode() : "";
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckGrossValueUnitNotValid, grossValueCurrencyCode, securityCurrency));
            }
            Optional<Transaction.Unit> unit = transaction.getUnits().filter(u -> u.getForex() != null).findAny();
            if (unit.isPresent()) {
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckUnitForexNotValid, Values.Money.format(unit.get().getForex())));
            }
        } else {
            String forex;
            Optional<Transaction.Unit> grossValue = transaction.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            if (!grossValue.isPresent()) {
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckGrossValueUnitMissing, transaction.getCurrencyCode(), securityCurrency));
            }
            String string = forex = grossValue.get().getForex() != null ? grossValue.get().getForex().getCurrencyCode() : null;
            if (!securityCurrency.equals(forex)) {
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckGrossValueUnitForexMismatch, forex, securityCurrency));
            }
            Optional<Transaction.Unit> unit = transaction.getUnits().filter(u -> u.getForex() != null).filter(u -> !u.getForex().getCurrencyCode().equals(securityCurrency)).findAny();
            if (unit.isPresent()) {
                return new ImportAction.Status(ImportAction.Status.Code.ERROR, MessageFormat.format(Messages.MsgCheckUnitForexMismatch, Values.Money.format(unit.get().getForex()), securityCurrency));
            }
        }
        return ImportAction.Status.OK_STATUS;
    }
}

