/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyUnit;

public class TransactionCurrencyCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        HashSet transactions = new HashSet();
        for (Account account : client.getAccounts()) {
            account.getTransactions().stream().filter(t -> t.getCurrencyCode() == null).forEach(t -> {
                boolean bl = transactions.add(t.getCrossEntry() != null ? t.getCrossEntry() : new TransactionPair<AccountTransaction>(account, (AccountTransaction)t));
            });
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            portfolio.getTransactions().stream().filter(t -> t.getCurrencyCode() == null).forEach(t -> {
                boolean bl = transactions.add(t.getCrossEntry() != null ? t.getCrossEntry() : new TransactionPair<PortfolioTransaction>(portfolio, (PortfolioTransaction)t));
            });
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Object t2 : transactions) {
            TransactionPair<Transaction> pair;
            CrossEntry entry;
            if (t2 instanceof TransactionPair) {
                TransactionPair pair2 = (TransactionPair)t2;
                issues.add(new TransactionMissingCurrencyIssue(client, pair2));
                continue;
            }
            if (t2 instanceof BuySellEntry) {
                entry = (BuySellEntry)t2;
                String accountCurrency = ((BuySellEntry)entry).getAccount().getCurrencyCode();
                String securityCurrency = ((BuySellEntry)entry).getPortfolioTransaction().getSecurity().getCurrencyCode();
                pair = new TransactionPair<Transaction>(((BuySellEntry)entry).getOwner(((BuySellEntry)entry).getAccountTransaction()), ((BuySellEntry)entry).getAccountTransaction());
                issues.add(new TransactionMissingCurrencyIssue(client, pair, Objects.equals(accountCurrency, securityCurrency)));
                continue;
            }
            if (t2 instanceof AccountTransferEntry) {
                entry = (AccountTransferEntry)t2;
                String sourceCurrency = ((AccountTransferEntry)entry).getSourceAccount().getCurrencyCode();
                String targetCurrency = ((AccountTransferEntry)entry).getTargetAccount().getCurrencyCode();
                pair = new TransactionPair<AccountTransaction>(((AccountTransferEntry)entry).getOwner(((AccountTransferEntry)entry).getSourceTransaction()), ((AccountTransferEntry)entry).getSourceTransaction());
                issues.add(new TransactionMissingCurrencyIssue(client, pair, Objects.equals(sourceCurrency, targetCurrency)));
                continue;
            }
            if (t2 instanceof PortfolioTransferEntry) {
                entry = (PortfolioTransferEntry)t2;
                TransactionPair<Transaction> pair3 = new TransactionPair<Transaction>(((PortfolioTransferEntry)entry).getOwner(((PortfolioTransferEntry)entry).getSourceTransaction()), ((PortfolioTransferEntry)entry).getSourceTransaction());
                issues.add(new TransactionMissingCurrencyIssue(client, pair3));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return issues;
    }

    public static class TransactionCurrencyQuickFix
    implements QuickFix {
        private TransactionPair<?> pair;
        private String currencyCode;

        public TransactionCurrencyQuickFix(Client client, TransactionPair<?> pair) {
            this.pair = pair;
            this.currencyCode = pair.getOwner() instanceof Account ? ((Account)pair.getOwner()).getCurrencyCode() : (pair.getOwner() instanceof Portfolio ? ((PortfolioTransaction)pair.getTransaction()).getSecurity().getCurrencyCode() : client.getBaseCurrency());
        }

        @Override
        public String getLabel() {
            return CurrencyUnit.getInstance(this.currencyCode).getLabel();
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixAssignCurrencyCodeDone, this.currencyCode);
        }

        @Override
        public void execute() {
            ((Transaction)this.pair.getTransaction()).setCurrencyCode(this.currencyCode);
            if (((Transaction)this.pair.getTransaction()).getCrossEntry() != null) {
                ((Transaction)this.pair.getTransaction()).getCrossEntry().getCrossTransaction((Transaction)this.pair.getTransaction()).setCurrencyCode(this.currencyCode);
            }
        }
    }

    private static class TransactionMissingCurrencyIssue
    implements Issue {
        private Client client;
        private TransactionPair<Transaction> pair;
        private boolean isFixable;

        public TransactionMissingCurrencyIssue(Client client, TransactionPair<Transaction> pair) {
            this(client, pair, true);
        }

        public TransactionMissingCurrencyIssue(Client client, TransactionPair<Transaction> pair, boolean isFixable) {
            this.client = client;
            this.pair = pair;
            this.isFixable = isFixable;
        }

        @Override
        public LocalDate getDate() {
            return this.pair.getTransaction().getDateTime().toLocalDate();
        }

        @Override
        public Object getEntity() {
            return this.pair.getOwner();
        }

        @Override
        public Long getAmount() {
            return this.pair.getTransaction().getAmount();
        }

        @Override
        public String getLabel() {
            String type = this.pair.getTransaction() instanceof AccountTransaction ? ((AccountTransaction)this.pair.getTransaction()).getType().toString() : ((PortfolioTransaction)this.pair.getTransaction()).getType().toString();
            return MessageFormat.format(Messages.IssueTransactionMissingCurrencyCode, type);
        }

        @Override
        public List<QuickFix> getAvailableFixes() {
            ArrayList<QuickFix> fixes = new ArrayList<QuickFix>();
            fixes.add(new DeleteTransactionFix<Transaction>(this.client, this.pair.getOwner(), this.pair.getTransaction()));
            if (this.isFixable) {
                fixes.add(new TransactionCurrencyQuickFix(this.client, this.pair));
            }
            return fixes;
        }
    }
}

