/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyUnit;

public class MissingCurrencyCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        boolean hasCurrencyMissing = false;
        for (Account account : client.getAccounts()) {
            if (account.getCurrencyCode() != null) continue;
            hasCurrencyMissing = true;
        }
        if (!hasCurrencyMissing) {
            for (Security security : client.getSecurities()) {
                if (security.getCurrencyCode() != null || !security.hasTransactions(client)) continue;
                hasCurrencyMissing = true;
            }
        }
        if (hasCurrencyMissing) {
            MissingCurrencyIssue issue = new MissingCurrencyIssue(client);
            return Arrays.asList(issue);
        }
        return Collections.emptyList();
    }

    public class CurrencyQuickFix
    implements QuickFix {
        private Client client;
        private CurrencyUnit currency;

        public CurrencyQuickFix(Client client, CurrencyUnit currency) {
            if (currency == null) {
                throw new NullPointerException();
            }
            this.client = client;
            this.currency = currency;
        }

        @Override
        public String getLabel() {
            return this.currency.getLabel();
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixAssignCurrencyCodeDone, this.currency.getDisplayName());
        }

        @Override
        public void execute() {
            for (Account account : this.client.getAccounts()) {
                if (account.getCurrencyCode() != null) continue;
                account.setCurrencyCode(this.currency.getCurrencyCode());
            }
            for (Security security : this.client.getSecurities()) {
                if (security.getCurrencyCode() != null || !security.hasTransactions(this.client)) continue;
                security.setCurrencyCode(this.currency.getCurrencyCode());
            }
        }
    }

    private final class MissingCurrencyIssue
    implements Issue {
        private Client client;

        public MissingCurrencyIssue(Client client) {
            this.client = client;
        }

        @Override
        public LocalDate getDate() {
            return null;
        }

        @Override
        public Object getEntity() {
            return this.client;
        }

        @Override
        public Long getAmount() {
            return null;
        }

        @Override
        public String getLabel() {
            return Messages.IssueMissingCurrencyCode;
        }

        @Override
        public List<QuickFix> getAvailableFixes() {
            ArrayList<QuickFix> fixes = new ArrayList<QuickFix>();
            fixes.add(new CurrencyQuickFix(this.client, CurrencyUnit.getInstance("EUR")));
            fixes.add(new CurrencyQuickFix(this.client, CurrencyUnit.getInstance("CHF")));
            fixes.add(new CurrencyQuickFix(this.client, CurrencyUnit.getInstance("USD")));
            fixes.add(QuickFix.SEPARATOR);
            List<CurrencyUnit> available = CurrencyUnit.getAvailableCurrencyUnits();
            Collections.sort(available);
            for (CurrencyUnit currency : available) {
                fixes.add(new CurrencyQuickFix(this.client, currency));
            }
            return fixes;
        }
    }
}

