/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.checks.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.checks.Check;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.checks.impl.AbstractAccountIssue;
import name.abuchen.portfolio.checks.impl.DeleteTransactionFix;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;

public class DividendsAndInterestCheck
implements Check {
    @Override
    public List<Issue> execute(Client client) {
        ArrayList<Issue> answer = new ArrayList<Issue>();
        for (Account account : client.getAccounts()) {
            for (AccountTransaction transaction : account.getTransactions()) {
                if (transaction.getType() == AccountTransaction.Type.DIVIDENDS && transaction.getSecurity() == null) {
                    answer.add(new DividendsAndInterestIssue(client, account, transaction, AccountTransaction.Type.INTEREST));
                    continue;
                }
                if (transaction.getType() != AccountTransaction.Type.INTEREST || transaction.getSecurity() == null) continue;
                answer.add(new DividendsAndInterestIssue(client, account, transaction, AccountTransaction.Type.DIVIDENDS));
            }
        }
        return answer;
    }

    private static final class ConvertFix
    implements QuickFix {
        private AccountTransaction transaction;
        private AccountTransaction.Type target;

        public ConvertFix(AccountTransaction transaction, AccountTransaction.Type target) {
            this.transaction = transaction;
            this.target = target;
        }

        @Override
        public String getLabel() {
            return MessageFormat.format(Messages.FixConvertToType, new Object[]{this.target});
        }

        @Override
        public void execute() {
            this.transaction.setType(this.target);
        }

        @Override
        public String getDoneLabel() {
            return MessageFormat.format(Messages.FixConvertToTypeDone, new Object[]{this.target});
        }
    }

    private static final class DividendsAndInterestIssue
    extends AbstractAccountIssue {
        private AccountTransaction.Type target;

        public DividendsAndInterestIssue(Client client, Account account, AccountTransaction transaction, AccountTransaction.Type target) {
            super(client, account, transaction);
            this.target = target;
        }

        @Override
        public String getLabel() {
            if (this.target == AccountTransaction.Type.INTEREST) {
                return Messages.IssueDividendWithoutSecurity;
            }
            return MessageFormat.format(Messages.IssueInterestWithSecurity, this.transaction.getSecurity().getName());
        }

        @Override
        public List<QuickFix> getAvailableFixes() {
            ArrayList<QuickFix> answer = new ArrayList<QuickFix>();
            answer.add(new ConvertFix(this.transaction, this.target));
            answer.add(new DeleteTransactionFix<AccountTransaction>(this.client, this.account, this.transaction));
            return answer;
        }
    }
}

