/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.internal.workbench.swt.IEventLoopAdvisor;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class LifeCycleManager {
    private static final String MODEL_VERSION = "model.version";
    @Inject
    @Preference(nodePath="name.abuchen.portfolio.bootstrap")
    IEclipsePreferences preferences;
    @Inject
    Logger logger;

    @PostContextCreate
    public void doPostContextCreate(IEclipseContext context) {
        this.checkForModelChanges();
        this.checkForRequestToClearPersistedState();
        this.setupEventLoopAdvisor(context);
    }

    private void checkForModelChanges() {
        Version programVersion;
        Version modelVersion = Version.parseVersion((String)this.preferences.get(MODEL_VERSION, null));
        if (!modelVersion.equals((Object)(programVersion = FrameworkUtil.getBundle(this.getClass()).getVersion()))) {
            this.logger.info(MessageFormat.format("Detected model change from version {0} to version {1}; clearing persisted state", modelVersion, programVersion));
            System.setProperty("clearPersistedState", Boolean.TRUE.toString());
        }
    }

    private void checkForRequestToClearPersistedState() {
        boolean forceClearPersistedState = Boolean.parseBoolean(this.preferences.get("model.forceClearPersistedState", Boolean.FALSE.toString()));
        if (forceClearPersistedState) {
            this.logger.info(MessageFormat.format("Clearing persisted state due to ''{0}=true''", "model.forceClearPersistedState"));
            System.setProperty("clearPersistedState", Boolean.TRUE.toString());
            System.setProperty("model.forceClearPersistedState", Boolean.TRUE.toString());
            try {
                this.preferences.remove("model.forceClearPersistedState");
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    public void setupEventLoopAdvisor(final IEclipseContext context) {
        context.set(IEventLoopAdvisor.class, (Object)new IEventLoopAdvisor(){

            public void eventLoopIdle(Display display) {
                display.sleep();
            }

            public void eventLoopException(Throwable exception) {
                boolean isAnnoyingNullPointerOnElCapitan = this.isAnnoyingNullPointerOnElCapitan(exception);
                StatusReporter statusReporter = (StatusReporter)context.get(StatusReporter.class.getName());
                if (!isAnnoyingNullPointerOnElCapitan && statusReporter != null) {
                    statusReporter.show(4, "Internal Error", exception, new Object[0]);
                } else if (LifeCycleManager.this.logger != null) {
                    LifeCycleManager.this.logger.error(exception);
                } else {
                    exception.printStackTrace();
                }
            }

            private boolean isAnnoyingNullPointerOnElCapitan(Throwable exception) {
                if (!(exception instanceof NullPointerException)) {
                    return false;
                }
                StackTraceElement[] stackTrace = exception.getStackTrace();
                if (stackTrace == null || stackTrace.length == 0) {
                    return true;
                }
                if (!"org.eclipse.swt.widgets.Control".equals(stackTrace[0].getClassName())) {
                    return false;
                }
                return "internal_new_GC".equals(stackTrace[0].getMethodName());
            }
        });
    }

    @ProcessRemovals
    public void removeDnDAddon(MApplication app) {
        for (MAddon addon : new ArrayList(app.getAddons())) {
            String contributionURI = addon.getContributionURI();
            if (!contributionURI.contains("ui.workbench.addons.minmax.MinMaxAddon") && !contributionURI.contains("ui.workbench.addons.splitteraddon.SplitterAddon")) continue;
            app.getAddons().remove(addon);
        }
    }

    @PreSave
    public void doPreSave(MApplication app, EModelService modelService, IModelResourceHandler handler) {
        this.saveModelVersion();
        this.removePortfolioPartsWithoutPersistedFile(app, modelService);
        this.saveCopyOfApplicationModel(app, handler);
    }

    private void saveModelVersion() {
        String programVersion;
        String modelVersion = this.preferences.get(MODEL_VERSION, Version.emptyVersion.toString());
        if (!modelVersion.equals(programVersion = FrameworkUtil.getBundle(this.getClass()).getVersion().toString())) {
            try {
                this.preferences.put(MODEL_VERSION, programVersion);
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private void removePortfolioPartsWithoutPersistedFile(MApplication app, EModelService modelService) {
        MElementContainer parent;
        List parts = modelService.findElements((MApplicationElement)app, MPart.class, 2, element -> {
            if (!"name.abuchen.portfolio.ui.part.portfolio".equals(element.getElementId())) {
                return false;
            }
            return element.getPersistedState().get("file") == null;
        });
        HashSet<MElementContainer> parentsWithRemovedChildren = new HashSet<MElementContainer>();
        for (MPart part : parts) {
            if (part.equals((parent = part.getParent()).getSelectedElement())) {
                parent.setSelectedElement(null);
            }
            parent.getChildren().remove(part);
            parentsWithRemovedChildren.add(parent);
        }
        for (MElementContainer container : parentsWithRemovedChildren) {
            if (modelService.isLastEditorStack((MUIElement)container)) break;
            if (!container.getChildren().isEmpty()) continue;
            parent = container.getParent();
            if (parent != null) {
                container.setToBeRendered(false);
                if (container.equals(parent.getSelectedElement())) {
                    parent.setSelectedElement(null);
                }
                parent.getChildren().remove(container);
                continue;
            }
            if (!(container instanceof MWindow)) continue;
            MUIElement eParent = (MUIElement)((EObject)container).eContainer();
            if (eParent instanceof MPerspective) {
                ((MPerspective)eParent).getWindows().remove(container);
                continue;
            }
            if (!(eParent instanceof MWindow)) continue;
            ((MWindow)eParent).getWindows().remove(container);
        }
    }

    private void saveCopyOfApplicationModel(MApplication app, IModelResourceHandler handler) {
        try {
            MApplication appCopy = (MApplication)EcoreUtil.copy((EObject)((EObject)app));
            Resource resource = handler.createResourceWithApp(appCopy);
            File file = new File(Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(LifeCycleManager.class)).toFile(), "copy.e4xmi");
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                    resource.save((OutputStream)out, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
            resource.unload();
            resource.getResourceSet().getResources().remove((Object)resource);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Throwable)e);
        }
    }
}

