// Copyright 2007 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview This data is generated from an SVG image of a tiger.
 *
 * @author arv@google.com (Erik Arvidsson)
 */


var tigerData = [{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [77.696, 284.285]},
 {t: 'C', p: [77.696, 284.285, 77.797, 286.179, 76.973, 286.16]},
 {t: 'C', p: [76.149, 286.141, 59.695, 238.066, 39.167, 240.309]},
 {t: 'C', p: [39.167, 240.309, 56.95, 232.956, 77.696, 284.285]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [81.226, 281.262]},
 {t: 'C', p: [81.226, 281.262, 80.677, 283.078, 79.908, 282.779]},
 {t: 'C', p: [79.14, 282.481, 80.023, 231.675, 59.957, 226.801]},
 {t: 'C', p: [59.957, 226.801, 79.18, 225.937, 81.226, 281.262]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [108.716, 323.59]},
 {t: 'C', p: [108.716, 323.59, 110.352, 324.55, 109.882, 325.227]},
 {t: 'C', p: [109.411, 325.904, 60.237, 313.102, 50.782, 331.459]},
 {t: 'C', p: [50.782, 331.459, 54.461, 312.572, 108.716, 323.59]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [105.907, 333.801]},
 {t: 'C', p: [105.907, 333.801, 107.763, 334.197, 107.529, 334.988]},
 {t: 'C', p: [107.296, 335.779, 56.593, 339.121, 53.403, 359.522]},
 {t: 'C', p: [53.403, 359.522, 50.945, 340.437, 105.907, 333.801]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [101.696, 328.276]},
 {t: 'C', p: [101.696, 328.276, 103.474, 328.939, 103.128, 329.687]},
 {t: 'C', p: [102.782, 330.435, 52.134, 326.346, 46.002, 346.064]},
 {t: 'C', p: [46.002, 346.064, 46.354, 326.825, 101.696, 328.276]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [90.991, 310.072]},
 {t: 'C', p: [90.991, 310.072, 92.299, 311.446, 91.66, 311.967]},
 {t: 'C', p: [91.021, 312.488, 47.278, 286.634, 33.131, 301.676]},
 {t: 'C', p: [33.131, 301.676, 41.872, 284.533, 90.991, 310.072]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [83.446, 314.263]},
 {t: 'C', p: [83.446, 314.263, 84.902, 315.48, 84.326, 316.071]},
 {t: 'C', p: [83.75, 316.661, 37.362, 295.922, 25.008, 312.469]},
 {t: 'C', p: [25.008, 312.469, 31.753, 294.447, 83.446, 314.263]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [80.846, 318.335]},
 {t: 'C', p: [80.846, 318.335, 82.454, 319.343, 81.964, 320.006]},
 {t: 'C', p: [81.474, 320.669, 32.692, 306.446, 22.709, 324.522]},
 {t: 'C', p: [22.709, 324.522, 26.934, 305.749, 80.846, 318.335]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [91.58, 318.949]},
 {t: 'C', p: [91.58, 318.949, 92.702, 320.48, 92.001, 320.915]},
 {t: 'C', p: [91.3, 321.35, 51.231, 290.102, 35.273, 303.207]},
 {t: 'C', p: [35.273, 303.207, 46.138, 287.326, 91.58, 318.949]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [71.8, 290]},
 {t: 'C', p: [71.8, 290, 72.4, 291.8, 71.6, 292]},
 {t: 'C', p: [70.8, 292.2, 42.2, 250.2, 22.999, 257.8]},
 {t: 'C', p: [22.999, 257.8, 38.2, 246, 71.8, 290]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [72.495, 296.979]},
 {t: 'C', p: [72.495, 296.979, 73.47, 298.608, 72.731, 298.975]},
 {t: 'C', p: [71.993, 299.343, 35.008, 264.499, 17.899, 276.061]},
 {t: 'C', p: [17.899, 276.061, 30.196, 261.261, 72.495, 296.979]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.172},
 p: [{t: 'M', p: [72.38, 301.349]},
 {t: 'C', p: [72.38, 301.349, 73.502, 302.88, 72.801, 303.315]},
 {t: 'C', p: [72.1, 303.749, 32.031, 272.502, 16.073, 285.607]},
 {t: 'C', p: [16.073, 285.607, 26.938, 269.726, 72.38, 301.349]},
 {t: 'z', p: []}]},

{f: '#fff', s: '#000', p: [{t: 'M', p: [70.17, 303.065]},
 {t: 'C', p: [70.673, 309.113, 71.661, 315.682, 73.4, 318.801]},
 {t: 'C', p: [73.4, 318.801, 69.8, 331.201, 78.6, 344.401]},
 {t: 'C', p: [78.6, 344.401, 78.2, 351.601, 79.8, 354.801]},
 {t: 'C', p: [79.8, 354.801, 83.8, 363.201, 88.6, 364.001]},
 {t: 'C', p: [92.484, 364.648, 101.207, 367.717, 111.068, 369.121]},
 {t: 'C', p: [111.068, 369.121, 128.2, 383.201, 125, 396.001]},
 {t: 'C', p: [125, 396.001, 124.6, 412.401, 121, 414.001]},
 {t: 'C', p: [121, 414.001, 132.6, 402.801, 123, 419.601]},
 {t: 'L', p: [118.6, 438.401]},
 {t: 'C', p: [118.6, 438.401, 144.2, 416.801, 128.6, 435.201]},
 {t: 'L', p: [118.6, 461.201]},
 {t: 'C', p: [118.6, 461.201, 138.2, 442.801, 131, 451.201]},
 {t: 'L', p: [127.8, 460.001]},
 {t: 'C', p: [127.8, 460.001, 171, 432.801, 140.2, 462.401]},
 {t: 'C', p: [140.2, 462.401, 148.2, 458.801, 152.6, 461.601]},
 {t: 'C', p: [152.6, 461.601, 159.4, 460.401, 158.6, 462.001]},
 {t: 'C', p: [158.6, 462.001, 137.8, 472.401, 134.2, 490.801]},
 {t: 'C', p: [134.2, 490.801, 142.6, 480.801, 139.4, 491.601]},
 {t: 'L', p: [139.8, 503.201]},
 {t: 'C', p: [139.8, 503.201, 143.8, 481.601, 143.4, 519.201]},
 {t: 'C', p: [143.4, 519.201, 162.6, 501.201, 151, 522.001]},
 {t: 'L', p: [151, 538.801]},
 {t: 'C', p: [151, 538.801, 166.2, 522.401, 159.8, 535.201]},
 {t: 'C', p: [159.8, 535.201, 169.8, 526.401, 165.8, 541.601]},
 {t: 'C', p: [165.8, 541.601, 165, 552.001, 169.4, 540.801]},
 {t: 'C', p: [169.4, 540.801, 185.4, 510.201, 179.4, 536.401]},
 {t: 'C', p: [179.4, 536.401, 178.6, 555.601, 183.4, 540.801]},
 {t: 'C', p: [183.4, 540.801, 183.8, 551.201, 193, 558.401]},
 {t: 'C', p: [193, 558.401, 191.8, 507.601, 204.6, 543.601]},
 {t: 'L', p: [208.6, 560.001]},
 {t: 'C', p: [208.6, 560.001, 211.4, 550.801, 211, 545.601]},
 {t: 'C', p: [211, 545.601, 225.8, 529.201, 219, 553.601]},
 {t: 'C', p: [219, 553.601, 234.2, 530.801, 231, 544.001]},
 {t: 'C', p: [231, 544.001, 223.4, 560.001, 225, 564.801]},
 {t: 'C', p: [225, 564.801, 241.8, 530.001, 243, 528.401]},
 {t: 'C', p: [243, 528.401, 241, 570.802, 251.8, 534.801]},
 {t: 'C', p: [251.8, 534.801, 257.4, 546.801, 254.6, 551.201]},
 {t: 'C', p: [254.6, 551.201, 262.6, 543.201, 261.8, 540.001]},
 {t: 'C', p: [261.8, 540.001, 266.4, 531.801, 269.2, 545.401]},
 {t: 'C', p: [269.2, 545.401, 271, 554.801, 272.6, 551.601]},
 {t: 'C', p: [272.6, 551.601, 276.6, 575.602, 277.8, 552.801]},
 {t: 'C', p: [277.8, 552.801, 279.4, 539.201, 272.2, 527.601]},
 {t: 'C', p: [272.2, 527.601, 273, 524.401, 270.2, 520.401]},
 {t: 'C', p: [270.2, 520.401, 283.8, 542.001, 276.6, 513.201]},
 {t: 'C', p: [276.6, 513.201, 287.801, 521.201, 289.001, 521.201]},
 {t: 'C', p: [289.001, 521.201, 275.4, 498.001, 284.2, 502.801]},
 {t: 'C', p: [284.2, 502.801, 279, 492.401, 297.001, 504.401]},
 {t: 'C', p: [297.001, 504.401, 281, 488.401, 298.601, 498.001]},
 {t: 'C', p: [298.601, 498.001, 306.601, 504.401, 299.001, 494.401]},
 {t: 'C', p: [299.001, 494.401, 284.6, 478.401, 306.601, 496.401]},
 {t: 'C', p: [306.601, 496.401, 318.201, 512.801, 319.001, 515.601]},
 {t: 'C', p: [319.001, 515.601, 309.001, 486.401, 304.601, 483.601]},
 {t: 'C', p: [304.601, 483.601, 313.001, 447.201, 354.201, 462.801]},
 {t: 'C', p: [354.201, 462.801, 361.001, 480.001, 365.401, 461.601]},
 {t: 'C', p: [365.401, 461.601, 378.201, 455.201, 389.401, 482.801]},
 {t: 'C', p: [389.401, 482.801, 393.401, 469.201, 392.601, 466.401]},
 {t: 'C', p: [392.601, 466.401, 399.401, 467.601, 398.601, 466.401]},
 {t: 'C', p: [398.601, 466.401, 411.801, 470.801, 413.001, 470.001]},
 {t: 'C', p: [413.001, 470.001, 419.801, 476.801, 420.201, 473.201]},
 {t: 'C', p: [420.201, 473.201, 429.401, 476.001, 427.401, 472.401]},
 {t: 'C', p: [427.401, 472.401, 436.201, 488.001, 436.601, 491.601]},
 {t: 'L', p: [439.001, 477.601]},
 {t: 'L', p: [441.001, 480.401]},
 {t: 'C', p: [441.001, 480.401, 442.601, 472.801, 441.801, 471.601]},
 {t: 'C', p: [441.001, 470.401, 461.801, 478.401, 466.601, 499.201]},
 {t: 'L', p: [468.601, 507.601]},
 {t: 'C', p: [468.601, 507.601, 474.601, 492.801, 473.001, 488.801]},
 {t: 'C', p: [473.001, 488.801, 478.201, 489.601, 478.601, 494.001]},
 {t: 'C', p: [478.601, 494.001, 482.601, 470.801, 477.801, 464.801]},
 {t: 'C', p: [477.801, 464.801, 482.201, 464.001, 483.401, 467.601]},
 {t: 'L', p: [483.401, 460.401]},
 {t: 'C', p: [483.401, 460.401, 490.601, 461.201, 490.601, 458.801]},
 {t: 'C', p: [490.601, 458.801, 495.001, 454.801, 497.001, 459.601]},
 {t: 'C', p: [497.001, 459.601, 484.601, 424.401, 503.001, 443.601]},
 {t: 'C', p: [503.001, 443.601, 510.201, 454.401, 506.601, 435.601]},
 {t: 'C', p: [503.001, 416.801, 499.001, 415.201, 503.801, 414.801]},
 {t: 'C', p: [503.801, 414.801, 504.601, 411.201, 502.601, 409.601]},
 {t: 'C', p: [500.601, 408.001, 503.801, 409.601, 503.801, 409.601]},
 {t: 'C', p: [503.801, 409.601, 508.601, 413.601, 503.401, 391.601]},
 {t: 'C', p: [503.401, 391.601, 509.801, 393.201, 497.801, 364.001]},
 {t: 'C', p: [497.801, 364.001, 500.601, 361.601, 496.601, 353.201]},
 {t: 'C', p: [496.601, 353.201, 504.601, 357.601, 507.401, 356.001]},
 {t: 'C', p: [507.401, 356.001, 507.001, 354.401, 503.801, 350.401]},
 {t: 'C', p: [503.801, 350.401, 482.201, 295.6, 502.601, 317.601]},
 {t: 'C', p: [502.601, 317.601, 514.451, 331.151, 508.051, 308.351]},
 {t: 'C', p: [508.051, 308.351, 498.94, 284.341, 499.717, 280.045]},
 {t: 'L', p: [70.17, 303.065]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: '#000', p: [{t: 'M', p: [499.717, 280.245]},
 {t: 'C', p: [500.345, 280.426, 502.551, 281.55, 503.801, 283.2]},
 {t: 'C', p: [503.801, 283.2, 510.601, 294, 505.401, 275.6]},
 {t: 'C', p: [505.401, 275.6, 496.201, 246.8, 505.001, 258]},
 {t: 'C', p: [505.001, 258, 511.001, 265.2, 507.801, 251.6]},
 {t: 'C', p: [503.936, 235.173, 501.401, 228.8, 501.401, 228.8]},
 {t: 'C', p: [501.401, 228.8, 513.001, 233.6, 486.201, 194]},
 {t: 'L', p: [495.001, 197.6]},
 {t: 'C', p: [495.001, 197.6, 475.401, 158, 453.801, 152.8]},
 {t: 'L', p: [445.801, 146.8]},
 {t: 'C', p: [445.801, 146.8, 484.201, 108.8, 471.401, 72]},
 {t: 'C', p: [471.401, 72, 464.601, 66.8, 455.001, 76]},
 {t: 'C', p: [455.001, 76, 448.601, 80.8, 442.601, 79.2]},
 {t: 'C', p: [442.601, 79.2, 411.801, 80.4, 409.801, 80.4]},
 {t: 'C', p: [407.801, 80.4, 373.001, 43.2, 307.401, 60.8]},
 {t: 'C', p: [307.401, 60.8, 302.201, 62.8, 297.801, 61.6]},
 {t: 'C', p: [297.801, 61.6, 279.4, 45.6, 230.6, 68.4]},
 {t: 'C', p: [230.6, 68.4, 220.6, 70.4, 219, 70.4]},
 {t: 'C', p: [217.4, 70.4, 214.6, 70.4, 206.6, 76.8]},
 {t: 'C', p: [198.6, 83.2, 198.2, 84, 196.2, 85.6]},
 {t: 'C', p: [196.2, 85.6, 179.8, 96.8, 175, 97.6]},
 {t: 'C', p: [175, 97.6, 163.4, 104, 159, 114]},
 {t: 'L', p: [155.4, 115.2]},
 {t: 'C', p: [155.4, 115.2, 153.8, 122.4, 153.4, 123.6]},
 {t: 'C', p: [153.4, 123.6, 148.6, 127.2, 147.8, 132.8]},
 {t: 'C', p: [147.8, 132.8, 139, 138.8, 139.4, 143.2]},
 {t: 'C', p: [139.4, 143.2, 137.8, 148.4, 137, 153.2]},
 {t: 'C', p: [137, 153.2, 129.8, 158, 130.6, 160.8]},
 {t: 'C', p: [130.6, 160.8, 123, 174.8, 124.2, 181.6]},
 {t: 'C', p: [124.2, 181.6, 117.8, 181.2, 115, 183.6]},
 {t: 'C', p: [115, 183.6, 114.2, 188.4, 112.6, 188.8]},
 {t: 'C', p: [112.6, 188.8, 109.8, 190, 112.2, 194]},
 {t: 'C', p: [112.2, 194, 110.6, 196.8, 110.2, 198.4]},
 {t: 'C', p: [110.2, 198.4, 111, 201.2, 106.6, 206.8]},
 {t: 'C', p: [106.6, 206.8, 100.2, 225.6, 102.2, 230.8]},
 {t: 'C', p: [102.2, 230.8, 102.6, 235.6, 99.8, 237.2]},
 {t: 'C', p: [99.8, 237.2, 96.2, 236.8, 104.6, 248.8]},
 {t: 'C', p: [104.6, 248.8, 105.4, 250, 102.2, 252.4]},
 {t: 'C', p: [102.2, 252.4, 85, 256, 82.6, 272.4]},
 {t: 'C', p: [82.6, 272.4, 69, 287.2, 69, 292.4]},
 {t: 'C', p: [69, 294.705, 69.271, 297.852, 69.97, 302.465]},
 {t: 'C', p: [69.97, 302.465, 69.4, 310.801, 97, 311.601]},
 {t: 'C', p: [124.6, 312.401, 499.717, 280.245, 499.717, 280.245]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [84.4, 302.6]},
 {t: 'C', p: [59.4, 263.2, 73.8, 319.601, 73.8, 319.601]},
 {t: 'C', p: [82.6, 354.001, 212.2, 316.401, 212.2, 316.401]},
 {t: 'C', p: [212.2, 316.401, 381.001, 286, 392.201, 282]},
 {t: 'C', p: [403.401, 278, 498.601, 284.4, 498.601, 284.4]},
 {t: 'L', p: [493.001, 267.6]},
 {t: 'C', p: [428.201, 221.2, 409.001, 244.4, 395.401, 240.4]},
 {t: 'C', p: [381.801, 236.4, 384.201, 246, 381.001, 246.8]},
 {t: 'C', p: [377.801, 247.6, 338.601, 222.8, 332.201, 223.6]},
 {t: 'C', p: [325.801, 224.4, 300.459, 200.649, 315.401, 232.4]},
 {t: 'C', p: [331.401, 266.4, 257, 271.6, 240.2, 260.4]},
 {t: 'C', p: [223.4, 249.2, 247.4, 278.8, 247.4, 278.8]},
 {t: 'C', p: [265.8, 298.8, 231.4, 282, 231.4, 282]},
 {t: 'C', p: [197, 269.2, 173, 294.8, 169.8, 295.6]},
 {t: 'C', p: [166.6, 296.4, 161.8, 299.6, 161, 293.2]},
 {t: 'C', p: [160.2, 286.8, 152.69, 270.099, 121, 296.4]},
 {t: 'C', p: [101, 313.001, 87.2, 291, 87.2, 291]},
 {t: 'L', p: [84.4, 302.6]},
 {t: 'z', p: []}]},

{f: '#e87f3a', s: null, p: [{t: 'M', p: [333.51, 225.346]},
 {t: 'C', p: [327.11, 226.146, 301.743, 202.407, 316.71, 234.146]},
 {t: 'C', p: [333.31, 269.346, 258.31, 273.346, 241.51, 262.146]},
 {t: 'C', p: [224.709, 250.946, 248.71, 280.546, 248.71, 280.546]},
 {t: 'C', p: [267.11, 300.546, 232.709, 283.746, 232.709, 283.746]},
 {t: 'C', p: [198.309, 270.946, 174.309, 296.546, 171.109, 297.346]},
 {t: 'C', p: [167.909, 298.146, 163.109, 301.346, 162.309, 294.946]},
 {t: 'C', p: [161.509, 288.546, 154.13, 272.012, 122.309, 298.146]},
 {t: 'C', p: [101.073, 315.492, 87.582, 294.037, 87.582, 294.037]},
 {t: 'L', p: [84.382, 304.146]},
 {t: 'C', p: [59.382, 264.346, 74.454, 322.655, 74.454, 322.655]},
 {t: 'C', p: [83.255, 357.056, 213.509, 318.146, 213.509, 318.146]},
 {t: 'C', p: [213.509, 318.146, 382.31, 287.746, 393.51, 283.746]},
 {t: 'C', p: [404.71, 279.746, 499.038, 286.073, 499.038, 286.073]},
 {t: 'L', p: [493.51, 268.764]},
 {t: 'C', p: [428.71, 222.364, 410.31, 246.146, 396.71, 242.146]},
 {t: 'C', p: [383.11, 238.146, 385.51, 247.746, 382.31, 248.546]},
 {t: 'C', p: [379.11, 249.346, 339.91, 224.546, 333.51, 225.346]},
 {t: 'z', p: []}]},

{f: '#ea8c4d', s: null, p: [{t: 'M', p: [334.819, 227.091]},
 {t: 'C', p: [328.419, 227.891, 303.685, 203.862, 318.019, 235.891]},
 {t: 'C', p: [334.219, 272.092, 259.619, 275.092, 242.819, 263.892]},
 {t: 'C', p: [226.019, 252.692, 250.019, 282.292, 250.019, 282.292]},
 {t: 'C', p: [268.419, 302.292, 234.019, 285.492, 234.019, 285.492]},
 {t: 'C', p: [199.619, 272.692, 175.618, 298.292, 172.418, 299.092]},
 {t: 'C', p: [169.218, 299.892, 164.418, 303.092, 163.618, 296.692]},
 {t: 'C', p: [162.818, 290.292, 155.57, 273.925, 123.618, 299.892]},
 {t: 'C', p: [101.145, 317.983, 87.964, 297.074, 87.964, 297.074]},
 {t: 'L', p: [84.364, 305.692]},
 {t: 'C', p: [60.564, 266.692, 75.109, 325.71, 75.109, 325.71]},
 {t: 'C', p: [83.909, 360.11, 214.819, 319.892, 214.819, 319.892]},
 {t: 'C', p: [214.819, 319.892, 383.619, 289.492, 394.819, 285.492]},
 {t: 'C', p: [406.019, 281.492, 499.474, 287.746, 499.474, 287.746]},
 {t: 'L', p: [494.02, 269.928]},
 {t: 'C', p: [429.219, 223.528, 411.619, 247.891, 398.019, 243.891]},
 {t: 'C', p: [384.419, 239.891, 386.819, 249.491, 383.619, 250.292]},
 {t: 'C', p: [380.419, 251.092, 341.219, 226.291, 334.819, 227.091]},
 {t: 'z', p: []}]},

{f: '#ec9961', s: null, p: [{t: 'M', p: [336.128, 228.837]},
 {t: 'C', p: [329.728, 229.637, 304.999, 205.605, 319.328, 237.637]},
 {t: 'C', p: [336.128, 275.193, 260.394, 276.482, 244.128, 265.637]},
 {t: 'C', p: [227.328, 254.437, 251.328, 284.037, 251.328, 284.037]},
 {t: 'C', p: [269.728, 304.037, 235.328, 287.237, 235.328, 287.237]},
 {t: 'C', p: [200.928, 274.437, 176.928, 300.037, 173.728, 300.837]},
 {t: 'C', p: [170.528, 301.637, 165.728, 304.837, 164.928, 298.437]},
 {t: 'C', p: [164.128, 292.037, 157.011, 275.839, 124.927, 301.637]},
 {t: 'C', p: [101.218, 320.474, 88.345, 300.11, 88.345, 300.11]},
 {t: 'L', p: [84.345, 307.237]},
 {t: 'C', p: [62.545, 270.437, 75.764, 328.765, 75.764, 328.765]},
 {t: 'C', p: [84.564, 363.165, 216.128, 321.637, 216.128, 321.637]},
 {t: 'C', p: [216.128, 321.637, 384.928, 291.237, 396.129, 287.237]},
 {t: 'C', p: [407.329, 283.237, 499.911, 289.419, 499.911, 289.419]},
 {t: 'L', p: [494.529, 271.092]},
 {t: 'C', p: [429.729, 224.691, 412.929, 249.637, 399.329, 245.637]},
 {t: 'C', p: [385.728, 241.637, 388.128, 251.237, 384.928, 252.037]},
 {t: 'C', p: [381.728, 252.837, 342.528, 228.037, 336.128, 228.837]},
 {t: 'z', p: []}]},

{f: '#eea575', s: null, p: [{t: 'M', p: [337.438, 230.583]},
 {t: 'C', p: [331.037, 231.383, 306.814, 207.129, 320.637, 239.383]},
 {t: 'C', p: [337.438, 278.583, 262.237, 278.583, 245.437, 267.383]},
 {t: 'C', p: [228.637, 256.183, 252.637, 285.783, 252.637, 285.783]},
 {t: 'C', p: [271.037, 305.783, 236.637, 288.983, 236.637, 288.983]},
 {t: 'C', p: [202.237, 276.183, 178.237, 301.783, 175.037, 302.583]},
 {t: 'C', p: [171.837, 303.383, 167.037, 306.583, 166.237, 300.183]},
 {t: 'C', p: [165.437, 293.783, 158.452, 277.752, 126.237, 303.383]},
 {t: 'C', p: [101.291, 322.965, 88.727, 303.146, 88.727, 303.146]},
 {t: 'L', p: [84.327, 308.783]},
 {t: 'C', p: [64.527, 273.982, 76.418, 331.819, 76.418, 331.819]},
 {t: 'C', p: [85.218, 366.22, 217.437, 323.383, 217.437, 323.383]},
 {t: 'C', p: [217.437, 323.383, 386.238, 292.983, 397.438, 288.983]},
 {t: 'C', p: [408.638, 284.983, 500.347, 291.092, 500.347, 291.092]},
 {t: 'L', p: [495.038, 272.255]},
 {t: 'C', p: [430.238, 225.855, 414.238, 251.383, 400.638, 247.383]},
 {t: 'C', p: [387.038, 243.383, 389.438, 252.983, 386.238, 253.783]},
 {t: 'C', p: [383.038, 254.583, 343.838, 229.783, 337.438, 230.583]},
 {t: 'z', p: []}]},

{f: '#f1b288', s: null, p: [{t: 'M', p: [338.747, 232.328]},
 {t: 'C', p: [332.347, 233.128, 306.383, 209.677, 321.947, 241.128]},
 {t: 'C', p: [341.147, 279.928, 263.546, 280.328, 246.746, 269.128]},
 {t: 'C', p: [229.946, 257.928, 253.946, 287.528, 253.946, 287.528]},
 {t: 'C', p: [272.346, 307.528, 237.946, 290.728, 237.946, 290.728]},
 {t: 'C', p: [203.546, 277.928, 179.546, 303.528, 176.346, 304.328]},
 {t: 'C', p: [173.146, 305.128, 168.346, 308.328, 167.546, 301.928]},
 {t: 'C', p: [166.746, 295.528, 159.892, 279.665, 127.546, 305.128]},
 {t: 'C', p: [101.364, 325.456, 89.109, 306.183, 89.109, 306.183]},
 {t: 'L', p: [84.309, 310.328]},
 {t: 'C', p: [66.309, 277.128, 77.073, 334.874, 77.073, 334.874]},
 {t: 'C', p: [85.873, 369.274, 218.746, 325.128, 218.746, 325.128]},
 {t: 'C', p: [218.746, 325.128, 387.547, 294.728, 398.747, 290.728]},
 {t: 'C', p: [409.947, 286.728, 500.783, 292.764, 500.783, 292.764]},
 {t: 'L', p: [495.547, 273.419]},
 {t: 'C', p: [430.747, 227.019, 415.547, 253.128, 401.947, 249.128]},
 {t: 'C', p: [388.347, 245.128, 390.747, 254.728, 387.547, 255.528]},
 {t: 'C', p: [384.347, 256.328, 345.147, 231.528, 338.747, 232.328]},
 {t: 'z', p: []}]},

{f: '#f3bf9c', s: null, p: [{t: 'M', p: [340.056, 234.073]},
 {t: 'C', p: [333.655, 234.873, 307.313, 211.613, 323.255, 242.873]},
 {t: 'C', p: [343.656, 282.874, 264.855, 282.074, 248.055, 270.874]},
 {t: 'C', p: [231.255, 259.674, 255.255, 289.274, 255.255, 289.274]},
 {t: 'C', p: [273.655, 309.274, 239.255, 292.474, 239.255, 292.474]},
 {t: 'C', p: [204.855, 279.674, 180.855, 305.274, 177.655, 306.074]},
 {t: 'C', p: [174.455, 306.874, 169.655, 310.074, 168.855, 303.674]},
 {t: 'C', p: [168.055, 297.274, 161.332, 281.578, 128.855, 306.874]},
 {t: 'C', p: [101.436, 327.947, 89.491, 309.219, 89.491, 309.219]},
 {t: 'L', p: [84.291, 311.874]},
 {t: 'C', p: [68.291, 281.674, 77.727, 337.929, 77.727, 337.929]},
 {t: 'C', p: [86.527, 372.329, 220.055, 326.874, 220.055, 326.874]},
 {t: 'C', p: [220.055, 326.874, 388.856, 296.474, 400.056, 292.474]},
 {t: 'C', p: [411.256, 288.474, 501.22, 294.437, 501.22, 294.437]},
 {t: 'L', p: [496.056, 274.583]},
 {t: 'C', p: [431.256, 228.183, 416.856, 254.874, 403.256, 250.874]},
 {t: 'C', p: [389.656, 246.873, 392.056, 256.474, 388.856, 257.274]},
 {t: 'C', p: [385.656, 258.074, 346.456, 233.273, 340.056, 234.073]},
 {t: 'z', p: []}]},

{f: '#f5ccb0', s: null, p: [{t: 'M', p: [341.365, 235.819]},
 {t: 'C', p: [334.965, 236.619, 307.523, 213.944, 324.565, 244.619]},
 {t: 'C', p: [346.565, 284.219, 266.164, 283.819, 249.364, 272.619]},
 {t: 'C', p: [232.564, 261.419, 256.564, 291.019, 256.564, 291.019]},
 {t: 'C', p: [274.964, 311.019, 240.564, 294.219, 240.564, 294.219]},
 {t: 'C', p: [206.164, 281.419, 182.164, 307.019, 178.964, 307.819]},
 {t: 'C', p: [175.764, 308.619, 170.964, 311.819, 170.164, 305.419]},
 {t: 'C', p: [169.364, 299.019, 162.773, 283.492, 130.164, 308.619]},
 {t: 'C', p: [101.509, 330.438, 89.873, 312.256, 89.873, 312.256]},
 {t: 'L', p: [84.273, 313.419]},
 {t: 'C', p: [69.872, 285.019, 78.382, 340.983, 78.382, 340.983]},
 {t: 'C', p: [87.182, 375.384, 221.364, 328.619, 221.364, 328.619]},
 {t: 'C', p: [221.364, 328.619, 390.165, 298.219, 401.365, 294.219]},
 {t: 'C', p: [412.565, 290.219, 501.656, 296.11, 501.656, 296.11]},
 {t: 'L', p: [496.565, 275.746]},
 {t: 'C', p: [431.765, 229.346, 418.165, 256.619, 404.565, 252.619]},
 {t: 'C', p: [390.965, 248.619, 393.365, 258.219, 390.165, 259.019]},
 {t: 'C', p: [386.965, 259.819, 347.765, 235.019, 341.365, 235.819]},
 {t: 'z', p: []}]},

{f: '#f8d8c4', s: null, p: [{t: 'M', p: [342.674, 237.565]},
 {t: 'C', p: [336.274, 238.365, 308.832, 215.689, 325.874, 246.365]},
 {t: 'C', p: [347.874, 285.965, 267.474, 285.565, 250.674, 274.365]},
 {t: 'C', p: [233.874, 263.165, 257.874, 292.765, 257.874, 292.765]},
 {t: 'C', p: [276.274, 312.765, 241.874, 295.965, 241.874, 295.965]},
 {t: 'C', p: [207.473, 283.165, 183.473, 308.765, 180.273, 309.565]},
 {t: 'C', p: [177.073, 310.365, 172.273, 313.565, 171.473, 307.165]},
 {t: 'C', p: [170.673, 300.765, 164.214, 285.405, 131.473, 310.365]},
 {t: 'C', p: [101.582, 332.929, 90.255, 315.293, 90.255, 315.293]},
 {t: 'L', p: [84.255, 314.965]},
 {t: 'C', p: [70.654, 288.564, 79.037, 344.038, 79.037, 344.038]},
 {t: 'C', p: [87.837, 378.438, 222.673, 330.365, 222.673, 330.365]},
 {t: 'C', p: [222.673, 330.365, 391.474, 299.965, 402.674, 295.965]},
 {t: 'C', p: [413.874, 291.965, 502.093, 297.783, 502.093, 297.783]},
 {t: 'L', p: [497.075, 276.91]},
 {t: 'C', p: [432.274, 230.51, 419.474, 258.365, 405.874, 254.365]},
 {t: 'C', p: [392.274, 250.365, 394.674, 259.965, 391.474, 260.765]},
 {t: 'C', p: [388.274, 261.565, 349.074, 236.765, 342.674, 237.565]},
 {t: 'z', p: []}]},

{f: '#fae5d7', s: null, p: [{t: 'M', p: [343.983, 239.31]},
 {t: 'C', p: [337.583, 240.11, 310.529, 217.223, 327.183, 248.11]},
 {t: 'C', p: [349.183, 288.91, 268.783, 287.31, 251.983, 276.11]},
 {t: 'C', p: [235.183, 264.91, 259.183, 294.51, 259.183, 294.51]},
 {t: 'C', p: [277.583, 314.51, 243.183, 297.71, 243.183, 297.71]},
 {t: 'C', p: [208.783, 284.91, 184.783, 310.51, 181.583, 311.31]},
 {t: 'C', p: [178.382, 312.11, 173.582, 315.31, 172.782, 308.91]},
 {t: 'C', p: [171.982, 302.51, 165.654, 287.318, 132.782, 312.11]},
 {t: 'C', p: [101.655, 335.42, 90.637, 318.329, 90.637, 318.329]},
 {t: 'L', p: [84.236, 316.51]},
 {t: 'C', p: [71.236, 292.51, 79.691, 347.093, 79.691, 347.093]},
 {t: 'C', p: [88.491, 381.493, 223.983, 332.11, 223.983, 332.11]},
 {t: 'C', p: [223.983, 332.11, 392.783, 301.71, 403.983, 297.71]},
 {t: 'C', p: [415.183, 293.71, 502.529, 299.456, 502.529, 299.456]},
 {t: 'L', p: [497.583, 278.074]},
 {t: 'C', p: [432.783, 231.673, 420.783, 260.11, 407.183, 256.11]},
 {t: 'C', p: [393.583, 252.11, 395.983, 261.71, 392.783, 262.51]},
 {t: 'C', p: [389.583, 263.31, 350.383, 238.51, 343.983, 239.31]},
 {t: 'z', p: []}]},

{f: '#fcf2eb', s: null, p: [{t: 'M', p: [345.292, 241.055]},
 {t: 'C', p: [338.892, 241.855, 312.917, 218.411, 328.492, 249.855]},
 {t: 'C', p: [349.692, 292.656, 270.092, 289.056, 253.292, 277.856]},
 {t: 'C', p: [236.492, 266.656, 260.492, 296.256, 260.492, 296.256]},
 {t: 'C', p: [278.892, 316.256, 244.492, 299.456, 244.492, 299.456]},
 {t: 'C', p: [210.092, 286.656, 186.092, 312.256, 182.892, 313.056]},
 {t: 'C', p: [179.692, 313.856, 174.892, 317.056, 174.092, 310.656]},
 {t: 'C', p: [173.292, 304.256, 167.095, 289.232, 134.092, 313.856]},
 {t: 'C', p: [101.727, 337.911, 91.018, 321.365, 91.018, 321.365]},
 {t: 'L', p: [84.218, 318.056]},
 {t: 'C', p: [71.418, 294.856, 80.346, 350.147, 80.346, 350.147]},
 {t: 'C', p: [89.146, 384.547, 225.292, 333.856, 225.292, 333.856]},
 {t: 'C', p: [225.292, 333.856, 394.093, 303.456, 405.293, 299.456]},
 {t: 'C', p: [416.493, 295.456, 502.965, 301.128, 502.965, 301.128]},
 {t: 'L', p: [498.093, 279.237]},
 {t: 'C', p: [433.292, 232.837, 422.093, 261.856, 408.493, 257.856]},
 {t: 'C', p: [394.893, 253.855, 397.293, 263.456, 394.093, 264.256]},
 {t: 'C', p: [390.892, 265.056, 351.692, 240.255, 345.292, 241.055]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [84.2, 319.601]},
 {t: 'C', p: [71.4, 297.6, 81, 353.201, 81, 353.201]},
 {t: 'C', p: [89.8, 387.601, 226.6, 335.601, 226.6, 335.601]},
 {t: 'C', p: [226.6, 335.601, 395.401, 305.2, 406.601, 301.2]},
 {t: 'C', p: [417.801, 297.2, 503.401, 302.8, 503.401, 302.8]},
 {t: 'L', p: [498.601, 280.4]},
 {t: 'C', p: [433.801, 234, 423.401, 263.6, 409.801, 259.6]},
 {t: 'C', p: [396.201, 255.6, 398.601, 265.2, 395.401, 266]},
 {t: 'C', p: [392.201, 266.8, 353.001, 242, 346.601, 242.8]},
 {t: 'C', p: [340.201, 243.6, 314.981, 219.793, 329.801, 251.6]},
 {t: 'C', p: [352.028, 299.307, 269.041, 289.227, 254.6, 279.6]},
 {t: 'C', p: [237.8, 268.4, 261.8, 298, 261.8, 298]},
 {t: 'C', p: [280.2, 318.001, 245.8, 301.2, 245.8, 301.2]},
 {t: 'C', p: [211.4, 288.4, 187.4, 314.001, 184.2, 314.801]},
 {t: 'C', p: [181, 315.601, 176.2, 318.801, 175.4, 312.401]},
 {t: 'C', p: [174.6, 306, 168.535, 291.144, 135.4, 315.601]},
 {t: 'C', p: [101.8, 340.401, 91.4, 324.401, 91.4, 324.401]},
 {t: 'L', p: [84.2, 319.601]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [125.8, 349.601]},
 {t: 'C', p: [125.8, 349.601, 118.6, 361.201, 139.4, 374.401]},
 {t: 'C', p: [139.4, 374.401, 140.8, 375.801, 122.8, 371.601]},
 {t: 'C', p: [122.8, 371.601, 116.6, 369.601, 115, 359.201]},
 {t: 'C', p: [115, 359.201, 110.2, 354.801, 105.4, 349.201]},
 {t: 'C', p: [100.6, 343.601, 125.8, 349.601, 125.8, 349.601]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [265.8, 302]},
 {t: 'C', p: [265.8, 302, 283.498, 328.821, 282.9, 333.601]},
 {t: 'C', p: [281.6, 344.001, 281.4, 353.601, 284.6, 357.601]},
 {t: 'C', p: [287.801, 361.601, 296.601, 394.801, 296.601, 394.801]},
 {t: 'C', p: [296.601, 394.801, 296.201, 396.001, 308.601, 358.001]},
 {t: 'C', p: [308.601, 358.001, 320.201, 342.001, 300.201, 323.601]},
 {t: 'C', p: [300.201, 323.601, 265, 294.8, 265.8, 302]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [145.8, 376.401]},
 {t: 'C', p: [145.8, 376.401, 157, 383.601, 142.6, 414.801]},
 {t: 'L', p: [149, 412.401]},
 {t: 'C', p: [149, 412.401, 148.2, 423.601, 145, 426.001]},
 {t: 'L', p: [152.2, 422.801]},
 {t: 'C', p: [152.2, 422.801, 157, 430.801, 153, 435.601]},
 {t: 'C', p: [153, 435.601, 169.8, 443.601, 169, 450.001]},
 {t: 'C', p: [169, 450.001, 175.4, 442.001, 171.4, 435.601]},
 {t: 'C', p: [167.4, 429.201, 160.2, 433.201, 161, 414.801]},
 {t: 'L', p: [152.2, 418.001]},
 {t: 'C', p: [152.2, 418.001, 157.8, 409.201, 157.8, 402.801]},
 {t: 'L', p: [149.8, 405.201]},
 {t: 'C', p: [149.8, 405.201, 165.269, 378.623, 154.6, 377.201]},
 {t: 'C', p: [148.6, 376.401, 145.8, 376.401, 145.8, 376.401]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [178.2, 393.201]},
 {t: 'C', p: [178.2, 393.201, 181, 388.801, 178.2, 389.601]},
 {t: 'C', p: [175.4, 390.401, 144.2, 405.201, 138.2, 414.801]},
 {t: 'C', p: [138.2, 414.801, 172.6, 390.401, 178.2, 393.201]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [188.6, 401.201]},
 {t: 'C', p: [188.6, 401.201, 191.4, 396.801, 188.6, 397.601]},
 {t: 'C', p: [185.8, 398.401, 154.6, 413.201, 148.6, 422.801]},
 {t: 'C', p: [148.6, 422.801, 183, 398.401, 188.6, 401.201]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [201.8, 386.001]},
 {t: 'C', p: [201.8, 386.001, 204.6, 381.601, 201.8, 382.401]},
 {t: 'C', p: [199, 383.201, 167.8, 398.001, 161.8, 407.601]},
 {t: 'C', p: [161.8, 407.601, 196.2, 383.201, 201.8, 386.001]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [178.6, 429.601]},
 {t: 'C', p: [178.6, 429.601, 178.6, 423.601, 175.8, 424.401]},
 {t: 'C', p: [173, 425.201, 137, 442.801, 131, 452.401]},
 {t: 'C', p: [131, 452.401, 173, 426.801, 178.6, 429.601]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [179.8, 418.801]},
 {t: 'C', p: [179.8, 418.801, 181, 414.001, 178.2, 414.801]},
 {t: 'C', p: [176.2, 414.801, 149.8, 426.401, 143.8, 436.001]},
 {t: 'C', p: [143.8, 436.001, 173.4, 414.401, 179.8, 418.801]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [165.4, 466.401]},
 {t: 'L', p: [155.4, 474.001]},
 {t: 'C', p: [155.4, 474.001, 165.8, 466.401, 169.4, 467.601]},
 {t: 'C', p: [169.4, 467.601, 162.6, 478.801, 161.8, 484.001]},
 {t: 'C', p: [161.8, 484.001, 172.2, 471.201, 177.8, 471.601]},
 {t: 'C', p: [177.8, 471.601, 185.4, 472.001, 185.4, 482.801]},
 {t: 'C', p: [185.4, 482.801, 191, 472.401, 194.2, 472.801]},
 {t: 'C', p: [194.2, 472.801, 195.4, 479.201, 194.2, 486.001]},
 {t: 'C', p: [194.2, 486.001, 198.2, 478.401, 202.2, 480.001]},
 {t: 'C', p: [202.2, 480.001, 208.6, 478.001, 207.8, 489.601]},
 {t: 'C', p: [207.8, 489.601, 207.8, 500.001, 207, 502.801]},
 {t: 'C', p: [207, 502.801, 212.6, 476.401, 215, 476.001]},
 {t: 'C', p: [215, 476.001, 223, 474.801, 227.8, 483.601]},
 {t: 'C', p: [227.8, 483.601, 223.8, 476.001, 228.6, 478.001]},
 {t: 'C', p: [228.6, 478.001, 239.4, 479.601, 242.6, 486.401]},
 {t: 'C', p: [242.6, 486.401, 235.8, 474.401, 241.4, 477.601]},
 {t: 'C', p: [241.4, 477.601, 248.2, 477.601, 249.4, 484.001]},
 {t: 'C', p: [249.4, 484.001, 257.8, 505.201, 259.8, 506.801]},
 {t: 'C', p: [259.8, 506.801, 252.2, 485.201, 253.8, 485.201]},
 {t: 'C', p: [253.8, 485.201, 251.8, 473.201, 257, 488.001]},
 {t: 'C', p: [257, 488.001, 253.8, 474.001, 259.4, 474.801]},
 {t: 'C', p: [265, 475.601, 269.4, 485.601, 277.8, 483.201]},
 {t: 'C', p: [277.8, 483.201, 287.401, 488.801, 289.401, 419.601]},
 {t: 'L', p: [165.4, 466.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [170.2, 373.601]},
 {t: 'C', p: [170.2, 373.601, 185, 367.601, 225, 373.601]},
 {t: 'C', p: [225, 373.601, 232.2, 374.001, 239, 365.201]},
 {t: 'C', p: [245.8, 356.401, 272.6, 349.201, 279, 351.201]},
 {t: 'L', p: [288.601, 357.601]},
 {t: 'L', p: [289.401, 358.801]},
 {t: 'C', p: [289.401, 358.801, 301.801, 369.201, 302.201, 376.801]},
 {t: 'C', p: [302.601, 384.401, 287.801, 432.401, 278.2, 448.401]},
 {t: 'C', p: [268.6, 464.401, 259, 476.801, 239.8, 474.401]},
 {t: 'C', p: [239.8, 474.401, 219, 470.401, 193.4, 474.401]},
 {t: 'C', p: [193.4, 474.401, 164.2, 472.801, 161.4, 464.801]},
 {t: 'C', p: [158.6, 456.801, 172.6, 441.601, 172.6, 441.601]},
 {t: 'C', p: [172.6, 441.601, 177, 433.201, 175.8, 418.801]},
 {t: 'C', p: [174.6, 404.401, 175, 376.401, 170.2, 373.601]},
 {t: 'z', p: []}]},

{f: '#e5668c', s: null, p: [{t: 'M', p: [192.2, 375.601]},
 {t: 'C', p: [200.6, 394.001, 171, 459.201, 171, 459.201]},
 {t: 'C', p: [169, 460.801, 183.66, 466.846, 193.8, 464.401]},
 {t: 'C', p: [204.746, 461.763, 245, 466.001, 245, 466.001]},
 {t: 'C', p: [268.6, 450.401, 281.4, 406.001, 281.4, 406.001]},
 {t: 'C', p: [281.4, 406.001, 291.801, 382.001, 274.2, 378.801]},
 {t: 'C', p: [256.6, 375.601, 192.2, 375.601, 192.2, 375.601]},
 {t: 'z', p: []}]},

{f: '#b23259', s: null, p: [{t: 'M', p: [190.169, 406.497]},
 {t: 'C', p: [193.495, 393.707, 195.079, 381.906, 192.2, 375.601]},
 {t: 'C', p: [192.2, 375.601, 254.6, 382.001, 265.8, 361.201]},
 {t: 'C', p: [270.041, 353.326, 284.801, 384.001, 284.4, 393.601]},
 {t: 'C', p: [284.4, 393.601, 221.4, 408.001, 206.6, 396.801]},
 {t: 'L', p: [190.169, 406.497]},
 {t: 'z', p: []}]},

{f: '#a5264c', s: null, p: [{t: 'M', p: [194.6, 422.801]},
 {t: 'C', p: [194.6, 422.801, 196.6, 430.001, 194.2, 434.001]},
 {t: 'C', p: [194.2, 434.001, 192.6, 434.801, 191.4, 435.201]},
 {t: 'C', p: [191.4, 435.201, 192.6, 438.801, 198.6, 440.401]},
 {t: 'C', p: [198.6, 440.401, 200.6, 444.801, 203, 445.201]},
 {t: 'C', p: [205.4, 445.601, 210.2, 451.201, 214.2, 450.001]},
 {t: 'C', p: [218.2, 448.801, 229.4, 444.801, 229.4, 444.801]},
 {t: 'C', p: [229.4, 444.801, 235, 441.601, 243.8, 445.201]},
 {t: 'C', p: [243.8, 445.201, 246.175, 444.399, 246.6, 440.401]},
 {t: 'C', p: [247.1, 435.701, 250.2, 432.001, 252.2, 430.001]},
 {t: 'C', p: [254.2, 428.001, 263.8, 415.201, 262.6, 414.801]},
 {t: 'C', p: [261.4, 414.401, 194.6, 422.801, 194.6, 422.801]},
 {t: 'z', p: []}]},

{f: '#ff727f', s: '#000', p: [{t: 'M', p: [190.2, 374.401]},
 {t: 'C', p: [190.2, 374.401, 187.4, 396.801, 190.6, 405.201]},
 {t: 'C', p: [193.8, 413.601, 193, 415.601, 192.2, 419.601]},
 {t: 'C', p: [191.4, 423.601, 195.8, 433.601, 201.4, 439.601]},
 {t: 'L', p: [213.4, 441.201]},
 {t: 'C', p: [213.4, 441.201, 228.6, 437.601, 237.8, 440.401]},
 {t: 'C', p: [237.8, 440.401, 246.794, 441.744, 250.2, 426.801]},
 {t: 'C', p: [250.2, 426.801, 255, 420.401, 262.2, 417.601]},
 {t: 'C', p: [269.4, 414.801, 276.6, 373.201, 272.6, 365.201]},
 {t: 'C', p: [268.6, 357.201, 254.2, 352.801, 238.2, 368.401]},
 {t: 'C', p: [222.2, 384.001, 220.2, 367.201, 190.2, 374.401]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [191.8, 449.201]},
 {t: 'C', p: [191.8, 449.201, 191, 447.201, 186.6, 446.801]},
 {t: 'C', p: [186.6, 446.801, 164.2, 443.201, 155.8, 430.801]},
 {t: 'C', p: [155.8, 430.801, 149, 425.201, 153.4, 436.801]},
 {t: 'C', p: [153.4, 436.801, 163.8, 457.201, 170.6, 460.001]},
 {t: 'C', p: [170.6, 460.001, 187, 464.001, 191.8, 449.201]},
 {t: 'z', p: []}]},

{f: '#cc3f4c', s: null, p: [{t: 'M', p: [271.742, 385.229]},
 {t: 'C', p: [272.401, 377.323, 274.354, 368.709, 272.6, 365.201]},
 {t: 'C', p: [266.154, 352.307, 249.181, 357.695, 238.2, 368.401]},
 {t: 'C', p: [222.2, 384.001, 220.2, 367.201, 190.2, 374.401]},
 {t: 'C', p: [190.2, 374.401, 188.455, 388.364, 189.295, 398.376]},
 {t: 'C', p: [189.295, 398.376, 226.6, 386.801, 227.4, 392.401]},
 {t: 'C', p: [227.4, 392.401, 229, 389.201, 238.2, 389.201]},
 {t: 'C', p: [247.4, 389.201, 270.142, 388.029, 271.742, 385.229]},
 {t: 'z', p: []}]},

{f: null, s: {c: '#a51926', w: 2},
 p: [{t: 'M', p: [228.6, 375.201]},
 {t: 'C', p: [228.6, 375.201, 233.4, 380.001, 229.8, 389.601]},
 {t: 'C', p: [229.8, 389.601, 215.4, 405.601, 217.4, 419.601]}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [180.6, 460.001]},
 {t: 'C', p: [180.6, 460.001, 176.2, 447.201, 185, 454.001]},
 {t: 'C', p: [185, 454.001, 189.8, 456.001, 188.6, 457.601]},
 {t: 'C', p: [187.4, 459.201, 181.8, 463.201, 180.6, 460.001]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [185.64, 461.201]},
 {t: 'C', p: [185.64, 461.201, 182.12, 450.961, 189.16, 456.401]},
 {t: 'C', p: [189.16, 456.401, 193.581, 458.849, 192.04, 459.281]},
 {t: 'C', p: [187.48, 460.561, 192.04, 463.121, 185.64, 461.201]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [190.44, 461.201]},
 {t: 'C', p: [190.44, 461.201, 186.92, 450.961, 193.96, 456.401]},
 {t: 'C', p: [193.96, 456.401, 198.335, 458.711, 196.84, 459.281]},
 {t: 'C', p: [193.48, 460.561, 196.84, 463.121, 190.44, 461.201]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [197.04, 461.401]},
 {t: 'C', p: [197.04, 461.401, 193.52, 451.161, 200.56, 456.601]},
 {t: 'C', p: [200.56, 456.601, 204.943, 458.933, 203.441, 459.481]},
 {t: 'C', p: [200.48, 460.561, 203.441, 463.321, 197.04, 461.401]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [203.52, 461.321]},
 {t: 'C', p: [203.52, 461.321, 200, 451.081, 207.041, 456.521]},
 {t: 'C', p: [207.041, 456.521, 210.881, 458.121, 209.921, 459.401]},
 {t: 'C', p: [208.961, 460.681, 209.921, 463.241, 203.52, 461.321]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [210.2, 462.001]},
 {t: 'C', p: [210.2, 462.001, 205.4, 449.601, 214.6, 456.001]},
 {t: 'C', p: [214.6, 456.001, 219.4, 458.001, 218.2, 459.601]},
 {t: 'C', p: [217, 461.201, 218.2, 464.401, 210.2, 462.001]},
 {t: 'z', p: []}]},

{f: null, s: {c: '#a5264c', w: 2},
 p: [{t: 'M', p: [181.8, 444.801]},
 {t: 'C', p: [181.8, 444.801, 195, 442.001, 201, 445.201]},
 {t: 'C', p: [201, 445.201, 207, 446.401, 208.2, 446.001]},
 {t: 'C', p: [209.4, 445.601, 212.6, 445.201, 212.6, 445.201]}]},

{f: null, s: {c: '#a5264c', w: 2},
 p: [{t: 'M', p: [215.8, 453.601]},
 {t: 'C', p: [215.8, 453.601, 227.8, 440.001, 239.8, 444.401]},
 {t: 'C', p: [246.816, 446.974, 245.8, 443.601, 246.6, 440.801]},
 {t: 'C', p: [247.4, 438.001, 247.6, 433.801, 252.6, 430.801]}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [233, 437.601]},
 {t: 'C', p: [233, 437.601, 229, 426.801, 226.2, 439.601]},
 {t: 'C', p: [223.4, 452.401, 220.2, 456.001, 218.6, 458.801]},
 {t: 'C', p: [218.6, 458.801, 218.6, 464.001, 227, 463.601]},
 {t: 'C', p: [227, 463.601, 237.8, 463.201, 238.2, 460.401]},
 {t: 'C', p: [238.6, 457.601, 237, 446.001, 233, 437.601]},
 {t: 'z', p: []}]},

{f: null, s: {c: '#a5264c', w: 2},
 p: [{t: 'M', p: [247, 444.801]},
 {t: 'C', p: [247, 444.801, 250.6, 442.401, 253, 443.601]}]},

{f: null, s: {c: '#a5264c', w: 2},
 p: [{t: 'M', p: [253.5, 428.401]},
 {t: 'C', p: [253.5, 428.401, 256.4, 423.501, 261.2, 422.701]}]},

{f: '#b2b2b2', s: null, p: [{t: 'M', p: [174.2, 465.201]},
 {t: 'C', p: [174.2, 465.201, 192.2, 468.401, 196.6, 466.801]},
 {t: 'C', p: [196.6, 466.801, 205.4, 466.801, 197, 468.801]},
 {t: 'C', p: [197, 468.801, 184.2, 468.801, 176.2, 467.601]},
 {t: 'C', p: [176.2, 467.601, 164.6, 462.001, 174.2, 465.201]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [188.2, 372.001]},
 {t: 'C', p: [188.2, 372.001, 205.8, 372.001, 207.8, 372.801]},
 {t: 'C', p: [207.8, 372.801, 215, 403.601, 211.4, 411.201]},
 {t: 'C', p: [211.4, 411.201, 210.2, 414.001, 207.4, 408.401]},
 {t: 'C', p: [207.4, 408.401, 189, 375.601, 185.8, 373.601]},
 {t: 'C', p: [182.6, 371.601, 187, 372.001, 188.2, 372.001]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [111.1, 369.301]},
 {t: 'C', p: [111.1, 369.301, 120, 371.001, 132.6, 373.601]},
 {t: 'C', p: [132.6, 373.601, 137.4, 396.001, 140.6, 400.801]},
 {t: 'C', p: [143.8, 405.601, 140.2, 405.601, 136.6, 402.801]},
 {t: 'C', p: [133, 400.001, 118.2, 386.001, 116.2, 381.601]},
 {t: 'C', p: [114.2, 377.201, 111.1, 369.301, 111.1, 369.301]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [132.961, 373.818]},
 {t: 'C', p: [132.961, 373.818, 138.761, 375.366, 139.77, 377.581]},
 {t: 'C', p: [140.778, 379.795, 138.568, 383.092, 138.568, 383.092]},
 {t: 'C', p: [138.568, 383.092, 137.568, 386.397, 136.366, 384.235]},
 {t: 'C', p: [135.164, 382.072, 132.292, 374.412, 132.961, 373.818]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [133, 373.601]},
 {t: 'C', p: [133, 373.601, 136.6, 378.801, 140.2, 378.801]},
 {t: 'C', p: [143.8, 378.801, 144.182, 378.388, 147, 379.001]},
 {t: 'C', p: [151.6, 380.001, 151.2, 378.001, 157.8, 379.201]},
 {t: 'C', p: [160.44, 379.681, 163, 378.801, 165.8, 380.001]},
 {t: 'C', p: [168.6, 381.201, 171.8, 380.401, 173, 378.401]},
 {t: 'C', p: [174.2, 376.401, 179, 372.201, 179, 372.201]},
 {t: 'C', p: [179, 372.201, 166.2, 374.001, 163.4, 374.801]},
 {t: 'C', p: [163.4, 374.801, 141, 376.001, 133, 373.601]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [177.6, 373.801]},
 {t: 'C', p: [177.6, 373.801, 171.15, 377.301, 170.75, 379.701]},
 {t: 'C', p: [170.35, 382.101, 176, 385.801, 176, 385.801]},
 {t: 'C', p: [176, 385.801, 178.75, 390.401, 179.35, 388.001]},
 {t: 'C', p: [179.95, 385.601, 178.4, 374.201, 177.6, 373.801]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [140.115, 379.265]},
 {t: 'C', p: [140.115, 379.265, 147.122, 390.453, 147.339, 379.242]},
 {t: 'C', p: [147.339, 379.242, 147.896, 377.984, 146.136, 377.962]},
 {t: 'C', p: [140.061, 377.886, 141.582, 373.784, 140.115, 379.265]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [147.293, 379.514]},
 {t: 'C', p: [147.293, 379.514, 155.214, 390.701, 154.578, 379.421]},
 {t: 'C', p: [154.578, 379.421, 154.585, 379.089, 152.832, 378.936]},
 {t: 'C', p: [148.085, 378.522, 148.43, 374.004, 147.293, 379.514]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [154.506, 379.522]},
 {t: 'C', p: [154.506, 379.522, 162.466, 390.15, 161.797, 380.484]},
 {t: 'C', p: [161.797, 380.484, 161.916, 379.251, 160.262, 378.95]},
 {t: 'C', p: [156.37, 378.244, 156.159, 374.995, 154.506, 379.522]},
 {t: 'z', p: []}]},

{f: '#ffc', s: {c: '#000', w: 0.5},
 p: [{t: 'M', p: [161.382, 379.602]},
 {t: 'C', p: [161.382, 379.602, 169.282, 391.163, 169.63, 381.382]},
 {t: 'C', p: [169.63, 381.382, 171.274, 380.004, 169.528, 379.782]},
 {t: 'C', p: [163.71, 379.042, 164.508, 374.588, 161.382, 379.602]},
 {t: 'z', p: []}]},

{f: '#e5e5b2', s: null, p: [{t: 'M', p: [125.208, 383.132]},
 {t: 'L', p: [117.55, 381.601]},
 {t: 'C', p: [114.95, 376.601, 112.85, 370.451, 112.85, 370.451]},
 {t: 'C', p: [112.85, 370.451, 119.2, 371.451, 131.7, 374.251]},
 {t: 'C', p: [131.7, 374.251, 132.576, 377.569, 134.048, 383.364]},
 {t: 'L', p: [125.208, 383.132]},
 {t: 'z', p: []}]},

{f: '#e5e5b2', s: null, p: [{t: 'M', p: [190.276, 378.47]},
 {t: 'C', p: [188.61, 375.964, 187.293, 374.206, 186.643, 373.8]},
 {t: 'C', p: [183.63, 371.917, 187.773, 372.294, 188.902, 372.294]},
 {t: 'C', p: [188.902, 372.294, 205.473, 372.294, 207.356, 373.047]},
 {t: 'C', p: [207.356, 373.047, 207.88, 375.289, 208.564, 378.68]},
 {t: 'C', p: [208.564, 378.68, 198.476, 376.67, 190.276, 378.47]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [243.88, 240.321]},
 {t: 'C', p: [271.601, 244.281, 297.121, 208.641, 298.881, 198.96]},
 {t: 'C', p: [300.641, 189.28, 290.521, 177.4, 290.521, 177.4]},
 {t: 'C', p: [291.841, 174.32, 287.001, 160.24, 281.721, 151]},
 {t: 'C', p: [276.441, 141.76, 260.54, 142.734, 243, 141.76]},
 {t: 'C', p: [227.16, 140.88, 208.68, 164.2, 207.36, 165.96]},
 {t: 'C', p: [206.04, 167.72, 212.2, 206.001, 213.52, 211.721]},
 {t: 'C', p: [214.84, 217.441, 212.2, 243.841, 212.2, 243.841]},
 {t: 'C', p: [246.44, 234.741, 216.16, 236.361, 243.88, 240.321]},
 {t: 'z', p: []}]},

{f: '#ea8e51', s: null, p: [{t: 'M', p: [208.088, 166.608]},
 {t: 'C', p: [206.792, 168.336, 212.84, 205.921, 214.136, 211.537]},
 {t: 'C', p: [215.432, 217.153, 212.84, 243.073, 212.84, 243.073]},
 {t: 'C', p: [245.512, 234.193, 216.728, 235.729, 243.944, 239.617]},
 {t: 'C', p: [271.161, 243.505, 296.217, 208.513, 297.945, 199.008]},
 {t: 'C', p: [299.673, 189.504, 289.737, 177.84, 289.737, 177.84]},
 {t: 'C', p: [291.033, 174.816, 286.281, 160.992, 281.097, 151.92]},
 {t: 'C', p: [275.913, 142.848, 260.302, 143.805, 243.08, 142.848]},
 {t: 'C', p: [227.528, 141.984, 209.384, 164.88, 208.088, 166.608]},
 {t: 'z', p: []}]},

{f: '#efaa7c', s: null, p: [{t: 'M', p: [208.816, 167.256]},
 {t: 'C', p: [207.544, 168.952, 213.48, 205.841, 214.752, 211.353]},
 {t: 'C', p: [216.024, 216.865, 213.48, 242.305, 213.48, 242.305]},
 {t: 'C', p: [244.884, 233.145, 217.296, 235.097, 244.008, 238.913]},
 {t: 'C', p: [270.721, 242.729, 295.313, 208.385, 297.009, 199.056]},
 {t: 'C', p: [298.705, 189.728, 288.953, 178.28, 288.953, 178.28]},
 {t: 'C', p: [290.225, 175.312, 285.561, 161.744, 280.473, 152.84]},
 {t: 'C', p: [275.385, 143.936, 260.063, 144.875, 243.16, 143.936]},
 {t: 'C', p: [227.896, 143.088, 210.088, 165.56, 208.816, 167.256]},
 {t: 'z', p: []}]},

{f: '#f4c6a8', s: null, p: [{t: 'M', p: [209.544, 167.904]},
 {t: 'C', p: [208.296, 169.568, 214.12, 205.761, 215.368, 211.169]},
 {t: 'C', p: [216.616, 216.577, 214.12, 241.537, 214.12, 241.537]},
 {t: 'C', p: [243.556, 232.497, 217.864, 234.465, 244.072, 238.209]},
 {t: 'C', p: [270.281, 241.953, 294.409, 208.257, 296.073, 199.105]},
 {t: 'C', p: [297.737, 189.952, 288.169, 178.72, 288.169, 178.72]},
 {t: 'C', p: [289.417, 175.808, 284.841, 162.496, 279.849, 153.76]},
 {t: 'C', p: [274.857, 145.024, 259.824, 145.945, 243.24, 145.024]},
 {t: 'C', p: [228.264, 144.192, 210.792, 166.24, 209.544, 167.904]},
 {t: 'z', p: []}]},

{f: '#f9e2d3', s: null, p: [{t: 'M', p: [210.272, 168.552]},
 {t: 'C', p: [209.048, 170.184, 214.76, 205.681, 215.984, 210.985]},
 {t: 'C', p: [217.208, 216.289, 214.76, 240.769, 214.76, 240.769]},
 {t: 'C', p: [242.628, 231.849, 218.432, 233.833, 244.136, 237.505]},
 {t: 'C', p: [269.841, 241.177, 293.505, 208.129, 295.137, 199.152]},
 {t: 'C', p: [296.769, 190.176, 287.385, 179.16, 287.385, 179.16]},
 {t: 'C', p: [288.609, 176.304, 284.121, 163.248, 279.225, 154.68]},
 {t: 'C', p: [274.329, 146.112, 259.585, 147.015, 243.32, 146.112]},
 {t: 'C', p: [228.632, 145.296, 211.496, 166.92, 210.272, 168.552]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [244.2, 236.8]},
 {t: 'C', p: [269.4, 240.4, 292.601, 208, 294.201, 199.2]},
 {t: 'C', p: [295.801, 190.4, 286.601, 179.6, 286.601, 179.6]},
 {t: 'C', p: [287.801, 176.8, 283.4, 164, 278.6, 155.6]},
 {t: 'C', p: [273.8, 147.2, 259.346, 148.086, 243.4, 147.2]},
 {t: 'C', p: [229, 146.4, 212.2, 167.6, 211, 169.2]},
 {t: 'C', p: [209.8, 170.8, 215.4, 205.6, 216.6, 210.8]},
 {t: 'C', p: [217.8, 216, 215.4, 240, 215.4, 240]},
 {t: 'C', p: [240.9, 231.4, 219, 233.2, 244.2, 236.8]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [290.601, 202.8]},
 {t: 'C', p: [290.601, 202.8, 262.8, 210.4, 251.2, 208.8]},
 {t: 'C', p: [251.2, 208.8, 235.4, 202.2, 226.6, 224]},
 {t: 'C', p: [226.6, 224, 223, 231.2, 221, 233.2]},
 {t: 'C', p: [219, 235.2, 290.601, 202.8, 290.601, 202.8]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [294.401, 200.6]},
 {t: 'C', p: [294.401, 200.6, 265.4, 212.8, 255.4, 212.4]},
 {t: 'C', p: [255.4, 212.4, 239, 207.8, 230.6, 222.4]},
 {t: 'C', p: [230.6, 222.4, 222.2, 231.6, 219, 233.2]},
 {t: 'C', p: [219, 233.2, 218.6, 234.8, 225, 230.8]},
 {t: 'L', p: [235.4, 236]},
 {t: 'C', p: [235.4, 236, 250.2, 245.6, 259.8, 229.6]},
 {t: 'C', p: [259.8, 229.6, 263.8, 218.4, 263.8, 216.4]},
 {t: 'C', p: [263.8, 214.4, 285, 208.8, 286.601, 208.4]},
 {t: 'C', p: [288.201, 208, 294.801, 203.8, 294.401, 200.6]},
 {t: 'z', p: []}]},

{f: '#99cc32', s: null, p: [{t: 'M', p: [247, 236.514]},
 {t: 'C', p: [240.128, 236.514, 231.755, 232.649, 231.755, 226.4]},
 {t: 'C', p: [231.755, 220.152, 240.128, 213.887, 247, 213.887]},
 {t: 'C', p: [253.874, 213.887, 259.446, 218.952, 259.446, 225.2]},
 {t: 'C', p: [259.446, 231.449, 253.874, 236.514, 247, 236.514]},
 {t: 'z', p: []}]},

{f: '#659900', s: null, p: [{t: 'M', p: [243.377, 219.83]},
 {t: 'C', p: [238.531, 220.552, 233.442, 222.055, 233.514, 221.839]},
 {t: 'C', p: [235.054, 217.22, 241.415, 213.887, 247, 213.887]},
 {t: 'C', p: [251.296, 213.887, 255.084, 215.865, 257.32, 218.875]},
 {t: 'C', p: [257.32, 218.875, 252.004, 218.545, 243.377, 219.83]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [255.4, 219.6]},
 {t: 'C', p: [255.4, 219.6, 251, 216.4, 251, 218.6]},
 {t: 'C', p: [251, 218.6, 254.6, 223, 255.4, 219.6]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [245.4, 227.726]},
 {t: 'C', p: [242.901, 227.726, 240.875, 225.7, 240.875, 223.2]},
 {t: 'C', p: [240.875, 220.701, 242.901, 218.675, 245.4, 218.675]},
 {t: 'C', p: [247.9, 218.675, 249.926, 220.701, 249.926, 223.2]},
 {t: 'C', p: [249.926, 225.7, 247.9, 227.726, 245.4, 227.726]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [141.4, 214.4]},
 {t: 'C', p: [141.4, 214.4, 138.2, 193.2, 140.6, 188.8]},
 {t: 'C', p: [140.6, 188.8, 151.4, 178.8, 151, 175.2]},
 {t: 'C', p: [151, 175.2, 150.6, 157.2, 149.4, 156.4]},
 {t: 'C', p: [148.2, 155.6, 140.6, 149.6, 134.6, 156]},
 {t: 'C', p: [134.6, 156, 124.2, 174, 125, 180.4]},
 {t: 'L', p: [125, 182.4]},
 {t: 'C', p: [125, 182.4, 117.4, 182, 115.8, 184]},
 {t: 'C', p: [115.8, 184, 114.6, 189.2, 113.4, 189.6]},
 {t: 'C', p: [113.4, 189.6, 110.6, 192, 112.6, 194.8]},
 {t: 'C', p: [112.6, 194.8, 110.6, 197.2, 111, 201.2]},
 {t: 'L', p: [118.6, 205.2]},
 {t: 'C', p: [118.6, 205.2, 120.6, 219.6, 131.4, 224.8]},
 {t: 'C', p: [136.236, 227.129, 139.4, 220.4, 141.4, 214.4]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [140.4, 212.56]},
 {t: 'C', p: [140.4, 212.56, 137.52, 193.48, 139.68, 189.52]},
 {t: 'C', p: [139.68, 189.52, 149.4, 180.52, 149.04, 177.28]},
 {t: 'C', p: [149.04, 177.28, 148.68, 161.08, 147.6, 160.36]},
 {t: 'C', p: [146.52, 159.64, 139.68, 154.24, 134.28, 160]},
 {t: 'C', p: [134.28, 160, 124.92, 176.2, 125.64, 181.96]},
 {t: 'L', p: [125.64, 183.76]},
 {t: 'C', p: [125.64, 183.76, 118.8, 183.4, 117.36, 185.2]},
 {t: 'C', p: [117.36, 185.2, 116.28, 189.88, 115.2, 190.24]},
 {t: 'C', p: [115.2, 190.24, 112.68, 192.4, 114.48, 194.92]},
 {t: 'C', p: [114.48, 194.92, 112.68, 197.08, 113.04, 200.68]},
 {t: 'L', p: [119.88, 204.28]},
 {t: 'C', p: [119.88, 204.28, 121.68, 217.24, 131.4, 221.92]},
 {t: 'C', p: [135.752, 224.015, 138.6, 217.96, 140.4, 212.56]},
 {t: 'z', p: []}]},

{f: '#eb955c', s: null, p: [{t: 'M', p: [148.95, 157.39]},
 {t: 'C', p: [147.86, 156.53, 140.37, 150.76, 134.52, 157]},
 {t: 'C', p: [134.52, 157, 124.38, 174.55, 125.16, 180.79]},
 {t: 'L', p: [125.16, 182.74]},
 {t: 'C', p: [125.16, 182.74, 117.75, 182.35, 116.19, 184.3]},
 {t: 'C', p: [116.19, 184.3, 115.02, 189.37, 113.85, 189.76]},
 {t: 'C', p: [113.85, 189.76, 111.12, 192.1, 113.07, 194.83]},
 {t: 'C', p: [113.07, 194.83, 111.12, 197.17, 111.51, 201.07]},
 {t: 'L', p: [118.92, 204.97]},
 {t: 'C', p: [118.92, 204.97, 120.87, 219.01, 131.4, 224.08]},
 {t: 'C', p: [136.114, 226.35, 139.2, 219.79, 141.15, 213.94]},
 {t: 'C', p: [141.15, 213.94, 138.03, 193.27, 140.37, 188.98]},
 {t: 'C', p: [140.37, 188.98, 150.9, 179.23, 150.51, 175.72]},
 {t: 'C', p: [150.51, 175.72, 150.12, 158.17, 148.95, 157.39]},
 {t: 'z', p: []}]},

{f: '#f2b892', s: null, p: [{t: 'M', p: [148.5, 158.38]},
 {t: 'C', p: [147.52, 157.46, 140.14, 151.92, 134.44, 158]},
 {t: 'C', p: [134.44, 158, 124.56, 175.1, 125.32, 181.18]},
 {t: 'L', p: [125.32, 183.08]},
 {t: 'C', p: [125.32, 183.08, 118.1, 182.7, 116.58, 184.6]},
 {t: 'C', p: [116.58, 184.6, 115.44, 189.54, 114.3, 189.92]},
 {t: 'C', p: [114.3, 189.92, 111.64, 192.2, 113.54, 194.86]},
 {t: 'C', p: [113.54, 194.86, 111.64, 197.14, 112.02, 200.94]},
 {t: 'L', p: [119.24, 204.74]},
 {t: 'C', p: [119.24, 204.74, 121.14, 218.42, 131.4, 223.36]},
 {t: 'C', p: [135.994, 225.572, 139, 219.18, 140.9, 213.48]},
 {t: 'C', p: [140.9, 213.48, 137.86, 193.34, 140.14, 189.16]},
 {t: 'C', p: [140.14, 189.16, 150.4, 179.66, 150.02, 176.24]},
 {t: 'C', p: [150.02, 176.24, 149.64, 159.14, 148.5, 158.38]},
 {t: 'z', p: []}]},

{f: '#f8dcc8', s: null, p: [{t: 'M', p: [148.05, 159.37]},
 {t: 'C', p: [147.18, 158.39, 139.91, 153.08, 134.36, 159]},
 {t: 'C', p: [134.36, 159, 124.74, 175.65, 125.48, 181.57]},
 {t: 'L', p: [125.48, 183.42]},
 {t: 'C', p: [125.48, 183.42, 118.45, 183.05, 116.97, 184.9]},
 {t: 'C', p: [116.97, 184.9, 115.86, 189.71, 114.75, 190.08]},
 {t: 'C', p: [114.75, 190.08, 112.16, 192.3, 114.01, 194.89]},
 {t: 'C', p: [114.01, 194.89, 112.16, 197.11, 112.53, 200.81]},
 {t: 'L', p: [119.56, 204.51]},
 {t: 'C', p: [119.56, 204.51, 121.41, 217.83, 131.4, 222.64]},
 {t: 'C', p: [135.873, 224.794, 138.8, 218.57, 140.65, 213.02]},
 {t: 'C', p: [140.65, 213.02, 137.69, 193.41, 139.91, 189.34]},
 {t: 'C', p: [139.91, 189.34, 149.9, 180.09, 149.53, 176.76]},
 {t: 'C', p: [149.53, 176.76, 149.16, 160.11, 148.05, 159.37]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [140.4, 212.46]},
 {t: 'C', p: [140.4, 212.46, 137.52, 193.48, 139.68, 189.52]},
 {t: 'C', p: [139.68, 189.52, 149.4, 180.52, 149.04, 177.28]},
 {t: 'C', p: [149.04, 177.28, 148.68, 161.08, 147.6, 160.36]},
 {t: 'C', p: [146.84, 159.32, 139.68, 154.24, 134.28, 160]},
 {t: 'C', p: [134.28, 160, 124.92, 176.2, 125.64, 181.96]},
 {t: 'L', p: [125.64, 183.76]},
 {t: 'C', p: [125.64, 183.76, 118.8, 183.4, 117.36, 185.2]},
 {t: 'C', p: [117.36, 185.2, 116.28, 189.88, 115.2, 190.24]},
 {t: 'C', p: [115.2, 190.24, 112.68, 192.4, 114.48, 194.92]},
 {t: 'C', p: [114.48, 194.92, 112.68, 197.08, 113.04, 200.68]},
 {t: 'L', p: [119.88, 204.28]},
 {t: 'C', p: [119.88, 204.28, 121.68, 217.24, 131.4, 221.92]},
 {t: 'C', p: [135.752, 224.015, 138.6, 217.86, 140.4, 212.46]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [137.3, 206.2]},
 {t: 'C', p: [137.3, 206.2, 115.7, 196, 114.8, 195.2]},
 {t: 'C', p: [114.8, 195.2, 123.9, 203.4, 124.7, 203.4]},
 {t: 'C', p: [125.5, 203.4, 137.3, 206.2, 137.3, 206.2]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [120.2, 200]},
 {t: 'C', p: [120.2, 200, 138.6, 203.6, 138.6, 208]},
 {t: 'C', p: [138.6, 210.912, 138.357, 224.331, 133, 222.8]},
 {t: 'C', p: [124.6, 220.4, 128.2, 206, 120.2, 200]},
 {t: 'z', p: []}]},

{f: '#99cc32', s: null, p: [{t: 'M', p: [128.6, 203.8]},
 {t: 'C', p: [128.6, 203.8, 137.578, 205.274, 138.6, 208]},
 {t: 'C', p: [139.2, 209.6, 139.863, 217.908, 134.4, 219]},
 {t: 'C', p: [129.848, 219.911, 127.618, 209.69, 128.6, 203.8]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [214.595, 246.349]},
 {t: 'C', p: [214.098, 244.607, 215.409, 244.738, 217.2, 244.2]},
 {t: 'C', p: [219.2, 243.6, 231.4, 239.8, 232.2, 237.2]},
 {t: 'C', p: [233, 234.6, 246.2, 239, 246.2, 239]},
 {t: 'C', p: [248, 239.8, 252.4, 242.4, 252.4, 242.4]},
 {t: 'C', p: [257.2, 243.6, 263.8, 244, 263.8, 244]},
 {t: 'C', p: [266.2, 245, 269.6, 247.8, 269.6, 247.8]},
 {t: 'C', p: [284.2, 258, 296.601, 250.8, 296.601, 250.8]},
 {t: 'C', p: [316.601, 244.2, 310.601, 227, 310.601, 227]},
 {t: 'C', p: [307.601, 218, 310.801, 214.6, 310.801, 214.6]},
 {t: 'C', p: [311.001, 210.8, 318.201, 217.2, 318.201, 217.2]},
 {t: 'C', p: [320.801, 221.4, 321.601, 226.4, 321.601, 226.4]},
 {t: 'C', p: [329.601, 237.6, 326.201, 219.8, 326.201, 219.8]},
 {t: 'C', p: [326.401, 218.8, 323.601, 215.2, 323.601, 214]},
 {t: 'C', p: [323.601, 212.8, 321.801, 209.4, 321.801, 209.4]},
 {t: 'C', p: [318.801, 206, 321.201, 199, 321.201, 199]},
 {t: 'C', p: [323.001, 185.2, 320.801, 187, 320.801, 187]},
 {t: 'C', p: [319.601, 185.2, 310.401, 195.2, 310.401, 195.2]},
 {t: 'C', p: [308.201, 198.6, 302.201, 200.2, 302.201, 200.2]},
 {t: 'C', p: [299.401, 202, 296.001, 200.6, 296.001, 200.6]},
 {t: 'C', p: [293.401, 200.2, 287.801, 207.2, 287.801, 207.2]},
 {t: 'C', p: [290.601, 207, 293.001, 211.4, 295.401, 211.6]},
 {t: 'C', p: [297.801, 211.8, 299.601, 209.2, 301.201, 208.6]},
 {t: 'C', p: [302.801, 208, 305.601, 213.8, 305.601, 213.8]},
 {t: 'C', p: [306.001, 216.4, 300.401, 221.2, 300.401, 221.2]},
 {t: 'C', p: [300.001, 225.8, 298.401, 224.2, 298.401, 224.2]},
 {t: 'C', p: [295.401, 223.6, 294.201, 227.4, 293.201, 232]},
 {t: 'C', p: [292.201, 236.6, 288.001, 237, 288.001, 237]},
 {t: 'C', p: [286.401, 244.4, 285.2, 241.4, 285.2, 241.4]},
 {t: 'C', p: [285, 235.8, 279, 241.6, 279, 241.6]},
 {t: 'C', p: [277.8, 243.6, 273.2, 241.4, 273.2, 241.4]},
 {t: 'C', p: [266.4, 239.4, 268.8, 237.4, 268.8, 237.4]},
 {t: 'C', p: [270.6, 235.2, 281.8, 237.4, 281.8, 237.4]},
 {t: 'C', p: [284, 235.8, 276, 231.8, 276, 231.8]},
 {t: 'C', p: [275.4, 230, 276.4, 225.6, 276.4, 225.6]},
 {t: 'C', p: [277.6, 222.4, 284.4, 216.8, 284.4, 216.8]},
 {t: 'C', p: [293.801, 215.6, 291.001, 214, 291.001, 214]},
 {t: 'C', p: [284.801, 208.8, 279, 216.4, 279, 216.4]},
 {t: 'C', p: [276.8, 222.6, 259.4, 237.6, 259.4, 237.6]},
 {t: 'C', p: [254.6, 241, 257.2, 234.2, 253.2, 237.6]},
 {t: 'C', p: [249.2, 241, 228.6, 232, 228.6, 232]},
 {t: 'C', p: [217.038, 230.807, 214.306, 246.549, 210.777, 243.429]},
 {t: 'C', p: [210.777, 243.429, 216.195, 251.949, 214.595, 246.349]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [409.401, 80]},
 {t: 'C', p: [409.401, 80, 383.801, 88, 381.001, 106.8]},
 {t: 'C', p: [381.001, 106.8, 378.601, 129.6, 399.001, 147.2]},
 {t: 'C', p: [399.001, 147.2, 399.401, 153.6, 401.401, 156.8]},
 {t: 'C', p: [401.401, 156.8, 399.801, 161.6, 418.601, 154]},
 {t: 'L', p: [445.801, 145.6]},
 {t: 'C', p: [445.801, 145.6, 452.201, 143.2, 457.401, 134.4]},
 {t: 'C', p: [462.601, 125.6, 477.801, 106.8, 474.201, 81.6]},
 {t: 'C', p: [474.201, 81.6, 475.401, 70.4, 469.401, 70]},
 {t: 'C', p: [469.401, 70, 461.001, 68.4, 453.801, 76]},
 {t: 'C', p: [453.801, 76, 447.001, 79.2, 444.601, 78.8]},
 {t: 'L', p: [409.401, 80]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [464.022, 79.01]},
 {t: 'C', p: [464.022, 79.01, 466.122, 70.08, 461.282, 74.92]},
 {t: 'C', p: [461.282, 74.92, 454.242, 80.64, 446.761, 80.64]},
 {t: 'C', p: [446.761, 80.64, 432.241, 82.84, 427.841, 96.04]},
 {t: 'C', p: [427.841, 96.04, 423.881, 122.88, 431.801, 128.6]},
 {t: 'C', p: [431.801, 128.6, 436.641, 136.08, 443.681, 129.48]},
 {t: 'C', p: [450.722, 122.88, 466.222, 92.65, 464.022, 79.01]},
 {t: 'z', p: []}]},

{f: '#323232', s: null, p: [{t: 'M', p: [463.648, 79.368]},
 {t: 'C', p: [463.648, 79.368, 465.738, 70.624, 460.986, 75.376]},
 {t: 'C', p: [460.986, 75.376, 454.074, 80.992, 446.729, 80.992]},
 {t: 'C', p: [446.729, 80.992, 432.473, 83.152, 428.153, 96.112]},
 {t: 'C', p: [428.153, 96.112, 424.265, 122.464, 432.041, 128.08]},
 {t: 'C', p: [432.041, 128.08, 436.793, 135.424, 443.705, 128.944]},
 {t: 'C', p: [450.618, 122.464, 465.808, 92.76, 463.648, 79.368]},
 {t: 'z', p: []}]},

{f: '#666', s: null, p: [{t: 'M', p: [463.274, 79.726]},
 {t: 'C', p: [463.274, 79.726, 465.354, 71.168, 460.69, 75.832]},
 {t: 'C', p: [460.69, 75.832, 453.906, 81.344, 446.697, 81.344]},
 {t: 'C', p: [446.697, 81.344, 432.705, 83.464, 428.465, 96.184]},
 {t: 'C', p: [428.465, 96.184, 424.649, 122.048, 432.281, 127.56]},
 {t: 'C', p: [432.281, 127.56, 436.945, 134.768, 443.729, 128.408]},
 {t: 'C', p: [450.514, 122.048, 465.394, 92.87, 463.274, 79.726]},
 {t: 'z', p: []}]},

{f: '#999', s: null, p: [{t: 'M', p: [462.9, 80.084]},
 {t: 'C', p: [462.9, 80.084, 464.97, 71.712, 460.394, 76.288]},
 {t: 'C', p: [460.394, 76.288, 453.738, 81.696, 446.665, 81.696]},
 {t: 'C', p: [446.665, 81.696, 432.937, 83.776, 428.777, 96.256]},
 {t: 'C', p: [428.777, 96.256, 425.033, 121.632, 432.521, 127.04]},
 {t: 'C', p: [432.521, 127.04, 437.097, 134.112, 443.753, 127.872]},
 {t: 'C', p: [450.41, 121.632, 464.98, 92.98, 462.9, 80.084]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [462.526, 80.442]},
 {t: 'C', p: [462.526, 80.442, 464.586, 72.256, 460.098, 76.744]},
 {t: 'C', p: [460.098, 76.744, 453.569, 82.048, 446.633, 82.048]},
 {t: 'C', p: [446.633, 82.048, 433.169, 84.088, 429.089, 96.328]},
 {t: 'C', p: [429.089, 96.328, 425.417, 121.216, 432.761, 126.52]},
 {t: 'C', p: [432.761, 126.52, 437.249, 133.456, 443.777, 127.336]},
 {t: 'C', p: [450.305, 121.216, 464.566, 93.09, 462.526, 80.442]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [462.151, 80.8]},
 {t: 'C', p: [462.151, 80.8, 464.201, 72.8, 459.801, 77.2]},
 {t: 'C', p: [459.801, 77.2, 453.401, 82.4, 446.601, 82.4]},
 {t: 'C', p: [446.601, 82.4, 433.401, 84.4, 429.401, 96.4]},
 {t: 'C', p: [429.401, 96.4, 425.801, 120.8, 433.001, 126]},
 {t: 'C', p: [433.001, 126, 437.401, 132.8, 443.801, 126.8]},
 {t: 'C', p: [450.201, 120.8, 464.151, 93.2, 462.151, 80.8]},
 {t: 'z', p: []}]},

{f: '#992600', s: null, p: [{t: 'M', p: [250.6, 284]},
 {t: 'C', p: [250.6, 284, 230.2, 264.8, 222.2, 264]},
 {t: 'C', p: [222.2, 264, 187.8, 260, 173, 278]},
 {t: 'C', p: [173, 278, 190.6, 257.6, 218.2, 263.2]},
 {t: 'C', p: [218.2, 263.2, 196.6, 258.8, 184.2, 262]},
 {t: 'C', p: [184.2, 262, 167.4, 262, 157.8, 276]},
 {t: 'L', p: [155, 280.8]},
 {t: 'C', p: [155, 280.8, 159, 266, 177.4, 260]},
 {t: 'C', p: [177.4, 260, 200.2, 255.2, 211, 260]},
 {t: 'C', p: [211, 260, 189.4, 253.2, 179.4, 255.2]},
 {t: 'C', p: [179.4, 255.2, 149, 252.8, 136.2, 279.2]},
 {t: 'C', p: [136.2, 279.2, 140.2, 264.8, 155, 257.6]},
 {t: 'C', p: [155, 257.6, 168.6, 248.8, 189, 251.6]},
 {t: 'C', p: [189, 251.6, 203.4, 254.8, 208.6, 257.2]},
 {t: 'C', p: [213.8, 259.6, 212.6, 256.8, 204.2, 252]},
 {t: 'C', p: [204.2, 252, 198.6, 242, 184.6, 242.4]},
 {t: 'C', p: [184.6, 242.4, 141.8, 246, 131.4, 258]},
 {t: 'C', p: [131.4, 258, 145, 246.8, 155.4, 244]},
 {t: 'C', p: [155.4, 244, 177.8, 236, 186.2, 236.8]},
 {t: 'C', p: [186.2, 236.8, 211, 237.8, 218.6, 233.8]},
 {t: 'C', p: [218.6, 233.8, 207.4, 238.8, 210.6, 242]},
 {t: 'C', p: [213.8, 245.2, 220.6, 252.8, 220.6, 254]},
 {t: 'C', p: [220.6, 255.2, 244.8, 277.3, 248.4, 281.7]},
 {t: 'L', p: [250.6, 284]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [389, 478]},
 {t: 'C', p: [389, 478, 373.5, 441.5, 361, 432]},
 {t: 'C', p: [361, 432, 387, 448, 390.5, 466]},
 {t: 'C', p: [390.5, 466, 390.5, 476, 389, 478]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [436, 485.5]},
 {t: 'C', p: [436, 485.5, 409.5, 430.5, 391, 406.5]},
 {t: 'C', p: [391, 406.5, 434.5, 444, 439.5, 470.5]},
 {t: 'L', p: [440, 476]},
 {t: 'L', p: [437, 473.5]},
 {t: 'C', p: [437, 473.5, 436.5, 482.5, 436, 485.5]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [492.5, 437]},
 {t: 'C', p: [492.5, 437, 430, 377.5, 428.5, 375]},
 {t: 'C', p: [428.5, 375, 489, 441, 492, 448.5]},
 {t: 'C', p: [492, 448.5, 490, 439.5, 492.5, 437]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [304, 480.5]},
 {t: 'C', p: [304, 480.5, 323.5, 428.5, 342.5, 451]},
 {t: 'C', p: [342.5, 451, 357.5, 461, 357, 464]},
 {t: 'C', p: [357, 464, 353, 457.5, 335, 458]},
 {t: 'C', p: [335, 458, 316, 455, 304, 480.5]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [494.5, 353]},
 {t: 'C', p: [494.5, 353, 449.5, 324.5, 442, 323]},
 {t: 'C', p: [430.193, 320.639, 491.5, 352, 496.5, 362.5]},
 {t: 'C', p: [496.5, 362.5, 498.5, 360, 494.5, 353]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [343.801, 459.601]},
 {t: 'C', p: [343.801, 459.601, 364.201, 457.601, 371.001, 450.801]},
 {t: 'L', p: [375.401, 454.401]},
 {t: 'L', p: [393.001, 416.001]},
 {t: 'L', p: [396.601, 421.201]},
 {t: 'C', p: [396.601, 421.201, 411.001, 406.401, 410.201, 398.401]},
 {t: 'C', p: [409.401, 390.401, 423.001, 404.401, 423.001, 404.401]},
 {t: 'C', p: [423.001, 404.401, 422.201, 392.801, 429.401, 399.601]},
 {t: 'C', p: [429.401, 399.601, 427.001, 384.001, 435.401, 392.001]},
 {t: 'C', p: [435.401, 392.001, 424.864, 361.844, 447.401, 387.601]},
 {t: 'C', p: [453.001, 394.001, 448.601, 387.201, 448.601, 387.201]},
 {t: 'C', p: [448.601, 387.201, 422.601, 339.201, 444.201, 353.601]},
 {t: 'C', p: [444.201, 353.601, 446.201, 330.801, 445.001, 326.401]},
 {t: 'C', p: [443.801, 322.001, 441.801, 299.6, 437.001, 294.4]},
 {t: 'C', p: [432.201, 289.2, 437.401, 287.6, 443.001, 292.8]},
 {t: 'C', p: [443.001, 292.8, 431.801, 268.8, 445.001, 280.8]},
 {t: 'C', p: [445.001, 280.8, 441.401, 265.6, 437.001, 262.8]},
 {t: 'C', p: [437.001, 262.8, 431.401, 245.6, 446.601, 256.4]},
 {t: 'C', p: [446.601, 256.4, 442.201, 244, 439.001, 240.8]},
 {t: 'C', p: [439.001, 240.8, 427.401, 213.2, 434.601, 218]},
 {t: 'L', p: [439.001, 221.6]},
 {t: 'C', p: [439.001, 221.6, 432.201, 207.6, 438.601, 212]},
 {t: 'C', p: [445.001, 216.4, 445.001, 216, 445.001, 216]},
 {t: 'C', p: [445.001, 216, 423.801, 182.8, 444.201, 200.4]},
 {t: 'C', p: [444.201, 200.4, 436.042, 186.482, 432.601, 179.6]},
 {t: 'C', p: [432.601, 179.6, 413.801, 159.2, 428.201, 165.6]},
 {t: 'L', p: [433.001, 167.2]},
 {t: 'C', p: [433.001, 167.2, 424.201, 157.2, 416.201, 155.6]},
 {t: 'C', p: [408.201, 154, 418.601, 147.6, 425.001, 149.6]},
 {t: 'C', p: [431.401, 151.6, 447.001, 159.2, 447.001, 159.2]},
 {t: 'C', p: [447.001, 159.2, 459.801, 178, 463.801, 178.4]},
 {t: 'C', p: [463.801, 178.4, 443.801, 170.8, 449.801, 178.8]},
 {t: 'C', p: [449.801, 178.8, 464.201, 192.8, 457.001, 192.4]},
 {t: 'C', p: [457.001, 192.4, 451.001, 199.6, 455.801, 208.4]},
 {t: 'C', p: [455.801, 208.4, 437.342, 190.009, 452.201, 215.6]},
 {t: 'L', p: [459.001, 232]},
 {t: 'C', p: [459.001, 232, 434.601, 207.2, 445.801, 229.2]},
 {t: 'C', p: [445.801, 229.2, 463.001, 252.8, 465.001, 253.2]},
 {t: 'C', p: [467.001, 253.6, 471.401, 262.4, 471.401, 262.4]},
 {t: 'L', p: [467.001, 260.4]},
 {t: 'L', p: [472.201, 269.2]},
 {t: 'C', p: [472.201, 269.2, 461.001, 257.2, 467.001, 270.4]},
 {t: 'L', p: [472.601, 284.8]},
 {t: 'C', p: [472.601, 284.8, 452.201, 262.8, 465.801, 292.4]},
 {t: 'C', p: [465.801, 292.4, 449.401, 287.2, 458.201, 304.4]},
 {t: 'C', p: [458.201, 304.4, 456.601, 320.401, 457.001, 325.601]},
 {t: 'C', p: [457.401, 330.801, 458.601, 359.201, 454.201, 367.201]},
 {t: 'C', p: [449.801, 375.201, 460.201, 394.401, 462.201, 398.401]},
 {t: 'C', p: [464.201, 402.401, 467.801, 413.201, 459.001, 404.001]},
 {t: 'C', p: [450.201, 394.801, 454.601, 400.401, 456.601, 409.201]},
 {t: 'C', p: [458.601, 418.001, 464.601, 433.601, 463.801, 439.201]},
 {t: 'C', p: [463.801, 439.201, 462.601, 440.401, 459.401, 436.801]},
 {t: 'C', p: [459.401, 436.801, 444.601, 414.001, 446.201, 428.401]},
 {t: 'C', p: [446.201, 428.401, 445.001, 436.401, 441.801, 445.201]},
 {t: 'C', p: [441.801, 445.201, 438.601, 456.001, 438.601, 447.201]},
 {t: 'C', p: [438.601, 447.201, 435.401, 430.401, 432.601, 438.001]},
 {t: 'C', p: [429.801, 445.601, 426.201, 451.601, 423.401, 454.001]},
 {t: 'C', p: [420.601, 456.401, 415.401, 433.601, 414.201, 444.001]},
 {t: 'C', p: [414.201, 444.001, 402.201, 431.601, 397.401, 448.001]},
 {t: 'L', p: [385.801, 464.401]},
 {t: 'C', p: [385.801, 464.401, 385.401, 452.001, 384.201, 458.001]},
 {t: 'C', p: [384.201, 458.001, 354.201, 464.001, 343.801, 459.601]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [309.401, 102.8]},
 {t: 'C', p: [309.401, 102.8, 297.801, 94.8, 293.801, 95.2]},
 {t: 'C', p: [289.801, 95.6, 321.401, 86.4, 362.601, 114]},
 {t: 'C', p: [362.601, 114, 367.401, 116.8, 371.001, 116.4]},
 {t: 'C', p: [371.001, 116.4, 374.201, 118.8, 371.401, 122.4]},
 {t: 'C', p: [371.401, 122.4, 362.601, 132, 373.801, 143.2]},
 {t: 'C', p: [373.801, 143.2, 392.201, 150, 386.601, 141.2]},
 {t: 'C', p: [386.601, 141.2, 397.401, 145.2, 399.801, 149.2]},
 {t: 'C', p: [402.201, 153.2, 401.001, 149.2, 401.001, 149.2]},
 {t: 'C', p: [401.001, 149.2, 394.601, 142, 388.601, 136.8]},
 {t: 'C', p: [388.601, 136.8, 383.401, 134.8, 380.601, 126.4]},
 {t: 'C', p: [377.801, 118, 375.401, 108, 379.801, 104.8]},
 {t: 'C', p: [379.801, 104.8, 375.801, 109.2, 376.601, 105.2]},
 {t: 'C', p: [377.401, 101.2, 381.001, 97.6, 382.601, 97.2]},
 {t: 'C', p: [384.201, 96.8, 400.601, 81, 407.401, 80.6]},
 {t: 'C', p: [407.401, 80.6, 398.201, 82, 395.201, 81]},
 {t: 'C', p: [392.201, 80, 365.601, 68.6, 359.601, 67.4]},
 {t: 'C', p: [359.601, 67.4, 342.801, 60.8, 354.801, 62.8]},
 {t: 'C', p: [354.801, 62.8, 390.601, 66.6, 408.801, 79.8]},
 {t: 'C', p: [408.801, 79.8, 401.601, 71.4, 383.201, 64.4]},
 {t: 'C', p: [383.201, 64.4, 361.001, 51.8, 325.801, 56.8]},
 {t: 'C', p: [325.801, 56.8, 308.001, 60, 300.201, 61.8]},
 {t: 'C', p: [300.201, 61.8, 297.601, 61.2, 297.001, 60.8]},
 {t: 'C', p: [296.401, 60.4, 284.6, 51.4, 257, 58.4]},
 {t: 'C', p: [257, 58.4, 240, 63, 231.4, 67.8]},
 {t: 'C', p: [231.4, 67.8, 216.2, 69, 212.6, 72.2]},
 {t: 'C', p: [212.6, 72.2, 194, 86.8, 192, 87.6]},
 {t: 'C', p: [190, 88.4, 178.6, 96, 177.8, 96.4]},
 {t: 'C', p: [177.8, 96.4, 202.4, 89.8, 204.8, 87.4]},
 {t: 'C', p: [207.2, 85, 224.6, 82.4, 227, 83.8]},
 {t: 'C', p: [229.4, 85.2, 237.8, 84.6, 228.2, 85.2]},
 {t: 'C', p: [228.2, 85.2, 303.801, 100, 304.601, 102]},
 {t: 'C', p: [305.401, 104, 309.401, 102.8, 309.401, 102.8]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [380.801, 93.6]},
 {t: 'C', p: [380.801, 93.6, 370.601, 86.2, 368.601, 86.2]},
 {t: 'C', p: [366.601, 86.2, 354.201, 76, 350.001, 76.4]},
 {t: 'C', p: [345.801, 76.8, 333.601, 66.8, 306.201, 75]},
 {t: 'C', p: [306.201, 75, 305.601, 73, 309.201, 72.2]},
 {t: 'C', p: [309.201, 72.2, 315.601, 70, 316.001, 69.4]},
 {t: 'C', p: [316.001, 69.4, 336.201, 65.2, 343.401, 68.8]},
 {t: 'C', p: [343.401, 68.8, 352.601, 71.4, 358.801, 77.6]},
 {t: 'C', p: [358.801, 77.6, 370.001, 80.8, 373.201, 79.8]},
 {t: 'C', p: [373.201, 79.8, 382.001, 82, 382.401, 83.8]},
 {t: 'C', p: [382.401, 83.8, 388.201, 86.8, 386.401, 89.4]},
 {t: 'C', p: [386.401, 89.4, 386.801, 91, 380.801, 93.6]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [368.33, 91.491]},
 {t: 'C', p: [369.137, 92.123, 370.156, 92.221, 370.761, 93.03]},
 {t: 'C', p: [370.995, 93.344, 370.706, 93.67, 370.391, 93.767]},
 {t: 'C', p: [369.348, 94.084, 368.292, 93.514, 367.15, 94.102]},
 {t: 'C', p: [366.748, 94.309, 366.106, 94.127, 365.553, 93.978]},
 {t: 'C', p: [363.921, 93.537, 362.092, 93.512, 360.401, 94.2]},
 {t: 'C', p: [358.416, 93.071, 356.056, 93.655, 353.975, 92.654]},
 {t: 'C', p: [353.917, 92.627, 353.695, 92.973, 353.621, 92.946]},
 {t: 'C', p: [350.575, 91.801, 346.832, 92.084, 344.401, 89.8]},
 {t: 'C', p: [341.973, 89.388, 339.616, 88.926, 337.188, 88.246]},
 {t: 'C', p: [335.37, 87.737, 333.961, 86.748, 332.341, 85.916]},
 {t: 'C', p: [330.964, 85.208, 329.507, 84.686, 327.973, 84.314]},
 {t: 'C', p: [326.11, 83.862, 324.279, 83.974, 322.386, 83.454]},
 {t: 'C', p: [322.293, 83.429, 322.101, 83.773, 322.019, 83.746]},
 {t: 'C', p: [321.695, 83.638, 321.405, 83.055, 321.234, 83.108]},
 {t: 'C', p: [319.553, 83.63, 318.065, 82.658, 316.401, 83]},
 {t: 'C', p: [315.223, 81.776, 313.495, 82.021, 311.949, 81.579]},
 {t: 'C', p: [308.985, 80.731, 305.831, 82.001, 302.801, 81]},
 {t: 'C', p: [306.914, 79.158, 311.601, 80.39, 315.663, 78.321]},
 {t: 'C', p: [317.991, 77.135, 320.653, 78.237, 323.223, 77.477]},
 {t: 'C', p: [323.71, 77.333, 324.401, 77.131, 324.801, 77.8]},
 {t: 'C', p: [324.935, 77.665, 325.117, 77.426, 325.175, 77.454]},
 {t: 'C', p: [327.625, 78.611, 329.94, 79.885, 332.422, 80.951]},
 {t: 'C', p: [332.763, 81.097, 333.295, 80.865, 333.547, 81.067]},
 {t: 'C', p: [335.067, 82.283, 337.01, 82.18, 338.401, 83.4]},
 {t: 'C', p: [340.099, 82.898, 341.892, 83.278, 343.621, 82.654]},
 {t: 'C', p: [343.698, 82.627, 343.932, 82.968, 343.965, 82.946]},
 {t: 'C', p: [345.095, 82.198, 346.25, 82.469, 347.142, 82.773]},
 {t: 'C', p: [347.48, 82.888, 348.143, 83.135, 348.448, 83.209]},
 {t: 'C', p: [349.574, 83.485, 350.43, 83.965, 351.609, 84.148]},
 {t: 'C', p: [351.723, 84.166, 351.908, 83.826, 351.98, 83.854]},
 {t: 'C', p: [353.103, 84.292, 354.145, 84.236, 354.801, 85.4]},
 {t: 'C', p: [354.936, 85.265, 355.101, 85.027, 355.183, 85.054]},
 {t: 'C', p: [356.21, 85.392, 356.859, 86.147, 357.96, 86.388]},
 {t: 'C', p: [358.445, 86.494, 359.057, 87.12, 359.633, 87.296]},
 {t: 'C', p: [362.025, 88.027, 363.868, 89.556, 366.062, 90.451]},
 {t: 'C', p: [366.821, 90.761, 367.697, 90.995, 368.33, 91.491]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [291.696, 77.261]},
 {t: 'C', p: [289.178, 75.536, 286.81, 74.43, 284.368, 72.644]},
 {t: 'C', p: [284.187, 72.511, 283.827, 72.681, 283.625, 72.559]},
 {t: 'C', p: [282.618, 71.95, 281.73, 71.369, 280.748, 70.673]},
 {t: 'C', p: [280.209, 70.291, 279.388, 70.302, 278.88, 70.044]},
 {t: 'C', p: [276.336, 68.752, 273.707, 68.194, 271.2, 67]},
 {t: 'C', p: [271.882, 66.362, 273.004, 66.606, 273.6, 65.8]},
 {t: 'C', p: [273.795, 66.08, 274.033, 66.364, 274.386, 66.173]},
 {t: 'C', p: [276.064, 65.269, 277.914, 65.116, 279.59, 65.206]},
 {t: 'C', p: [281.294, 65.298, 283.014, 65.603, 284.789, 65.875]},
 {t: 'C', p: [285.096, 65.922, 285.295, 66.445, 285.618, 66.542]},
 {t: 'C', p: [287.846, 67.205, 290.235, 66.68, 292.354, 67.518]},
 {t: 'C', p: [293.945, 68.147, 295.515, 68.97, 296.754, 70.245]},
 {t: 'C', p: [297.006, 70.505, 296.681, 70.806, 296.401, 71]},
 {t: 'C', p: [296.789, 70.891, 297.062, 71.097, 297.173, 71.41]},
 {t: 'C', p: [297.257, 71.649, 297.257, 71.951, 297.173, 72.19]},
 {t: 'C', p: [297.061, 72.502, 296.782, 72.603, 296.408, 72.654]},
 {t: 'C', p: [295.001, 72.844, 296.773, 71.464, 296.073, 71.912]},
 {t: 'C', p: [294.8, 72.726, 295.546, 74.132, 294.801, 75.4]},
 {t: 'C', p: [294.521, 75.206, 294.291, 74.988, 294.401, 74.6]},
 {t: 'C', p: [294.635, 75.122, 294.033, 75.412, 293.865, 75.728]},
 {t: 'C', p: [293.48, 76.453, 292.581, 77.868, 291.696, 77.261]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [259.198, 84.609]},
 {t: 'C', p: [256.044, 83.815, 252.994, 83.93, 249.978, 82.654]},
 {t: 'C', p: [249.911, 82.626, 249.688, 82.973, 249.624, 82.946]},
 {t: 'C', p: [248.258, 82.352, 247.34, 81.386, 246.264, 80.34]},
 {t: 'C', p: [245.351, 79.452, 243.693, 79.839, 242.419, 79.352]},
 {t: 'C', p: [242.095, 79.228, 241.892, 78.716, 241.591, 78.677]},
 {t: 'C', p: [240.372, 78.52, 239.445, 77.571, 238.4, 77]},
 {t: 'C', p: [240.736, 76.205, 243.147, 76.236, 245.609, 75.852]},
 {t: 'C', p: [245.722, 75.834, 245.867, 76.155, 246, 76.155]},
 {t: 'C', p: [246.136, 76.155, 246.266, 75.934, 246.4, 75.8]},
 {t: 'C', p: [246.595, 76.08, 246.897, 76.406, 247.154, 76.152]},
 {t: 'C', p: [247.702, 75.612, 248.258, 75.802, 248.798, 75.842]},
 {t: 'C', p: [248.942, 75.852, 249.067, 76.155, 249.2, 76.155]},
 {t: 'C', p: [249.336, 76.155, 249.467, 75.844, 249.6, 75.844]},
 {t: 'C', p: [249.736, 75.845, 249.867, 76.155, 250, 76.155]},
 {t: 'C', p: [250.136, 76.155, 250.266, 75.934, 250.4, 75.8]},
 {t: 'C', p: [251.092, 76.582, 251.977, 76.028, 252.799, 76.207]},
 {t: 'C', p: [253.837, 76.434, 254.104, 77.582, 255.178, 77.88]},
 {t: 'C', p: [259.893, 79.184, 264.03, 81.329, 268.393, 83.416]},
 {t: 'C', p: [268.7, 83.563, 268.91, 83.811, 268.8, 84.2]},
 {t: 'C', p: [269.067, 84.2, 269.38, 84.112, 269.57, 84.244]},
 {t: 'C', p: [270.628, 84.976, 271.669, 85.524, 272.366, 86.622]},
 {t: 'C', p: [272.582, 86.961, 272.253, 87.368, 272.02, 87.316]},
 {t: 'C', p: [267.591, 86.321, 263.585, 85.713, 259.198, 84.609]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [245.338, 128.821]},
 {t: 'C', p: [243.746, 127.602, 243.162, 125.571, 242.034, 123.779]},
 {t: 'C', p: [241.82, 123.439, 242.094, 123.125, 242.411, 123.036]},
 {t: 'C', p: [242.971, 122.877, 243.514, 123.355, 243.923, 123.557]},
 {t: 'C', p: [245.668, 124.419, 247.203, 125.661, 249.2, 125.8]},
 {t: 'C', p: [251.19, 128.034, 255.45, 128.419, 255.457, 131.8]},
 {t: 'C', p: [255.458, 132.659, 254.03, 131.741, 253.6, 132.6]},
 {t: 'C', p: [251.149, 131.597, 248.76, 131.7, 246.38, 130.233]},
 {t: 'C', p: [245.763, 129.852, 246.093, 129.399, 245.338, 128.821]},
 {t: 'z', p: []}]},

{f: '#cc7226', s: null, p: [{t: 'M', p: [217.8, 76.244]},
 {t: 'C', p: [217.935, 76.245, 224.966, 76.478, 224.949, 76.592]},
 {t: 'C', p: [224.904, 76.901, 217.174, 77.95, 216.81, 77.78]},
 {t: 'C', p: [216.646, 77.704, 209.134, 80.134, 209, 80]},
 {t: 'C', p: [209.268, 79.865, 217.534, 76.244, 217.8, 76.244]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [233.2, 86]},
 {t: 'C', p: [233.2, 86, 218.4, 87.8, 214, 89]},
 {t: 'C', p: [209.6, 90.2, 191, 97.8, 188, 99.8]},
 {t: 'C', p: [188, 99.8, 174.6, 105.2, 157.6, 125.2]},
 {t: 'C', p: [157.6, 125.2, 165.2, 121.8, 167.4, 119]},
 {t: 'C', p: [167.4, 119, 181, 106.4, 180.8, 109]},
 {t: 'C', p: [180.8, 109, 193, 100.4, 192.4, 102.6]},
 {t: 'C', p: [192.4, 102.6, 216.8, 91.4, 214.8, 94.6]},
 {t: 'C', p: [214.8, 94.6, 236.4, 90, 235.4, 92]},
 {t: 'C', p: [235.4, 92, 254.2, 96.4, 251.4, 96.6]},
 {t: 'C', p: [251.4, 96.6, 245.6, 97.8, 252, 101.4]},
 {t: 'C', p: [252, 101.4, 248.6, 105.8, 243.2, 101.8]},
 {t: 'C', p: [237.8, 97.8, 240.8, 100, 235.8, 101]},
 {t: 'C', p: [235.8, 101, 233.2, 101.8, 228.6, 97.8]},
 {t: 'C', p: [228.6, 97.8, 223, 93.2, 214.2, 96.8]},
 {t: 'C', p: [214.2, 96.8, 183.6, 109.4, 181.6, 110]},
 {t: 'C', p: [181.6, 110, 178, 112.8, 175.6, 116.4]},
 {t: 'C', p: [175.6, 116.4, 169.8, 120.8, 166.8, 122.2]},
 {t: 'C', p: [166.8, 122.2, 154, 133.8, 152.8, 135.2]},
 {t: 'C', p: [152.8, 135.2, 149.4, 140.4, 148.6, 140.8]},
 {t: 'C', p: [148.6, 140.8, 155, 137, 157, 135]},
 {t: 'C', p: [157, 135, 171, 125, 176.4, 124.2]},
 {t: 'C', p: [176.4, 124.2, 180.8, 121.2, 181.6, 119.8]},
 {t: 'C', p: [181.6, 119.8, 196, 110.6, 200.2, 110.6]},
 {t: 'C', p: [200.2, 110.6, 209.4, 115.8, 211.8, 108.8]},
 {t: 'C', p: [211.8, 108.8, 217.6, 107, 223.2, 108.2]},
 {t: 'C', p: [223.2, 108.2, 226.4, 105.6, 225.6, 103.4]},
 {t: 'C', p: [225.6, 103.4, 227.2, 101.6, 228.2, 105.4]},
 {t: 'C', p: [228.2, 105.4, 231.6, 109, 236.4, 107]},
 {t: 'C', p: [236.4, 107, 240.4, 106.8, 238.4, 109.2]},
 {t: 'C', p: [238.4, 109.2, 234, 113, 222.2, 113.2]},
 {t: 'C', p: [222.2, 113.2, 209.8, 113.8, 193.4, 121.4]},
 {t: 'C', p: [193.4, 121.4, 163.6, 131.8, 154.4, 142.2]},
 {t: 'C', p: [154.4, 142.2, 148, 151, 142.6, 152.2]},
 {t: 'C', p: [142.6, 152.2, 136.8, 153, 130.8, 160.4]},
 {t: 'C', p: [130.8, 160.4, 140.6, 154.6, 149.6, 154.6]},
 {t: 'C', p: [149.6, 154.6, 153.6, 152.2, 149.8, 155.8]},
 {t: 'C', p: [149.8, 155.8, 146.2, 163.4, 147.8, 168.8]},
 {t: 'C', p: [147.8, 168.8, 147.2, 174, 146.4, 175.6]},
 {t: 'C', p: [146.4, 175.6, 138.6, 188.4, 138.6, 190.8]},
 {t: 'C', p: [138.6, 193.2, 139.8, 203, 140.2, 203.6]},
 {t: 'C', p: [140.6, 204.2, 139.2, 202, 143, 204.4]},
 {t: 'C', p: [146.8, 206.8, 149.6, 208.4, 150.4, 211.2]},
 {t: 'C', p: [151.2, 214, 148.4, 205.8, 148.2, 204]},
 {t: 'C', p: [148, 202.2, 143.8, 195, 144.6, 192.6]},
 {t: 'C', p: [144.6, 192.6, 145.6, 193.6, 146.4, 195]},
 {t: 'C', p: [146.4, 195, 145.8, 194.4, 146.4, 190.8]},
 {t: 'C', p: [146.4, 190.8, 147.2, 185.6, 148.6, 182.4]},
 {t: 'C', p: [150, 179.2, 152, 175.4, 152.4, 174.6]},
 {t: 'C', p: [152.8, 173.8, 152.8, 168, 154.2, 170.6]},
 {t: 'L', p: [157.6, 173.2]},
 {t: 'C', p: [157.6, 173.2, 154.8, 170.6, 157, 168.4]},
 {t: 'C', p: [157, 168.4, 156, 162.8, 157.8, 160.2]},
 {t: 'C', p: [157.8, 160.2, 164.8, 151.8, 166.4, 150.8]},
 {t: 'C', p: [168, 149.8, 166.6, 150.2, 166.6, 150.2]},
 {t: 'C', p: [166.6, 150.2, 172.6, 146, 166.8, 147.6]},
 {t: 'C', p: [166.8, 147.6, 162.8, 149.2, 159.8, 149.2]},
 {t: 'C', p: [159.8, 149.2, 152.2, 151.2, 156.2, 147]},
 {t: 'C', p: [160.2, 142.8, 170.2, 137.4, 174, 137.6]},
 {t: 'L', p: [174.8, 139.2]},
 {t: 'L', p: [186, 136.8]},
 {t: 'L', p: [184.8, 137.6]},
 {t: 'C', p: [184.8, 137.6, 184.6, 137.4, 188.8, 137]},
 {t: 'C', p: [193, 136.6, 198.8, 138, 200.2, 136.2]},
 {t: 'C', p: [201.6, 134.4, 205, 133.4, 204.6, 134.8]},
 {t: 'C', p: [204.2, 136.2, 204, 138.2, 204, 138.2]},
 {t: 'C', p: [204, 138.2, 209, 132.4, 208.4, 134.6]},
 {t: 'C', p: [207.8, 136.8, 199.6, 142, 198.2, 148.2]},
 {t: 'L', p: [208.6, 140]},
 {t: 'L', p: [212.2, 137]},
 {t: 'C', p: [212.2, 137, 215.8, 139.2, 216, 137.6]},
 {t: 'C', p: [216.2, 136, 220.8, 130.2, 222, 130.4]},
 {t: 'C', p: [223.2, 130.6, 225.2, 127.8, 225, 130.4]},
 {t: 'C', p: [224.8, 133, 232.4, 138.4, 232.4, 138.4]},
 {t: 'C', p: [232.4, 138.4, 235.6, 136.6, 237, 138]},
 {t: 'C', p: [238.4, 139.4, 242.6, 118.2, 242.6, 118.2]},
 {t: 'L', p: [267.6, 107.6]},
 {t: 'L', p: [311.201, 104.2]},
 {t: 'L', p: [294.201, 97.4]},
 {t: 'L', p: [233.2, 86]},
 {t: 'z', p: []}]},

{f: null, s: {c: '#4c0000', w: 2},
 p: [{t: 'M', p: [251.4, 285]},
 {t: 'C', p: [251.4, 285, 236.4, 268.2, 228, 265.6]},
 {t: 'C', p: [228, 265.6, 214.6, 258.8, 190, 266.6]}]},

{f: null, s: {c: '#4c0000', w: 2},
 p: [{t: 'M', p: [224.8, 264.2]},
 {t: 'C', p: [224.8, 264.2, 199.6, 256.2, 184.2, 260.4]},
 {t: 'C', p: [184.2, 260.4, 165.8, 262.4, 157.4, 276.2]}]},

{f: null, s: {c: '#4c0000', w: 2},
 p: [{t: 'M', p: [221.2, 263]},
 {t: 'C', p: [221.2, 263, 204.2, 255.8, 189.4, 253.6]},
 {t: 'C', p: [189.4, 253.6, 172.8, 251, 156.2, 258.2]},
 {t: 'C', p: [156.2, 258.2, 144, 264.2, 138.6, 274.4]}]},

{f: null, s: {c: '#4c0000', w: 2},
 p: [{t: 'M', p: [222.2, 263.4]},
 {t: 'C', p: [222.2, 263.4, 206.8, 252.4, 205.8, 251]},
 {t: 'C', p: [205.8, 251, 198.8, 240, 185.8, 239.6]},
 {t: 'C', p: [185.8, 239.6, 164.4, 240.4, 147.2, 248.4]}]},

{f: '#000', s: null, p: [{t: 'M', p: [220.895, 254.407]},
 {t: 'C', p: [222.437, 255.87, 249.4, 284.8, 249.4, 284.8]},
 {t: 'C', p: [284.6, 321.401, 256.6, 287.2, 256.6, 287.2]},
 {t: 'C', p: [249, 282.4, 239.8, 263.6, 239.8, 263.6]},
 {t: 'C', p: [238.6, 260.8, 253.8, 270.8, 253.8, 270.8]},
 {t: 'C', p: [257.8, 271.6, 271.4, 290.8, 271.4, 290.8]},
 {t: 'C', p: [264.6, 288.4, 269.4, 295.6, 269.4, 295.6]},
 {t: 'C', p: [272.2, 297.6, 292.601, 313.201, 292.601, 313.201]},
 {t: 'C', p: [296.201, 317.201, 300.201, 318.801, 300.201, 318.801]},
 {t: 'C', p: [314.201, 313.601, 307.801, 326.801, 307.801, 326.801]},
 {t: 'C', p: [310.201, 333.601, 315.801, 322.001, 315.801, 322.001]},
 {t: 'C', p: [327.001, 305.2, 310.601, 307.601, 310.601, 307.601]},
 {t: 'C', p: [280.6, 310.401, 273.8, 294.4, 273.8, 294.4]},
 {t: 'C', p: [271.4, 292, 280.2, 294.4, 280.2, 294.4]},
 {t: 'C', p: [288.601, 296.4, 273, 282, 273, 282]},
 {t: 'C', p: [275.4, 282, 284.6, 288.8, 284.6, 288.8]},
 {t: 'C', p: [295.001, 298, 297.001, 296, 297.001, 296]},
 {t: 'C', p: [315.001, 287.2, 325.401, 294.8, 325.401, 294.8]},
 {t: 'C', p: [327.401, 296.4, 321.801, 303.2, 323.401, 308.401]},
 {t: 'C', p: [325.001, 313.601, 329.801, 326.001, 329.801, 326.001]},
 {t: 'C', p: [327.401, 327.601, 327.801, 338.401, 327.801, 338.401]},
 {t: 'C', p: [344.601, 361.601, 335.001, 359.601, 335.001, 359.601]},
 {t: 'C', p: [319.401, 359.201, 334.201, 366.801, 334.201, 366.801]},
 {t: 'C', p: [337.401, 368.801, 346.201, 376.001, 346.201, 376.001]},
 {t: 'C', p: [343.401, 374.801, 341.801, 380.001, 341.801, 380.001]},
 {t: 'C', p: [346.601, 384.001, 343.801, 388.801, 343.801, 388.801]},
 {t: 'C', p: [337.801, 390.001, 336.601, 394.001, 336.601, 394.001]},
 {t: 'C', p: [343.401, 402.001, 333.401, 402.401, 333.401, 402.401]},
 {t: 'C', p: [337.001, 406.801, 332.201, 418.801, 332.201, 418.801]},
 {t: 'C', p: [327.401, 418.801, 321.001, 424.401, 321.001, 424.401]},
 {t: 'C', p: [323.401, 429.201, 313.001, 434.801, 313.001, 434.801]},
 {t: 'C', p: [304.601, 436.401, 307.401, 443.201, 307.401, 443.201]},
 {t: 'C', p: [299.401, 449.201, 297.001, 465.201, 297.001, 465.201]},
 {t: 'C', p: [296.201, 475.601, 293.801, 478.801, 299.001, 476.801]},
 {t: 'C', p: [304.201, 474.801, 303.401, 462.401, 303.401, 462.401]},
 {t: 'C', p: [298.601, 446.801, 341.401, 430.801, 341.401, 430.801]},
 {t: 'C', p: [345.401, 429.201, 346.201, 424.001, 346.201, 424.001]},
 {t: 'C', p: [348.201, 424.401, 357.001, 432.001, 357.001, 432.001]},
 {t: 'C', p: [364.601, 443.201, 365.001, 434.001, 365.001, 434.001]},
 {t: 'C', p: [366.201, 430.401, 364.601, 424.401, 364.601, 424.401]},
 {t: 'C', p: [370.601, 402.801, 356.601, 396.401, 356.601, 396.401]},
 {t: 'C', p: [346.601, 362.801, 360.601, 371.201, 360.601, 371.201]},
 {t: 'C', p: [363.401, 376.801, 374.201, 382.001, 374.201, 382.001]},
 {t: 'L', p: [377.801, 379.601]},
 {t: 'C', p: [376.201, 374.801, 384.601, 368.801, 384.601, 368.801]},
 {t: 'C', p: [387.401, 375.201, 393.401, 367.201, 393.401, 367.201]},
 {t: 'C', p: [397.001, 342.801, 409.401, 357.201, 409.401, 357.201]},
 {t: 'C', p: [413.401, 358.401, 414.601, 351.601, 414.601, 351.601]},
 {t: 'C', p: [418.201, 341.201, 414.601, 327.601, 414.601, 327.601]},
 {t: 'C', p: [418.201, 327.201, 427.801, 333.201, 427.801, 333.201]},
 {t: 'C', p: [430.601, 329.601, 421.401, 312.801, 425.401, 315.201]},
 {t: 'C', p: [429.401, 317.601, 433.801, 319.201, 433.801, 319.201]},
 {t: 'C', p: [434.601, 317.201, 424.601, 304.801, 424.601, 304.801]},
 {t: 'C', p: [420.201, 302, 415.001, 281.6, 415.001, 281.6]},
 {t: 'C', p: [422.201, 285.2, 412.201, 270, 412.201, 270]},
 {t: 'C', p: [412.201, 266.8, 418.201, 255.6, 418.201, 255.6]},
 {t: 'C', p: [417.401, 248.8, 418.201, 249.2, 418.201, 249.2]},
 {t: 'C', p: [421.001, 250.4, 429.001, 252, 422.201, 245.6]},
 {t: 'C', p: [415.401, 239.2, 423.001, 234.4, 423.001, 234.4]},
 {t: 'C', p: [427.401, 231.6, 413.801, 232, 413.801, 232]},
 {t: 'C', p: [408.601, 227.6, 409.001, 223.6, 409.001, 223.6]},
 {t: 'C', p: [417.001, 225.6, 402.601, 211.2, 400.201, 207.6]},
 {t: 'C', p: [397.801, 204, 407.401, 198.8, 407.401, 198.8]},
 {t: 'C', p: [420.601, 195.2, 409.001, 192, 409.001, 192]},
 {t: 'C', p: [389.401, 192.4, 400.201, 181.6, 400.201, 181.6]},
 {t: 'C', p: [406.201, 182, 404.601, 179.6, 404.601, 179.6]},
 {t: 'C', p: [399.401, 178.4, 389.801, 172, 389.801, 172]},
 {t: 'C', p: [385.801, 168.4, 389.401, 169.2, 389.401, 169.2]},
 {t: 'C', p: [406.201, 170.4, 377.401, 159.2, 377.401, 159.2]},
 {t: 'C', p: [385.401, 159.2, 367.401, 148.8, 367.401, 148.8]},
 {t: 'C', p: [365.401, 147.2, 362.201, 139.6, 362.201, 139.6]},
 {t: 'C', p: [356.201, 134.4, 351.401, 127.6, 351.401, 127.6]},
 {t: 'C', p: [351.001, 123.2, 346.201, 118.4, 346.201, 118.4]},
 {t: 'C', p: [334.601, 104.8, 329.001, 105.2, 329.001, 105.2]},
 {t: 'C', p: [314.201, 101.6, 309.001, 102.4, 309.001, 102.4]},
 {t: 'L', p: [256.2, 106.8]},
 {t: 'C', p: [229.8, 119.6, 237.6, 140.6, 237.6, 140.6]},
 {t: 'C', p: [244, 149, 253.2, 145.2, 253.2, 145.2]},
 {t: 'C', p: [257.8, 139, 269.4, 141.2, 269.4, 141.2]},
 {t: 'C', p: [289.801, 144.4, 287.201, 140.8, 287.201, 140.8]},
 {t: 'C', p: [284.801, 136.2, 268.6, 130, 268.4, 129.4]},
 {t: 'C', p: [268.2, 128.8, 259.4, 125.4, 259.4, 125.4]},
 {t: 'C', p: [256.4, 124.2, 252, 115, 252, 115]},
 {t: 'C', p: [248.8, 111.6, 264.6, 117.4, 264.6, 117.4]},
 {t: 'C', p: [263.4, 118.4, 270.8, 122.4, 270.8, 122.4]},
 {t: 'C', p: [288.201, 121.4, 298.801, 132.2, 298.801, 132.2]},
 {t: 'C', p: [309.601, 148.8, 309.801, 140.6, 309.801, 140.6]},
 {t: 'C', p: [312.601, 131.2, 300.801, 110, 300.801, 110]},
 {t: 'C', p: [301.201, 108, 309.401, 114.6, 309.401, 114.6]},
 {t: 'C', p: [310.801, 112.6, 311.601, 118.4, 311.601, 118.4]},
 {t: 'C', p: [311.801, 120.8, 315.601, 128.8, 315.601, 128.8]},
 {t: 'C', p: [318.401, 141.8, 322.001, 134.4, 322.001, 134.4]},
 {t: 'L', p: [326.601, 143.8]},
 {t: 'C', p: [328.001, 146.4, 322.001, 154, 322.001, 154]},
 {t: 'C', p: [321.801, 156.8, 322.601, 156.6, 317.001, 164.2]},
 {t: 'C', p: [311.401, 171.8, 314.801, 176.2, 314.801, 176.2]},
 {t: 'C', p: [313.401, 182.8, 322.201, 182.4, 322.201, 182.4]},
 {t: 'C', p: [324.801, 184.6, 328.201, 184.6, 328.201, 184.6]},
 {t: 'C', p: [330.001, 186.6, 332.401, 186, 332.401, 186]},
 {t: 'C', p: [334.001, 182.2, 340.201, 184.2, 340.201, 184.2]},
 {t: 'C', p: [341.601, 181.8, 349.801, 181.4, 349.801, 181.4]},
 {t: 'C', p: [350.801, 178.8, 351.201, 177.2, 354.601, 176.6]},
 {t: 'C', p: [358.001, 176, 333.401, 133, 333.401, 133]},
 {t: 'C', p: [339.801, 132.2, 331.601, 119.8, 331.601, 119.8]},
 {t: 'C', p: [329.401, 113.2, 340.801, 127.8, 343.001, 129.2]},
 {t: 'C', p: [345.201, 130.6, 346.201, 132.8, 344.601, 132.6]},
 {t: 'C', p: [343.001, 132.4, 341.201, 134.6, 342.601, 134.8]},
 {t: 'C', p: [344.001, 135, 357.001, 150, 360.401, 160.2]},
 {t: 'C', p: [363.801, 170.4, 369.801, 174.4, 376.001, 180.4]},
 {t: 'C', p: [382.201, 186.4, 381.401, 210.6, 381.401, 210.6]},
 {t: 'C', p: [381.001, 219.4, 387.001, 230, 387.001, 230]},
 {t: 'C', p: [389.001, 233.8, 384.801, 252, 384.801, 252]},
 {t: 'C', p: [382.801, 254.2, 384.201, 255, 384.201, 255]},
 {t: 'C', p: [385.201, 256.2, 392.001, 269.4, 392.001, 269.4]},
 {t: 'C', p: [390.201, 269.2, 393.801, 272.8, 393.801, 272.8]},
 {t: 'C', p: [399.001, 278.8, 392.601, 275.8, 392.601, 275.8]},
 {t: 'C', p: [386.601, 274.2, 393.601, 284, 393.601, 284]},
 {t: 'C', p: [394.801, 285.8, 385.801, 281.2, 385.801, 281.2]},
 {t: 'C', p: [376.601, 280.6, 388.201, 287.8, 388.201, 287.8]},
 {t: 'C', p: [396.801, 295, 385.401, 290.6, 385.401, 290.6]},
 {t: 'C', p: [380.801, 288.8, 384.001, 295.6, 384.001, 295.6]},
 {t: 'C', p: [387.201, 297.2, 404.401, 304.2, 404.401, 304.2]},
 {t: 'C', p: [404.801, 308.001, 401.801, 313.001, 401.801, 313.001]},
 {t: 'C', p: [402.201, 317.001, 400.001, 320.401, 400.001, 320.401]},
 {t: 'C', p: [398.801, 328.601, 398.201, 329.401, 398.201, 329.401]},
 {t: 'C', p: [394.001, 329.601, 386.601, 343.401, 386.601, 343.401]},
 {t: 'C', p: [384.801, 346.001, 374.601, 358.001, 374.601, 358.001]},
 {t: 'C', p: [372.601, 365.001, 354.601, 357.801, 354.601, 357.801]},
 {t: 'C', p: [348.001, 361.201, 350.001, 357.801, 350.001, 357.801]},
 {t: 'C', p: [349.601, 355.601, 354.401, 349.601, 354.401, 349.601]},
 {t: 'C', p: [361.401, 347.001, 358.801, 336.201, 358.801, 336.201]},
 {t: 'C', p: [362.801, 334.801, 351.601, 332.001, 351.801, 330.801]},
 {t: 'C', p: [352.001, 329.601, 357.801, 328.201, 357.801, 328.201]},
 {t: 'C', p: [365.801, 326.201, 361.401, 323.801, 361.401, 323.801]},
 {t: 'C', p: [360.801, 319.801, 363.801, 314.201, 363.801, 314.201]},
 {t: 'C', p: [375.401, 313.401, 363.801, 297.2, 363.801, 297.2]},
 {t: 'C', p: [353.001, 289.6, 352.001, 283.8, 352.001, 283.8]},
 {t: 'C', p: [364.601, 275.6, 356.401, 263.2, 356.601, 259.6]},
 {t: 'C', p: [356.801, 256, 358.001, 234.4, 358.001, 234.4]},
 {t: 'C', p: [356.001, 228.2, 353.001, 214.6, 353.001, 214.6]},
 {t: 'C', p: [355.201, 209.4, 362.601, 196.8, 362.601, 196.8]},
 {t: 'C', p: [365.401, 192.6, 374.201, 187.8, 372.001, 184.8]},
 {t: 'C', p: [369.801, 181.8, 362.001, 183.6, 362.001, 183.6]},
 {t: 'C', p: [354.201, 182.2, 354.801, 187.4, 354.801, 187.4]},
 {t: 'C', p: [353.201, 188.4, 352.401, 193.4, 352.401, 193.4]},
 {t: 'C', p: [351.68, 201.333, 342.801, 207.6, 342.801, 207.6]},
 {t: 'C', p: [331.601, 213.8, 340.801, 217.8, 340.801, 217.8]},
 {t: 'C', p: [346.801, 224.4, 337.001, 224.6, 337.001, 224.6]},
 {t: 'C', p: [326.001, 222.8, 334.201, 233, 334.201, 233]},
 {t: 'C', p: [345.001, 245.8, 342.001, 248.6, 342.001, 248.6]},
 {t: 'C', p: [331.801, 249.6, 344.401, 258.8, 344.401, 258.8]},
 {t: 'C', p: [344.401, 258.8, 343.601, 256.8, 343.801, 258.6]},
 {t: 'C', p: [344.001, 260.4, 347.001, 264.6, 347.801, 266.6]},
 {t: 'C', p: [348.601, 268.6, 344.601, 268.8, 344.601, 268.8]},
 {t: 'C', p: [345.201, 278.4, 329.801, 274.2, 329.801, 274.2]},
 {t: 'C', p: [329.801, 274.2, 329.801, 274.2, 328.201, 274.4]},
 {t: 'C', p: [326.601, 274.6, 315.401, 273.8, 309.601, 271.6]},
 {t: 'C', p: [303.801, 269.4, 297.001, 269.4, 297.001, 269.4]},
 {t: 'C', p: [297.001, 269.4, 293.001, 271.2, 285.4, 271]},
 {t: 'C', p: [277.8, 270.8, 269.8, 273.6, 269.8, 273.6]},
 {t: 'C', p: [265.4, 273.2, 274, 268.8, 274.2, 269]},
 {t: 'C', p: [274.4, 269.2, 280, 263.6, 272, 264.2]},
 {t: 'C', p: [250.203, 265.835, 239.4, 255.6, 239.4, 255.6]},
 {t: 'C', p: [237.4, 254.2, 234.8, 251.4, 234.8, 251.4]},
 {t: 'C', p: [224.8, 249.4, 236.2, 263.8, 236.2, 263.8]},
 {t: 'C', p: [237.4, 265.2, 236, 266.2, 236, 266.2]},
 {t: 'C', p: [235.2, 264.6, 227.4, 259.2, 227.4, 259.2]},
 {t: 'C', p: [224.589, 258.227, 223.226, 256.893, 220.895, 254.407]},
 {t: 'z', p: []}]},

{f: '#4c0000', s: null, p: [{t: 'M', p: [197, 242.8]},
 {t: 'C', p: [197, 242.8, 208.6, 248.4, 211.2, 251.2]},
 {t: 'C', p: [213.8, 254, 227.8, 265.4, 227.8, 265.4]},
 {t: 'C', p: [227.8, 265.4, 222.4, 263.4, 219.8, 261.6]},
 {t: 'C', p: [217.2, 259.8, 206.4, 251.6, 206.4, 251.6]},
 {t: 'C', p: [206.4, 251.6, 202.6, 245.6, 197, 242.8]},
 {t: 'z', p: []}]},

{f: '#99cc32', s: null, p: [{t: 'M', p: [138.991, 211.603]},
 {t: 'C', p: [139.328, 211.455, 138.804, 208.743, 138.6, 208.2]},
 {t: 'C', p: [137.578, 205.474, 128.6, 204, 128.6, 204]},
 {t: 'C', p: [128.373, 205.365, 128.318, 206.961, 128.424, 208.599]},
 {t: 'C', p: [128.424, 208.599, 133.292, 214.118, 138.991, 211.603]},
 {t: 'z', p: []}]},

{f: '#659900', s: null, p: [{t: 'M', p: [138.991, 211.403]},
 {t: 'C', p: [138.542, 211.561, 138.976, 208.669, 138.8, 208.2]},
 {t: 'C', p: [137.778, 205.474, 128.6, 203.9, 128.6, 203.9]},
 {t: 'C', p: [128.373, 205.265, 128.318, 206.861, 128.424, 208.499]},
 {t: 'C', p: [128.424, 208.499, 132.692, 213.618, 138.991, 211.403]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [134.6, 211.546]},
 {t: 'C', p: [133.975, 211.546, 133.469, 210.406, 133.469, 209]},
 {t: 'C', p: [133.469, 207.595, 133.975, 206.455, 134.6, 206.455]},
 {t: 'C', p: [135.225, 206.455, 135.732, 207.595, 135.732, 209]},
 {t: 'C', p: [135.732, 210.406, 135.225, 211.546, 134.6, 211.546]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [134.6, 209]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [89, 309.601]},
 {t: 'C', p: [89, 309.601, 83.4, 319.601, 108.2, 313.601]},
 {t: 'C', p: [108.2, 313.601, 122.2, 312.401, 124.6, 310.001]},
 {t: 'C', p: [125.8, 310.801, 134.166, 313.734, 137, 314.401]},
 {t: 'C', p: [143.8, 316.001, 152.2, 306, 152.2, 306]},
 {t: 'C', p: [152.2, 306, 156.8, 295.5, 159.6, 295.5]},
 {t: 'C', p: [162.4, 295.5, 159.2, 297.1, 159.2, 297.1]},
 {t: 'C', p: [159.2, 297.1, 152.6, 307.201, 153, 308.801]},
 {t: 'C', p: [153, 308.801, 147.8, 328.801, 131.8, 329.601]},
 {t: 'C', p: [131.8, 329.601, 115.65, 330.551, 117, 336.401]},
 {t: 'C', p: [117, 336.401, 125.8, 334.001, 128.2, 336.401]},
 {t: 'C', p: [128.2, 336.401, 139, 336.001, 131, 342.401]},
 {t: 'L', p: [124.2, 354.001]},
 {t: 'C', p: [124.2, 354.001, 124.34, 357.919, 114.2, 354.401]},
 {t: 'C', p: [104.4, 351.001, 94.1, 338.101, 94.1, 338.101]},
 {t: 'C', p: [94.1, 338.101, 78.15, 323.551, 89, 309.601]},
 {t: 'z', p: []}]},

{f: '#e59999', s: null, p: [{t: 'M', p: [87.8, 313.601]},
 {t: 'C', p: [87.8, 313.601, 85.8, 323.201, 122.6, 312.801]},
 {t: 'C', p: [122.6, 312.801, 127, 312.801, 129.4, 313.601]},
 {t: 'C', p: [131.8, 314.401, 143.8, 317.201, 145.8, 316.001]},
 {t: 'C', p: [145.8, 316.001, 138.6, 329.601, 127, 328.001]},
 {t: 'C', p: [127, 328.001, 113.8, 329.601, 114.2, 334.401]},
 {t: 'C', p: [114.2, 334.401, 118.2, 341.601, 123, 344.001]},
 {t: 'C', p: [123, 344.001, 125.8, 346.401, 125.4, 349.601]},
 {t: 'C', p: [125, 352.801, 122.2, 354.401, 120.2, 355.201]},
 {t: 'C', p: [118.2, 356.001, 115, 352.801, 113.4, 352.801]},
 {t: 'C', p: [111.8, 352.801, 103.4, 346.401, 99, 341.601]},
 {t: 'C', p: [94.6, 336.801, 86.2, 324.801, 86.6, 322.001]},
 {t: 'C', p: [87, 319.201, 87.8, 313.601, 87.8, 313.601]},
 {t: 'z', p: []}]},

{f: '#b26565', s: null, p: [{t: 'M', p: [91, 331.051]},
 {t: 'C', p: [93.6, 335.001, 96.8, 339.201, 99, 341.601]},
 {t: 'C', p: [103.4, 346.401, 111.8, 352.801, 113.4, 352.801]},
 {t: 'C', p: [115, 352.801, 118.2, 356.001, 120.2, 355.201]},
 {t: 'C', p: [122.2, 354.401, 125, 352.801, 125.4, 349.601]},
 {t: 'C', p: [125.8, 346.401, 123, 344.001, 123, 344.001]},
 {t: 'C', p: [119.934, 342.468, 117.194, 338.976, 115.615, 336.653]},
 {t: 'C', p: [115.615, 336.653, 115.8, 339.201, 110.6, 338.401]},
 {t: 'C', p: [105.4, 337.601, 100.2, 334.801, 98.6, 331.601]},
 {t: 'C', p: [97, 328.401, 94.6, 326.001, 96.2, 329.601]},
 {t: 'C', p: [97.8, 333.201, 100.2, 336.801, 101.8, 337.201]},
 {t: 'C', p: [103.4, 337.601, 103, 338.801, 100.6, 338.401]},
 {t: 'C', p: [98.2, 338.001, 95.4, 337.601, 91, 332.401]},
 {t: 'z', p: []}]},

{f: '#992600', s: null, p: [{t: 'M', p: [88.4, 310.001]},
 {t: 'C', p: [88.4, 310.001, 90.2, 296.4, 91.4, 292.4]},
 {t: 'C', p: [91.4, 292.4, 90.6, 285.6, 93, 281.4]},
 {t: 'C', p: [95.4, 277.2, 97.4, 271, 100.4, 265.6]},
 {t: 'C', p: [103.4, 260.2, 103.6, 256.2, 107.6, 254.6]},
 {t: 'C', p: [111.6, 253, 117.6, 244.4, 120.4, 243.4]},
 {t: 'C', p: [123.2, 242.4, 123, 243.2, 123, 243.2]},
 {t: 'C', p: [123, 243.2, 129.8, 228.4, 143.4, 232.4]},
 {t: 'C', p: [143.4, 232.4, 127.2, 229.6, 143, 220.2]},
 {t: 'C', p: [143, 220.2, 138.2, 221.3, 141.5, 214.3]},
 {t: 'C', p: [143.701, 209.632, 143.2, 216.4, 132.2, 228.2]},
 {t: 'C', p: [132.2, 228.2, 127.2, 236.8, 122, 239.8]},
 {t: 'C', p: [116.8, 242.8, 104.8, 249.8, 103.6, 253.6]},
 {t: 'C', p: [102.4, 257.4, 99.2, 263.2, 97.2, 264.8]},
 {t: 'C', p: [95.2, 266.4, 92.4, 270.6, 92, 274]},
 {t: 'C', p: [92, 274, 90.8, 278, 89.4, 279.2]},
 {t: 'C', p: [88, 280.4, 87.8, 283.6, 87.8, 285.6]},
 {t: 'C', p: [87.8, 287.6, 85.8, 290.4, 86, 292.8]},
 {t: 'C', p: [86, 292.8, 86.8, 311.801, 86.4, 313.801]},
 {t: 'L', p: [88.4, 310.001]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [79.8, 314.601]},
 {t: 'C', p: [79.8, 314.601, 77.8, 313.201, 73.4, 319.201]},
 {t: 'C', p: [73.4, 319.201, 80.7, 352.201, 80.7, 353.601]},
 {t: 'C', p: [80.7, 353.601, 81.8, 351.501, 80.5, 344.301]},
 {t: 'C', p: [79.2, 337.101, 78.3, 324.401, 78.3, 324.401]},
 {t: 'L', p: [79.8, 314.601]},
 {t: 'z', p: []}]},

{f: '#992600', s: null, p: [{t: 'M', p: [101.4, 254]},
 {t: 'C', p: [101.4, 254, 83.8, 257.2, 84.2, 286.4]},
 {t: 'L', p: [83.4, 311.201]},
 {t: 'C', p: [83.4, 311.201, 82.2, 285.6, 81, 284]},
 {t: 'C', p: [79.8, 282.4, 83.8, 271.2, 80.6, 277.2]},
 {t: 'C', p: [80.6, 277.2, 66.6, 291.2, 74.6, 312.401]},
 {t: 'C', p: [74.6, 312.401, 76.1, 315.701, 73.1, 311.101]},
 {t: 'C', p: [73.1, 311.101, 68.5, 298.5, 69.6, 292.1]},
 {t: 'C', p: [69.6, 292.1, 69.8, 289.9, 71.7, 287.1]},
 {t: 'C', p: [71.7, 287.1, 80.3, 275.4, 83, 273.1]},
 {t: 'C', p: [83, 273.1, 84.8, 258.7, 100.2, 253.5]},
 {t: 'C', p: [100.2, 253.5, 105.9, 251.2, 101.4, 254]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [240.8, 187.8]},
 {t: 'C', p: [241.46, 187.446, 241.451, 186.476, 242.031, 186.303]},
 {t: 'C', p: [243.18, 185.959, 243.344, 184.892, 243.862, 184.108]},
 {t: 'C', p: [244.735, 182.789, 244.928, 181.256, 245.51, 179.765]},
 {t: 'C', p: [245.782, 179.065, 245.809, 178.11, 245.496, 177.45]},
 {t: 'C', p: [244.322, 174.969, 243.62, 172.52, 242.178, 170.094]},
 {t: 'C', p: [241.91, 169.644, 241.648, 168.85, 241.447, 168.252]},
 {t: 'C', p: [240.984, 166.868, 239.727, 165.877, 238.867, 164.557]},
 {t: 'C', p: [238.579, 164.116, 239.104, 163.191, 238.388, 163.107]},
 {t: 'C', p: [237.491, 163.002, 236.042, 162.422, 235.809, 163.448]},
 {t: 'C', p: [235.221, 166.035, 236.232, 168.558, 237.2, 171]},
 {t: 'C', p: [236.418, 171.692, 236.752, 172.613, 236.904, 173.38]},
 {t: 'C', p: [237.614, 176.986, 236.416, 180.338, 235.655, 183.812]},
 {t: 'C', p: [235.632, 183.916, 235.974, 184.114, 235.946, 184.176]},
 {t: 'C', p: [234.724, 186.862, 233.272, 189.307, 231.453, 191.688]},
 {t: 'C', p: [230.695, 192.68, 229.823, 193.596, 229.326, 194.659]},
 {t: 'C', p: [228.958, 195.446, 228.55, 196.412, 228.8, 197.4]},
 {t: 'C', p: [225.365, 200.18, 223.115, 204.025, 220.504, 207.871]},
 {t: 'C', p: [220.042, 208.551, 220.333, 209.76, 220.884, 210.029]},
 {t: 'C', p: [221.697, 210.427, 222.653, 209.403, 223.123, 208.557]},
 {t: 'C', p: [223.512, 207.859, 223.865, 207.209, 224.356, 206.566]},
 {t: 'C', p: [224.489, 206.391, 224.31, 205.972, 224.445, 205.851]},
 {t: 'C', p: [227.078, 203.504, 228.747, 200.568, 231.2, 198.2]},
 {t: 'C', p: [233.15, 197.871, 234.687, 196.873, 236.435, 195.86]},
 {t: 'C', p: [236.743, 195.681, 237.267, 195.93, 237.557, 195.735]},
 {t: 'C', p: [239.31, 194.558, 239.308, 192.522, 239.414, 190.612]},
 {t: 'C', p: [239.464, 189.728, 239.66, 188.411, 240.8, 187.8]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [231.959, 183.334]},
 {t: 'C', p: [232.083, 183.257, 231.928, 182.834, 232.037, 182.618]},
 {t: 'C', p: [232.199, 182.294, 232.602, 182.106, 232.764, 181.782]},
 {t: 'C', p: [232.873, 181.566, 232.71, 181.186, 232.846, 181.044]},
 {t: 'C', p: [235.179, 178.597, 235.436, 175.573, 234.4, 172.6]},
 {t: 'C', p: [235.424, 171.98, 235.485, 170.718, 235.06, 169.871]},
 {t: 'C', p: [234.207, 168.171, 234.014, 166.245, 233.039, 164.702]},
 {t: 'C', p: [232.237, 163.433, 230.659, 162.189, 229.288, 163.492]},
 {t: 'C', p: [228.867, 163.892, 228.546, 164.679, 228.824, 165.391]},
 {t: 'C', p: [228.888, 165.554, 229.173, 165.7, 229.146, 165.782]},
 {t: 'C', p: [229.039, 166.106, 228.493, 166.33, 228.487, 166.602]},
 {t: 'C', p: [228.457, 168.098, 227.503, 169.609, 228.133, 170.938]},
 {t: 'C', p: [228.905, 172.567, 229.724, 174.424, 230.4, 176.2]},
 {t: 'C', p: [229.166, 178.316, 230.199, 180.765, 228.446, 182.642]},
 {t: 'C', p: [228.31, 182.788, 228.319, 183.174, 228.441, 183.376]},
 {t: 'C', p: [228.733, 183.862, 229.139, 184.268, 229.625, 184.56]},
 {t: 'C', p: [229.827, 184.681, 230.175, 184.683, 230.375, 184.559]},
 {t: 'C', p: [230.953, 184.197, 231.351, 183.71, 231.959, 183.334]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [294.771, 173.023]},
 {t: 'C', p: [296.16, 174.815, 296.45, 177.61, 294.401, 179]},
 {t: 'C', p: [294.951, 182.309, 298.302, 180.33, 300.401, 179.8]},
 {t: 'C', p: [300.292, 179.412, 300.519, 179.068, 300.802, 179.063]},
 {t: 'C', p: [301.859, 179.048, 302.539, 178.016, 303.601, 178.2]},
 {t: 'C', p: [304.035, 176.643, 305.673, 175.941, 306.317, 174.561]},
 {t: 'C', p: [308.043, 170.866, 307.452, 166.593, 304.868, 163.347]},
 {t: 'C', p: [304.666, 163.093, 304.883, 162.576, 304.759, 162.214]},
 {t: 'C', p: [304.003, 160.003, 301.935, 159.688, 300.001, 159]},
 {t: 'C', p: [298.824, 155.125, 298.163, 151.094, 296.401, 147.4]},
 {t: 'C', p: [294.787, 147.15, 294.089, 145.411, 292.752, 144.691]},
 {t: 'C', p: [291.419, 143.972, 290.851, 145.551, 290.892, 146.597]},
 {t: 'C', p: [290.899, 146.802, 291.351, 147.026, 291.181, 147.391]},
 {t: 'C', p: [291.105, 147.555, 290.845, 147.666, 290.845, 147.8]},
 {t: 'C', p: [290.846, 147.935, 291.067, 148.066, 291.201, 148.2]},
 {t: 'C', p: [290.283, 149.02, 288.86, 149.497, 288.565, 150.642]},
 {t: 'C', p: [287.611, 154.352, 290.184, 157.477, 291.852, 160.678]},
 {t: 'C', p: [292.443, 161.813, 291.707, 163.084, 290.947, 164.292]},
 {t: 'C', p: [290.509, 164.987, 290.617, 166.114, 290.893, 166.97]},
 {t: 'C', p: [291.645, 169.301, 293.236, 171.04, 294.771, 173.023]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [257.611, 191.409]},
 {t: 'C', p: [256.124, 193.26, 252.712, 195.829, 255.629, 197.757]},
 {t: 'C', p: [255.823, 197.886, 256.193, 197.89, 256.366, 197.756]},
 {t: 'C', p: [258.387, 196.191, 260.39, 195.288, 262.826, 194.706]},
 {t: 'C', p: [262.95, 194.677, 263.224, 195.144, 263.593, 194.983]},
 {t: 'C', p: [265.206, 194.28, 267.216, 194.338, 268.4, 193]},
 {t: 'C', p: [272.167, 193.224, 275.732, 192.108, 279.123, 190.8]},
 {t: 'C', p: [280.284, 190.352, 281.554, 189.793, 282.755, 189.291]},
 {t: 'C', p: [284.131, 188.715, 285.335, 187.787, 286.447, 186.646]},
 {t: 'C', p: [286.58, 186.51, 286.934, 186.6, 287.201, 186.6]},
 {t: 'C', p: [287.161, 185.737, 288.123, 185.61, 288.37, 184.988]},
 {t: 'C', p: [288.462, 184.756, 288.312, 184.36, 288.445, 184.258]},
 {t: 'C', p: [290.583, 182.628, 291.503, 180.61, 290.334, 178.233]},
 {t: 'C', p: [290.049, 177.655, 289.8, 177.037, 289.234, 176.561]},
 {t: 'C', p: [288.149, 175.65, 287.047, 176.504, 286, 176.2]},
 {t: 'C', p: [285.841, 176.828, 285.112, 176.656, 284.726, 176.854]},
 {t: 'C', p: [283.867, 177.293, 282.534, 176.708, 281.675, 177.146]},
 {t: 'C', p: [280.313, 177.841, 279.072, 178.01, 277.65, 178.387]},
 {t: 'C', p: [277.338, 178.469, 276.56, 178.373, 276.4, 179]},
 {t: 'C', p: [276.266, 178.866, 276.118, 178.632, 276.012, 178.654]},
 {t: 'C', p: [274.104, 179.05, 272.844, 179.264, 271.543, 180.956]},
 {t: 'C', p: [271.44, 181.089, 270.998, 180.91, 270.839, 181.045]},
 {t: 'C', p: [269.882, 181.853, 269.477, 183.087, 268.376, 183.759]},
 {t: 'C', p: [268.175, 183.882, 267.823, 183.714, 267.629, 183.843]},
 {t: 'C', p: [266.983, 184.274, 266.616, 184.915, 265.974, 185.362]},
 {t: 'C', p: [265.645, 185.591, 265.245, 185.266, 265.277, 185.01]},
 {t: 'C', p: [265.522, 183.063, 266.175, 181.276, 265.6, 179.4]},
 {t: 'C', p: [267.677, 176.88, 270.194, 174.931, 272, 172.2]},
 {t: 'C', p: [272.015, 170.034, 272.707, 167.888, 272.594, 165.811]},
 {t: 'C', p: [272.584, 165.618, 272.296, 164.885, 272.17, 164.538]},
 {t: 'C', p: [271.858, 163.684, 272.764, 162.618, 271.92, 161.894]},
 {t: 'C', p: [270.516, 160.691, 269.224, 161.567, 268.4, 163]},
 {t: 'C', p: [266.562, 163.39, 264.496, 164.083, 262.918, 162.849]},
 {t: 'C', p: [261.911, 162.062, 261.333, 161.156, 260.534, 160.1]},
 {t: 'C', p: [259.549, 158.798, 259.884, 157.362, 259.954, 155.798]},
 {t: 'C', p: [259.96, 155.67, 259.645, 155.534, 259.645, 155.4]},
 {t: 'C', p: [259.646, 155.265, 259.866, 155.134, 260, 155]},
 {t: 'C', p: [259.294, 154.374, 259.019, 153.316, 258, 153]},
 {t: 'C', p: [258.305, 151.908, 257.629, 151.024, 256.758, 150.722]},
 {t: 'C', p: [254.763, 150.031, 253.086, 151.943, 251.194, 152.016]},
 {t: 'C', p: [250.68, 152.035, 250.213, 150.997, 249.564, 150.672]},
 {t: 'C', p: [249.132, 150.456, 248.428, 150.423, 248.066, 150.689]},
 {t: 'C', p: [247.378, 151.193, 246.789, 151.307, 246.031, 151.512]},
 {t: 'C', p: [244.414, 151.948, 243.136, 153.042, 241.656, 153.897]},
 {t: 'C', p: [240.171, 154.754, 239.216, 156.191, 238.136, 157.511]},
 {t: 'C', p: [237.195, 158.663, 237.059, 161.077, 238.479, 161.577]},
 {t: 'C', p: [240.322, 162.227, 241.626, 159.524, 243.592, 159.85]},
 {t: 'C', p: [243.904, 159.901, 244.11, 160.212, 244, 160.6]},
 {t: 'C', p: [244.389, 160.709, 244.607, 160.48, 244.8, 160.2]},
 {t: 'C', p: [245.658, 161.219, 246.822, 161.556, 247.76, 162.429]},
 {t: 'C', p: [248.73, 163.333, 250.476, 162.915, 251.491, 163.912]},
 {t: 'C', p: [253.02, 165.414, 252.461, 168.095, 254.4, 169.4]},
 {t: 'C', p: [253.814, 170.713, 253.207, 171.99, 252.872, 173.417]},
 {t: 'C', p: [252.59, 174.623, 253.584, 175.82, 254.795, 175.729]},
 {t: 'C', p: [256.053, 175.635, 256.315, 174.876, 256.8, 173.8]},
 {t: 'C', p: [257.067, 174.067, 257.536, 174.364, 257.495, 174.58]},
 {t: 'C', p: [257.038, 176.967, 256.011, 178.96, 255.553, 181.391]},
 {t: 'C', p: [255.494, 181.708, 255.189, 181.91, 254.8, 181.8]},
 {t: 'C', p: [254.332, 185.949, 250.28, 188.343, 247.735, 191.508]},
 {t: 'C', p: [247.332, 192.01, 247.328, 193.259, 247.737, 193.662]},
 {t: 'C', p: [249.14, 195.049, 251.1, 193.503, 252.8, 193]},
 {t: 'C', p: [253.013, 191.794, 253.872, 190.852, 255.204, 190.908]},
 {t: 'C', p: [255.46, 190.918, 255.695, 190.376, 256.019, 190.246]},
 {t: 'C', p: [256.367, 190.108, 256.869, 190.332, 257.155, 190.134]},
 {t: 'C', p: [258.884, 188.939, 260.292, 187.833, 262.03, 186.644]},
 {t: 'C', p: [262.222, 186.513, 262.566, 186.672, 262.782, 186.564]},
 {t: 'C', p: [263.107, 186.402, 263.294, 186.015, 263.617, 185.83]},
 {t: 'C', p: [263.965, 185.63, 264.207, 185.92, 264.4, 186.2]},
 {t: 'C', p: [263.754, 186.549, 263.75, 187.506, 263.168, 187.708]},
 {t: 'C', p: [262.393, 187.976, 261.832, 188.489, 261.158, 188.936]},
 {t: 'C', p: [260.866, 189.129, 260.207, 188.881, 260.103, 189.06]},
 {t: 'C', p: [259.505, 190.088, 258.321, 190.526, 257.611, 191.409]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [202.2, 142]},
 {t: 'C', p: [202.2, 142, 192.962, 139.128, 181.8, 164.8]},
 {t: 'C', p: [181.8, 164.8, 179.4, 170, 177, 172]},
 {t: 'C', p: [174.6, 174, 163.4, 177.6, 161.4, 181.6]},
 {t: 'L', p: [151, 197.6]},
 {t: 'C', p: [151, 197.6, 165.8, 181.6, 169, 179.2]},
 {t: 'C', p: [169, 179.2, 177, 170.8, 173.8, 177.6]},
 {t: 'C', p: [173.8, 177.6, 159.8, 188.4, 161, 197.6]},
 {t: 'C', p: [161, 197.6, 155.4, 212, 154.6, 214]},
 {t: 'C', p: [154.6, 214, 170.6, 182, 173, 180.8]},
 {t: 'C', p: [175.4, 179.6, 176.6, 179.6, 175.4, 183.2]},
 {t: 'C', p: [174.2, 186.8, 173.8, 203.2, 171, 205.2]},
 {t: 'C', p: [171, 205.2, 179, 184.8, 178.2, 181.6]},
 {t: 'C', p: [178.2, 181.6, 181.4, 178, 183.8, 183.2]},
 {t: 'L', p: [182.6, 199.2]},
 {t: 'L', p: [187, 211.2]},
 {t: 'C', p: [187, 211.2, 184.6, 200, 186.2, 184.4]},
 {t: 'C', p: [186.2, 184.4, 184.2, 174, 188.2, 179.6]},
 {t: 'C', p: [192.2, 185.2, 201.8, 191.2, 201.8, 196]},
 {t: 'C', p: [201.8, 196, 196.6, 178.4, 187.4, 173.6]},
 {t: 'L', p: [183.4, 179.6]},
 {t: 'L', p: [182.2, 177.6]},
 {t: 'C', p: [182.2, 177.6, 178.6, 176.8, 183, 170]},
 {t: 'C', p: [187.4, 163.2, 187, 162.4, 187, 162.4]},
 {t: 'C', p: [187, 162.4, 193.4, 169.6, 195, 169.6]},
 {t: 'C', p: [195, 169.6, 208.2, 162, 209.4, 186.4]},
 {t: 'C', p: [209.4, 186.4, 216.2, 172, 207, 165.2]},
 {t: 'C', p: [207, 165.2, 192.2, 163.2, 193.4, 158]},
 {t: 'L', p: [200.6, 145.6]},
 {t: 'C', p: [204.2, 140.4, 202.6, 143.2, 202.6, 143.2]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [182.2, 158.4]},
 {t: 'C', p: [182.2, 158.4, 169.4, 158.4, 166.2, 163.6]},
 {t: 'L', p: [159, 173.2]},
 {t: 'C', p: [159, 173.2, 176.2, 163.2, 180.2, 162]},
 {t: 'C', p: [184.2, 160.8, 182.2, 158.4, 182.2, 158.4]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [142.2, 164.8]},
 {t: 'C', p: [142.2, 164.8, 140.2, 166, 139.8, 168.8]},
 {t: 'C', p: [139.4, 171.6, 137, 172, 137.8, 174.8]},
 {t: 'C', p: [138.6, 177.6, 140.6, 180, 140.6, 176]},
 {t: 'C', p: [140.6, 172, 142.2, 170, 143, 168.8]},
 {t: 'C', p: [143.8, 167.6, 145.4, 163.2, 142.2, 164.8]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [133.4, 226]},
 {t: 'C', p: [133.4, 226, 125, 222, 121.8, 218.4]},
 {t: 'C', p: [118.6, 214.8, 119.052, 219.966, 114.2, 219.6]},
 {t: 'C', p: [108.353, 219.159, 109.4, 203.2, 109.4, 203.2]},
 {t: 'L', p: [105.4, 210.8]},
 {t: 'C', p: [105.4, 210.8, 104.2, 225.2, 112.2, 222.8]},
 {t: 'C', p: [116.107, 221.628, 117.4, 223.2, 115.8, 224]},
 {t: 'C', p: [114.2, 224.8, 121.4, 225.2, 118.6, 226.8]},
 {t: 'C', p: [115.8, 228.4, 130.2, 223.2, 127.8, 233.6]},
 {t: 'L', p: [133.4, 226]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [120.8, 240.4]},
 {t: 'C', p: [120.8, 240.4, 105.4, 244.8, 101.8, 235.2]},
 {t: 'C', p: [101.8, 235.2, 97, 237.6, 99.2, 240.6]},
 {t: 'C', p: [101.4, 243.6, 102.6, 244, 102.6, 244]},
 {t: 'C', p: [102.6, 244, 108, 245.2, 107.4, 246]},
 {t: 'C', p: [106.8, 246.8, 104.4, 250.2, 104.4, 250.2]},
 {t: 'C', p: [104.4, 250.2, 114.6, 244.2, 120.8, 240.4]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [349.201, 318.601]},
 {t: 'C', p: [348.774, 320.735, 347.103, 321.536, 345.201, 322.201]},
 {t: 'C', p: [343.284, 321.243, 340.686, 318.137, 338.801, 320.201]},
 {t: 'C', p: [338.327, 319.721, 337.548, 319.661, 337.204, 318.999]},
 {t: 'C', p: [336.739, 318.101, 337.011, 317.055, 336.669, 316.257]},
 {t: 'C', p: [336.124, 314.985, 335.415, 313.619, 335.601, 312.201]},
 {t: 'C', p: [337.407, 311.489, 338.002, 309.583, 337.528, 307.82]},
 {t: 'C', p: [337.459, 307.563, 337.03, 307.366, 337.23, 307.017]},
 {t: 'C', p: [337.416, 306.694, 337.734, 306.467, 338.001, 306.2]},
 {t: 'C', p: [337.866, 306.335, 337.721, 306.568, 337.61, 306.548]},
 {t: 'C', p: [337, 306.442, 337.124, 305.805, 337.254, 305.418]},
 {t: 'C', p: [337.839, 303.672, 339.853, 303.408, 341.201, 304.6]},
 {t: 'C', p: [341.457, 304.035, 341.966, 304.229, 342.401, 304.2]},
 {t: 'C', p: [342.351, 303.621, 342.759, 303.094, 342.957, 302.674]},
 {t: 'C', p: [343.475, 301.576, 345.104, 302.682, 345.901, 302.07]},
 {t: 'C', p: [346.977, 301.245, 348.04, 300.546, 349.118, 301.149]},
 {t: 'C', p: [350.927, 302.162, 352.636, 303.374, 353.835, 305.115]},
 {t: 'C', p: [354.41, 305.949, 354.65, 307.23, 354.592, 308.188]},
 {t: 'C', p: [354.554, 308.835, 353.173, 308.483, 352.83, 309.412]},
 {t: 'C', p: [352.185, 311.16, 354.016, 311.679, 354.772, 313.017]},
 {t: 'C', p: [354.97, 313.366, 354.706, 313.67, 354.391, 313.768]},
 {t: 'C', p: [353.98, 313.896, 353.196, 313.707, 353.334, 314.16]},
 {t: 'C', p: [354.306, 317.353, 351.55, 318.031, 349.201, 318.601]},
 {t: 'z', p: []}]},

{f: '#fff', s: null, p: [{t: 'M', p: [339.6, 338.201]},
 {t: 'C', p: [339.593, 336.463, 337.992, 334.707, 339.201, 333.001]},
 {t: 'C', p: [339.336, 333.135, 339.467, 333.356, 339.601, 333.356]},
 {t: 'C', p: [339.736, 333.356, 339.867, 333.135, 340.001, 333.001]},
 {t: 'C', p: [341.496, 335.217, 345.148, 336.145, 345.006, 338.991]},
 {t: 'C', p: [344.984, 339.438, 343.897, 340.356, 344.801, 341.001]},
 {t: 'C', p: [342.988, 342.349, 342.933, 344.719, 342.001, 346.601]},
 {t: 'C', p: [340.763, 346.315, 339.551, 345.952, 338.401, 345.401]},
 {t: 'C', p: [338.753, 343.915, 338.636, 342.231, 339.456, 340.911]},
 {t: 'C', p: [339.89, 340.213, 339.603, 339.134, 339.6, 338.201]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [173.4, 329.201]},
 {t: 'C', p: [173.4, 329.201, 156.542, 339.337, 170.6, 324.001]},
 {t: 'C', p: [179.4, 314.401, 189.4, 308.801, 189.4, 308.801]},
 {t: 'C', p: [189.4, 308.801, 199.8, 304.4, 203.4, 303.2]},
 {t: 'C', p: [207, 302, 222.2, 296.8, 225.4, 296.4]},
 {t: 'C', p: [228.6, 296, 238.2, 292, 245, 296]},
 {t: 'C', p: [251.8, 300, 259.8, 304.4, 259.8, 304.4]},
 {t: 'C', p: [259.8, 304.4, 243.4, 296, 239.8, 298.4]},
 {t: 'C', p: [236.2, 300.8, 229, 300.4, 223, 303.6]},
 {t: 'C', p: [223, 303.6, 208.2, 308.001, 205, 310.001]},
 {t: 'C', p: [201.8, 312.001, 191.4, 323.601, 189.8, 322.801]},
 {t: 'C', p: [188.2, 322.001, 190.2, 321.601, 191.4, 318.801]},
 {t: 'C', p: [192.6, 316.001, 190.6, 314.401, 182.6, 320.801]},
 {t: 'C', p: [174.6, 327.201, 173.4, 329.201, 173.4, 329.201]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [180.805, 323.234]},
 {t: 'C', p: [180.805, 323.234, 182.215, 310.194, 190.693, 311.859]},
 {t: 'C', p: [190.693, 311.859, 198.919, 307.689, 201.641, 305.721]},
 {t: 'C', p: [201.641, 305.721, 209.78, 304.019, 211.09, 303.402]},
 {t: 'C', p: [229.569, 294.702, 244.288, 299.221, 244.835, 298.101]},
 {t: 'C', p: [245.381, 296.982, 265.006, 304.099, 268.615, 308.185]},
 {t: 'C', p: [269.006, 308.628, 258.384, 302.588, 248.686, 300.697]},
 {t: 'C', p: [240.413, 299.083, 218.811, 300.944, 207.905, 306.48]},
 {t: 'C', p: [204.932, 307.989, 195.987, 313.773, 193.456, 313.662]},
 {t: 'C', p: [190.925, 313.55, 180.805, 323.234, 180.805, 323.234]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [177, 348.801]},
 {t: 'C', p: [177, 348.801, 161.8, 346.401, 178.6, 344.801]},
 {t: 'C', p: [178.6, 344.801, 196.6, 342.801, 200.6, 337.601]},
 {t: 'C', p: [200.6, 337.601, 214.2, 328.401, 217, 328.001]},
 {t: 'C', p: [219.8, 327.601, 249.8, 320.401, 250.2, 318.001]},
 {t: 'C', p: [250.6, 315.601, 256.2, 315.601, 257.8, 316.401]},
 {t: 'C', p: [259.4, 317.201, 258.6, 318.401, 255.8, 319.201]},
 {t: 'C', p: [253, 320.001, 221.8, 336.401, 215.4, 337.601]},
 {t: 'C', p: [209, 338.801, 197.4, 346.401, 192.6, 347.601]},
 {t: 'C', p: [187.8, 348.801, 177, 348.801, 177, 348.801]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [196.52, 341.403]},
 {t: 'C', p: [196.52, 341.403, 187.938, 340.574, 196.539, 339.755]},
 {t: 'C', p: [196.539, 339.755, 205.355, 336.331, 207.403, 333.668]},
 {t: 'C', p: [207.403, 333.668, 214.367, 328.957, 215.8, 328.753]},
 {t: 'C', p: [217.234, 328.548, 231.194, 324.861, 231.399, 323.633]},
 {t: 'C', p: [231.604, 322.404, 265.67, 309.823, 270.09, 313.013]},
 {t: 'C', p: [273.001, 315.114, 263.1, 313.437, 253.466, 317.847]},
 {t: 'C', p: [252.111, 318.467, 218.258, 333.054, 214.981, 333.668]},
 {t: 'C', p: [211.704, 334.283, 205.765, 338.174, 203.307, 338.788]},
 {t: 'C', p: [200.85, 339.403, 196.52, 341.403, 196.52, 341.403]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [188.6, 343.601]},
 {t: 'C', p: [188.6, 343.601, 193.8, 343.201, 192.6, 344.801]},
 {t: 'C', p: [191.4, 346.401, 189, 345.601, 189, 345.601]},
 {t: 'L', p: [188.6, 343.601]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [181.4, 345.201]},
 {t: 'C', p: [181.4, 345.201, 186.6, 344.801, 185.4, 346.401]},
 {t: 'C', p: [184.2, 348.001, 181.8, 347.201, 181.8, 347.201]},
 {t: 'L', p: [181.4, 345.201]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [171, 346.801]},
 {t: 'C', p: [171, 346.801, 176.2, 346.401, 175, 348.001]},
 {t: 'C', p: [173.8, 349.601, 171.4, 348.801, 171.4, 348.801]},
 {t: 'L', p: [171, 346.801]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [163.4, 347.601]},
 {t: 'C', p: [163.4, 347.601, 168.6, 347.201, 167.4, 348.801]},
 {t: 'C', p: [166.2, 350.401, 163.8, 349.601, 163.8, 349.601]},
 {t: 'L', p: [163.4, 347.601]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [201.8, 308.001]},
 {t: 'C', p: [201.8, 308.001, 206.2, 308.001, 205, 309.601]},
 {t: 'C', p: [203.8, 311.201, 200.6, 310.801, 200.6, 310.801]},
 {t: 'L', p: [201.8, 308.001]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [191.8, 313.601]},
 {t: 'C', p: [191.8, 313.601, 198.306, 311.46, 195.8, 314.801]},
 {t: 'C', p: [194.6, 316.401, 192.2, 315.601, 192.2, 315.601]},
 {t: 'L', p: [191.8, 313.601]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [180.6, 318.401]},
 {t: 'C', p: [180.6, 318.401, 185.8, 318.001, 184.6, 319.601]},
 {t: 'C', p: [183.4, 321.201, 181, 320.401, 181, 320.401]},
 {t: 'L', p: [180.6, 318.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [173, 324.401]},
 {t: 'C', p: [173, 324.401, 178.2, 324.001, 177, 325.601]},
 {t: 'C', p: [175.8, 327.201, 173.4, 326.401, 173.4, 326.401]},
 {t: 'L', p: [173, 324.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [166.2, 329.201]},
 {t: 'C', p: [166.2, 329.201, 171.4, 328.801, 170.2, 330.401]},
 {t: 'C', p: [169, 332.001, 166.6, 331.201, 166.6, 331.201]},
 {t: 'L', p: [166.2, 329.201]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [205.282, 335.598]},
 {t: 'C', p: [205.282, 335.598, 212.203, 335.066, 210.606, 337.195]},
 {t: 'C', p: [209.009, 339.325, 205.814, 338.26, 205.814, 338.26]},
 {t: 'L', p: [205.282, 335.598]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [215.682, 330.798]},
 {t: 'C', p: [215.682, 330.798, 222.603, 330.266, 221.006, 332.395]},
 {t: 'C', p: [219.409, 334.525, 216.214, 333.46, 216.214, 333.46]},
 {t: 'L', p: [215.682, 330.798]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [226.482, 326.398]},
 {t: 'C', p: [226.482, 326.398, 233.403, 325.866, 231.806, 327.995]},
 {t: 'C', p: [230.209, 330.125, 227.014, 329.06, 227.014, 329.06]},
 {t: 'L', p: [226.482, 326.398]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [236.882, 321.598]},
 {t: 'C', p: [236.882, 321.598, 243.803, 321.066, 242.206, 323.195]},
 {t: 'C', p: [240.609, 325.325, 237.414, 324.26, 237.414, 324.26]},
 {t: 'L', p: [236.882, 321.598]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [209.282, 303.598]},
 {t: 'C', p: [209.282, 303.598, 216.203, 303.066, 214.606, 305.195]},
 {t: 'C', p: [213.009, 307.325, 209.014, 307.06, 209.014, 307.06]},
 {t: 'L', p: [209.282, 303.598]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [219.282, 300.398]},
 {t: 'C', p: [219.282, 300.398, 226.203, 299.866, 224.606, 301.995]},
 {t: 'C', p: [223.009, 304.125, 218.614, 303.86, 218.614, 303.86]},
 {t: 'L', p: [219.282, 300.398]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [196.6, 340.401]},
 {t: 'C', p: [196.6, 340.401, 201.8, 340.001, 200.6, 341.601]},
 {t: 'C', p: [199.4, 343.201, 197, 342.401, 197, 342.401]},
 {t: 'L', p: [196.6, 340.401]},
 {t: 'z', p: []}]},

{f: '#992600', s: null, p: [{t: 'M', p: [123.4, 241.2]},
 {t: 'C', p: [123.4, 241.2, 119, 250, 118.6, 253.2]},
 {t: 'C', p: [118.6, 253.2, 119.4, 244.4, 120.6, 242.4]},
 {t: 'C', p: [121.8, 240.4, 123.4, 241.2, 123.4, 241.2]},
 {t: 'z', p: []}]},

{f: '#992600', s: null, p: [{t: 'M', p: [105, 255.2]},
 {t: 'C', p: [105, 255.2, 101.8, 269.6, 102.2, 272.4]},
 {t: 'C', p: [102.2, 272.4, 101, 260.8, 101.4, 259.6]},
 {t: 'C', p: [101.8, 258.4, 105, 255.2, 105, 255.2]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [125.8, 180.6]},
 {t: 'L', p: [125.6, 183.8]},
 {t: 'L', p: [123.4, 184]},
 {t: 'C', p: [123.4, 184, 137.6, 196.6, 138.2, 204.2]},
 {t: 'C', p: [138.2, 204.2, 139, 196, 125.8, 180.6]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [129.784, 181.865]},
 {t: 'C', p: [129.353, 181.449, 129.572, 180.704, 129.164, 180.444]},
 {t: 'C', p: [128.355, 179.928, 130.462, 179.871, 130.234, 179.155]},
 {t: 'C', p: [129.851, 177.949, 130.038, 177.928, 129.916, 176.652]},
 {t: 'C', p: [129.859, 176.054, 130.447, 174.514, 130.832, 174.074]},
 {t: 'C', p: [132.278, 172.422, 130.954, 169.49, 132.594, 167.939]},
 {t: 'C', p: [132.898, 167.65, 133.274, 167.098, 133.559, 166.68]},
 {t: 'C', p: [134.218, 165.717, 135.402, 165.229, 136.352, 164.401]},
 {t: 'C', p: [136.67, 164.125, 136.469, 163.298, 137.038, 163.39]},
 {t: 'C', p: [137.752, 163.505, 138.993, 163.375, 138.948, 164.216]},
 {t: 'C', p: [138.835, 166.336, 137.506, 168.056, 136.226, 169.724]},
 {t: 'C', p: [136.677, 170.428, 136.219, 171.063, 135.935, 171.62]},
 {t: 'C', p: [134.6, 174.24, 134.789, 177.081, 134.615, 179.921]},
 {t: 'C', p: [134.61, 180.006, 134.303, 180.084, 134.311, 180.137]},
 {t: 'C', p: [134.664, 182.472, 135.248, 184.671, 136.127, 186.9]},
 {t: 'C', p: [136.493, 187.83, 136.964, 188.725, 137.114, 189.652]},
 {t: 'C', p: [137.225, 190.338, 137.328, 191.171, 136.92, 191.876]},
 {t: 'C', p: [138.955, 194.766, 137.646, 197.417, 138.815, 200.948]},
 {t: 'C', p: [139.022, 201.573, 140.714, 203.487, 140.251, 203.326]},
 {t: 'C', p: [137.738, 202.455, 137.626, 202.057, 137.449, 201.304]},
 {t: 'C', p: [137.303, 200.681, 136.973, 199.304, 136.736, 198.702]},
 {t: 'C', p: [136.672, 198.538, 136.501, 196.654, 136.423, 196.532]},
 {t: 'C', p: [134.91, 194.15, 136.268, 194.326, 134.898, 191.968]},
 {t: 'C', p: [133.47, 191.288, 132.504, 190.184, 131.381, 189.022]},
 {t: 'C', p: [131.183, 188.818, 132.326, 188.094, 132.145, 187.881]},
 {t: 'C', p: [131.053, 186.592, 129.9, 185.825, 130.236, 184.332]},
 {t: 'C', p: [130.391, 183.642, 130.528, 182.585, 129.784, 181.865]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [126.2, 183.6]},
 {t: 'C', p: [126.2, 183.6, 126.6, 190.4, 129, 192]},
 {t: 'C', p: [131.4, 193.6, 130.2, 192.8, 127, 191.6]},
 {t: 'C', p: [123.8, 190.4, 125, 189.6, 125, 189.6]},
 {t: 'C', p: [125, 189.6, 122.2, 190, 124.6, 192]},
 {t: 'C', p: [127, 194, 130.6, 196.4, 129, 196.4]},
 {t: 'C', p: [127.4, 196.4, 119.8, 192.4, 119.8, 189.6]},
 {t: 'C', p: [119.8, 186.8, 118.8, 182.7, 118.8, 182.7]},
 {t: 'C', p: [118.8, 182.7, 119.9, 181.9, 124.7, 182]},
 {t: 'C', p: [124.7, 182, 126.1, 182.7, 126.2, 183.6]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [125.4, 202.2]},
 {t: 'C', p: [125.4, 202.2, 116.88, 199.409, 98.4, 202.8]},
 {t: 'C', p: [98.4, 202.8, 107.431, 200.722, 126.2, 203]},
 {t: 'C', p: [136.5, 204.25, 125.4, 202.2, 125.4, 202.2]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [127.498, 202.129]},
 {t: 'C', p: [127.498, 202.129, 119.252, 198.611, 100.547, 200.392]},
 {t: 'C', p: [100.547, 200.392, 109.725, 199.103, 128.226, 202.995]},
 {t: 'C', p: [138.38, 205.131, 127.498, 202.129, 127.498, 202.129]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [129.286, 202.222]},
 {t: 'C', p: [129.286, 202.222, 121.324, 198.101, 102.539, 198.486]},
 {t: 'C', p: [102.539, 198.486, 111.787, 197.882, 129.948, 203.14]},
 {t: 'C', p: [139.914, 206.025, 129.286, 202.222, 129.286, 202.222]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [130.556, 202.445]},
 {t: 'C', p: [130.556, 202.445, 123.732, 198.138, 106.858, 197.04]},
 {t: 'C', p: [106.858, 197.04, 115.197, 197.21, 131.078, 203.319]},
 {t: 'C', p: [139.794, 206.672, 130.556, 202.445, 130.556, 202.445]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [245.84, 212.961]},
 {t: 'C', p: [245.84, 212.961, 244.91, 213.605, 245.124, 212.424]},
 {t: 'C', p: [245.339, 211.243, 273.547, 198.073, 277.161, 198.323]},
 {t: 'C', p: [277.161, 198.323, 246.913, 211.529, 245.84, 212.961]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [242.446, 213.6]},
 {t: 'C', p: [242.446, 213.6, 241.57, 214.315, 241.691, 213.121]},
 {t: 'C', p: [241.812, 211.927, 268.899, 196.582, 272.521, 196.548]},
 {t: 'C', p: [272.521, 196.548, 243.404, 212.089, 242.446, 213.6]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [239.16, 214.975]},
 {t: 'C', p: [239.16, 214.975, 238.332, 215.747, 238.374, 214.547]},
 {t: 'C', p: [238.416, 213.348, 258.233, 197.851, 268.045, 195.977]},
 {t: 'C', p: [268.045, 195.977, 250.015, 204.104, 239.16, 214.975]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [236.284, 216.838]},
 {t: 'C', p: [236.284, 216.838, 235.539, 217.532, 235.577, 216.453]},
 {t: 'C', p: [235.615, 215.373, 253.449, 201.426, 262.28, 199.74]},
 {t: 'C', p: [262.28, 199.74, 246.054, 207.054, 236.284, 216.838]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [204.6, 364.801]},
 {t: 'C', p: [204.6, 364.801, 189.4, 362.401, 206.2, 360.801]},
 {t: 'C', p: [206.2, 360.801, 224.2, 358.801, 228.2, 353.601]},
 {t: 'C', p: [228.2, 353.601, 241.8, 344.401, 244.6, 344.001]},
 {t: 'C', p: [247.4, 343.601, 263.8, 340.001, 264.2, 337.601]},
 {t: 'C', p: [264.6, 335.201, 270.6, 332.801, 272.2, 333.601]},
 {t: 'C', p: [273.8, 334.401, 273.8, 343.601, 271, 344.401]},
 {t: 'C', p: [268.2, 345.201, 249.4, 352.401, 243, 353.601]},
 {t: 'C', p: [236.6, 354.801, 225, 362.401, 220.2, 363.601]},
 {t: 'C', p: [215.4, 364.801, 204.6, 364.801, 204.6, 364.801]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [277.6, 327.401]},
 {t: 'C', p: [277.6, 327.401, 274.6, 329.001, 273.4, 331.601]},
 {t: 'C', p: [273.4, 331.601, 267, 342.201, 252.8, 345.401]},
 {t: 'C', p: [252.8, 345.401, 229.8, 354.401, 222, 356.401]},
 {t: 'C', p: [222, 356.401, 208.6, 361.401, 201.2, 360.601]},
 {t: 'C', p: [201.2, 360.601, 194.2, 360.801, 200.4, 362.401]},
 {t: 'C', p: [200.4, 362.401, 220.6, 360.401, 224, 358.601]},
 {t: 'C', p: [224, 358.601, 239.6, 353.401, 242.6, 350.801]},
 {t: 'C', p: [245.6, 348.201, 263.8, 343.201, 266, 341.201]},
 {t: 'C', p: [268.2, 339.201, 278, 330.801, 277.6, 327.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [218.882, 358.911]},
 {t: 'C', p: [218.882, 358.911, 224.111, 358.685, 222.958, 360.234]},
 {t: 'C', p: [221.805, 361.784, 219.357, 360.91, 219.357, 360.91]},
 {t: 'L', p: [218.882, 358.911]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [211.68, 360.263]},
 {t: 'C', p: [211.68, 360.263, 216.908, 360.037, 215.756, 361.586]},
 {t: 'C', p: [214.603, 363.136, 212.155, 362.263, 212.155, 362.263]},
 {t: 'L', p: [211.68, 360.263]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [201.251, 361.511]},
 {t: 'C', p: [201.251, 361.511, 206.48, 361.284, 205.327, 362.834]},
 {t: 'C', p: [204.174, 364.383, 201.726, 363.51, 201.726, 363.51]},
 {t: 'L', p: [201.251, 361.511]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [193.617, 362.055]},
 {t: 'C', p: [193.617, 362.055, 198.846, 361.829, 197.693, 363.378]},
 {t: 'C', p: [196.54, 364.928, 194.092, 364.054, 194.092, 364.054]},
 {t: 'L', p: [193.617, 362.055]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [235.415, 351.513]},
 {t: 'C', p: [235.415, 351.513, 242.375, 351.212, 240.84, 353.274]},
 {t: 'C', p: [239.306, 355.336, 236.047, 354.174, 236.047, 354.174]},
 {t: 'L', p: [235.415, 351.513]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [245.73, 347.088]},
 {t: 'C', p: [245.73, 347.088, 251.689, 343.787, 251.155, 348.849]},
 {t: 'C', p: [250.885, 351.405, 246.362, 349.749, 246.362, 349.749]},
 {t: 'L', p: [245.73, 347.088]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [254.862, 344.274]},
 {t: 'C', p: [254.862, 344.274, 262.021, 340.573, 260.287, 346.035]},
 {t: 'C', p: [259.509, 348.485, 255.493, 346.935, 255.493, 346.935]},
 {t: 'L', p: [254.862, 344.274]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [264.376, 339.449]},
 {t: 'C', p: [264.376, 339.449, 268.735, 334.548, 269.801, 341.21]},
 {t: 'C', p: [270.207, 343.748, 265.008, 342.11, 265.008, 342.11]},
 {t: 'L', p: [264.376, 339.449]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [226.834, 355.997]},
 {t: 'C', p: [226.834, 355.997, 232.062, 355.77, 230.91, 357.32]},
 {t: 'C', p: [229.757, 358.869, 227.308, 357.996, 227.308, 357.996]},
 {t: 'L', p: [226.834, 355.997]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [262.434, 234.603]},
 {t: 'C', p: [262.434, 234.603, 261.708, 235.268, 261.707, 234.197]},
 {t: 'C', p: [261.707, 233.127, 279.191, 219.863, 288.034, 218.479]},
 {t: 'C', p: [288.034, 218.479, 271.935, 225.208, 262.434, 234.603]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [265.4, 298.4]},
 {t: 'C', p: [265.4, 298.4, 287.401, 320.801, 296.601, 324.401]},
 {t: 'C', p: [296.601, 324.401, 305.801, 335.601, 301.801, 361.601]},
 {t: 'C', p: [301.801, 361.601, 298.601, 369.201, 295.401, 348.401]},
 {t: 'C', p: [295.401, 348.401, 298.601, 323.201, 287.401, 339.201]},
 {t: 'C', p: [287.401, 339.201, 279, 329.301, 285.4, 329.601]},
 {t: 'C', p: [285.4, 329.601, 288.601, 331.601, 289.001, 330.001]},
 {t: 'C', p: [289.401, 328.401, 281.4, 314.801, 264.2, 300.4]},
 {t: 'C', p: [247, 286, 265.4, 298.4, 265.4, 298.4]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [207, 337.201]},
 {t: 'C', p: [207, 337.201, 206.8, 335.401, 208.6, 336.201]},
 {t: 'C', p: [210.4, 337.001, 304.601, 343.201, 336.201, 367.201]},
 {t: 'C', p: [336.201, 367.201, 291.001, 344.001, 207, 337.201]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [217.4, 332.801]},
 {t: 'C', p: [217.4, 332.801, 217.2, 331.001, 219, 331.801]},
 {t: 'C', p: [220.8, 332.601, 357.401, 331.601, 381.001, 364.001]},
 {t: 'C', p: [381.001, 364.001, 359.001, 338.801, 217.4, 332.801]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [229, 328.801]},
 {t: 'C', p: [229, 328.801, 228.8, 327.001, 230.6, 327.801]},
 {t: 'C', p: [232.4, 328.601, 405.801, 315.601, 429.401, 348.001]},
 {t: 'C', p: [429.401, 348.001, 419.801, 322.401, 229, 328.801]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [239, 324.001]},
 {t: 'C', p: [239, 324.001, 238.8, 322.201, 240.6, 323.001]},
 {t: 'C', p: [242.4, 323.801, 364.601, 285.2, 388.201, 317.601]},
 {t: 'C', p: [388.201, 317.601, 374.801, 293, 239, 324.001]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [181, 346.801]},
 {t: 'C', p: [181, 346.801, 180.8, 345.001, 182.6, 345.801]},
 {t: 'C', p: [184.4, 346.601, 202.2, 348.801, 204.2, 387.601]},
 {t: 'C', p: [204.2, 387.601, 197, 345.601, 181, 346.801]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [172.2, 348.401]},
 {t: 'C', p: [172.2, 348.401, 172, 346.601, 173.8, 347.401]},
 {t: 'C', p: [175.6, 348.201, 189.8, 343.601, 187, 382.401]},
 {t: 'C', p: [187, 382.401, 188.2, 347.201, 172.2, 348.401]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [164.2, 348.801]},
 {t: 'C', p: [164.2, 348.801, 164, 347.001, 165.8, 347.801]},
 {t: 'C', p: [167.6, 348.601, 183, 349.201, 170.6, 371.601]},
 {t: 'C', p: [170.6, 371.601, 180.2, 347.601, 164.2, 348.801]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [211.526, 304.465]},
 {t: 'C', p: [211.526, 304.465, 211.082, 306.464, 212.631, 305.247]},
 {t: 'C', p: [228.699, 292.622, 261.141, 233.72, 316.826, 228.086]},
 {t: 'C', p: [316.826, 228.086, 278.518, 215.976, 211.526, 304.465]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [222.726, 302.665]},
 {t: 'C', p: [222.726, 302.665, 221.363, 301.472, 223.231, 300.847]},
 {t: 'C', p: [225.099, 300.222, 337.541, 227.72, 376.826, 235.686]},
 {t: 'C', p: [376.826, 235.686, 349.719, 228.176, 222.726, 302.665]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [201.885, 308.767]},
 {t: 'C', p: [201.885, 308.767, 201.376, 310.366, 203.087, 309.39]},
 {t: 'C', p: [212.062, 304.27, 215.677, 247.059, 259.254, 245.804]},
 {t: 'C', p: [259.254, 245.804, 226.843, 231.09, 201.885, 308.767]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [181.962, 319.793]},
 {t: 'C', p: [181.962, 319.793, 180.885, 321.079, 182.838, 320.825]},
 {t: 'C', p: [193.084, 319.493, 214.489, 278.222, 258.928, 283.301]},
 {t: 'C', p: [258.928, 283.301, 226.962, 268.955, 181.962, 319.793]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [193.2, 313.667]},
 {t: 'C', p: [193.2, 313.667, 192.389, 315.136, 194.258, 314.511]},
 {t: 'C', p: [204.057, 311.237, 217.141, 266.625, 261.729, 263.078]},
 {t: 'C', p: [261.729, 263.078, 227.603, 255.135, 193.2, 313.667]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [174.922, 324.912]},
 {t: 'C', p: [174.922, 324.912, 174.049, 325.954, 175.631, 325.748]},
 {t: 'C', p: [183.93, 324.669, 201.268, 291.24, 237.264, 295.354]},
 {t: 'C', p: [237.264, 295.354, 211.371, 283.734, 174.922, 324.912]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [167.323, 330.821]},
 {t: 'C', p: [167.323, 330.821, 166.318, 331.866, 167.909, 331.748]},
 {t: 'C', p: [172.077, 331.439, 202.715, 298.36, 221.183, 313.862]},
 {t: 'C', p: [221.183, 313.862, 209.168, 295.139, 167.323, 330.821]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [236.855, 298.898]},
 {t: 'C', p: [236.855, 298.898, 235.654, 297.543, 237.586, 297.158]},
 {t: 'C', p: [239.518, 296.774, 360.221, 239.061, 398.184, 251.927]},
 {t: 'C', p: [398.184, 251.927, 372.243, 241.053, 236.855, 298.898]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [203.4, 363.201]},
 {t: 'C', p: [203.4, 363.201, 203.2, 361.401, 205, 362.201]},
 {t: 'C', p: [206.8, 363.001, 222.2, 363.601, 209.8, 386.001]},
 {t: 'C', p: [209.8, 386.001, 219.4, 362.001, 203.4, 363.201]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [213.8, 361.601]},
 {t: 'C', p: [213.8, 361.601, 213.6, 359.801, 215.4, 360.601]},
 {t: 'C', p: [217.2, 361.401, 235, 363.601, 237, 402.401]},
 {t: 'C', p: [237, 402.401, 229.8, 360.401, 213.8, 361.601]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [220.6, 360.001]},
 {t: 'C', p: [220.6, 360.001, 220.4, 358.201, 222.2, 359.001]},
 {t: 'C', p: [224, 359.801, 248.6, 363.201, 272.2, 395.601]},
 {t: 'C', p: [272.2, 395.601, 236.6, 358.801, 220.6, 360.001]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [228.225, 357.972]},
 {t: 'C', p: [228.225, 357.972, 227.788, 356.214, 229.678, 356.768]},
 {t: 'C', p: [231.568, 357.322, 252.002, 355.423, 290.099, 389.599]},
 {t: 'C', p: [290.099, 389.599, 243.924, 354.656, 228.225, 357.972]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [238.625, 353.572]},
 {t: 'C', p: [238.625, 353.572, 238.188, 351.814, 240.078, 352.368]},
 {t: 'C', p: [241.968, 352.922, 276.802, 357.423, 328.499, 392.399]},
 {t: 'C', p: [328.499, 392.399, 254.324, 350.256, 238.625, 353.572]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [198.2, 342.001]},
 {t: 'C', p: [198.2, 342.001, 198, 340.201, 199.8, 341.001]},
 {t: 'C', p: [201.6, 341.801, 255, 344.401, 285.4, 371.201]},
 {t: 'C', p: [285.4, 371.201, 250.499, 346.426, 198.2, 342.001]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [188.2, 346.001]},
 {t: 'C', p: [188.2, 346.001, 188, 344.201, 189.8, 345.001]},
 {t: 'C', p: [191.6, 345.801, 216.2, 349.201, 239.8, 381.601]},
 {t: 'C', p: [239.8, 381.601, 204.2, 344.801, 188.2, 346.001]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [249.503, 348.962]},
 {t: 'C', p: [249.503, 348.962, 248.938, 347.241, 250.864, 347.655]},
 {t: 'C', p: [252.79, 348.068, 287.86, 350.004, 341.981, 381.098]},
 {t: 'C', p: [341.981, 381.098, 264.317, 346.704, 249.503, 348.962]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [257.903, 346.562]},
 {t: 'C', p: [257.903, 346.562, 257.338, 344.841, 259.264, 345.255]},
 {t: 'C', p: [261.19, 345.668, 296.26, 347.604, 350.381, 378.698]},
 {t: 'C', p: [350.381, 378.698, 273.317, 343.904, 257.903, 346.562]},
 {t: 'z', p: []}]},

{f: '#fff', s: {c: '#000', w: 0.1},
 p: [{t: 'M', p: [267.503, 341.562]},
 {t: 'C', p: [267.503, 341.562, 266.938, 339.841, 268.864, 340.255]},
 {t: 'C', p: [270.79, 340.668, 313.86, 345.004, 403.582, 379.298]},
 {t: 'C', p: [403.582, 379.298, 282.917, 338.904, 267.503, 341.562]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [156.2, 348.401]},
 {t: 'C', p: [156.2, 348.401, 161.4, 348.001, 160.2, 349.601]},
 {t: 'C', p: [159, 351.201, 156.6, 350.401, 156.6, 350.401]},
 {t: 'L', p: [156.2, 348.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [187, 362.401]},
 {t: 'C', p: [187, 362.401, 192.2, 362.001, 191, 363.601]},
 {t: 'C', p: [189.8, 365.201, 187.4, 364.401, 187.4, 364.401]},
 {t: 'L', p: [187, 362.401]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [178.2, 362.001]},
 {t: 'C', p: [178.2, 362.001, 183.4, 361.601, 182.2, 363.201]},
 {t: 'C', p: [181, 364.801, 178.6, 364.001, 178.6, 364.001]},
 {t: 'L', p: [178.2, 362.001]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [82.831, 350.182]},
 {t: 'C', p: [82.831, 350.182, 87.876, 351.505, 86.218, 352.624]},
 {t: 'C', p: [84.561, 353.744, 82.554, 352.202, 82.554, 352.202]},
 {t: 'L', p: [82.831, 350.182]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [84.831, 340.582]},
 {t: 'C', p: [84.831, 340.582, 89.876, 341.905, 88.218, 343.024]},
 {t: 'C', p: [86.561, 344.144, 84.554, 342.602, 84.554, 342.602]},
 {t: 'L', p: [84.831, 340.582]},
 {t: 'z', p: []}]},

{f: '#000', s: null, p: [{t: 'M', p: [77.631, 336.182]},
 {t: 'C', p: [77.631, 336.182, 82.676, 337.505, 81.018, 338.624]},
 {t: 'C', p: [79.361, 339.744, 77.354, 338.202, 77.354, 338.202]},
 {t: 'L', p: [77.631, 336.182]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [157.4, 411.201]},
 {t: 'C', p: [157.4, 411.201, 155.8, 411.201, 151.8, 413.201]},
 {t: 'C', p: [149.8, 413.201, 138.6, 416.801, 133, 426.801]},
 {t: 'C', p: [133, 426.801, 145.4, 417.201, 157.4, 411.201]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [245.116, 503.847]},
 {t: 'C', p: [245.257, 504.105, 245.312, 504.525, 245.604, 504.542]},
 {t: 'C', p: [246.262, 504.582, 247.495, 504.883, 247.37, 504.247]},
 {t: 'C', p: [246.522, 499.941, 245.648, 495.004, 241.515, 493.197]},
 {t: 'C', p: [240.876, 492.918, 239.434, 493.331, 239.36, 494.215]},
 {t: 'C', p: [239.233, 495.739, 239.116, 497.088, 239.425, 498.554]},
 {t: 'C', p: [239.725, 499.975, 241.883, 499.985, 242.8, 498.601]},
 {t: 'C', p: [243.736, 500.273, 244.168, 502.116, 245.116, 503.847]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [234.038, 508.581]},
 {t: 'C', p: [234.786, 509.994, 234.659, 511.853, 236.074, 512.416]},
 {t: 'C', p: [236.814, 512.71, 238.664, 511.735, 238.246, 510.661]},
 {t: 'C', p: [237.444, 508.6, 237.056, 506.361, 235.667, 504.55]},
 {t: 'C', p: [235.467, 504.288, 235.707, 503.755, 235.547, 503.427]},
 {t: 'C', p: [234.953, 502.207, 233.808, 501.472, 232.4, 501.801]},
 {t: 'C', p: [231.285, 504.004, 232.433, 506.133, 233.955, 507.842]},
 {t: 'C', p: [234.091, 507.994, 233.925, 508.37, 234.038, 508.581]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [194.436, 503.391]},
 {t: 'C', p: [194.328, 503.014, 194.29, 502.551, 194.455, 502.23]},
 {t: 'C', p: [194.986, 501.197, 195.779, 500.075, 195.442, 499.053]},
 {t: 'C', p: [195.094, 497.997, 193.978, 498.179, 193.328, 498.748]},
 {t: 'C', p: [192.193, 499.742, 192.144, 501.568, 191.453, 502.927]},
 {t: 'C', p: [191.257, 503.313, 191.308, 503.886, 190.867, 504.277]},
 {t: 'C', p: [190.393, 504.698, 189.953, 506.222, 190.049, 506.793]},
 {t: 'C', p: [190.102, 507.106, 189.919, 517.014, 190.141, 516.751]},
 {t: 'C', p: [190.76, 516.018, 193.81, 506.284, 193.879, 505.392]},
 {t: 'C', p: [193.936, 504.661, 194.668, 504.196, 194.436, 503.391]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [168.798, 496.599]},
 {t: 'C', p: [171.432, 494.1, 174.222, 491.139, 173.78, 487.427]},
 {t: 'C', p: [173.664, 486.451, 171.889, 486.978, 171.702, 487.824]},
 {t: 'C', p: [170.9, 491.449, 168.861, 494.11, 166.293, 496.502]},
 {t: 'C', p: [164.097, 498.549, 162.235, 504.893, 162, 505.401]},
 {t: 'C', p: [165.697, 500.145, 167.954, 497.399, 168.798, 496.599]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [155.224, 490.635]},
 {t: 'C', p: [155.747, 490.265, 155.445, 489.774, 155.662, 489.442]},
 {t: 'C', p: [156.615, 487.984, 157.916, 486.738, 157.934, 485]},
 {t: 'C', p: [157.937, 484.723, 157.559, 484.414, 157.224, 484.638]},
 {t: 'C', p: [156.947, 484.822, 156.605, 484.952, 156.497, 485.082]},
 {t: 'C', p: [154.467, 487.531, 153.067, 490.202, 151.624, 493.014]},
 {t: 'C', p: [151.441, 493.371, 150.297, 497.862, 150.61, 497.973]},
 {t: 'C', p: [150.849, 498.058, 152.569, 493.877, 152.779, 493.763]},
 {t: 'C', p: [154.042, 493.077, 154.054, 491.462, 155.224, 490.635]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [171.957, 510.179]},
 {t: 'C', p: [172.401, 509.31, 173.977, 508.108, 173.864, 507.219]},
 {t: 'C', p: [173.746, 506.291, 174.214, 504.848, 173.302, 505.536]},
 {t: 'C', p: [172.045, 506.484, 168.596, 507.833, 168.326, 513.641]},
 {t: 'C', p: [168.3, 514.212, 171.274, 511.519, 171.957, 510.179]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [186.4, 493.001]},
 {t: 'C', p: [186.8, 492.333, 187.508, 492.806, 187.967, 492.543]},
 {t: 'C', p: [188.615, 492.171, 189.226, 491.613, 189.518, 490.964]},
 {t: 'C', p: [190.488, 488.815, 192.257, 486.995, 192.4, 484.601]},
 {t: 'C', p: [190.909, 483.196, 190.23, 485.236, 189.6, 486.201]},
 {t: 'C', p: [188.277, 484.554, 187.278, 486.428, 185.978, 486.947]},
 {t: 'C', p: [185.908, 486.975, 185.695, 486.628, 185.62, 486.655]},
 {t: 'C', p: [184.443, 487.095, 183.763, 488.176, 182.765, 488.957]},
 {t: 'C', p: [182.594, 489.091, 182.189, 488.911, 182.042, 489.047]},
 {t: 'C', p: [181.39, 489.65, 180.417, 489.975, 180.137, 490.657]},
 {t: 'C', p: [179.027, 493.364, 175.887, 495.459, 174, 503.001]},
 {t: 'C', p: [174.381, 503.91, 178.512, 496.359, 178.999, 495.661]},
 {t: 'C', p: [179.835, 494.465, 179.953, 497.322, 181.229, 496.656]},
 {t: 'C', p: [181.28, 496.629, 181.466, 496.867, 181.6, 497.001]},
 {t: 'C', p: [181.794, 496.721, 182.012, 496.492, 182.4, 496.601]},
 {t: 'C', p: [182.4, 496.201, 182.266, 495.645, 182.467, 495.486]},
 {t: 'C', p: [183.704, 494.509, 183.62, 493.441, 184.4, 492.201]},
 {t: 'C', p: [184.858, 492.99, 185.919, 492.271, 186.4, 493.001]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [246.2, 547.401]},
 {t: 'C', p: [246.2, 547.401, 253.6, 527.001, 249.2, 515.801]},
 {t: 'C', p: [249.2, 515.801, 260.6, 537.401, 256, 548.601]},
 {t: 'C', p: [256, 548.601, 255.6, 538.201, 251.6, 533.201]},
 {t: 'C', p: [251.6, 533.201, 247.6, 546.001, 246.2, 547.401]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [231.4, 544.801]},
 {t: 'C', p: [231.4, 544.801, 236.8, 536.001, 228.8, 517.601]},
 {t: 'C', p: [228.8, 517.601, 228, 538.001, 221.2, 549.001]},
 {t: 'C', p: [221.2, 549.001, 235.4, 528.801, 231.4, 544.801]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [221.4, 542.801]},
 {t: 'C', p: [221.4, 542.801, 221.2, 522.801, 221.6, 519.801]},
 {t: 'C', p: [221.6, 519.801, 217.8, 536.401, 207.6, 546.001]},
 {t: 'C', p: [207.6, 546.001, 222, 534.001, 221.4, 542.801]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [211.8, 510.801]},
 {t: 'C', p: [211.8, 510.801, 217.8, 524.401, 207.8, 542.801]},
 {t: 'C', p: [207.8, 542.801, 214.2, 530.601, 209.4, 523.601]},
 {t: 'C', p: [209.4, 523.601, 212, 520.201, 211.8, 510.801]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [192.6, 542.401]},
 {t: 'C', p: [192.6, 542.401, 191.6, 526.801, 193.4, 524.601]},
 {t: 'C', p: [193.4, 524.601, 193.6, 518.201, 193.2, 517.201]},
 {t: 'C', p: [193.2, 517.201, 197.2, 511.001, 197.4, 518.401]},
 {t: 'C', p: [197.4, 518.401, 198.8, 526.201, 201.6, 530.801]},
 {t: 'C', p: [201.6, 530.801, 205.2, 536.201, 205, 542.601]},
 {t: 'C', p: [205, 542.601, 195, 512.401, 192.6, 542.401]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [189, 514.801]},
 {t: 'C', p: [189, 514.801, 182.4, 525.601, 180.6, 544.601]},
 {t: 'C', p: [180.6, 544.601, 179.2, 538.401, 183, 524.001]},
 {t: 'C', p: [183, 524.001, 187.2, 508.601, 189, 514.801]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [167.2, 534.601]},
 {t: 'C', p: [167.2, 534.601, 172.2, 529.201, 173.6, 524.201]},
 {t: 'C', p: [173.6, 524.201, 177.2, 508.401, 170.8, 517.001]},
 {t: 'C', p: [170.8, 517.001, 171, 525.001, 162.8, 532.401]},
 {t: 'C', p: [162.8, 532.401, 167.6, 530.001, 167.2, 534.601]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [161.4, 529.601]},
 {t: 'C', p: [161.4, 529.601, 164.8, 512.201, 165.6, 511.401]},
 {t: 'C', p: [165.6, 511.401, 167.4, 508.001, 164.6, 511.201]},
 {t: 'C', p: [164.6, 511.201, 155.8, 530.401, 151.8, 537.001]},
 {t: 'C', p: [151.8, 537.001, 159.8, 527.801, 161.4, 529.601]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [155.6, 513.001]},
 {t: 'C', p: [155.6, 513.001, 167.2, 490.601, 145.4, 516.401]},
 {t: 'C', p: [145.4, 516.401, 156.4, 506.601, 155.6, 513.001]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [140.2, 498.401]},
 {t: 'C', p: [140.2, 498.401, 145, 479.601, 147.6, 479.801]},
 {t: 'C', p: [147.6, 479.801, 155.8, 470.801, 149.2, 481.401]},
 {t: 'C', p: [149.2, 481.401, 143.2, 491.001, 143.8, 500.801]},
 {t: 'C', p: [143.8, 500.801, 143.2, 491.201, 140.2, 498.401]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [470.5, 487]},
 {t: 'C', p: [470.5, 487, 458.5, 477, 456, 473.5]},
 {t: 'C', p: [456, 473.5, 469.5, 492, 469.5, 499]},
 {t: 'C', p: [469.5, 499, 472, 491.5, 470.5, 487]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [476, 465]},
 {t: 'C', p: [476, 465, 455, 450, 451.5, 442.5]},
 {t: 'C', p: [451.5, 442.5, 478, 472, 478, 476.5]},
 {t: 'C', p: [478, 476.5, 478.5, 467.5, 476, 465]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [493, 311]},
 {t: 'C', p: [493, 311, 481, 303, 479.5, 305]},
 {t: 'C', p: [479.5, 305, 490, 311.5, 492.5, 320]},
 {t: 'C', p: [492.5, 320, 491, 311, 493, 311]},
 {t: 'z', p: []}]},

{f: '#ccc', s: null, p: [{t: 'M', p: [501.5, 391.5]},
 {t: 'L', p: [484, 379.5]},
 {t: 'C', p: [484, 379.5, 503, 396.5, 503.5, 400.5]},
 {t: 'L', p: [501.5, 391.5]},
 {t: 'z', p: []}]},

{f: null, s: '#000', p: [{t: 'M', p: [110.75, 369]},
 {t: 'L', p: [132.75, 373.75]}]},

{f: null, s: '#000', p: [{t: 'M', p: [161, 531]},
 {t: 'C', p: [161, 531, 160.5, 527.5, 151.5, 538]}]},

{f: null, s: '#000', p: [{t: 'M', p: [166.5, 536]},
 {t: 'C', p: [166.5, 536, 168.5, 529.5, 162, 534]}]},

{f: null, s: '#000', p: [{t: 'M', p: [220.5, 544.5]},
 {t: 'C', p: [220.5, 544.5, 222, 533.5, 210.5, 546.5]}]}]
