/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.crash;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.version.PSystemVersion;

public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private final TextBlock text1;
    private final String flash;
    private final BufferedImage flashCode;
    private final boolean graphviz244onWindows;

    private GraphvizCrash(String flash, boolean graphviz244onWindows, Throwable rootCause) {
        this.flash = flash;
        this.graphviz244onWindows = graphviz244onWindows;
        this.flashCode = FlashCodeFactory.getFlashCodeUtils().exportFlashcode(flash, Color.BLACK, Color.WHITE);
        ReportLog strings = new ReportLog();
        this.init(strings, rootCause);
        this.text1 = GraphicStrings.createBlackOnWhite(strings.asList(), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    public static IEntityImage build(String text, boolean graphviz244onWindows, Throwable rootCause) {
        return new GraphvizCrash(text, graphviz244onWindows, rootCause);
    }

    private void init(ReportLog strings, Throwable rootCause) {
        strings.anErrorHasOccured(null, this.flash);
        strings.add("For some reason, dot/GraphViz has crashed.");
        strings.addEmptyLine();
        strings.add("RootCause " + rootCause);
        if (rootCause != null) {
            strings.addAll(CommandExecutionResult.getStackTrace(rootCause));
        }
        strings.addEmptyLine();
        strings.addProperties();
        strings.addEmptyLine();
        try {
            String dotVersion = GraphvizRuntimeEnvironment.getInstance().dotVersion();
            strings.add("Default dot version: " + dotVersion);
        }
        catch (Throwable e) {
            strings.add("Cannot determine dot version: " + e.toString());
        }
        strings.pleaseCheckYourGraphVizVersion();
        strings.youShouldSendThisDiagram();
        if (this.flashCode != null) {
            strings.addDecodeHint();
        }
    }

    private List<String> getText2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(" ");
        strings.add("<b>It looks like you are running GraphViz 2.44 under Windows.");
        strings.add("If you have just installed GraphViz, you <i>may</i> have to execute");
        strings.add("the post-install command <b>dot -c</b> like in the following example:");
        return strings;
    }

    private List<String> getText3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(" ");
        strings.add("You may have to have <i>Administrator rights</i> to avoid the following error message:");
        return strings;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HColor getBackcolor() {
        return HColors.WHITE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMain().calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getMain().drawU(ug);
    }

    private TextBlock getMain() {
        TextBlock result = this.text1;
        if (this.flashCode != null) {
            UImage flash = new UImage(new PixelImage(this.flashCode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0);
            result = TextBlockUtils.mergeTB(result, flash, HorizontalAlignment.LEFT);
        }
        if (this.graphviz244onWindows) {
            TextBlock text2 = GraphicStrings.createBlackOnWhite(this.getText2());
            result = TextBlockUtils.mergeTB(result, text2, HorizontalAlignment.LEFT);
            UImage dotc = new UImage(new PixelImage(PSystemVersion.getDotc(), AffineTransformType.TYPE_BILINEAR));
            result = TextBlockUtils.mergeTB(result, dotc, HorizontalAlignment.LEFT);
            TextBlock text3 = GraphicStrings.createBlackOnWhite(this.getText3());
            result = TextBlockUtils.mergeTB(result, text3, HorizontalAlignment.LEFT);
            UImage dotd = new UImage(new PixelImage(PSystemVersion.getDotd(), AffineTransformType.TYPE_BILINEAR));
            result = TextBlockUtils.mergeTB(result, dotd, HorizontalAlignment.LEFT);
        }
        return result;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

