# Copyright (c) 2014 Thomas Heller
# Copyright (c) 2015 Andreas Schaefer
#
# SPDX-License-Identifier: BSL-1.0
# Distributed under the Boost Software License, Version 1.0. (See accompanying
# file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

set(PIKA_FIND_PACKAGE ON)
cmake_policy(VERSION 3.22)

# Forward PIKA_* cache variables
include("${CMAKE_CURRENT_LIST_DIR}/pika_cache_variables.cmake")

# Include pika CMake utilities
set(CMAKE_MODULE_PATH "${CMAKE_MODULE_PATH}" "${CMAKE_CURRENT_LIST_DIR}")
include(pika_utils)

# include exported targets
include("${CMAKE_CURRENT_LIST_DIR}/pika_internal_targets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/pika_targets.cmake")

get_filename_component(
  _pika_root_dir "${CMAKE_CURRENT_LIST_DIR}/../../.." ABSOLUTE
)

include(pika_set_cmake_policy)
pika_set_cmake_policy(CMP0144 NEW)

set(PIKA_VERSION_STRING "0.30.1")
set(PIKA_VERSION_MAJOR 0)
set(PIKA_VERSION_MINOR 30)
set(PIKA_VERSION_PATCH 1)

set(PIKA_DEBUG_POSTFIX "d")
set(PIKA_BUILD_TYPE "MacPorts")
# We explicitly set the default to 98 to force CMake to emit a -std=c++XX flag.
# Some compilers (clang) have a different default standard for cpp and cu files,
# but CMake does not know about this difference. If the standard is set to the
# .cpp default in CMake, CMake will omit the flag, resulting in the wrong
# standard for .cu files.
set(CMAKE_CXX_STANDARD_DEFAULT 98)

set(PIKA_GIT_COMMIT
    "unknown"
    CACHE STRING "Revision of pika from Git" FORCE
)

set(PIKA_CXX_COMPILER
    "/opt/local/bin/mpicxx-mpich-mp"
    CACHE STRING "CXX compiler for pika" FORCE
)
set(PIKA_CXX_COMPILER_ID
    "AppleClang"
    CACHE STRING "CXX compiler id for pika" FORCE
)
set(PIKA_CXX_COMPILER_VERSION
    "13.0.0.13000029"
    CACHE STRING "CXX compiler version for pika" FORCE
)

# ##############################################################################
# Setup the imported libraries (publicly linked) #

# Allocator
set(PIKA_JEMALLOC_ROOT "/opt/local")
set(PIKA_TCMALLOC_ROOT "")
set(PIKA_TBBMALLOC_ROOT "")
# Special handle for mimalloc cause we can't specify PIKA_MIMALLOC_ROOT as a HINT
# to find_package
set(PIKA_MIMALLOC_ROOT "")
if(NOT MIMALLOC_ROOT AND NOT "$ENV{MIMALLOC_ROOT}")
  set(MIMALLOC_ROOT ${PIKA_MIMALLOC_ROOT})
endif()
include(pika_setup_allocator)

include(pika_setup_threads)

# Boost Separate boost targets to be unarily linked to some modules
set(PIKA_BOOST_ROOT "/opt/local/libexec/boost/1.81")
# By default BOOST_ROOT is set to PIKA_BOOST_ROOT (not necessary for PAPI or
# HWLOC cause we are specifying PIKA_<lib>_ROOT as an HINT to find_package)
if(NOT BOOST_ROOT AND NOT "$ENV{BOOST_ROOT}")
  set(BOOST_ROOT ${PIKA_BOOST_ROOT})
endif()
include(pika_setup_boost)

include(pika_setup_fmt)
include(pika_setup_spdlog)

# Hwloc
set(PIKA_HWLOC_ROOT "/opt/local")
include(pika_setup_hwloc)

# CUDA/HIP/whip
include(pika_setup_hip)
include(pika_setup_cuda)
include(pika_setup_whip)

include(pika_setup_mpi)

include(pika_setup_stdexec)

# APEX
set(PIKA_APEX_ROOT "")
include(pika_setup_apex)

# Tracy
if(PIKA_WITH_TRACY)
  find_dependency(Tracy REQUIRED)
endif()

set(PIKA_WITH_MALLOC_DEFAULT jemalloc)

if(NOT PIKA_CMAKE_LOGLEVEL)
  set(PIKA_CMAKE_LOGLEVEL "WARN")
endif()

if(NOT DEFINED ${CMAKE_FIND_PACKAGE_NAME}_FOUND)
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND true)
endif()
