"use strict";
var __webpack_require__ = {};
(()=>{
    __webpack_require__.d = (exports1, definition)=>{
        for(var key in definition)if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports1, key)) Object.defineProperty(exports1, key, {
            enumerable: true,
            get: definition[key]
        });
    };
})();
(()=>{
    __webpack_require__.o = (obj, prop)=>Object.prototype.hasOwnProperty.call(obj, prop);
})();
(()=>{
    __webpack_require__.r = (exports1)=>{
        if ('undefined' != typeof Symbol && Symbol.toStringTag) Object.defineProperty(exports1, Symbol.toStringTag, {
            value: 'Module'
        });
        Object.defineProperty(exports1, '__esModule', {
            value: true
        });
    };
})();
var __webpack_exports__ = {};
__webpack_require__.r(__webpack_exports__);
__webpack_require__.d(__webpack_exports__, {
    PostHogCore: ()=>PostHogCore
});
const external_featureFlagUtils_js_namespaceObject = require("./featureFlagUtils.js");
const external_types_js_namespaceObject = require("./types.js");
const external_posthog_core_stateless_js_namespaceObject = require("./posthog-core-stateless.js");
const uuidv7_js_namespaceObject = require("./vendor/uuidv7.js");
const index_js_namespaceObject = require("./utils/index.js");
class PostHogCore extends external_posthog_core_stateless_js_namespaceObject.PostHogCoreStateless {
    constructor(apiKey, options){
        const disableGeoipOption = options?.disableGeoip ?? false;
        const featureFlagsRequestTimeoutMs = options?.featureFlagsRequestTimeoutMs ?? 10000;
        super(apiKey, {
            ...options,
            disableGeoip: disableGeoipOption,
            featureFlagsRequestTimeoutMs
        }), this.flagCallReported = {}, this._sessionMaxLengthSeconds = 86400, this.sessionProps = {}, this._cachedPersonProperties = null;
        this.sendFeatureFlagEvent = options?.sendFeatureFlagEvent ?? true;
        this._sessionExpirationTimeSeconds = options?.sessionExpirationTimeSeconds ?? 1800;
        this._personProfiles = options?.personProfiles ?? 'identified_only';
        this._beforeSend = options?.before_send;
    }
    setupBootstrap(options) {
        const bootstrap = options?.bootstrap;
        if (!bootstrap) return;
        if (bootstrap.distinctId) if (bootstrap.isIdentifiedId) {
            const distinctId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.DistinctId);
            if (!distinctId) {
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.DistinctId, bootstrap.distinctId);
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonMode, 'identified');
            }
        } else {
            const anonymousId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId);
            if (!anonymousId) this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId, bootstrap.distinctId);
        }
        const bootstrapFeatureFlags = bootstrap.featureFlags;
        const bootstrapFeatureFlagPayloads = bootstrap.featureFlagPayloads ?? {};
        if (bootstrapFeatureFlags && Object.keys(bootstrapFeatureFlags).length) {
            const normalizedBootstrapFeatureFlagDetails = (0, external_featureFlagUtils_js_namespaceObject.createFlagsResponseFromFlagsAndPayloads)(bootstrapFeatureFlags, bootstrapFeatureFlagPayloads);
            if (Object.keys(normalizedBootstrapFeatureFlagDetails.flags).length > 0) {
                this.setBootstrappedFeatureFlagDetails(normalizedBootstrapFeatureFlagDetails);
                const currentFeatureFlagDetails = this.getKnownFeatureFlagDetails() || {
                    flags: {},
                    requestId: void 0
                };
                const newFeatureFlagDetails = {
                    flags: {
                        ...normalizedBootstrapFeatureFlagDetails.flags,
                        ...currentFeatureFlagDetails.flags
                    },
                    requestId: normalizedBootstrapFeatureFlagDetails.requestId
                };
                this.setKnownFeatureFlagDetails(newFeatureFlagDetails);
            }
        }
    }
    clearProps() {
        this.props = void 0;
        this.sessionProps = {};
        this.flagCallReported = {};
    }
    on(event, cb) {
        return this._events.on(event, cb);
    }
    reset(propertiesToKeep) {
        this.wrap(()=>{
            const allPropertiesToKeep = [
                external_types_js_namespaceObject.PostHogPersistedProperty.Queue,
                ...propertiesToKeep || []
            ];
            this.clearProps();
            this._cachedPersonProperties = null;
            for (const key of Object.keys(external_types_js_namespaceObject.PostHogPersistedProperty))if (!allPropertiesToKeep.includes(external_types_js_namespaceObject.PostHogPersistedProperty[key])) this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty[key], null);
            this.reloadFeatureFlags();
        });
    }
    getCommonEventProperties() {
        const featureFlags = this.getFeatureFlags();
        const featureVariantProperties = {};
        if (featureFlags) for (const [feature, variant] of Object.entries(featureFlags))featureVariantProperties[`$feature/${feature}`] = variant;
        return {
            ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$active_feature_flags', featureFlags ? Object.keys(featureFlags) : void 0),
            ...featureVariantProperties,
            ...super.getCommonEventProperties()
        };
    }
    enrichProperties(properties) {
        return {
            ...this.props,
            ...this.sessionProps,
            ...properties || {},
            ...this.getCommonEventProperties(),
            $session_id: this.getSessionId()
        };
    }
    getSessionId() {
        if (!this._isInitialized) return '';
        let sessionId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionId);
        const sessionLastTimestamp = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionLastTimestamp) || 0;
        const sessionStartTimestamp = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionStartTimestamp) || 0;
        const now = Date.now();
        const sessionLastDif = now - sessionLastTimestamp;
        const sessionStartDif = now - sessionStartTimestamp;
        if (!sessionId || sessionLastDif > 1000 * this._sessionExpirationTimeSeconds || sessionStartDif > 1000 * this._sessionMaxLengthSeconds) {
            sessionId = (0, uuidv7_js_namespaceObject.uuidv7)();
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionId, sessionId);
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionStartTimestamp, now);
        }
        this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionLastTimestamp, now);
        return sessionId;
    }
    resetSessionId() {
        this.wrap(()=>{
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionId, null);
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionLastTimestamp, null);
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionStartTimestamp, null);
        });
    }
    getAnonymousId() {
        if (!this._isInitialized) return '';
        let anonId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId);
        if (!anonId) {
            anonId = (0, uuidv7_js_namespaceObject.uuidv7)();
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId, anonId);
        }
        return anonId;
    }
    getDistinctId() {
        if (!this._isInitialized) return '';
        return this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.DistinctId) || this.getAnonymousId();
    }
    registerForSession(properties) {
        this.sessionProps = {
            ...this.sessionProps,
            ...properties
        };
    }
    unregisterForSession(property) {
        delete this.sessionProps[property];
    }
    identify(distinctId, properties, options) {
        this.wrap(()=>{
            if (!this._requirePersonProcessing('posthog.identify')) return;
            const previousDistinctId = this.getDistinctId();
            distinctId = distinctId || previousDistinctId;
            if (properties?.$groups) this.groups(properties.$groups);
            const userPropsOnce = properties?.$set_once;
            delete properties?.$set_once;
            const userProps = properties?.$set || properties;
            const allProperties = this.enrichProperties({
                $anon_distinct_id: this.getAnonymousId(),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$set', userProps),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$set_once', userPropsOnce)
            });
            const userPropsObj = (0, index_js_namespaceObject.isObject)(userProps) ? userProps : void 0;
            const userPropsOnceObj = (0, index_js_namespaceObject.isObject)(userPropsOnce) ? userPropsOnce : void 0;
            if (distinctId !== previousDistinctId) {
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId, previousDistinctId);
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.DistinctId, distinctId);
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonMode, 'identified');
                this.reloadFeatureFlags();
                super.identifyStateless(distinctId, allProperties, options);
                this._cachedPersonProperties = (0, index_js_namespaceObject.getPersonPropertiesHash)(distinctId, userPropsObj, userPropsOnceObj);
            } else if (userPropsObj || userPropsOnceObj) this.setPersonProperties(userPropsObj, userPropsOnceObj);
        });
    }
    capture(event, properties, options) {
        if ('$exception' === event && !options?._originatedFromCaptureException) this._logger.warn("Using `posthog.capture('$exception')` is unreliable because it does not attach required metadata. Use `posthog.captureException(error)` instead, which attaches required metadata automatically.");
        this.wrap(()=>{
            const distinctId = this.getDistinctId();
            if (properties?.$groups) this.groups(properties.$groups);
            const allProperties = this.enrichProperties(properties);
            const hasPersonProcessing = this._hasPersonProcessing();
            allProperties['$process_person_profile'] = hasPersonProcessing;
            allProperties['$is_identified'] = this._isIdentified();
            if (hasPersonProcessing) this._requirePersonProcessing('capture');
            super.captureStateless(distinctId, event, allProperties, options);
        });
    }
    alias(alias) {
        this.wrap(()=>{
            if (!this._requirePersonProcessing('posthog.alias')) return;
            const distinctId = this.getDistinctId();
            const allProperties = this.enrichProperties({});
            super.aliasStateless(alias, distinctId, allProperties);
        });
    }
    autocapture(eventType, elements, properties = {}, options) {
        this.wrap(()=>{
            const distinctId = this.getDistinctId();
            const payload = {
                distinct_id: distinctId,
                event: '$autocapture',
                properties: {
                    ...this.enrichProperties(properties),
                    $event_type: eventType,
                    $elements: elements
                }
            };
            this.enqueue('autocapture', payload, options);
        });
    }
    groups(groups) {
        this.wrap(()=>{
            if (!this._requirePersonProcessing('posthog.group')) return;
            const existingGroups = this.props.$groups || {};
            this.register({
                $groups: {
                    ...existingGroups,
                    ...groups
                }
            });
            if (Object.keys(groups).find((type)=>existingGroups[type] !== groups[type])) this.reloadFeatureFlags();
        });
    }
    group(groupType, groupKey, groupProperties, options) {
        this.wrap(()=>{
            this.groups({
                [groupType]: groupKey
            });
            if (groupProperties) this.groupIdentify(groupType, groupKey, groupProperties, options);
        });
    }
    groupIdentify(groupType, groupKey, groupProperties, options) {
        this.wrap(()=>{
            if (!this._requirePersonProcessing('posthog.groupIdentify')) return;
            const distinctId = this.getDistinctId();
            const eventProperties = this.enrichProperties({});
            super.groupIdentifyStateless(groupType, groupKey, groupProperties, options, distinctId, eventProperties);
        });
    }
    setPersonPropertiesForFlags(properties, reloadFeatureFlags = true) {
        this.wrap(()=>{
            const existingProperties = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonProperties) || {};
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonProperties, {
                ...existingProperties,
                ...properties
            });
            if (reloadFeatureFlags) this.reloadFeatureFlags();
        });
    }
    resetPersonPropertiesForFlags() {
        this.wrap(()=>{
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonProperties, null);
        });
    }
    setGroupPropertiesForFlags(properties) {
        this.wrap(()=>{
            const existingProperties = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.GroupProperties) || {};
            if (0 !== Object.keys(existingProperties).length) Object.keys(existingProperties).forEach((groupType)=>{
                existingProperties[groupType] = {
                    ...existingProperties[groupType],
                    ...properties[groupType]
                };
                delete properties[groupType];
            });
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.GroupProperties, {
                ...existingProperties,
                ...properties
            });
        });
    }
    resetGroupPropertiesForFlags() {
        this.wrap(()=>{
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.GroupProperties, null);
        });
    }
    async remoteConfigAsync() {
        await this._initPromise;
        if (this._remoteConfigResponsePromise) return this._remoteConfigResponsePromise;
        return this._remoteConfigAsync();
    }
    async flagsAsync(options) {
        const { sendAnonDistinctId = true, fetchConfig = false, triggerOnRemoteConfig = false } = options ?? {};
        await this._initPromise;
        if (this._flagsResponsePromise) {
            this._logger.info('Feature flags are being loaded already, queuing reload.');
            if (this._pendingFlagsRequest) this._flagsResponsePromise.then(this._pendingFlagsRequest.resolve).catch(this._pendingFlagsRequest.reject);
            return new Promise((resolve, reject)=>{
                this._pendingFlagsRequest = {
                    sendAnonDistinctId,
                    fetchConfig,
                    triggerOnRemoteConfig,
                    resolve,
                    reject
                };
            });
        }
        return this._flagsAsync({
            sendAnonDistinctId,
            fetchConfig,
            triggerOnRemoteConfig
        });
    }
    onRemoteConfig(_response) {}
    maybeNotifyRemoteConfig(shouldTrigger, response) {
        if (shouldTrigger) try {
            this.onRemoteConfig(response);
        } catch (e) {
            this._logger.error('Error in onRemoteConfig callback:', e);
        }
    }
    cacheSessionReplay(source, response) {
        const sessionReplay = response?.sessionRecording;
        if (sessionReplay) {
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionReplay, sessionReplay);
            this._logger.info(`Session replay config from ${source}: `, JSON.stringify(sessionReplay));
        } else if ('boolean' == typeof sessionReplay && false === sessionReplay) {
            this._logger.info(`Session replay config from ${source} disabled.`);
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.SessionReplay, null);
        }
    }
    async _remoteConfigAsync() {
        this._remoteConfigResponsePromise = this._initPromise.then(()=>{
            let remoteConfig = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.RemoteConfig);
            this._logger.info('Cached remote config: ', JSON.stringify(remoteConfig));
            return super.getRemoteConfig().then((response)=>{
                if (response) {
                    const remoteConfigWithoutSurveys = {
                        ...response
                    };
                    delete remoteConfigWithoutSurveys.surveys;
                    this._logger.info('Fetched remote config: ', JSON.stringify(remoteConfigWithoutSurveys));
                    if (false === this.disableSurveys) {
                        const surveys = response.surveys;
                        let hasSurveys = true;
                        if (Array.isArray(surveys)) this._logger.info('Surveys fetched from remote config: ', JSON.stringify(surveys));
                        else {
                            this._logger.info('There are no surveys.');
                            hasSurveys = false;
                        }
                        if (hasSurveys) this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.Surveys, surveys);
                        else this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.Surveys, null);
                    } else this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.Surveys, null);
                    this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.RemoteConfig, remoteConfigWithoutSurveys);
                    this.cacheSessionReplay('remote config', response);
                    let willLoadFlags = false;
                    if (false === response.hasFeatureFlags) {
                        this.setKnownFeatureFlagDetails({
                            flags: {}
                        });
                        this._logger.warn('Remote config has no feature flags, will not load feature flags.');
                    } else if (false !== this.preloadFeatureFlags) {
                        willLoadFlags = true;
                        this.flagsAsync({
                            sendAnonDistinctId: true,
                            fetchConfig: true,
                            triggerOnRemoteConfig: true
                        });
                    }
                    if (!response.supportedCompression?.includes(external_types_js_namespaceObject.Compression.GZipJS)) this.disableCompression = true;
                    this.maybeNotifyRemoteConfig(!willLoadFlags, response);
                    remoteConfig = response;
                }
                return remoteConfig;
            });
        }).finally(()=>{
            this._remoteConfigResponsePromise = void 0;
        });
        return this._remoteConfigResponsePromise;
    }
    async _flagsAsync(options) {
        const sendAnonDistinctId = options?.sendAnonDistinctId ?? true;
        const fetchConfig = options?.fetchConfig ?? false;
        const triggerOnRemoteConfig = options?.triggerOnRemoteConfig ?? false;
        this._flagsResponsePromise = this._initPromise.then(async ()=>{
            const distinctId = this.getDistinctId();
            const groups = this.props.$groups || {};
            const personProperties = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonProperties) || {};
            const groupProperties = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.GroupProperties) || {};
            const extraProperties = {
                $anon_distinct_id: sendAnonDistinctId ? this.getAnonymousId() : void 0
            };
            const result = await super.getFlags(distinctId, groups, personProperties, groupProperties, extraProperties, fetchConfig);
            if (!result.success) return void this.setKnownFeatureFlagDetails({
                flags: this.getKnownFeatureFlagDetails()?.flags ?? {},
                requestError: result.error
            });
            const res = result.response;
            if (res?.quotaLimited?.includes(external_posthog_core_stateless_js_namespaceObject.QuotaLimitedFeature.FeatureFlags)) {
                this.setKnownFeatureFlagDetails({
                    flags: this.getKnownFeatureFlagDetails()?.flags ?? {},
                    quotaLimited: res.quotaLimited
                });
                this._logger.warn('[FEATURE FLAGS] Feature flags quota limit exceeded. Learn more about billing limits at https://posthog.com/docs/billing/limits-alerts');
                this.maybeNotifyRemoteConfig(triggerOnRemoteConfig, res);
                return res;
            }
            if (res?.featureFlags) {
                if (this.sendFeatureFlagEvent) this.flagCallReported = {};
                let newFeatureFlagDetails = res;
                if (res.errorsWhileComputingFlags) {
                    const currentFlagDetails = this.getKnownFeatureFlagDetails();
                    this._logger.info('Cached feature flags: ', JSON.stringify(currentFlagDetails));
                    const filteredFlags = {};
                    for(const key in res.flags)if (!res.flags[key].failed) filteredFlags[key] = res.flags[key];
                    newFeatureFlagDetails = {
                        ...res,
                        flags: {
                            ...currentFlagDetails?.flags,
                            ...filteredFlags
                        }
                    };
                }
                this.setKnownFeatureFlagDetails({
                    flags: newFeatureFlagDetails.flags,
                    requestId: res.requestId,
                    evaluatedAt: res.evaluatedAt,
                    errorsWhileComputingFlags: res.errorsWhileComputingFlags,
                    quotaLimited: res.quotaLimited
                });
                this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FlagsEndpointWasHit, true);
                this.cacheSessionReplay('flags', res);
                this.maybeNotifyRemoteConfig(triggerOnRemoteConfig, res);
            }
            return res;
        }).finally(()=>{
            this._flagsResponsePromise = void 0;
            const pendingRequest = this._pendingFlagsRequest;
            if (pendingRequest) {
                this._pendingFlagsRequest = void 0;
                this._logger.info('Executing pending feature flags reload.');
                this.flagsAsync({
                    sendAnonDistinctId: pendingRequest.sendAnonDistinctId,
                    fetchConfig: pendingRequest.fetchConfig,
                    triggerOnRemoteConfig: pendingRequest.triggerOnRemoteConfig
                }).then(pendingRequest.resolve).catch(pendingRequest.reject);
            }
        });
        return this._flagsResponsePromise;
    }
    setKnownFeatureFlagDetails(flagsResponse) {
        this.wrap(()=>{
            this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FeatureFlagDetails, flagsResponse);
            this._events.emit('featureflags', (0, external_featureFlagUtils_js_namespaceObject.getFlagValuesFromFlags)(flagsResponse?.flags ?? {}));
        });
    }
    getKnownFeatureFlagDetails() {
        const storedDetails = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FeatureFlagDetails);
        if (!storedDetails) {
            const featureFlags = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FeatureFlags);
            const featureFlagPayloads = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FeatureFlagPayloads);
            if (void 0 === featureFlags && void 0 === featureFlagPayloads) return;
            return (0, external_featureFlagUtils_js_namespaceObject.createFlagsResponseFromFlagsAndPayloads)(featureFlags ?? {}, featureFlagPayloads ?? {});
        }
        return (0, external_featureFlagUtils_js_namespaceObject.normalizeFlagsResponse)(storedDetails);
    }
    getStoredFlagDetails() {
        return this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FeatureFlagDetails);
    }
    getKnownFeatureFlags() {
        const featureFlagDetails = this.getKnownFeatureFlagDetails();
        if (!featureFlagDetails) return;
        return (0, external_featureFlagUtils_js_namespaceObject.getFlagValuesFromFlags)(featureFlagDetails.flags);
    }
    getBootstrappedFeatureFlagDetails() {
        const details = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.BootstrapFeatureFlagDetails);
        if (!details) return;
        return details;
    }
    setBootstrappedFeatureFlagDetails(details) {
        this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.BootstrapFeatureFlagDetails, details);
    }
    getBootstrappedFeatureFlags() {
        const details = this.getBootstrappedFeatureFlagDetails();
        if (!details) return;
        return (0, external_featureFlagUtils_js_namespaceObject.getFlagValuesFromFlags)(details.flags);
    }
    getBootstrappedFeatureFlagPayloads() {
        const details = this.getBootstrappedFeatureFlagDetails();
        if (!details) return;
        return (0, external_featureFlagUtils_js_namespaceObject.getPayloadsFromFlags)(details.flags);
    }
    getFeatureFlagResult(key, options) {
        return this._getFeatureFlagResult(key, options);
    }
    _getFeatureFlagResult(key, options = {}) {
        const storedDetails = this.getStoredFlagDetails();
        const details = this.getFeatureFlagDetails();
        const isQuotaLimited = storedDetails?.quotaLimited?.includes(external_posthog_core_stateless_js_namespaceObject.QuotaLimitedFeature.FeatureFlags);
        const featureFlag = details?.flags[key];
        const sendEvent = (options.sendEvent ?? this.sendFeatureFlagEvent) && !this.flagCallReported[key];
        const flagValue = (0, external_featureFlagUtils_js_namespaceObject.getFeatureFlagValue)(featureFlag);
        if (sendEvent) {
            const errors = [];
            if (storedDetails?.requestError) {
                const { type, statusCode } = storedDetails.requestError;
                if ('timeout' === type) errors.push(external_types_js_namespaceObject.FeatureFlagError.TIMEOUT);
                else if ('api_error' === type && void 0 !== statusCode) errors.push(external_types_js_namespaceObject.FeatureFlagError.apiError(statusCode));
                else if ('connection_error' === type) errors.push(external_types_js_namespaceObject.FeatureFlagError.CONNECTION_ERROR);
                else errors.push(external_types_js_namespaceObject.FeatureFlagError.UNKNOWN_ERROR);
            } else if (storedDetails) {
                if (storedDetails.errorsWhileComputingFlags) errors.push(external_types_js_namespaceObject.FeatureFlagError.ERRORS_WHILE_COMPUTING);
                if (isQuotaLimited) errors.push(external_types_js_namespaceObject.FeatureFlagError.QUOTA_LIMITED);
                else if (void 0 === flagValue && !featureFlag) errors.push(external_types_js_namespaceObject.FeatureFlagError.FLAG_MISSING);
            }
            const bootstrappedResponse = this.getBootstrappedFeatureFlags()?.[key];
            const bootstrappedPayload = this.getBootstrappedFeatureFlagPayloads()?.[key];
            const featureFlagError = errors.length > 0 ? errors.join(',') : void 0;
            this.flagCallReported[key] = true;
            const properties = {
                $feature_flag: key,
                $feature_flag_response: flagValue,
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_id', featureFlag?.metadata?.id),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_version', featureFlag?.metadata?.version),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_reason', featureFlag?.reason?.description ?? featureFlag?.reason?.code),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_bootstrapped_response', bootstrappedResponse),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_bootstrapped_payload', bootstrappedPayload),
                $used_bootstrap_value: !this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.FlagsEndpointWasHit),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_request_id', details?.requestId),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_evaluated_at', details?.evaluatedAt),
                ...(0, external_posthog_core_stateless_js_namespaceObject.maybeAdd)('$feature_flag_error', featureFlagError)
            };
            this.capture('$feature_flag_called', properties);
        }
        if (void 0 === flagValue) switch(options.missingFlagBehavior){
            case 'getFeatureFlagPayload':
                return details ? {
                    key,
                    enabled: false,
                    payload: null
                } : void 0;
            case 'getFeatureFlag':
                return details && Object.keys(details.flags).length ? {
                    key,
                    enabled: false,
                    payload: null
                } : void 0;
            case void 0:
                return;
        }
        const rawPayload = featureFlag?.metadata?.payload;
        const payload = void 0 !== rawPayload ? (0, external_featureFlagUtils_js_namespaceObject.parsePayload)(rawPayload) : null;
        return {
            key,
            enabled: (0, external_featureFlagUtils_js_namespaceObject.getEnabledFromValue)(flagValue),
            variant: (0, external_featureFlagUtils_js_namespaceObject.getVariantFromValue)(flagValue),
            payload
        };
    }
    getFeatureFlag(key) {
        const result = this._getFeatureFlagResult(key, {
            missingFlagBehavior: 'getFeatureFlag'
        });
        return result?.variant ?? result?.enabled;
    }
    getFeatureFlagPayload(key) {
        const result = this._getFeatureFlagResult(key, {
            missingFlagBehavior: 'getFeatureFlagPayload',
            sendEvent: false
        });
        return result?.payload;
    }
    getFeatureFlagPayloads() {
        return this.getFeatureFlagDetails()?.featureFlagPayloads;
    }
    getFeatureFlags() {
        return this.getFeatureFlagDetails()?.featureFlags;
    }
    getFeatureFlagDetails() {
        let details = this.getKnownFeatureFlagDetails();
        const overriddenFlags = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.OverrideFeatureFlags);
        if (!overriddenFlags) return details;
        details = details ?? {
            featureFlags: {},
            featureFlagPayloads: {},
            flags: {}
        };
        const flags = details.flags ?? {};
        for(const key in overriddenFlags)if (overriddenFlags[key]) flags[key] = (0, external_featureFlagUtils_js_namespaceObject.updateFlagValue)(flags[key], overriddenFlags[key]);
        else delete flags[key];
        const result = {
            ...details,
            flags
        };
        return (0, external_featureFlagUtils_js_namespaceObject.normalizeFlagsResponse)(result);
    }
    getFeatureFlagsAndPayloads() {
        const flags = this.getFeatureFlags();
        const payloads = this.getFeatureFlagPayloads();
        return {
            flags,
            payloads
        };
    }
    isFeatureEnabled(key) {
        const response = this.getFeatureFlag(key);
        if (void 0 === response) return;
        return !!response;
    }
    reloadFeatureFlags(options) {
        this.flagsAsync({
            sendAnonDistinctId: true
        }).then((res)=>{
            options?.cb?.(void 0, res?.featureFlags);
        }).catch((e)=>{
            options?.cb?.(e, void 0);
            if (!options?.cb) this._logger.info('Error reloading feature flags', e);
        });
    }
    async reloadRemoteConfigAsync() {
        return await this.remoteConfigAsync();
    }
    async reloadFeatureFlagsAsync(sendAnonDistinctId) {
        return (await this.flagsAsync({
            sendAnonDistinctId: sendAnonDistinctId
        }))?.featureFlags;
    }
    onFeatureFlags(cb) {
        return this.on('featureflags', async ()=>{
            const flags = this.getFeatureFlags();
            if (flags) cb(flags);
        });
    }
    onFeatureFlag(key, cb) {
        return this.on('featureflags', async ()=>{
            const flagResponse = this.getFeatureFlag(key);
            if (void 0 !== flagResponse) cb(flagResponse);
        });
    }
    async overrideFeatureFlag(flags) {
        this.wrap(()=>{
            if (null === flags) return this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.OverrideFeatureFlags, null);
            return this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.OverrideFeatureFlags, flags);
        });
    }
    captureException(error, additionalProperties) {
        const properties = {
            $exception_level: 'error',
            $exception_list: [
                {
                    type: (0, index_js_namespaceObject.isPlainError)(error) ? error.name : 'Error',
                    value: (0, index_js_namespaceObject.isPlainError)(error) ? error.message : error,
                    mechanism: {
                        handled: true,
                        synthetic: false
                    }
                }
            ],
            ...additionalProperties
        };
        this.capture('$exception', properties, {
            _originatedFromCaptureException: true
        });
    }
    captureTraceFeedback(traceId, userFeedback) {
        this.capture('$ai_feedback', {
            $ai_feedback_text: userFeedback,
            $ai_trace_id: String(traceId)
        });
    }
    captureTraceMetric(traceId, metricName, metricValue) {
        this.capture('$ai_metric', {
            $ai_metric_name: metricName,
            $ai_metric_value: String(metricValue),
            $ai_trace_id: String(traceId)
        });
    }
    _isIdentified() {
        const personMode = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.PersonMode);
        if ('identified' === personMode) return true;
        if (void 0 === personMode) {
            const distinctId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.DistinctId);
            const anonymousId = this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.AnonymousId);
            if (distinctId && anonymousId && distinctId !== anonymousId) return true;
        }
        return false;
    }
    _getGroups() {
        return this.props.$groups || {};
    }
    _hasPersonProcessing() {
        if ('always' === this._personProfiles) return true;
        if ('never' === this._personProfiles) return false;
        const isIdentified = this._isIdentified();
        const hasGroups = Object.keys(this._getGroups()).length > 0;
        const personProcessingEnabled = true === this.getPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.EnablePersonProcessing);
        return isIdentified || hasGroups || personProcessingEnabled;
    }
    _requirePersonProcessing(functionName) {
        if ('never' === this._personProfiles) {
            this._logger.error(`${functionName} was called, but personProfiles is set to "never". This call will be ignored.`);
            return false;
        }
        this.setPersistedProperty(external_types_js_namespaceObject.PostHogPersistedProperty.EnablePersonProcessing, true);
        return true;
    }
    createPersonProfile() {
        if (this._hasPersonProcessing()) return;
        if (!this._requirePersonProcessing('posthog.createPersonProfile')) return;
        this.capture('$set', {
            $set: {},
            $set_once: {}
        });
    }
    setPersonProperties(userPropertiesToSet, userPropertiesToSetOnce, reloadFeatureFlags = true) {
        this.wrap(()=>{
            const isSetEmpty = (0, index_js_namespaceObject.isNullish)(userPropertiesToSet) || (0, index_js_namespaceObject.isEmptyObject)(userPropertiesToSet);
            const isSetOnceEmpty = (0, index_js_namespaceObject.isNullish)(userPropertiesToSetOnce) || (0, index_js_namespaceObject.isEmptyObject)(userPropertiesToSetOnce);
            if (isSetEmpty && isSetOnceEmpty) return;
            if (!this._requirePersonProcessing('posthog.setPersonProperties')) return;
            const hash = (0, index_js_namespaceObject.getPersonPropertiesHash)(this.getDistinctId(), userPropertiesToSet, userPropertiesToSetOnce);
            if (this._cachedPersonProperties === hash) return void this._logger.info('A duplicate setPersonProperties call was made with the same properties. It has been ignored.');
            const mergedProperties = {
                ...userPropertiesToSetOnce || {},
                ...userPropertiesToSet || {}
            };
            this.setPersonPropertiesForFlags(mergedProperties, reloadFeatureFlags);
            this.capture('$set', {
                $set: userPropertiesToSet || {},
                $set_once: userPropertiesToSetOnce || {}
            });
            this._cachedPersonProperties = hash;
        });
    }
    processBeforeEnqueue(message) {
        if (!this._beforeSend) return message;
        const timestamp = message.timestamp;
        const props = message.properties || {};
        const captureEvent = {
            uuid: message.uuid,
            event: message.event,
            properties: props,
            $set: props.$set,
            $set_once: props.$set_once,
            timestamp: 'string' == typeof timestamp ? new Date(timestamp) : timestamp
        };
        const result = this._runBeforeSend(captureEvent);
        if (!result) return null;
        const resultProps = {
            ...result.properties ?? props
        };
        if (void 0 !== result.$set) resultProps.$set = result.$set;
        else delete resultProps.$set;
        if (void 0 !== result.$set_once) resultProps.$set_once = result.$set_once;
        else delete resultProps.$set_once;
        return {
            ...message,
            uuid: result.uuid ?? message.uuid,
            event: result.event,
            properties: resultProps,
            timestamp: result.timestamp
        };
    }
    _runBeforeSend(captureEvent) {
        const beforeSend = this._beforeSend;
        if (!beforeSend) return captureEvent;
        const fns = Array.isArray(beforeSend) ? beforeSend : [
            beforeSend
        ];
        let result = captureEvent;
        for (const fn of fns)try {
            result = fn(result);
            if (!result) {
                this._logger.info(`Event '${captureEvent.event}' was rejected in before_send function`);
                return null;
            }
        } catch (e) {
            this._logger.error(`Error in before_send function for event '${captureEvent.event}':`, e);
        }
        return result;
    }
}
exports.PostHogCore = __webpack_exports__.PostHogCore;
for(var __webpack_i__ in __webpack_exports__)if (-1 === [
    "PostHogCore"
].indexOf(__webpack_i__)) exports[__webpack_i__] = __webpack_exports__[__webpack_i__];
Object.defineProperty(exports, '__esModule', {
    value: true
});
