/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moskovan normaaliaika",
               "",
               "Moskovan kes\u00e4aika",
               "",
               "Moskovan aika",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanin normaaliaika",
               "",
               "Pakistanin kes\u00e4aika",
               "",
               "Pakistanin aika",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanin normaaliaika",
               "",
               "Magadanin kes\u00e4aika",
               "",
               "Magadanin aika",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Keski-Euroopan normaaliaika",
               "",
               "Keski-Euroopan kes\u00e4aika",
               "",
               "Keski-Euroopan aika",
               "",
            };
        final String[] Acre = new String[] {
               "Acren normaaliaika",
               "",
               "Acren kes\u00e4aika",
               "",
               "Acren aika",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Yhdysvaltain it\u00e4inen normaaliaika",
               "",
               "Yhdysvaltain it\u00e4inen kes\u00e4aika",
               "",
               "Yhdysvaltain it\u00e4inen aika",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howen normaaliaika",
               "",
               "Lord Howen kes\u00e4aika",
               "",
               "Lord Howen aika",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Uuden-Seelannin normaaliaika",
               "",
               "Uuden-Seelannin kes\u00e4aika",
               "",
               "Uuden-Seelannin aika",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Intian valtameren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskin normaaliaika",
               "",
               "Jakutskin kes\u00e4aika",
               "",
               "Jakutskin aika",
               "",
            };
        final String[] East_Timor = new String[] {
               "It\u00e4-Timorin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosraen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "It\u00e4-Euroopan normaaliaika",
               "",
               "It\u00e4-Euroopan kes\u00e4aika",
               "",
               "It\u00e4-Euroopan aika",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "L\u00e4nsi-Argentiinan normaaliaika",
               "",
               "L\u00e4nsi-Argentiinan kes\u00e4aika",
               "",
               "L\u00e4nsi-Argentiinan aika",
               "",
            };
        final String[] Ponape = new String[] {
               "Pohnpein aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierren ja Miquelonin normaaliaika",
               "",
               "Saint-Pierren ja Miquelonin kes\u00e4aika",
               "",
               "Saint-Pierren ja Miquelonin aika",
               "",
            };
        final String[] Indochina = new String[] {
               "Indokiinan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgin normaaliaika",
               "",
               "Jekaterinburgin kes\u00e4aika",
               "",
               "Jekaterinburgin aika",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediivien aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallisin ja Futunan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Etel\u00e4-Afrikan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linesaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistanin normaaliaika",
               "",
               "Uzbekistanin kes\u00e4aika",
               "",
               "Uzbekistanin aika",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorin normaaliaika",
               "",
               "Ulan Batorin kes\u00e4aika",
               "",
               "Ulan Batorin aika",
               "",
            };
        final String[] America_Central = new String[] {
               "Yhdysvaltain keskinen normaaliaika",
               "",
               "Yhdysvaltain keskinen kes\u00e4aika",
               "",
               "Yhdysvaltain keskinen aika",
               "",
            };
        final String[] Niue = new String[] {
               "Niuen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waken aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinsaarten normaaliaika",
               "",
               "Falklandinsaarten kes\u00e4aika",
               "",
               "Falklandinsaarten aika",
               "",
            };
        final String[] Apia = new String[] {
               "Apian normaaliaika",
               "",
               "Apian kes\u00e4aika",
               "",
               "Apian aika",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Naurun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "L\u00e4nsi-Kazakstanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Joulusaaren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kookossaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamin normaaliaika",
               "",
               "Chathamin kes\u00e4aika",
               "",
               "Chathamin aika",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentiinan normaaliaika",
               "",
               "Argentiinan kes\u00e4aika",
               "",
               "Argentiinan aika",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiersaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1pagossaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verden normaaliaika",
               "",
               "Kap Verden kes\u00e4aika",
               "",
               "Kap Verden aika",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinsaaren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoan normaaliaika",
               "",
               "Samoan kes\u00e4aika",
               "",
               "Samoan aika",
               "",
            };
        final String[] Davis = new String[] {
               "Davisin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuuban normaaliaika",
               "",
               "Kuuban kes\u00e4aika",
               "",
               "Kuuban aika",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwichin normaaliaika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippiinien normaaliaika",
               "",
               "Filippiinien kes\u00e4aika",
               "",
               "Filippiinien aika",
               "",
            };
        final String[] French_Southern = new String[] {
               "Ranskan etel\u00e4isten ja antarktisten alueiden aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Uuden-Kaledonian normaaliaika",
               "",
               "Uuden-Kaledonian kes\u00e4aika",
               "",
               "Uuden-Kaledonian aika",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunein aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iranin normaaliaika",
               "",
               "Iranin kes\u00e4aika",
               "",
               "Iranin aika",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongan normaaliaika",
               "",
               "Tongan kes\u00e4aika",
               "",
               "Tongan aika",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshin normaaliaika",
               "",
               "Bangladeshin kes\u00e4aika",
               "",
               "Bangladeshin aika",
               "",
            };
        final String[] Peru = new String[] {
               "Perun normaaliaika",
               "",
               "Perun kes\u00e4aika",
               "",
               "Perun aika",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "It\u00e4-Gr\u00f6nlannin normaaliaika",
               "",
               "It\u00e4-Gr\u00f6nlannin kes\u00e4aika",
               "",
               "It\u00e4-Gr\u00f6nlannin aika",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "It\u00e4-Indonesian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "It\u00e4-Australian normaaliaika",
               "",
               "It\u00e4-Australian kes\u00e4aika",
               "",
               "It\u00e4-Australian aika",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ranskan Guayanan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbian normaaliaika",
               "",
               "Kolumbian kes\u00e4aika",
               "",
               "Kolumbian aika",
               "",
            };
        final String[] Chile = new String[] {
               "Chilen normaaliaika",
               "",
               "Chilen kes\u00e4aika",
               "",
               "Chilen aika",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskin normaaliaika",
               "",
               "Irkutskin kes\u00e4aika",
               "",
               "Irkutskin aika",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgian normaaliaika",
               "",
               "Georgian kes\u00e4aika",
               "",
               "Georgian aika",
               "",
            };
        final String[] Choibalsan = new String[] {
               "T\u0161oibalsan normaaliaika",
               "",
               "T\u0161oibalsan kes\u00e4aika",
               "",
               "T\u0161oibalsan aika",
               "",
            };
        final String[] China = new String[] {
               "Kiinan normaaliaika",
               "",
               "Kiinan kes\u00e4aika",
               "",
               "Kiinan aika",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenian normaaliaika",
               "",
               "Armenian kes\u00e4aika",
               "",
               "Armenian aika",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Keski-Afrikan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japanin normaaliaika",
               "",
               "Japanin kes\u00e4aika",
               "",
               "Japanin aika",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipein normaaliaika",
               "",
               "Taipein kes\u00e4aika",
               "",
               "Taipein aika",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdin normaaliaika",
               "",
               "Hovdin kes\u00e4aika",
               "",
               "Hovdin aika",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "L\u00e4ntisen Keski-Australian normaaliaika",
               "",
               "L\u00e4ntisen Keski-Australian kes\u00e4aika",
               "",
               "L\u00e4ntisen Keski-Australian aika",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinin normaaliaika",
               "",
               "Sahalinin kes\u00e4aika",
               "",
               "Sahalinin aika",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayn normaaliaika",
               "",
               "Paraguayn kes\u00e4aika",
               "",
               "Paraguayn aika",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malesian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "UTC-yleisaika",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiuksen normaaliaika",
               "",
               "Mauritiuksen kes\u00e4aika",
               "",
               "Mauritiuksen aika",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "It\u00e4-Afrikan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinsaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandin normaaliaika",
               "",
               "Newfoundlandin kes\u00e4aika",
               "",
               "Newfoundlandin aika",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongin normaaliaika",
               "",
               "Hongkongin kes\u00e4aika",
               "",
               "Hongkongin aika",
               "",
            };
        final String[] Atlantic = new String[] {
               "Kanadan Atlantin normaaliaika",
               "",
               "Kanadan Atlantin kes\u00e4aika",
               "",
               "Kanadan Atlantin aika",
               "",
            };
        final String[] Israel = new String[] {
               "Israelin normaaliaika",
               "",
               "Israelin kes\u00e4aika",
               "",
               "Israelin aika",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Keski-Indonesian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskin normaaliaika",
               "",
               "Omskin kes\u00e4aika",
               "",
               "Omskin aika",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellien aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayn normaaliaika",
               "",
               "Uruguayn kes\u00e4aika",
               "",
               "Uruguayn aika",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatun normaaliaika",
               "",
               "Vanuatun kes\u00e4aika",
               "",
               "Vanuatun aika",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskin normaaliaika",
               "",
               "Novosibirskin kes\u00e4aika",
               "",
               "Novosibirskin aika",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azorien normaaliaika",
               "",
               "Azorien kes\u00e4aika",
               "",
               "Azorien aika",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskin normaaliaika",
               "",
               "Krasnojarskin kes\u00e4aika",
               "",
               "Krasnojarskin aika",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonin normaaliaika",
               "",
               "Amazonin kes\u00e4aika",
               "",
               "Amazonin aika",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "It\u00e4-Kazakstanin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ein normaaliaika",
               "",
               "Fid\u017ein kes\u00e4aika",
               "",
               "Fid\u017ein aika",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamt\u0161atkan normaaliaika",
               "",
               "Kamt\u0161atkan kes\u00e4aika",
               "",
               "Kamt\u0161atkan aika",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquariensaaren aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaijin-Aleuttien normaaliaika",
               "",
               "Havaijin-Aleuttien kes\u00e4aika",
               "",
               "Havaijin-Aleuttien aika",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Keski-Australian normaaliaika",
               "",
               "Keski-Australian kes\u00e4aika",
               "",
               "Keski-Australian aika",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Yhdysvaltain Tyynenmeren normaaliaika",
               "",
               "Yhdysvaltain Tyynenmeren kes\u00e4aika",
               "",
               "Yhdysvaltain Tyynenmeren aika",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistanin normaaliaika",
               "",
               "Turkmenistanin kes\u00e4aika",
               "",
               "Turkmenistanin aika",
               "",
            };
        final String[] Europe_Western = new String[] {
               "L\u00e4nsi-Euroopan normaaliaika",
               "",
               "L\u00e4nsi-Euroopan kes\u00e4aika",
               "",
               "L\u00e4nsi-Euroopan aika",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyanan aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotheran aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palaun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017eanin normaaliaika",
               "",
               "Azerbaid\u017eanin kes\u00e4aika",
               "",
               "Azerbaid\u017eanin aika",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikon Tyynenmeren normaaliaika",
               "",
               "Meksikon Tyynenmeren kes\u00e4aika",
               "",
               "Meksikon Tyynenmeren aika",
               "",
            };
        final String[] Africa_Western = new String[] {
               "L\u00e4nsi-Afrikan normaaliaika",
               "",
               "L\u00e4nsi-Afrikan kes\u00e4aika",
               "",
               "L\u00e4nsi-Afrikan aika",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Etel\u00e4-Georgian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradin normaaliaika",
               "",
               "Volgogradin kes\u00e4aika",
               "",
               "Volgogradin aika",
               "",
            };
        final String[] Easter = new String[] {
               "P\u00e4\u00e4si\u00e4issaaren normaaliaika",
               "",
               "P\u00e4\u00e4si\u00e4issaaren kes\u00e4aika",
               "",
               "P\u00e4\u00e4si\u00e4issaaren aika",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Luoteis-Meksikon normaaliaika",
               "",
               "Luoteis-Meksikon kes\u00e4aika",
               "",
               "Luoteis-Meksikon aika",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont d\u2019Urvillen aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "L\u00e4nsi-Gr\u00f6nlannin normaaliaika",
               "",
               "L\u00e4nsi-Gr\u00f6nlannin kes\u00e4aika",
               "",
               "L\u00e4nsi-Gr\u00f6nlannin aika",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorin aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Arabiemiirikuntien normaaliaika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korean normaaliaika",
               "",
               "Korean kes\u00e4aika",
               "",
               "Korean aika",
               "",
            };
        final String[] Australia_Western = new String[] {
               "L\u00e4nsi-Australian normaaliaika",
               "",
               "L\u00e4nsi-Australian kes\u00e4aika",
               "",
               "L\u00e4nsi-Australian aika",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "L\u00e4nsi-Indonesian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kalliovuorten normaaliaika",
               "",
               "Kalliovuorten kes\u00e4aika",
               "",
               "Kalliovuorten aika",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesassaarten aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saudi-Arabian normaaliaika",
               "",
               "Saudi-Arabian kes\u00e4aika",
               "",
               "Saudi-Arabian aika",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaskan normaaliaika",
               "",
               "Alaskan kes\u00e4aika",
               "",
               "Alaskan aika",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokin normaaliaika",
               "",
               "Vladivostokin kes\u00e4aika",
               "",
               "Vladivostokin aika",
               "",
            };
        final String[] Chamorro = new String[] {
               "T\u0161amorron aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaun aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Uuden-Guinean aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhan normaaliaika",
               "",
               "Fernando de Noronhan kes\u00e4aika",
               "",
               "Fernando de Noronhan aika",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasilian normaaliaika",
               "",
               "Brasilian kes\u00e4aika",
               "",
               "Brasilian aika",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrin normaaliaika",
               "",
               "Anadyrin kes\u00e4aika",
               "",
               "Anadyrin aika",
               "",
            };
        final String[] Samara = new String[] {
               "Samaran normaaliaika",
               "",
               "Samaran kes\u00e4aika",
               "",
               "Samaran aika",
               "",
            };
        final String[] India = new String[] {
               "Intian aika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinsaarten normaaliaika",
               "",
               "Cookinsaarten kes\u00e4aika",
               "",
               "Cookinsaarten aika",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesassaaret" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwichin normaaliaika",
                    "",
                    "Britannian kes\u00e4aika",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Pohjois-Dakota" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinna" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Lontoo" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "T\u0161oibalsa" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berliini" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midwaysaaret" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Pohjois-Dakota" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Etel\u00e4-Georgia" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Rooma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Pohjois-Dakota" },
            { "timezone.excity.Asia/Atyrau", "At\u0131raw" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "tuntematon" },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquariensaari" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Handyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichin normaaliaika",
                    "",
                    "Irlannin kes\u00e4aika",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Mansaari" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Pariisi" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "T\u0161ita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskova" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichin normaaliaika",
                    "",
                    "Britannian kes\u00e4aika",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azorit" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Joulusaari" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtaw" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chi\u015fin\u0103u" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kamt\u0161atka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "P\u00e4\u00e4si\u00e4issaari" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Kanariansaaret" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varsova" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatikaani" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelensaaret" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Ateena" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "K\u00f6\u00f6penhamina" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jerusalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damaskos" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "H\u1ed3 Ch\u00ed Minhin kaupunki" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Pacific/Gambier", "Gambiersaaret" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zapori\u017e\u017eja" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chathamsaaret" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riika" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Q\u0131z\u0131lorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Maarianhamina" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago de Chile" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Europe/Kiev", "Kiova" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4rsaaret" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0161gabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Kookossaaret" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bryssel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komorit" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Tukholma" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Malediivit" },
        };
        return data;
    }
}
