/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_vi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ALK = "ALK";
        final String metaValue_CNX = "CNX";
        final String metaValue_ILR = "ILR";
        final String metaValue_ISJ = "ISJ";
        final String metaValue_MVP = "MVP";
        final String metaValue_UYW = "UYW";
        final String metaValue_XSU = "XSU";
        final String metaValue_XUA = "XUA";
        final Object[][] data = new Object[][] {
            { "mwk", "Kwacha Malawi" },
            { "aon", "\u0110\u1ed3ng Kwanza M\u1edbi c\u1ee7a Angola (1990\u20132000)" },
            { "lul", "\u0110\u1ed3ng Franc Luxembourg t\u00e0i ch\u00ednh" },
            { "bad", "\u0110\u1ed3ng Dinar c\u1ee7a Bosnia-Herzegovina (1992\u20131994)" },
            { "aor", "\u0110\u1ed3ng Kwanza \u0110i\u1ec1u ch\u1ec9nh l\u1ea1i c\u1ee7a Angola (1995\u20131999)" },
            { "mga", "Ariary Malagasy" },
            { "nic", "\u0110\u1ed3ng C\u00f3rdoba Nicaragua (1988\u20131991)" },
            { "fim", "\u0110\u1ed3ng Markka Ph\u1ea7n Lan" },
            { "STN", "STN" },
            { "dem", "\u0110\u1ed3ng Mark \u0110\u1ee9c" },
            { "mgf", "\u0110\u1ed3ng Franc Magalasy" },
            { "ban", "\u0110\u1ed3ng Dinar M\u1edbi c\u1ee7a Bosnia-Herzegovina (1994\u20131997)" },
            { "bam", "Mark Bosnia-Herzegovina c\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i" },
            { "egp", "B\u1ea3ng Ai C\u1eadp" },
            { "ssp", "B\u1ea3ng Nam Sudan" },
            { "brc", "\u0110\u1ed3ng Cruzado c\u1ee7a Braxin (1986\u20131989)" },
            { "brb", "\u0110\u1ed3ng Cruzerio M\u1edbi c\u1ee7a Braxin (1967\u20131986)" },
            { "bre", "\u0110\u1ed3ng Cruzerio c\u1ee7a Braxin (1990\u20131993)" },
            { "nio", "C\u00f3rdoba Nicaragua" },
            { "nzd", "\u0110\u00f4 la New Zealand" },
            { "brl", "Real Braxin" },
            { "brn", "\u0110\u1ed3ng Cruzado M\u1edbi c\u1ee7a Braxin (1989\u20131990)" },
            { "ugs", "\u0110\u1ed3ng Shilling Uganda (1966\u20131987)" },
            { "fjd", "\u0110\u00f4 la Fiji" },
            { "mxn", "Peso Mexico" },
            { "std", "Dobra S\u00e3o Tom\u00e9 v\u00e0 Pr\u00edncipe (1977\u20132017)" },
            { "brr", "\u0110\u1ed3ng Cruzeiro c\u1ee7a Braxin (1993\u20131994)" },
            { "lvl", "Lats Latvia" },
            { "scr", "Rupee Seychelles" },
            { "cdf", "Franc Congo" },
            { "mxp", "\u0110\u1ed3ng Peso B\u1ea1c M\u00ea-hi-c\u00f4 (1861\u20131992)" },
            { "zal", "\u0110\u1ed3ng Rand Nam Phi (t\u00e0i ch\u00ednh)" },
            { "bbd", "\u0110\u00f4 la Barbados" },
            { "hnl", "Lempira Honduras" },
            { "ugx", "Shilling Uganda" },
            { "lvr", "\u0110\u1ed3ng R\u00fap Latvia" },
            { "mxv", "\u0110\u01a1n v\u1ecb \u0110\u1ea7u t\u01b0 M\u00ea-hi-c\u00f4" },
            { "zar", "Rand Nam Phi" },
            { "brz", "\u0110\u1ed3ng Cruzeiro c\u1ee7a Braxin (1942\u20131967)" },
            { "stn", "Dobra S\u00e3o Tom\u00e9 v\u00e0 Pr\u00edncipe" },
            { "cuc", "Peso Cuba c\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i" },
            { "UYW", metaValue_UYW },
            { "bsd", "\u0110\u00f4 la Bahamas" },
            { "sdd", "\u0110\u1ed3ng Dinar Sudan (1992\u20132007)" },
            { "sdg", "B\u1ea3ng Sudan" },
            { "zrn", "\u0110\u1ed3ng Zaire M\u1edbi (1993\u20131998)" },
            { "iqd", "Dinar I-r\u1eafc" },
            { "sdp", "\u0110\u1ed3ng B\u1ea3ng Sudan (1957\u20131998)" },
            { "cup", "Peso Cuba" },
            { "gmd", "Dalasi Gambia" },
            { "twd", "\u0110\u00f4 la \u0110\u00e0i Loan m\u1edbi" },
            { "rsd", "Dinar Serbia" },
            { "zrz", "\u0110\u1ed3ng Zaire (1971\u20131993)" },
            { "uyi", "\u0110\u1ed3ng Peso Uruguay (\u0110\u01a1n v\u1ecb Theo ch\u1ec9 s\u1ed1)" },
            { "myr", "Ringgit Malaysia" },
            { "fkp", "B\u1ea3ng Qu\u1ea7n \u0111\u1ea3o Falkland" },
            { "uyp", "\u0110\u1ed3ng Peso Uruguay (1975\u20131993)" },
            { "xof", "Franc CFA T\u00e2y Phi" },
            { "THB", "\u0e3f" },
            { "uyu", "Peso Uruguay" },
            { "ara", "\u0110\u1ed3ng Austral c\u1ee7a Argentina" },
            { "sur", "\u0110\u1ed3ng R\u00fap S\u00f4 vi\u1ebft" },
            { "uyw", metaValue_UYW },
            { "cve", "Escudo Cape Verde" },
            { "omr", "Rial Oman" },
            { "kes", "Shilling Kenya" },
            { "sek", "Krona Th\u1ee5y \u0110i\u1ec3n" },
            { "mze", "Escudo Mozambique" },
            { "arl", "\u0110\u1ed3ng Peso Ley c\u1ee7a Argentina (1970\u20131983)" },
            { "arm", "\u0110\u1ed3ng Peso Argentina (1881\u20131970)" },
            { "btn", "Ngultrum Bhutan" },
            { "arp", "\u0110\u1ed3ng Peso Argentina (1983\u20131985)" },
            { "gnf", "Franc Guinea" },
            { "mzn", "Metical Mozambique" },
            { "ISJ", metaValue_ISJ },
            { "mzm", "\u0110\u1ed3ng Metical Mozambique (1980\u20132006)" },
            { "svc", "Col\u00f3n El Salvador" },
            { "ars", "Peso Argentina" },
            { "qar", "Rial Qatar" },
            { "irr", "Rial Iran" },
            { "nlg", "\u0110\u1ed3ng Guilder H\u00e0 Lan" },
            { "gns", "Syli Guinea" },
            { "xpd", "Paladi" },
            { "thb", "B\u1ea1t Th\u00e1i Lan" },
            { "uzs", "Som Uzbekistan" },
            { "xpf", "Franc CFP" },
            { "bdt", "Taka Bangladesh" },
            { "lyd", "Dinar Libi" },
            { "buk", "\u0110\u1ed3ng Kyat Mi\u1ebfn \u0110i\u1ec7n" },
            { "kwd", "Dinar Kuwait" },
            { "xpt", "B\u1ea1ch kim" },
            { "rub", "R\u00fap Nga" },
            { "isk", "Kr\u00f3na Iceland" },
            { "isj", metaValue_ISJ },
            { "bec", "\u0110\u1ed3ng Franc B\u1ec9 (c\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i)" },
            { "bef", "\u0110\u1ed3ng Franc B\u1ec9" },
            { "mkd", "Denar Macedonia" },
            { "bel", "\u0110\u1ed3ng Franc B\u1ec9 (t\u00e0i ch\u00ednh)" },
            { "rur", "\u0110\u1ed3ng R\u00fap Nga (1991\u20131998)" },
            { "dzd", "Dinar Algeria" },
            { "AUD", "AU$" },
            { "pab", "Balboa Panama" },
            { "mkn", "\u0110\u1ed3ng Denar Macedonia (1992\u20131993)" },
            { "sgd", "\u0110\u00f4 la Singapore" },
            { "kgs", "Som Kyrgyzstan" },
            { "hrd", "\u0110\u1ed3ng Dinar Croatia" },
            { "xaf", "Franc CFA Trung Phi" },
            { "xag", "B\u1ea1c" },
            { "chf", "Franc Th\u1ee5y s\u0129" },
            { "hrk", "Kuna Croatia" },
            { "itl", "Lia \u00dd" },
            { "ats", "\u0110\u1ed3ng Schiling \u00c1o" },
            { "che", "\u0110\u1ed3ng Euro WIR" },
            { "djf", "Franc Djibouti" },
            { "mlf", "\u0110\u1ed3ng Franc Mali" },
            { "xre", "Qu\u1ef9 RINET" },
            { "adp", "\u0110\u1ed3ng Peseta c\u1ee7a Andora" },
            { "tzs", "Shilling Tanzania" },
            { "vnd", "\u0110\u1ed3ng Vi\u1ec7t Nam" },
            { "xau", "V\u00e0ng" },
            { "aud", "\u0110\u00f4 la Australia" },
            { "chw", "\u0110\u1ed3ng France WIR" },
            { "khr", "Riel Campuchia" },
            { "idr", "Rupiah Indonesia" },
            { "xba", "\u0110\u01a1n v\u1ecb T\u1ed5ng h\u1ee3p Ch\u00e2u \u00c2u" },
            { "kyd", "\u0110\u00f4 la Qu\u1ea7n \u0111\u1ea3o Cayman" },
            { "vnn", "\u0110\u1ed3ng Vi\u1ec7t Nam (1978\u20131985)" },
            { "xbc", "\u0110\u01a1n v\u1ecb K\u1ebf to\u00e1n Ch\u00e2u \u00c2u (XBC)" },
            { "ydd", "\u0110\u1ed3ng Dinar Yemen" },
            { "xbb", "\u0110\u01a1n v\u1ecb Ti\u1ec1n t\u1ec7 Ch\u00e2u \u00c2u" },
            { "bwp", "Pula Botswana" },
            { "gqe", "\u0110\u1ed3ng Ekwele c\u1ee7a Guinea X\u00edch \u0110\u1ea1o" },
            { "shp", "B\u1ea3ng St. Helena" },
            { "XSU", metaValue_XSU },
            { "cyp", "\u0110\u1ed3ng B\u1ea3ng S\u00edp" },
            { "xbd", "\u0110\u01a1n v\u1ecb K\u1ebf to\u00e1n Ch\u00e2u \u00c2u (XBD)" },
            { "tjs", "Somoni Tajikistan" },
            { "tjr", "\u0110\u1ed3ng R\u00fap Tajikistan" },
            { "rwf", "Franc Rwanda" },
            { "aed", "Dirham UAE" },
            { "dkk", "Krone \u0110an M\u1ea1ch" },
            { "bgl", "\u0110\u1ed3ng Lev Xu c\u1ee7a Bun-ga-ri" },
            { "zwd", "\u0110\u1ed3ng \u0110\u00f4 la Zimbabwe (1980\u20132008)" },
            { "bgn", "Lev Bulgaria" },
            { "bgm", "\u0110\u1ed3ng Lev X\u00e3 h\u1ed9i ch\u1ee7 ngh\u0129a c\u1ee7a Bun-ga-ri" },
            { "yud", "\u0110\u1ed3ng Dinar Nam T\u01b0 Xu (1966\u20131990)" },
            { "mmk", "Kyat Myanma" },
            { "bgo", "\u0110\u1ed3ng Lev c\u1ee7a Bun-ga-ri (1879\u20131952)" },
            { "nok", "Krone Na Uy" },
            { "syp", "B\u1ea3ng Syria" },
            { "zwl", "\u0110\u1ed3ng \u0110\u00f4 la Zimbabwe (2009)" },
            { "yum", "\u0110\u1ed3ng Dinar Nam T\u01b0 M\u1edbi (1994\u20132002)" },
            { "lkr", "Rupee Sri Lanka" },
            { "yun", "\u0110\u1ed3ng Dinar Nam T\u01b0 C\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i (1990\u20131992)" },
            { "zwr", "\u0110\u1ed3ng \u0110\u00f4 la Zimbabwe (2008)" },
            { "czk", "Koruna C\u1ed9ng h\u00f2a S\u00e9c" },
            { "iep", "Pao Ai-len" },
            { "BYN", "BYN" },
            { "yur", "\u0110\u1ed3ng Dinar Nam T\u01b0 T\u00e1i c\u01a1 c\u1ea5u (1992\u20131993)" },
            { "grd", "Drachma Hy L\u1ea1p" },
            { "xcd", "\u0110\u00f4 la \u0110\u00f4ng Carib\u00ea" },
            { "htg", "Gourde Haiti" },
            { "xsu", metaValue_XSU },
            { "afa", "\u0110\u1ed3ng Afghani c\u1ee7a Afghanistan (1927\u20132002)" },
            { "bhd", "Dinar Bahrain" },
            { "sit", "T\u00f4la Xl\u00f4v\u00eania" },
            { "pte", "\u0110\u1ed3ng Escudo B\u1ed3 \u0110\u00e0o Nha" },
            { "kzt", "Tenge Kazakhstan" },
            { "szl", "Lilangeni Swaziland" },
            { "XUA", metaValue_XUA },
            { "yer", "Rial Yemen" },
            { "afn", "Afghani Afghanistan" },
            { "byb", "\u0110\u1ed3ng R\u00fap M\u1edbi c\u1ee7a Belarus (1994\u20131999)" },
            { "rhd", "\u0110\u1ed3ng \u0110\u00f4 la Rhode" },
            { "awg", "Florin Aruba" },
            { "npr", "Rupee Nepal" },
            { "mnt", "Tugrik M\u00f4ng C\u1ed5" },
            { "gbp", "B\u1ea3ng Anh" },
            { "byn", "R\u00fap Belarus" },
            { "xts", "M\u00e3 Ti\u1ec1n t\u1ec7 Ki\u1ec3m tra" },
            { "huf", "Forint Hungary" },
            { "byr", "R\u00fap Belarus (2000\u20132016)" },
            { "bif", "Franc Burundi" },
            { "xua", metaValue_XUA },
            { "xdr", "Quy\u1ec1n R\u00fat v\u1ed1n \u0110\u1eb7c bi\u1ec7t" },
            { "bzd", "\u0110\u00f4 la Belize" },
            { "mop", "Pataca Ma Cao" },
            { "nad", "\u0110\u00f4 la Namibia" },
            { "skk", "Cuaron Xl\u00f4v\u00e1c" },
            { "pei", "\u0110\u1ed3ng Inti Peru" },
            { "tmm", "\u0110\u1ed3ng Manat Turkmenistan (1993\u20132009)" },
            { "pen", "Sol Peru" },
            { "wst", "Tala Samoa" },
            { "tmt", "Manat Turkmenistan" },
            { "frf", "Franc Ph\u00e1p" },
            { "clf", "\u0110\u01a1n v\u1ecb K\u1ebf to\u00e1n c\u1ee7a Chile (UF)" },
            { "cle", "\u0110\u1ed3ng Escudo c\u1ee7a Chile" },
            { "pes", "\u0110\u1ed3ng Sol Peru (1863\u20131965)" },
            { "gtq", "Quetzal Guatemala" },
            { "clp", "Peso Chile" },
            { "xeu", "\u0110\u01a1n v\u1ecb Ti\u1ec1n Ch\u00e2u \u00c2u" },
            { "tnd", "Dinar Tunisia" },
            { "sll", "Leone Sierra Leone" },
            { "CNH", "CNH" },
            { "xfo", "\u0110\u1ed3ng France Ph\u00e1p V\u00e0ng" },
            { "dop", "Peso Dominica" },
            { "kmf", "Franc Comoros" },
            { "xfu", "\u0110\u1ed3ng UIC-Franc Ph\u00e1p" },
            { "CNX", metaValue_CNX },
            { "gek", "\u0110\u1ed3ng Kupon Larit c\u1ee7a Georgia" },
            { "gel", "Lari Gruzia" },
            { "mad", "Dirham Ma-r\u1ed1c" },
            { "maf", "\u0110\u1ed3ng Franc Ma-r\u1ed1c" },
            { "azn", "Manat Azerbaijan" },
            { "top", "Pa\u02bbanga Tonga" },
            { "azm", "\u0110\u1ed3ng Manat c\u1ee7a Azerbaijan (1993\u20132006)" },
            { "pgk", "Kina Papua New Guinean" },
            { "XXX", "XXX" },
            { "cnh", "Nh\u00e2n d\u00e2n t\u1ec7 (h\u1ea3i ngo\u1ea1i)" },
            { "uah", "Hryvnia Ucraina" },
            { "uak", "\u0110\u1ed3ng Karbovanets Ucraina" },
            { "ern", "Nakfa Eritrea" },
            { "tpe", "\u0110\u1ed3ng Escudo Timor" },
            { "mro", "Ouguiya Mauritania (1973\u20132017)" },
            { "cnx", metaValue_CNX },
            { "cny", "Nh\u00e2n d\u00e2n t\u1ec7" },
            { "mru", "Ouguiya Mauritania" },
            { "esa", "\u0110\u1ed3ng Peseta T\u00e2y Ban Nha (T\u00e0i kho\u1ea3n)" },
            { "gwe", "\u0110\u1ed3ng Guinea Escudo B\u1ed3 \u0110\u00e0o Nha" },
            { "esb", "\u0110\u1ed3ng Peseta T\u00e2y Ban Nha (t\u00e0i kho\u1ea3n c\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i)" },
            { "bmd", "\u0110\u00f4 la Bermuda" },
            { "php", "Peso Philipin" },
            { "xxx", "Ti\u1ec1n t\u1ec7 ch\u01b0a bi\u1ebft" },
            { "pyg", "Guarani Paraguay" },
            { "ALK", metaValue_ALK },
            { "jmd", "\u0110\u00f4 la Jamaica" },
            { "gwp", "Peso Guinea-Bissau" },
            { "esp", "\u0110\u1ed3ng Peseta T\u00e2y Ban Nha" },
            { "cop", "Peso Colombia" },
            { "usd", "\u0110\u00f4 la M\u1ef9" },
            { "cou", "\u0110\u01a1n v\u1ecb Gi\u00e1 tr\u1ecb Th\u1ef1c c\u1ee7a Colombia" },
            { "ILR", metaValue_ILR },
            { "mcf", "\u0110\u1ed3ng Franc Monegasque" },
            { "usn", "\u0110\u00f4 la M\u1ef9 (Ng\u00e0y ti\u1ebfp theo)" },
            { "etb", "Birr Ethiopia" },
            { "veb", "\u0110\u1ed3ng bol\u00edvar c\u1ee7a Venezuela (1871\u20132008)" },
            { "ecs", "\u0110\u1ed3ng Scure Ecuador" },
            { "uss", "\u0110\u00f4 la M\u1ef9 (C\u00f9ng ng\u00e0y)" },
            { "sos", "Schilling Somali" },
            { "vef", "Bol\u00edvar Venezuela (2008\u20132018)" },
            { "vuv", "Vatu Vanuatu" },
            { "lak", "Kip L\u00e0o" },
            { "bnd", "\u0110\u00f4 la Brunei" },
            { "ecv", "\u0110\u01a1n v\u1ecb Gi\u00e1 tr\u1ecb Kh\u00f4ng \u0111\u1ed5i c\u1ee7a Ecuador" },
            { "zmk", "\u0110\u1ed3ng kwacha c\u1ee7a Zambia (1968\u20132012)" },
            { "lrd", "\u0110\u00f4 la Liberia" },
            { "all", "Lek Albania" },
            { "alk", metaValue_ALK },
            { "ghc", "Cedi Ghana (1979\u20132007)" },
            { "mtl", "Lia x\u1ee9 Man-t\u01a1" },
            { "ves", "Bol\u00edvar Venezuela" },
            { "zmw", "Kwacha Zambia" },
            { "mtp", "\u0110\u1ed3ng B\u1ea3ng Malta" },
            { "ilp", "Pao Ixraen" },
            { "mdc", "\u0110\u1ed3ng Cupon Moldova" },
            { "ilr", metaValue_ILR },
            { "trl", "Lia Th\u1ed5 Nh\u0129 K\u1ef3 (1922\u20132005)" },
            { "ils", "Sheqel Israel m\u1edbi" },
            { "ghs", "Cedi Ghana" },
            { "gyd", "\u0110\u00f4 la Guyana" },
            { "kpw", "Won Tri\u1ec1u Ti\u00ean" },
            { "bob", "Boliviano Bolivia" },
            { "mdl", "Leu Moldova" },
            { "amd", "Dram Armenia" },
            { "try", "Lia Th\u1ed5 Nh\u0129 K\u1ef3" },
            { "lbp", "B\u1ea3ng Li-b\u0103ng" },
            { "bol", "\u0110\u1ed3ng Boliviano c\u1ee7a Bolivia (1863\u20131963)" },
            { "jod", "Dinar Jordan" },
            { "hkd", "\u0110\u00f4 la H\u1ed3ng K\u00f4ng" },
            { "bop", "\u0110\u1ed3ng Peso Bolivia" },
            { "eur", "Euro" },
            { "lsl", "Ioti Lesotho" },
            { "MVP", metaValue_MVP },
            { "cad", "\u0110\u00f4 la Canada" },
            { "bov", "\u0110\u1ed3ng Mvdol Bolivia" },
            { "eek", "Crun Ext\u00f4nia" },
            { "mur", "Rupee Mauritius" },
            { "rol", "\u0110\u1ed3ng Leu Rumani (1952\u20132006)" },
            { "gip", "B\u1ea3ng Gibraltar" },
            { "ron", "Leu Romania" },
            { "ngn", "Naira Nigeria" },
            { "crc", "Col\u00f3n Costa Rica" },
            { "pkr", "Rupee Pakistan" },
            { "ang", "Guilder Antille H\u00e0 Lan" },
            { "krh", "\u0110\u1ed3ng Hwan H\u00e0n Qu\u1ed1c (1953\u20131962)" },
            { "srd", "\u0110\u00f4 la Suriname" },
            { "ltl", "Litas L\u00edt-va" },
            { "sar", "Riyal \u1ea2 R\u1eadp X\u00ea-\u00fat" },
            { "ttd", "\u0110\u00f4 la Trinidad v\u00e0 Tobago" },
            { "mvp", metaValue_MVP },
            { "mvr", "Rufiyaa Maldives" },
            { "kro", "\u0110\u1ed3ng Won H\u00e0n Qu\u1ed1c (1945\u20131953)" },
            { "srg", "\u0110\u1ed3ng Guilder Surinam" },
            { "ddm", "\u0110\u1ed3ng Mark \u0110\u00f4ng \u0110\u1ee9c" },
            { "inr", "Rupee \u1ea4n \u0110\u1ed9" },
            { "ltt", "\u0110\u1ed3ng Talonas Litva" },
            { "krw", "Won H\u00e0n Qu\u1ed1c" },
            { "aoa", "Kwanza Angola" },
            { "jpy", "Y\u00ean Nh\u1eadt" },
            { "pln", "Zloty Ba Lan" },
            { "sbd", "\u0110\u00f4 la qu\u1ea7n \u0111\u1ea3o Solomon" },
            { "csd", "\u0110\u1ed3ng Dinar c\u1ee7a Serbia (2002\u20132006)" },
            { "csk", "\u0110\u1ed3ng Koruna Xu c\u1ee7a Czechoslovakia" },
            { "luc", "\u0110\u1ed3ng Franc Luxembourg c\u00f3 th\u1ec3 chuy\u1ec3n \u0111\u1ed5i" },
            { "aok", "\u0110\u1ed3ng Kwanza c\u1ee7a Angola (1977\u20131991)" },
            { "luf", "\u0110\u1ed3ng Franc Luxembourg" },
            { "plz", "\u0110\u1ed3ng Zloty Ba Lan (1950\u20131995)" },
        };
        return data;
    }
}
