// The BSD 1-Clause License (BSD-1-Clause)
//
// Copyright (c) 2015-2020 the fiat-crypto authors (see the AUTHORS file)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     1. Redistributions of source code must retain the above copyright
//        notice, this list of conditions and the following disclaimer.
//
// THIS SOFTWARE IS PROVIDED BY the fiat-crypto authors "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Berkeley Software Design,
// Inc. BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package field_scalarp384r1

// The file provides arithmetic on the field Z/(2^384 - 1388124618062372383947042015309946732620727252194336364173)
// using a 64-bit Montgomery form internal representation.  It is derived
// primarily from the machine generated Golang output from the fiat-crypto
// project.
//
// While the base implementation is provably correct, this implementation
// makes no such claims as the port and optimizations were done by hand.
//
// WARNING: While big-endian is the common representation used for this
// curve, the fiat output uses least-significant-limb first.

import fiat "core:crypto/_fiat"
import "core:math/bits"

// ELL is the saturated representation of the field order, least-significant
// limb first.
ELL :: [6]u64{0xecec196accc52973, 0x581a0db248b0a77a, 0xc7634d81f4372ddf, 0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff}

Montgomery_Domain_Field_Element :: distinct [6]u64
Non_Montgomery_Domain_Field_Element :: distinct [6]u64

fe_mul :: proc "contextless" (out1, arg1, arg2: ^Montgomery_Domain_Field_Element) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	x8, x7 := bits.mul_u64(x6, arg2[5])
	x10, x9 := bits.mul_u64(x6, arg2[4])
	x12, x11 := bits.mul_u64(x6, arg2[3])
	x14, x13 := bits.mul_u64(x6, arg2[2])
	x16, x15 := bits.mul_u64(x6, arg2[1])
	x18, x17 := bits.mul_u64(x6, arg2[0])
	x19, x20 := bits.add_u64(x18, x15, u64(0x0))
	x21, x22 := bits.add_u64(x16, x13, u64(fiat.u1(x20)))
	x23, x24 := bits.add_u64(x14, x11, u64(fiat.u1(x22)))
	x25, x26 := bits.add_u64(x12, x9, u64(fiat.u1(x24)))
	x27, x28 := bits.add_u64(x10, x7, u64(fiat.u1(x26)))
	x29 := (u64(fiat.u1(x28)) + x8)
	_, x30 := bits.mul_u64(x17, 0x6ed46089e88fdc45)
	x33, x32 := bits.mul_u64(x30, 0xffffffffffffffff)
	x35, x34 := bits.mul_u64(x30, 0xffffffffffffffff)
	x37, x36 := bits.mul_u64(x30, 0xffffffffffffffff)
	x39, x38 := bits.mul_u64(x30, 0xc7634d81f4372ddf)
	x41, x40 := bits.mul_u64(x30, 0x581a0db248b0a77a)
	x43, x42 := bits.mul_u64(x30, 0xecec196accc52973)
	x44, x45 := bits.add_u64(x43, x40, u64(0x0))
	x46, x47 := bits.add_u64(x41, x38, u64(fiat.u1(x45)))
	x48, x49 := bits.add_u64(x39, x36, u64(fiat.u1(x47)))
	x50, x51 := bits.add_u64(x37, x34, u64(fiat.u1(x49)))
	x52, x53 := bits.add_u64(x35, x32, u64(fiat.u1(x51)))
	x54 := (u64(fiat.u1(x53)) + x33)
	_, x56 := bits.add_u64(x17, x42, u64(0x0))
	x57, x58 := bits.add_u64(x19, x44, u64(fiat.u1(x56)))
	x59, x60 := bits.add_u64(x21, x46, u64(fiat.u1(x58)))
	x61, x62 := bits.add_u64(x23, x48, u64(fiat.u1(x60)))
	x63, x64 := bits.add_u64(x25, x50, u64(fiat.u1(x62)))
	x65, x66 := bits.add_u64(x27, x52, u64(fiat.u1(x64)))
	x67, x68 := bits.add_u64(x29, x54, u64(fiat.u1(x66)))
	x70, x69 := bits.mul_u64(x1, arg2[5])
	x72, x71 := bits.mul_u64(x1, arg2[4])
	x74, x73 := bits.mul_u64(x1, arg2[3])
	x76, x75 := bits.mul_u64(x1, arg2[2])
	x78, x77 := bits.mul_u64(x1, arg2[1])
	x80, x79 := bits.mul_u64(x1, arg2[0])
	x81, x82 := bits.add_u64(x80, x77, u64(0x0))
	x83, x84 := bits.add_u64(x78, x75, u64(fiat.u1(x82)))
	x85, x86 := bits.add_u64(x76, x73, u64(fiat.u1(x84)))
	x87, x88 := bits.add_u64(x74, x71, u64(fiat.u1(x86)))
	x89, x90 := bits.add_u64(x72, x69, u64(fiat.u1(x88)))
	x91 := (u64(fiat.u1(x90)) + x70)
	x92, x93 := bits.add_u64(x57, x79, u64(0x0))
	x94, x95 := bits.add_u64(x59, x81, u64(fiat.u1(x93)))
	x96, x97 := bits.add_u64(x61, x83, u64(fiat.u1(x95)))
	x98, x99 := bits.add_u64(x63, x85, u64(fiat.u1(x97)))
	x100, x101 := bits.add_u64(x65, x87, u64(fiat.u1(x99)))
	x102, x103 := bits.add_u64(x67, x89, u64(fiat.u1(x101)))
	x104, x105 := bits.add_u64(u64(fiat.u1(x68)), x91, u64(fiat.u1(x103)))
	_, x106 := bits.mul_u64(x92, 0x6ed46089e88fdc45)
	x109, x108 := bits.mul_u64(x106, 0xffffffffffffffff)
	x111, x110 := bits.mul_u64(x106, 0xffffffffffffffff)
	x113, x112 := bits.mul_u64(x106, 0xffffffffffffffff)
	x115, x114 := bits.mul_u64(x106, 0xc7634d81f4372ddf)
	x117, x116 := bits.mul_u64(x106, 0x581a0db248b0a77a)
	x119, x118 := bits.mul_u64(x106, 0xecec196accc52973)
	x120, x121 := bits.add_u64(x119, x116, u64(0x0))
	x122, x123 := bits.add_u64(x117, x114, u64(fiat.u1(x121)))
	x124, x125 := bits.add_u64(x115, x112, u64(fiat.u1(x123)))
	x126, x127 := bits.add_u64(x113, x110, u64(fiat.u1(x125)))
	x128, x129 := bits.add_u64(x111, x108, u64(fiat.u1(x127)))
	x130 := (u64(fiat.u1(x129)) + x109)
	_, x132 := bits.add_u64(x92, x118, u64(0x0))
	x133, x134 := bits.add_u64(x94, x120, u64(fiat.u1(x132)))
	x135, x136 := bits.add_u64(x96, x122, u64(fiat.u1(x134)))
	x137, x138 := bits.add_u64(x98, x124, u64(fiat.u1(x136)))
	x139, x140 := bits.add_u64(x100, x126, u64(fiat.u1(x138)))
	x141, x142 := bits.add_u64(x102, x128, u64(fiat.u1(x140)))
	x143, x144 := bits.add_u64(x104, x130, u64(fiat.u1(x142)))
	x145 := (u64(fiat.u1(x144)) + u64(fiat.u1(x105)))
	x147, x146 := bits.mul_u64(x2, arg2[5])
	x149, x148 := bits.mul_u64(x2, arg2[4])
	x151, x150 := bits.mul_u64(x2, arg2[3])
	x153, x152 := bits.mul_u64(x2, arg2[2])
	x155, x154 := bits.mul_u64(x2, arg2[1])
	x157, x156 := bits.mul_u64(x2, arg2[0])
	x158, x159 := bits.add_u64(x157, x154, u64(0x0))
	x160, x161 := bits.add_u64(x155, x152, u64(fiat.u1(x159)))
	x162, x163 := bits.add_u64(x153, x150, u64(fiat.u1(x161)))
	x164, x165 := bits.add_u64(x151, x148, u64(fiat.u1(x163)))
	x166, x167 := bits.add_u64(x149, x146, u64(fiat.u1(x165)))
	x168 := (u64(fiat.u1(x167)) + x147)
	x169, x170 := bits.add_u64(x133, x156, u64(0x0))
	x171, x172 := bits.add_u64(x135, x158, u64(fiat.u1(x170)))
	x173, x174 := bits.add_u64(x137, x160, u64(fiat.u1(x172)))
	x175, x176 := bits.add_u64(x139, x162, u64(fiat.u1(x174)))
	x177, x178 := bits.add_u64(x141, x164, u64(fiat.u1(x176)))
	x179, x180 := bits.add_u64(x143, x166, u64(fiat.u1(x178)))
	x181, x182 := bits.add_u64(x145, x168, u64(fiat.u1(x180)))
	_, x183 := bits.mul_u64(x169, 0x6ed46089e88fdc45)
	x186, x185 := bits.mul_u64(x183, 0xffffffffffffffff)
	x188, x187 := bits.mul_u64(x183, 0xffffffffffffffff)
	x190, x189 := bits.mul_u64(x183, 0xffffffffffffffff)
	x192, x191 := bits.mul_u64(x183, 0xc7634d81f4372ddf)
	x194, x193 := bits.mul_u64(x183, 0x581a0db248b0a77a)
	x196, x195 := bits.mul_u64(x183, 0xecec196accc52973)
	x197, x198 := bits.add_u64(x196, x193, u64(0x0))
	x199, x200 := bits.add_u64(x194, x191, u64(fiat.u1(x198)))
	x201, x202 := bits.add_u64(x192, x189, u64(fiat.u1(x200)))
	x203, x204 := bits.add_u64(x190, x187, u64(fiat.u1(x202)))
	x205, x206 := bits.add_u64(x188, x185, u64(fiat.u1(x204)))
	x207 := (u64(fiat.u1(x206)) + x186)
	_, x209 := bits.add_u64(x169, x195, u64(0x0))
	x210, x211 := bits.add_u64(x171, x197, u64(fiat.u1(x209)))
	x212, x213 := bits.add_u64(x173, x199, u64(fiat.u1(x211)))
	x214, x215 := bits.add_u64(x175, x201, u64(fiat.u1(x213)))
	x216, x217 := bits.add_u64(x177, x203, u64(fiat.u1(x215)))
	x218, x219 := bits.add_u64(x179, x205, u64(fiat.u1(x217)))
	x220, x221 := bits.add_u64(x181, x207, u64(fiat.u1(x219)))
	x222 := (u64(fiat.u1(x221)) + u64(fiat.u1(x182)))
	x224, x223 := bits.mul_u64(x3, arg2[5])
	x226, x225 := bits.mul_u64(x3, arg2[4])
	x228, x227 := bits.mul_u64(x3, arg2[3])
	x230, x229 := bits.mul_u64(x3, arg2[2])
	x232, x231 := bits.mul_u64(x3, arg2[1])
	x234, x233 := bits.mul_u64(x3, arg2[0])
	x235, x236 := bits.add_u64(x234, x231, u64(0x0))
	x237, x238 := bits.add_u64(x232, x229, u64(fiat.u1(x236)))
	x239, x240 := bits.add_u64(x230, x227, u64(fiat.u1(x238)))
	x241, x242 := bits.add_u64(x228, x225, u64(fiat.u1(x240)))
	x243, x244 := bits.add_u64(x226, x223, u64(fiat.u1(x242)))
	x245 := (u64(fiat.u1(x244)) + x224)
	x246, x247 := bits.add_u64(x210, x233, u64(0x0))
	x248, x249 := bits.add_u64(x212, x235, u64(fiat.u1(x247)))
	x250, x251 := bits.add_u64(x214, x237, u64(fiat.u1(x249)))
	x252, x253 := bits.add_u64(x216, x239, u64(fiat.u1(x251)))
	x254, x255 := bits.add_u64(x218, x241, u64(fiat.u1(x253)))
	x256, x257 := bits.add_u64(x220, x243, u64(fiat.u1(x255)))
	x258, x259 := bits.add_u64(x222, x245, u64(fiat.u1(x257)))
	_, x260 := bits.mul_u64(x246, 0x6ed46089e88fdc45)
	x263, x262 := bits.mul_u64(x260, 0xffffffffffffffff)
	x265, x264 := bits.mul_u64(x260, 0xffffffffffffffff)
	x267, x266 := bits.mul_u64(x260, 0xffffffffffffffff)
	x269, x268 := bits.mul_u64(x260, 0xc7634d81f4372ddf)
	x271, x270 := bits.mul_u64(x260, 0x581a0db248b0a77a)
	x273, x272 := bits.mul_u64(x260, 0xecec196accc52973)
	x274, x275 := bits.add_u64(x273, x270, u64(0x0))
	x276, x277 := bits.add_u64(x271, x268, u64(fiat.u1(x275)))
	x278, x279 := bits.add_u64(x269, x266, u64(fiat.u1(x277)))
	x280, x281 := bits.add_u64(x267, x264, u64(fiat.u1(x279)))
	x282, x283 := bits.add_u64(x265, x262, u64(fiat.u1(x281)))
	x284 := (u64(fiat.u1(x283)) + x263)
	_, x286 := bits.add_u64(x246, x272, u64(0x0))
	x287, x288 := bits.add_u64(x248, x274, u64(fiat.u1(x286)))
	x289, x290 := bits.add_u64(x250, x276, u64(fiat.u1(x288)))
	x291, x292 := bits.add_u64(x252, x278, u64(fiat.u1(x290)))
	x293, x294 := bits.add_u64(x254, x280, u64(fiat.u1(x292)))
	x295, x296 := bits.add_u64(x256, x282, u64(fiat.u1(x294)))
	x297, x298 := bits.add_u64(x258, x284, u64(fiat.u1(x296)))
	x299 := (u64(fiat.u1(x298)) + u64(fiat.u1(x259)))
	x301, x300 := bits.mul_u64(x4, arg2[5])
	x303, x302 := bits.mul_u64(x4, arg2[4])
	x305, x304 := bits.mul_u64(x4, arg2[3])
	x307, x306 := bits.mul_u64(x4, arg2[2])
	x309, x308 := bits.mul_u64(x4, arg2[1])
	x311, x310 := bits.mul_u64(x4, arg2[0])
	x312, x313 := bits.add_u64(x311, x308, u64(0x0))
	x314, x315 := bits.add_u64(x309, x306, u64(fiat.u1(x313)))
	x316, x317 := bits.add_u64(x307, x304, u64(fiat.u1(x315)))
	x318, x319 := bits.add_u64(x305, x302, u64(fiat.u1(x317)))
	x320, x321 := bits.add_u64(x303, x300, u64(fiat.u1(x319)))
	x322 := (u64(fiat.u1(x321)) + x301)
	x323, x324 := bits.add_u64(x287, x310, u64(0x0))
	x325, x326 := bits.add_u64(x289, x312, u64(fiat.u1(x324)))
	x327, x328 := bits.add_u64(x291, x314, u64(fiat.u1(x326)))
	x329, x330 := bits.add_u64(x293, x316, u64(fiat.u1(x328)))
	x331, x332 := bits.add_u64(x295, x318, u64(fiat.u1(x330)))
	x333, x334 := bits.add_u64(x297, x320, u64(fiat.u1(x332)))
	x335, x336 := bits.add_u64(x299, x322, u64(fiat.u1(x334)))
	_, x337 := bits.mul_u64(x323, 0x6ed46089e88fdc45)
	x340, x339 := bits.mul_u64(x337, 0xffffffffffffffff)
	x342, x341 := bits.mul_u64(x337, 0xffffffffffffffff)
	x344, x343 := bits.mul_u64(x337, 0xffffffffffffffff)
	x346, x345 := bits.mul_u64(x337, 0xc7634d81f4372ddf)
	x348, x347 := bits.mul_u64(x337, 0x581a0db248b0a77a)
	x350, x349 := bits.mul_u64(x337, 0xecec196accc52973)
	x351, x352 := bits.add_u64(x350, x347, u64(0x0))
	x353, x354 := bits.add_u64(x348, x345, u64(fiat.u1(x352)))
	x355, x356 := bits.add_u64(x346, x343, u64(fiat.u1(x354)))
	x357, x358 := bits.add_u64(x344, x341, u64(fiat.u1(x356)))
	x359, x360 := bits.add_u64(x342, x339, u64(fiat.u1(x358)))
	x361 := (u64(fiat.u1(x360)) + x340)
	_, x363 := bits.add_u64(x323, x349, u64(0x0))
	x364, x365 := bits.add_u64(x325, x351, u64(fiat.u1(x363)))
	x366, x367 := bits.add_u64(x327, x353, u64(fiat.u1(x365)))
	x368, x369 := bits.add_u64(x329, x355, u64(fiat.u1(x367)))
	x370, x371 := bits.add_u64(x331, x357, u64(fiat.u1(x369)))
	x372, x373 := bits.add_u64(x333, x359, u64(fiat.u1(x371)))
	x374, x375 := bits.add_u64(x335, x361, u64(fiat.u1(x373)))
	x376 := (u64(fiat.u1(x375)) + u64(fiat.u1(x336)))
	x378, x377 := bits.mul_u64(x5, arg2[5])
	x380, x379 := bits.mul_u64(x5, arg2[4])
	x382, x381 := bits.mul_u64(x5, arg2[3])
	x384, x383 := bits.mul_u64(x5, arg2[2])
	x386, x385 := bits.mul_u64(x5, arg2[1])
	x388, x387 := bits.mul_u64(x5, arg2[0])
	x389, x390 := bits.add_u64(x388, x385, u64(0x0))
	x391, x392 := bits.add_u64(x386, x383, u64(fiat.u1(x390)))
	x393, x394 := bits.add_u64(x384, x381, u64(fiat.u1(x392)))
	x395, x396 := bits.add_u64(x382, x379, u64(fiat.u1(x394)))
	x397, x398 := bits.add_u64(x380, x377, u64(fiat.u1(x396)))
	x399 := (u64(fiat.u1(x398)) + x378)
	x400, x401 := bits.add_u64(x364, x387, u64(0x0))
	x402, x403 := bits.add_u64(x366, x389, u64(fiat.u1(x401)))
	x404, x405 := bits.add_u64(x368, x391, u64(fiat.u1(x403)))
	x406, x407 := bits.add_u64(x370, x393, u64(fiat.u1(x405)))
	x408, x409 := bits.add_u64(x372, x395, u64(fiat.u1(x407)))
	x410, x411 := bits.add_u64(x374, x397, u64(fiat.u1(x409)))
	x412, x413 := bits.add_u64(x376, x399, u64(fiat.u1(x411)))
	_, x414 := bits.mul_u64(x400, 0x6ed46089e88fdc45)
	x417, x416 := bits.mul_u64(x414, 0xffffffffffffffff)
	x419, x418 := bits.mul_u64(x414, 0xffffffffffffffff)
	x421, x420 := bits.mul_u64(x414, 0xffffffffffffffff)
	x423, x422 := bits.mul_u64(x414, 0xc7634d81f4372ddf)
	x425, x424 := bits.mul_u64(x414, 0x581a0db248b0a77a)
	x427, x426 := bits.mul_u64(x414, 0xecec196accc52973)
	x428, x429 := bits.add_u64(x427, x424, u64(0x0))
	x430, x431 := bits.add_u64(x425, x422, u64(fiat.u1(x429)))
	x432, x433 := bits.add_u64(x423, x420, u64(fiat.u1(x431)))
	x434, x435 := bits.add_u64(x421, x418, u64(fiat.u1(x433)))
	x436, x437 := bits.add_u64(x419, x416, u64(fiat.u1(x435)))
	x438 := (u64(fiat.u1(x437)) + x417)
	_, x440 := bits.add_u64(x400, x426, u64(0x0))
	x441, x442 := bits.add_u64(x402, x428, u64(fiat.u1(x440)))
	x443, x444 := bits.add_u64(x404, x430, u64(fiat.u1(x442)))
	x445, x446 := bits.add_u64(x406, x432, u64(fiat.u1(x444)))
	x447, x448 := bits.add_u64(x408, x434, u64(fiat.u1(x446)))
	x449, x450 := bits.add_u64(x410, x436, u64(fiat.u1(x448)))
	x451, x452 := bits.add_u64(x412, x438, u64(fiat.u1(x450)))
	x453 := (u64(fiat.u1(x452)) + u64(fiat.u1(x413)))
	x454, x455 := bits.sub_u64(x441, 0xecec196accc52973, u64(0x0))
	x456, x457 := bits.sub_u64(x443, 0x581a0db248b0a77a, u64(fiat.u1(x455)))
	x458, x459 := bits.sub_u64(x445, 0xc7634d81f4372ddf, u64(fiat.u1(x457)))
	x460, x461 := bits.sub_u64(x447, 0xffffffffffffffff, u64(fiat.u1(x459)))
	x462, x463 := bits.sub_u64(x449, 0xffffffffffffffff, u64(fiat.u1(x461)))
	x464, x465 := bits.sub_u64(x451, 0xffffffffffffffff, u64(fiat.u1(x463)))
	_, x467 := bits.sub_u64(x453, u64(0x0), u64(fiat.u1(x465)))
	x468 := fiat.cmovznz_u64(fiat.u1(x467), x454, x441)
	x469 := fiat.cmovznz_u64(fiat.u1(x467), x456, x443)
	x470 := fiat.cmovznz_u64(fiat.u1(x467), x458, x445)
	x471 := fiat.cmovznz_u64(fiat.u1(x467), x460, x447)
	x472 := fiat.cmovznz_u64(fiat.u1(x467), x462, x449)
	x473 := fiat.cmovznz_u64(fiat.u1(x467), x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}

fe_square :: proc "contextless" (out1, arg1: ^Montgomery_Domain_Field_Element) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	x8, x7 := bits.mul_u64(x6, arg1[5])
	x10, x9 := bits.mul_u64(x6, arg1[4])
	x12, x11 := bits.mul_u64(x6, arg1[3])
	x14, x13 := bits.mul_u64(x6, arg1[2])
	x16, x15 := bits.mul_u64(x6, arg1[1])
	x18, x17 := bits.mul_u64(x6, arg1[0])
	x19, x20 := bits.add_u64(x18, x15, u64(0x0))
	x21, x22 := bits.add_u64(x16, x13, u64(fiat.u1(x20)))
	x23, x24 := bits.add_u64(x14, x11, u64(fiat.u1(x22)))
	x25, x26 := bits.add_u64(x12, x9, u64(fiat.u1(x24)))
	x27, x28 := bits.add_u64(x10, x7, u64(fiat.u1(x26)))
	x29 := (u64(fiat.u1(x28)) + x8)
	_, x30 := bits.mul_u64(x17, 0x6ed46089e88fdc45)
	x33, x32 := bits.mul_u64(x30, 0xffffffffffffffff)
	x35, x34 := bits.mul_u64(x30, 0xffffffffffffffff)
	x37, x36 := bits.mul_u64(x30, 0xffffffffffffffff)
	x39, x38 := bits.mul_u64(x30, 0xc7634d81f4372ddf)
	x41, x40 := bits.mul_u64(x30, 0x581a0db248b0a77a)
	x43, x42 := bits.mul_u64(x30, 0xecec196accc52973)
	x44, x45 := bits.add_u64(x43, x40, u64(0x0))
	x46, x47 := bits.add_u64(x41, x38, u64(fiat.u1(x45)))
	x48, x49 := bits.add_u64(x39, x36, u64(fiat.u1(x47)))
	x50, x51 := bits.add_u64(x37, x34, u64(fiat.u1(x49)))
	x52, x53 := bits.add_u64(x35, x32, u64(fiat.u1(x51)))
	x54 := (u64(fiat.u1(x53)) + x33)
	_, x56 := bits.add_u64(x17, x42, u64(0x0))
	x57, x58 := bits.add_u64(x19, x44, u64(fiat.u1(x56)))
	x59, x60 := bits.add_u64(x21, x46, u64(fiat.u1(x58)))
	x61, x62 := bits.add_u64(x23, x48, u64(fiat.u1(x60)))
	x63, x64 := bits.add_u64(x25, x50, u64(fiat.u1(x62)))
	x65, x66 := bits.add_u64(x27, x52, u64(fiat.u1(x64)))
	x67, x68 := bits.add_u64(x29, x54, u64(fiat.u1(x66)))
	x70, x69 := bits.mul_u64(x1, arg1[5])
	x72, x71 := bits.mul_u64(x1, arg1[4])
	x74, x73 := bits.mul_u64(x1, arg1[3])
	x76, x75 := bits.mul_u64(x1, arg1[2])
	x78, x77 := bits.mul_u64(x1, arg1[1])
	x80, x79 := bits.mul_u64(x1, arg1[0])
	x81, x82 := bits.add_u64(x80, x77, u64(0x0))
	x83, x84 := bits.add_u64(x78, x75, u64(fiat.u1(x82)))
	x85, x86 := bits.add_u64(x76, x73, u64(fiat.u1(x84)))
	x87, x88 := bits.add_u64(x74, x71, u64(fiat.u1(x86)))
	x89, x90 := bits.add_u64(x72, x69, u64(fiat.u1(x88)))
	x91 := (u64(fiat.u1(x90)) + x70)
	x92, x93 := bits.add_u64(x57, x79, u64(0x0))
	x94, x95 := bits.add_u64(x59, x81, u64(fiat.u1(x93)))
	x96, x97 := bits.add_u64(x61, x83, u64(fiat.u1(x95)))
	x98, x99 := bits.add_u64(x63, x85, u64(fiat.u1(x97)))
	x100, x101 := bits.add_u64(x65, x87, u64(fiat.u1(x99)))
	x102, x103 := bits.add_u64(x67, x89, u64(fiat.u1(x101)))
	x104, x105 := bits.add_u64(u64(fiat.u1(x68)), x91, u64(fiat.u1(x103)))
	_, x106 := bits.mul_u64(x92, 0x6ed46089e88fdc45)
	x109, x108 := bits.mul_u64(x106, 0xffffffffffffffff)
	x111, x110 := bits.mul_u64(x106, 0xffffffffffffffff)
	x113, x112 := bits.mul_u64(x106, 0xffffffffffffffff)
	x115, x114 := bits.mul_u64(x106, 0xc7634d81f4372ddf)
	x117, x116 := bits.mul_u64(x106, 0x581a0db248b0a77a)
	x119, x118 := bits.mul_u64(x106, 0xecec196accc52973)
	x120, x121 := bits.add_u64(x119, x116, u64(0x0))
	x122, x123 := bits.add_u64(x117, x114, u64(fiat.u1(x121)))
	x124, x125 := bits.add_u64(x115, x112, u64(fiat.u1(x123)))
	x126, x127 := bits.add_u64(x113, x110, u64(fiat.u1(x125)))
	x128, x129 := bits.add_u64(x111, x108, u64(fiat.u1(x127)))
	x130 := (u64(fiat.u1(x129)) + x109)
	_, x132 := bits.add_u64(x92, x118, u64(0x0))
	x133, x134 := bits.add_u64(x94, x120, u64(fiat.u1(x132)))
	x135, x136 := bits.add_u64(x96, x122, u64(fiat.u1(x134)))
	x137, x138 := bits.add_u64(x98, x124, u64(fiat.u1(x136)))
	x139, x140 := bits.add_u64(x100, x126, u64(fiat.u1(x138)))
	x141, x142 := bits.add_u64(x102, x128, u64(fiat.u1(x140)))
	x143, x144 := bits.add_u64(x104, x130, u64(fiat.u1(x142)))
	x145 := (u64(fiat.u1(x144)) + u64(fiat.u1(x105)))
	x147, x146 := bits.mul_u64(x2, arg1[5])
	x149, x148 := bits.mul_u64(x2, arg1[4])
	x151, x150 := bits.mul_u64(x2, arg1[3])
	x153, x152 := bits.mul_u64(x2, arg1[2])
	x155, x154 := bits.mul_u64(x2, arg1[1])
	x157, x156 := bits.mul_u64(x2, arg1[0])
	x158, x159 := bits.add_u64(x157, x154, u64(0x0))
	x160, x161 := bits.add_u64(x155, x152, u64(fiat.u1(x159)))
	x162, x163 := bits.add_u64(x153, x150, u64(fiat.u1(x161)))
	x164, x165 := bits.add_u64(x151, x148, u64(fiat.u1(x163)))
	x166, x167 := bits.add_u64(x149, x146, u64(fiat.u1(x165)))
	x168 := (u64(fiat.u1(x167)) + x147)
	x169, x170 := bits.add_u64(x133, x156, u64(0x0))
	x171, x172 := bits.add_u64(x135, x158, u64(fiat.u1(x170)))
	x173, x174 := bits.add_u64(x137, x160, u64(fiat.u1(x172)))
	x175, x176 := bits.add_u64(x139, x162, u64(fiat.u1(x174)))
	x177, x178 := bits.add_u64(x141, x164, u64(fiat.u1(x176)))
	x179, x180 := bits.add_u64(x143, x166, u64(fiat.u1(x178)))
	x181, x182 := bits.add_u64(x145, x168, u64(fiat.u1(x180)))
	_, x183 := bits.mul_u64(x169, 0x6ed46089e88fdc45)
	x186, x185 := bits.mul_u64(x183, 0xffffffffffffffff)
	x188, x187 := bits.mul_u64(x183, 0xffffffffffffffff)
	x190, x189 := bits.mul_u64(x183, 0xffffffffffffffff)
	x192, x191 := bits.mul_u64(x183, 0xc7634d81f4372ddf)
	x194, x193 := bits.mul_u64(x183, 0x581a0db248b0a77a)
	x196, x195 := bits.mul_u64(x183, 0xecec196accc52973)
	x197, x198 := bits.add_u64(x196, x193, u64(0x0))
	x199, x200 := bits.add_u64(x194, x191, u64(fiat.u1(x198)))
	x201, x202 := bits.add_u64(x192, x189, u64(fiat.u1(x200)))
	x203, x204 := bits.add_u64(x190, x187, u64(fiat.u1(x202)))
	x205, x206 := bits.add_u64(x188, x185, u64(fiat.u1(x204)))
	x207 := (u64(fiat.u1(x206)) + x186)
	_, x209 := bits.add_u64(x169, x195, u64(0x0))
	x210, x211 := bits.add_u64(x171, x197, u64(fiat.u1(x209)))
	x212, x213 := bits.add_u64(x173, x199, u64(fiat.u1(x211)))
	x214, x215 := bits.add_u64(x175, x201, u64(fiat.u1(x213)))
	x216, x217 := bits.add_u64(x177, x203, u64(fiat.u1(x215)))
	x218, x219 := bits.add_u64(x179, x205, u64(fiat.u1(x217)))
	x220, x221 := bits.add_u64(x181, x207, u64(fiat.u1(x219)))
	x222 := (u64(fiat.u1(x221)) + u64(fiat.u1(x182)))
	x224, x223 := bits.mul_u64(x3, arg1[5])
	x226, x225 := bits.mul_u64(x3, arg1[4])
	x228, x227 := bits.mul_u64(x3, arg1[3])
	x230, x229 := bits.mul_u64(x3, arg1[2])
	x232, x231 := bits.mul_u64(x3, arg1[1])
	x234, x233 := bits.mul_u64(x3, arg1[0])
	x235, x236 := bits.add_u64(x234, x231, u64(0x0))
	x237, x238 := bits.add_u64(x232, x229, u64(fiat.u1(x236)))
	x239, x240 := bits.add_u64(x230, x227, u64(fiat.u1(x238)))
	x241, x242 := bits.add_u64(x228, x225, u64(fiat.u1(x240)))
	x243, x244 := bits.add_u64(x226, x223, u64(fiat.u1(x242)))
	x245 := (u64(fiat.u1(x244)) + x224)
	x246, x247 := bits.add_u64(x210, x233, u64(0x0))
	x248, x249 := bits.add_u64(x212, x235, u64(fiat.u1(x247)))
	x250, x251 := bits.add_u64(x214, x237, u64(fiat.u1(x249)))
	x252, x253 := bits.add_u64(x216, x239, u64(fiat.u1(x251)))
	x254, x255 := bits.add_u64(x218, x241, u64(fiat.u1(x253)))
	x256, x257 := bits.add_u64(x220, x243, u64(fiat.u1(x255)))
	x258, x259 := bits.add_u64(x222, x245, u64(fiat.u1(x257)))
	_, x260 := bits.mul_u64(x246, 0x6ed46089e88fdc45)
	x263, x262 := bits.mul_u64(x260, 0xffffffffffffffff)
	x265, x264 := bits.mul_u64(x260, 0xffffffffffffffff)
	x267, x266 := bits.mul_u64(x260, 0xffffffffffffffff)
	x269, x268 := bits.mul_u64(x260, 0xc7634d81f4372ddf)
	x271, x270 := bits.mul_u64(x260, 0x581a0db248b0a77a)
	x273, x272 := bits.mul_u64(x260, 0xecec196accc52973)
	x274, x275 := bits.add_u64(x273, x270, u64(0x0))
	x276, x277 := bits.add_u64(x271, x268, u64(fiat.u1(x275)))
	x278, x279 := bits.add_u64(x269, x266, u64(fiat.u1(x277)))
	x280, x281 := bits.add_u64(x267, x264, u64(fiat.u1(x279)))
	x282, x283 := bits.add_u64(x265, x262, u64(fiat.u1(x281)))
	x284 := (u64(fiat.u1(x283)) + x263)
	_, x286 := bits.add_u64(x246, x272, u64(0x0))
	x287, x288 := bits.add_u64(x248, x274, u64(fiat.u1(x286)))
	x289, x290 := bits.add_u64(x250, x276, u64(fiat.u1(x288)))
	x291, x292 := bits.add_u64(x252, x278, u64(fiat.u1(x290)))
	x293, x294 := bits.add_u64(x254, x280, u64(fiat.u1(x292)))
	x295, x296 := bits.add_u64(x256, x282, u64(fiat.u1(x294)))
	x297, x298 := bits.add_u64(x258, x284, u64(fiat.u1(x296)))
	x299 := (u64(fiat.u1(x298)) + u64(fiat.u1(x259)))
	x301, x300 := bits.mul_u64(x4, arg1[5])
	x303, x302 := bits.mul_u64(x4, arg1[4])
	x305, x304 := bits.mul_u64(x4, arg1[3])
	x307, x306 := bits.mul_u64(x4, arg1[2])
	x309, x308 := bits.mul_u64(x4, arg1[1])
	x311, x310 := bits.mul_u64(x4, arg1[0])
	x312, x313 := bits.add_u64(x311, x308, u64(0x0))
	x314, x315 := bits.add_u64(x309, x306, u64(fiat.u1(x313)))
	x316, x317 := bits.add_u64(x307, x304, u64(fiat.u1(x315)))
	x318, x319 := bits.add_u64(x305, x302, u64(fiat.u1(x317)))
	x320, x321 := bits.add_u64(x303, x300, u64(fiat.u1(x319)))
	x322 := (u64(fiat.u1(x321)) + x301)
	x323, x324 := bits.add_u64(x287, x310, u64(0x0))
	x325, x326 := bits.add_u64(x289, x312, u64(fiat.u1(x324)))
	x327, x328 := bits.add_u64(x291, x314, u64(fiat.u1(x326)))
	x329, x330 := bits.add_u64(x293, x316, u64(fiat.u1(x328)))
	x331, x332 := bits.add_u64(x295, x318, u64(fiat.u1(x330)))
	x333, x334 := bits.add_u64(x297, x320, u64(fiat.u1(x332)))
	x335, x336 := bits.add_u64(x299, x322, u64(fiat.u1(x334)))
	_, x337 := bits.mul_u64(x323, 0x6ed46089e88fdc45)
	x340, x339 := bits.mul_u64(x337, 0xffffffffffffffff)
	x342, x341 := bits.mul_u64(x337, 0xffffffffffffffff)
	x344, x343 := bits.mul_u64(x337, 0xffffffffffffffff)
	x346, x345 := bits.mul_u64(x337, 0xc7634d81f4372ddf)
	x348, x347 := bits.mul_u64(x337, 0x581a0db248b0a77a)
	x350, x349 := bits.mul_u64(x337, 0xecec196accc52973)
	x351, x352 := bits.add_u64(x350, x347, u64(0x0))
	x353, x354 := bits.add_u64(x348, x345, u64(fiat.u1(x352)))
	x355, x356 := bits.add_u64(x346, x343, u64(fiat.u1(x354)))
	x357, x358 := bits.add_u64(x344, x341, u64(fiat.u1(x356)))
	x359, x360 := bits.add_u64(x342, x339, u64(fiat.u1(x358)))
	x361 := (u64(fiat.u1(x360)) + x340)
	_, x363 := bits.add_u64(x323, x349, u64(0x0))
	x364, x365 := bits.add_u64(x325, x351, u64(fiat.u1(x363)))
	x366, x367 := bits.add_u64(x327, x353, u64(fiat.u1(x365)))
	x368, x369 := bits.add_u64(x329, x355, u64(fiat.u1(x367)))
	x370, x371 := bits.add_u64(x331, x357, u64(fiat.u1(x369)))
	x372, x373 := bits.add_u64(x333, x359, u64(fiat.u1(x371)))
	x374, x375 := bits.add_u64(x335, x361, u64(fiat.u1(x373)))
	x376 := (u64(fiat.u1(x375)) + u64(fiat.u1(x336)))
	x378, x377 := bits.mul_u64(x5, arg1[5])
	x380, x379 := bits.mul_u64(x5, arg1[4])
	x382, x381 := bits.mul_u64(x5, arg1[3])
	x384, x383 := bits.mul_u64(x5, arg1[2])
	x386, x385 := bits.mul_u64(x5, arg1[1])
	x388, x387 := bits.mul_u64(x5, arg1[0])
	x389, x390 := bits.add_u64(x388, x385, u64(0x0))
	x391, x392 := bits.add_u64(x386, x383, u64(fiat.u1(x390)))
	x393, x394 := bits.add_u64(x384, x381, u64(fiat.u1(x392)))
	x395, x396 := bits.add_u64(x382, x379, u64(fiat.u1(x394)))
	x397, x398 := bits.add_u64(x380, x377, u64(fiat.u1(x396)))
	x399 := (u64(fiat.u1(x398)) + x378)
	x400, x401 := bits.add_u64(x364, x387, u64(0x0))
	x402, x403 := bits.add_u64(x366, x389, u64(fiat.u1(x401)))
	x404, x405 := bits.add_u64(x368, x391, u64(fiat.u1(x403)))
	x406, x407 := bits.add_u64(x370, x393, u64(fiat.u1(x405)))
	x408, x409 := bits.add_u64(x372, x395, u64(fiat.u1(x407)))
	x410, x411 := bits.add_u64(x374, x397, u64(fiat.u1(x409)))
	x412, x413 := bits.add_u64(x376, x399, u64(fiat.u1(x411)))
	_, x414 := bits.mul_u64(x400, 0x6ed46089e88fdc45)
	x417, x416 := bits.mul_u64(x414, 0xffffffffffffffff)
	x419, x418 := bits.mul_u64(x414, 0xffffffffffffffff)
	x421, x420 := bits.mul_u64(x414, 0xffffffffffffffff)
	x423, x422 := bits.mul_u64(x414, 0xc7634d81f4372ddf)
	x425, x424 := bits.mul_u64(x414, 0x581a0db248b0a77a)
	x427, x426 := bits.mul_u64(x414, 0xecec196accc52973)
	x428, x429 := bits.add_u64(x427, x424, u64(0x0))
	x430, x431 := bits.add_u64(x425, x422, u64(fiat.u1(x429)))
	x432, x433 := bits.add_u64(x423, x420, u64(fiat.u1(x431)))
	x434, x435 := bits.add_u64(x421, x418, u64(fiat.u1(x433)))
	x436, x437 := bits.add_u64(x419, x416, u64(fiat.u1(x435)))
	x438 := (u64(fiat.u1(x437)) + x417)
	_, x440 := bits.add_u64(x400, x426, u64(0x0))
	x441, x442 := bits.add_u64(x402, x428, u64(fiat.u1(x440)))
	x443, x444 := bits.add_u64(x404, x430, u64(fiat.u1(x442)))
	x445, x446 := bits.add_u64(x406, x432, u64(fiat.u1(x444)))
	x447, x448 := bits.add_u64(x408, x434, u64(fiat.u1(x446)))
	x449, x450 := bits.add_u64(x410, x436, u64(fiat.u1(x448)))
	x451, x452 := bits.add_u64(x412, x438, u64(fiat.u1(x450)))
	x453 := (u64(fiat.u1(x452)) + u64(fiat.u1(x413)))
	x454, x455 := bits.sub_u64(x441, 0xecec196accc52973, u64(0x0))
	x456, x457 := bits.sub_u64(x443, 0x581a0db248b0a77a, u64(fiat.u1(x455)))
	x458, x459 := bits.sub_u64(x445, 0xc7634d81f4372ddf, u64(fiat.u1(x457)))
	x460, x461 := bits.sub_u64(x447, 0xffffffffffffffff, u64(fiat.u1(x459)))
	x462, x463 := bits.sub_u64(x449, 0xffffffffffffffff, u64(fiat.u1(x461)))
	x464, x465 := bits.sub_u64(x451, 0xffffffffffffffff, u64(fiat.u1(x463)))
	_, x467 := bits.sub_u64(x453, u64(0x0), u64(fiat.u1(x465)))
	x468 := fiat.cmovznz_u64(fiat.u1(x467), x454, x441)
	x469 := fiat.cmovznz_u64(fiat.u1(x467), x456, x443)
	x470 := fiat.cmovznz_u64(fiat.u1(x467), x458, x445)
	x471 := fiat.cmovznz_u64(fiat.u1(x467), x460, x447)
	x472 := fiat.cmovznz_u64(fiat.u1(x467), x462, x449)
	x473 := fiat.cmovznz_u64(fiat.u1(x467), x464, x451)
	out1[0] = x468
	out1[1] = x469
	out1[2] = x470
	out1[3] = x471
	out1[4] = x472
	out1[5] = x473
}

fe_add :: proc "contextless" (out1, arg1, arg2: ^Montgomery_Domain_Field_Element) {
	x1, x2 := bits.add_u64(arg1[0], arg2[0], u64(0x0))
	x3, x4 := bits.add_u64(arg1[1], arg2[1], u64(fiat.u1(x2)))
	x5, x6 := bits.add_u64(arg1[2], arg2[2], u64(fiat.u1(x4)))
	x7, x8 := bits.add_u64(arg1[3], arg2[3], u64(fiat.u1(x6)))
	x9, x10 := bits.add_u64(arg1[4], arg2[4], u64(fiat.u1(x8)))
	x11, x12 := bits.add_u64(arg1[5], arg2[5], u64(fiat.u1(x10)))
	x13, x14 := bits.sub_u64(x1, 0xecec196accc52973, u64(0x0))
	x15, x16 := bits.sub_u64(x3, 0x581a0db248b0a77a, u64(fiat.u1(x14)))
	x17, x18 := bits.sub_u64(x5, 0xc7634d81f4372ddf, u64(fiat.u1(x16)))
	x19, x20 := bits.sub_u64(x7, 0xffffffffffffffff, u64(fiat.u1(x18)))
	x21, x22 := bits.sub_u64(x9, 0xffffffffffffffff, u64(fiat.u1(x20)))
	x23, x24 := bits.sub_u64(x11, 0xffffffffffffffff, u64(fiat.u1(x22)))
	_, x26 := bits.sub_u64(u64(fiat.u1(x12)), u64(0x0), u64(fiat.u1(x24)))
	x27 := fiat.cmovznz_u64(fiat.u1(x26), x13, x1)
	x28 := fiat.cmovznz_u64(fiat.u1(x26), x15, x3)
	x29 := fiat.cmovznz_u64(fiat.u1(x26), x17, x5)
	x30 := fiat.cmovznz_u64(fiat.u1(x26), x19, x7)
	x31 := fiat.cmovznz_u64(fiat.u1(x26), x21, x9)
	x32 := fiat.cmovznz_u64(fiat.u1(x26), x23, x11)
	out1[0] = x27
	out1[1] = x28
	out1[2] = x29
	out1[3] = x30
	out1[4] = x31
	out1[5] = x32
}

fe_sub :: proc "contextless" (out1, arg1, arg2: ^Montgomery_Domain_Field_Element) {
	x1, x2 := bits.sub_u64(arg1[0], arg2[0], u64(0x0))
	x3, x4 := bits.sub_u64(arg1[1], arg2[1], u64(fiat.u1(x2)))
	x5, x6 := bits.sub_u64(arg1[2], arg2[2], u64(fiat.u1(x4)))
	x7, x8 := bits.sub_u64(arg1[3], arg2[3], u64(fiat.u1(x6)))
	x9, x10 := bits.sub_u64(arg1[4], arg2[4], u64(fiat.u1(x8)))
	x11, x12 := bits.sub_u64(arg1[5], arg2[5], u64(fiat.u1(x10)))
	x13 := fiat.cmovznz_u64(fiat.u1(x12), u64(0x0), 0xffffffffffffffff)
	x14, x15 := bits.add_u64(x1, (x13 & 0xecec196accc52973), u64(0x0))
	x16, x17 := bits.add_u64(x3, (x13 & 0x581a0db248b0a77a), u64(fiat.u1(x15)))
	x18, x19 := bits.add_u64(x5, (x13 & 0xc7634d81f4372ddf), u64(fiat.u1(x17)))
	x20, x21 := bits.add_u64(x7, x13, u64(fiat.u1(x19)))
	x22, x23 := bits.add_u64(x9, x13, u64(fiat.u1(x21)))
	x24, _ := bits.add_u64(x11, x13, u64(fiat.u1(x23)))
	out1[0] = x14
	out1[1] = x16
	out1[2] = x18
	out1[3] = x20
	out1[4] = x22
	out1[5] = x24
}

fe_opp :: proc "contextless" (out1, arg1: ^Montgomery_Domain_Field_Element) {
	x1, x2 := bits.sub_u64(u64(0x0), arg1[0], u64(0x0))
	x3, x4 := bits.sub_u64(u64(0x0), arg1[1], u64(fiat.u1(x2)))
	x5, x6 := bits.sub_u64(u64(0x0), arg1[2], u64(fiat.u1(x4)))
	x7, x8 := bits.sub_u64(u64(0x0), arg1[3], u64(fiat.u1(x6)))
	x9, x10 := bits.sub_u64(u64(0x0), arg1[4], u64(fiat.u1(x8)))
	x11, x12 := bits.sub_u64(u64(0x0), arg1[5], u64(fiat.u1(x10)))
	x13 := fiat.cmovznz_u64(fiat.u1(x12), u64(0x0), 0xffffffffffffffff)
	x14, x15 := bits.add_u64(x1, (x13 & 0xecec196accc52973), u64(0x0))
	x16, x17 := bits.add_u64(x3, (x13 & 0x581a0db248b0a77a), u64(fiat.u1(x15)))
	x18, x19 := bits.add_u64(x5, (x13 & 0xc7634d81f4372ddf), u64(fiat.u1(x17)))
	x20, x21 := bits.add_u64(x7, x13, u64(fiat.u1(x19)))
	x22, x23 := bits.add_u64(x9, x13, u64(fiat.u1(x21)))
	x24, _ := bits.add_u64(x11, x13, u64(fiat.u1(x23)))
	out1[0] = x14
	out1[1] = x16
	out1[2] = x18
	out1[3] = x20
	out1[4] = x22
	out1[5] = x24
}

fe_one :: proc "contextless" (out1: ^Montgomery_Domain_Field_Element) {
	out1[0] = 0x1313e695333ad68d
	out1[1] = 0xa7e5f24db74f5885
	out1[2] = 0x389cb27e0bc8d220
	out1[3] = 0x0
	out1[4] = 0x0
	out1[5] = 0x0
}

fe_non_zero :: proc "contextless" (arg1: ^Montgomery_Domain_Field_Element) -> u64 {
	return (arg1[0] | (arg1[1] | (arg1[2] | (arg1[3] | (arg1[4] | arg1[5])))))
}

@(optimization_mode = "none")
fe_cond_assign :: #force_no_inline proc "contextless" (
	out1, arg1: ^Montgomery_Domain_Field_Element,
	arg2: int,
) {
	x1 := fiat.cmovznz_u64(fiat.u1(arg2), out1[0], arg1[0])
	x2 := fiat.cmovznz_u64(fiat.u1(arg2), out1[1], arg1[1])
	x3 := fiat.cmovznz_u64(fiat.u1(arg2), out1[2], arg1[2])
	x4 := fiat.cmovznz_u64(fiat.u1(arg2), out1[3], arg1[3])
	x5 := fiat.cmovznz_u64(fiat.u1(arg2), out1[4], arg1[4])
	x6 := fiat.cmovznz_u64(fiat.u1(arg2), out1[5], arg1[5])
	out1[0] = x1
	out1[1] = x2
	out1[2] = x3
	out1[3] = x4
	out1[4] = x5
	out1[5] = x6
}

fe_from_montgomery :: proc "contextless" (
	out1: ^Non_Montgomery_Domain_Field_Element,
	arg1: ^Montgomery_Domain_Field_Element,
) {
	x1 := arg1[0]
	_, x2 := bits.mul_u64(x1, 0x6ed46089e88fdc45)
	x5, x4 := bits.mul_u64(x2, 0xffffffffffffffff)
	x7, x6 := bits.mul_u64(x2, 0xffffffffffffffff)
	x9, x8 := bits.mul_u64(x2, 0xffffffffffffffff)
	x11, x10 := bits.mul_u64(x2, 0xc7634d81f4372ddf)
	x13, x12 := bits.mul_u64(x2, 0x581a0db248b0a77a)
	x15, x14 := bits.mul_u64(x2, 0xecec196accc52973)
	x16, x17 := bits.add_u64(x15, x12, u64(0x0))
	x18, x19 := bits.add_u64(x13, x10, u64(fiat.u1(x17)))
	x20, x21 := bits.add_u64(x11, x8, u64(fiat.u1(x19)))
	x22, x23 := bits.add_u64(x9, x6, u64(fiat.u1(x21)))
	x24, x25 := bits.add_u64(x7, x4, u64(fiat.u1(x23)))
	_, x27 := bits.add_u64(x1, x14, u64(0x0))
	x28, x29 := bits.add_u64(u64(0x0), x16, u64(fiat.u1(x27)))
	x30, x31 := bits.add_u64(u64(0x0), x18, u64(fiat.u1(x29)))
	x32, x33 := bits.add_u64(u64(0x0), x20, u64(fiat.u1(x31)))
	x34, x35 := bits.add_u64(u64(0x0), x22, u64(fiat.u1(x33)))
	x36, x37 := bits.add_u64(u64(0x0), x24, u64(fiat.u1(x35)))
	x38, x39 := bits.add_u64(u64(0x0), (u64(fiat.u1(x25)) + x5), u64(fiat.u1(x37)))
	x40, x41 := bits.add_u64(x28, arg1[1], u64(0x0))
	x42, x43 := bits.add_u64(x30, u64(0x0), u64(fiat.u1(x41)))
	x44, x45 := bits.add_u64(x32, u64(0x0), u64(fiat.u1(x43)))
	x46, x47 := bits.add_u64(x34, u64(0x0), u64(fiat.u1(x45)))
	x48, x49 := bits.add_u64(x36, u64(0x0), u64(fiat.u1(x47)))
	x50, x51 := bits.add_u64(x38, u64(0x0), u64(fiat.u1(x49)))
	_, x52 := bits.mul_u64(x40, 0x6ed46089e88fdc45)
	x55, x54 := bits.mul_u64(x52, 0xffffffffffffffff)
	x57, x56 := bits.mul_u64(x52, 0xffffffffffffffff)
	x59, x58 := bits.mul_u64(x52, 0xffffffffffffffff)
	x61, x60 := bits.mul_u64(x52, 0xc7634d81f4372ddf)
	x63, x62 := bits.mul_u64(x52, 0x581a0db248b0a77a)
	x65, x64 := bits.mul_u64(x52, 0xecec196accc52973)
	x66, x67 := bits.add_u64(x65, x62, u64(0x0))
	x68, x69 := bits.add_u64(x63, x60, u64(fiat.u1(x67)))
	x70, x71 := bits.add_u64(x61, x58, u64(fiat.u1(x69)))
	x72, x73 := bits.add_u64(x59, x56, u64(fiat.u1(x71)))
	x74, x75 := bits.add_u64(x57, x54, u64(fiat.u1(x73)))
	_, x77 := bits.add_u64(x40, x64, u64(0x0))
	x78, x79 := bits.add_u64(x42, x66, u64(fiat.u1(x77)))
	x80, x81 := bits.add_u64(x44, x68, u64(fiat.u1(x79)))
	x82, x83 := bits.add_u64(x46, x70, u64(fiat.u1(x81)))
	x84, x85 := bits.add_u64(x48, x72, u64(fiat.u1(x83)))
	x86, x87 := bits.add_u64(x50, x74, u64(fiat.u1(x85)))
	x88, x89 := bits.add_u64((u64(fiat.u1(x51)) + u64(fiat.u1(x39))), (u64(fiat.u1(x75)) + x55), u64(fiat.u1(x87)))
	x90, x91 := bits.add_u64(x78, arg1[2], u64(0x0))
	x92, x93 := bits.add_u64(x80, u64(0x0), u64(fiat.u1(x91)))
	x94, x95 := bits.add_u64(x82, u64(0x0), u64(fiat.u1(x93)))
	x96, x97 := bits.add_u64(x84, u64(0x0), u64(fiat.u1(x95)))
	x98, x99 := bits.add_u64(x86, u64(0x0), u64(fiat.u1(x97)))
	x100, x101 := bits.add_u64(x88, u64(0x0), u64(fiat.u1(x99)))
	_, x102 := bits.mul_u64(x90, 0x6ed46089e88fdc45)
	x105, x104 := bits.mul_u64(x102, 0xffffffffffffffff)
	x107, x106 := bits.mul_u64(x102, 0xffffffffffffffff)
	x109, x108 := bits.mul_u64(x102, 0xffffffffffffffff)
	x111, x110 := bits.mul_u64(x102, 0xc7634d81f4372ddf)
	x113, x112 := bits.mul_u64(x102, 0x581a0db248b0a77a)
	x115, x114 := bits.mul_u64(x102, 0xecec196accc52973)
	x116, x117 := bits.add_u64(x115, x112, u64(0x0))
	x118, x119 := bits.add_u64(x113, x110, u64(fiat.u1(x117)))
	x120, x121 := bits.add_u64(x111, x108, u64(fiat.u1(x119)))
	x122, x123 := bits.add_u64(x109, x106, u64(fiat.u1(x121)))
	x124, x125 := bits.add_u64(x107, x104, u64(fiat.u1(x123)))
	_, x127 := bits.add_u64(x90, x114, u64(0x0))
	x128, x129 := bits.add_u64(x92, x116, u64(fiat.u1(x127)))
	x130, x131 := bits.add_u64(x94, x118, u64(fiat.u1(x129)))
	x132, x133 := bits.add_u64(x96, x120, u64(fiat.u1(x131)))
	x134, x135 := bits.add_u64(x98, x122, u64(fiat.u1(x133)))
	x136, x137 := bits.add_u64(x100, x124, u64(fiat.u1(x135)))
	x138, x139 := bits.add_u64((u64(fiat.u1(x101)) + u64(fiat.u1(x89))), (u64(fiat.u1(x125)) + x105), u64(fiat.u1(x137)))
	x140, x141 := bits.add_u64(x128, arg1[3], u64(0x0))
	x142, x143 := bits.add_u64(x130, u64(0x0), u64(fiat.u1(x141)))
	x144, x145 := bits.add_u64(x132, u64(0x0), u64(fiat.u1(x143)))
	x146, x147 := bits.add_u64(x134, u64(0x0), u64(fiat.u1(x145)))
	x148, x149 := bits.add_u64(x136, u64(0x0), u64(fiat.u1(x147)))
	x150, x151 := bits.add_u64(x138, u64(0x0), u64(fiat.u1(x149)))
	_, x152 := bits.mul_u64(x140, 0x6ed46089e88fdc45)
	x155, x154 := bits.mul_u64(x152, 0xffffffffffffffff)
	x157, x156 := bits.mul_u64(x152, 0xffffffffffffffff)
	x159, x158 := bits.mul_u64(x152, 0xffffffffffffffff)
	x161, x160 := bits.mul_u64(x152, 0xc7634d81f4372ddf)
	x163, x162 := bits.mul_u64(x152, 0x581a0db248b0a77a)
	x165, x164 := bits.mul_u64(x152, 0xecec196accc52973)
	x166, x167 := bits.add_u64(x165, x162, u64(0x0))
	x168, x169 := bits.add_u64(x163, x160, u64(fiat.u1(x167)))
	x170, x171 := bits.add_u64(x161, x158, u64(fiat.u1(x169)))
	x172, x173 := bits.add_u64(x159, x156, u64(fiat.u1(x171)))
	x174, x175 := bits.add_u64(x157, x154, u64(fiat.u1(x173)))
	_, x177 := bits.add_u64(x140, x164, u64(0x0))
	x178, x179 := bits.add_u64(x142, x166, u64(fiat.u1(x177)))
	x180, x181 := bits.add_u64(x144, x168, u64(fiat.u1(x179)))
	x182, x183 := bits.add_u64(x146, x170, u64(fiat.u1(x181)))
	x184, x185 := bits.add_u64(x148, x172, u64(fiat.u1(x183)))
	x186, x187 := bits.add_u64(x150, x174, u64(fiat.u1(x185)))
	x188, x189 := bits.add_u64((u64(fiat.u1(x151)) + u64(fiat.u1(x139))), (u64(fiat.u1(x175)) + x155), u64(fiat.u1(x187)))
	x190, x191 := bits.add_u64(x178, arg1[4], u64(0x0))
	x192, x193 := bits.add_u64(x180, u64(0x0), u64(fiat.u1(x191)))
	x194, x195 := bits.add_u64(x182, u64(0x0), u64(fiat.u1(x193)))
	x196, x197 := bits.add_u64(x184, u64(0x0), u64(fiat.u1(x195)))
	x198, x199 := bits.add_u64(x186, u64(0x0), u64(fiat.u1(x197)))
	x200, x201 := bits.add_u64(x188, u64(0x0), u64(fiat.u1(x199)))
	_, x202 := bits.mul_u64(x190, 0x6ed46089e88fdc45)
	x205, x204 := bits.mul_u64(x202, 0xffffffffffffffff)
	x207, x206 := bits.mul_u64(x202, 0xffffffffffffffff)
	x209, x208 := bits.mul_u64(x202, 0xffffffffffffffff)
	x211, x210 := bits.mul_u64(x202, 0xc7634d81f4372ddf)
	x213, x212 := bits.mul_u64(x202, 0x581a0db248b0a77a)
	x215, x214 := bits.mul_u64(x202, 0xecec196accc52973)
	x216, x217 := bits.add_u64(x215, x212, u64(0x0))
	x218, x219 := bits.add_u64(x213, x210, u64(fiat.u1(x217)))
	x220, x221 := bits.add_u64(x211, x208, u64(fiat.u1(x219)))
	x222, x223 := bits.add_u64(x209, x206, u64(fiat.u1(x221)))
	x224, x225 := bits.add_u64(x207, x204, u64(fiat.u1(x223)))
	_, x227 := bits.add_u64(x190, x214, u64(0x0))
	x228, x229 := bits.add_u64(x192, x216, u64(fiat.u1(x227)))
	x230, x231 := bits.add_u64(x194, x218, u64(fiat.u1(x229)))
	x232, x233 := bits.add_u64(x196, x220, u64(fiat.u1(x231)))
	x234, x235 := bits.add_u64(x198, x222, u64(fiat.u1(x233)))
	x236, x237 := bits.add_u64(x200, x224, u64(fiat.u1(x235)))
	x238, x239 := bits.add_u64((u64(fiat.u1(x201)) + u64(fiat.u1(x189))), (u64(fiat.u1(x225)) + x205), u64(fiat.u1(x237)))
	x240, x241 := bits.add_u64(x228, arg1[5], u64(0x0))
	x242, x243 := bits.add_u64(x230, u64(0x0), u64(fiat.u1(x241)))
	x244, x245 := bits.add_u64(x232, u64(0x0), u64(fiat.u1(x243)))
	x246, x247 := bits.add_u64(x234, u64(0x0), u64(fiat.u1(x245)))
	x248, x249 := bits.add_u64(x236, u64(0x0), u64(fiat.u1(x247)))
	x250, x251 := bits.add_u64(x238, u64(0x0), u64(fiat.u1(x249)))
	_, x252 := bits.mul_u64(x240, 0x6ed46089e88fdc45)
	x255, x254 := bits.mul_u64(x252, 0xffffffffffffffff)
	x257, x256 := bits.mul_u64(x252, 0xffffffffffffffff)
	x259, x258 := bits.mul_u64(x252, 0xffffffffffffffff)
	x261, x260 := bits.mul_u64(x252, 0xc7634d81f4372ddf)
	x263, x262 := bits.mul_u64(x252, 0x581a0db248b0a77a)
	x265, x264 := bits.mul_u64(x252, 0xecec196accc52973)
	x266, x267 := bits.add_u64(x265, x262, u64(0x0))
	x268, x269 := bits.add_u64(x263, x260, u64(fiat.u1(x267)))
	x270, x271 := bits.add_u64(x261, x258, u64(fiat.u1(x269)))
	x272, x273 := bits.add_u64(x259, x256, u64(fiat.u1(x271)))
	x274, x275 := bits.add_u64(x257, x254, u64(fiat.u1(x273)))
	_, x277 := bits.add_u64(x240, x264, u64(0x0))
	x278, x279 := bits.add_u64(x242, x266, u64(fiat.u1(x277)))
	x280, x281 := bits.add_u64(x244, x268, u64(fiat.u1(x279)))
	x282, x283 := bits.add_u64(x246, x270, u64(fiat.u1(x281)))
	x284, x285 := bits.add_u64(x248, x272, u64(fiat.u1(x283)))
	x286, x287 := bits.add_u64(x250, x274, u64(fiat.u1(x285)))
	x288, x289 := bits.add_u64((u64(fiat.u1(x251)) + u64(fiat.u1(x239))), (u64(fiat.u1(x275)) + x255), u64(fiat.u1(x287)))
	x290, x291 := bits.sub_u64(x278, 0xecec196accc52973, u64(0x0))
	x292, x293 := bits.sub_u64(x280, 0x581a0db248b0a77a, u64(fiat.u1(x291)))
	x294, x295 := bits.sub_u64(x282, 0xc7634d81f4372ddf, u64(fiat.u1(x293)))
	x296, x297 := bits.sub_u64(x284, 0xffffffffffffffff, u64(fiat.u1(x295)))
	x298, x299 := bits.sub_u64(x286, 0xffffffffffffffff, u64(fiat.u1(x297)))
	x300, x301 := bits.sub_u64(x288, 0xffffffffffffffff, u64(fiat.u1(x299)))
	_, x303 := bits.sub_u64(u64(fiat.u1(x289)), u64(0x0), u64(fiat.u1(x301)))
	x304 := fiat.cmovznz_u64(fiat.u1(x303), x290, x278)
	x305 := fiat.cmovznz_u64(fiat.u1(x303), x292, x280)
	x306 := fiat.cmovznz_u64(fiat.u1(x303), x294, x282)
	x307 := fiat.cmovznz_u64(fiat.u1(x303), x296, x284)
	x308 := fiat.cmovznz_u64(fiat.u1(x303), x298, x286)
	x309 := fiat.cmovznz_u64(fiat.u1(x303), x300, x288)
	out1[0] = x304
	out1[1] = x305
	out1[2] = x306
	out1[3] = x307
	out1[4] = x308
	out1[5] = x309
}

fe_to_montgomery :: proc "contextless" (
	out1: ^Montgomery_Domain_Field_Element,
	arg1: ^Non_Montgomery_Domain_Field_Element,
) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[4]
	x5 := arg1[5]
	x6 := arg1[0]
	x8, x7 := bits.mul_u64(x6, 0xc84ee012b39bf21)
	x10, x9 := bits.mul_u64(x6, 0x3fb05b7a28266895)
	x12, x11 := bits.mul_u64(x6, 0xd40d49174aab1cc5)
	x14, x13 := bits.mul_u64(x6, 0xbc3e483afcb82947)
	x16, x15 := bits.mul_u64(x6, 0xff3d81e5df1aa419)
	x18, x17 := bits.mul_u64(x6, 0x2d319b2419b409a9)
	x19, x20 := bits.add_u64(x18, x15, u64(0x0))
	x21, x22 := bits.add_u64(x16, x13, u64(fiat.u1(x20)))
	x23, x24 := bits.add_u64(x14, x11, u64(fiat.u1(x22)))
	x25, x26 := bits.add_u64(x12, x9, u64(fiat.u1(x24)))
	x27, x28 := bits.add_u64(x10, x7, u64(fiat.u1(x26)))
	_, x29 := bits.mul_u64(x17, 0x6ed46089e88fdc45)
	x32, x31 := bits.mul_u64(x29, 0xffffffffffffffff)
	x34, x33 := bits.mul_u64(x29, 0xffffffffffffffff)
	x36, x35 := bits.mul_u64(x29, 0xffffffffffffffff)
	x38, x37 := bits.mul_u64(x29, 0xc7634d81f4372ddf)
	x40, x39 := bits.mul_u64(x29, 0x581a0db248b0a77a)
	x42, x41 := bits.mul_u64(x29, 0xecec196accc52973)
	x43, x44 := bits.add_u64(x42, x39, u64(0x0))
	x45, x46 := bits.add_u64(x40, x37, u64(fiat.u1(x44)))
	x47, x48 := bits.add_u64(x38, x35, u64(fiat.u1(x46)))
	x49, x50 := bits.add_u64(x36, x33, u64(fiat.u1(x48)))
	x51, x52 := bits.add_u64(x34, x31, u64(fiat.u1(x50)))
	_, x54 := bits.add_u64(x17, x41, u64(0x0))
	x55, x56 := bits.add_u64(x19, x43, u64(fiat.u1(x54)))
	x57, x58 := bits.add_u64(x21, x45, u64(fiat.u1(x56)))
	x59, x60 := bits.add_u64(x23, x47, u64(fiat.u1(x58)))
	x61, x62 := bits.add_u64(x25, x49, u64(fiat.u1(x60)))
	x63, x64 := bits.add_u64(x27, x51, u64(fiat.u1(x62)))
	x65, x66 := bits.add_u64((u64(fiat.u1(x28)) + x8), (u64(fiat.u1(x52)) + x32), u64(fiat.u1(x64)))
	x68, x67 := bits.mul_u64(x1, 0xc84ee012b39bf21)
	x70, x69 := bits.mul_u64(x1, 0x3fb05b7a28266895)
	x72, x71 := bits.mul_u64(x1, 0xd40d49174aab1cc5)
	x74, x73 := bits.mul_u64(x1, 0xbc3e483afcb82947)
	x76, x75 := bits.mul_u64(x1, 0xff3d81e5df1aa419)
	x78, x77 := bits.mul_u64(x1, 0x2d319b2419b409a9)
	x79, x80 := bits.add_u64(x78, x75, u64(0x0))
	x81, x82 := bits.add_u64(x76, x73, u64(fiat.u1(x80)))
	x83, x84 := bits.add_u64(x74, x71, u64(fiat.u1(x82)))
	x85, x86 := bits.add_u64(x72, x69, u64(fiat.u1(x84)))
	x87, x88 := bits.add_u64(x70, x67, u64(fiat.u1(x86)))
	x89, x90 := bits.add_u64(x55, x77, u64(0x0))
	x91, x92 := bits.add_u64(x57, x79, u64(fiat.u1(x90)))
	x93, x94 := bits.add_u64(x59, x81, u64(fiat.u1(x92)))
	x95, x96 := bits.add_u64(x61, x83, u64(fiat.u1(x94)))
	x97, x98 := bits.add_u64(x63, x85, u64(fiat.u1(x96)))
	x99, x100 := bits.add_u64(x65, x87, u64(fiat.u1(x98)))
	_, x101 := bits.mul_u64(x89, 0x6ed46089e88fdc45)
	x104, x103 := bits.mul_u64(x101, 0xffffffffffffffff)
	x106, x105 := bits.mul_u64(x101, 0xffffffffffffffff)
	x108, x107 := bits.mul_u64(x101, 0xffffffffffffffff)
	x110, x109 := bits.mul_u64(x101, 0xc7634d81f4372ddf)
	x112, x111 := bits.mul_u64(x101, 0x581a0db248b0a77a)
	x114, x113 := bits.mul_u64(x101, 0xecec196accc52973)
	x115, x116 := bits.add_u64(x114, x111, u64(0x0))
	x117, x118 := bits.add_u64(x112, x109, u64(fiat.u1(x116)))
	x119, x120 := bits.add_u64(x110, x107, u64(fiat.u1(x118)))
	x121, x122 := bits.add_u64(x108, x105, u64(fiat.u1(x120)))
	x123, x124 := bits.add_u64(x106, x103, u64(fiat.u1(x122)))
	_, x126 := bits.add_u64(x89, x113, u64(0x0))
	x127, x128 := bits.add_u64(x91, x115, u64(fiat.u1(x126)))
	x129, x130 := bits.add_u64(x93, x117, u64(fiat.u1(x128)))
	x131, x132 := bits.add_u64(x95, x119, u64(fiat.u1(x130)))
	x133, x134 := bits.add_u64(x97, x121, u64(fiat.u1(x132)))
	x135, x136 := bits.add_u64(x99, x123, u64(fiat.u1(x134)))
	x137, x138 := bits.add_u64(((u64(fiat.u1(x100)) + u64(fiat.u1(x66))) + (u64(fiat.u1(x88)) + x68)), (u64(fiat.u1(x124)) + x104), u64(fiat.u1(x136)))
	x140, x139 := bits.mul_u64(x2, 0xc84ee012b39bf21)
	x142, x141 := bits.mul_u64(x2, 0x3fb05b7a28266895)
	x144, x143 := bits.mul_u64(x2, 0xd40d49174aab1cc5)
	x146, x145 := bits.mul_u64(x2, 0xbc3e483afcb82947)
	x148, x147 := bits.mul_u64(x2, 0xff3d81e5df1aa419)
	x150, x149 := bits.mul_u64(x2, 0x2d319b2419b409a9)
	x151, x152 := bits.add_u64(x150, x147, u64(0x0))
	x153, x154 := bits.add_u64(x148, x145, u64(fiat.u1(x152)))
	x155, x156 := bits.add_u64(x146, x143, u64(fiat.u1(x154)))
	x157, x158 := bits.add_u64(x144, x141, u64(fiat.u1(x156)))
	x159, x160 := bits.add_u64(x142, x139, u64(fiat.u1(x158)))
	x161, x162 := bits.add_u64(x127, x149, u64(0x0))
	x163, x164 := bits.add_u64(x129, x151, u64(fiat.u1(x162)))
	x165, x166 := bits.add_u64(x131, x153, u64(fiat.u1(x164)))
	x167, x168 := bits.add_u64(x133, x155, u64(fiat.u1(x166)))
	x169, x170 := bits.add_u64(x135, x157, u64(fiat.u1(x168)))
	x171, x172 := bits.add_u64(x137, x159, u64(fiat.u1(x170)))
	_, x173 := bits.mul_u64(x161, 0x6ed46089e88fdc45)
	x176, x175 := bits.mul_u64(x173, 0xffffffffffffffff)
	x178, x177 := bits.mul_u64(x173, 0xffffffffffffffff)
	x180, x179 := bits.mul_u64(x173, 0xffffffffffffffff)
	x182, x181 := bits.mul_u64(x173, 0xc7634d81f4372ddf)
	x184, x183 := bits.mul_u64(x173, 0x581a0db248b0a77a)
	x186, x185 := bits.mul_u64(x173, 0xecec196accc52973)
	x187, x188 := bits.add_u64(x186, x183, u64(0x0))
	x189, x190 := bits.add_u64(x184, x181, u64(fiat.u1(x188)))
	x191, x192 := bits.add_u64(x182, x179, u64(fiat.u1(x190)))
	x193, x194 := bits.add_u64(x180, x177, u64(fiat.u1(x192)))
	x195, x196 := bits.add_u64(x178, x175, u64(fiat.u1(x194)))
	_, x198 := bits.add_u64(x161, x185, u64(0x0))
	x199, x200 := bits.add_u64(x163, x187, u64(fiat.u1(x198)))
	x201, x202 := bits.add_u64(x165, x189, u64(fiat.u1(x200)))
	x203, x204 := bits.add_u64(x167, x191, u64(fiat.u1(x202)))
	x205, x206 := bits.add_u64(x169, x193, u64(fiat.u1(x204)))
	x207, x208 := bits.add_u64(x171, x195, u64(fiat.u1(x206)))
	x209, x210 := bits.add_u64(((u64(fiat.u1(x172)) + u64(fiat.u1(x138))) + (u64(fiat.u1(x160)) + x140)), (u64(fiat.u1(x196)) + x176), u64(fiat.u1(x208)))
	x212, x211 := bits.mul_u64(x3, 0xc84ee012b39bf21)
	x214, x213 := bits.mul_u64(x3, 0x3fb05b7a28266895)
	x216, x215 := bits.mul_u64(x3, 0xd40d49174aab1cc5)
	x218, x217 := bits.mul_u64(x3, 0xbc3e483afcb82947)
	x220, x219 := bits.mul_u64(x3, 0xff3d81e5df1aa419)
	x222, x221 := bits.mul_u64(x3, 0x2d319b2419b409a9)
	x223, x224 := bits.add_u64(x222, x219, u64(0x0))
	x225, x226 := bits.add_u64(x220, x217, u64(fiat.u1(x224)))
	x227, x228 := bits.add_u64(x218, x215, u64(fiat.u1(x226)))
	x229, x230 := bits.add_u64(x216, x213, u64(fiat.u1(x228)))
	x231, x232 := bits.add_u64(x214, x211, u64(fiat.u1(x230)))
	x233, x234 := bits.add_u64(x199, x221, u64(0x0))
	x235, x236 := bits.add_u64(x201, x223, u64(fiat.u1(x234)))
	x237, x238 := bits.add_u64(x203, x225, u64(fiat.u1(x236)))
	x239, x240 := bits.add_u64(x205, x227, u64(fiat.u1(x238)))
	x241, x242 := bits.add_u64(x207, x229, u64(fiat.u1(x240)))
	x243, x244 := bits.add_u64(x209, x231, u64(fiat.u1(x242)))
	_, x245 := bits.mul_u64(x233, 0x6ed46089e88fdc45)
	x248, x247 := bits.mul_u64(x245, 0xffffffffffffffff)
	x250, x249 := bits.mul_u64(x245, 0xffffffffffffffff)
	x252, x251 := bits.mul_u64(x245, 0xffffffffffffffff)
	x254, x253 := bits.mul_u64(x245, 0xc7634d81f4372ddf)
	x256, x255 := bits.mul_u64(x245, 0x581a0db248b0a77a)
	x258, x257 := bits.mul_u64(x245, 0xecec196accc52973)
	x259, x260 := bits.add_u64(x258, x255, u64(0x0))
	x261, x262 := bits.add_u64(x256, x253, u64(fiat.u1(x260)))
	x263, x264 := bits.add_u64(x254, x251, u64(fiat.u1(x262)))
	x265, x266 := bits.add_u64(x252, x249, u64(fiat.u1(x264)))
	x267, x268 := bits.add_u64(x250, x247, u64(fiat.u1(x266)))
	_, x270 := bits.add_u64(x233, x257, u64(0x0))
	x271, x272 := bits.add_u64(x235, x259, u64(fiat.u1(x270)))
	x273, x274 := bits.add_u64(x237, x261, u64(fiat.u1(x272)))
	x275, x276 := bits.add_u64(x239, x263, u64(fiat.u1(x274)))
	x277, x278 := bits.add_u64(x241, x265, u64(fiat.u1(x276)))
	x279, x280 := bits.add_u64(x243, x267, u64(fiat.u1(x278)))
	x281, x282 := bits.add_u64(((u64(fiat.u1(x244)) + u64(fiat.u1(x210))) + (u64(fiat.u1(x232)) + x212)), (u64(fiat.u1(x268)) + x248), u64(fiat.u1(x280)))
	x284, x283 := bits.mul_u64(x4, 0xc84ee012b39bf21)
	x286, x285 := bits.mul_u64(x4, 0x3fb05b7a28266895)
	x288, x287 := bits.mul_u64(x4, 0xd40d49174aab1cc5)
	x290, x289 := bits.mul_u64(x4, 0xbc3e483afcb82947)
	x292, x291 := bits.mul_u64(x4, 0xff3d81e5df1aa419)
	x294, x293 := bits.mul_u64(x4, 0x2d319b2419b409a9)
	x295, x296 := bits.add_u64(x294, x291, u64(0x0))
	x297, x298 := bits.add_u64(x292, x289, u64(fiat.u1(x296)))
	x299, x300 := bits.add_u64(x290, x287, u64(fiat.u1(x298)))
	x301, x302 := bits.add_u64(x288, x285, u64(fiat.u1(x300)))
	x303, x304 := bits.add_u64(x286, x283, u64(fiat.u1(x302)))
	x305, x306 := bits.add_u64(x271, x293, u64(0x0))
	x307, x308 := bits.add_u64(x273, x295, u64(fiat.u1(x306)))
	x309, x310 := bits.add_u64(x275, x297, u64(fiat.u1(x308)))
	x311, x312 := bits.add_u64(x277, x299, u64(fiat.u1(x310)))
	x313, x314 := bits.add_u64(x279, x301, u64(fiat.u1(x312)))
	x315, x316 := bits.add_u64(x281, x303, u64(fiat.u1(x314)))
	_, x317 := bits.mul_u64(x305, 0x6ed46089e88fdc45)
	x320, x319 := bits.mul_u64(x317, 0xffffffffffffffff)
	x322, x321 := bits.mul_u64(x317, 0xffffffffffffffff)
	x324, x323 := bits.mul_u64(x317, 0xffffffffffffffff)
	x326, x325 := bits.mul_u64(x317, 0xc7634d81f4372ddf)
	x328, x327 := bits.mul_u64(x317, 0x581a0db248b0a77a)
	x330, x329 := bits.mul_u64(x317, 0xecec196accc52973)
	x331, x332 := bits.add_u64(x330, x327, u64(0x0))
	x333, x334 := bits.add_u64(x328, x325, u64(fiat.u1(x332)))
	x335, x336 := bits.add_u64(x326, x323, u64(fiat.u1(x334)))
	x337, x338 := bits.add_u64(x324, x321, u64(fiat.u1(x336)))
	x339, x340 := bits.add_u64(x322, x319, u64(fiat.u1(x338)))
	_, x342 := bits.add_u64(x305, x329, u64(0x0))
	x343, x344 := bits.add_u64(x307, x331, u64(fiat.u1(x342)))
	x345, x346 := bits.add_u64(x309, x333, u64(fiat.u1(x344)))
	x347, x348 := bits.add_u64(x311, x335, u64(fiat.u1(x346)))
	x349, x350 := bits.add_u64(x313, x337, u64(fiat.u1(x348)))
	x351, x352 := bits.add_u64(x315, x339, u64(fiat.u1(x350)))
	x353, x354 := bits.add_u64(((u64(fiat.u1(x316)) + u64(fiat.u1(x282))) + (u64(fiat.u1(x304)) + x284)), (u64(fiat.u1(x340)) + x320), u64(fiat.u1(x352)))
	x356, x355 := bits.mul_u64(x5, 0xc84ee012b39bf21)
	x358, x357 := bits.mul_u64(x5, 0x3fb05b7a28266895)
	x360, x359 := bits.mul_u64(x5, 0xd40d49174aab1cc5)
	x362, x361 := bits.mul_u64(x5, 0xbc3e483afcb82947)
	x364, x363 := bits.mul_u64(x5, 0xff3d81e5df1aa419)
	x366, x365 := bits.mul_u64(x5, 0x2d319b2419b409a9)
	x367, x368 := bits.add_u64(x366, x363, u64(0x0))
	x369, x370 := bits.add_u64(x364, x361, u64(fiat.u1(x368)))
	x371, x372 := bits.add_u64(x362, x359, u64(fiat.u1(x370)))
	x373, x374 := bits.add_u64(x360, x357, u64(fiat.u1(x372)))
	x375, x376 := bits.add_u64(x358, x355, u64(fiat.u1(x374)))
	x377, x378 := bits.add_u64(x343, x365, u64(0x0))
	x379, x380 := bits.add_u64(x345, x367, u64(fiat.u1(x378)))
	x381, x382 := bits.add_u64(x347, x369, u64(fiat.u1(x380)))
	x383, x384 := bits.add_u64(x349, x371, u64(fiat.u1(x382)))
	x385, x386 := bits.add_u64(x351, x373, u64(fiat.u1(x384)))
	x387, x388 := bits.add_u64(x353, x375, u64(fiat.u1(x386)))
	_, x389 := bits.mul_u64(x377, 0x6ed46089e88fdc45)
	x392, x391 := bits.mul_u64(x389, 0xffffffffffffffff)
	x394, x393 := bits.mul_u64(x389, 0xffffffffffffffff)
	x396, x395 := bits.mul_u64(x389, 0xffffffffffffffff)
	x398, x397 := bits.mul_u64(x389, 0xc7634d81f4372ddf)
	x400, x399 := bits.mul_u64(x389, 0x581a0db248b0a77a)
	x402, x401 := bits.mul_u64(x389, 0xecec196accc52973)
	x403, x404 := bits.add_u64(x402, x399, u64(0x0))
	x405, x406 := bits.add_u64(x400, x397, u64(fiat.u1(x404)))
	x407, x408 := bits.add_u64(x398, x395, u64(fiat.u1(x406)))
	x409, x410 := bits.add_u64(x396, x393, u64(fiat.u1(x408)))
	x411, x412 := bits.add_u64(x394, x391, u64(fiat.u1(x410)))
	_, x414 := bits.add_u64(x377, x401, u64(0x0))
	x415, x416 := bits.add_u64(x379, x403, u64(fiat.u1(x414)))
	x417, x418 := bits.add_u64(x381, x405, u64(fiat.u1(x416)))
	x419, x420 := bits.add_u64(x383, x407, u64(fiat.u1(x418)))
	x421, x422 := bits.add_u64(x385, x409, u64(fiat.u1(x420)))
	x423, x424 := bits.add_u64(x387, x411, u64(fiat.u1(x422)))
	x425, x426 := bits.add_u64(((u64(fiat.u1(x388)) + u64(fiat.u1(x354))) + (u64(fiat.u1(x376)) + x356)), (u64(fiat.u1(x412)) + x392), u64(fiat.u1(x424)))
	x427, x428 := bits.sub_u64(x415, 0xecec196accc52973, u64(0x0))
	x429, x430 := bits.sub_u64(x417, 0x581a0db248b0a77a, u64(fiat.u1(x428)))
	x431, x432 := bits.sub_u64(x419, 0xc7634d81f4372ddf, u64(fiat.u1(x430)))
	x433, x434 := bits.sub_u64(x421, 0xffffffffffffffff, u64(fiat.u1(x432)))
	x435, x436 := bits.sub_u64(x423, 0xffffffffffffffff, u64(fiat.u1(x434)))
	x437, x438 := bits.sub_u64(x425, 0xffffffffffffffff, u64(fiat.u1(x436)))
	_, x440 := bits.sub_u64(u64(fiat.u1(x426)), u64(0x0), u64(fiat.u1(x438)))
	x441 := fiat.cmovznz_u64(fiat.u1(x440), x427, x415)
	x442 := fiat.cmovznz_u64(fiat.u1(x440), x429, x417)
	x443 := fiat.cmovznz_u64(fiat.u1(x440), x431, x419)
	x444 := fiat.cmovznz_u64(fiat.u1(x440), x433, x421)
	x445 := fiat.cmovznz_u64(fiat.u1(x440), x435, x423)
	x446 := fiat.cmovznz_u64(fiat.u1(x440), x437, x425)
	out1[0] = x441
	out1[1] = x442
	out1[2] = x443
	out1[3] = x444
	out1[4] = x445
	out1[5] = x446
}
