
(* The type of tokens. *)

type token = 
  | VEC_UNARY of (Ast.instr')
  | VEC_TYPE of (Types.vec_type)
  | VEC_TEST of (Ast.instr')
  | VEC_TERNARY of (Ast.instr')
  | VEC_STORE_LANE of (int option -> Memory.offset -> int -> Ast.instr')
  | VEC_STORE of (int option -> Memory.offset -> Ast.instr')
  | VEC_SPLAT of (Ast.instr')
  | VEC_SHUFFLE
  | VEC_SHIFT of (Ast.instr')
  | VEC_SHAPE of (V128.shape)
  | VEC_REPLACE of (int -> Ast.instr')
  | VEC_LOAD_LANE of (int option -> Memory.offset -> int -> Ast.instr')
  | VEC_LOAD of (int option -> Memory.offset -> Ast.instr')
  | VEC_EXTRACT of (int -> Ast.instr')
  | VEC_CONST of (V128.shape -> string Source.phrase list -> Source.region -> Ast.instr' * Values.vec)
  | VEC_BITMASK of (Ast.instr')
  | VEC_BINARY of (Ast.instr')
  | VAR of (string)
  | UNREACHABLE
  | UNARY of (Ast.instr')
  | TYPE
  | THEN
  | TEST of (Ast.instr')
  | TABLE_SIZE
  | TABLE_SET
  | TABLE_INIT
  | TABLE_GROW
  | TABLE_GET
  | TABLE_FILL
  | TABLE_COPY
  | TABLE
  | STRING of (string)
  | STORE of (int option -> Memory.offset -> Ast.instr')
  | START
  | SELECT
  | SCRIPT
  | RPAR
  | RETURN
  | RESULT
  | REGISTER
  | REF_NULL
  | REF_IS_NULL
  | REF_FUNC
  | REF_EXTERN
  | QUOTE
  | PARAM
  | OUTPUT
  | OFFSET_EQ_NAT of (string)
  | OFFSET
  | NUM_TYPE of (Types.num_type)
  | NOP
  | NAT of (string)
  | NAN of (Script.nan)
  | MUT
  | MODULE
  | MEMORY_SIZE
  | MEMORY_INIT
  | MEMORY_GROW
  | MEMORY_FILL
  | MEMORY_COPY
  | MEMORY
  | LPAR
  | LOOP
  | LOCAL_TEE
  | LOCAL_SET
  | LOCAL_GET
  | LOCAL
  | LOAD of (int option -> Memory.offset -> Ast.instr')
  | ITEM
  | INVOKE
  | INT of (string)
  | INPUT
  | IMPORT
  | IF
  | GLOBAL_SET
  | GLOBAL_GET
  | GLOBAL
  | GET
  | FUNCREF
  | FUNC
  | FLOAT of (string)
  | EXTERNREF
  | EXTERN
  | EXPORT
  | EOF
  | END
  | ELSE
  | ELEM_DROP
  | ELEM
  | DROP
  | DECLARE
  | DATA_DROP
  | DATA
  | CONVERT of (Ast.instr')
  | CONST of (string Source.phrase -> Ast.instr' * Values.num)
  | COMPARE of (Ast.instr')
  | CALL_INDIRECT
  | CALL
  | BR_TABLE
  | BR_IF
  | BR
  | BLOCK
  | BINARY of (Ast.instr')
  | BIN
  | ASSERT_UNLINKABLE
  | ASSERT_TRAP
  | ASSERT_RETURN
  | ASSERT_MALFORMED
  | ASSERT_INVALID
  | ASSERT_EXHAUSTION
  | ALIGN_EQ_NAT of (string)

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val script1: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Script.script)

val script: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Script.script)

val module1: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (Script.var option * Script.definition)
