module type S = sig
type position = Lexing.position =
  {
  pos_fname: string ;
  pos_lnum: int ;
  pos_bol: int ;
  pos_cnum: int }
(** Alias for {!Lexing.position} *)


type lexbuf = Lexing.lexbuf =
  {
  refill_buff: lexbuf -> unit ;
  mutable lex_buffer: bytes ;
  mutable lex_buffer_len: int ;
  mutable lex_abs_pos: int ;
  mutable lex_start_pos: int ;
  mutable lex_curr_pos: int ;
  mutable lex_last_pos: int ;
  mutable lex_last_action: int ;
  mutable lex_eof_reached: bool ;
  mutable lex_mem: int array ;
  mutable lex_start_p: position ;
  mutable lex_curr_p: position }

(*
type lexbuf = Lexing.lexbuf =
  {
  refill_buff: lexbuf -> unit ;
  mutable lex_buffer: string ;
  mutable lex_buffer_len: int ;
  mutable lex_abs_pos: int ;
  mutable lex_start_pos: int ;
  mutable lex_curr_pos: int ;
  mutable lex_last_pos: int ;
  mutable lex_last_action: int ;
  mutable lex_eof_reached: bool ;
  mutable lex_mem: int array ;
  mutable lex_start_p: position ;
  mutable lex_curr_p: position }
*)
(** @since 4.02.0:
    type lexbuf =
      {
      refill_buff: lexbuf -> unit ;
      mutable lex_buffer: bytes ;
      mutable lex_buffer_len: int ;
      mutable lex_abs_pos: int ;
      mutable lex_start_pos: int ;
      mutable lex_curr_pos: int ;
      mutable lex_last_pos: int ;
      mutable lex_last_action: int ;
      mutable lex_eof_reached: bool ;
      mutable lex_mem: int array ;
      mutable lex_start_p: position ;
      mutable lex_curr_p: position }
@since 3.07.0:
type lexbuf =
  {
  refill_buff: lexbuf -> unit ;
  mutable lex_buffer: string ;
  mutable lex_buffer_len: int ;
  mutable lex_abs_pos: int ;
  mutable lex_start_pos: int ;
  mutable lex_curr_pos: int ;
  mutable lex_last_pos: int ;
  mutable lex_last_action: int ;
  mutable lex_eof_reached: bool ;
  mutable lex_mem: int array ;
  mutable lex_start_p: position ;
  mutable lex_curr_p: position }
 *)

type lex_tables = Lexing.lex_tables =
  {
  lex_base: string ;
  lex_backtrk: string ;
  lex_default: string ;
  lex_trans: string ;
  lex_check: string ;
  lex_base_code: string ;
  lex_backtrk_code: string ;
  lex_default_code: string ;
  lex_trans_code: string ;
  lex_check_code: string ;
  lex_code: string }
(** Alias for {!Lexing.lex_tables} *)

val set_position : lexbuf -> position -> unit
(** @since 4.11.0: val set_position : lexbuf -> position -> unit *)

val set_filename : lexbuf -> string -> unit
(** @since 4.11.0: val set_filename : lexbuf -> string -> unit *)

val from_channel : ?with_positions:bool -> in_channel -> lexbuf
(** @since 4.08.0:
    val from_channel : ?with_positions:bool -> in_channel -> lexbuf *)

val from_string : ?with_positions:bool -> string -> lexbuf
(** @since 4.08.0: val from_string : ?with_positions:bool -> string -> lexbuf *)


val from_function : ?with_positions:bool -> (bytes -> int -> int) -> lexbuf

(*
val from_function :
  ?with_positions:bool -> (Stdcompat__init.bytes -> int -> int) -> lexbuf
*)
(** @since 4.08.0:
    val from_function :
      ?with_positions:bool -> (bytes -> int -> int) -> lexbuf
 *)

val with_positions : lexbuf -> bool
(** @since 4.08.0: val with_positions : lexbuf -> bool *)

val new_line : lexbuf -> unit
(** @since 3.11.0: val new_line : lexbuf -> unit *)

val dummy_pos : position
(** Alias for {!Lexing.dummy_pos} *)

val lexeme : lexbuf -> string
(** Alias for {!Lexing.lexeme} *)

val lexeme_char : lexbuf -> int -> char
(** Alias for {!Lexing.lexeme_char} *)

val lexeme_start : lexbuf -> int
(** Alias for {!Lexing.lexeme_start} *)

val lexeme_end : lexbuf -> int
(** Alias for {!Lexing.lexeme_end} *)

val lexeme_start_p : lexbuf -> position
(** Alias for {!Lexing.lexeme_start_p} *)

val lexeme_end_p : lexbuf -> position
(** Alias for {!Lexing.lexeme_end_p} *)

val flush_input : lexbuf -> unit
(** Alias for {!Lexing.flush_input} *)

val sub_lexeme : lexbuf -> int -> int -> string
(** Alias for {!Lexing.sub_lexeme} *)

val sub_lexeme_opt : lexbuf -> int -> int -> string option
(** Alias for {!Lexing.sub_lexeme_opt} *)

val sub_lexeme_char : lexbuf -> int -> char
(** Alias for {!Lexing.sub_lexeme_char} *)

val sub_lexeme_char_opt : lexbuf -> int -> char option
(** Alias for {!Lexing.sub_lexeme_char_opt} *)

val engine : lex_tables -> int -> lexbuf -> int
(** Alias for {!Lexing.engine} *)

val new_engine : lex_tables -> int -> lexbuf -> int
(** Alias for {!Lexing.new_engine} *)

end
