/* ---------------------------------------------------------------------------


  This file is part of the ``trace'' package.
  %COPYRIGHT%
  

-----------------------------------------------------------------------------*/

/*!
  \author Michele Dorigatti
  \brief Module header file for trace shell commands

  Module header file for trace shell commands

*/


#ifndef __NUSMV_SHELL_TRACE_TRACE_CMD_H__
#define __NUSMV_SHELL_TRACE_TRACE_CMD_H__

#include "nusmv/core/cinit/NuSMVEnv.h"
/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
/* commands */

/*!
  \brief \todo Missing synopsis

  \todo Missing description
*/
void traceCmd_init(NuSMVEnv_ptr env);

/*!
  \command{show_traces} Shows the traces generated in a NuSMV session

  \command_args{[ [-h] [-v] [-m | -o output-file] [-A]
  -t | [-d] -a | trace_number[.from_state[:[to_state]]] ]}

   Shows the traces currently stored in system memory, if
  any. By default it shows the last generated trace, if any. A trace number
  can be specified optionally followed by a slice denoting the steps top be
  shown. Negative numbers can be used to denote steps in a right-to-left fashion.
  (i.e. -1 denotes last step, -2 is the previous and so forth.)

  <p> Command Options:<p>
  <dl>
    <dt> <tt>-v</tt>
       <dd> Verbosely prints traces content (all state variables, otherwise
       it prints out only those variables that have changed their value from
       previous state).
    <dt> <tt>-t</tt>
       <dd> Prints only the total number of currently stored traces.
    <dt> <tt>-a</tt>
       <dd> Prints all the currently stored traces.
    <dt> <tt>-A</tt>
       <dd> Prints traces in an anonimized form.
    <dt> <tt>-d</tt>
       <dd> Disables DEFINEs printout in traces
    <dt> <tt>-p trace plugin</tt>
       <dd> Uses the specified trace plugin to explain the trace.
    <dt> <tt>-m</tt>
       <dd> Pipes the output through the program specified
       by the <tt>PAGER</tt> shell variable if defined, else through the
       <tt>UNIX</tt> command "more".
    <dt> <tt>-o output-file</tt>
       <dd> Writes the output generated by the command to <tt>output-file</tt>
    <dt> <tt>trace_number</tt>
       <dd> The (ordinal) identifier number of the trace to be printed.
    <dt> <tt>from_state</tt>
      <dd> Denotes left end of the trace slice to be printed.
    <dt> <tt>to_state</tt>
     <dd> Denotes right end of the trace slice to be printed.
  </dl> 

  \sa pick_state goto_state simulate
*/
int CommandShowTraces(NuSMVEnv_ptr env, int argc, char** argv);

/*!
  \command{show_plugins} Lists out all the available plugins inside the system. In
  addition, it prints [D] in front of the default plugin.

  \command_args{[ [-h] [-n plugin_index| -a]]

  CommandDescription [
  Sets the default plugin to print traces.
  <p> Command Options:<p>
  <dl>
    <dt> <tt>-h</tt>
       <dd> Prints the usage of the command.
    <dt> <tt>-n plugin_index</tt>
       <dd> Prints the description message of the plugin at specified index
       only.
    <dt> <tt>-a</tt>
       <dd> Prints all the available plugins with their description.
  </dl> ]

*****************************************************************************[EXTRACT_DOC_NOTE: * /]
}

  
  Sets the default plugin to print traces.
  <p> Command Options:<p>
  <dl>
    <dt> <tt>-h</tt>
       <dd> Prints the usage of the command.
    <dt> <tt>-n plugin_index</tt>
       <dd> Prints the description message of the plugin at specified index
       only.
    <dt> <tt>-a</tt>
       <dd> Prints all the available plugins with their description.
  </dl> 
*/
int CommandShowPlugins(NuSMVEnv_ptr env, int argc, char** argv);

/*!
  \command{read_trace} Reads the trace from the specified file into the memory

  \command_args{ [-h] | [-i filename] | [-u] [-s] filename}

  
  Reads a trace from a specified XML file into the memory.
  <p>
  Command Options:<p>
  <dl>
    <dt> <tt>-h</tt>
       <dd> Prints the usage of the command.
    <dt> <tt>-i filename</tt>
       <dd> Specifies the name of the xml trace file to read (deprecated).
    <dt> <tt>-u</tt>
       <dd> Turns 'undefined symbol' error in a warning.
    <dt> <tt>-s</tt>
       <dd> Turns 'wrong section' error in a warning.
    <dt> <tt>filename</tt>
       <dd> Specifies the name of the xml trace file to read
    </dl>
    

  \sa show_traces
*/
int CommandReadTrace(NuSMVEnv_ptr env, int argc, char** argv);

/*!
  \command{execute_traces} Executes complete traces on the model FSM

  \command_args{[-h] [-v] [-m | -o output-file]
                      -e engine [-a | trace_number]}

  Executes traces stored in the Trace Manager.  If
                      no trace is specified, last registered trace is
                      executed. Traces must be complete in order to
                      perform execution.

  <p> Command Options:<p>
  <dl>
    <dt> <tt>-v</tt>
       <dd> Verbosely prints traces execution steps
    <dt> <tt>-a</tt>
       <dd> Prints all the currently stored traces.
    <dt> <tt>-m</tt>
       <dd> Pipes the output through the program specified
       by the <tt>PAGER</tt> shell variable if defined, else through the
       <tt>UNIX</tt> command "more".
    <dt> <tt>-o output-file</tt>
       <dd> Writes the output generated by the command to <tt>output-file</tt>
    <dt> <tt>-e executor</tt>
       <dd> Selects an executor for trace re-execution.
    <dt> <tt>trace_number</tt>
       <dd> The (ordinal) identifier number of the trace to be printed.
  </dl> 

  \sa CommandExecutePartialTraces
*/
int CommandExecuteTraces(NuSMVEnv_ptr env, int argc, char** argv);

/*!
  \command{execute_partial_traces} Executes partial traces on the model FSM

  \command_args{[-h] [-v] [-r] [-m | -o output-file]
                      -e engine [-a | trace_number]}

  Executes traces stored in the Trace Manager.  If
                      no trace is specified, last registered trace is
                      executed. Traces are not required to be
                      complete.  Upon succesful termination, a new
                      complete trace is registered in the Trace
                      Manager.

  <p> Command Options:<p>
  <dl>
    <dt> <tt>-v</tt>
       <dd> Verbosely prints traces execution steps.
    <dt> <tt>-a</tt>
       <dd> Executes all the currently stored traces.
    <dt> <tt>-r</tt>
       <dd> Performs restart on complete states (deprecated).
    <dt> <tt>-m</tt>
       <dd> Pipes the output through the program specified
       by the <tt>PAGER</tt> shell variable if defined, else through the
       <tt>UNIX</tt> command "more".
    <dt> <tt>-o output-file</tt>
       <dd> Writes the output generated by the command to <tt>output-file</tt>
    <dt> <tt>-e engine</tt>
       <dd> Selects an engine for trace re-execution. It must be one of 'bdd',
       'sat'.
    <dt> <tt>trace_number</tt>
       <dd> The (ordinal) identifier number of the trace to be printed.
  </dl> 

  \sa CommandExecuteTraces
*/
int CommandExecutePartialTraces(NuSMVEnv_ptr env, int argc, char** argv);

/*!
  \brief Parse and checks whether the argument 's' contains valid 
   types for trace number and state number/slices 'from' and 'to'. 

   Return 0 iff the parse and checks of the argument 's' 
   (format trace.from:to) contains valid  types (integer) for 
   trace number and state number/slices 'from' and 'to'. Moreover,
   the values for 'trace', 'from', and 'to' are assigned.
*/
int traceCmd_parse_slice(const NuSMVEnv_ptr env, const char* s,
                         int* trace, int* from, int* to);

/**AutomaticEnd***************************************************************/

#endif /* __NUSMV_SHELL_TRACE_TRACE_CMD_H__ */
