def _cmake_to_bool(s):
    return s.upper() not in ['', '0','FALSE','OFF','N','NO','IGNORE','NOTFOUND']

is_python_package    = _cmake_to_bool("")

BUILD_STUB_FILES     = _cmake_to_bool("OFF")
BUILD_UMFPACK        = _cmake_to_bool("NO")
ENABLE_UNIT_TESTS    = _cmake_to_bool("OFF")
INSTALL_DEPENDENCIES = _cmake_to_bool("OFF")
USE_CCACHE           = _cmake_to_bool("OFF")
USE_HYPRE            = _cmake_to_bool("OFF")
USE_LAPACK           = _cmake_to_bool("ON")
USE_MKL              = _cmake_to_bool("OFF")
USE_MKL              = _cmake_to_bool("OFF")
USE_MUMPS            = _cmake_to_bool("OFF")
USE_PARDISO          = _cmake_to_bool("OFF")
USE_UMFPACK          = _cmake_to_bool("ON")

NETGEN_DIR = "/opt/local"

NGSOLVE_COMPILE_DEFINITIONS         = "HAVE_NETGEN_SOURCES;HAVE_DLFCN_H;HAVE_CXA_DEMANGLE;USE_TIMEOFDAY;MSG_NOSIGNAL=0;TCL;LAPACK;NGS_PYTHON;USE_UMFPACK"
NGSOLVE_COMPILE_DEFINITIONS_PRIVATE = ""
NGSOLVE_COMPILE_INCLUDE_DIRS        = ""
NGSOLVE_COMPILE_OPTIONS             = "$<$<COMPILE_LANGUAGE:CXX>:-std=c++17>;$<$<COMPILE_LANGUAGE:CXX>:-Wno-undefined-var-template>;-DMAX_SYS_DIM=3"

NGSOLVE_VERSION = "........-..-.."
NGSOLVE_VERSION_GIT = ".."
NGSOLVE_VERSION_PYTHON = ""

NGSOLVE_VERSION_MAJOR = ".."
NGSOLVE_VERSION_MINOR = ".."
NGSOLVE_VERSION_TWEAK = ".."
NGSOLVE_VERSION_PATCH = ".."
NGSOLVE_VERSION_HASH = ".."

CMAKE_CXX_COMPILER           = "/opt/local/bin/clang++-mp-19"
CMAKE_CUDA_COMPILER          = ""
CMAKE_C_COMPILER             = "/opt/local/bin/clang-mp-19"
CMAKE_LINKER                 = "/opt/local/bin/ld"
CMAKE_INSTALL_PREFIX         = "/opt/local"
CMAKE_CXX_COMPILER_LAUNCHER  = ""

version = NGSOLVE_VERSION_GIT

def get_cmake_dir():
    import netgen.config as c
    import os.path as p
    d_python = p.dirname(p.dirname(__file__))
    py_to_cmake = p.relpath(
            p.dirname(c.NG_INSTALL_DIR_CMAKE),
            c.NG_INSTALL_DIR_PYTHON
            )
    return p.normpath(p.join(d_python,py_to_cmake, 'ngsolve'))
