/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: XeGPUTransformOps.td                                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::transform {

/// Convert xegpu.layout attribute for a value.
/// Adds an `xegpu.convert_layout` op to convert the `xegpu.layout` attribute
///     of a value. The input and target layouts are defined by the `*sg_layout`,
///     `*sg_data` and optional `*inst_data` attributes. Returns a handle to the
///     emitted `xegpu.convert_layout` op.
class ConvertLayoutOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Get a handle to the descriptor op of a value.
/// Traces the producers of the given value until an `xegpu.create_nd_tdesc`
///     descriptor op is found. Returns a handle to it. Currently traces
///     producers by following only the first operand of producer ops.
class GetDescOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Adds xegpu prefetch ops to matmul operand tiles.
/// Given a target value (e.g., `vector`) residing in a `scf.for` loop, this
///     transform finds the corresponding `xegpu.load_nd` op and inserts
///     `xegpu.prefetch_nd` operations for the tile. The load op must reside within
///     the `scf.for` loop. Number of prefetch steps is set by the `nb_prefetch`
///     argument (default value is 1). Returns a handle to the created
///     `xegpu.create_nd_desc` op.
class InsertPrefetchOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Set xegpu.layout attribute to a xegpu.create_nd_desc op result.
/// Given an `xegpu.create_nd_desc` operation, this transform adds
///     `xegpu.layout` attribute to the result tensor descriptor. The layout is
///     defined by the `sg_layout`, and `sg_data` and optional `inst_data`
///     attributes. If `slice_dims` is provided, the `xegpu.layout` attribute is
///     wrapped in an `xegpu.slice<..., dims=slice_dims>` attribute. Returns a handle to
///     the transformed op.
class SetDescLayoutOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Set number of threads for a given gpu.launch operation
/// Overrides the x,y,z threads operands of a given `gpu.launch` operation in-place.
class SetGPULaunchThreadsOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Set xegpu.layout attribute of an op.
/// Sets the `xegpu.layout` attribute of an op. If `result=true`, sets the
///     `layout_result_{index}`, otherwise `layout_operand_{index}` attribute. The
///     target operand/result value is defined by the `index` argument. The layout
///     is defined by the `sg_layout`, `sg_data` and optional `inst_data`
///     attributes. If `slice_dims` is provided, the `xegpu.layout` attribute is
///     wrapped in an `xegpu.slice<..., dims=slice_dims>` attribute.
class SetOpLayoutAttrOp;

} // namespace mlir::transform
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::ConvertLayoutOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertLayoutOpGenericAdaptorBase {
public:
  struct Properties {
    using static_input_inst_dataTy = ::mlir::DenseI64ArrayAttr;
    static_input_inst_dataTy static_input_inst_data;

    auto getStaticInputInstData() const {
      auto &propStorage = this->static_input_inst_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticInputInstData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_input_inst_data = propValue;
    }
    using static_input_sg_dataTy = ::mlir::DenseI64ArrayAttr;
    static_input_sg_dataTy static_input_sg_data;

    auto getStaticInputSgData() const {
      auto &propStorage = this->static_input_sg_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticInputSgData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_input_sg_data = propValue;
    }
    using static_input_sg_layoutTy = ::mlir::DenseI64ArrayAttr;
    static_input_sg_layoutTy static_input_sg_layout;

    auto getStaticInputSgLayout() const {
      auto &propStorage = this->static_input_sg_layout;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticInputSgLayout(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_input_sg_layout = propValue;
    }
    using static_target_inst_dataTy = ::mlir::DenseI64ArrayAttr;
    static_target_inst_dataTy static_target_inst_data;

    auto getStaticTargetInstData() const {
      auto &propStorage = this->static_target_inst_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticTargetInstData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_target_inst_data = propValue;
    }
    using static_target_sg_dataTy = ::mlir::DenseI64ArrayAttr;
    static_target_sg_dataTy static_target_sg_data;

    auto getStaticTargetSgData() const {
      auto &propStorage = this->static_target_sg_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticTargetSgData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_target_sg_data = propValue;
    }
    using static_target_sg_layoutTy = ::mlir::DenseI64ArrayAttr;
    static_target_sg_layoutTy static_target_sg_layout;

    auto getStaticTargetSgLayout() const {
      auto &propStorage = this->static_target_sg_layout;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticTargetSgLayout(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_target_sg_layout = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 7>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.static_input_inst_data == this->static_input_inst_data &&
        rhs.static_input_sg_data == this->static_input_sg_data &&
        rhs.static_input_sg_layout == this->static_input_sg_layout &&
        rhs.static_target_inst_data == this->static_target_inst_data &&
        rhs.static_target_sg_data == this->static_target_sg_data &&
        rhs.static_target_sg_layout == this->static_target_sg_layout &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertLayoutOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.convert_layout", odsAttrs.getContext());
  }

  ConvertLayoutOpGenericAdaptorBase(ConvertLayoutOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getStaticInputSgLayoutAttr();
  ::llvm::ArrayRef<int64_t> getStaticInputSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticInputSgDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticInputSgData();
  ::mlir::DenseI64ArrayAttr getStaticInputInstDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticInputInstData();
  ::mlir::DenseI64ArrayAttr getStaticTargetSgLayoutAttr();
  ::llvm::ArrayRef<int64_t> getStaticTargetSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticTargetSgDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticTargetSgData();
  ::mlir::DenseI64ArrayAttr getStaticTargetInstDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticTargetInstData();
};

} // namespace detail
template <typename RangeT>
class ConvertLayoutOpGenericAdaptor : public detail::ConvertLayoutOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertLayoutOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_input_sg_layout = 1;
  static constexpr int odsIndex_input_sg_data = 2;
  static constexpr int odsIndex_input_inst_data = 3;
  static constexpr int odsIndex_target_sg_layout = 4;
  static constexpr int odsIndex_target_sg_data = 5;
  static constexpr int odsIndex_target_inst_data = 6;
public:
  ConvertLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertLayoutOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ConvertLayoutOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertLayoutOpGenericAdaptor(RangeT values, const ConvertLayoutOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertLayoutOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertLayoutOp>>>
  ConvertLayoutOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getInputSgLayout() {
    return getODSOperands(1);
  }

  RangeT getInputSgData() {
    return getODSOperands(2);
  }

  RangeT getInputInstData() {
    return getODSOperands(3);
  }

  RangeT getTargetSgLayout() {
    return getODSOperands(4);
  }

  RangeT getTargetSgData() {
    return getODSOperands(5);
  }

  RangeT getTargetInstData() {
    return getODSOperands(6);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertLayoutOpAdaptor : public ConvertLayoutOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertLayoutOpGenericAdaptor::ConvertLayoutOpGenericAdaptor;
  ConvertLayoutOpAdaptor(ConvertLayoutOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertLayoutOp : public ::mlir::Op<ConvertLayoutOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformHandleTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertLayoutOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertLayoutOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_input_sg_layout = 1;
  static constexpr int odsIndex_input_sg_data = 2;
  static constexpr int odsIndex_input_inst_data = 3;
  static constexpr int odsIndex_target_sg_layout = 4;
  static constexpr int odsIndex_target_sg_data = 5;
  static constexpr int odsIndex_target_inst_data = 6;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("static_input_inst_data"), ::llvm::StringRef("static_input_sg_data"), ::llvm::StringRef("static_input_sg_layout"), ::llvm::StringRef("static_target_inst_data"), ::llvm::StringRef("static_target_sg_data"), ::llvm::StringRef("static_target_sg_layout"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getStaticInputInstDataAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getStaticInputInstDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getStaticInputSgDataAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getStaticInputSgDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getStaticInputSgLayoutAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getStaticInputSgLayoutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStaticTargetInstDataAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStaticTargetInstDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStaticTargetSgDataAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStaticTargetSgDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getStaticTargetSgLayoutAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getStaticTargetSgLayoutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.convert_layout");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getInputSgLayout() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getInputSgData() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getInputInstData() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getTargetSgLayout() {
    return getODSOperands(4);
  }

  ::mlir::Operation::operand_range getTargetSgData() {
    return getODSOperands(5);
  }

  ::mlir::Operation::operand_range getTargetInstData() {
    return getODSOperands(6);
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getInputSgLayoutMutable();
  ::mlir::MutableOperandRange getInputSgDataMutable();
  ::mlir::MutableOperandRange getInputInstDataMutable();
  ::mlir::MutableOperandRange getTargetSgLayoutMutable();
  ::mlir::MutableOperandRange getTargetSgDataMutable();
  ::mlir::MutableOperandRange getTargetInstDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getNewConvertOp() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getStaticInputSgLayoutAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_sg_layout);
  }

  ::llvm::ArrayRef<int64_t> getStaticInputSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticInputSgDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_sg_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticInputSgData();
  ::mlir::DenseI64ArrayAttr getStaticInputInstDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_inst_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticInputInstData();
  ::mlir::DenseI64ArrayAttr getStaticTargetSgLayoutAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_sg_layout);
  }

  ::llvm::ArrayRef<int64_t> getStaticTargetSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticTargetSgDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_sg_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticTargetSgData();
  ::mlir::DenseI64ArrayAttr getStaticTargetInstDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_inst_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticTargetInstData();
  void setStaticInputSgLayoutAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_input_sg_layout = attr;
  }

  void setStaticInputSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticInputSgDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_input_sg_data = attr;
  }

  void setStaticInputSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticInputInstDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_input_inst_data = attr;
  }

  void setStaticInputInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticTargetSgLayoutAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_target_sg_layout = attr;
  }

  void setStaticTargetSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticTargetSgDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_target_sg_data = attr;
  }

  void setStaticTargetSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticTargetInstDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_target_inst_data = attr;
  }

  void setStaticTargetInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  ::mlir::Attribute removeStaticInputSgLayoutAttr() {
      auto attr = getProperties().static_input_sg_layout;
      getProperties().static_input_sg_layout = {};
      return attr;
  }

  ::mlir::Attribute removeStaticInputSgDataAttr() {
      auto attr = getProperties().static_input_sg_data;
      getProperties().static_input_sg_data = {};
      return attr;
  }

  ::mlir::Attribute removeStaticInputInstDataAttr() {
      auto attr = getProperties().static_input_inst_data;
      getProperties().static_input_inst_data = {};
      return attr;
  }

  ::mlir::Attribute removeStaticTargetSgLayoutAttr() {
      auto attr = getProperties().static_target_sg_layout;
      getProperties().static_target_sg_layout = {};
      return attr;
  }

  ::mlir::Attribute removeStaticTargetSgDataAttr() {
      auto attr = getProperties().static_target_sg_data;
      getProperties().static_target_sg_data = {};
      return attr;
  }

  ::mlir::Attribute removeStaticTargetInstDataAttr() {
      auto attr = getProperties().static_target_inst_data;
      getProperties().static_target_inst_data = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value target, ArrayRef<OpFoldResult> mixedInputSgLayout, ArrayRef<OpFoldResult> mixedInputSgData, ArrayRef<OpFoldResult> mixedInputInstData, ArrayRef<OpFoldResult> mixedTargetSgLayout, ArrayRef<OpFoldResult> mixedTargetSgData, ArrayRef<OpFoldResult> mixedTargetInstData);
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedInputSgLayout, ArrayRef<OpFoldResult> mixedInputSgData, ArrayRef<OpFoldResult> mixedInputInstData, ArrayRef<OpFoldResult> mixedTargetSgLayout, ArrayRef<OpFoldResult> mixedTargetSgData, ArrayRef<OpFoldResult> mixedTargetInstData);
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedInputSgLayout, ArrayRef<OpFoldResult> mixedInputSgData, ArrayRef<OpFoldResult> mixedInputInstData, ArrayRef<OpFoldResult> mixedTargetSgLayout, ArrayRef<OpFoldResult> mixedTargetSgData, ArrayRef<OpFoldResult> mixedTargetInstData);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::DiagnosedSilenceableFailure apply(
      ::mlir::transform::TransformRewriter &rewriter,
      ::mlir::transform::TransformResults &transformResults,
      ::mlir::transform::TransformState &state);

  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedInputSgLayout() {
    Builder b(getContext());
    return getMixedValues(getStaticInputSgLayout(), getInputSgLayout(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedInputSgData() {
    Builder b(getContext());
    return getMixedValues(getStaticInputSgData(), getInputSgData(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedInputInstData() {
    Builder b(getContext());
    return getMixedValues(getStaticInputInstData(), getInputInstData(), b);
  }

  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedTargetSgLayout() {
    Builder b(getContext());
    return getMixedValues(getStaticTargetSgLayout(), getTargetSgLayout(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedTargetSgData() {
    Builder b(getContext());
    return getMixedValues(getStaticTargetSgData(), getTargetSgData(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedTargetInstData() {
    Builder b(getContext());
    return getMixedValues(getStaticTargetInstData(), getTargetInstData(), b);
  }
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::ConvertLayoutOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::GetDescOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GetDescOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GetDescOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.get_desc_op", odsAttrs.getContext());
  }

  GetDescOpGenericAdaptorBase(GetDescOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class GetDescOpGenericAdaptor : public detail::GetDescOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GetDescOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
public:
  GetDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GetDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GetDescOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GetDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GetDescOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GetDescOpGenericAdaptor(RangeT values, const GetDescOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GetDescOp, typename = std::enable_if_t<std::is_same_v<LateInst, GetDescOp>>>
  GetDescOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GetDescOpAdaptor : public GetDescOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GetDescOpGenericAdaptor::GetDescOpGenericAdaptor;
  GetDescOpAdaptor(GetDescOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GetDescOp : public ::mlir::Op<GetDescOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformHandleTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::transform::TransformOpInterface::Trait, ::mlir::transform::NavigationTransformOpTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GetDescOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GetDescOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::TransformOpInterface::Trait<GetDescOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.get_desc_op");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getDescHandle() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type descHandle, ::mlir::Value target);
  static GetDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type descHandle, ::mlir::Value target);
  static GetDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type descHandle, ::mlir::Value target);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static GetDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static GetDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GetDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GetDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::GetDescOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::InsertPrefetchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InsertPrefetchOpGenericAdaptorBase {
public:
  struct Properties {
    using static_nb_prefetchTy = ::mlir::IntegerAttr;
    static_nb_prefetchTy static_nb_prefetch;

    auto getStaticNbPrefetch() const {
      auto &propStorage = this->static_nb_prefetch;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setStaticNbPrefetch(const ::mlir::IntegerAttr &propValue) {
      this->static_nb_prefetch = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.static_nb_prefetch == this->static_nb_prefetch &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertPrefetchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.insert_prefetch", odsAttrs.getContext());
  }

  InsertPrefetchOpGenericAdaptorBase(InsertPrefetchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getStaticNbPrefetchAttr();
  uint64_t getStaticNbPrefetch();
};

} // namespace detail
template <typename RangeT>
class InsertPrefetchOpGenericAdaptor : public detail::InsertPrefetchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertPrefetchOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_dynamic_nb_prefetch = 1;
public:
  InsertPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertPrefetchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertPrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertPrefetchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertPrefetchOpGenericAdaptor(RangeT values, const InsertPrefetchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertPrefetchOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertPrefetchOp>>>
  InsertPrefetchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDynamicNbPrefetch() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertPrefetchOpAdaptor : public InsertPrefetchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertPrefetchOpGenericAdaptor::InsertPrefetchOpGenericAdaptor;
  InsertPrefetchOpAdaptor(InsertPrefetchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertPrefetchOp : public ::mlir::Op<InsertPrefetchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformHandleTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertPrefetchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertPrefetchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_dynamic_nb_prefetch = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("static_nb_prefetch")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getStaticNbPrefetchAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getStaticNbPrefetchAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.insert_prefetch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDynamicNbPrefetch() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDynamicNbPrefetchMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getDescOp() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getStaticNbPrefetchAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().static_nb_prefetch);
  }

  uint64_t getStaticNbPrefetch();
  void setStaticNbPrefetchAttr(::mlir::IntegerAttr attr) {
    getProperties().static_nb_prefetch = attr;
  }

  void setStaticNbPrefetch(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeStaticNbPrefetchAttr() {
      auto attr = getProperties().static_nb_prefetch;
      getProperties().static_nb_prefetch = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch = 1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertPrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertPrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::DiagnosedSilenceableFailure apply(
      ::mlir::transform::TransformRewriter &rewriter,
      ::mlir::transform::TransformResults &transformResults,
      ::mlir::transform::TransformState &state);

  OpFoldResult getNbPrefetch() {
    auto cxt = getContext();
    if (getDynamicNbPrefetch())
      return OpFoldResult(getDynamicNbPrefetch());
    return OpFoldResult(IntegerAttr::get(
                        IntegerType::get(cxt, 64), getStaticNbPrefetch()));
  }
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::InsertPrefetchOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetDescLayoutOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SetDescLayoutOpGenericAdaptorBase {
public:
  struct Properties {
    using slice_dimsTy = ::mlir::DenseI64ArrayAttr;
    slice_dimsTy slice_dims;

    auto getSliceDims() const {
      auto &propStorage = this->slice_dims;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSliceDims(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->slice_dims = propValue;
    }
    using static_inst_dataTy = ::mlir::DenseI64ArrayAttr;
    static_inst_dataTy static_inst_data;

    auto getStaticInstData() const {
      auto &propStorage = this->static_inst_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticInstData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_inst_data = propValue;
    }
    using static_sg_dataTy = ::mlir::DenseI64ArrayAttr;
    static_sg_dataTy static_sg_data;

    auto getStaticSgData() const {
      auto &propStorage = this->static_sg_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticSgData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_sg_data = propValue;
    }
    using static_sg_layoutTy = ::mlir::DenseI64ArrayAttr;
    static_sg_layoutTy static_sg_layout;

    auto getStaticSgLayout() const {
      auto &propStorage = this->static_sg_layout;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticSgLayout(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_sg_layout = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.slice_dims == this->slice_dims &&
        rhs.static_inst_data == this->static_inst_data &&
        rhs.static_sg_data == this->static_sg_data &&
        rhs.static_sg_layout == this->static_sg_layout &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SetDescLayoutOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.set_desc_layout", odsAttrs.getContext());
  }

  SetDescLayoutOpGenericAdaptorBase(SetDescLayoutOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getStaticSgLayoutAttr();
  ::llvm::ArrayRef<int64_t> getStaticSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticSgDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticSgData();
  ::mlir::DenseI64ArrayAttr getStaticInstDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticInstData();
  ::mlir::DenseI64ArrayAttr getSliceDimsAttr();
  ::llvm::ArrayRef<int64_t> getSliceDims();
};

} // namespace detail
template <typename RangeT>
class SetDescLayoutOpGenericAdaptor : public detail::SetDescLayoutOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SetDescLayoutOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_sg_layout = 1;
  static constexpr int odsIndex_sg_data = 2;
  static constexpr int odsIndex_inst_data = 3;
public:
  SetDescLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SetDescLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SetDescLayoutOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SetDescLayoutOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : SetDescLayoutOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SetDescLayoutOpGenericAdaptor(RangeT values, const SetDescLayoutOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SetDescLayoutOp, typename = std::enable_if_t<std::is_same_v<LateInst, SetDescLayoutOp>>>
  SetDescLayoutOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getSgLayout() {
    return getODSOperands(1);
  }

  RangeT getSgData() {
    return getODSOperands(2);
  }

  RangeT getInstData() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SetDescLayoutOpAdaptor : public SetDescLayoutOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SetDescLayoutOpGenericAdaptor::SetDescLayoutOpGenericAdaptor;
  SetDescLayoutOpAdaptor(SetDescLayoutOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SetDescLayoutOp : public ::mlir::Op<SetDescLayoutOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformHandleTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SetDescLayoutOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SetDescLayoutOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_sg_layout = 1;
  static constexpr int odsIndex_sg_data = 2;
  static constexpr int odsIndex_inst_data = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("slice_dims"), ::llvm::StringRef("static_inst_data"), ::llvm::StringRef("static_sg_data"), ::llvm::StringRef("static_sg_layout"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSliceDimsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSliceDimsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getStaticInstDataAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getStaticInstDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getStaticSgDataAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getStaticSgDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStaticSgLayoutAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStaticSgLayoutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.set_desc_layout");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getSgLayout() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getSgData() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getInstData() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSgLayoutMutable();
  ::mlir::MutableOperandRange getSgDataMutable();
  ::mlir::MutableOperandRange getInstDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTransformed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getStaticSgLayoutAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_layout);
  }

  ::llvm::ArrayRef<int64_t> getStaticSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticSgDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticSgData();
  ::mlir::DenseI64ArrayAttr getStaticInstDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_inst_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticInstData();
  ::mlir::DenseI64ArrayAttr getSliceDimsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().slice_dims);
  }

  ::llvm::ArrayRef<int64_t> getSliceDims();
  void setStaticSgLayoutAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_sg_layout = attr;
  }

  void setStaticSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticSgDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_sg_data = attr;
  }

  void setStaticSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticInstDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_inst_data = attr;
  }

  void setStaticInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setSliceDimsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().slice_dims = attr;
  }

  void setSliceDims(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  ::mlir::Attribute removeStaticSgLayoutAttr() {
      auto attr = getProperties().static_sg_layout;
      getProperties().static_sg_layout = {};
      return attr;
  }

  ::mlir::Attribute removeStaticSgDataAttr() {
      auto attr = getProperties().static_sg_data;
      getProperties().static_sg_data = {};
      return attr;
  }

  ::mlir::Attribute removeStaticInstDataAttr() {
      auto attr = getProperties().static_inst_data;
      getProperties().static_inst_data = {};
      return attr;
  }

  ::mlir::Attribute removeSliceDimsAttr() {
      auto attr = getProperties().slice_dims;
      getProperties().slice_dims = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value target, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims);
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims);
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetDescLayoutOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetDescLayoutOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::DiagnosedSilenceableFailure apply(
      ::mlir::transform::TransformRewriter &rewriter,
      ::mlir::transform::TransformResults &transformResults,
      ::mlir::transform::TransformState &state);

  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedSgLayout() {
    Builder b(getContext());
    return getMixedValues(getStaticSgLayout(), getSgLayout(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedSgData() {
    Builder b(getContext());
    return getMixedValues(getStaticSgData(), getSgData(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedInstData() {
    Builder b(getContext());
    return getMixedValues(getStaticInstData(), getInstData(), b);
  }
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::SetDescLayoutOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetGPULaunchThreadsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SetGPULaunchThreadsOpGenericAdaptorBase {
public:
  struct Properties {
    using static_threadsTy = ::mlir::DenseI64ArrayAttr;
    static_threadsTy static_threads;

    auto getStaticThreads() const {
      auto &propStorage = this->static_threads;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticThreads(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_threads = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.static_threads == this->static_threads &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SetGPULaunchThreadsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.set_gpu_launch_threads", odsAttrs.getContext());
  }

  SetGPULaunchThreadsOpGenericAdaptorBase(SetGPULaunchThreadsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI64ArrayAttr getStaticThreadsAttr();
  ::llvm::ArrayRef<int64_t> getStaticThreads();
};

} // namespace detail
template <typename RangeT>
class SetGPULaunchThreadsOpGenericAdaptor : public detail::SetGPULaunchThreadsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SetGPULaunchThreadsOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_threads = 1;
public:
  SetGPULaunchThreadsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SetGPULaunchThreadsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SetGPULaunchThreadsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SetGPULaunchThreadsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : SetGPULaunchThreadsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SetGPULaunchThreadsOpGenericAdaptor(RangeT values, const SetGPULaunchThreadsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SetGPULaunchThreadsOp, typename = std::enable_if_t<std::is_same_v<LateInst, SetGPULaunchThreadsOp>>>
  SetGPULaunchThreadsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getThreads() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SetGPULaunchThreadsOpAdaptor : public SetGPULaunchThreadsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SetGPULaunchThreadsOpGenericAdaptor::SetGPULaunchThreadsOpGenericAdaptor;
  SetGPULaunchThreadsOpAdaptor(SetGPULaunchThreadsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SetGPULaunchThreadsOp : public ::mlir::Op<SetGPULaunchThreadsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SetGPULaunchThreadsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SetGPULaunchThreadsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_threads = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("static_threads")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getStaticThreadsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getStaticThreadsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.set_gpu_launch_threads");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getThreads() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getThreadsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI64ArrayAttr getStaticThreadsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_threads);
  }

  ::llvm::ArrayRef<int64_t> getStaticThreads();
  void setStaticThreadsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_threads = attr;
  }

  void setStaticThreads(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  ::mlir::Attribute removeStaticThreadsAttr() {
      auto attr = getProperties().static_threads;
      getProperties().static_threads = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value target, ArrayRef<OpFoldResult> mixedThreads);
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedThreads);
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedThreads);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetGPULaunchThreadsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetGPULaunchThreadsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::DiagnosedSilenceableFailure apply(
      ::mlir::transform::TransformRewriter &rewriter,
      ::mlir::transform::TransformResults &transformResults,
      ::mlir::transform::TransformState &state);

  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedThreads() {
    Builder b(getContext());
    return getMixedValues(getStaticThreads(), getThreads(), b);
  }
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::SetGPULaunchThreadsOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetOpLayoutAttrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class SetOpLayoutAttrOpGenericAdaptorBase {
public:
  struct Properties {
    using indexTy = ::mlir::IntegerAttr;
    indexTy index;

    auto getIndex() const {
      auto &propStorage = this->index;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setIndex(const ::mlir::IntegerAttr &propValue) {
      this->index = propValue;
    }
    using resultTy = ::mlir::UnitAttr;
    resultTy result;

    auto getResult() const {
      auto &propStorage = this->result;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setResult(const ::mlir::UnitAttr &propValue) {
      this->result = propValue;
    }
    using slice_dimsTy = ::mlir::DenseI64ArrayAttr;
    slice_dimsTy slice_dims;

    auto getSliceDims() const {
      auto &propStorage = this->slice_dims;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setSliceDims(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->slice_dims = propValue;
    }
    using static_inst_dataTy = ::mlir::DenseI64ArrayAttr;
    static_inst_dataTy static_inst_data;

    auto getStaticInstData() const {
      auto &propStorage = this->static_inst_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticInstData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_inst_data = propValue;
    }
    using static_sg_dataTy = ::mlir::DenseI64ArrayAttr;
    static_sg_dataTy static_sg_data;

    auto getStaticSgData() const {
      auto &propStorage = this->static_sg_data;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticSgData(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_sg_data = propValue;
    }
    using static_sg_layoutTy = ::mlir::DenseI64ArrayAttr;
    static_sg_layoutTy static_sg_layout;

    auto getStaticSgLayout() const {
      auto &propStorage = this->static_sg_layout;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setStaticSgLayout(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->static_sg_layout = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.index == this->index &&
        rhs.result == this->result &&
        rhs.slice_dims == this->slice_dims &&
        rhs.static_inst_data == this->static_inst_data &&
        rhs.static_sg_data == this->static_sg_data &&
        rhs.static_sg_layout == this->static_sg_layout &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  SetOpLayoutAttrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.xegpu.set_op_layout_attr", odsAttrs.getContext());
  }

  SetOpLayoutAttrOpGenericAdaptorBase(SetOpLayoutAttrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIndexAttr();
  uint64_t getIndex();
  ::mlir::DenseI64ArrayAttr getStaticSgLayoutAttr();
  ::llvm::ArrayRef<int64_t> getStaticSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticSgDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticSgData();
  ::mlir::DenseI64ArrayAttr getStaticInstDataAttr();
  ::llvm::ArrayRef<int64_t> getStaticInstData();
  ::mlir::DenseI64ArrayAttr getSliceDimsAttr();
  ::llvm::ArrayRef<int64_t> getSliceDims();
  ::mlir::UnitAttr getResultAttr();
  bool getResult();
};

} // namespace detail
template <typename RangeT>
class SetOpLayoutAttrOpGenericAdaptor : public detail::SetOpLayoutAttrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::SetOpLayoutAttrOpGenericAdaptorBase;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_sg_layout = 1;
  static constexpr int odsIndex_sg_data = 2;
  static constexpr int odsIndex_inst_data = 3;
public:
  SetOpLayoutAttrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  SetOpLayoutAttrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : SetOpLayoutAttrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  SetOpLayoutAttrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : SetOpLayoutAttrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  SetOpLayoutAttrOpGenericAdaptor(RangeT values, const SetOpLayoutAttrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = SetOpLayoutAttrOp, typename = std::enable_if_t<std::is_same_v<LateInst, SetOpLayoutAttrOp>>>
  SetOpLayoutAttrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTarget() {
    return (*getODSOperands(0).begin());
  }

  RangeT getSgLayout() {
    return getODSOperands(1);
  }

  RangeT getSgData() {
    return getODSOperands(2);
  }

  RangeT getInstData() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class SetOpLayoutAttrOpAdaptor : public SetOpLayoutAttrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using SetOpLayoutAttrOpGenericAdaptor::SetOpLayoutAttrOpGenericAdaptor;
  SetOpLayoutAttrOpAdaptor(SetOpLayoutAttrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class SetOpLayoutAttrOp : public ::mlir::Op<SetOpLayoutAttrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = SetOpLayoutAttrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = SetOpLayoutAttrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_target = 0;
  static constexpr int odsIndex_sg_layout = 1;
  static constexpr int odsIndex_sg_data = 2;
  static constexpr int odsIndex_inst_data = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("index"), ::llvm::StringRef("result"), ::llvm::StringRef("slice_dims"), ::llvm::StringRef("static_inst_data"), ::llvm::StringRef("static_sg_data"), ::llvm::StringRef("static_sg_layout"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getResultAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getResultAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSliceDimsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSliceDimsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStaticInstDataAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStaticInstDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStaticSgDataAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStaticSgDataAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getStaticSgLayoutAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getStaticSgLayoutAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.xegpu.set_op_layout_attr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTarget() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getSgLayout() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getSgData() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getInstData() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getTargetMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSgLayoutMutable();
  ::mlir::MutableOperandRange getSgDataMutable();
  ::mlir::MutableOperandRange getInstDataMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIndexAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().index);
  }

  uint64_t getIndex();
  ::mlir::DenseI64ArrayAttr getStaticSgLayoutAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_layout);
  }

  ::llvm::ArrayRef<int64_t> getStaticSgLayout();
  ::mlir::DenseI64ArrayAttr getStaticSgDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticSgData();
  ::mlir::DenseI64ArrayAttr getStaticInstDataAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_inst_data);
  }

  ::llvm::ArrayRef<int64_t> getStaticInstData();
  ::mlir::DenseI64ArrayAttr getSliceDimsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().slice_dims);
  }

  ::llvm::ArrayRef<int64_t> getSliceDims();
  ::mlir::UnitAttr getResultAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().result);
  }

  bool getResult();
  void setIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().index = attr;
  }

  void setIndex(::std::optional<uint64_t> attrValue);
  void setStaticSgLayoutAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_sg_layout = attr;
  }

  void setStaticSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticSgDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_sg_data = attr;
  }

  void setStaticSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setStaticInstDataAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().static_inst_data = attr;
  }

  void setStaticInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setSliceDimsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().slice_dims = attr;
  }

  void setSliceDims(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setResultAttr(::mlir::UnitAttr attr) {
    getProperties().result = attr;
  }

  void setResult(bool attrValue);
  ::mlir::Attribute removeIndexAttr() {
      auto attr = getProperties().index;
      getProperties().index = {};
      return attr;
  }

  ::mlir::Attribute removeStaticSgLayoutAttr() {
      auto attr = getProperties().static_sg_layout;
      getProperties().static_sg_layout = {};
      return attr;
  }

  ::mlir::Attribute removeStaticSgDataAttr() {
      auto attr = getProperties().static_sg_data;
      getProperties().static_sg_data = {};
      return attr;
  }

  ::mlir::Attribute removeStaticInstDataAttr() {
      auto attr = getProperties().static_inst_data;
      getProperties().static_inst_data = {};
      return attr;
  }

  ::mlir::Attribute removeSliceDimsAttr() {
      auto attr = getProperties().slice_dims;
      getProperties().slice_dims = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value target, int64_t index, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, int64_t index, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, Value target, int64_t index, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims, bool result = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data = nullptr, /*optional*/::mlir::DenseI64ArrayAttr slice_dims = nullptr, ::mlir::UnitAttr result = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout = {}, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data = {}, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data = {}, /*optional*/::llvm::ArrayRef<int64_t> slice_dims = {}, bool result = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetOpLayoutAttrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static SetOpLayoutAttrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::DiagnosedSilenceableFailure apply(
      ::mlir::transform::TransformRewriter &rewriter,
      ::mlir::transform::TransformResults &transformResults,
      ::mlir::transform::TransformState &state);

  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedSgLayout() {
    Builder b(getContext());
    return getMixedValues(getStaticSgLayout(), getSgLayout(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedSgData() {
    Builder b(getContext());
    return getMixedValues(getStaticSgData(), getSgData(), b);
  }
  ::llvm::SmallVector<::mlir::OpFoldResult> getMixedInstData() {
    Builder b(getContext());
    return getMixedValues(getStaticInstData(), getInstData(), b);
  }
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::SetOpLayoutAttrOp)


#endif // GET_OP_CLASSES

