# @generated by usage-cli from usage spec

# if "usage" is not installed show an error
if ! type -p usage &> /dev/null
    echo >&2
    echo "Error: usage CLI not found. This is required for completions to work in mise." >&2
    echo "See https://usage.jdx.dev for more information." >&2
    return 1
end
set -l tmpdir (if set -q TMPDIR; echo $TMPDIR; else; echo /tmp; end)
set -l spec_file "$tmpdir/usage__usage_spec_mise_2025_10_10.spec"
if not test -f "$spec_file"
    mise usage | string collect > "$spec_file"
end

set -l tokens
if commandline -x >/dev/null 2>&1
    complete -xc mise -a "(command usage complete-word --shell fish -f \"$spec_file\" -- (commandline -xpc) (commandline -t))"
else
    complete -xc mise -a "(command usage complete-word --shell fish -f \"$spec_file\" -- (commandline -opc) (commandline -t))"
end
