import { NS, ATTRIBUTES, NamespaceURI, NodeType } from './constants.ts';
import { ParentNode } from './ParentNode.ts';
import { NamedNodeMap } from './NamedNodeMap.ts';
export declare class Element extends ParentNode {
    static readonly observedAttributes?: string[];
    nodeType: NodeType;
    [NS]: NamespaceURI;
    get namespaceURI(): NamespaceURI;
    get tagName(): string;
    [ATTRIBUTES]: NamedNodeMap;
    [anyProperty: string]: any;
    get slot(): string;
    set slot(slot: string);
    get attributes(): NamedNodeMap;
    getAttributeNames(): string[];
    get firstElementChild(): any;
    get lastElementChild(): any;
    get nextElementSibling(): import("./Node.ts").Node | null;
    get previousElementSibling(): import("./Node.ts").Node | null;
    setAttribute(name: string, value: string): void;
    setAttributeNS(namespace: NamespaceURI | null, name: string, value: string): void;
    getAttribute(name: string): string | null;
    getAttributeNS(namespace: NamespaceURI | null, name: string): string | null;
    hasAttribute(name: string): boolean;
    hasAttributeNS(namespace: NamespaceURI | null, name: string): boolean;
    removeAttribute(name: string): void;
    removeAttributeNS(namespace: NamespaceURI | null, name: string): void;
    get outerHTML(): string;
    get innerHTML(): any;
    set innerHTML(html: any);
}
//# sourceMappingURL=Element.d.ts.map