import type { AnyThread, ThreadSerialization, ThreadSerializationOptions } from '../Thread.ts';
/**
 * A thread encoder that can transfer supports a wide variety of JavaScript types by
 * converting them to a format that the [`structuredClone`](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Structured_clone_algorithm)
 * algorithm can process. This
 *
 * Additionally, this encoder will convert functions into a JSON-friendly representation.
 * These functions will use a manual memory management technique to ensure they can be
 * garbage collected by default, but can be configured to use a `WeakRef`-based automatic
 * memory management system by setting the `garbageCollection: 'weak-ref'` option.
 */
export declare class ThreadSerializationStructuredClone implements ThreadSerialization {
    #private;
    constructor(options?: ThreadSerializationOptions);
    /**
     * Serializes a value into a structured cloning-compatible format that can be transferred between threads.
     */
    serialize(value: unknown, thread: AnyThread, transferable?: any[]): any;
    /**
     * Deserializes a structured cloning-compatible value from another thread.
     */
    deserialize(value: unknown, thread: AnyThread): any;
}
//# sourceMappingURL=ThreadSerializationStructuredClone.d.ts.map