function isIterator(value) {
  return value != null && (Symbol.asyncIterator in value || Symbol.iterator in value) && typeof value.next === 'function';
}
function isBasicObject(value) {
  if (value == null || typeof value !== 'object') return false;
  const prototype = Object.getPrototypeOf(value);
  return prototype == null || prototype === Object.prototype;
}

export { isBasicObject, isIterator };
