'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');

/**
 * A helper for creating a `RemoteConnection` object. The `RemoteConnection`
 * protocol is pretty low-level; this function provides more human-friendly
 * naming on top of the protocol.
 */
function createRemoteConnection({
  call,
  insertChild,
  removeChild,
  updateText,
  updateProperty
}) {
  const handlers = {
    [constants.MUTATION_TYPE_INSERT_CHILD]: insertChild,
    [constants.MUTATION_TYPE_REMOVE_CHILD]: removeChild,
    [constants.MUTATION_TYPE_UPDATE_TEXT]: updateText,
    [constants.MUTATION_TYPE_UPDATE_PROPERTY]: updateProperty
  };
  return {
    call,
    mutate(records) {
      for (const [type, ...args] of records) {
        handlers[type](...args);
      }
    }
  };
}

exports.createRemoteConnection = createRemoteConnection;
