/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli.extensions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.cli.extensions.InputLocation;
import org.apache.maven.api.cli.extensions.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CoreExtension
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String classLoadingStrategy;
    final XmlNode configuration;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected CoreExtension(Builder builder) {
        String string = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        String string2 = builder.artifactId != null ? builder.artifactId : (this.artifactId = builder.base != null ? builder.base.artifactId : null);
        String string3 = builder.version != null ? builder.version : (this.version = builder.base != null ? builder.base.version : null);
        String string4 = builder.classLoadingStrategy != null ? builder.classLoadingStrategy : (this.classLoadingStrategy = builder.base != null ? builder.base.classLoadingStrategy : null);
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassLoadingStrategy() {
        return this.classLoadingStrategy;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return CoreExtension.newBuilder(this);
    }

    @Nonnull
    public CoreExtension withGroupId(String groupId) {
        return CoreExtension.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public CoreExtension withArtifactId(String artifactId) {
        return CoreExtension.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public CoreExtension withVersion(String version) {
        return CoreExtension.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public CoreExtension withClassLoadingStrategy(String classLoadingStrategy) {
        return CoreExtension.newBuilder(this, true).classLoadingStrategy(classLoadingStrategy).build();
    }

    @Nonnull
    public CoreExtension withConfiguration(XmlNode configuration) {
        return CoreExtension.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static CoreExtension newInstance() {
        return CoreExtension.newInstance(true);
    }

    @Nonnull
    public static CoreExtension newInstance(boolean withDefaults) {
        return CoreExtension.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CoreExtension.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtension from) {
        return CoreExtension.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CoreExtension from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String getId() {
        return (this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId()) + ":" + (this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId()) + ":" + (this.getVersion() == null ? "[unknown-version]" : this.getVersion());
    }

    @NotThreadSafe
    public static class Builder {
        CoreExtension base;
        String groupId;
        String artifactId;
        String version;
        String classLoadingStrategy;
        XmlNode configuration;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.classLoadingStrategy = "self-first";
            }
        }

        protected Builder(CoreExtension base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.classLoadingStrategy = base.classLoadingStrategy;
                this.configuration = base.configuration;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder classLoadingStrategy(String classLoadingStrategy) {
            this.classLoadingStrategy = classLoadingStrategy;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public CoreExtension build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.classLoadingStrategy != null && this.classLoadingStrategy != this.base.classLoadingStrategy || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new CoreExtension(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

