/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.wagon;

import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.wagon.WagonConfigurator;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named
@Component(role=RepositoryConnectorFactory.class, hint="wagon")
public final class WagonRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private WagonProvider wagonProvider;
    @Requirement
    private WagonConfigurator wagonConfigurator;
    private float priority;

    public WagonRepositoryConnectorFactory() {
    }

    @Inject
    WagonRepositoryConnectorFactory(FileProcessor fileProcessor, WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setWagonProvider(wagonProvider);
        this.setWagonConfigurator(wagonConfigurator);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
        this.setWagonProvider((WagonProvider)locator.getService(WagonProvider.class));
        this.setWagonConfigurator((WagonConfigurator)locator.getService(WagonConfigurator.class));
    }

    public WagonRepositoryConnectorFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, WagonRepositoryConnector.class);
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public WagonRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public WagonRepositoryConnectorFactory setWagonProvider(WagonProvider wagonProvider) {
        this.wagonProvider = wagonProvider;
        return this;
    }

    public WagonRepositoryConnectorFactory setWagonConfigurator(WagonConfigurator wagonConfigurator) {
        this.wagonConfigurator = wagonConfigurator;
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public WagonRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new WagonRepositoryConnector(this.wagonProvider, this.wagonConfigurator, repository, session, this.fileProcessor, this.logger);
    }
}

