/* This file is part of HSPlasma.
 *
 * HSPlasma is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * HSPlasma is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HSPlasma.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _PLMESSAGEWITHCALLBACKS_H
#define _PLMESSAGEWITHCALLBACKS_H

#include "plMessage.h"

class HSPLASMA_EXPORT plMessageWithCallbacks : public plMessage
{
    CREATABLE(plMessageWithCallbacks, kMessageWithCallbacks, plMessage)

protected:
    std::vector<plMessage*> fCallbacks;

public:
    plMessageWithCallbacks() { }
    ~plMessageWithCallbacks();

    void read(hsStream* S, plResManager* mgr) HS_OVERRIDE;
    void write(hsStream* S, plResManager* mgr) HS_OVERRIDE;

protected:
    void IPrcWrite(pfPrcHelper* prc) HS_OVERRIDE;
    void IPrcParse(const pfPrcTag* tag, plResManager* mgr) HS_OVERRIDE;

public:
    const std::vector<plMessage*>& getCallbacks() const { return fCallbacks; }
    std::vector<plMessage*>& getCallbacks() { return fCallbacks; }
    void addCallback(plMessage* callback) { fCallbacks.push_back(callback); }
    void delCallback(size_t idx);
    void clearCallbacks();
};

#endif
