/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_38_H
#define LEXBOR_UNICODE_TABLES_38_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F800 = {.cps = (lxb_codepoint_t[]) {0x4E3D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F801 = {.cps = (lxb_codepoint_t[]) {0x4E38}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F802 = {.cps = (lxb_codepoint_t[]) {0x4E41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F803 = {.cps = (lxb_codepoint_t[]) {0x20122}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F804 = {.cps = (lxb_codepoint_t[]) {0x4F60}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F805 = {.cps = (lxb_codepoint_t[]) {0x4FAE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F806 = {.cps = (lxb_codepoint_t[]) {0x4FBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F807 = {.cps = (lxb_codepoint_t[]) {0x5002}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F808 = {.cps = (lxb_codepoint_t[]) {0x507A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F809 = {.cps = (lxb_codepoint_t[]) {0x5099}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80A = {.cps = (lxb_codepoint_t[]) {0x50E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80B = {.cps = (lxb_codepoint_t[]) {0x50CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80C = {.cps = (lxb_codepoint_t[]) {0x349E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80D = {.cps = (lxb_codepoint_t[]) {0x2063A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80E = {.cps = (lxb_codepoint_t[]) {0x514D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80F = {.cps = (lxb_codepoint_t[]) {0x5154}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F810 = {.cps = (lxb_codepoint_t[]) {0x5164}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F811 = {.cps = (lxb_codepoint_t[]) {0x5177}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F812 = {.cps = (lxb_codepoint_t[]) {0x2051C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F813 = {.cps = (lxb_codepoint_t[]) {0x34B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F814 = {.cps = (lxb_codepoint_t[]) {0x5167}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F815 = {.cps = (lxb_codepoint_t[]) {0x518D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F816 = {.cps = (lxb_codepoint_t[]) {0x2054B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F817 = {.cps = (lxb_codepoint_t[]) {0x5197}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F818 = {.cps = (lxb_codepoint_t[]) {0x51A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F819 = {.cps = (lxb_codepoint_t[]) {0x4ECC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81A = {.cps = (lxb_codepoint_t[]) {0x51AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81B = {.cps = (lxb_codepoint_t[]) {0x51B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81C = {.cps = (lxb_codepoint_t[]) {0x291DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81D = {.cps = (lxb_codepoint_t[]) {0x51F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81E = {.cps = (lxb_codepoint_t[]) {0x5203}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81F = {.cps = (lxb_codepoint_t[]) {0x34DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F820 = {.cps = (lxb_codepoint_t[]) {0x523B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F821 = {.cps = (lxb_codepoint_t[]) {0x5246}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F822 = {.cps = (lxb_codepoint_t[]) {0x5272}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F823 = {.cps = (lxb_codepoint_t[]) {0x5277}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F824 = {.cps = (lxb_codepoint_t[]) {0x3515}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F825 = {.cps = (lxb_codepoint_t[]) {0x52C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F826 = {.cps = (lxb_codepoint_t[]) {0x52C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F827 = {.cps = (lxb_codepoint_t[]) {0x52E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F828 = {.cps = (lxb_codepoint_t[]) {0x52FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F829 = {.cps = (lxb_codepoint_t[]) {0x5305}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82A = {.cps = (lxb_codepoint_t[]) {0x5306}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82B = {.cps = (lxb_codepoint_t[]) {0x5317}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82C = {.cps = (lxb_codepoint_t[]) {0x5349}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82D = {.cps = (lxb_codepoint_t[]) {0x5351}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82E = {.cps = (lxb_codepoint_t[]) {0x535A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82F = {.cps = (lxb_codepoint_t[]) {0x5373}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F830 = {.cps = (lxb_codepoint_t[]) {0x537D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F831 = {.cps = (lxb_codepoint_t[]) {0x537F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F832 = {.cps = (lxb_codepoint_t[]) {0x537F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F833 = {.cps = (lxb_codepoint_t[]) {0x537F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F834 = {.cps = (lxb_codepoint_t[]) {0x20A2C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F835 = {.cps = (lxb_codepoint_t[]) {0x7070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F836 = {.cps = (lxb_codepoint_t[]) {0x53CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F837 = {.cps = (lxb_codepoint_t[]) {0x53DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F838 = {.cps = (lxb_codepoint_t[]) {0x20B63}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F839 = {.cps = (lxb_codepoint_t[]) {0x53EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83A = {.cps = (lxb_codepoint_t[]) {0x53F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83B = {.cps = (lxb_codepoint_t[]) {0x5406}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83C = {.cps = (lxb_codepoint_t[]) {0x549E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83D = {.cps = (lxb_codepoint_t[]) {0x5438}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83E = {.cps = (lxb_codepoint_t[]) {0x5448}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83F = {.cps = (lxb_codepoint_t[]) {0x5468}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F840 = {.cps = (lxb_codepoint_t[]) {0x54A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F841 = {.cps = (lxb_codepoint_t[]) {0x54F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F842 = {.cps = (lxb_codepoint_t[]) {0x5510}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F843 = {.cps = (lxb_codepoint_t[]) {0x5553}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F844 = {.cps = (lxb_codepoint_t[]) {0x5563}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F845 = {.cps = (lxb_codepoint_t[]) {0x5584}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F846 = {.cps = (lxb_codepoint_t[]) {0x5584}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F847 = {.cps = (lxb_codepoint_t[]) {0x5599}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F848 = {.cps = (lxb_codepoint_t[]) {0x55AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F849 = {.cps = (lxb_codepoint_t[]) {0x55B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84A = {.cps = (lxb_codepoint_t[]) {0x55C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84B = {.cps = (lxb_codepoint_t[]) {0x5716}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84C = {.cps = (lxb_codepoint_t[]) {0x5606}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84D = {.cps = (lxb_codepoint_t[]) {0x5717}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84E = {.cps = (lxb_codepoint_t[]) {0x5651}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84F = {.cps = (lxb_codepoint_t[]) {0x5674}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F850 = {.cps = (lxb_codepoint_t[]) {0x5207}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F851 = {.cps = (lxb_codepoint_t[]) {0x58EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F852 = {.cps = (lxb_codepoint_t[]) {0x57CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F853 = {.cps = (lxb_codepoint_t[]) {0x57F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F854 = {.cps = (lxb_codepoint_t[]) {0x580D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F855 = {.cps = (lxb_codepoint_t[]) {0x578B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F856 = {.cps = (lxb_codepoint_t[]) {0x5832}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F857 = {.cps = (lxb_codepoint_t[]) {0x5831}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F858 = {.cps = (lxb_codepoint_t[]) {0x58AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F859 = {.cps = (lxb_codepoint_t[]) {0x214E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85A = {.cps = (lxb_codepoint_t[]) {0x58F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85B = {.cps = (lxb_codepoint_t[]) {0x58F7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85C = {.cps = (lxb_codepoint_t[]) {0x5906}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85D = {.cps = (lxb_codepoint_t[]) {0x591A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85E = {.cps = (lxb_codepoint_t[]) {0x5922}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85F = {.cps = (lxb_codepoint_t[]) {0x5962}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F860 = {.cps = (lxb_codepoint_t[]) {0x216A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F861 = {.cps = (lxb_codepoint_t[]) {0x216EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F862 = {.cps = (lxb_codepoint_t[]) {0x59EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F863 = {.cps = (lxb_codepoint_t[]) {0x5A1B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F864 = {.cps = (lxb_codepoint_t[]) {0x5A27}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F865 = {.cps = (lxb_codepoint_t[]) {0x59D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F866 = {.cps = (lxb_codepoint_t[]) {0x5A66}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F867 = {.cps = (lxb_codepoint_t[]) {0x36EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F869 = {.cps = (lxb_codepoint_t[]) {0x5B08}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86A = {.cps = (lxb_codepoint_t[]) {0x5B3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86B = {.cps = (lxb_codepoint_t[]) {0x5B3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86C = {.cps = (lxb_codepoint_t[]) {0x219C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86D = {.cps = (lxb_codepoint_t[]) {0x5BC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86E = {.cps = (lxb_codepoint_t[]) {0x5BD8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86F = {.cps = (lxb_codepoint_t[]) {0x5BE7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F870 = {.cps = (lxb_codepoint_t[]) {0x5BF3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F871 = {.cps = (lxb_codepoint_t[]) {0x21B18}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F872 = {.cps = (lxb_codepoint_t[]) {0x5BFF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F873 = {.cps = (lxb_codepoint_t[]) {0x5C06}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F875 = {.cps = (lxb_codepoint_t[]) {0x5C22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F876 = {.cps = (lxb_codepoint_t[]) {0x3781}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F877 = {.cps = (lxb_codepoint_t[]) {0x5C60}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F878 = {.cps = (lxb_codepoint_t[]) {0x5C6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F879 = {.cps = (lxb_codepoint_t[]) {0x5CC0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87A = {.cps = (lxb_codepoint_t[]) {0x5C8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87B = {.cps = (lxb_codepoint_t[]) {0x21DE4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87C = {.cps = (lxb_codepoint_t[]) {0x5D43}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87D = {.cps = (lxb_codepoint_t[]) {0x21DE6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87E = {.cps = (lxb_codepoint_t[]) {0x5D6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87F = {.cps = (lxb_codepoint_t[]) {0x5D6B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F880 = {.cps = (lxb_codepoint_t[]) {0x5D7C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F881 = {.cps = (lxb_codepoint_t[]) {0x5DE1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F882 = {.cps = (lxb_codepoint_t[]) {0x5DE2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F883 = {.cps = (lxb_codepoint_t[]) {0x382F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F884 = {.cps = (lxb_codepoint_t[]) {0x5DFD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F885 = {.cps = (lxb_codepoint_t[]) {0x5E28}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F886 = {.cps = (lxb_codepoint_t[]) {0x5E3D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F887 = {.cps = (lxb_codepoint_t[]) {0x5E69}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F888 = {.cps = (lxb_codepoint_t[]) {0x3862}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F889 = {.cps = (lxb_codepoint_t[]) {0x22183}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88A = {.cps = (lxb_codepoint_t[]) {0x387C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88B = {.cps = (lxb_codepoint_t[]) {0x5EB0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88C = {.cps = (lxb_codepoint_t[]) {0x5EB3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88D = {.cps = (lxb_codepoint_t[]) {0x5EB6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88E = {.cps = (lxb_codepoint_t[]) {0x5ECA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88F = {.cps = (lxb_codepoint_t[]) {0x2A392}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F890 = {.cps = (lxb_codepoint_t[]) {0x5EFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F891 = {.cps = (lxb_codepoint_t[]) {0x22331}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F892 = {.cps = (lxb_codepoint_t[]) {0x22331}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F893 = {.cps = (lxb_codepoint_t[]) {0x8201}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F894 = {.cps = (lxb_codepoint_t[]) {0x5F22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F895 = {.cps = (lxb_codepoint_t[]) {0x5F22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F896 = {.cps = (lxb_codepoint_t[]) {0x38C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F897 = {.cps = (lxb_codepoint_t[]) {0x232B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F898 = {.cps = (lxb_codepoint_t[]) {0x261DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F899 = {.cps = (lxb_codepoint_t[]) {0x5F62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89A = {.cps = (lxb_codepoint_t[]) {0x5F6B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89B = {.cps = (lxb_codepoint_t[]) {0x38E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89C = {.cps = (lxb_codepoint_t[]) {0x5F9A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89D = {.cps = (lxb_codepoint_t[]) {0x5FCD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89E = {.cps = (lxb_codepoint_t[]) {0x5FD7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89F = {.cps = (lxb_codepoint_t[]) {0x5FF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A0 = {.cps = (lxb_codepoint_t[]) {0x6081}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A1 = {.cps = (lxb_codepoint_t[]) {0x393A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A2 = {.cps = (lxb_codepoint_t[]) {0x391C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A3 = {.cps = (lxb_codepoint_t[]) {0x6094}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A4 = {.cps = (lxb_codepoint_t[]) {0x226D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A5 = {.cps = (lxb_codepoint_t[]) {0x60C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A6 = {.cps = (lxb_codepoint_t[]) {0x6148}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A7 = {.cps = (lxb_codepoint_t[]) {0x614C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A8 = {.cps = (lxb_codepoint_t[]) {0x614E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A9 = {.cps = (lxb_codepoint_t[]) {0x614C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AA = {.cps = (lxb_codepoint_t[]) {0x617A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AB = {.cps = (lxb_codepoint_t[]) {0x618E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AC = {.cps = (lxb_codepoint_t[]) {0x61B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AD = {.cps = (lxb_codepoint_t[]) {0x61A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AE = {.cps = (lxb_codepoint_t[]) {0x61AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8AF = {.cps = (lxb_codepoint_t[]) {0x61DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B0 = {.cps = (lxb_codepoint_t[]) {0x61F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B1 = {.cps = (lxb_codepoint_t[]) {0x61F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B2 = {.cps = (lxb_codepoint_t[]) {0x6210}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B3 = {.cps = (lxb_codepoint_t[]) {0x621B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B4 = {.cps = (lxb_codepoint_t[]) {0x625D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B5 = {.cps = (lxb_codepoint_t[]) {0x62B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B6 = {.cps = (lxb_codepoint_t[]) {0x62D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B7 = {.cps = (lxb_codepoint_t[]) {0x6350}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B8 = {.cps = (lxb_codepoint_t[]) {0x22B0C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B9 = {.cps = (lxb_codepoint_t[]) {0x633D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BA = {.cps = (lxb_codepoint_t[]) {0x62FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BB = {.cps = (lxb_codepoint_t[]) {0x6368}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BC = {.cps = (lxb_codepoint_t[]) {0x6383}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BD = {.cps = (lxb_codepoint_t[]) {0x63E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BE = {.cps = (lxb_codepoint_t[]) {0x22BF1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8BF = {.cps = (lxb_codepoint_t[]) {0x6422}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C0 = {.cps = (lxb_codepoint_t[]) {0x63C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C1 = {.cps = (lxb_codepoint_t[]) {0x63A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C2 = {.cps = (lxb_codepoint_t[]) {0x3A2E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C3 = {.cps = (lxb_codepoint_t[]) {0x6469}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C4 = {.cps = (lxb_codepoint_t[]) {0x647E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C5 = {.cps = (lxb_codepoint_t[]) {0x649D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C6 = {.cps = (lxb_codepoint_t[]) {0x6477}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C7 = {.cps = (lxb_codepoint_t[]) {0x3A6C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C8 = {.cps = (lxb_codepoint_t[]) {0x654F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C9 = {.cps = (lxb_codepoint_t[]) {0x656C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CA = {.cps = (lxb_codepoint_t[]) {0x2300A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CB = {.cps = (lxb_codepoint_t[]) {0x65E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CC = {.cps = (lxb_codepoint_t[]) {0x66F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CD = {.cps = (lxb_codepoint_t[]) {0x6649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CE = {.cps = (lxb_codepoint_t[]) {0x3B19}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8CF = {.cps = (lxb_codepoint_t[]) {0x6691}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D0 = {.cps = (lxb_codepoint_t[]) {0x3B08}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D1 = {.cps = (lxb_codepoint_t[]) {0x3AE4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D2 = {.cps = (lxb_codepoint_t[]) {0x5192}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D3 = {.cps = (lxb_codepoint_t[]) {0x5195}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D4 = {.cps = (lxb_codepoint_t[]) {0x6700}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D5 = {.cps = (lxb_codepoint_t[]) {0x669C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D6 = {.cps = (lxb_codepoint_t[]) {0x80AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D7 = {.cps = (lxb_codepoint_t[]) {0x43D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D8 = {.cps = (lxb_codepoint_t[]) {0x6717}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D9 = {.cps = (lxb_codepoint_t[]) {0x671B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DA = {.cps = (lxb_codepoint_t[]) {0x6721}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DB = {.cps = (lxb_codepoint_t[]) {0x675E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DC = {.cps = (lxb_codepoint_t[]) {0x6753}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DD = {.cps = (lxb_codepoint_t[]) {0x233C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DE = {.cps = (lxb_codepoint_t[]) {0x3B49}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8DF = {.cps = (lxb_codepoint_t[]) {0x67FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E0 = {.cps = (lxb_codepoint_t[]) {0x6785}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E1 = {.cps = (lxb_codepoint_t[]) {0x6852}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E2 = {.cps = (lxb_codepoint_t[]) {0x6885}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E3 = {.cps = (lxb_codepoint_t[]) {0x2346D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E4 = {.cps = (lxb_codepoint_t[]) {0x688E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E5 = {.cps = (lxb_codepoint_t[]) {0x681F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E6 = {.cps = (lxb_codepoint_t[]) {0x6914}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E7 = {.cps = (lxb_codepoint_t[]) {0x3B9D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E8 = {.cps = (lxb_codepoint_t[]) {0x6942}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E9 = {.cps = (lxb_codepoint_t[]) {0x69A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8EA = {.cps = (lxb_codepoint_t[]) {0x69EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8EB = {.cps = (lxb_codepoint_t[]) {0x6AA8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8EC = {.cps = (lxb_codepoint_t[]) {0x236A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8ED = {.cps = (lxb_codepoint_t[]) {0x6ADB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8EE = {.cps = (lxb_codepoint_t[]) {0x3C18}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8EF = {.cps = (lxb_codepoint_t[]) {0x6B21}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F0 = {.cps = (lxb_codepoint_t[]) {0x238A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F1 = {.cps = (lxb_codepoint_t[]) {0x6B54}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F2 = {.cps = (lxb_codepoint_t[]) {0x3C4E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F3 = {.cps = (lxb_codepoint_t[]) {0x6B72}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F4 = {.cps = (lxb_codepoint_t[]) {0x6B9F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F5 = {.cps = (lxb_codepoint_t[]) {0x6BBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F6 = {.cps = (lxb_codepoint_t[]) {0x6BBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F7 = {.cps = (lxb_codepoint_t[]) {0x23A8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F8 = {.cps = (lxb_codepoint_t[]) {0x21D0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F9 = {.cps = (lxb_codepoint_t[]) {0x23AFA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FA = {.cps = (lxb_codepoint_t[]) {0x6C4E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FB = {.cps = (lxb_codepoint_t[]) {0x23CBC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FC = {.cps = (lxb_codepoint_t[]) {0x6CBF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FD = {.cps = (lxb_codepoint_t[]) {0x6CCD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FE = {.cps = (lxb_codepoint_t[]) {0x6C67}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8FF = {.cps = (lxb_codepoint_t[]) {0x6D16}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F900 = {.cps = (lxb_codepoint_t[]) {0x6D3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F901 = {.cps = (lxb_codepoint_t[]) {0x6D77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F902 = {.cps = (lxb_codepoint_t[]) {0x6D41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F903 = {.cps = (lxb_codepoint_t[]) {0x6D69}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F904 = {.cps = (lxb_codepoint_t[]) {0x6D78}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F905 = {.cps = (lxb_codepoint_t[]) {0x6D85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F906 = {.cps = (lxb_codepoint_t[]) {0x23D1E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F907 = {.cps = (lxb_codepoint_t[]) {0x6D34}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F908 = {.cps = (lxb_codepoint_t[]) {0x6E2F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F909 = {.cps = (lxb_codepoint_t[]) {0x6E6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90A = {.cps = (lxb_codepoint_t[]) {0x3D33}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90B = {.cps = (lxb_codepoint_t[]) {0x6ECB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90C = {.cps = (lxb_codepoint_t[]) {0x6EC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90D = {.cps = (lxb_codepoint_t[]) {0x23ED1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90E = {.cps = (lxb_codepoint_t[]) {0x6DF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90F = {.cps = (lxb_codepoint_t[]) {0x6F6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F910 = {.cps = (lxb_codepoint_t[]) {0x23F5E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F911 = {.cps = (lxb_codepoint_t[]) {0x23F8E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F912 = {.cps = (lxb_codepoint_t[]) {0x6FC6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F913 = {.cps = (lxb_codepoint_t[]) {0x7039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F914 = {.cps = (lxb_codepoint_t[]) {0x701E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F915 = {.cps = (lxb_codepoint_t[]) {0x701B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F916 = {.cps = (lxb_codepoint_t[]) {0x3D96}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F917 = {.cps = (lxb_codepoint_t[]) {0x704A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F918 = {.cps = (lxb_codepoint_t[]) {0x707D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F919 = {.cps = (lxb_codepoint_t[]) {0x7077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91A = {.cps = (lxb_codepoint_t[]) {0x70AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91B = {.cps = (lxb_codepoint_t[]) {0x20525}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91C = {.cps = (lxb_codepoint_t[]) {0x7145}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91D = {.cps = (lxb_codepoint_t[]) {0x24263}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91E = {.cps = (lxb_codepoint_t[]) {0x719C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F920 = {.cps = (lxb_codepoint_t[]) {0x7228}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F921 = {.cps = (lxb_codepoint_t[]) {0x7235}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F922 = {.cps = (lxb_codepoint_t[]) {0x7250}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F923 = {.cps = (lxb_codepoint_t[]) {0x24608}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F924 = {.cps = (lxb_codepoint_t[]) {0x7280}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F925 = {.cps = (lxb_codepoint_t[]) {0x7295}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F926 = {.cps = (lxb_codepoint_t[]) {0x24735}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F927 = {.cps = (lxb_codepoint_t[]) {0x24814}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F928 = {.cps = (lxb_codepoint_t[]) {0x737A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F929 = {.cps = (lxb_codepoint_t[]) {0x738B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92A = {.cps = (lxb_codepoint_t[]) {0x3EAC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92B = {.cps = (lxb_codepoint_t[]) {0x73A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92C = {.cps = (lxb_codepoint_t[]) {0x3EB8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92D = {.cps = (lxb_codepoint_t[]) {0x3EB8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92E = {.cps = (lxb_codepoint_t[]) {0x7447}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92F = {.cps = (lxb_codepoint_t[]) {0x745C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F930 = {.cps = (lxb_codepoint_t[]) {0x7471}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F931 = {.cps = (lxb_codepoint_t[]) {0x7485}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F932 = {.cps = (lxb_codepoint_t[]) {0x74CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F933 = {.cps = (lxb_codepoint_t[]) {0x3F1B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F934 = {.cps = (lxb_codepoint_t[]) {0x7524}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F935 = {.cps = (lxb_codepoint_t[]) {0x24C36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F936 = {.cps = (lxb_codepoint_t[]) {0x753E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F937 = {.cps = (lxb_codepoint_t[]) {0x24C92}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F938 = {.cps = (lxb_codepoint_t[]) {0x7570}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F939 = {.cps = (lxb_codepoint_t[]) {0x2219F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93A = {.cps = (lxb_codepoint_t[]) {0x7610}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93B = {.cps = (lxb_codepoint_t[]) {0x24FA1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93C = {.cps = (lxb_codepoint_t[]) {0x24FB8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93D = {.cps = (lxb_codepoint_t[]) {0x25044}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93E = {.cps = (lxb_codepoint_t[]) {0x3FFC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93F = {.cps = (lxb_codepoint_t[]) {0x4008}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F940 = {.cps = (lxb_codepoint_t[]) {0x76F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F941 = {.cps = (lxb_codepoint_t[]) {0x250F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F942 = {.cps = (lxb_codepoint_t[]) {0x250F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F943 = {.cps = (lxb_codepoint_t[]) {0x25119}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F944 = {.cps = (lxb_codepoint_t[]) {0x25133}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F945 = {.cps = (lxb_codepoint_t[]) {0x771E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F946 = {.cps = (lxb_codepoint_t[]) {0x771F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F947 = {.cps = (lxb_codepoint_t[]) {0x771F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F948 = {.cps = (lxb_codepoint_t[]) {0x774A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F949 = {.cps = (lxb_codepoint_t[]) {0x4039}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94A = {.cps = (lxb_codepoint_t[]) {0x778B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94B = {.cps = (lxb_codepoint_t[]) {0x4046}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94C = {.cps = (lxb_codepoint_t[]) {0x4096}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94D = {.cps = (lxb_codepoint_t[]) {0x2541D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94E = {.cps = (lxb_codepoint_t[]) {0x784E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94F = {.cps = (lxb_codepoint_t[]) {0x788C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F950 = {.cps = (lxb_codepoint_t[]) {0x78CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F951 = {.cps = (lxb_codepoint_t[]) {0x40E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F952 = {.cps = (lxb_codepoint_t[]) {0x25626}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F953 = {.cps = (lxb_codepoint_t[]) {0x7956}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F954 = {.cps = (lxb_codepoint_t[]) {0x2569A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F955 = {.cps = (lxb_codepoint_t[]) {0x256C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F956 = {.cps = (lxb_codepoint_t[]) {0x798F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F957 = {.cps = (lxb_codepoint_t[]) {0x79EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F958 = {.cps = (lxb_codepoint_t[]) {0x412F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F959 = {.cps = (lxb_codepoint_t[]) {0x7A40}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95A = {.cps = (lxb_codepoint_t[]) {0x7A4A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95B = {.cps = (lxb_codepoint_t[]) {0x7A4F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95C = {.cps = (lxb_codepoint_t[]) {0x2597C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95D = {.cps = (lxb_codepoint_t[]) {0x25AA7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95E = {.cps = (lxb_codepoint_t[]) {0x25AA7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F960 = {.cps = (lxb_codepoint_t[]) {0x4202}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F961 = {.cps = (lxb_codepoint_t[]) {0x25BAB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F962 = {.cps = (lxb_codepoint_t[]) {0x7BC6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F963 = {.cps = (lxb_codepoint_t[]) {0x7BC9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F964 = {.cps = (lxb_codepoint_t[]) {0x4227}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F965 = {.cps = (lxb_codepoint_t[]) {0x25C80}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F966 = {.cps = (lxb_codepoint_t[]) {0x7CD2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F967 = {.cps = (lxb_codepoint_t[]) {0x42A0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F968 = {.cps = (lxb_codepoint_t[]) {0x7CE8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F969 = {.cps = (lxb_codepoint_t[]) {0x7CE3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96A = {.cps = (lxb_codepoint_t[]) {0x7D00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96B = {.cps = (lxb_codepoint_t[]) {0x25F86}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96C = {.cps = (lxb_codepoint_t[]) {0x7D63}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96D = {.cps = (lxb_codepoint_t[]) {0x4301}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96E = {.cps = (lxb_codepoint_t[]) {0x7DC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96F = {.cps = (lxb_codepoint_t[]) {0x7E02}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F970 = {.cps = (lxb_codepoint_t[]) {0x7E45}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F971 = {.cps = (lxb_codepoint_t[]) {0x4334}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F972 = {.cps = (lxb_codepoint_t[]) {0x26228}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F973 = {.cps = (lxb_codepoint_t[]) {0x26247}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F974 = {.cps = (lxb_codepoint_t[]) {0x4359}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F975 = {.cps = (lxb_codepoint_t[]) {0x262D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F976 = {.cps = (lxb_codepoint_t[]) {0x7F7A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F977 = {.cps = (lxb_codepoint_t[]) {0x2633E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F978 = {.cps = (lxb_codepoint_t[]) {0x7F95}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F979 = {.cps = (lxb_codepoint_t[]) {0x7FFA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97A = {.cps = (lxb_codepoint_t[]) {0x8005}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97B = {.cps = (lxb_codepoint_t[]) {0x264DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97C = {.cps = (lxb_codepoint_t[]) {0x26523}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97D = {.cps = (lxb_codepoint_t[]) {0x8060}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97E = {.cps = (lxb_codepoint_t[]) {0x265A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97F = {.cps = (lxb_codepoint_t[]) {0x8070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F980 = {.cps = (lxb_codepoint_t[]) {0x2335F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F981 = {.cps = (lxb_codepoint_t[]) {0x43D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F982 = {.cps = (lxb_codepoint_t[]) {0x80B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F983 = {.cps = (lxb_codepoint_t[]) {0x8103}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F984 = {.cps = (lxb_codepoint_t[]) {0x440B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F985 = {.cps = (lxb_codepoint_t[]) {0x813E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F986 = {.cps = (lxb_codepoint_t[]) {0x5AB5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F987 = {.cps = (lxb_codepoint_t[]) {0x267A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F988 = {.cps = (lxb_codepoint_t[]) {0x267B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F989 = {.cps = (lxb_codepoint_t[]) {0x23393}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98A = {.cps = (lxb_codepoint_t[]) {0x2339C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98B = {.cps = (lxb_codepoint_t[]) {0x8201}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98C = {.cps = (lxb_codepoint_t[]) {0x8204}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98D = {.cps = (lxb_codepoint_t[]) {0x8F9E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98E = {.cps = (lxb_codepoint_t[]) {0x446B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98F = {.cps = (lxb_codepoint_t[]) {0x8291}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F990 = {.cps = (lxb_codepoint_t[]) {0x828B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F991 = {.cps = (lxb_codepoint_t[]) {0x829D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F992 = {.cps = (lxb_codepoint_t[]) {0x52B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F993 = {.cps = (lxb_codepoint_t[]) {0x82B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F994 = {.cps = (lxb_codepoint_t[]) {0x82B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F995 = {.cps = (lxb_codepoint_t[]) {0x82BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F996 = {.cps = (lxb_codepoint_t[]) {0x82E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F997 = {.cps = (lxb_codepoint_t[]) {0x26B3C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F998 = {.cps = (lxb_codepoint_t[]) {0x82E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F999 = {.cps = (lxb_codepoint_t[]) {0x831D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99A = {.cps = (lxb_codepoint_t[]) {0x8363}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99B = {.cps = (lxb_codepoint_t[]) {0x83AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99C = {.cps = (lxb_codepoint_t[]) {0x8323}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99D = {.cps = (lxb_codepoint_t[]) {0x83BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99E = {.cps = (lxb_codepoint_t[]) {0x83E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99F = {.cps = (lxb_codepoint_t[]) {0x8457}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A0 = {.cps = (lxb_codepoint_t[]) {0x8353}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A1 = {.cps = (lxb_codepoint_t[]) {0x83CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A2 = {.cps = (lxb_codepoint_t[]) {0x83CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A3 = {.cps = (lxb_codepoint_t[]) {0x83DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A4 = {.cps = (lxb_codepoint_t[]) {0x26C36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A5 = {.cps = (lxb_codepoint_t[]) {0x26D6B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A6 = {.cps = (lxb_codepoint_t[]) {0x26CD5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A7 = {.cps = (lxb_codepoint_t[]) {0x452B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A8 = {.cps = (lxb_codepoint_t[]) {0x84F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A9 = {.cps = (lxb_codepoint_t[]) {0x84F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AA = {.cps = (lxb_codepoint_t[]) {0x8516}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AB = {.cps = (lxb_codepoint_t[]) {0x273CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AC = {.cps = (lxb_codepoint_t[]) {0x8564}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AD = {.cps = (lxb_codepoint_t[]) {0x26F2C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AE = {.cps = (lxb_codepoint_t[]) {0x455D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9AF = {.cps = (lxb_codepoint_t[]) {0x4561}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B0 = {.cps = (lxb_codepoint_t[]) {0x26FB1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B1 = {.cps = (lxb_codepoint_t[]) {0x270D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B2 = {.cps = (lxb_codepoint_t[]) {0x456B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B3 = {.cps = (lxb_codepoint_t[]) {0x8650}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B4 = {.cps = (lxb_codepoint_t[]) {0x865C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B5 = {.cps = (lxb_codepoint_t[]) {0x8667}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B6 = {.cps = (lxb_codepoint_t[]) {0x8669}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B7 = {.cps = (lxb_codepoint_t[]) {0x86A9}, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F800[1] = {0x4E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F800 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F800, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F800[1] = {0x4E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F800 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F800, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F800[1] = {0x4E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F800 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F800, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F800 = {.cp = 0x2F800, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F800, .cde = &lxb_unicode_decomposition_c_2F800, .kde = &lxb_unicode_decomposition_k_2F800};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F801[1] = {0x4E38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F801 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F801, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F801[1] = {0x4E38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F801 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F801, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F801[1] = {0x4E38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F801 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F801, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F801 = {.cp = 0x2F801, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F801, .cde = &lxb_unicode_decomposition_c_2F801, .kde = &lxb_unicode_decomposition_k_2F801};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F802[1] = {0x4E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F802 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F802, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F802[1] = {0x4E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F802 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F802, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F802[1] = {0x4E41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F802 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F802, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F802 = {.cp = 0x2F802, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F802, .cde = &lxb_unicode_decomposition_c_2F802, .kde = &lxb_unicode_decomposition_k_2F802};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F803[1] = {0x20122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F803 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F803, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F803[1] = {0x20122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F803 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F803, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F803[1] = {0x20122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F803 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F803, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F803 = {.cp = 0x2F803, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F803, .cde = &lxb_unicode_decomposition_c_2F803, .kde = &lxb_unicode_decomposition_k_2F803};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F804[1] = {0x4F60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F804 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F804, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F804[1] = {0x4F60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F804 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F804, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F804[1] = {0x4F60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F804 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F804, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F804 = {.cp = 0x2F804, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F804, .cde = &lxb_unicode_decomposition_c_2F804, .kde = &lxb_unicode_decomposition_k_2F804};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F805[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F805 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F805, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F805[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F805 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F805, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F805[1] = {0x4FAE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F805 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F805, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F805 = {.cp = 0x2F805, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F805, .cde = &lxb_unicode_decomposition_c_2F805, .kde = &lxb_unicode_decomposition_k_2F805};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F806[1] = {0x4FBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F806 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F806, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F806[1] = {0x4FBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F806 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F806, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F806[1] = {0x4FBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F806 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F806, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F806 = {.cp = 0x2F806, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F806, .cde = &lxb_unicode_decomposition_c_2F806, .kde = &lxb_unicode_decomposition_k_2F806};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F807[1] = {0x5002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F807 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F807, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F807[1] = {0x5002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F807 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F807, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F807[1] = {0x5002};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F807 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F807, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F807 = {.cp = 0x2F807, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F807, .cde = &lxb_unicode_decomposition_c_2F807, .kde = &lxb_unicode_decomposition_k_2F807};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F808[1] = {0x507A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F808 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F808, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F808[1] = {0x507A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F808 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F808, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F808[1] = {0x507A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F808 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F808, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F808 = {.cp = 0x2F808, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F808, .cde = &lxb_unicode_decomposition_c_2F808, .kde = &lxb_unicode_decomposition_k_2F808};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F809[1] = {0x5099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F809 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F809, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F809[1] = {0x5099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F809 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F809, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F809[1] = {0x5099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F809 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F809, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F809 = {.cp = 0x2F809, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F809, .cde = &lxb_unicode_decomposition_c_2F809, .kde = &lxb_unicode_decomposition_k_2F809};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80A[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80A[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80A[1] = {0x50E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80A = {.cp = 0x2F80A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80A, .cde = &lxb_unicode_decomposition_c_2F80A, .kde = &lxb_unicode_decomposition_k_2F80A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80B[1] = {0x50CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80B[1] = {0x50CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80B[1] = {0x50CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80B = {.cp = 0x2F80B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80B, .cde = &lxb_unicode_decomposition_c_2F80B, .kde = &lxb_unicode_decomposition_k_2F80B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80C[1] = {0x349E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80C[1] = {0x349E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80C[1] = {0x349E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80C = {.cp = 0x2F80C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80C, .cde = &lxb_unicode_decomposition_c_2F80C, .kde = &lxb_unicode_decomposition_k_2F80C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80D[1] = {0x2063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80D[1] = {0x2063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80D[1] = {0x2063A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80D = {.cp = 0x2F80D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80D, .cde = &lxb_unicode_decomposition_c_2F80D, .kde = &lxb_unicode_decomposition_k_2F80D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80E[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80E[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80E[1] = {0x514D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80E = {.cp = 0x2F80E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80E, .cde = &lxb_unicode_decomposition_c_2F80E, .kde = &lxb_unicode_decomposition_k_2F80E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80F[1] = {0x5154};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F80F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80F[1] = {0x5154};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F80F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80F[1] = {0x5154};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F80F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80F = {.cp = 0x2F80F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80F, .cde = &lxb_unicode_decomposition_c_2F80F, .kde = &lxb_unicode_decomposition_k_2F80F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F810[1] = {0x5164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F810 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F810, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F810[1] = {0x5164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F810 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F810, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F810[1] = {0x5164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F810 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F810, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F810 = {.cp = 0x2F810, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F810, .cde = &lxb_unicode_decomposition_c_2F810, .kde = &lxb_unicode_decomposition_k_2F810};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F811[1] = {0x5177};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F811 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F811, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F811[1] = {0x5177};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F811 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F811, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F811[1] = {0x5177};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F811 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F811, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F811 = {.cp = 0x2F811, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F811, .cde = &lxb_unicode_decomposition_c_2F811, .kde = &lxb_unicode_decomposition_k_2F811};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F812[1] = {0x2051C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F812 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F812, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F812[1] = {0x2051C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F812 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F812, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F812[1] = {0x2051C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F812 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F812, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F812 = {.cp = 0x2F812, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F812, .cde = &lxb_unicode_decomposition_c_2F812, .kde = &lxb_unicode_decomposition_k_2F812};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F813[1] = {0x34B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F813 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F813, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F813[1] = {0x34B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F813 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F813, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F813[1] = {0x34B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F813 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F813, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F813 = {.cp = 0x2F813, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F813, .cde = &lxb_unicode_decomposition_c_2F813, .kde = &lxb_unicode_decomposition_k_2F813};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F814[1] = {0x5167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F814 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F814, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F814[1] = {0x5167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F814 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F814, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F814[1] = {0x5167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F814 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F814, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F814 = {.cp = 0x2F814, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F814, .cde = &lxb_unicode_decomposition_c_2F814, .kde = &lxb_unicode_decomposition_k_2F814};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F815[1] = {0x518D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F815 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F815, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F815[1] = {0x518D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F815 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F815, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F815[1] = {0x518D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F815 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F815, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F815 = {.cp = 0x2F815, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F815, .cde = &lxb_unicode_decomposition_c_2F815, .kde = &lxb_unicode_decomposition_k_2F815};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F816[1] = {0x2054B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F816 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F816, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F816[1] = {0x2054B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F816 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F816, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F816[1] = {0x2054B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F816 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F816, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F816 = {.cp = 0x2F816, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F816, .cde = &lxb_unicode_decomposition_c_2F816, .kde = &lxb_unicode_decomposition_k_2F816};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F817[1] = {0x5197};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F817 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F817, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F817[1] = {0x5197};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F817 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F817, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F817[1] = {0x5197};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F817 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F817, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F817 = {.cp = 0x2F817, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F817, .cde = &lxb_unicode_decomposition_c_2F817, .kde = &lxb_unicode_decomposition_k_2F817};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F818[1] = {0x51A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F818 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F818, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F818[1] = {0x51A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F818 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F818, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F818[1] = {0x51A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F818 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F818, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F818 = {.cp = 0x2F818, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F818, .cde = &lxb_unicode_decomposition_c_2F818, .kde = &lxb_unicode_decomposition_k_2F818};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F819[1] = {0x4ECC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F819 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F819, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F819[1] = {0x4ECC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F819 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F819, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F819[1] = {0x4ECC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F819 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F819, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F819 = {.cp = 0x2F819, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F819, .cde = &lxb_unicode_decomposition_c_2F819, .kde = &lxb_unicode_decomposition_k_2F819};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81A[1] = {0x51AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81A[1] = {0x51AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81A[1] = {0x51AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81A = {.cp = 0x2F81A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81A, .cde = &lxb_unicode_decomposition_c_2F81A, .kde = &lxb_unicode_decomposition_k_2F81A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81B[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81B[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81B[1] = {0x51B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81B = {.cp = 0x2F81B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81B, .cde = &lxb_unicode_decomposition_c_2F81B, .kde = &lxb_unicode_decomposition_k_2F81B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81C[1] = {0x291DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81C[1] = {0x291DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81C[1] = {0x291DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81C = {.cp = 0x2F81C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81C, .cde = &lxb_unicode_decomposition_c_2F81C, .kde = &lxb_unicode_decomposition_k_2F81C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81D[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81D[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81D[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81D = {.cp = 0x2F81D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81D, .cde = &lxb_unicode_decomposition_c_2F81D, .kde = &lxb_unicode_decomposition_k_2F81D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81E[1] = {0x5203};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81E[1] = {0x5203};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81E[1] = {0x5203};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81E = {.cp = 0x2F81E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81E, .cde = &lxb_unicode_decomposition_c_2F81E, .kde = &lxb_unicode_decomposition_k_2F81E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81F[1] = {0x34DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F81F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81F[1] = {0x34DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F81F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81F[1] = {0x34DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F81F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81F = {.cp = 0x2F81F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81F, .cde = &lxb_unicode_decomposition_c_2F81F, .kde = &lxb_unicode_decomposition_k_2F81F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F820[1] = {0x523B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F820 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F820, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F820[1] = {0x523B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F820 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F820, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F820[1] = {0x523B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F820 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F820, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F820 = {.cp = 0x2F820, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F820, .cde = &lxb_unicode_decomposition_c_2F820, .kde = &lxb_unicode_decomposition_k_2F820};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F821[1] = {0x5246};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F821 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F821, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F821[1] = {0x5246};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F821 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F821, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F821[1] = {0x5246};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F821 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F821, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F821 = {.cp = 0x2F821, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F821, .cde = &lxb_unicode_decomposition_c_2F821, .kde = &lxb_unicode_decomposition_k_2F821};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F822[1] = {0x5272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F822 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F822, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F822[1] = {0x5272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F822 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F822, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F822[1] = {0x5272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F822 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F822, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F822 = {.cp = 0x2F822, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F822, .cde = &lxb_unicode_decomposition_c_2F822, .kde = &lxb_unicode_decomposition_k_2F822};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F823[1] = {0x5277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F823 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F823, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F823[1] = {0x5277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F823 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F823, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F823[1] = {0x5277};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F823 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F823, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F823 = {.cp = 0x2F823, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F823, .cde = &lxb_unicode_decomposition_c_2F823, .kde = &lxb_unicode_decomposition_k_2F823};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F824[1] = {0x3515};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F824 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F824, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F824[1] = {0x3515};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F824 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F824, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F824[1] = {0x3515};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F824 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F824, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F824 = {.cp = 0x2F824, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F824, .cde = &lxb_unicode_decomposition_c_2F824, .kde = &lxb_unicode_decomposition_k_2F824};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F825[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F825 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F825, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F825[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F825 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F825, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F825[1] = {0x52C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F825 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F825, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F825 = {.cp = 0x2F825, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F825, .cde = &lxb_unicode_decomposition_c_2F825, .kde = &lxb_unicode_decomposition_k_2F825};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F826[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F826 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F826, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F826[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F826 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F826, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F826[1] = {0x52C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F826 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F826, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F826 = {.cp = 0x2F826, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F826, .cde = &lxb_unicode_decomposition_c_2F826, .kde = &lxb_unicode_decomposition_k_2F826};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F827[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F827 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F827, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F827[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F827 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F827, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F827[1] = {0x52E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F827 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F827, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F827 = {.cp = 0x2F827, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F827, .cde = &lxb_unicode_decomposition_c_2F827, .kde = &lxb_unicode_decomposition_k_2F827};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F828[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F828 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F828, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F828[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F828 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F828, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F828[1] = {0x52FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F828 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F828, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F828 = {.cp = 0x2F828, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F828, .cde = &lxb_unicode_decomposition_c_2F828, .kde = &lxb_unicode_decomposition_k_2F828};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F829[1] = {0x5305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F829 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F829, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F829[1] = {0x5305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F829 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F829, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F829[1] = {0x5305};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F829 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F829, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F829 = {.cp = 0x2F829, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F829, .cde = &lxb_unicode_decomposition_c_2F829, .kde = &lxb_unicode_decomposition_k_2F829};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82A[1] = {0x5306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82A[1] = {0x5306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82A[1] = {0x5306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82A = {.cp = 0x2F82A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82A, .cde = &lxb_unicode_decomposition_c_2F82A, .kde = &lxb_unicode_decomposition_k_2F82A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82B[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82B[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82B[1] = {0x5317};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82B = {.cp = 0x2F82B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82B, .cde = &lxb_unicode_decomposition_c_2F82B, .kde = &lxb_unicode_decomposition_k_2F82B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82C[1] = {0x5349};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82C[1] = {0x5349};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82C[1] = {0x5349};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82C = {.cp = 0x2F82C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82C, .cde = &lxb_unicode_decomposition_c_2F82C, .kde = &lxb_unicode_decomposition_k_2F82C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82D[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82D[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82D[1] = {0x5351};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82D = {.cp = 0x2F82D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82D, .cde = &lxb_unicode_decomposition_c_2F82D, .kde = &lxb_unicode_decomposition_k_2F82D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82E[1] = {0x535A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82E[1] = {0x535A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82E[1] = {0x535A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82E = {.cp = 0x2F82E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82E, .cde = &lxb_unicode_decomposition_c_2F82E, .kde = &lxb_unicode_decomposition_k_2F82E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82F[1] = {0x5373};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F82F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82F[1] = {0x5373};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F82F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82F[1] = {0x5373};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F82F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82F = {.cp = 0x2F82F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82F, .cde = &lxb_unicode_decomposition_c_2F82F, .kde = &lxb_unicode_decomposition_k_2F82F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F830[1] = {0x537D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F830 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F830, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F830[1] = {0x537D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F830 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F830, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F830[1] = {0x537D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F830 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F830, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F830 = {.cp = 0x2F830, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F830, .cde = &lxb_unicode_decomposition_c_2F830, .kde = &lxb_unicode_decomposition_k_2F830};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F831[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F831 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F831, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F831[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F831 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F831, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F831[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F831 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F831, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F831 = {.cp = 0x2F831, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F831, .cde = &lxb_unicode_decomposition_c_2F831, .kde = &lxb_unicode_decomposition_k_2F831};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F832[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F832 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F832, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F832[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F832 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F832, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F832[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F832 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F832, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F832 = {.cp = 0x2F832, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F832, .cde = &lxb_unicode_decomposition_c_2F832, .kde = &lxb_unicode_decomposition_k_2F832};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F833[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F833 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F833, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F833[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F833 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F833, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F833[1] = {0x537F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F833 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F833, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F833 = {.cp = 0x2F833, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F833, .cde = &lxb_unicode_decomposition_c_2F833, .kde = &lxb_unicode_decomposition_k_2F833};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F834[1] = {0x20A2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F834 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F834, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F834[1] = {0x20A2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F834 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F834, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F834[1] = {0x20A2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F834 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F834, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F834 = {.cp = 0x2F834, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F834, .cde = &lxb_unicode_decomposition_c_2F834, .kde = &lxb_unicode_decomposition_k_2F834};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F835[1] = {0x7070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F835 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F835, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F835[1] = {0x7070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F835 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F835, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F835[1] = {0x7070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F835 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F835, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F835 = {.cp = 0x2F835, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F835, .cde = &lxb_unicode_decomposition_c_2F835, .kde = &lxb_unicode_decomposition_k_2F835};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F836[1] = {0x53CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F836 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F836, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F836[1] = {0x53CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F836 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F836, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F836[1] = {0x53CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F836 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F836, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F836 = {.cp = 0x2F836, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F836, .cde = &lxb_unicode_decomposition_c_2F836, .kde = &lxb_unicode_decomposition_k_2F836};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F837[1] = {0x53DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F837 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F837, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F837[1] = {0x53DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F837 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F837, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F837[1] = {0x53DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F837 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F837, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F837 = {.cp = 0x2F837, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F837, .cde = &lxb_unicode_decomposition_c_2F837, .kde = &lxb_unicode_decomposition_k_2F837};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F838[1] = {0x20B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F838 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F838, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F838[1] = {0x20B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F838 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F838, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F838[1] = {0x20B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F838 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F838, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F838 = {.cp = 0x2F838, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F838, .cde = &lxb_unicode_decomposition_c_2F838, .kde = &lxb_unicode_decomposition_k_2F838};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F839[1] = {0x53EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F839 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F839, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F839[1] = {0x53EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F839 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F839, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F839[1] = {0x53EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F839 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F839, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F839 = {.cp = 0x2F839, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F839, .cde = &lxb_unicode_decomposition_c_2F839, .kde = &lxb_unicode_decomposition_k_2F839};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83A[1] = {0x53F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83A[1] = {0x53F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83A[1] = {0x53F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83A = {.cp = 0x2F83A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83A, .cde = &lxb_unicode_decomposition_c_2F83A, .kde = &lxb_unicode_decomposition_k_2F83A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83B[1] = {0x5406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83B[1] = {0x5406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83B[1] = {0x5406};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83B = {.cp = 0x2F83B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83B, .cde = &lxb_unicode_decomposition_c_2F83B, .kde = &lxb_unicode_decomposition_k_2F83B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83C[1] = {0x549E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83C[1] = {0x549E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83C[1] = {0x549E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83C = {.cp = 0x2F83C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83C, .cde = &lxb_unicode_decomposition_c_2F83C, .kde = &lxb_unicode_decomposition_k_2F83C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83D[1] = {0x5438};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83D[1] = {0x5438};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83D[1] = {0x5438};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83D = {.cp = 0x2F83D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83D, .cde = &lxb_unicode_decomposition_c_2F83D, .kde = &lxb_unicode_decomposition_k_2F83D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83E[1] = {0x5448};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83E[1] = {0x5448};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83E[1] = {0x5448};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83E = {.cp = 0x2F83E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83E, .cde = &lxb_unicode_decomposition_c_2F83E, .kde = &lxb_unicode_decomposition_k_2F83E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83F[1] = {0x5468};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F83F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83F[1] = {0x5468};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F83F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83F[1] = {0x5468};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F83F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83F = {.cp = 0x2F83F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83F, .cde = &lxb_unicode_decomposition_c_2F83F, .kde = &lxb_unicode_decomposition_k_2F83F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F840[1] = {0x54A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F840 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F840, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F840[1] = {0x54A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F840 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F840, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F840[1] = {0x54A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F840 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F840, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F840 = {.cp = 0x2F840, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F840, .cde = &lxb_unicode_decomposition_c_2F840, .kde = &lxb_unicode_decomposition_k_2F840};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F841[1] = {0x54F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F841 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F841, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F841[1] = {0x54F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F841 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F841, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F841[1] = {0x54F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F841 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F841, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F841 = {.cp = 0x2F841, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F841, .cde = &lxb_unicode_decomposition_c_2F841, .kde = &lxb_unicode_decomposition_k_2F841};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F842[1] = {0x5510};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F842 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F842, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F842[1] = {0x5510};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F842 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F842, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F842[1] = {0x5510};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F842 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F842, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F842 = {.cp = 0x2F842, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F842, .cde = &lxb_unicode_decomposition_c_2F842, .kde = &lxb_unicode_decomposition_k_2F842};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F843[1] = {0x5553};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F843 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F843, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F843[1] = {0x5553};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F843 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F843, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F843[1] = {0x5553};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F843 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F843, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F843 = {.cp = 0x2F843, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F843, .cde = &lxb_unicode_decomposition_c_2F843, .kde = &lxb_unicode_decomposition_k_2F843};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F844[1] = {0x5563};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F844 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F844, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F844[1] = {0x5563};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F844 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F844, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F844[1] = {0x5563};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F844 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F844, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F844 = {.cp = 0x2F844, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F844, .cde = &lxb_unicode_decomposition_c_2F844, .kde = &lxb_unicode_decomposition_k_2F844};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F845[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F845 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F845, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F845[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F845 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F845, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F845[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F845 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F845, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F845 = {.cp = 0x2F845, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F845, .cde = &lxb_unicode_decomposition_c_2F845, .kde = &lxb_unicode_decomposition_k_2F845};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F846[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F846 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F846, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F846[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F846 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F846, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F846[1] = {0x5584};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F846 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F846, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F846 = {.cp = 0x2F846, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F846, .cde = &lxb_unicode_decomposition_c_2F846, .kde = &lxb_unicode_decomposition_k_2F846};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F847[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F847 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F847, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F847[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F847 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F847, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F847[1] = {0x5599};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F847 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F847, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F847 = {.cp = 0x2F847, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F847, .cde = &lxb_unicode_decomposition_c_2F847, .kde = &lxb_unicode_decomposition_k_2F847};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F848[1] = {0x55AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F848 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F848, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F848[1] = {0x55AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F848 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F848, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F848[1] = {0x55AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F848 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F848, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F848 = {.cp = 0x2F848, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F848, .cde = &lxb_unicode_decomposition_c_2F848, .kde = &lxb_unicode_decomposition_k_2F848};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F849[1] = {0x55B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F849 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F849, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F849[1] = {0x55B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F849 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F849, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F849[1] = {0x55B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F849 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F849, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F849 = {.cp = 0x2F849, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F849, .cde = &lxb_unicode_decomposition_c_2F849, .kde = &lxb_unicode_decomposition_k_2F849};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84A[1] = {0x55C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84A[1] = {0x55C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84A[1] = {0x55C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84A = {.cp = 0x2F84A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84A, .cde = &lxb_unicode_decomposition_c_2F84A, .kde = &lxb_unicode_decomposition_k_2F84A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84B[1] = {0x5716};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84B[1] = {0x5716};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84B[1] = {0x5716};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84B = {.cp = 0x2F84B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84B, .cde = &lxb_unicode_decomposition_c_2F84B, .kde = &lxb_unicode_decomposition_k_2F84B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84C[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84C[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84C[1] = {0x5606};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84C = {.cp = 0x2F84C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84C, .cde = &lxb_unicode_decomposition_c_2F84C, .kde = &lxb_unicode_decomposition_k_2F84C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84D[1] = {0x5717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84D[1] = {0x5717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84D[1] = {0x5717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84D = {.cp = 0x2F84D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84D, .cde = &lxb_unicode_decomposition_c_2F84D, .kde = &lxb_unicode_decomposition_k_2F84D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84E[1] = {0x5651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84E[1] = {0x5651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84E[1] = {0x5651};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84E = {.cp = 0x2F84E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84E, .cde = &lxb_unicode_decomposition_c_2F84E, .kde = &lxb_unicode_decomposition_k_2F84E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84F[1] = {0x5674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F84F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84F[1] = {0x5674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F84F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84F[1] = {0x5674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F84F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84F = {.cp = 0x2F84F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84F, .cde = &lxb_unicode_decomposition_c_2F84F, .kde = &lxb_unicode_decomposition_k_2F84F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F850[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F850 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F850, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F850[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F850 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F850, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F850[1] = {0x5207};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F850 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F850, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F850 = {.cp = 0x2F850, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F850, .cde = &lxb_unicode_decomposition_c_2F850, .kde = &lxb_unicode_decomposition_k_2F850};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F851[1] = {0x58EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F851 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F851, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F851[1] = {0x58EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F851 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F851, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F851[1] = {0x58EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F851 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F851, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F851 = {.cp = 0x2F851, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F851, .cde = &lxb_unicode_decomposition_c_2F851, .kde = &lxb_unicode_decomposition_k_2F851};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F852[1] = {0x57CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F852 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F852, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F852[1] = {0x57CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F852 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F852, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F852[1] = {0x57CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F852 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F852, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F852 = {.cp = 0x2F852, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F852, .cde = &lxb_unicode_decomposition_c_2F852, .kde = &lxb_unicode_decomposition_k_2F852};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F853[1] = {0x57F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F853 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F853, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F853[1] = {0x57F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F853 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F853, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F853[1] = {0x57F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F853 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F853, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F853 = {.cp = 0x2F853, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F853, .cde = &lxb_unicode_decomposition_c_2F853, .kde = &lxb_unicode_decomposition_k_2F853};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F854[1] = {0x580D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F854 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F854, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F854[1] = {0x580D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F854 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F854, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F854[1] = {0x580D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F854 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F854, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F854 = {.cp = 0x2F854, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F854, .cde = &lxb_unicode_decomposition_c_2F854, .kde = &lxb_unicode_decomposition_k_2F854};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F855[1] = {0x578B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F855 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F855, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F855[1] = {0x578B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F855 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F855, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F855[1] = {0x578B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F855 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F855, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F855 = {.cp = 0x2F855, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F855, .cde = &lxb_unicode_decomposition_c_2F855, .kde = &lxb_unicode_decomposition_k_2F855};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F856[1] = {0x5832};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F856 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F856, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F856[1] = {0x5832};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F856 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F856, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F856[1] = {0x5832};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F856 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F856, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F856 = {.cp = 0x2F856, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F856, .cde = &lxb_unicode_decomposition_c_2F856, .kde = &lxb_unicode_decomposition_k_2F856};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F857[1] = {0x5831};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F857 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F857, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F857[1] = {0x5831};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F857 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F857, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F857[1] = {0x5831};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F857 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F857, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F857 = {.cp = 0x2F857, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F857, .cde = &lxb_unicode_decomposition_c_2F857, .kde = &lxb_unicode_decomposition_k_2F857};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F858[1] = {0x58AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F858 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F858, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F858[1] = {0x58AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F858 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F858, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F858[1] = {0x58AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F858 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F858, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F858 = {.cp = 0x2F858, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F858, .cde = &lxb_unicode_decomposition_c_2F858, .kde = &lxb_unicode_decomposition_k_2F858};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F859[1] = {0x214E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F859 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F859, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F859[1] = {0x214E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F859 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F859, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F859[1] = {0x214E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F859 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F859, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F859 = {.cp = 0x2F859, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F859, .cde = &lxb_unicode_decomposition_c_2F859, .kde = &lxb_unicode_decomposition_k_2F859};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85A[1] = {0x58F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85A[1] = {0x58F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85A[1] = {0x58F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85A = {.cp = 0x2F85A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85A, .cde = &lxb_unicode_decomposition_c_2F85A, .kde = &lxb_unicode_decomposition_k_2F85A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85B[1] = {0x58F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85B[1] = {0x58F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85B[1] = {0x58F7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85B = {.cp = 0x2F85B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85B, .cde = &lxb_unicode_decomposition_c_2F85B, .kde = &lxb_unicode_decomposition_k_2F85B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85C[1] = {0x5906};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85C[1] = {0x5906};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85C[1] = {0x5906};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85C = {.cp = 0x2F85C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85C, .cde = &lxb_unicode_decomposition_c_2F85C, .kde = &lxb_unicode_decomposition_k_2F85C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85D[1] = {0x591A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85D[1] = {0x591A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85D[1] = {0x591A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85D = {.cp = 0x2F85D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85D, .cde = &lxb_unicode_decomposition_c_2F85D, .kde = &lxb_unicode_decomposition_k_2F85D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85E[1] = {0x5922};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85E[1] = {0x5922};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85E[1] = {0x5922};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85E = {.cp = 0x2F85E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85E, .cde = &lxb_unicode_decomposition_c_2F85E, .kde = &lxb_unicode_decomposition_k_2F85E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85F[1] = {0x5962};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F85F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85F[1] = {0x5962};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F85F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85F[1] = {0x5962};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F85F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85F = {.cp = 0x2F85F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85F, .cde = &lxb_unicode_decomposition_c_2F85F, .kde = &lxb_unicode_decomposition_k_2F85F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F860[1] = {0x216A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F860 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F860, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F860[1] = {0x216A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F860 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F860, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F860[1] = {0x216A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F860 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F860, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F860 = {.cp = 0x2F860, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F860, .cde = &lxb_unicode_decomposition_c_2F860, .kde = &lxb_unicode_decomposition_k_2F860};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F861[1] = {0x216EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F861 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F861, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F861[1] = {0x216EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F861 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F861, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F861[1] = {0x216EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F861 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F861, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F861 = {.cp = 0x2F861, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F861, .cde = &lxb_unicode_decomposition_c_2F861, .kde = &lxb_unicode_decomposition_k_2F861};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F862[1] = {0x59EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F862 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F862, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F862[1] = {0x59EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F862 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F862, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F862[1] = {0x59EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F862 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F862, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F862 = {.cp = 0x2F862, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F862, .cde = &lxb_unicode_decomposition_c_2F862, .kde = &lxb_unicode_decomposition_k_2F862};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F863[1] = {0x5A1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F863 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F863, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F863[1] = {0x5A1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F863 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F863, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F863[1] = {0x5A1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F863 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F863, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F863 = {.cp = 0x2F863, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F863, .cde = &lxb_unicode_decomposition_c_2F863, .kde = &lxb_unicode_decomposition_k_2F863};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F864[1] = {0x5A27};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F864 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F864, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F864[1] = {0x5A27};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F864 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F864, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F864[1] = {0x5A27};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F864 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F864, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F864 = {.cp = 0x2F864, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F864, .cde = &lxb_unicode_decomposition_c_2F864, .kde = &lxb_unicode_decomposition_k_2F864};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F865[1] = {0x59D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F865 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F865, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F865[1] = {0x59D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F865 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F865, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F865[1] = {0x59D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F865 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F865, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F865 = {.cp = 0x2F865, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F865, .cde = &lxb_unicode_decomposition_c_2F865, .kde = &lxb_unicode_decomposition_k_2F865};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F866[1] = {0x5A66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F866 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F866, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F866[1] = {0x5A66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F866 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F866, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F866[1] = {0x5A66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F866 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F866, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F866 = {.cp = 0x2F866, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F866, .cde = &lxb_unicode_decomposition_c_2F866, .kde = &lxb_unicode_decomposition_k_2F866};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F867[1] = {0x36EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F867 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F867, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F867[1] = {0x36EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F867 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F867, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F867[1] = {0x36EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F867 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F867, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F867 = {.cp = 0x2F867, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F867, .cde = &lxb_unicode_decomposition_c_2F867, .kde = &lxb_unicode_decomposition_k_2F867};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F868[1] = {0x36FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F868 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F868, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F868[1] = {0x36FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F868 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F868, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F868[1] = {0x36FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F868 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F868, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F868 = {.cp = 0x2F868, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F868, .cde = &lxb_unicode_decomposition_c_2F868, .kde = &lxb_unicode_decomposition_k_2F868};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F869[1] = {0x5B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F869 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F869, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F869[1] = {0x5B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F869 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F869, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F869[1] = {0x5B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F869 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F869, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F869 = {.cp = 0x2F869, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F869, .cde = &lxb_unicode_decomposition_c_2F869, .kde = &lxb_unicode_decomposition_k_2F869};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86A[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86A[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86A[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86A = {.cp = 0x2F86A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86A, .cde = &lxb_unicode_decomposition_c_2F86A, .kde = &lxb_unicode_decomposition_k_2F86A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86B[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86B[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86B[1] = {0x5B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86B = {.cp = 0x2F86B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86B, .cde = &lxb_unicode_decomposition_c_2F86B, .kde = &lxb_unicode_decomposition_k_2F86B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86C[1] = {0x219C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86C[1] = {0x219C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86C[1] = {0x219C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86C = {.cp = 0x2F86C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86C, .cde = &lxb_unicode_decomposition_c_2F86C, .kde = &lxb_unicode_decomposition_k_2F86C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86D[1] = {0x5BC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86D[1] = {0x5BC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86D[1] = {0x5BC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86D = {.cp = 0x2F86D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86D, .cde = &lxb_unicode_decomposition_c_2F86D, .kde = &lxb_unicode_decomposition_k_2F86D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86E[1] = {0x5BD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86E[1] = {0x5BD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86E[1] = {0x5BD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86E = {.cp = 0x2F86E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86E, .cde = &lxb_unicode_decomposition_c_2F86E, .kde = &lxb_unicode_decomposition_k_2F86E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F86F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F86F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86F[1] = {0x5BE7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F86F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86F = {.cp = 0x2F86F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86F, .cde = &lxb_unicode_decomposition_c_2F86F, .kde = &lxb_unicode_decomposition_k_2F86F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F870[1] = {0x5BF3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F870 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F870, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F870[1] = {0x5BF3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F870 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F870, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F870[1] = {0x5BF3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F870 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F870, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F870 = {.cp = 0x2F870, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F870, .cde = &lxb_unicode_decomposition_c_2F870, .kde = &lxb_unicode_decomposition_k_2F870};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F871[1] = {0x21B18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F871 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F871, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F871[1] = {0x21B18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F871 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F871, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F871[1] = {0x21B18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F871 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F871, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F871 = {.cp = 0x2F871, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F871, .cde = &lxb_unicode_decomposition_c_2F871, .kde = &lxb_unicode_decomposition_k_2F871};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F872[1] = {0x5BFF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F872 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F872, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F872[1] = {0x5BFF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F872 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F872, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F872[1] = {0x5BFF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F872 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F872, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F872 = {.cp = 0x2F872, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F872, .cde = &lxb_unicode_decomposition_c_2F872, .kde = &lxb_unicode_decomposition_k_2F872};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F873[1] = {0x5C06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F873 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F873, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F873[1] = {0x5C06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F873 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F873, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F873[1] = {0x5C06};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F873 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F873, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F873 = {.cp = 0x2F873, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F873, .cde = &lxb_unicode_decomposition_c_2F873, .kde = &lxb_unicode_decomposition_k_2F873};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F874[1] = {0x5F53};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F874 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F874, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F874[1] = {0x5F53};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F874 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F874, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F874[1] = {0x5F53};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F874 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F874, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F874 = {.cp = 0x2F874, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F874, .cde = &lxb_unicode_decomposition_c_2F874, .kde = &lxb_unicode_decomposition_k_2F874};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F875[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F875 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F875, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F875[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F875 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F875, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F875[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F875 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F875, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F875 = {.cp = 0x2F875, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F875, .cde = &lxb_unicode_decomposition_c_2F875, .kde = &lxb_unicode_decomposition_k_2F875};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F876[1] = {0x3781};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F876 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F876, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F876[1] = {0x3781};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F876 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F876, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F876[1] = {0x3781};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F876 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F876, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F876 = {.cp = 0x2F876, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F876, .cde = &lxb_unicode_decomposition_c_2F876, .kde = &lxb_unicode_decomposition_k_2F876};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F877[1] = {0x5C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F877 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F877, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F877[1] = {0x5C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F877 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F877, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F877[1] = {0x5C60};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F877 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F877, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F877 = {.cp = 0x2F877, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F877, .cde = &lxb_unicode_decomposition_c_2F877, .kde = &lxb_unicode_decomposition_k_2F877};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F878[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F878 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F878, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F878[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F878 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F878, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F878[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F878 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F878, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F878 = {.cp = 0x2F878, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F878, .cde = &lxb_unicode_decomposition_c_2F878, .kde = &lxb_unicode_decomposition_k_2F878};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F879[1] = {0x5CC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F879 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F879, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F879[1] = {0x5CC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F879 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F879, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F879[1] = {0x5CC0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F879 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F879, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F879 = {.cp = 0x2F879, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F879, .cde = &lxb_unicode_decomposition_c_2F879, .kde = &lxb_unicode_decomposition_k_2F879};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87A[1] = {0x5C8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87A[1] = {0x5C8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87A[1] = {0x5C8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87A = {.cp = 0x2F87A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87A, .cde = &lxb_unicode_decomposition_c_2F87A, .kde = &lxb_unicode_decomposition_k_2F87A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87B[1] = {0x21DE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87B[1] = {0x21DE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87B[1] = {0x21DE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87B = {.cp = 0x2F87B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87B, .cde = &lxb_unicode_decomposition_c_2F87B, .kde = &lxb_unicode_decomposition_k_2F87B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87C[1] = {0x5D43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87C[1] = {0x5D43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87C[1] = {0x5D43};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87C = {.cp = 0x2F87C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87C, .cde = &lxb_unicode_decomposition_c_2F87C, .kde = &lxb_unicode_decomposition_k_2F87C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87D[1] = {0x21DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87D[1] = {0x21DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87D[1] = {0x21DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87D = {.cp = 0x2F87D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87D, .cde = &lxb_unicode_decomposition_c_2F87D, .kde = &lxb_unicode_decomposition_k_2F87D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87E[1] = {0x5D6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87E[1] = {0x5D6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87E[1] = {0x5D6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87E = {.cp = 0x2F87E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87E, .cde = &lxb_unicode_decomposition_c_2F87E, .kde = &lxb_unicode_decomposition_k_2F87E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87F[1] = {0x5D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F87F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87F[1] = {0x5D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F87F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87F[1] = {0x5D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F87F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87F = {.cp = 0x2F87F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87F, .cde = &lxb_unicode_decomposition_c_2F87F, .kde = &lxb_unicode_decomposition_k_2F87F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F880[1] = {0x5D7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F880 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F880, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F880[1] = {0x5D7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F880 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F880, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F880[1] = {0x5D7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F880 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F880, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F880 = {.cp = 0x2F880, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F880, .cde = &lxb_unicode_decomposition_c_2F880, .kde = &lxb_unicode_decomposition_k_2F880};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F881[1] = {0x5DE1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F881 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F881, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F881[1] = {0x5DE1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F881 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F881, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F881[1] = {0x5DE1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F881 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F881, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F881 = {.cp = 0x2F881, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F881, .cde = &lxb_unicode_decomposition_c_2F881, .kde = &lxb_unicode_decomposition_k_2F881};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F882[1] = {0x5DE2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F882 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F882, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F882[1] = {0x5DE2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F882 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F882, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F882[1] = {0x5DE2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F882 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F882, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F882 = {.cp = 0x2F882, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F882, .cde = &lxb_unicode_decomposition_c_2F882, .kde = &lxb_unicode_decomposition_k_2F882};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F883[1] = {0x382F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F883 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F883, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F883[1] = {0x382F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F883 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F883, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F883[1] = {0x382F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F883 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F883, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F883 = {.cp = 0x2F883, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F883, .cde = &lxb_unicode_decomposition_c_2F883, .kde = &lxb_unicode_decomposition_k_2F883};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F884[1] = {0x5DFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F884 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F884, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F884[1] = {0x5DFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F884 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F884, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F884[1] = {0x5DFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F884 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F884, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F884 = {.cp = 0x2F884, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F884, .cde = &lxb_unicode_decomposition_c_2F884, .kde = &lxb_unicode_decomposition_k_2F884};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F885[1] = {0x5E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F885 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F885, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F885[1] = {0x5E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F885 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F885, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F885[1] = {0x5E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F885 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F885, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F885 = {.cp = 0x2F885, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F885, .cde = &lxb_unicode_decomposition_c_2F885, .kde = &lxb_unicode_decomposition_k_2F885};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F886[1] = {0x5E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F886 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F886, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F886[1] = {0x5E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F886 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F886, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F886[1] = {0x5E3D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F886 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F886, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F886 = {.cp = 0x2F886, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F886, .cde = &lxb_unicode_decomposition_c_2F886, .kde = &lxb_unicode_decomposition_k_2F886};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F887[1] = {0x5E69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F887 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F887, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F887[1] = {0x5E69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F887 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F887, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F887[1] = {0x5E69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F887 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F887, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F887 = {.cp = 0x2F887, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F887, .cde = &lxb_unicode_decomposition_c_2F887, .kde = &lxb_unicode_decomposition_k_2F887};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F888[1] = {0x3862};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F888 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F888, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F888[1] = {0x3862};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F888 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F888, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F888[1] = {0x3862};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F888 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F888, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F888 = {.cp = 0x2F888, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F888, .cde = &lxb_unicode_decomposition_c_2F888, .kde = &lxb_unicode_decomposition_k_2F888};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F889[1] = {0x22183};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F889 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F889, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F889[1] = {0x22183};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F889 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F889, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F889[1] = {0x22183};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F889 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F889, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F889 = {.cp = 0x2F889, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F889, .cde = &lxb_unicode_decomposition_c_2F889, .kde = &lxb_unicode_decomposition_k_2F889};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88A[1] = {0x387C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88A[1] = {0x387C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88A[1] = {0x387C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88A = {.cp = 0x2F88A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88A, .cde = &lxb_unicode_decomposition_c_2F88A, .kde = &lxb_unicode_decomposition_k_2F88A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88B[1] = {0x5EB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88B[1] = {0x5EB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88B[1] = {0x5EB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88B = {.cp = 0x2F88B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88B, .cde = &lxb_unicode_decomposition_c_2F88B, .kde = &lxb_unicode_decomposition_k_2F88B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88C[1] = {0x5EB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88C[1] = {0x5EB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88C[1] = {0x5EB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88C = {.cp = 0x2F88C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88C, .cde = &lxb_unicode_decomposition_c_2F88C, .kde = &lxb_unicode_decomposition_k_2F88C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88D[1] = {0x5EB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88D[1] = {0x5EB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88D[1] = {0x5EB6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88D = {.cp = 0x2F88D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88D, .cde = &lxb_unicode_decomposition_c_2F88D, .kde = &lxb_unicode_decomposition_k_2F88D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88E[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88E[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88E[1] = {0x5ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88E = {.cp = 0x2F88E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88E, .cde = &lxb_unicode_decomposition_c_2F88E, .kde = &lxb_unicode_decomposition_k_2F88E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88F[1] = {0x2A392};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F88F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88F[1] = {0x2A392};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F88F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88F[1] = {0x2A392};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F88F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88F = {.cp = 0x2F88F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88F, .cde = &lxb_unicode_decomposition_c_2F88F, .kde = &lxb_unicode_decomposition_k_2F88F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F890[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F890 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F890, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F890[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F890 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F890, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F890[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F890 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F890, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F890 = {.cp = 0x2F890, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F890, .cde = &lxb_unicode_decomposition_c_2F890, .kde = &lxb_unicode_decomposition_k_2F890};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F891[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F891 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F891, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F891[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F891 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F891, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F891[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F891 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F891, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F891 = {.cp = 0x2F891, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F891, .cde = &lxb_unicode_decomposition_c_2F891, .kde = &lxb_unicode_decomposition_k_2F891};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F892[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F892 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F892, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F892[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F892 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F892, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F892[1] = {0x22331};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F892 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F892, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F892 = {.cp = 0x2F892, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F892, .cde = &lxb_unicode_decomposition_c_2F892, .kde = &lxb_unicode_decomposition_k_2F892};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F893[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F893 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F893, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F893[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F893 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F893, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F893[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F893 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F893, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F893 = {.cp = 0x2F893, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F893, .cde = &lxb_unicode_decomposition_c_2F893, .kde = &lxb_unicode_decomposition_k_2F893};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F894[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F894 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F894, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F894[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F894 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F894, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F894[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F894 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F894, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F894 = {.cp = 0x2F894, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F894, .cde = &lxb_unicode_decomposition_c_2F894, .kde = &lxb_unicode_decomposition_k_2F894};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F895[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F895 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F895, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F895[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F895 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F895, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F895[1] = {0x5F22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F895 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F895, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F895 = {.cp = 0x2F895, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F895, .cde = &lxb_unicode_decomposition_c_2F895, .kde = &lxb_unicode_decomposition_k_2F895};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F896[1] = {0x38C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F896 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F896, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F896[1] = {0x38C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F896 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F896, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F896[1] = {0x38C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F896 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F896, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F896 = {.cp = 0x2F896, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F896, .cde = &lxb_unicode_decomposition_c_2F896, .kde = &lxb_unicode_decomposition_k_2F896};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F897[1] = {0x232B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F897 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F897, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F897[1] = {0x232B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F897 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F897, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F897[1] = {0x232B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F897 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F897, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F897 = {.cp = 0x2F897, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F897, .cde = &lxb_unicode_decomposition_c_2F897, .kde = &lxb_unicode_decomposition_k_2F897};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F898[1] = {0x261DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F898 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F898, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F898[1] = {0x261DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F898 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F898, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F898[1] = {0x261DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F898 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F898, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F898 = {.cp = 0x2F898, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F898, .cde = &lxb_unicode_decomposition_c_2F898, .kde = &lxb_unicode_decomposition_k_2F898};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F899[1] = {0x5F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F899 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F899, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F899[1] = {0x5F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F899 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F899, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F899[1] = {0x5F62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F899 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F899, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F899 = {.cp = 0x2F899, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F899, .cde = &lxb_unicode_decomposition_c_2F899, .kde = &lxb_unicode_decomposition_k_2F899};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89A[1] = {0x5F6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89A[1] = {0x5F6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89A[1] = {0x5F6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89A = {.cp = 0x2F89A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89A, .cde = &lxb_unicode_decomposition_c_2F89A, .kde = &lxb_unicode_decomposition_k_2F89A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89B[1] = {0x38E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89B[1] = {0x38E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89B[1] = {0x38E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89B = {.cp = 0x2F89B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89B, .cde = &lxb_unicode_decomposition_c_2F89B, .kde = &lxb_unicode_decomposition_k_2F89B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89C[1] = {0x5F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89C[1] = {0x5F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89C[1] = {0x5F9A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89C = {.cp = 0x2F89C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89C, .cde = &lxb_unicode_decomposition_c_2F89C, .kde = &lxb_unicode_decomposition_k_2F89C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89D[1] = {0x5FCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89D[1] = {0x5FCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89D[1] = {0x5FCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89D = {.cp = 0x2F89D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89D, .cde = &lxb_unicode_decomposition_c_2F89D, .kde = &lxb_unicode_decomposition_k_2F89D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89E[1] = {0x5FD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89E[1] = {0x5FD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89E[1] = {0x5FD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89E = {.cp = 0x2F89E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89E, .cde = &lxb_unicode_decomposition_c_2F89E, .kde = &lxb_unicode_decomposition_k_2F89E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89F[1] = {0x5FF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F89F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89F[1] = {0x5FF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F89F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89F[1] = {0x5FF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F89F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89F = {.cp = 0x2F89F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89F, .cde = &lxb_unicode_decomposition_c_2F89F, .kde = &lxb_unicode_decomposition_k_2F89F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A0[1] = {0x6081};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A0[1] = {0x6081};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A0[1] = {0x6081};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A0 = {.cp = 0x2F8A0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A0, .cde = &lxb_unicode_decomposition_c_2F8A0, .kde = &lxb_unicode_decomposition_k_2F8A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A1[1] = {0x393A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A1[1] = {0x393A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A1[1] = {0x393A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A1 = {.cp = 0x2F8A1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A1, .cde = &lxb_unicode_decomposition_c_2F8A1, .kde = &lxb_unicode_decomposition_k_2F8A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A2[1] = {0x391C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A2[1] = {0x391C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A2[1] = {0x391C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A2 = {.cp = 0x2F8A2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A2, .cde = &lxb_unicode_decomposition_c_2F8A2, .kde = &lxb_unicode_decomposition_k_2F8A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A3[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A3[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A3[1] = {0x6094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A3 = {.cp = 0x2F8A3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A3, .cde = &lxb_unicode_decomposition_c_2F8A3, .kde = &lxb_unicode_decomposition_k_2F8A3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A4[1] = {0x226D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A4[1] = {0x226D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A4[1] = {0x226D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A4 = {.cp = 0x2F8A4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A4, .cde = &lxb_unicode_decomposition_c_2F8A4, .kde = &lxb_unicode_decomposition_k_2F8A4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A5[1] = {0x60C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A5[1] = {0x60C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A5[1] = {0x60C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A5 = {.cp = 0x2F8A5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A5, .cde = &lxb_unicode_decomposition_c_2F8A5, .kde = &lxb_unicode_decomposition_k_2F8A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A6[1] = {0x6148};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A6[1] = {0x6148};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A6[1] = {0x6148};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A6 = {.cp = 0x2F8A6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A6, .cde = &lxb_unicode_decomposition_c_2F8A6, .kde = &lxb_unicode_decomposition_k_2F8A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A7[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A7[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A7[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A7 = {.cp = 0x2F8A7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A7, .cde = &lxb_unicode_decomposition_c_2F8A7, .kde = &lxb_unicode_decomposition_k_2F8A7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A8[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A8[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A8[1] = {0x614E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A8 = {.cp = 0x2F8A8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A8, .cde = &lxb_unicode_decomposition_c_2F8A8, .kde = &lxb_unicode_decomposition_k_2F8A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A9[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A9[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A9[1] = {0x614C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A9 = {.cp = 0x2F8A9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A9, .cde = &lxb_unicode_decomposition_c_2F8A9, .kde = &lxb_unicode_decomposition_k_2F8A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AA[1] = {0x617A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AA[1] = {0x617A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AA[1] = {0x617A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AA = {.cp = 0x2F8AA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AA, .cde = &lxb_unicode_decomposition_c_2F8AA, .kde = &lxb_unicode_decomposition_k_2F8AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AB[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AB[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AB[1] = {0x618E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AB = {.cp = 0x2F8AB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AB, .cde = &lxb_unicode_decomposition_c_2F8AB, .kde = &lxb_unicode_decomposition_k_2F8AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AC[1] = {0x61B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AC[1] = {0x61B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AC[1] = {0x61B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AC = {.cp = 0x2F8AC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AC, .cde = &lxb_unicode_decomposition_c_2F8AC, .kde = &lxb_unicode_decomposition_k_2F8AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AD[1] = {0x61A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AD[1] = {0x61A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AD[1] = {0x61A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AD = {.cp = 0x2F8AD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AD, .cde = &lxb_unicode_decomposition_c_2F8AD, .kde = &lxb_unicode_decomposition_k_2F8AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AE[1] = {0x61AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AE[1] = {0x61AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AE[1] = {0x61AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AE = {.cp = 0x2F8AE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AE, .cde = &lxb_unicode_decomposition_c_2F8AE, .kde = &lxb_unicode_decomposition_k_2F8AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8AF[1] = {0x61DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8AF[1] = {0x61DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8AF[1] = {0x61DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8AF = {.cp = 0x2F8AF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8AF, .cde = &lxb_unicode_decomposition_c_2F8AF, .kde = &lxb_unicode_decomposition_k_2F8AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B0[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B0[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B0[1] = {0x61F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B0 = {.cp = 0x2F8B0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B0, .cde = &lxb_unicode_decomposition_c_2F8B0, .kde = &lxb_unicode_decomposition_k_2F8B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B1[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B1[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B1[1] = {0x61F6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B1 = {.cp = 0x2F8B1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B1, .cde = &lxb_unicode_decomposition_c_2F8B1, .kde = &lxb_unicode_decomposition_k_2F8B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B2[1] = {0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B2[1] = {0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B2[1] = {0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B2 = {.cp = 0x2F8B2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B2, .cde = &lxb_unicode_decomposition_c_2F8B2, .kde = &lxb_unicode_decomposition_k_2F8B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B3[1] = {0x621B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B3[1] = {0x621B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B3[1] = {0x621B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B3 = {.cp = 0x2F8B3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B3, .cde = &lxb_unicode_decomposition_c_2F8B3, .kde = &lxb_unicode_decomposition_k_2F8B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B4[1] = {0x625D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B4[1] = {0x625D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B4[1] = {0x625D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B4 = {.cp = 0x2F8B4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B4, .cde = &lxb_unicode_decomposition_c_2F8B4, .kde = &lxb_unicode_decomposition_k_2F8B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B5[1] = {0x62B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B5[1] = {0x62B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B5[1] = {0x62B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B5 = {.cp = 0x2F8B5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B5, .cde = &lxb_unicode_decomposition_c_2F8B5, .kde = &lxb_unicode_decomposition_k_2F8B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B6[1] = {0x62D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B6[1] = {0x62D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B6[1] = {0x62D4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B6 = {.cp = 0x2F8B6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B6, .cde = &lxb_unicode_decomposition_c_2F8B6, .kde = &lxb_unicode_decomposition_k_2F8B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B7[1] = {0x6350};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B7[1] = {0x6350};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B7[1] = {0x6350};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B7 = {.cp = 0x2F8B7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B7, .cde = &lxb_unicode_decomposition_c_2F8B7, .kde = &lxb_unicode_decomposition_k_2F8B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B8[1] = {0x22B0C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B8[1] = {0x22B0C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B8[1] = {0x22B0C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B8 = {.cp = 0x2F8B8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B8, .cde = &lxb_unicode_decomposition_c_2F8B8, .kde = &lxb_unicode_decomposition_k_2F8B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B9[1] = {0x633D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B9[1] = {0x633D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B9[1] = {0x633D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B9 = {.cp = 0x2F8B9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B9, .cde = &lxb_unicode_decomposition_c_2F8B9, .kde = &lxb_unicode_decomposition_k_2F8B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BA[1] = {0x62FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BA[1] = {0x62FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BA[1] = {0x62FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BA = {.cp = 0x2F8BA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BA, .cde = &lxb_unicode_decomposition_c_2F8BA, .kde = &lxb_unicode_decomposition_k_2F8BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BB[1] = {0x6368};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BB[1] = {0x6368};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BB[1] = {0x6368};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BB = {.cp = 0x2F8BB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BB, .cde = &lxb_unicode_decomposition_c_2F8BB, .kde = &lxb_unicode_decomposition_k_2F8BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BC[1] = {0x6383};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BC[1] = {0x6383};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BC[1] = {0x6383};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BC = {.cp = 0x2F8BC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BC, .cde = &lxb_unicode_decomposition_c_2F8BC, .kde = &lxb_unicode_decomposition_k_2F8BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BD[1] = {0x63E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BD[1] = {0x63E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BD[1] = {0x63E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BD = {.cp = 0x2F8BD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BD, .cde = &lxb_unicode_decomposition_c_2F8BD, .kde = &lxb_unicode_decomposition_k_2F8BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BE[1] = {0x22BF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BE[1] = {0x22BF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BE[1] = {0x22BF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BE = {.cp = 0x2F8BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BE, .cde = &lxb_unicode_decomposition_c_2F8BE, .kde = &lxb_unicode_decomposition_k_2F8BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8BF[1] = {0x6422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8BF[1] = {0x6422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8BF[1] = {0x6422};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8BF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8BF = {.cp = 0x2F8BF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8BF, .cde = &lxb_unicode_decomposition_c_2F8BF, .kde = &lxb_unicode_decomposition_k_2F8BF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C0[1] = {0x63C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C0[1] = {0x63C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C0[1] = {0x63C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C0 = {.cp = 0x2F8C0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C0, .cde = &lxb_unicode_decomposition_c_2F8C0, .kde = &lxb_unicode_decomposition_k_2F8C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C1[1] = {0x63A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C1[1] = {0x63A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C1[1] = {0x63A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C1 = {.cp = 0x2F8C1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C1, .cde = &lxb_unicode_decomposition_c_2F8C1, .kde = &lxb_unicode_decomposition_k_2F8C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C2[1] = {0x3A2E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C2[1] = {0x3A2E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C2[1] = {0x3A2E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C2 = {.cp = 0x2F8C2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C2, .cde = &lxb_unicode_decomposition_c_2F8C2, .kde = &lxb_unicode_decomposition_k_2F8C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C3[1] = {0x6469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C3[1] = {0x6469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C3[1] = {0x6469};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C3 = {.cp = 0x2F8C3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C3, .cde = &lxb_unicode_decomposition_c_2F8C3, .kde = &lxb_unicode_decomposition_k_2F8C3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C4[1] = {0x647E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C4[1] = {0x647E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C4[1] = {0x647E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C4 = {.cp = 0x2F8C4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C4, .cde = &lxb_unicode_decomposition_c_2F8C4, .kde = &lxb_unicode_decomposition_k_2F8C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C5[1] = {0x649D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C5[1] = {0x649D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C5[1] = {0x649D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C5 = {.cp = 0x2F8C5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C5, .cde = &lxb_unicode_decomposition_c_2F8C5, .kde = &lxb_unicode_decomposition_k_2F8C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C6[1] = {0x6477};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C6[1] = {0x6477};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C6[1] = {0x6477};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C6 = {.cp = 0x2F8C6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C6, .cde = &lxb_unicode_decomposition_c_2F8C6, .kde = &lxb_unicode_decomposition_k_2F8C6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C7[1] = {0x3A6C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C7[1] = {0x3A6C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C7[1] = {0x3A6C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C7 = {.cp = 0x2F8C7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C7, .cde = &lxb_unicode_decomposition_c_2F8C7, .kde = &lxb_unicode_decomposition_k_2F8C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C8[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C8[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C8[1] = {0x654F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C8 = {.cp = 0x2F8C8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C8, .cde = &lxb_unicode_decomposition_c_2F8C8, .kde = &lxb_unicode_decomposition_k_2F8C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C9[1] = {0x656C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C9[1] = {0x656C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C9[1] = {0x656C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8C9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C9 = {.cp = 0x2F8C9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C9, .cde = &lxb_unicode_decomposition_c_2F8C9, .kde = &lxb_unicode_decomposition_k_2F8C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CA[1] = {0x2300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CA[1] = {0x2300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CA[1] = {0x2300A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CA = {.cp = 0x2F8CA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CA, .cde = &lxb_unicode_decomposition_c_2F8CA, .kde = &lxb_unicode_decomposition_k_2F8CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CB[1] = {0x65E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CB[1] = {0x65E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CB[1] = {0x65E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CB = {.cp = 0x2F8CB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CB, .cde = &lxb_unicode_decomposition_c_2F8CB, .kde = &lxb_unicode_decomposition_k_2F8CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CC[1] = {0x66F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CC[1] = {0x66F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CC[1] = {0x66F8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CC = {.cp = 0x2F8CC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CC, .cde = &lxb_unicode_decomposition_c_2F8CC, .kde = &lxb_unicode_decomposition_k_2F8CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CD[1] = {0x6649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CD[1] = {0x6649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CD[1] = {0x6649};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CD = {.cp = 0x2F8CD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CD, .cde = &lxb_unicode_decomposition_c_2F8CD, .kde = &lxb_unicode_decomposition_k_2F8CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CE[1] = {0x3B19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CE[1] = {0x3B19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CE[1] = {0x3B19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CE = {.cp = 0x2F8CE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CE, .cde = &lxb_unicode_decomposition_c_2F8CE, .kde = &lxb_unicode_decomposition_k_2F8CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8CF[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8CF[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8CF[1] = {0x6691};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8CF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8CF = {.cp = 0x2F8CF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8CF, .cde = &lxb_unicode_decomposition_c_2F8CF, .kde = &lxb_unicode_decomposition_k_2F8CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D0[1] = {0x3B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D0[1] = {0x3B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D0[1] = {0x3B08};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D0 = {.cp = 0x2F8D0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D0, .cde = &lxb_unicode_decomposition_c_2F8D0, .kde = &lxb_unicode_decomposition_k_2F8D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D1[1] = {0x3AE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D1[1] = {0x3AE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D1[1] = {0x3AE4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D1 = {.cp = 0x2F8D1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D1, .cde = &lxb_unicode_decomposition_c_2F8D1, .kde = &lxb_unicode_decomposition_k_2F8D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D2[1] = {0x5192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D2[1] = {0x5192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D2[1] = {0x5192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D2 = {.cp = 0x2F8D2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D2, .cde = &lxb_unicode_decomposition_c_2F8D2, .kde = &lxb_unicode_decomposition_k_2F8D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D3[1] = {0x5195};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D3[1] = {0x5195};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D3[1] = {0x5195};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D3 = {.cp = 0x2F8D3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D3, .cde = &lxb_unicode_decomposition_c_2F8D3, .kde = &lxb_unicode_decomposition_k_2F8D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D4[1] = {0x6700};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D4[1] = {0x6700};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D4[1] = {0x6700};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D4 = {.cp = 0x2F8D4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D4, .cde = &lxb_unicode_decomposition_c_2F8D4, .kde = &lxb_unicode_decomposition_k_2F8D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D5[1] = {0x669C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D5[1] = {0x669C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D5[1] = {0x669C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D5 = {.cp = 0x2F8D5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D5, .cde = &lxb_unicode_decomposition_c_2F8D5, .kde = &lxb_unicode_decomposition_k_2F8D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D6[1] = {0x80AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D6[1] = {0x80AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D6[1] = {0x80AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D6 = {.cp = 0x2F8D6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D6, .cde = &lxb_unicode_decomposition_c_2F8D6, .kde = &lxb_unicode_decomposition_k_2F8D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D7[1] = {0x43D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D7[1] = {0x43D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D7[1] = {0x43D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D7 = {.cp = 0x2F8D7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D7, .cde = &lxb_unicode_decomposition_c_2F8D7, .kde = &lxb_unicode_decomposition_k_2F8D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D8[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D8[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D8[1] = {0x6717};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D8 = {.cp = 0x2F8D8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D8, .cde = &lxb_unicode_decomposition_c_2F8D8, .kde = &lxb_unicode_decomposition_k_2F8D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D9[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D9[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D9[1] = {0x671B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8D9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D9 = {.cp = 0x2F8D9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D9, .cde = &lxb_unicode_decomposition_c_2F8D9, .kde = &lxb_unicode_decomposition_k_2F8D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DA[1] = {0x6721};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DA[1] = {0x6721};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DA[1] = {0x6721};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DA = {.cp = 0x2F8DA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DA, .cde = &lxb_unicode_decomposition_c_2F8DA, .kde = &lxb_unicode_decomposition_k_2F8DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DB[1] = {0x675E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DB[1] = {0x675E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DB[1] = {0x675E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DB = {.cp = 0x2F8DB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DB, .cde = &lxb_unicode_decomposition_c_2F8DB, .kde = &lxb_unicode_decomposition_k_2F8DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DC[1] = {0x6753};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DC[1] = {0x6753};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DC[1] = {0x6753};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DC = {.cp = 0x2F8DC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DC, .cde = &lxb_unicode_decomposition_c_2F8DC, .kde = &lxb_unicode_decomposition_k_2F8DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DD[1] = {0x233C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DD[1] = {0x233C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DD[1] = {0x233C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DD = {.cp = 0x2F8DD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DD, .cde = &lxb_unicode_decomposition_c_2F8DD, .kde = &lxb_unicode_decomposition_k_2F8DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DE[1] = {0x3B49};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DE[1] = {0x3B49};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DE[1] = {0x3B49};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DE = {.cp = 0x2F8DE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DE, .cde = &lxb_unicode_decomposition_c_2F8DE, .kde = &lxb_unicode_decomposition_k_2F8DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8DF[1] = {0x67FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8DF[1] = {0x67FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8DF[1] = {0x67FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8DF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8DF = {.cp = 0x2F8DF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8DF, .cde = &lxb_unicode_decomposition_c_2F8DF, .kde = &lxb_unicode_decomposition_k_2F8DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E0[1] = {0x6785};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E0[1] = {0x6785};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E0[1] = {0x6785};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E0 = {.cp = 0x2F8E0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E0, .cde = &lxb_unicode_decomposition_c_2F8E0, .kde = &lxb_unicode_decomposition_k_2F8E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E1[1] = {0x6852};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E1[1] = {0x6852};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E1[1] = {0x6852};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E1 = {.cp = 0x2F8E1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E1, .cde = &lxb_unicode_decomposition_c_2F8E1, .kde = &lxb_unicode_decomposition_k_2F8E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E2[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E2[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E2[1] = {0x6885};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E2 = {.cp = 0x2F8E2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E2, .cde = &lxb_unicode_decomposition_c_2F8E2, .kde = &lxb_unicode_decomposition_k_2F8E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E3[1] = {0x2346D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E3[1] = {0x2346D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E3[1] = {0x2346D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E3 = {.cp = 0x2F8E3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E3, .cde = &lxb_unicode_decomposition_c_2F8E3, .kde = &lxb_unicode_decomposition_k_2F8E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E4[1] = {0x688E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E4[1] = {0x688E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E4[1] = {0x688E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E4 = {.cp = 0x2F8E4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E4, .cde = &lxb_unicode_decomposition_c_2F8E4, .kde = &lxb_unicode_decomposition_k_2F8E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E5[1] = {0x681F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E5[1] = {0x681F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E5[1] = {0x681F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E5 = {.cp = 0x2F8E5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E5, .cde = &lxb_unicode_decomposition_c_2F8E5, .kde = &lxb_unicode_decomposition_k_2F8E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E6[1] = {0x6914};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E6[1] = {0x6914};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E6[1] = {0x6914};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E6 = {.cp = 0x2F8E6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E6, .cde = &lxb_unicode_decomposition_c_2F8E6, .kde = &lxb_unicode_decomposition_k_2F8E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E7[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E7[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E7[1] = {0x3B9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E7 = {.cp = 0x2F8E7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E7, .cde = &lxb_unicode_decomposition_c_2F8E7, .kde = &lxb_unicode_decomposition_k_2F8E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E8[1] = {0x6942};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E8[1] = {0x6942};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E8[1] = {0x6942};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E8 = {.cp = 0x2F8E8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E8, .cde = &lxb_unicode_decomposition_c_2F8E8, .kde = &lxb_unicode_decomposition_k_2F8E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E9[1] = {0x69A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E9[1] = {0x69A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E9[1] = {0x69A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8E9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E9 = {.cp = 0x2F8E9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E9, .cde = &lxb_unicode_decomposition_c_2F8E9, .kde = &lxb_unicode_decomposition_k_2F8E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8EA[1] = {0x69EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8EA[1] = {0x69EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8EA[1] = {0x69EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8EA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8EA = {.cp = 0x2F8EA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8EA, .cde = &lxb_unicode_decomposition_c_2F8EA, .kde = &lxb_unicode_decomposition_k_2F8EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8EB[1] = {0x6AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8EB[1] = {0x6AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8EB[1] = {0x6AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8EB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8EB = {.cp = 0x2F8EB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8EB, .cde = &lxb_unicode_decomposition_c_2F8EB, .kde = &lxb_unicode_decomposition_k_2F8EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8EC[1] = {0x236A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8EC[1] = {0x236A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8EC[1] = {0x236A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8EC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8EC = {.cp = 0x2F8EC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8EC, .cde = &lxb_unicode_decomposition_c_2F8EC, .kde = &lxb_unicode_decomposition_k_2F8EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8ED[1] = {0x6ADB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8ED[1] = {0x6ADB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8ED[1] = {0x6ADB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8ED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8ED = {.cp = 0x2F8ED, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8ED, .cde = &lxb_unicode_decomposition_c_2F8ED, .kde = &lxb_unicode_decomposition_k_2F8ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8EE[1] = {0x3C18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8EE[1] = {0x3C18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8EE[1] = {0x3C18};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8EE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8EE = {.cp = 0x2F8EE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8EE, .cde = &lxb_unicode_decomposition_c_2F8EE, .kde = &lxb_unicode_decomposition_k_2F8EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8EF[1] = {0x6B21};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8EF[1] = {0x6B21};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8EF[1] = {0x6B21};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8EF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8EF = {.cp = 0x2F8EF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8EF, .cde = &lxb_unicode_decomposition_c_2F8EF, .kde = &lxb_unicode_decomposition_k_2F8EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F0[1] = {0x238A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F0[1] = {0x238A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F0[1] = {0x238A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F0 = {.cp = 0x2F8F0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F0, .cde = &lxb_unicode_decomposition_c_2F8F0, .kde = &lxb_unicode_decomposition_k_2F8F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F1[1] = {0x6B54};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F1[1] = {0x6B54};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F1[1] = {0x6B54};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F1 = {.cp = 0x2F8F1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F1, .cde = &lxb_unicode_decomposition_c_2F8F1, .kde = &lxb_unicode_decomposition_k_2F8F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F2[1] = {0x3C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F2[1] = {0x3C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F2[1] = {0x3C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F2 = {.cp = 0x2F8F2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F2, .cde = &lxb_unicode_decomposition_c_2F8F2, .kde = &lxb_unicode_decomposition_k_2F8F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F3[1] = {0x6B72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F3[1] = {0x6B72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F3[1] = {0x6B72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F3 = {.cp = 0x2F8F3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F3, .cde = &lxb_unicode_decomposition_c_2F8F3, .kde = &lxb_unicode_decomposition_k_2F8F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F4[1] = {0x6B9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F4[1] = {0x6B9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F4[1] = {0x6B9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F4 = {.cp = 0x2F8F4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F4, .cde = &lxb_unicode_decomposition_c_2F8F4, .kde = &lxb_unicode_decomposition_k_2F8F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F5[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F5[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F5[1] = {0x6BBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F5 = {.cp = 0x2F8F5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F5, .cde = &lxb_unicode_decomposition_c_2F8F5, .kde = &lxb_unicode_decomposition_k_2F8F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F6[1] = {0x6BBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F6[1] = {0x6BBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F6[1] = {0x6BBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F6 = {.cp = 0x2F8F6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F6, .cde = &lxb_unicode_decomposition_c_2F8F6, .kde = &lxb_unicode_decomposition_k_2F8F6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F7[1] = {0x23A8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F7[1] = {0x23A8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F7[1] = {0x23A8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F7 = {.cp = 0x2F8F7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F7, .cde = &lxb_unicode_decomposition_c_2F8F7, .kde = &lxb_unicode_decomposition_k_2F8F7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F8[1] = {0x21D0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F8[1] = {0x21D0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F8[1] = {0x21D0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F8 = {.cp = 0x2F8F8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F8, .cde = &lxb_unicode_decomposition_c_2F8F8, .kde = &lxb_unicode_decomposition_k_2F8F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F9[1] = {0x23AFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F9[1] = {0x23AFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F9[1] = {0x23AFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F9 = {.cp = 0x2F8F9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F9, .cde = &lxb_unicode_decomposition_c_2F8F9, .kde = &lxb_unicode_decomposition_k_2F8F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FA[1] = {0x6C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FA[1] = {0x6C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FA[1] = {0x6C4E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FA = {.cp = 0x2F8FA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FA, .cde = &lxb_unicode_decomposition_c_2F8FA, .kde = &lxb_unicode_decomposition_k_2F8FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FB[1] = {0x23CBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FB[1] = {0x23CBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FB[1] = {0x23CBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FB = {.cp = 0x2F8FB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FB, .cde = &lxb_unicode_decomposition_c_2F8FB, .kde = &lxb_unicode_decomposition_k_2F8FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FC[1] = {0x6CBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FC[1] = {0x6CBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FC[1] = {0x6CBF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FC = {.cp = 0x2F8FC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FC, .cde = &lxb_unicode_decomposition_c_2F8FC, .kde = &lxb_unicode_decomposition_k_2F8FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FD[1] = {0x6CCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FD[1] = {0x6CCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FD[1] = {0x6CCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FD = {.cp = 0x2F8FD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FD, .cde = &lxb_unicode_decomposition_c_2F8FD, .kde = &lxb_unicode_decomposition_k_2F8FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FE[1] = {0x6C67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FE[1] = {0x6C67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FE[1] = {0x6C67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FE = {.cp = 0x2F8FE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FE, .cde = &lxb_unicode_decomposition_c_2F8FE, .kde = &lxb_unicode_decomposition_k_2F8FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8FF[1] = {0x6D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F8FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8FF[1] = {0x6D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F8FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8FF[1] = {0x6D16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F8FF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8FF = {.cp = 0x2F8FF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8FF, .cde = &lxb_unicode_decomposition_c_2F8FF, .kde = &lxb_unicode_decomposition_k_2F8FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F900[1] = {0x6D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F900, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F900[1] = {0x6D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F900, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F900[1] = {0x6D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F900 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F900, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F900 = {.cp = 0x2F900, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F900, .cde = &lxb_unicode_decomposition_c_2F900, .kde = &lxb_unicode_decomposition_k_2F900};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F901[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F901, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F901[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F901, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F901[1] = {0x6D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F901 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F901, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F901 = {.cp = 0x2F901, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F901, .cde = &lxb_unicode_decomposition_c_2F901, .kde = &lxb_unicode_decomposition_k_2F901};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F902[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F902, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F902[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F902, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F902[1] = {0x6D41};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F902 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F902, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F902 = {.cp = 0x2F902, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F902, .cde = &lxb_unicode_decomposition_c_2F902, .kde = &lxb_unicode_decomposition_k_2F902};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F903[1] = {0x6D69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F903, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F903[1] = {0x6D69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F903, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F903[1] = {0x6D69};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F903 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F903, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F903 = {.cp = 0x2F903, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F903, .cde = &lxb_unicode_decomposition_c_2F903, .kde = &lxb_unicode_decomposition_k_2F903};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F904[1] = {0x6D78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F904, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F904[1] = {0x6D78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F904, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F904[1] = {0x6D78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F904 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F904, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F904 = {.cp = 0x2F904, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F904, .cde = &lxb_unicode_decomposition_c_2F904, .kde = &lxb_unicode_decomposition_k_2F904};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F905[1] = {0x6D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F905, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F905[1] = {0x6D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F905, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F905[1] = {0x6D85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F905 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F905, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F905 = {.cp = 0x2F905, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F905, .cde = &lxb_unicode_decomposition_c_2F905, .kde = &lxb_unicode_decomposition_k_2F905};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F906[1] = {0x23D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F906, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F906[1] = {0x23D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F906, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F906[1] = {0x23D1E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F906 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F906, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F906 = {.cp = 0x2F906, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F906, .cde = &lxb_unicode_decomposition_c_2F906, .kde = &lxb_unicode_decomposition_k_2F906};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F907[1] = {0x6D34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F907, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F907[1] = {0x6D34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F907, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F907[1] = {0x6D34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F907 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F907, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F907 = {.cp = 0x2F907, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F907, .cde = &lxb_unicode_decomposition_c_2F907, .kde = &lxb_unicode_decomposition_k_2F907};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F908[1] = {0x6E2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F908, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F908[1] = {0x6E2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F908, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F908[1] = {0x6E2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F908 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F908, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F908 = {.cp = 0x2F908, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F908, .cde = &lxb_unicode_decomposition_c_2F908, .kde = &lxb_unicode_decomposition_k_2F908};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F909[1] = {0x6E6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F909, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F909[1] = {0x6E6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F909, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F909[1] = {0x6E6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F909 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F909, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F909 = {.cp = 0x2F909, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F909, .cde = &lxb_unicode_decomposition_c_2F909, .kde = &lxb_unicode_decomposition_k_2F909};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90A[1] = {0x3D33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90A[1] = {0x3D33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90A[1] = {0x3D33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90A = {.cp = 0x2F90A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90A, .cde = &lxb_unicode_decomposition_c_2F90A, .kde = &lxb_unicode_decomposition_k_2F90A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90B[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90B[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90B[1] = {0x6ECB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90B = {.cp = 0x2F90B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90B, .cde = &lxb_unicode_decomposition_c_2F90B, .kde = &lxb_unicode_decomposition_k_2F90B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90C[1] = {0x6EC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90C[1] = {0x6EC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90C[1] = {0x6EC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90C = {.cp = 0x2F90C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90C, .cde = &lxb_unicode_decomposition_c_2F90C, .kde = &lxb_unicode_decomposition_k_2F90C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90D[1] = {0x23ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90D[1] = {0x23ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90D[1] = {0x23ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90D = {.cp = 0x2F90D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90D, .cde = &lxb_unicode_decomposition_c_2F90D, .kde = &lxb_unicode_decomposition_k_2F90D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90E[1] = {0x6DF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90E[1] = {0x6DF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90E[1] = {0x6DF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90E = {.cp = 0x2F90E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90E, .cde = &lxb_unicode_decomposition_c_2F90E, .kde = &lxb_unicode_decomposition_k_2F90E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90F[1] = {0x6F6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F90F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90F[1] = {0x6F6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F90F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90F[1] = {0x6F6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F90F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90F = {.cp = 0x2F90F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90F, .cde = &lxb_unicode_decomposition_c_2F90F, .kde = &lxb_unicode_decomposition_k_2F90F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F910[1] = {0x23F5E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F910, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F910[1] = {0x23F5E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F910, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F910[1] = {0x23F5E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F910 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F910, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F910 = {.cp = 0x2F910, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F910, .cde = &lxb_unicode_decomposition_c_2F910, .kde = &lxb_unicode_decomposition_k_2F910};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F911[1] = {0x23F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F911, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F911[1] = {0x23F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F911, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F911[1] = {0x23F8E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F911 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F911, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F911 = {.cp = 0x2F911, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F911, .cde = &lxb_unicode_decomposition_c_2F911, .kde = &lxb_unicode_decomposition_k_2F911};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F912[1] = {0x6FC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F912, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F912[1] = {0x6FC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F912, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F912[1] = {0x6FC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F912 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F912, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F912 = {.cp = 0x2F912, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F912, .cde = &lxb_unicode_decomposition_c_2F912, .kde = &lxb_unicode_decomposition_k_2F912};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F913[1] = {0x7039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F913, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F913[1] = {0x7039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F913, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F913[1] = {0x7039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F913 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F913, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F913 = {.cp = 0x2F913, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F913, .cde = &lxb_unicode_decomposition_c_2F913, .kde = &lxb_unicode_decomposition_k_2F913};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F914[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F914, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F914[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F914, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F914[1] = {0x701E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F914 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F914, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F914 = {.cp = 0x2F914, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F914, .cde = &lxb_unicode_decomposition_c_2F914, .kde = &lxb_unicode_decomposition_k_2F914};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F915[1] = {0x701B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F915, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F915[1] = {0x701B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F915, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F915[1] = {0x701B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F915 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F915, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F915 = {.cp = 0x2F915, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F915, .cde = &lxb_unicode_decomposition_c_2F915, .kde = &lxb_unicode_decomposition_k_2F915};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F916[1] = {0x3D96};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F916, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F916[1] = {0x3D96};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F916, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F916[1] = {0x3D96};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F916 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F916, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F916 = {.cp = 0x2F916, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F916, .cde = &lxb_unicode_decomposition_c_2F916, .kde = &lxb_unicode_decomposition_k_2F916};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F917[1] = {0x704A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F917, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F917[1] = {0x704A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F917, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F917[1] = {0x704A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F917 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F917, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F917 = {.cp = 0x2F917, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F917, .cde = &lxb_unicode_decomposition_c_2F917, .kde = &lxb_unicode_decomposition_k_2F917};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F918[1] = {0x707D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F918, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F918[1] = {0x707D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F918, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F918[1] = {0x707D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F918 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F918, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F918 = {.cp = 0x2F918, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F918, .cde = &lxb_unicode_decomposition_c_2F918, .kde = &lxb_unicode_decomposition_k_2F918};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F919[1] = {0x7077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F919, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F919[1] = {0x7077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F919, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F919[1] = {0x7077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F919 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F919, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F919 = {.cp = 0x2F919, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F919, .cde = &lxb_unicode_decomposition_c_2F919, .kde = &lxb_unicode_decomposition_k_2F919};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91A[1] = {0x70AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91A[1] = {0x70AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91A[1] = {0x70AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91A = {.cp = 0x2F91A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91A, .cde = &lxb_unicode_decomposition_c_2F91A, .kde = &lxb_unicode_decomposition_k_2F91A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91B[1] = {0x20525};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91B[1] = {0x20525};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91B[1] = {0x20525};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91B = {.cp = 0x2F91B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91B, .cde = &lxb_unicode_decomposition_c_2F91B, .kde = &lxb_unicode_decomposition_k_2F91B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91C[1] = {0x7145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91C[1] = {0x7145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91C[1] = {0x7145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91C = {.cp = 0x2F91C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91C, .cde = &lxb_unicode_decomposition_c_2F91C, .kde = &lxb_unicode_decomposition_k_2F91C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91D[1] = {0x24263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91D[1] = {0x24263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91D[1] = {0x24263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91D = {.cp = 0x2F91D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91D, .cde = &lxb_unicode_decomposition_c_2F91D, .kde = &lxb_unicode_decomposition_k_2F91D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91E[1] = {0x719C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91E[1] = {0x719C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91E[1] = {0x719C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91E = {.cp = 0x2F91E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91E, .cde = &lxb_unicode_decomposition_c_2F91E, .kde = &lxb_unicode_decomposition_k_2F91E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91F[1] = {0x243AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F91F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91F[1] = {0x243AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F91F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91F[1] = {0x243AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F91F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91F = {.cp = 0x2F91F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91F, .cde = &lxb_unicode_decomposition_c_2F91F, .kde = &lxb_unicode_decomposition_k_2F91F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F920[1] = {0x7228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F920, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F920[1] = {0x7228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F920, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F920[1] = {0x7228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F920 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F920, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F920 = {.cp = 0x2F920, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F920, .cde = &lxb_unicode_decomposition_c_2F920, .kde = &lxb_unicode_decomposition_k_2F920};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F921[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F921, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F921[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F921, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F921[1] = {0x7235};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F921 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F921, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F921 = {.cp = 0x2F921, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F921, .cde = &lxb_unicode_decomposition_c_2F921, .kde = &lxb_unicode_decomposition_k_2F921};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F922[1] = {0x7250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F922, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F922[1] = {0x7250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F922, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F922[1] = {0x7250};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F922 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F922, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F922 = {.cp = 0x2F922, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F922, .cde = &lxb_unicode_decomposition_c_2F922, .kde = &lxb_unicode_decomposition_k_2F922};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F923[1] = {0x24608};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F923, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F923[1] = {0x24608};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F923, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F923[1] = {0x24608};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F923 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F923, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F923 = {.cp = 0x2F923, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F923, .cde = &lxb_unicode_decomposition_c_2F923, .kde = &lxb_unicode_decomposition_k_2F923};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F924[1] = {0x7280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F924, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F924[1] = {0x7280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F924, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F924[1] = {0x7280};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F924 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F924, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F924 = {.cp = 0x2F924, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F924, .cde = &lxb_unicode_decomposition_c_2F924, .kde = &lxb_unicode_decomposition_k_2F924};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F925[1] = {0x7295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F925, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F925[1] = {0x7295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F925, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F925[1] = {0x7295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F925 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F925, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F925 = {.cp = 0x2F925, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F925, .cde = &lxb_unicode_decomposition_c_2F925, .kde = &lxb_unicode_decomposition_k_2F925};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F926[1] = {0x24735};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F926, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F926[1] = {0x24735};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F926, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F926[1] = {0x24735};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F926 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F926, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F926 = {.cp = 0x2F926, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F926, .cde = &lxb_unicode_decomposition_c_2F926, .kde = &lxb_unicode_decomposition_k_2F926};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F927[1] = {0x24814};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F927, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F927[1] = {0x24814};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F927, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F927[1] = {0x24814};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F927 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F927, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F927 = {.cp = 0x2F927, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F927, .cde = &lxb_unicode_decomposition_c_2F927, .kde = &lxb_unicode_decomposition_k_2F927};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F928[1] = {0x737A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F928, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F928[1] = {0x737A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F928, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F928[1] = {0x737A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F928 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F928, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F928 = {.cp = 0x2F928, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F928, .cde = &lxb_unicode_decomposition_c_2F928, .kde = &lxb_unicode_decomposition_k_2F928};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F929[1] = {0x738B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F929, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F929[1] = {0x738B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F929, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F929[1] = {0x738B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F929, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F929 = {.cp = 0x2F929, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F929, .cde = &lxb_unicode_decomposition_c_2F929, .kde = &lxb_unicode_decomposition_k_2F929};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92A[1] = {0x3EAC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92A[1] = {0x3EAC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92A[1] = {0x3EAC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92A = {.cp = 0x2F92A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92A, .cde = &lxb_unicode_decomposition_c_2F92A, .kde = &lxb_unicode_decomposition_k_2F92A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92B[1] = {0x73A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92B[1] = {0x73A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92B[1] = {0x73A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92B = {.cp = 0x2F92B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92B, .cde = &lxb_unicode_decomposition_c_2F92B, .kde = &lxb_unicode_decomposition_k_2F92B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92C[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92C[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92C[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92C = {.cp = 0x2F92C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92C, .cde = &lxb_unicode_decomposition_c_2F92C, .kde = &lxb_unicode_decomposition_k_2F92C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92D[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92D[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92D[1] = {0x3EB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92D = {.cp = 0x2F92D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92D, .cde = &lxb_unicode_decomposition_c_2F92D, .kde = &lxb_unicode_decomposition_k_2F92D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92E[1] = {0x7447};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92E[1] = {0x7447};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92E[1] = {0x7447};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92E = {.cp = 0x2F92E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92E, .cde = &lxb_unicode_decomposition_c_2F92E, .kde = &lxb_unicode_decomposition_k_2F92E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92F[1] = {0x745C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F92F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92F[1] = {0x745C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F92F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92F[1] = {0x745C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F92F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92F = {.cp = 0x2F92F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92F, .cde = &lxb_unicode_decomposition_c_2F92F, .kde = &lxb_unicode_decomposition_k_2F92F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F930[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F930, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F930[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F930, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F930[1] = {0x7471};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F930 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F930, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F930 = {.cp = 0x2F930, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F930, .cde = &lxb_unicode_decomposition_c_2F930, .kde = &lxb_unicode_decomposition_k_2F930};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F931[1] = {0x7485};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F931, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F931[1] = {0x7485};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F931, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F931[1] = {0x7485};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F931, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F931 = {.cp = 0x2F931, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F931, .cde = &lxb_unicode_decomposition_c_2F931, .kde = &lxb_unicode_decomposition_k_2F931};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F932[1] = {0x74CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F932, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F932[1] = {0x74CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F932, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F932[1] = {0x74CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F932 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F932, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F932 = {.cp = 0x2F932, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F932, .cde = &lxb_unicode_decomposition_c_2F932, .kde = &lxb_unicode_decomposition_k_2F932};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F933[1] = {0x3F1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F933, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F933[1] = {0x3F1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F933, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F933[1] = {0x3F1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F933 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F933, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F933 = {.cp = 0x2F933, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F933, .cde = &lxb_unicode_decomposition_c_2F933, .kde = &lxb_unicode_decomposition_k_2F933};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F934[1] = {0x7524};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F934, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F934[1] = {0x7524};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F934, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F934[1] = {0x7524};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F934, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F934 = {.cp = 0x2F934, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F934, .cde = &lxb_unicode_decomposition_c_2F934, .kde = &lxb_unicode_decomposition_k_2F934};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F935[1] = {0x24C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F935, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F935[1] = {0x24C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F935, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F935[1] = {0x24C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F935 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F935, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F935 = {.cp = 0x2F935, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F935, .cde = &lxb_unicode_decomposition_c_2F935, .kde = &lxb_unicode_decomposition_k_2F935};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F936[1] = {0x753E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F936, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F936[1] = {0x753E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F936, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F936[1] = {0x753E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F936 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F936, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F936 = {.cp = 0x2F936, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F936, .cde = &lxb_unicode_decomposition_c_2F936, .kde = &lxb_unicode_decomposition_k_2F936};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F937[1] = {0x24C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F937, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F937[1] = {0x24C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F937, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F937[1] = {0x24C92};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F937 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F937, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F937 = {.cp = 0x2F937, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F937, .cde = &lxb_unicode_decomposition_c_2F937, .kde = &lxb_unicode_decomposition_k_2F937};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F938[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F938, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F938[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F938, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F938[1] = {0x7570};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F938 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F938, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F938 = {.cp = 0x2F938, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F938, .cde = &lxb_unicode_decomposition_c_2F938, .kde = &lxb_unicode_decomposition_k_2F938};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F939[1] = {0x2219F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F939, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F939[1] = {0x2219F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F939, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F939[1] = {0x2219F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F939 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F939, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F939 = {.cp = 0x2F939, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F939, .cde = &lxb_unicode_decomposition_c_2F939, .kde = &lxb_unicode_decomposition_k_2F939};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93A[1] = {0x7610};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93A[1] = {0x7610};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93A[1] = {0x7610};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93A = {.cp = 0x2F93A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93A, .cde = &lxb_unicode_decomposition_c_2F93A, .kde = &lxb_unicode_decomposition_k_2F93A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93B[1] = {0x24FA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93B[1] = {0x24FA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93B[1] = {0x24FA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93B = {.cp = 0x2F93B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93B, .cde = &lxb_unicode_decomposition_c_2F93B, .kde = &lxb_unicode_decomposition_k_2F93B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93C[1] = {0x24FB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93C[1] = {0x24FB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93C[1] = {0x24FB8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93C = {.cp = 0x2F93C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93C, .cde = &lxb_unicode_decomposition_c_2F93C, .kde = &lxb_unicode_decomposition_k_2F93C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93D[1] = {0x25044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93D[1] = {0x25044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93D[1] = {0x25044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93D = {.cp = 0x2F93D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93D, .cde = &lxb_unicode_decomposition_c_2F93D, .kde = &lxb_unicode_decomposition_k_2F93D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93E[1] = {0x3FFC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93E[1] = {0x3FFC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93E[1] = {0x3FFC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93E = {.cp = 0x2F93E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93E, .cde = &lxb_unicode_decomposition_c_2F93E, .kde = &lxb_unicode_decomposition_k_2F93E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93F[1] = {0x4008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F93F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93F[1] = {0x4008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F93F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93F[1] = {0x4008};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F93F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93F = {.cp = 0x2F93F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93F, .cde = &lxb_unicode_decomposition_c_2F93F, .kde = &lxb_unicode_decomposition_k_2F93F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F940[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F940, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F940[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F940, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F940[1] = {0x76F4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F940 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F940, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F940 = {.cp = 0x2F940, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F940, .cde = &lxb_unicode_decomposition_c_2F940, .kde = &lxb_unicode_decomposition_k_2F940};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F941[1] = {0x250F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F941, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F941[1] = {0x250F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F941, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F941[1] = {0x250F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F941 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F941, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F941 = {.cp = 0x2F941, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F941, .cde = &lxb_unicode_decomposition_c_2F941, .kde = &lxb_unicode_decomposition_k_2F941};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F942[1] = {0x250F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F942, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F942[1] = {0x250F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F942, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F942[1] = {0x250F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F942 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F942, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F942 = {.cp = 0x2F942, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F942, .cde = &lxb_unicode_decomposition_c_2F942, .kde = &lxb_unicode_decomposition_k_2F942};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F943[1] = {0x25119};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F943, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F943[1] = {0x25119};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F943, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F943[1] = {0x25119};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F943 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F943, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F943 = {.cp = 0x2F943, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F943, .cde = &lxb_unicode_decomposition_c_2F943, .kde = &lxb_unicode_decomposition_k_2F943};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F944[1] = {0x25133};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F944, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F944[1] = {0x25133};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F944, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F944[1] = {0x25133};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F944 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F944, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F944 = {.cp = 0x2F944, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F944, .cde = &lxb_unicode_decomposition_c_2F944, .kde = &lxb_unicode_decomposition_k_2F944};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F945[1] = {0x771E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F945, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F945[1] = {0x771E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F945, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F945[1] = {0x771E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F945 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F945, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F945 = {.cp = 0x2F945, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F945, .cde = &lxb_unicode_decomposition_c_2F945, .kde = &lxb_unicode_decomposition_k_2F945};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F946[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F946, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F946[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F946, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F946[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F946 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F946, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F946 = {.cp = 0x2F946, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F946, .cde = &lxb_unicode_decomposition_c_2F946, .kde = &lxb_unicode_decomposition_k_2F946};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F947[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F947, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F947[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F947, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F947[1] = {0x771F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F947 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F947, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F947 = {.cp = 0x2F947, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F947, .cde = &lxb_unicode_decomposition_c_2F947, .kde = &lxb_unicode_decomposition_k_2F947};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F948[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F948, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F948[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F948, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F948[1] = {0x774A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F948 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F948, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F948 = {.cp = 0x2F948, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F948, .cde = &lxb_unicode_decomposition_c_2F948, .kde = &lxb_unicode_decomposition_k_2F948};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F949[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F949, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F949[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F949, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F949[1] = {0x4039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F949 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F949, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F949 = {.cp = 0x2F949, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F949, .cde = &lxb_unicode_decomposition_c_2F949, .kde = &lxb_unicode_decomposition_k_2F949};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94A[1] = {0x778B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94A[1] = {0x778B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94A[1] = {0x778B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94A = {.cp = 0x2F94A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94A, .cde = &lxb_unicode_decomposition_c_2F94A, .kde = &lxb_unicode_decomposition_k_2F94A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94B[1] = {0x4046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94B[1] = {0x4046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94B[1] = {0x4046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94B = {.cp = 0x2F94B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94B, .cde = &lxb_unicode_decomposition_c_2F94B, .kde = &lxb_unicode_decomposition_k_2F94B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94C[1] = {0x4096};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94C[1] = {0x4096};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94C[1] = {0x4096};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94C = {.cp = 0x2F94C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94C, .cde = &lxb_unicode_decomposition_c_2F94C, .kde = &lxb_unicode_decomposition_k_2F94C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94D[1] = {0x2541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94D[1] = {0x2541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94D[1] = {0x2541D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94D = {.cp = 0x2F94D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94D, .cde = &lxb_unicode_decomposition_c_2F94D, .kde = &lxb_unicode_decomposition_k_2F94D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94E[1] = {0x784E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94E[1] = {0x784E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94E[1] = {0x784E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94E = {.cp = 0x2F94E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94E, .cde = &lxb_unicode_decomposition_c_2F94E, .kde = &lxb_unicode_decomposition_k_2F94E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94F[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F94F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94F[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F94F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94F[1] = {0x788C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F94F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94F = {.cp = 0x2F94F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94F, .cde = &lxb_unicode_decomposition_c_2F94F, .kde = &lxb_unicode_decomposition_k_2F94F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F950[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F950, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F950[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F950, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F950[1] = {0x78CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F950 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F950, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F950 = {.cp = 0x2F950, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F950, .cde = &lxb_unicode_decomposition_c_2F950, .kde = &lxb_unicode_decomposition_k_2F950};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F951[1] = {0x40E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F951, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F951[1] = {0x40E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F951, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F951[1] = {0x40E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F951 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F951, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F951 = {.cp = 0x2F951, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F951, .cde = &lxb_unicode_decomposition_c_2F951, .kde = &lxb_unicode_decomposition_k_2F951};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F952[1] = {0x25626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F952, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F952[1] = {0x25626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F952, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F952[1] = {0x25626};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F952 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F952, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F952 = {.cp = 0x2F952, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F952, .cde = &lxb_unicode_decomposition_c_2F952, .kde = &lxb_unicode_decomposition_k_2F952};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F953[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F953, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F953[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F953, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F953[1] = {0x7956};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F953 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F953, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F953 = {.cp = 0x2F953, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F953, .cde = &lxb_unicode_decomposition_c_2F953, .kde = &lxb_unicode_decomposition_k_2F953};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F954[1] = {0x2569A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F954, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F954[1] = {0x2569A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F954, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F954[1] = {0x2569A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F954 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F954, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F954 = {.cp = 0x2F954, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F954, .cde = &lxb_unicode_decomposition_c_2F954, .kde = &lxb_unicode_decomposition_k_2F954};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F955[1] = {0x256C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F955, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F955[1] = {0x256C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F955, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F955[1] = {0x256C5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F955 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F955, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F955 = {.cp = 0x2F955, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F955, .cde = &lxb_unicode_decomposition_c_2F955, .kde = &lxb_unicode_decomposition_k_2F955};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F956[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F956, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F956[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F956, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F956[1] = {0x798F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F956 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F956, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F956 = {.cp = 0x2F956, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F956, .cde = &lxb_unicode_decomposition_c_2F956, .kde = &lxb_unicode_decomposition_k_2F956};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F957[1] = {0x79EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F957, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F957[1] = {0x79EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F957, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F957[1] = {0x79EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F957 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F957, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F957 = {.cp = 0x2F957, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F957, .cde = &lxb_unicode_decomposition_c_2F957, .kde = &lxb_unicode_decomposition_k_2F957};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F958[1] = {0x412F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F958, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F958[1] = {0x412F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F958, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F958[1] = {0x412F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F958, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F958 = {.cp = 0x2F958, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F958, .cde = &lxb_unicode_decomposition_c_2F958, .kde = &lxb_unicode_decomposition_k_2F958};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F959[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F959, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F959[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F959, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F959[1] = {0x7A40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F959, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F959 = {.cp = 0x2F959, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F959, .cde = &lxb_unicode_decomposition_c_2F959, .kde = &lxb_unicode_decomposition_k_2F959};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95A[1] = {0x7A4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95A[1] = {0x7A4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95A[1] = {0x7A4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95A = {.cp = 0x2F95A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95A, .cde = &lxb_unicode_decomposition_c_2F95A, .kde = &lxb_unicode_decomposition_k_2F95A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95B[1] = {0x7A4F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95B[1] = {0x7A4F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95B[1] = {0x7A4F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95B = {.cp = 0x2F95B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95B, .cde = &lxb_unicode_decomposition_c_2F95B, .kde = &lxb_unicode_decomposition_k_2F95B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95C[1] = {0x2597C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95C[1] = {0x2597C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95C[1] = {0x2597C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95C = {.cp = 0x2F95C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95C, .cde = &lxb_unicode_decomposition_c_2F95C, .kde = &lxb_unicode_decomposition_k_2F95C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95D[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95D[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95D[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95D = {.cp = 0x2F95D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95D, .cde = &lxb_unicode_decomposition_c_2F95D, .kde = &lxb_unicode_decomposition_k_2F95D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95E[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95E[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95E[1] = {0x25AA7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95E = {.cp = 0x2F95E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95E, .cde = &lxb_unicode_decomposition_c_2F95E, .kde = &lxb_unicode_decomposition_k_2F95E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95F[1] = {0x7AEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F95F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95F[1] = {0x7AEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F95F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95F[1] = {0x7AEE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F95F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95F = {.cp = 0x2F95F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95F, .cde = &lxb_unicode_decomposition_c_2F95F, .kde = &lxb_unicode_decomposition_k_2F95F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F960[1] = {0x4202};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F960, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F960[1] = {0x4202};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F960, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F960[1] = {0x4202};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F960 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F960, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F960 = {.cp = 0x2F960, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F960, .cde = &lxb_unicode_decomposition_c_2F960, .kde = &lxb_unicode_decomposition_k_2F960};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F961[1] = {0x25BAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F961, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F961[1] = {0x25BAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F961, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F961[1] = {0x25BAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F961 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F961, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F961 = {.cp = 0x2F961, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F961, .cde = &lxb_unicode_decomposition_c_2F961, .kde = &lxb_unicode_decomposition_k_2F961};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F962[1] = {0x7BC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F962, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F962[1] = {0x7BC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F962, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F962[1] = {0x7BC6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F962 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F962, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F962 = {.cp = 0x2F962, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F962, .cde = &lxb_unicode_decomposition_c_2F962, .kde = &lxb_unicode_decomposition_k_2F962};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F963[1] = {0x7BC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F963, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F963[1] = {0x7BC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F963, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F963[1] = {0x7BC9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F963 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F963, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F963 = {.cp = 0x2F963, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F963, .cde = &lxb_unicode_decomposition_c_2F963, .kde = &lxb_unicode_decomposition_k_2F963};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F964[1] = {0x4227};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F964, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F964[1] = {0x4227};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F964, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F964[1] = {0x4227};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F964 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F964, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F964 = {.cp = 0x2F964, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F964, .cde = &lxb_unicode_decomposition_c_2F964, .kde = &lxb_unicode_decomposition_k_2F964};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F965[1] = {0x25C80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F965, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F965[1] = {0x25C80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F965, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F965[1] = {0x25C80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F965 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F965, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F965 = {.cp = 0x2F965, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F965, .cde = &lxb_unicode_decomposition_c_2F965, .kde = &lxb_unicode_decomposition_k_2F965};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F966[1] = {0x7CD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F966, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F966[1] = {0x7CD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F966, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F966[1] = {0x7CD2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F966 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F966, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F966 = {.cp = 0x2F966, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F966, .cde = &lxb_unicode_decomposition_c_2F966, .kde = &lxb_unicode_decomposition_k_2F966};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F967[1] = {0x42A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F967, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F967[1] = {0x42A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F967, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F967[1] = {0x42A0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F967 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F967, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F967 = {.cp = 0x2F967, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F967, .cde = &lxb_unicode_decomposition_c_2F967, .kde = &lxb_unicode_decomposition_k_2F967};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F968[1] = {0x7CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F968, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F968[1] = {0x7CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F968, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F968[1] = {0x7CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F968 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F968, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F968 = {.cp = 0x2F968, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F968, .cde = &lxb_unicode_decomposition_c_2F968, .kde = &lxb_unicode_decomposition_k_2F968};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F969[1] = {0x7CE3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F969, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F969[1] = {0x7CE3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F969, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F969[1] = {0x7CE3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F969 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F969, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F969 = {.cp = 0x2F969, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F969, .cde = &lxb_unicode_decomposition_c_2F969, .kde = &lxb_unicode_decomposition_k_2F969};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96A[1] = {0x7D00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96A[1] = {0x7D00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96A[1] = {0x7D00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96A = {.cp = 0x2F96A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96A, .cde = &lxb_unicode_decomposition_c_2F96A, .kde = &lxb_unicode_decomposition_k_2F96A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96B[1] = {0x25F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96B[1] = {0x25F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96B[1] = {0x25F86};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96B = {.cp = 0x2F96B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96B, .cde = &lxb_unicode_decomposition_c_2F96B, .kde = &lxb_unicode_decomposition_k_2F96B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96C[1] = {0x7D63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96C[1] = {0x7D63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96C[1] = {0x7D63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96C = {.cp = 0x2F96C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96C, .cde = &lxb_unicode_decomposition_c_2F96C, .kde = &lxb_unicode_decomposition_k_2F96C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96D[1] = {0x4301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96D[1] = {0x4301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96D[1] = {0x4301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96D = {.cp = 0x2F96D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96D, .cde = &lxb_unicode_decomposition_c_2F96D, .kde = &lxb_unicode_decomposition_k_2F96D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96E[1] = {0x7DC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96E[1] = {0x7DC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96E[1] = {0x7DC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96E = {.cp = 0x2F96E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96E, .cde = &lxb_unicode_decomposition_c_2F96E, .kde = &lxb_unicode_decomposition_k_2F96E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96F[1] = {0x7E02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F96F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96F[1] = {0x7E02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F96F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96F[1] = {0x7E02};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F96F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96F = {.cp = 0x2F96F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96F, .cde = &lxb_unicode_decomposition_c_2F96F, .kde = &lxb_unicode_decomposition_k_2F96F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F970[1] = {0x7E45};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F970, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F970[1] = {0x7E45};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F970, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F970[1] = {0x7E45};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F970 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F970, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F970 = {.cp = 0x2F970, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F970, .cde = &lxb_unicode_decomposition_c_2F970, .kde = &lxb_unicode_decomposition_k_2F970};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F971[1] = {0x4334};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F971, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F971[1] = {0x4334};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F971, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F971[1] = {0x4334};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F971 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F971, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F971 = {.cp = 0x2F971, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F971, .cde = &lxb_unicode_decomposition_c_2F971, .kde = &lxb_unicode_decomposition_k_2F971};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F972[1] = {0x26228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F972, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F972[1] = {0x26228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F972, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F972[1] = {0x26228};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F972 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F972, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F972 = {.cp = 0x2F972, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F972, .cde = &lxb_unicode_decomposition_c_2F972, .kde = &lxb_unicode_decomposition_k_2F972};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F973[1] = {0x26247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F973, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F973[1] = {0x26247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F973, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F973[1] = {0x26247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F973 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F973, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F973 = {.cp = 0x2F973, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F973, .cde = &lxb_unicode_decomposition_c_2F973, .kde = &lxb_unicode_decomposition_k_2F973};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F974[1] = {0x4359};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F974, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F974[1] = {0x4359};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F974, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F974[1] = {0x4359};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F974 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F974, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F974 = {.cp = 0x2F974, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F974, .cde = &lxb_unicode_decomposition_c_2F974, .kde = &lxb_unicode_decomposition_k_2F974};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F975[1] = {0x262D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F975, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F975[1] = {0x262D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F975, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F975[1] = {0x262D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F975 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F975, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F975 = {.cp = 0x2F975, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F975, .cde = &lxb_unicode_decomposition_c_2F975, .kde = &lxb_unicode_decomposition_k_2F975};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F976[1] = {0x7F7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F976, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F976[1] = {0x7F7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F976, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F976[1] = {0x7F7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F976 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F976, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F976 = {.cp = 0x2F976, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F976, .cde = &lxb_unicode_decomposition_c_2F976, .kde = &lxb_unicode_decomposition_k_2F976};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F977[1] = {0x2633E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F977, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F977[1] = {0x2633E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F977, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F977[1] = {0x2633E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F977 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F977, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F977 = {.cp = 0x2F977, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F977, .cde = &lxb_unicode_decomposition_c_2F977, .kde = &lxb_unicode_decomposition_k_2F977};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F978[1] = {0x7F95};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F978, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F978[1] = {0x7F95};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F978, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F978[1] = {0x7F95};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F978 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F978, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F978 = {.cp = 0x2F978, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F978, .cde = &lxb_unicode_decomposition_c_2F978, .kde = &lxb_unicode_decomposition_k_2F978};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F979[1] = {0x7FFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F979, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F979[1] = {0x7FFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F979, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F979[1] = {0x7FFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F979 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F979, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F979 = {.cp = 0x2F979, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F979, .cde = &lxb_unicode_decomposition_c_2F979, .kde = &lxb_unicode_decomposition_k_2F979};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97A[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97A[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97A[1] = {0x8005};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97A = {.cp = 0x2F97A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97A, .cde = &lxb_unicode_decomposition_c_2F97A, .kde = &lxb_unicode_decomposition_k_2F97A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97B[1] = {0x264DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97B[1] = {0x264DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97B[1] = {0x264DA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97B = {.cp = 0x2F97B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97B, .cde = &lxb_unicode_decomposition_c_2F97B, .kde = &lxb_unicode_decomposition_k_2F97B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97C[1] = {0x26523};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97C[1] = {0x26523};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97C[1] = {0x26523};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97C = {.cp = 0x2F97C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97C, .cde = &lxb_unicode_decomposition_c_2F97C, .kde = &lxb_unicode_decomposition_k_2F97C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97D[1] = {0x8060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97D[1] = {0x8060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97D[1] = {0x8060};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97D = {.cp = 0x2F97D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97D, .cde = &lxb_unicode_decomposition_c_2F97D, .kde = &lxb_unicode_decomposition_k_2F97D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97E[1] = {0x265A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97E[1] = {0x265A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97E[1] = {0x265A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97E = {.cp = 0x2F97E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97E, .cde = &lxb_unicode_decomposition_c_2F97E, .kde = &lxb_unicode_decomposition_k_2F97E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97F[1] = {0x8070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F97F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97F[1] = {0x8070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F97F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97F[1] = {0x8070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F97F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97F = {.cp = 0x2F97F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97F, .cde = &lxb_unicode_decomposition_c_2F97F, .kde = &lxb_unicode_decomposition_k_2F97F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F980[1] = {0x2335F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F980, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F980[1] = {0x2335F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F980, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F980[1] = {0x2335F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F980 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F980, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F980 = {.cp = 0x2F980, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F980, .cde = &lxb_unicode_decomposition_c_2F980, .kde = &lxb_unicode_decomposition_k_2F980};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F981[1] = {0x43D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F981, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F981[1] = {0x43D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F981, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F981[1] = {0x43D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F981 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F981, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F981 = {.cp = 0x2F981, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F981, .cde = &lxb_unicode_decomposition_c_2F981, .kde = &lxb_unicode_decomposition_k_2F981};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F982[1] = {0x80B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F982, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F982[1] = {0x80B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F982, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F982[1] = {0x80B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F982 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F982, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F982 = {.cp = 0x2F982, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F982, .cde = &lxb_unicode_decomposition_c_2F982, .kde = &lxb_unicode_decomposition_k_2F982};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F983[1] = {0x8103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F983, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F983[1] = {0x8103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F983, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F983[1] = {0x8103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F983 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F983, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F983 = {.cp = 0x2F983, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F983, .cde = &lxb_unicode_decomposition_c_2F983, .kde = &lxb_unicode_decomposition_k_2F983};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F984[1] = {0x440B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F984, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F984[1] = {0x440B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F984, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F984[1] = {0x440B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F984 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F984, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F984 = {.cp = 0x2F984, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F984, .cde = &lxb_unicode_decomposition_c_2F984, .kde = &lxb_unicode_decomposition_k_2F984};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F985[1] = {0x813E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F985, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F985[1] = {0x813E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F985, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F985[1] = {0x813E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F985 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F985, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F985 = {.cp = 0x2F985, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F985, .cde = &lxb_unicode_decomposition_c_2F985, .kde = &lxb_unicode_decomposition_k_2F985};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F986[1] = {0x5AB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F986, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F986[1] = {0x5AB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F986, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F986[1] = {0x5AB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F986 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F986, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F986 = {.cp = 0x2F986, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F986, .cde = &lxb_unicode_decomposition_c_2F986, .kde = &lxb_unicode_decomposition_k_2F986};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F987[1] = {0x267A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F987, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F987[1] = {0x267A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F987, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F987[1] = {0x267A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F987 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F987, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F987 = {.cp = 0x2F987, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F987, .cde = &lxb_unicode_decomposition_c_2F987, .kde = &lxb_unicode_decomposition_k_2F987};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F988[1] = {0x267B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F988, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F988[1] = {0x267B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F988, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F988[1] = {0x267B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F988 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F988, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F988 = {.cp = 0x2F988, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F988, .cde = &lxb_unicode_decomposition_c_2F988, .kde = &lxb_unicode_decomposition_k_2F988};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F989[1] = {0x23393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F989, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F989[1] = {0x23393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F989, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F989[1] = {0x23393};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F989 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F989, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F989 = {.cp = 0x2F989, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F989, .cde = &lxb_unicode_decomposition_c_2F989, .kde = &lxb_unicode_decomposition_k_2F989};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98A[1] = {0x2339C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98A[1] = {0x2339C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98A[1] = {0x2339C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98A = {.cp = 0x2F98A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98A, .cde = &lxb_unicode_decomposition_c_2F98A, .kde = &lxb_unicode_decomposition_k_2F98A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98B[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98B[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98B[1] = {0x8201};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98B = {.cp = 0x2F98B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98B, .cde = &lxb_unicode_decomposition_c_2F98B, .kde = &lxb_unicode_decomposition_k_2F98B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98C[1] = {0x8204};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98C[1] = {0x8204};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98C[1] = {0x8204};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98C = {.cp = 0x2F98C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98C, .cde = &lxb_unicode_decomposition_c_2F98C, .kde = &lxb_unicode_decomposition_k_2F98C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98D[1] = {0x8F9E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98D[1] = {0x8F9E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98D[1] = {0x8F9E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98D = {.cp = 0x2F98D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98D, .cde = &lxb_unicode_decomposition_c_2F98D, .kde = &lxb_unicode_decomposition_k_2F98D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98E[1] = {0x446B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98E[1] = {0x446B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98E[1] = {0x446B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98E = {.cp = 0x2F98E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98E, .cde = &lxb_unicode_decomposition_c_2F98E, .kde = &lxb_unicode_decomposition_k_2F98E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98F[1] = {0x8291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F98F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98F[1] = {0x8291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F98F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98F[1] = {0x8291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F98F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98F = {.cp = 0x2F98F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98F, .cde = &lxb_unicode_decomposition_c_2F98F, .kde = &lxb_unicode_decomposition_k_2F98F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F990[1] = {0x828B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F990, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F990[1] = {0x828B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F990, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F990[1] = {0x828B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F990 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F990, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F990 = {.cp = 0x2F990, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F990, .cde = &lxb_unicode_decomposition_c_2F990, .kde = &lxb_unicode_decomposition_k_2F990};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F991[1] = {0x829D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F991, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F991[1] = {0x829D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F991, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F991[1] = {0x829D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F991 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F991, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F991 = {.cp = 0x2F991, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F991, .cde = &lxb_unicode_decomposition_c_2F991, .kde = &lxb_unicode_decomposition_k_2F991};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F992[1] = {0x52B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F992, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F992[1] = {0x52B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F992, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F992[1] = {0x52B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F992 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F992, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F992 = {.cp = 0x2F992, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F992, .cde = &lxb_unicode_decomposition_c_2F992, .kde = &lxb_unicode_decomposition_k_2F992};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F993[1] = {0x82B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F993, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F993[1] = {0x82B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F993, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F993[1] = {0x82B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F993 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F993, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F993 = {.cp = 0x2F993, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F993, .cde = &lxb_unicode_decomposition_c_2F993, .kde = &lxb_unicode_decomposition_k_2F993};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F994[1] = {0x82B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F994, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F994[1] = {0x82B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F994, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F994[1] = {0x82B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F994 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F994, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F994 = {.cp = 0x2F994, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F994, .cde = &lxb_unicode_decomposition_c_2F994, .kde = &lxb_unicode_decomposition_k_2F994};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F995[1] = {0x82BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F995, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F995[1] = {0x82BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F995, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F995[1] = {0x82BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F995 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F995, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F995 = {.cp = 0x2F995, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F995, .cde = &lxb_unicode_decomposition_c_2F995, .kde = &lxb_unicode_decomposition_k_2F995};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F996[1] = {0x82E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F996, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F996[1] = {0x82E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F996, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F996[1] = {0x82E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F996 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F996, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F996 = {.cp = 0x2F996, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F996, .cde = &lxb_unicode_decomposition_c_2F996, .kde = &lxb_unicode_decomposition_k_2F996};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F997[1] = {0x26B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F997, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F997[1] = {0x26B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F997, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F997[1] = {0x26B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F997 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F997, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F997 = {.cp = 0x2F997, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F997, .cde = &lxb_unicode_decomposition_c_2F997, .kde = &lxb_unicode_decomposition_k_2F997};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F998[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F998, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F998[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F998, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F998[1] = {0x82E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F998 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F998, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F998 = {.cp = 0x2F998, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F998, .cde = &lxb_unicode_decomposition_c_2F998, .kde = &lxb_unicode_decomposition_k_2F998};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F999[1] = {0x831D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F999, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F999[1] = {0x831D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F999, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F999[1] = {0x831D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F999 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F999, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F999 = {.cp = 0x2F999, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F999, .cde = &lxb_unicode_decomposition_c_2F999, .kde = &lxb_unicode_decomposition_k_2F999};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99A[1] = {0x8363};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99A[1] = {0x8363};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99A[1] = {0x8363};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99A = {.cp = 0x2F99A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99A, .cde = &lxb_unicode_decomposition_c_2F99A, .kde = &lxb_unicode_decomposition_k_2F99A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99B[1] = {0x83AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99B[1] = {0x83AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99B[1] = {0x83AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99B = {.cp = 0x2F99B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99B, .cde = &lxb_unicode_decomposition_c_2F99B, .kde = &lxb_unicode_decomposition_k_2F99B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99C[1] = {0x8323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99C[1] = {0x8323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99C[1] = {0x8323};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99C = {.cp = 0x2F99C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99C, .cde = &lxb_unicode_decomposition_c_2F99C, .kde = &lxb_unicode_decomposition_k_2F99C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99D[1] = {0x83BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99D[1] = {0x83BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99D[1] = {0x83BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99D = {.cp = 0x2F99D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99D, .cde = &lxb_unicode_decomposition_c_2F99D, .kde = &lxb_unicode_decomposition_k_2F99D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99E[1] = {0x83E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99E[1] = {0x83E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99E[1] = {0x83E7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99E = {.cp = 0x2F99E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99E, .cde = &lxb_unicode_decomposition_c_2F99E, .kde = &lxb_unicode_decomposition_k_2F99E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F99F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F99F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99F[1] = {0x8457};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F99F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99F = {.cp = 0x2F99F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99F, .cde = &lxb_unicode_decomposition_c_2F99F, .kde = &lxb_unicode_decomposition_k_2F99F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A0[1] = {0x8353};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A0[1] = {0x8353};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A0[1] = {0x8353};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A0 = {.cp = 0x2F9A0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A0, .cde = &lxb_unicode_decomposition_c_2F9A0, .kde = &lxb_unicode_decomposition_k_2F9A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A1[1] = {0x83CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A1[1] = {0x83CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A1[1] = {0x83CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A1 = {.cp = 0x2F9A1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A1, .cde = &lxb_unicode_decomposition_c_2F9A1, .kde = &lxb_unicode_decomposition_k_2F9A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A2[1] = {0x83CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A2[1] = {0x83CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A2[1] = {0x83CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A2 = {.cp = 0x2F9A2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A2, .cde = &lxb_unicode_decomposition_c_2F9A2, .kde = &lxb_unicode_decomposition_k_2F9A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A3[1] = {0x83DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A3[1] = {0x83DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A3[1] = {0x83DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A3 = {.cp = 0x2F9A3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A3, .cde = &lxb_unicode_decomposition_c_2F9A3, .kde = &lxb_unicode_decomposition_k_2F9A3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A4[1] = {0x26C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A4[1] = {0x26C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A4[1] = {0x26C36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A4 = {.cp = 0x2F9A4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A4, .cde = &lxb_unicode_decomposition_c_2F9A4, .kde = &lxb_unicode_decomposition_k_2F9A4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A5[1] = {0x26D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A5[1] = {0x26D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A5[1] = {0x26D6B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A5 = {.cp = 0x2F9A5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A5, .cde = &lxb_unicode_decomposition_c_2F9A5, .kde = &lxb_unicode_decomposition_k_2F9A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A6[1] = {0x26CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A6[1] = {0x26CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A6[1] = {0x26CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A6 = {.cp = 0x2F9A6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A6, .cde = &lxb_unicode_decomposition_c_2F9A6, .kde = &lxb_unicode_decomposition_k_2F9A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A7[1] = {0x452B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A7[1] = {0x452B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A7[1] = {0x452B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A7 = {.cp = 0x2F9A7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A7, .cde = &lxb_unicode_decomposition_c_2F9A7, .kde = &lxb_unicode_decomposition_k_2F9A7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A8[1] = {0x84F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A8[1] = {0x84F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A8[1] = {0x84F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A8 = {.cp = 0x2F9A8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A8, .cde = &lxb_unicode_decomposition_c_2F9A8, .kde = &lxb_unicode_decomposition_k_2F9A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A9[1] = {0x84F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A9[1] = {0x84F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A9[1] = {0x84F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A9 = {.cp = 0x2F9A9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A9, .cde = &lxb_unicode_decomposition_c_2F9A9, .kde = &lxb_unicode_decomposition_k_2F9A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AA[1] = {0x8516};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AA[1] = {0x8516};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AA[1] = {0x8516};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AA = {.cp = 0x2F9AA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AA, .cde = &lxb_unicode_decomposition_c_2F9AA, .kde = &lxb_unicode_decomposition_k_2F9AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AB[1] = {0x273CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AB[1] = {0x273CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AB[1] = {0x273CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AB = {.cp = 0x2F9AB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AB, .cde = &lxb_unicode_decomposition_c_2F9AB, .kde = &lxb_unicode_decomposition_k_2F9AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AC[1] = {0x8564};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AC[1] = {0x8564};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AC[1] = {0x8564};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AC = {.cp = 0x2F9AC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AC, .cde = &lxb_unicode_decomposition_c_2F9AC, .kde = &lxb_unicode_decomposition_k_2F9AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AD[1] = {0x26F2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AD[1] = {0x26F2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AD[1] = {0x26F2C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AD = {.cp = 0x2F9AD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AD, .cde = &lxb_unicode_decomposition_c_2F9AD, .kde = &lxb_unicode_decomposition_k_2F9AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AE[1] = {0x455D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AE[1] = {0x455D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AE[1] = {0x455D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AE = {.cp = 0x2F9AE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AE, .cde = &lxb_unicode_decomposition_c_2F9AE, .kde = &lxb_unicode_decomposition_k_2F9AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9AF[1] = {0x4561};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9AF[1] = {0x4561};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9AF[1] = {0x4561};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9AF = {.cp = 0x2F9AF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9AF, .cde = &lxb_unicode_decomposition_c_2F9AF, .kde = &lxb_unicode_decomposition_k_2F9AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B0[1] = {0x26FB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B0[1] = {0x26FB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B0[1] = {0x26FB1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B0 = {.cp = 0x2F9B0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B0, .cde = &lxb_unicode_decomposition_c_2F9B0, .kde = &lxb_unicode_decomposition_k_2F9B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B1[1] = {0x270D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B1[1] = {0x270D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B1[1] = {0x270D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B1 = {.cp = 0x2F9B1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B1, .cde = &lxb_unicode_decomposition_c_2F9B1, .kde = &lxb_unicode_decomposition_k_2F9B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B2[1] = {0x456B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B2[1] = {0x456B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B2[1] = {0x456B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B2 = {.cp = 0x2F9B2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B2, .cde = &lxb_unicode_decomposition_c_2F9B2, .kde = &lxb_unicode_decomposition_k_2F9B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B3[1] = {0x8650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B3[1] = {0x8650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B3[1] = {0x8650};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B3 = {.cp = 0x2F9B3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B3, .cde = &lxb_unicode_decomposition_c_2F9B3, .kde = &lxb_unicode_decomposition_k_2F9B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B4[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B4[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B4[1] = {0x865C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B4 = {.cp = 0x2F9B4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B4, .cde = &lxb_unicode_decomposition_c_2F9B4, .kde = &lxb_unicode_decomposition_k_2F9B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B5[1] = {0x8667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B5[1] = {0x8667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B5[1] = {0x8667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B5 = {.cp = 0x2F9B5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B5, .cde = &lxb_unicode_decomposition_c_2F9B5, .kde = &lxb_unicode_decomposition_k_2F9B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B6[1] = {0x8669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B6[1] = {0x8669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B6[1] = {0x8669};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B6 = {.cp = 0x2F9B6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B6, .cde = &lxb_unicode_decomposition_c_2F9B6, .kde = &lxb_unicode_decomposition_k_2F9B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B7[1] = {0x86A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B7[1] = {0x86A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B7[1] = {0x86A9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B7 = {.cp = 0x2F9B7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B7, .cde = &lxb_unicode_decomposition_c_2F9B7, .kde = &lxb_unicode_decomposition_k_2F9B7};
static const lxb_unicode_data_t lxb_unicode_data_2F800 = {&lxb_unicode_entry_2F800, &lxb_unicode_idna_map_2F800};
static const lxb_unicode_data_t lxb_unicode_data_2F801 = {&lxb_unicode_entry_2F801, &lxb_unicode_idna_map_2F801};
static const lxb_unicode_data_t lxb_unicode_data_2F802 = {&lxb_unicode_entry_2F802, &lxb_unicode_idna_map_2F802};
static const lxb_unicode_data_t lxb_unicode_data_2F803 = {&lxb_unicode_entry_2F803, &lxb_unicode_idna_map_2F803};
static const lxb_unicode_data_t lxb_unicode_data_2F804 = {&lxb_unicode_entry_2F804, &lxb_unicode_idna_map_2F804};
static const lxb_unicode_data_t lxb_unicode_data_2F805 = {&lxb_unicode_entry_2F805, &lxb_unicode_idna_map_2F805};
static const lxb_unicode_data_t lxb_unicode_data_2F806 = {&lxb_unicode_entry_2F806, &lxb_unicode_idna_map_2F806};
static const lxb_unicode_data_t lxb_unicode_data_2F807 = {&lxb_unicode_entry_2F807, &lxb_unicode_idna_map_2F807};
static const lxb_unicode_data_t lxb_unicode_data_2F808 = {&lxb_unicode_entry_2F808, &lxb_unicode_idna_map_2F808};
static const lxb_unicode_data_t lxb_unicode_data_2F809 = {&lxb_unicode_entry_2F809, &lxb_unicode_idna_map_2F809};
static const lxb_unicode_data_t lxb_unicode_data_2F80A = {&lxb_unicode_entry_2F80A, &lxb_unicode_idna_map_2F80A};
static const lxb_unicode_data_t lxb_unicode_data_2F80B = {&lxb_unicode_entry_2F80B, &lxb_unicode_idna_map_2F80B};
static const lxb_unicode_data_t lxb_unicode_data_2F80C = {&lxb_unicode_entry_2F80C, &lxb_unicode_idna_map_2F80C};
static const lxb_unicode_data_t lxb_unicode_data_2F80D = {&lxb_unicode_entry_2F80D, &lxb_unicode_idna_map_2F80D};
static const lxb_unicode_data_t lxb_unicode_data_2F80E = {&lxb_unicode_entry_2F80E, &lxb_unicode_idna_map_2F80E};
static const lxb_unicode_data_t lxb_unicode_data_2F80F = {&lxb_unicode_entry_2F80F, &lxb_unicode_idna_map_2F80F};
static const lxb_unicode_data_t lxb_unicode_data_2F810 = {&lxb_unicode_entry_2F810, &lxb_unicode_idna_map_2F810};
static const lxb_unicode_data_t lxb_unicode_data_2F811 = {&lxb_unicode_entry_2F811, &lxb_unicode_idna_map_2F811};
static const lxb_unicode_data_t lxb_unicode_data_2F812 = {&lxb_unicode_entry_2F812, &lxb_unicode_idna_map_2F812};
static const lxb_unicode_data_t lxb_unicode_data_2F813 = {&lxb_unicode_entry_2F813, &lxb_unicode_idna_map_2F813};
static const lxb_unicode_data_t lxb_unicode_data_2F814 = {&lxb_unicode_entry_2F814, &lxb_unicode_idna_map_2F814};
static const lxb_unicode_data_t lxb_unicode_data_2F815 = {&lxb_unicode_entry_2F815, &lxb_unicode_idna_map_2F815};
static const lxb_unicode_data_t lxb_unicode_data_2F816 = {&lxb_unicode_entry_2F816, &lxb_unicode_idna_map_2F816};
static const lxb_unicode_data_t lxb_unicode_data_2F817 = {&lxb_unicode_entry_2F817, &lxb_unicode_idna_map_2F817};
static const lxb_unicode_data_t lxb_unicode_data_2F818 = {&lxb_unicode_entry_2F818, &lxb_unicode_idna_map_2F818};
static const lxb_unicode_data_t lxb_unicode_data_2F819 = {&lxb_unicode_entry_2F819, &lxb_unicode_idna_map_2F819};
static const lxb_unicode_data_t lxb_unicode_data_2F81A = {&lxb_unicode_entry_2F81A, &lxb_unicode_idna_map_2F81A};
static const lxb_unicode_data_t lxb_unicode_data_2F81B = {&lxb_unicode_entry_2F81B, &lxb_unicode_idna_map_2F81B};
static const lxb_unicode_data_t lxb_unicode_data_2F81C = {&lxb_unicode_entry_2F81C, &lxb_unicode_idna_map_2F81C};
static const lxb_unicode_data_t lxb_unicode_data_2F81D = {&lxb_unicode_entry_2F81D, &lxb_unicode_idna_map_2F81D};
static const lxb_unicode_data_t lxb_unicode_data_2F81E = {&lxb_unicode_entry_2F81E, &lxb_unicode_idna_map_2F81E};
static const lxb_unicode_data_t lxb_unicode_data_2F81F = {&lxb_unicode_entry_2F81F, &lxb_unicode_idna_map_2F81F};
static const lxb_unicode_data_t lxb_unicode_data_2F820 = {&lxb_unicode_entry_2F820, &lxb_unicode_idna_map_2F820};
static const lxb_unicode_data_t lxb_unicode_data_2F821 = {&lxb_unicode_entry_2F821, &lxb_unicode_idna_map_2F821};
static const lxb_unicode_data_t lxb_unicode_data_2F822 = {&lxb_unicode_entry_2F822, &lxb_unicode_idna_map_2F822};
static const lxb_unicode_data_t lxb_unicode_data_2F823 = {&lxb_unicode_entry_2F823, &lxb_unicode_idna_map_2F823};
static const lxb_unicode_data_t lxb_unicode_data_2F824 = {&lxb_unicode_entry_2F824, &lxb_unicode_idna_map_2F824};
static const lxb_unicode_data_t lxb_unicode_data_2F825 = {&lxb_unicode_entry_2F825, &lxb_unicode_idna_map_2F825};
static const lxb_unicode_data_t lxb_unicode_data_2F826 = {&lxb_unicode_entry_2F826, &lxb_unicode_idna_map_2F826};
static const lxb_unicode_data_t lxb_unicode_data_2F827 = {&lxb_unicode_entry_2F827, &lxb_unicode_idna_map_2F827};
static const lxb_unicode_data_t lxb_unicode_data_2F828 = {&lxb_unicode_entry_2F828, &lxb_unicode_idna_map_2F828};
static const lxb_unicode_data_t lxb_unicode_data_2F829 = {&lxb_unicode_entry_2F829, &lxb_unicode_idna_map_2F829};
static const lxb_unicode_data_t lxb_unicode_data_2F82A = {&lxb_unicode_entry_2F82A, &lxb_unicode_idna_map_2F82A};
static const lxb_unicode_data_t lxb_unicode_data_2F82B = {&lxb_unicode_entry_2F82B, &lxb_unicode_idna_map_2F82B};
static const lxb_unicode_data_t lxb_unicode_data_2F82C = {&lxb_unicode_entry_2F82C, &lxb_unicode_idna_map_2F82C};
static const lxb_unicode_data_t lxb_unicode_data_2F82D = {&lxb_unicode_entry_2F82D, &lxb_unicode_idna_map_2F82D};
static const lxb_unicode_data_t lxb_unicode_data_2F82E = {&lxb_unicode_entry_2F82E, &lxb_unicode_idna_map_2F82E};
static const lxb_unicode_data_t lxb_unicode_data_2F82F = {&lxb_unicode_entry_2F82F, &lxb_unicode_idna_map_2F82F};
static const lxb_unicode_data_t lxb_unicode_data_2F830 = {&lxb_unicode_entry_2F830, &lxb_unicode_idna_map_2F830};
static const lxb_unicode_data_t lxb_unicode_data_2F831 = {&lxb_unicode_entry_2F831, &lxb_unicode_idna_map_2F831};
static const lxb_unicode_data_t lxb_unicode_data_2F832 = {&lxb_unicode_entry_2F832, &lxb_unicode_idna_map_2F832};
static const lxb_unicode_data_t lxb_unicode_data_2F833 = {&lxb_unicode_entry_2F833, &lxb_unicode_idna_map_2F833};
static const lxb_unicode_data_t lxb_unicode_data_2F834 = {&lxb_unicode_entry_2F834, &lxb_unicode_idna_map_2F834};
static const lxb_unicode_data_t lxb_unicode_data_2F835 = {&lxb_unicode_entry_2F835, &lxb_unicode_idna_map_2F835};
static const lxb_unicode_data_t lxb_unicode_data_2F836 = {&lxb_unicode_entry_2F836, &lxb_unicode_idna_map_2F836};
static const lxb_unicode_data_t lxb_unicode_data_2F837 = {&lxb_unicode_entry_2F837, &lxb_unicode_idna_map_2F837};
static const lxb_unicode_data_t lxb_unicode_data_2F838 = {&lxb_unicode_entry_2F838, &lxb_unicode_idna_map_2F838};
static const lxb_unicode_data_t lxb_unicode_data_2F839 = {&lxb_unicode_entry_2F839, &lxb_unicode_idna_map_2F839};
static const lxb_unicode_data_t lxb_unicode_data_2F83A = {&lxb_unicode_entry_2F83A, &lxb_unicode_idna_map_2F83A};
static const lxb_unicode_data_t lxb_unicode_data_2F83B = {&lxb_unicode_entry_2F83B, &lxb_unicode_idna_map_2F83B};
static const lxb_unicode_data_t lxb_unicode_data_2F83C = {&lxb_unicode_entry_2F83C, &lxb_unicode_idna_map_2F83C};
static const lxb_unicode_data_t lxb_unicode_data_2F83D = {&lxb_unicode_entry_2F83D, &lxb_unicode_idna_map_2F83D};
static const lxb_unicode_data_t lxb_unicode_data_2F83E = {&lxb_unicode_entry_2F83E, &lxb_unicode_idna_map_2F83E};
static const lxb_unicode_data_t lxb_unicode_data_2F83F = {&lxb_unicode_entry_2F83F, &lxb_unicode_idna_map_2F83F};
static const lxb_unicode_data_t lxb_unicode_data_2F840 = {&lxb_unicode_entry_2F840, &lxb_unicode_idna_map_2F840};
static const lxb_unicode_data_t lxb_unicode_data_2F841 = {&lxb_unicode_entry_2F841, &lxb_unicode_idna_map_2F841};
static const lxb_unicode_data_t lxb_unicode_data_2F842 = {&lxb_unicode_entry_2F842, &lxb_unicode_idna_map_2F842};
static const lxb_unicode_data_t lxb_unicode_data_2F843 = {&lxb_unicode_entry_2F843, &lxb_unicode_idna_map_2F843};
static const lxb_unicode_data_t lxb_unicode_data_2F844 = {&lxb_unicode_entry_2F844, &lxb_unicode_idna_map_2F844};
static const lxb_unicode_data_t lxb_unicode_data_2F845 = {&lxb_unicode_entry_2F845, &lxb_unicode_idna_map_2F845};
static const lxb_unicode_data_t lxb_unicode_data_2F846 = {&lxb_unicode_entry_2F846, &lxb_unicode_idna_map_2F846};
static const lxb_unicode_data_t lxb_unicode_data_2F847 = {&lxb_unicode_entry_2F847, &lxb_unicode_idna_map_2F847};
static const lxb_unicode_data_t lxb_unicode_data_2F848 = {&lxb_unicode_entry_2F848, &lxb_unicode_idna_map_2F848};
static const lxb_unicode_data_t lxb_unicode_data_2F849 = {&lxb_unicode_entry_2F849, &lxb_unicode_idna_map_2F849};
static const lxb_unicode_data_t lxb_unicode_data_2F84A = {&lxb_unicode_entry_2F84A, &lxb_unicode_idna_map_2F84A};
static const lxb_unicode_data_t lxb_unicode_data_2F84B = {&lxb_unicode_entry_2F84B, &lxb_unicode_idna_map_2F84B};
static const lxb_unicode_data_t lxb_unicode_data_2F84C = {&lxb_unicode_entry_2F84C, &lxb_unicode_idna_map_2F84C};
static const lxb_unicode_data_t lxb_unicode_data_2F84D = {&lxb_unicode_entry_2F84D, &lxb_unicode_idna_map_2F84D};
static const lxb_unicode_data_t lxb_unicode_data_2F84E = {&lxb_unicode_entry_2F84E, &lxb_unicode_idna_map_2F84E};
static const lxb_unicode_data_t lxb_unicode_data_2F84F = {&lxb_unicode_entry_2F84F, &lxb_unicode_idna_map_2F84F};
static const lxb_unicode_data_t lxb_unicode_data_2F850 = {&lxb_unicode_entry_2F850, &lxb_unicode_idna_map_2F850};
static const lxb_unicode_data_t lxb_unicode_data_2F851 = {&lxb_unicode_entry_2F851, &lxb_unicode_idna_map_2F851};
static const lxb_unicode_data_t lxb_unicode_data_2F852 = {&lxb_unicode_entry_2F852, &lxb_unicode_idna_map_2F852};
static const lxb_unicode_data_t lxb_unicode_data_2F853 = {&lxb_unicode_entry_2F853, &lxb_unicode_idna_map_2F853};
static const lxb_unicode_data_t lxb_unicode_data_2F854 = {&lxb_unicode_entry_2F854, &lxb_unicode_idna_map_2F854};
static const lxb_unicode_data_t lxb_unicode_data_2F855 = {&lxb_unicode_entry_2F855, &lxb_unicode_idna_map_2F855};
static const lxb_unicode_data_t lxb_unicode_data_2F856 = {&lxb_unicode_entry_2F856, &lxb_unicode_idna_map_2F856};
static const lxb_unicode_data_t lxb_unicode_data_2F857 = {&lxb_unicode_entry_2F857, &lxb_unicode_idna_map_2F857};
static const lxb_unicode_data_t lxb_unicode_data_2F858 = {&lxb_unicode_entry_2F858, &lxb_unicode_idna_map_2F858};
static const lxb_unicode_data_t lxb_unicode_data_2F859 = {&lxb_unicode_entry_2F859, &lxb_unicode_idna_map_2F859};
static const lxb_unicode_data_t lxb_unicode_data_2F85A = {&lxb_unicode_entry_2F85A, &lxb_unicode_idna_map_2F85A};
static const lxb_unicode_data_t lxb_unicode_data_2F85B = {&lxb_unicode_entry_2F85B, &lxb_unicode_idna_map_2F85B};
static const lxb_unicode_data_t lxb_unicode_data_2F85C = {&lxb_unicode_entry_2F85C, &lxb_unicode_idna_map_2F85C};
static const lxb_unicode_data_t lxb_unicode_data_2F85D = {&lxb_unicode_entry_2F85D, &lxb_unicode_idna_map_2F85D};
static const lxb_unicode_data_t lxb_unicode_data_2F85E = {&lxb_unicode_entry_2F85E, &lxb_unicode_idna_map_2F85E};
static const lxb_unicode_data_t lxb_unicode_data_2F85F = {&lxb_unicode_entry_2F85F, &lxb_unicode_idna_map_2F85F};
static const lxb_unicode_data_t lxb_unicode_data_2F860 = {&lxb_unicode_entry_2F860, &lxb_unicode_idna_map_2F860};
static const lxb_unicode_data_t lxb_unicode_data_2F861 = {&lxb_unicode_entry_2F861, &lxb_unicode_idna_map_2F861};
static const lxb_unicode_data_t lxb_unicode_data_2F862 = {&lxb_unicode_entry_2F862, &lxb_unicode_idna_map_2F862};
static const lxb_unicode_data_t lxb_unicode_data_2F863 = {&lxb_unicode_entry_2F863, &lxb_unicode_idna_map_2F863};
static const lxb_unicode_data_t lxb_unicode_data_2F864 = {&lxb_unicode_entry_2F864, &lxb_unicode_idna_map_2F864};
static const lxb_unicode_data_t lxb_unicode_data_2F865 = {&lxb_unicode_entry_2F865, &lxb_unicode_idna_map_2F865};
static const lxb_unicode_data_t lxb_unicode_data_2F866 = {&lxb_unicode_entry_2F866, &lxb_unicode_idna_map_2F866};
static const lxb_unicode_data_t lxb_unicode_data_2F867 = {&lxb_unicode_entry_2F867, &lxb_unicode_idna_map_2F867};
static const lxb_unicode_data_t lxb_unicode_data_2F868 = {&lxb_unicode_entry_2F868, NULL};
static const lxb_unicode_data_t lxb_unicode_data_2F869 = {&lxb_unicode_entry_2F869, &lxb_unicode_idna_map_2F869};
static const lxb_unicode_data_t lxb_unicode_data_2F86A = {&lxb_unicode_entry_2F86A, &lxb_unicode_idna_map_2F86A};
static const lxb_unicode_data_t lxb_unicode_data_2F86B = {&lxb_unicode_entry_2F86B, &lxb_unicode_idna_map_2F86B};
static const lxb_unicode_data_t lxb_unicode_data_2F86C = {&lxb_unicode_entry_2F86C, &lxb_unicode_idna_map_2F86C};
static const lxb_unicode_data_t lxb_unicode_data_2F86D = {&lxb_unicode_entry_2F86D, &lxb_unicode_idna_map_2F86D};
static const lxb_unicode_data_t lxb_unicode_data_2F86E = {&lxb_unicode_entry_2F86E, &lxb_unicode_idna_map_2F86E};
static const lxb_unicode_data_t lxb_unicode_data_2F86F = {&lxb_unicode_entry_2F86F, &lxb_unicode_idna_map_2F86F};
static const lxb_unicode_data_t lxb_unicode_data_2F870 = {&lxb_unicode_entry_2F870, &lxb_unicode_idna_map_2F870};
static const lxb_unicode_data_t lxb_unicode_data_2F871 = {&lxb_unicode_entry_2F871, &lxb_unicode_idna_map_2F871};
static const lxb_unicode_data_t lxb_unicode_data_2F872 = {&lxb_unicode_entry_2F872, &lxb_unicode_idna_map_2F872};
static const lxb_unicode_data_t lxb_unicode_data_2F873 = {&lxb_unicode_entry_2F873, &lxb_unicode_idna_map_2F873};
static const lxb_unicode_data_t lxb_unicode_data_2F874 = {&lxb_unicode_entry_2F874, NULL};
static const lxb_unicode_data_t lxb_unicode_data_2F875 = {&lxb_unicode_entry_2F875, &lxb_unicode_idna_map_2F875};
static const lxb_unicode_data_t lxb_unicode_data_2F876 = {&lxb_unicode_entry_2F876, &lxb_unicode_idna_map_2F876};
static const lxb_unicode_data_t lxb_unicode_data_2F877 = {&lxb_unicode_entry_2F877, &lxb_unicode_idna_map_2F877};
static const lxb_unicode_data_t lxb_unicode_data_2F878 = {&lxb_unicode_entry_2F878, &lxb_unicode_idna_map_2F878};
static const lxb_unicode_data_t lxb_unicode_data_2F879 = {&lxb_unicode_entry_2F879, &lxb_unicode_idna_map_2F879};
static const lxb_unicode_data_t lxb_unicode_data_2F87A = {&lxb_unicode_entry_2F87A, &lxb_unicode_idna_map_2F87A};
static const lxb_unicode_data_t lxb_unicode_data_2F87B = {&lxb_unicode_entry_2F87B, &lxb_unicode_idna_map_2F87B};
static const lxb_unicode_data_t lxb_unicode_data_2F87C = {&lxb_unicode_entry_2F87C, &lxb_unicode_idna_map_2F87C};
static const lxb_unicode_data_t lxb_unicode_data_2F87D = {&lxb_unicode_entry_2F87D, &lxb_unicode_idna_map_2F87D};
static const lxb_unicode_data_t lxb_unicode_data_2F87E = {&lxb_unicode_entry_2F87E, &lxb_unicode_idna_map_2F87E};
static const lxb_unicode_data_t lxb_unicode_data_2F87F = {&lxb_unicode_entry_2F87F, &lxb_unicode_idna_map_2F87F};
static const lxb_unicode_data_t lxb_unicode_data_2F880 = {&lxb_unicode_entry_2F880, &lxb_unicode_idna_map_2F880};
static const lxb_unicode_data_t lxb_unicode_data_2F881 = {&lxb_unicode_entry_2F881, &lxb_unicode_idna_map_2F881};
static const lxb_unicode_data_t lxb_unicode_data_2F882 = {&lxb_unicode_entry_2F882, &lxb_unicode_idna_map_2F882};
static const lxb_unicode_data_t lxb_unicode_data_2F883 = {&lxb_unicode_entry_2F883, &lxb_unicode_idna_map_2F883};
static const lxb_unicode_data_t lxb_unicode_data_2F884 = {&lxb_unicode_entry_2F884, &lxb_unicode_idna_map_2F884};
static const lxb_unicode_data_t lxb_unicode_data_2F885 = {&lxb_unicode_entry_2F885, &lxb_unicode_idna_map_2F885};
static const lxb_unicode_data_t lxb_unicode_data_2F886 = {&lxb_unicode_entry_2F886, &lxb_unicode_idna_map_2F886};
static const lxb_unicode_data_t lxb_unicode_data_2F887 = {&lxb_unicode_entry_2F887, &lxb_unicode_idna_map_2F887};
static const lxb_unicode_data_t lxb_unicode_data_2F888 = {&lxb_unicode_entry_2F888, &lxb_unicode_idna_map_2F888};
static const lxb_unicode_data_t lxb_unicode_data_2F889 = {&lxb_unicode_entry_2F889, &lxb_unicode_idna_map_2F889};
static const lxb_unicode_data_t lxb_unicode_data_2F88A = {&lxb_unicode_entry_2F88A, &lxb_unicode_idna_map_2F88A};
static const lxb_unicode_data_t lxb_unicode_data_2F88B = {&lxb_unicode_entry_2F88B, &lxb_unicode_idna_map_2F88B};
static const lxb_unicode_data_t lxb_unicode_data_2F88C = {&lxb_unicode_entry_2F88C, &lxb_unicode_idna_map_2F88C};
static const lxb_unicode_data_t lxb_unicode_data_2F88D = {&lxb_unicode_entry_2F88D, &lxb_unicode_idna_map_2F88D};
static const lxb_unicode_data_t lxb_unicode_data_2F88E = {&lxb_unicode_entry_2F88E, &lxb_unicode_idna_map_2F88E};
static const lxb_unicode_data_t lxb_unicode_data_2F88F = {&lxb_unicode_entry_2F88F, &lxb_unicode_idna_map_2F88F};
static const lxb_unicode_data_t lxb_unicode_data_2F890 = {&lxb_unicode_entry_2F890, &lxb_unicode_idna_map_2F890};
static const lxb_unicode_data_t lxb_unicode_data_2F891 = {&lxb_unicode_entry_2F891, &lxb_unicode_idna_map_2F891};
static const lxb_unicode_data_t lxb_unicode_data_2F892 = {&lxb_unicode_entry_2F892, &lxb_unicode_idna_map_2F892};
static const lxb_unicode_data_t lxb_unicode_data_2F893 = {&lxb_unicode_entry_2F893, &lxb_unicode_idna_map_2F893};
static const lxb_unicode_data_t lxb_unicode_data_2F894 = {&lxb_unicode_entry_2F894, &lxb_unicode_idna_map_2F894};
static const lxb_unicode_data_t lxb_unicode_data_2F895 = {&lxb_unicode_entry_2F895, &lxb_unicode_idna_map_2F895};
static const lxb_unicode_data_t lxb_unicode_data_2F896 = {&lxb_unicode_entry_2F896, &lxb_unicode_idna_map_2F896};
static const lxb_unicode_data_t lxb_unicode_data_2F897 = {&lxb_unicode_entry_2F897, &lxb_unicode_idna_map_2F897};
static const lxb_unicode_data_t lxb_unicode_data_2F898 = {&lxb_unicode_entry_2F898, &lxb_unicode_idna_map_2F898};
static const lxb_unicode_data_t lxb_unicode_data_2F899 = {&lxb_unicode_entry_2F899, &lxb_unicode_idna_map_2F899};
static const lxb_unicode_data_t lxb_unicode_data_2F89A = {&lxb_unicode_entry_2F89A, &lxb_unicode_idna_map_2F89A};
static const lxb_unicode_data_t lxb_unicode_data_2F89B = {&lxb_unicode_entry_2F89B, &lxb_unicode_idna_map_2F89B};
static const lxb_unicode_data_t lxb_unicode_data_2F89C = {&lxb_unicode_entry_2F89C, &lxb_unicode_idna_map_2F89C};
static const lxb_unicode_data_t lxb_unicode_data_2F89D = {&lxb_unicode_entry_2F89D, &lxb_unicode_idna_map_2F89D};
static const lxb_unicode_data_t lxb_unicode_data_2F89E = {&lxb_unicode_entry_2F89E, &lxb_unicode_idna_map_2F89E};
static const lxb_unicode_data_t lxb_unicode_data_2F89F = {&lxb_unicode_entry_2F89F, &lxb_unicode_idna_map_2F89F};
static const lxb_unicode_data_t lxb_unicode_data_2F8A0 = {&lxb_unicode_entry_2F8A0, &lxb_unicode_idna_map_2F8A0};
static const lxb_unicode_data_t lxb_unicode_data_2F8A1 = {&lxb_unicode_entry_2F8A1, &lxb_unicode_idna_map_2F8A1};
static const lxb_unicode_data_t lxb_unicode_data_2F8A2 = {&lxb_unicode_entry_2F8A2, &lxb_unicode_idna_map_2F8A2};
static const lxb_unicode_data_t lxb_unicode_data_2F8A3 = {&lxb_unicode_entry_2F8A3, &lxb_unicode_idna_map_2F8A3};
static const lxb_unicode_data_t lxb_unicode_data_2F8A4 = {&lxb_unicode_entry_2F8A4, &lxb_unicode_idna_map_2F8A4};
static const lxb_unicode_data_t lxb_unicode_data_2F8A5 = {&lxb_unicode_entry_2F8A5, &lxb_unicode_idna_map_2F8A5};
static const lxb_unicode_data_t lxb_unicode_data_2F8A6 = {&lxb_unicode_entry_2F8A6, &lxb_unicode_idna_map_2F8A6};
static const lxb_unicode_data_t lxb_unicode_data_2F8A7 = {&lxb_unicode_entry_2F8A7, &lxb_unicode_idna_map_2F8A7};
static const lxb_unicode_data_t lxb_unicode_data_2F8A8 = {&lxb_unicode_entry_2F8A8, &lxb_unicode_idna_map_2F8A8};
static const lxb_unicode_data_t lxb_unicode_data_2F8A9 = {&lxb_unicode_entry_2F8A9, &lxb_unicode_idna_map_2F8A9};
static const lxb_unicode_data_t lxb_unicode_data_2F8AA = {&lxb_unicode_entry_2F8AA, &lxb_unicode_idna_map_2F8AA};
static const lxb_unicode_data_t lxb_unicode_data_2F8AB = {&lxb_unicode_entry_2F8AB, &lxb_unicode_idna_map_2F8AB};
static const lxb_unicode_data_t lxb_unicode_data_2F8AC = {&lxb_unicode_entry_2F8AC, &lxb_unicode_idna_map_2F8AC};
static const lxb_unicode_data_t lxb_unicode_data_2F8AD = {&lxb_unicode_entry_2F8AD, &lxb_unicode_idna_map_2F8AD};
static const lxb_unicode_data_t lxb_unicode_data_2F8AE = {&lxb_unicode_entry_2F8AE, &lxb_unicode_idna_map_2F8AE};
static const lxb_unicode_data_t lxb_unicode_data_2F8AF = {&lxb_unicode_entry_2F8AF, &lxb_unicode_idna_map_2F8AF};
static const lxb_unicode_data_t lxb_unicode_data_2F8B0 = {&lxb_unicode_entry_2F8B0, &lxb_unicode_idna_map_2F8B0};
static const lxb_unicode_data_t lxb_unicode_data_2F8B1 = {&lxb_unicode_entry_2F8B1, &lxb_unicode_idna_map_2F8B1};
static const lxb_unicode_data_t lxb_unicode_data_2F8B2 = {&lxb_unicode_entry_2F8B2, &lxb_unicode_idna_map_2F8B2};
static const lxb_unicode_data_t lxb_unicode_data_2F8B3 = {&lxb_unicode_entry_2F8B3, &lxb_unicode_idna_map_2F8B3};
static const lxb_unicode_data_t lxb_unicode_data_2F8B4 = {&lxb_unicode_entry_2F8B4, &lxb_unicode_idna_map_2F8B4};
static const lxb_unicode_data_t lxb_unicode_data_2F8B5 = {&lxb_unicode_entry_2F8B5, &lxb_unicode_idna_map_2F8B5};
static const lxb_unicode_data_t lxb_unicode_data_2F8B6 = {&lxb_unicode_entry_2F8B6, &lxb_unicode_idna_map_2F8B6};
static const lxb_unicode_data_t lxb_unicode_data_2F8B7 = {&lxb_unicode_entry_2F8B7, &lxb_unicode_idna_map_2F8B7};
static const lxb_unicode_data_t lxb_unicode_data_2F8B8 = {&lxb_unicode_entry_2F8B8, &lxb_unicode_idna_map_2F8B8};
static const lxb_unicode_data_t lxb_unicode_data_2F8B9 = {&lxb_unicode_entry_2F8B9, &lxb_unicode_idna_map_2F8B9};
static const lxb_unicode_data_t lxb_unicode_data_2F8BA = {&lxb_unicode_entry_2F8BA, &lxb_unicode_idna_map_2F8BA};
static const lxb_unicode_data_t lxb_unicode_data_2F8BB = {&lxb_unicode_entry_2F8BB, &lxb_unicode_idna_map_2F8BB};
static const lxb_unicode_data_t lxb_unicode_data_2F8BC = {&lxb_unicode_entry_2F8BC, &lxb_unicode_idna_map_2F8BC};
static const lxb_unicode_data_t lxb_unicode_data_2F8BD = {&lxb_unicode_entry_2F8BD, &lxb_unicode_idna_map_2F8BD};
static const lxb_unicode_data_t lxb_unicode_data_2F8BE = {&lxb_unicode_entry_2F8BE, &lxb_unicode_idna_map_2F8BE};
static const lxb_unicode_data_t lxb_unicode_data_2F8BF = {&lxb_unicode_entry_2F8BF, &lxb_unicode_idna_map_2F8BF};
static const lxb_unicode_data_t lxb_unicode_data_2F8C0 = {&lxb_unicode_entry_2F8C0, &lxb_unicode_idna_map_2F8C0};
static const lxb_unicode_data_t lxb_unicode_data_2F8C1 = {&lxb_unicode_entry_2F8C1, &lxb_unicode_idna_map_2F8C1};
static const lxb_unicode_data_t lxb_unicode_data_2F8C2 = {&lxb_unicode_entry_2F8C2, &lxb_unicode_idna_map_2F8C2};
static const lxb_unicode_data_t lxb_unicode_data_2F8C3 = {&lxb_unicode_entry_2F8C3, &lxb_unicode_idna_map_2F8C3};
static const lxb_unicode_data_t lxb_unicode_data_2F8C4 = {&lxb_unicode_entry_2F8C4, &lxb_unicode_idna_map_2F8C4};
static const lxb_unicode_data_t lxb_unicode_data_2F8C5 = {&lxb_unicode_entry_2F8C5, &lxb_unicode_idna_map_2F8C5};
static const lxb_unicode_data_t lxb_unicode_data_2F8C6 = {&lxb_unicode_entry_2F8C6, &lxb_unicode_idna_map_2F8C6};
static const lxb_unicode_data_t lxb_unicode_data_2F8C7 = {&lxb_unicode_entry_2F8C7, &lxb_unicode_idna_map_2F8C7};
static const lxb_unicode_data_t lxb_unicode_data_2F8C8 = {&lxb_unicode_entry_2F8C8, &lxb_unicode_idna_map_2F8C8};
static const lxb_unicode_data_t lxb_unicode_data_2F8C9 = {&lxb_unicode_entry_2F8C9, &lxb_unicode_idna_map_2F8C9};
static const lxb_unicode_data_t lxb_unicode_data_2F8CA = {&lxb_unicode_entry_2F8CA, &lxb_unicode_idna_map_2F8CA};
static const lxb_unicode_data_t lxb_unicode_data_2F8CB = {&lxb_unicode_entry_2F8CB, &lxb_unicode_idna_map_2F8CB};
static const lxb_unicode_data_t lxb_unicode_data_2F8CC = {&lxb_unicode_entry_2F8CC, &lxb_unicode_idna_map_2F8CC};
static const lxb_unicode_data_t lxb_unicode_data_2F8CD = {&lxb_unicode_entry_2F8CD, &lxb_unicode_idna_map_2F8CD};
static const lxb_unicode_data_t lxb_unicode_data_2F8CE = {&lxb_unicode_entry_2F8CE, &lxb_unicode_idna_map_2F8CE};
static const lxb_unicode_data_t lxb_unicode_data_2F8CF = {&lxb_unicode_entry_2F8CF, &lxb_unicode_idna_map_2F8CF};
static const lxb_unicode_data_t lxb_unicode_data_2F8D0 = {&lxb_unicode_entry_2F8D0, &lxb_unicode_idna_map_2F8D0};
static const lxb_unicode_data_t lxb_unicode_data_2F8D1 = {&lxb_unicode_entry_2F8D1, &lxb_unicode_idna_map_2F8D1};
static const lxb_unicode_data_t lxb_unicode_data_2F8D2 = {&lxb_unicode_entry_2F8D2, &lxb_unicode_idna_map_2F8D2};
static const lxb_unicode_data_t lxb_unicode_data_2F8D3 = {&lxb_unicode_entry_2F8D3, &lxb_unicode_idna_map_2F8D3};
static const lxb_unicode_data_t lxb_unicode_data_2F8D4 = {&lxb_unicode_entry_2F8D4, &lxb_unicode_idna_map_2F8D4};
static const lxb_unicode_data_t lxb_unicode_data_2F8D5 = {&lxb_unicode_entry_2F8D5, &lxb_unicode_idna_map_2F8D5};
static const lxb_unicode_data_t lxb_unicode_data_2F8D6 = {&lxb_unicode_entry_2F8D6, &lxb_unicode_idna_map_2F8D6};
static const lxb_unicode_data_t lxb_unicode_data_2F8D7 = {&lxb_unicode_entry_2F8D7, &lxb_unicode_idna_map_2F8D7};
static const lxb_unicode_data_t lxb_unicode_data_2F8D8 = {&lxb_unicode_entry_2F8D8, &lxb_unicode_idna_map_2F8D8};
static const lxb_unicode_data_t lxb_unicode_data_2F8D9 = {&lxb_unicode_entry_2F8D9, &lxb_unicode_idna_map_2F8D9};
static const lxb_unicode_data_t lxb_unicode_data_2F8DA = {&lxb_unicode_entry_2F8DA, &lxb_unicode_idna_map_2F8DA};
static const lxb_unicode_data_t lxb_unicode_data_2F8DB = {&lxb_unicode_entry_2F8DB, &lxb_unicode_idna_map_2F8DB};
static const lxb_unicode_data_t lxb_unicode_data_2F8DC = {&lxb_unicode_entry_2F8DC, &lxb_unicode_idna_map_2F8DC};
static const lxb_unicode_data_t lxb_unicode_data_2F8DD = {&lxb_unicode_entry_2F8DD, &lxb_unicode_idna_map_2F8DD};
static const lxb_unicode_data_t lxb_unicode_data_2F8DE = {&lxb_unicode_entry_2F8DE, &lxb_unicode_idna_map_2F8DE};
static const lxb_unicode_data_t lxb_unicode_data_2F8DF = {&lxb_unicode_entry_2F8DF, &lxb_unicode_idna_map_2F8DF};
static const lxb_unicode_data_t lxb_unicode_data_2F8E0 = {&lxb_unicode_entry_2F8E0, &lxb_unicode_idna_map_2F8E0};
static const lxb_unicode_data_t lxb_unicode_data_2F8E1 = {&lxb_unicode_entry_2F8E1, &lxb_unicode_idna_map_2F8E1};
static const lxb_unicode_data_t lxb_unicode_data_2F8E2 = {&lxb_unicode_entry_2F8E2, &lxb_unicode_idna_map_2F8E2};
static const lxb_unicode_data_t lxb_unicode_data_2F8E3 = {&lxb_unicode_entry_2F8E3, &lxb_unicode_idna_map_2F8E3};
static const lxb_unicode_data_t lxb_unicode_data_2F8E4 = {&lxb_unicode_entry_2F8E4, &lxb_unicode_idna_map_2F8E4};
static const lxb_unicode_data_t lxb_unicode_data_2F8E5 = {&lxb_unicode_entry_2F8E5, &lxb_unicode_idna_map_2F8E5};
static const lxb_unicode_data_t lxb_unicode_data_2F8E6 = {&lxb_unicode_entry_2F8E6, &lxb_unicode_idna_map_2F8E6};
static const lxb_unicode_data_t lxb_unicode_data_2F8E7 = {&lxb_unicode_entry_2F8E7, &lxb_unicode_idna_map_2F8E7};
static const lxb_unicode_data_t lxb_unicode_data_2F8E8 = {&lxb_unicode_entry_2F8E8, &lxb_unicode_idna_map_2F8E8};
static const lxb_unicode_data_t lxb_unicode_data_2F8E9 = {&lxb_unicode_entry_2F8E9, &lxb_unicode_idna_map_2F8E9};
static const lxb_unicode_data_t lxb_unicode_data_2F8EA = {&lxb_unicode_entry_2F8EA, &lxb_unicode_idna_map_2F8EA};
static const lxb_unicode_data_t lxb_unicode_data_2F8EB = {&lxb_unicode_entry_2F8EB, &lxb_unicode_idna_map_2F8EB};
static const lxb_unicode_data_t lxb_unicode_data_2F8EC = {&lxb_unicode_entry_2F8EC, &lxb_unicode_idna_map_2F8EC};
static const lxb_unicode_data_t lxb_unicode_data_2F8ED = {&lxb_unicode_entry_2F8ED, &lxb_unicode_idna_map_2F8ED};
static const lxb_unicode_data_t lxb_unicode_data_2F8EE = {&lxb_unicode_entry_2F8EE, &lxb_unicode_idna_map_2F8EE};
static const lxb_unicode_data_t lxb_unicode_data_2F8EF = {&lxb_unicode_entry_2F8EF, &lxb_unicode_idna_map_2F8EF};
static const lxb_unicode_data_t lxb_unicode_data_2F8F0 = {&lxb_unicode_entry_2F8F0, &lxb_unicode_idna_map_2F8F0};
static const lxb_unicode_data_t lxb_unicode_data_2F8F1 = {&lxb_unicode_entry_2F8F1, &lxb_unicode_idna_map_2F8F1};
static const lxb_unicode_data_t lxb_unicode_data_2F8F2 = {&lxb_unicode_entry_2F8F2, &lxb_unicode_idna_map_2F8F2};
static const lxb_unicode_data_t lxb_unicode_data_2F8F3 = {&lxb_unicode_entry_2F8F3, &lxb_unicode_idna_map_2F8F3};
static const lxb_unicode_data_t lxb_unicode_data_2F8F4 = {&lxb_unicode_entry_2F8F4, &lxb_unicode_idna_map_2F8F4};
static const lxb_unicode_data_t lxb_unicode_data_2F8F5 = {&lxb_unicode_entry_2F8F5, &lxb_unicode_idna_map_2F8F5};
static const lxb_unicode_data_t lxb_unicode_data_2F8F6 = {&lxb_unicode_entry_2F8F6, &lxb_unicode_idna_map_2F8F6};
static const lxb_unicode_data_t lxb_unicode_data_2F8F7 = {&lxb_unicode_entry_2F8F7, &lxb_unicode_idna_map_2F8F7};
static const lxb_unicode_data_t lxb_unicode_data_2F8F8 = {&lxb_unicode_entry_2F8F8, &lxb_unicode_idna_map_2F8F8};
static const lxb_unicode_data_t lxb_unicode_data_2F8F9 = {&lxb_unicode_entry_2F8F9, &lxb_unicode_idna_map_2F8F9};
static const lxb_unicode_data_t lxb_unicode_data_2F8FA = {&lxb_unicode_entry_2F8FA, &lxb_unicode_idna_map_2F8FA};
static const lxb_unicode_data_t lxb_unicode_data_2F8FB = {&lxb_unicode_entry_2F8FB, &lxb_unicode_idna_map_2F8FB};
static const lxb_unicode_data_t lxb_unicode_data_2F8FC = {&lxb_unicode_entry_2F8FC, &lxb_unicode_idna_map_2F8FC};
static const lxb_unicode_data_t lxb_unicode_data_2F8FD = {&lxb_unicode_entry_2F8FD, &lxb_unicode_idna_map_2F8FD};
static const lxb_unicode_data_t lxb_unicode_data_2F8FE = {&lxb_unicode_entry_2F8FE, &lxb_unicode_idna_map_2F8FE};
static const lxb_unicode_data_t lxb_unicode_data_2F8FF = {&lxb_unicode_entry_2F8FF, &lxb_unicode_idna_map_2F8FF};
static const lxb_unicode_data_t lxb_unicode_data_2F900 = {&lxb_unicode_entry_2F900, &lxb_unicode_idna_map_2F900};
static const lxb_unicode_data_t lxb_unicode_data_2F901 = {&lxb_unicode_entry_2F901, &lxb_unicode_idna_map_2F901};
static const lxb_unicode_data_t lxb_unicode_data_2F902 = {&lxb_unicode_entry_2F902, &lxb_unicode_idna_map_2F902};
static const lxb_unicode_data_t lxb_unicode_data_2F903 = {&lxb_unicode_entry_2F903, &lxb_unicode_idna_map_2F903};
static const lxb_unicode_data_t lxb_unicode_data_2F904 = {&lxb_unicode_entry_2F904, &lxb_unicode_idna_map_2F904};
static const lxb_unicode_data_t lxb_unicode_data_2F905 = {&lxb_unicode_entry_2F905, &lxb_unicode_idna_map_2F905};
static const lxb_unicode_data_t lxb_unicode_data_2F906 = {&lxb_unicode_entry_2F906, &lxb_unicode_idna_map_2F906};
static const lxb_unicode_data_t lxb_unicode_data_2F907 = {&lxb_unicode_entry_2F907, &lxb_unicode_idna_map_2F907};
static const lxb_unicode_data_t lxb_unicode_data_2F908 = {&lxb_unicode_entry_2F908, &lxb_unicode_idna_map_2F908};
static const lxb_unicode_data_t lxb_unicode_data_2F909 = {&lxb_unicode_entry_2F909, &lxb_unicode_idna_map_2F909};
static const lxb_unicode_data_t lxb_unicode_data_2F90A = {&lxb_unicode_entry_2F90A, &lxb_unicode_idna_map_2F90A};
static const lxb_unicode_data_t lxb_unicode_data_2F90B = {&lxb_unicode_entry_2F90B, &lxb_unicode_idna_map_2F90B};
static const lxb_unicode_data_t lxb_unicode_data_2F90C = {&lxb_unicode_entry_2F90C, &lxb_unicode_idna_map_2F90C};
static const lxb_unicode_data_t lxb_unicode_data_2F90D = {&lxb_unicode_entry_2F90D, &lxb_unicode_idna_map_2F90D};
static const lxb_unicode_data_t lxb_unicode_data_2F90E = {&lxb_unicode_entry_2F90E, &lxb_unicode_idna_map_2F90E};
static const lxb_unicode_data_t lxb_unicode_data_2F90F = {&lxb_unicode_entry_2F90F, &lxb_unicode_idna_map_2F90F};
static const lxb_unicode_data_t lxb_unicode_data_2F910 = {&lxb_unicode_entry_2F910, &lxb_unicode_idna_map_2F910};
static const lxb_unicode_data_t lxb_unicode_data_2F911 = {&lxb_unicode_entry_2F911, &lxb_unicode_idna_map_2F911};
static const lxb_unicode_data_t lxb_unicode_data_2F912 = {&lxb_unicode_entry_2F912, &lxb_unicode_idna_map_2F912};
static const lxb_unicode_data_t lxb_unicode_data_2F913 = {&lxb_unicode_entry_2F913, &lxb_unicode_idna_map_2F913};
static const lxb_unicode_data_t lxb_unicode_data_2F914 = {&lxb_unicode_entry_2F914, &lxb_unicode_idna_map_2F914};
static const lxb_unicode_data_t lxb_unicode_data_2F915 = {&lxb_unicode_entry_2F915, &lxb_unicode_idna_map_2F915};
static const lxb_unicode_data_t lxb_unicode_data_2F916 = {&lxb_unicode_entry_2F916, &lxb_unicode_idna_map_2F916};
static const lxb_unicode_data_t lxb_unicode_data_2F917 = {&lxb_unicode_entry_2F917, &lxb_unicode_idna_map_2F917};
static const lxb_unicode_data_t lxb_unicode_data_2F918 = {&lxb_unicode_entry_2F918, &lxb_unicode_idna_map_2F918};
static const lxb_unicode_data_t lxb_unicode_data_2F919 = {&lxb_unicode_entry_2F919, &lxb_unicode_idna_map_2F919};
static const lxb_unicode_data_t lxb_unicode_data_2F91A = {&lxb_unicode_entry_2F91A, &lxb_unicode_idna_map_2F91A};
static const lxb_unicode_data_t lxb_unicode_data_2F91B = {&lxb_unicode_entry_2F91B, &lxb_unicode_idna_map_2F91B};
static const lxb_unicode_data_t lxb_unicode_data_2F91C = {&lxb_unicode_entry_2F91C, &lxb_unicode_idna_map_2F91C};
static const lxb_unicode_data_t lxb_unicode_data_2F91D = {&lxb_unicode_entry_2F91D, &lxb_unicode_idna_map_2F91D};
static const lxb_unicode_data_t lxb_unicode_data_2F91E = {&lxb_unicode_entry_2F91E, &lxb_unicode_idna_map_2F91E};
static const lxb_unicode_data_t lxb_unicode_data_2F91F = {&lxb_unicode_entry_2F91F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_2F920 = {&lxb_unicode_entry_2F920, &lxb_unicode_idna_map_2F920};
static const lxb_unicode_data_t lxb_unicode_data_2F921 = {&lxb_unicode_entry_2F921, &lxb_unicode_idna_map_2F921};
static const lxb_unicode_data_t lxb_unicode_data_2F922 = {&lxb_unicode_entry_2F922, &lxb_unicode_idna_map_2F922};
static const lxb_unicode_data_t lxb_unicode_data_2F923 = {&lxb_unicode_entry_2F923, &lxb_unicode_idna_map_2F923};
static const lxb_unicode_data_t lxb_unicode_data_2F924 = {&lxb_unicode_entry_2F924, &lxb_unicode_idna_map_2F924};
static const lxb_unicode_data_t lxb_unicode_data_2F925 = {&lxb_unicode_entry_2F925, &lxb_unicode_idna_map_2F925};
static const lxb_unicode_data_t lxb_unicode_data_2F926 = {&lxb_unicode_entry_2F926, &lxb_unicode_idna_map_2F926};
static const lxb_unicode_data_t lxb_unicode_data_2F927 = {&lxb_unicode_entry_2F927, &lxb_unicode_idna_map_2F927};
static const lxb_unicode_data_t lxb_unicode_data_2F928 = {&lxb_unicode_entry_2F928, &lxb_unicode_idna_map_2F928};
static const lxb_unicode_data_t lxb_unicode_data_2F929 = {&lxb_unicode_entry_2F929, &lxb_unicode_idna_map_2F929};
static const lxb_unicode_data_t lxb_unicode_data_2F92A = {&lxb_unicode_entry_2F92A, &lxb_unicode_idna_map_2F92A};
static const lxb_unicode_data_t lxb_unicode_data_2F92B = {&lxb_unicode_entry_2F92B, &lxb_unicode_idna_map_2F92B};
static const lxb_unicode_data_t lxb_unicode_data_2F92C = {&lxb_unicode_entry_2F92C, &lxb_unicode_idna_map_2F92C};
static const lxb_unicode_data_t lxb_unicode_data_2F92D = {&lxb_unicode_entry_2F92D, &lxb_unicode_idna_map_2F92D};
static const lxb_unicode_data_t lxb_unicode_data_2F92E = {&lxb_unicode_entry_2F92E, &lxb_unicode_idna_map_2F92E};
static const lxb_unicode_data_t lxb_unicode_data_2F92F = {&lxb_unicode_entry_2F92F, &lxb_unicode_idna_map_2F92F};
static const lxb_unicode_data_t lxb_unicode_data_2F930 = {&lxb_unicode_entry_2F930, &lxb_unicode_idna_map_2F930};
static const lxb_unicode_data_t lxb_unicode_data_2F931 = {&lxb_unicode_entry_2F931, &lxb_unicode_idna_map_2F931};
static const lxb_unicode_data_t lxb_unicode_data_2F932 = {&lxb_unicode_entry_2F932, &lxb_unicode_idna_map_2F932};
static const lxb_unicode_data_t lxb_unicode_data_2F933 = {&lxb_unicode_entry_2F933, &lxb_unicode_idna_map_2F933};
static const lxb_unicode_data_t lxb_unicode_data_2F934 = {&lxb_unicode_entry_2F934, &lxb_unicode_idna_map_2F934};
static const lxb_unicode_data_t lxb_unicode_data_2F935 = {&lxb_unicode_entry_2F935, &lxb_unicode_idna_map_2F935};
static const lxb_unicode_data_t lxb_unicode_data_2F936 = {&lxb_unicode_entry_2F936, &lxb_unicode_idna_map_2F936};
static const lxb_unicode_data_t lxb_unicode_data_2F937 = {&lxb_unicode_entry_2F937, &lxb_unicode_idna_map_2F937};
static const lxb_unicode_data_t lxb_unicode_data_2F938 = {&lxb_unicode_entry_2F938, &lxb_unicode_idna_map_2F938};
static const lxb_unicode_data_t lxb_unicode_data_2F939 = {&lxb_unicode_entry_2F939, &lxb_unicode_idna_map_2F939};
static const lxb_unicode_data_t lxb_unicode_data_2F93A = {&lxb_unicode_entry_2F93A, &lxb_unicode_idna_map_2F93A};
static const lxb_unicode_data_t lxb_unicode_data_2F93B = {&lxb_unicode_entry_2F93B, &lxb_unicode_idna_map_2F93B};
static const lxb_unicode_data_t lxb_unicode_data_2F93C = {&lxb_unicode_entry_2F93C, &lxb_unicode_idna_map_2F93C};
static const lxb_unicode_data_t lxb_unicode_data_2F93D = {&lxb_unicode_entry_2F93D, &lxb_unicode_idna_map_2F93D};
static const lxb_unicode_data_t lxb_unicode_data_2F93E = {&lxb_unicode_entry_2F93E, &lxb_unicode_idna_map_2F93E};
static const lxb_unicode_data_t lxb_unicode_data_2F93F = {&lxb_unicode_entry_2F93F, &lxb_unicode_idna_map_2F93F};
static const lxb_unicode_data_t lxb_unicode_data_2F940 = {&lxb_unicode_entry_2F940, &lxb_unicode_idna_map_2F940};
static const lxb_unicode_data_t lxb_unicode_data_2F941 = {&lxb_unicode_entry_2F941, &lxb_unicode_idna_map_2F941};
static const lxb_unicode_data_t lxb_unicode_data_2F942 = {&lxb_unicode_entry_2F942, &lxb_unicode_idna_map_2F942};
static const lxb_unicode_data_t lxb_unicode_data_2F943 = {&lxb_unicode_entry_2F943, &lxb_unicode_idna_map_2F943};
static const lxb_unicode_data_t lxb_unicode_data_2F944 = {&lxb_unicode_entry_2F944, &lxb_unicode_idna_map_2F944};
static const lxb_unicode_data_t lxb_unicode_data_2F945 = {&lxb_unicode_entry_2F945, &lxb_unicode_idna_map_2F945};
static const lxb_unicode_data_t lxb_unicode_data_2F946 = {&lxb_unicode_entry_2F946, &lxb_unicode_idna_map_2F946};
static const lxb_unicode_data_t lxb_unicode_data_2F947 = {&lxb_unicode_entry_2F947, &lxb_unicode_idna_map_2F947};
static const lxb_unicode_data_t lxb_unicode_data_2F948 = {&lxb_unicode_entry_2F948, &lxb_unicode_idna_map_2F948};
static const lxb_unicode_data_t lxb_unicode_data_2F949 = {&lxb_unicode_entry_2F949, &lxb_unicode_idna_map_2F949};
static const lxb_unicode_data_t lxb_unicode_data_2F94A = {&lxb_unicode_entry_2F94A, &lxb_unicode_idna_map_2F94A};
static const lxb_unicode_data_t lxb_unicode_data_2F94B = {&lxb_unicode_entry_2F94B, &lxb_unicode_idna_map_2F94B};
static const lxb_unicode_data_t lxb_unicode_data_2F94C = {&lxb_unicode_entry_2F94C, &lxb_unicode_idna_map_2F94C};
static const lxb_unicode_data_t lxb_unicode_data_2F94D = {&lxb_unicode_entry_2F94D, &lxb_unicode_idna_map_2F94D};
static const lxb_unicode_data_t lxb_unicode_data_2F94E = {&lxb_unicode_entry_2F94E, &lxb_unicode_idna_map_2F94E};
static const lxb_unicode_data_t lxb_unicode_data_2F94F = {&lxb_unicode_entry_2F94F, &lxb_unicode_idna_map_2F94F};
static const lxb_unicode_data_t lxb_unicode_data_2F950 = {&lxb_unicode_entry_2F950, &lxb_unicode_idna_map_2F950};
static const lxb_unicode_data_t lxb_unicode_data_2F951 = {&lxb_unicode_entry_2F951, &lxb_unicode_idna_map_2F951};
static const lxb_unicode_data_t lxb_unicode_data_2F952 = {&lxb_unicode_entry_2F952, &lxb_unicode_idna_map_2F952};
static const lxb_unicode_data_t lxb_unicode_data_2F953 = {&lxb_unicode_entry_2F953, &lxb_unicode_idna_map_2F953};
static const lxb_unicode_data_t lxb_unicode_data_2F954 = {&lxb_unicode_entry_2F954, &lxb_unicode_idna_map_2F954};
static const lxb_unicode_data_t lxb_unicode_data_2F955 = {&lxb_unicode_entry_2F955, &lxb_unicode_idna_map_2F955};
static const lxb_unicode_data_t lxb_unicode_data_2F956 = {&lxb_unicode_entry_2F956, &lxb_unicode_idna_map_2F956};
static const lxb_unicode_data_t lxb_unicode_data_2F957 = {&lxb_unicode_entry_2F957, &lxb_unicode_idna_map_2F957};
static const lxb_unicode_data_t lxb_unicode_data_2F958 = {&lxb_unicode_entry_2F958, &lxb_unicode_idna_map_2F958};
static const lxb_unicode_data_t lxb_unicode_data_2F959 = {&lxb_unicode_entry_2F959, &lxb_unicode_idna_map_2F959};
static const lxb_unicode_data_t lxb_unicode_data_2F95A = {&lxb_unicode_entry_2F95A, &lxb_unicode_idna_map_2F95A};
static const lxb_unicode_data_t lxb_unicode_data_2F95B = {&lxb_unicode_entry_2F95B, &lxb_unicode_idna_map_2F95B};
static const lxb_unicode_data_t lxb_unicode_data_2F95C = {&lxb_unicode_entry_2F95C, &lxb_unicode_idna_map_2F95C};
static const lxb_unicode_data_t lxb_unicode_data_2F95D = {&lxb_unicode_entry_2F95D, &lxb_unicode_idna_map_2F95D};
static const lxb_unicode_data_t lxb_unicode_data_2F95E = {&lxb_unicode_entry_2F95E, &lxb_unicode_idna_map_2F95E};
static const lxb_unicode_data_t lxb_unicode_data_2F95F = {&lxb_unicode_entry_2F95F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_2F960 = {&lxb_unicode_entry_2F960, &lxb_unicode_idna_map_2F960};
static const lxb_unicode_data_t lxb_unicode_data_2F961 = {&lxb_unicode_entry_2F961, &lxb_unicode_idna_map_2F961};
static const lxb_unicode_data_t lxb_unicode_data_2F962 = {&lxb_unicode_entry_2F962, &lxb_unicode_idna_map_2F962};
static const lxb_unicode_data_t lxb_unicode_data_2F963 = {&lxb_unicode_entry_2F963, &lxb_unicode_idna_map_2F963};
static const lxb_unicode_data_t lxb_unicode_data_2F964 = {&lxb_unicode_entry_2F964, &lxb_unicode_idna_map_2F964};
static const lxb_unicode_data_t lxb_unicode_data_2F965 = {&lxb_unicode_entry_2F965, &lxb_unicode_idna_map_2F965};
static const lxb_unicode_data_t lxb_unicode_data_2F966 = {&lxb_unicode_entry_2F966, &lxb_unicode_idna_map_2F966};
static const lxb_unicode_data_t lxb_unicode_data_2F967 = {&lxb_unicode_entry_2F967, &lxb_unicode_idna_map_2F967};
static const lxb_unicode_data_t lxb_unicode_data_2F968 = {&lxb_unicode_entry_2F968, &lxb_unicode_idna_map_2F968};
static const lxb_unicode_data_t lxb_unicode_data_2F969 = {&lxb_unicode_entry_2F969, &lxb_unicode_idna_map_2F969};
static const lxb_unicode_data_t lxb_unicode_data_2F96A = {&lxb_unicode_entry_2F96A, &lxb_unicode_idna_map_2F96A};
static const lxb_unicode_data_t lxb_unicode_data_2F96B = {&lxb_unicode_entry_2F96B, &lxb_unicode_idna_map_2F96B};
static const lxb_unicode_data_t lxb_unicode_data_2F96C = {&lxb_unicode_entry_2F96C, &lxb_unicode_idna_map_2F96C};
static const lxb_unicode_data_t lxb_unicode_data_2F96D = {&lxb_unicode_entry_2F96D, &lxb_unicode_idna_map_2F96D};
static const lxb_unicode_data_t lxb_unicode_data_2F96E = {&lxb_unicode_entry_2F96E, &lxb_unicode_idna_map_2F96E};
static const lxb_unicode_data_t lxb_unicode_data_2F96F = {&lxb_unicode_entry_2F96F, &lxb_unicode_idna_map_2F96F};
static const lxb_unicode_data_t lxb_unicode_data_2F970 = {&lxb_unicode_entry_2F970, &lxb_unicode_idna_map_2F970};
static const lxb_unicode_data_t lxb_unicode_data_2F971 = {&lxb_unicode_entry_2F971, &lxb_unicode_idna_map_2F971};
static const lxb_unicode_data_t lxb_unicode_data_2F972 = {&lxb_unicode_entry_2F972, &lxb_unicode_idna_map_2F972};
static const lxb_unicode_data_t lxb_unicode_data_2F973 = {&lxb_unicode_entry_2F973, &lxb_unicode_idna_map_2F973};
static const lxb_unicode_data_t lxb_unicode_data_2F974 = {&lxb_unicode_entry_2F974, &lxb_unicode_idna_map_2F974};
static const lxb_unicode_data_t lxb_unicode_data_2F975 = {&lxb_unicode_entry_2F975, &lxb_unicode_idna_map_2F975};
static const lxb_unicode_data_t lxb_unicode_data_2F976 = {&lxb_unicode_entry_2F976, &lxb_unicode_idna_map_2F976};
static const lxb_unicode_data_t lxb_unicode_data_2F977 = {&lxb_unicode_entry_2F977, &lxb_unicode_idna_map_2F977};
static const lxb_unicode_data_t lxb_unicode_data_2F978 = {&lxb_unicode_entry_2F978, &lxb_unicode_idna_map_2F978};
static const lxb_unicode_data_t lxb_unicode_data_2F979 = {&lxb_unicode_entry_2F979, &lxb_unicode_idna_map_2F979};
static const lxb_unicode_data_t lxb_unicode_data_2F97A = {&lxb_unicode_entry_2F97A, &lxb_unicode_idna_map_2F97A};
static const lxb_unicode_data_t lxb_unicode_data_2F97B = {&lxb_unicode_entry_2F97B, &lxb_unicode_idna_map_2F97B};
static const lxb_unicode_data_t lxb_unicode_data_2F97C = {&lxb_unicode_entry_2F97C, &lxb_unicode_idna_map_2F97C};
static const lxb_unicode_data_t lxb_unicode_data_2F97D = {&lxb_unicode_entry_2F97D, &lxb_unicode_idna_map_2F97D};
static const lxb_unicode_data_t lxb_unicode_data_2F97E = {&lxb_unicode_entry_2F97E, &lxb_unicode_idna_map_2F97E};
static const lxb_unicode_data_t lxb_unicode_data_2F97F = {&lxb_unicode_entry_2F97F, &lxb_unicode_idna_map_2F97F};
static const lxb_unicode_data_t lxb_unicode_data_2F980 = {&lxb_unicode_entry_2F980, &lxb_unicode_idna_map_2F980};
static const lxb_unicode_data_t lxb_unicode_data_2F981 = {&lxb_unicode_entry_2F981, &lxb_unicode_idna_map_2F981};
static const lxb_unicode_data_t lxb_unicode_data_2F982 = {&lxb_unicode_entry_2F982, &lxb_unicode_idna_map_2F982};
static const lxb_unicode_data_t lxb_unicode_data_2F983 = {&lxb_unicode_entry_2F983, &lxb_unicode_idna_map_2F983};
static const lxb_unicode_data_t lxb_unicode_data_2F984 = {&lxb_unicode_entry_2F984, &lxb_unicode_idna_map_2F984};
static const lxb_unicode_data_t lxb_unicode_data_2F985 = {&lxb_unicode_entry_2F985, &lxb_unicode_idna_map_2F985};
static const lxb_unicode_data_t lxb_unicode_data_2F986 = {&lxb_unicode_entry_2F986, &lxb_unicode_idna_map_2F986};
static const lxb_unicode_data_t lxb_unicode_data_2F987 = {&lxb_unicode_entry_2F987, &lxb_unicode_idna_map_2F987};
static const lxb_unicode_data_t lxb_unicode_data_2F988 = {&lxb_unicode_entry_2F988, &lxb_unicode_idna_map_2F988};
static const lxb_unicode_data_t lxb_unicode_data_2F989 = {&lxb_unicode_entry_2F989, &lxb_unicode_idna_map_2F989};
static const lxb_unicode_data_t lxb_unicode_data_2F98A = {&lxb_unicode_entry_2F98A, &lxb_unicode_idna_map_2F98A};
static const lxb_unicode_data_t lxb_unicode_data_2F98B = {&lxb_unicode_entry_2F98B, &lxb_unicode_idna_map_2F98B};
static const lxb_unicode_data_t lxb_unicode_data_2F98C = {&lxb_unicode_entry_2F98C, &lxb_unicode_idna_map_2F98C};
static const lxb_unicode_data_t lxb_unicode_data_2F98D = {&lxb_unicode_entry_2F98D, &lxb_unicode_idna_map_2F98D};
static const lxb_unicode_data_t lxb_unicode_data_2F98E = {&lxb_unicode_entry_2F98E, &lxb_unicode_idna_map_2F98E};
static const lxb_unicode_data_t lxb_unicode_data_2F98F = {&lxb_unicode_entry_2F98F, &lxb_unicode_idna_map_2F98F};
static const lxb_unicode_data_t lxb_unicode_data_2F990 = {&lxb_unicode_entry_2F990, &lxb_unicode_idna_map_2F990};
static const lxb_unicode_data_t lxb_unicode_data_2F991 = {&lxb_unicode_entry_2F991, &lxb_unicode_idna_map_2F991};
static const lxb_unicode_data_t lxb_unicode_data_2F992 = {&lxb_unicode_entry_2F992, &lxb_unicode_idna_map_2F992};
static const lxb_unicode_data_t lxb_unicode_data_2F993 = {&lxb_unicode_entry_2F993, &lxb_unicode_idna_map_2F993};
static const lxb_unicode_data_t lxb_unicode_data_2F994 = {&lxb_unicode_entry_2F994, &lxb_unicode_idna_map_2F994};
static const lxb_unicode_data_t lxb_unicode_data_2F995 = {&lxb_unicode_entry_2F995, &lxb_unicode_idna_map_2F995};
static const lxb_unicode_data_t lxb_unicode_data_2F996 = {&lxb_unicode_entry_2F996, &lxb_unicode_idna_map_2F996};
static const lxb_unicode_data_t lxb_unicode_data_2F997 = {&lxb_unicode_entry_2F997, &lxb_unicode_idna_map_2F997};
static const lxb_unicode_data_t lxb_unicode_data_2F998 = {&lxb_unicode_entry_2F998, &lxb_unicode_idna_map_2F998};
static const lxb_unicode_data_t lxb_unicode_data_2F999 = {&lxb_unicode_entry_2F999, &lxb_unicode_idna_map_2F999};
static const lxb_unicode_data_t lxb_unicode_data_2F99A = {&lxb_unicode_entry_2F99A, &lxb_unicode_idna_map_2F99A};
static const lxb_unicode_data_t lxb_unicode_data_2F99B = {&lxb_unicode_entry_2F99B, &lxb_unicode_idna_map_2F99B};
static const lxb_unicode_data_t lxb_unicode_data_2F99C = {&lxb_unicode_entry_2F99C, &lxb_unicode_idna_map_2F99C};
static const lxb_unicode_data_t lxb_unicode_data_2F99D = {&lxb_unicode_entry_2F99D, &lxb_unicode_idna_map_2F99D};
static const lxb_unicode_data_t lxb_unicode_data_2F99E = {&lxb_unicode_entry_2F99E, &lxb_unicode_idna_map_2F99E};
static const lxb_unicode_data_t lxb_unicode_data_2F99F = {&lxb_unicode_entry_2F99F, &lxb_unicode_idna_map_2F99F};
static const lxb_unicode_data_t lxb_unicode_data_2F9A0 = {&lxb_unicode_entry_2F9A0, &lxb_unicode_idna_map_2F9A0};
static const lxb_unicode_data_t lxb_unicode_data_2F9A1 = {&lxb_unicode_entry_2F9A1, &lxb_unicode_idna_map_2F9A1};
static const lxb_unicode_data_t lxb_unicode_data_2F9A2 = {&lxb_unicode_entry_2F9A2, &lxb_unicode_idna_map_2F9A2};
static const lxb_unicode_data_t lxb_unicode_data_2F9A3 = {&lxb_unicode_entry_2F9A3, &lxb_unicode_idna_map_2F9A3};
static const lxb_unicode_data_t lxb_unicode_data_2F9A4 = {&lxb_unicode_entry_2F9A4, &lxb_unicode_idna_map_2F9A4};
static const lxb_unicode_data_t lxb_unicode_data_2F9A5 = {&lxb_unicode_entry_2F9A5, &lxb_unicode_idna_map_2F9A5};
static const lxb_unicode_data_t lxb_unicode_data_2F9A6 = {&lxb_unicode_entry_2F9A6, &lxb_unicode_idna_map_2F9A6};
static const lxb_unicode_data_t lxb_unicode_data_2F9A7 = {&lxb_unicode_entry_2F9A7, &lxb_unicode_idna_map_2F9A7};
static const lxb_unicode_data_t lxb_unicode_data_2F9A8 = {&lxb_unicode_entry_2F9A8, &lxb_unicode_idna_map_2F9A8};
static const lxb_unicode_data_t lxb_unicode_data_2F9A9 = {&lxb_unicode_entry_2F9A9, &lxb_unicode_idna_map_2F9A9};
static const lxb_unicode_data_t lxb_unicode_data_2F9AA = {&lxb_unicode_entry_2F9AA, &lxb_unicode_idna_map_2F9AA};
static const lxb_unicode_data_t lxb_unicode_data_2F9AB = {&lxb_unicode_entry_2F9AB, &lxb_unicode_idna_map_2F9AB};
static const lxb_unicode_data_t lxb_unicode_data_2F9AC = {&lxb_unicode_entry_2F9AC, &lxb_unicode_idna_map_2F9AC};
static const lxb_unicode_data_t lxb_unicode_data_2F9AD = {&lxb_unicode_entry_2F9AD, &lxb_unicode_idna_map_2F9AD};
static const lxb_unicode_data_t lxb_unicode_data_2F9AE = {&lxb_unicode_entry_2F9AE, &lxb_unicode_idna_map_2F9AE};
static const lxb_unicode_data_t lxb_unicode_data_2F9AF = {&lxb_unicode_entry_2F9AF, &lxb_unicode_idna_map_2F9AF};
static const lxb_unicode_data_t lxb_unicode_data_2F9B0 = {&lxb_unicode_entry_2F9B0, &lxb_unicode_idna_map_2F9B0};
static const lxb_unicode_data_t lxb_unicode_data_2F9B1 = {&lxb_unicode_entry_2F9B1, &lxb_unicode_idna_map_2F9B1};
static const lxb_unicode_data_t lxb_unicode_data_2F9B2 = {&lxb_unicode_entry_2F9B2, &lxb_unicode_idna_map_2F9B2};
static const lxb_unicode_data_t lxb_unicode_data_2F9B3 = {&lxb_unicode_entry_2F9B3, &lxb_unicode_idna_map_2F9B3};
static const lxb_unicode_data_t lxb_unicode_data_2F9B4 = {&lxb_unicode_entry_2F9B4, &lxb_unicode_idna_map_2F9B4};
static const lxb_unicode_data_t lxb_unicode_data_2F9B5 = {&lxb_unicode_entry_2F9B5, &lxb_unicode_idna_map_2F9B5};
static const lxb_unicode_data_t lxb_unicode_data_2F9B6 = {&lxb_unicode_entry_2F9B6, &lxb_unicode_idna_map_2F9B6};
static const lxb_unicode_data_t lxb_unicode_data_2F9B7 = {&lxb_unicode_entry_2F9B7, &lxb_unicode_idna_map_2F9B7};
static const lxb_unicode_data_t *lxb_unicode_table_38[5000] = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_2F800,
    &lxb_unicode_data_2F801,
    &lxb_unicode_data_2F802,
    &lxb_unicode_data_2F803,
    &lxb_unicode_data_2F804,
    &lxb_unicode_data_2F805,
    &lxb_unicode_data_2F806,
    &lxb_unicode_data_2F807,
    &lxb_unicode_data_2F808,
    &lxb_unicode_data_2F809,
    &lxb_unicode_data_2F80A,
    &lxb_unicode_data_2F80B,
    &lxb_unicode_data_2F80C,
    &lxb_unicode_data_2F80D,
    &lxb_unicode_data_2F80E,
    &lxb_unicode_data_2F80F,
    &lxb_unicode_data_2F810,
    &lxb_unicode_data_2F811,
    &lxb_unicode_data_2F812,
    &lxb_unicode_data_2F813,
    &lxb_unicode_data_2F814,
    &lxb_unicode_data_2F815,
    &lxb_unicode_data_2F816,
    &lxb_unicode_data_2F817,
    &lxb_unicode_data_2F818,
    &lxb_unicode_data_2F819,
    &lxb_unicode_data_2F81A,
    &lxb_unicode_data_2F81B,
    &lxb_unicode_data_2F81C,
    &lxb_unicode_data_2F81D,
    &lxb_unicode_data_2F81E,
    &lxb_unicode_data_2F81F,
    &lxb_unicode_data_2F820,
    &lxb_unicode_data_2F821,
    &lxb_unicode_data_2F822,
    &lxb_unicode_data_2F823,
    &lxb_unicode_data_2F824,
    &lxb_unicode_data_2F825,
    &lxb_unicode_data_2F826,
    &lxb_unicode_data_2F827,
    &lxb_unicode_data_2F828,
    &lxb_unicode_data_2F829,
    &lxb_unicode_data_2F82A,
    &lxb_unicode_data_2F82B,
    &lxb_unicode_data_2F82C,
    &lxb_unicode_data_2F82D,
    &lxb_unicode_data_2F82E,
    &lxb_unicode_data_2F82F,
    &lxb_unicode_data_2F830,
    &lxb_unicode_data_2F831,
    &lxb_unicode_data_2F832,
    &lxb_unicode_data_2F833,
    &lxb_unicode_data_2F834,
    &lxb_unicode_data_2F835,
    &lxb_unicode_data_2F836,
    &lxb_unicode_data_2F837,
    &lxb_unicode_data_2F838,
    &lxb_unicode_data_2F839,
    &lxb_unicode_data_2F83A,
    &lxb_unicode_data_2F83B,
    &lxb_unicode_data_2F83C,
    &lxb_unicode_data_2F83D,
    &lxb_unicode_data_2F83E,
    &lxb_unicode_data_2F83F,
    &lxb_unicode_data_2F840,
    &lxb_unicode_data_2F841,
    &lxb_unicode_data_2F842,
    &lxb_unicode_data_2F843,
    &lxb_unicode_data_2F844,
    &lxb_unicode_data_2F845,
    &lxb_unicode_data_2F846,
    &lxb_unicode_data_2F847,
    &lxb_unicode_data_2F848,
    &lxb_unicode_data_2F849,
    &lxb_unicode_data_2F84A,
    &lxb_unicode_data_2F84B,
    &lxb_unicode_data_2F84C,
    &lxb_unicode_data_2F84D,
    &lxb_unicode_data_2F84E,
    &lxb_unicode_data_2F84F,
    &lxb_unicode_data_2F850,
    &lxb_unicode_data_2F851,
    &lxb_unicode_data_2F852,
    &lxb_unicode_data_2F853,
    &lxb_unicode_data_2F854,
    &lxb_unicode_data_2F855,
    &lxb_unicode_data_2F856,
    &lxb_unicode_data_2F857,
    &lxb_unicode_data_2F858,
    &lxb_unicode_data_2F859,
    &lxb_unicode_data_2F85A,
    &lxb_unicode_data_2F85B,
    &lxb_unicode_data_2F85C,
    &lxb_unicode_data_2F85D,
    &lxb_unicode_data_2F85E,
    &lxb_unicode_data_2F85F,
    &lxb_unicode_data_2F860,
    &lxb_unicode_data_2F861,
    &lxb_unicode_data_2F862,
    &lxb_unicode_data_2F863,
    &lxb_unicode_data_2F864,
    &lxb_unicode_data_2F865,
    &lxb_unicode_data_2F866,
    &lxb_unicode_data_2F867,
    &lxb_unicode_data_2F868,
    &lxb_unicode_data_2F869,
    &lxb_unicode_data_2F86A,
    &lxb_unicode_data_2F86B,
    &lxb_unicode_data_2F86C,
    &lxb_unicode_data_2F86D,
    &lxb_unicode_data_2F86E,
    &lxb_unicode_data_2F86F,
    &lxb_unicode_data_2F870,
    &lxb_unicode_data_2F871,
    &lxb_unicode_data_2F872,
    &lxb_unicode_data_2F873,
    &lxb_unicode_data_2F874,
    &lxb_unicode_data_2F875,
    &lxb_unicode_data_2F876,
    &lxb_unicode_data_2F877,
    &lxb_unicode_data_2F878,
    &lxb_unicode_data_2F879,
    &lxb_unicode_data_2F87A,
    &lxb_unicode_data_2F87B,
    &lxb_unicode_data_2F87C,
    &lxb_unicode_data_2F87D,
    &lxb_unicode_data_2F87E,
    &lxb_unicode_data_2F87F,
    &lxb_unicode_data_2F880,
    &lxb_unicode_data_2F881,
    &lxb_unicode_data_2F882,
    &lxb_unicode_data_2F883,
    &lxb_unicode_data_2F884,
    &lxb_unicode_data_2F885,
    &lxb_unicode_data_2F886,
    &lxb_unicode_data_2F887,
    &lxb_unicode_data_2F888,
    &lxb_unicode_data_2F889,
    &lxb_unicode_data_2F88A,
    &lxb_unicode_data_2F88B,
    &lxb_unicode_data_2F88C,
    &lxb_unicode_data_2F88D,
    &lxb_unicode_data_2F88E,
    &lxb_unicode_data_2F88F,
    &lxb_unicode_data_2F890,
    &lxb_unicode_data_2F891,
    &lxb_unicode_data_2F892,
    &lxb_unicode_data_2F893,
    &lxb_unicode_data_2F894,
    &lxb_unicode_data_2F895,
    &lxb_unicode_data_2F896,
    &lxb_unicode_data_2F897,
    &lxb_unicode_data_2F898,
    &lxb_unicode_data_2F899,
    &lxb_unicode_data_2F89A,
    &lxb_unicode_data_2F89B,
    &lxb_unicode_data_2F89C,
    &lxb_unicode_data_2F89D,
    &lxb_unicode_data_2F89E,
    &lxb_unicode_data_2F89F,
    &lxb_unicode_data_2F8A0,
    &lxb_unicode_data_2F8A1,
    &lxb_unicode_data_2F8A2,
    &lxb_unicode_data_2F8A3,
    &lxb_unicode_data_2F8A4,
    &lxb_unicode_data_2F8A5,
    &lxb_unicode_data_2F8A6,
    &lxb_unicode_data_2F8A7,
    &lxb_unicode_data_2F8A8,
    &lxb_unicode_data_2F8A9,
    &lxb_unicode_data_2F8AA,
    &lxb_unicode_data_2F8AB,
    &lxb_unicode_data_2F8AC,
    &lxb_unicode_data_2F8AD,
    &lxb_unicode_data_2F8AE,
    &lxb_unicode_data_2F8AF,
    &lxb_unicode_data_2F8B0,
    &lxb_unicode_data_2F8B1,
    &lxb_unicode_data_2F8B2,
    &lxb_unicode_data_2F8B3,
    &lxb_unicode_data_2F8B4,
    &lxb_unicode_data_2F8B5,
    &lxb_unicode_data_2F8B6,
    &lxb_unicode_data_2F8B7,
    &lxb_unicode_data_2F8B8,
    &lxb_unicode_data_2F8B9,
    &lxb_unicode_data_2F8BA,
    &lxb_unicode_data_2F8BB,
    &lxb_unicode_data_2F8BC,
    &lxb_unicode_data_2F8BD,
    &lxb_unicode_data_2F8BE,
    &lxb_unicode_data_2F8BF,
    &lxb_unicode_data_2F8C0,
    &lxb_unicode_data_2F8C1,
    &lxb_unicode_data_2F8C2,
    &lxb_unicode_data_2F8C3,
    &lxb_unicode_data_2F8C4,
    &lxb_unicode_data_2F8C5,
    &lxb_unicode_data_2F8C6,
    &lxb_unicode_data_2F8C7,
    &lxb_unicode_data_2F8C8,
    &lxb_unicode_data_2F8C9,
    &lxb_unicode_data_2F8CA,
    &lxb_unicode_data_2F8CB,
    &lxb_unicode_data_2F8CC,
    &lxb_unicode_data_2F8CD,
    &lxb_unicode_data_2F8CE,
    &lxb_unicode_data_2F8CF,
    &lxb_unicode_data_2F8D0,
    &lxb_unicode_data_2F8D1,
    &lxb_unicode_data_2F8D2,
    &lxb_unicode_data_2F8D3,
    &lxb_unicode_data_2F8D4,
    &lxb_unicode_data_2F8D5,
    &lxb_unicode_data_2F8D6,
    &lxb_unicode_data_2F8D7,
    &lxb_unicode_data_2F8D8,
    &lxb_unicode_data_2F8D9,
    &lxb_unicode_data_2F8DA,
    &lxb_unicode_data_2F8DB,
    &lxb_unicode_data_2F8DC,
    &lxb_unicode_data_2F8DD,
    &lxb_unicode_data_2F8DE,
    &lxb_unicode_data_2F8DF,
    &lxb_unicode_data_2F8E0,
    &lxb_unicode_data_2F8E1,
    &lxb_unicode_data_2F8E2,
    &lxb_unicode_data_2F8E3,
    &lxb_unicode_data_2F8E4,
    &lxb_unicode_data_2F8E5,
    &lxb_unicode_data_2F8E6,
    &lxb_unicode_data_2F8E7,
    &lxb_unicode_data_2F8E8,
    &lxb_unicode_data_2F8E9,
    &lxb_unicode_data_2F8EA,
    &lxb_unicode_data_2F8EB,
    &lxb_unicode_data_2F8EC,
    &lxb_unicode_data_2F8ED,
    &lxb_unicode_data_2F8EE,
    &lxb_unicode_data_2F8EF,
    &lxb_unicode_data_2F8F0,
    &lxb_unicode_data_2F8F1,
    &lxb_unicode_data_2F8F2,
    &lxb_unicode_data_2F8F3,
    &lxb_unicode_data_2F8F4,
    &lxb_unicode_data_2F8F5,
    &lxb_unicode_data_2F8F6,
    &lxb_unicode_data_2F8F7,
    &lxb_unicode_data_2F8F8,
    &lxb_unicode_data_2F8F9,
    &lxb_unicode_data_2F8FA,
    &lxb_unicode_data_2F8FB,
    &lxb_unicode_data_2F8FC,
    &lxb_unicode_data_2F8FD,
    &lxb_unicode_data_2F8FE,
    &lxb_unicode_data_2F8FF,
    &lxb_unicode_data_2F900,
    &lxb_unicode_data_2F901,
    &lxb_unicode_data_2F902,
    &lxb_unicode_data_2F903,
    &lxb_unicode_data_2F904,
    &lxb_unicode_data_2F905,
    &lxb_unicode_data_2F906,
    &lxb_unicode_data_2F907,
    &lxb_unicode_data_2F908,
    &lxb_unicode_data_2F909,
    &lxb_unicode_data_2F90A,
    &lxb_unicode_data_2F90B,
    &lxb_unicode_data_2F90C,
    &lxb_unicode_data_2F90D,
    &lxb_unicode_data_2F90E,
    &lxb_unicode_data_2F90F,
    &lxb_unicode_data_2F910,
    &lxb_unicode_data_2F911,
    &lxb_unicode_data_2F912,
    &lxb_unicode_data_2F913,
    &lxb_unicode_data_2F914,
    &lxb_unicode_data_2F915,
    &lxb_unicode_data_2F916,
    &lxb_unicode_data_2F917,
    &lxb_unicode_data_2F918,
    &lxb_unicode_data_2F919,
    &lxb_unicode_data_2F91A,
    &lxb_unicode_data_2F91B,
    &lxb_unicode_data_2F91C,
    &lxb_unicode_data_2F91D,
    &lxb_unicode_data_2F91E,
    &lxb_unicode_data_2F91F,
    &lxb_unicode_data_2F920,
    &lxb_unicode_data_2F921,
    &lxb_unicode_data_2F922,
    &lxb_unicode_data_2F923,
    &lxb_unicode_data_2F924,
    &lxb_unicode_data_2F925,
    &lxb_unicode_data_2F926,
    &lxb_unicode_data_2F927,
    &lxb_unicode_data_2F928,
    &lxb_unicode_data_2F929,
    &lxb_unicode_data_2F92A,
    &lxb_unicode_data_2F92B,
    &lxb_unicode_data_2F92C,
    &lxb_unicode_data_2F92D,
    &lxb_unicode_data_2F92E,
    &lxb_unicode_data_2F92F,
    &lxb_unicode_data_2F930,
    &lxb_unicode_data_2F931,
    &lxb_unicode_data_2F932,
    &lxb_unicode_data_2F933,
    &lxb_unicode_data_2F934,
    &lxb_unicode_data_2F935,
    &lxb_unicode_data_2F936,
    &lxb_unicode_data_2F937,
    &lxb_unicode_data_2F938,
    &lxb_unicode_data_2F939,
    &lxb_unicode_data_2F93A,
    &lxb_unicode_data_2F93B,
    &lxb_unicode_data_2F93C,
    &lxb_unicode_data_2F93D,
    &lxb_unicode_data_2F93E,
    &lxb_unicode_data_2F93F,
    &lxb_unicode_data_2F940,
    &lxb_unicode_data_2F941,
    &lxb_unicode_data_2F942,
    &lxb_unicode_data_2F943,
    &lxb_unicode_data_2F944,
    &lxb_unicode_data_2F945,
    &lxb_unicode_data_2F946,
    &lxb_unicode_data_2F947,
    &lxb_unicode_data_2F948,
    &lxb_unicode_data_2F949,
    &lxb_unicode_data_2F94A,
    &lxb_unicode_data_2F94B,
    &lxb_unicode_data_2F94C,
    &lxb_unicode_data_2F94D,
    &lxb_unicode_data_2F94E,
    &lxb_unicode_data_2F94F,
    &lxb_unicode_data_2F950,
    &lxb_unicode_data_2F951,
    &lxb_unicode_data_2F952,
    &lxb_unicode_data_2F953,
    &lxb_unicode_data_2F954,
    &lxb_unicode_data_2F955,
    &lxb_unicode_data_2F956,
    &lxb_unicode_data_2F957,
    &lxb_unicode_data_2F958,
    &lxb_unicode_data_2F959,
    &lxb_unicode_data_2F95A,
    &lxb_unicode_data_2F95B,
    &lxb_unicode_data_2F95C,
    &lxb_unicode_data_2F95D,
    &lxb_unicode_data_2F95E,
    &lxb_unicode_data_2F95F,
    &lxb_unicode_data_2F960,
    &lxb_unicode_data_2F961,
    &lxb_unicode_data_2F962,
    &lxb_unicode_data_2F963,
    &lxb_unicode_data_2F964,
    &lxb_unicode_data_2F965,
    &lxb_unicode_data_2F966,
    &lxb_unicode_data_2F967,
    &lxb_unicode_data_2F968,
    &lxb_unicode_data_2F969,
    &lxb_unicode_data_2F96A,
    &lxb_unicode_data_2F96B,
    &lxb_unicode_data_2F96C,
    &lxb_unicode_data_2F96D,
    &lxb_unicode_data_2F96E,
    &lxb_unicode_data_2F96F,
    &lxb_unicode_data_2F970,
    &lxb_unicode_data_2F971,
    &lxb_unicode_data_2F972,
    &lxb_unicode_data_2F973,
    &lxb_unicode_data_2F974,
    &lxb_unicode_data_2F975,
    &lxb_unicode_data_2F976,
    &lxb_unicode_data_2F977,
    &lxb_unicode_data_2F978,
    &lxb_unicode_data_2F979,
    &lxb_unicode_data_2F97A,
    &lxb_unicode_data_2F97B,
    &lxb_unicode_data_2F97C,
    &lxb_unicode_data_2F97D,
    &lxb_unicode_data_2F97E,
    &lxb_unicode_data_2F97F,
    &lxb_unicode_data_2F980,
    &lxb_unicode_data_2F981,
    &lxb_unicode_data_2F982,
    &lxb_unicode_data_2F983,
    &lxb_unicode_data_2F984,
    &lxb_unicode_data_2F985,
    &lxb_unicode_data_2F986,
    &lxb_unicode_data_2F987,
    &lxb_unicode_data_2F988,
    &lxb_unicode_data_2F989,
    &lxb_unicode_data_2F98A,
    &lxb_unicode_data_2F98B,
    &lxb_unicode_data_2F98C,
    &lxb_unicode_data_2F98D,
    &lxb_unicode_data_2F98E,
    &lxb_unicode_data_2F98F,
    &lxb_unicode_data_2F990,
    &lxb_unicode_data_2F991,
    &lxb_unicode_data_2F992,
    &lxb_unicode_data_2F993,
    &lxb_unicode_data_2F994,
    &lxb_unicode_data_2F995,
    &lxb_unicode_data_2F996,
    &lxb_unicode_data_2F997,
    &lxb_unicode_data_2F998,
    &lxb_unicode_data_2F999,
    &lxb_unicode_data_2F99A,
    &lxb_unicode_data_2F99B,
    &lxb_unicode_data_2F99C,
    &lxb_unicode_data_2F99D,
    &lxb_unicode_data_2F99E,
    &lxb_unicode_data_2F99F,
    &lxb_unicode_data_2F9A0,
    &lxb_unicode_data_2F9A1,
    &lxb_unicode_data_2F9A2,
    &lxb_unicode_data_2F9A3,
    &lxb_unicode_data_2F9A4,
    &lxb_unicode_data_2F9A5,
    &lxb_unicode_data_2F9A6,
    &lxb_unicode_data_2F9A7,
    &lxb_unicode_data_2F9A8,
    &lxb_unicode_data_2F9A9,
    &lxb_unicode_data_2F9AA,
    &lxb_unicode_data_2F9AB,
    &lxb_unicode_data_2F9AC,
    &lxb_unicode_data_2F9AD,
    &lxb_unicode_data_2F9AE,
    &lxb_unicode_data_2F9AF,
    &lxb_unicode_data_2F9B0,
    &lxb_unicode_data_2F9B1,
    &lxb_unicode_data_2F9B2,
    &lxb_unicode_data_2F9B3,
    &lxb_unicode_data_2F9B4,
    &lxb_unicode_data_2F9B5,
    &lxb_unicode_data_2F9B6,
    &lxb_unicode_data_2F9B7
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_38_H */
