/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_8_H
#define LEXBOR_UNICODE_TABLES_8_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A640 = {.cps = (lxb_codepoint_t[]) {0xA641}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A642 = {.cps = (lxb_codepoint_t[]) {0xA643}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A644 = {.cps = (lxb_codepoint_t[]) {0xA645}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A646 = {.cps = (lxb_codepoint_t[]) {0xA647}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A648 = {.cps = (lxb_codepoint_t[]) {0xA649}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A64A = {.cps = (lxb_codepoint_t[]) {0xA64B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A64C = {.cps = (lxb_codepoint_t[]) {0xA64D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A64E = {.cps = (lxb_codepoint_t[]) {0xA64F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A650 = {.cps = (lxb_codepoint_t[]) {0xA651}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A652 = {.cps = (lxb_codepoint_t[]) {0xA653}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A654 = {.cps = (lxb_codepoint_t[]) {0xA655}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A656 = {.cps = (lxb_codepoint_t[]) {0xA657}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A658 = {.cps = (lxb_codepoint_t[]) {0xA659}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A65A = {.cps = (lxb_codepoint_t[]) {0xA65B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A65C = {.cps = (lxb_codepoint_t[]) {0xA65D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A65E = {.cps = (lxb_codepoint_t[]) {0xA65F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A660 = {.cps = (lxb_codepoint_t[]) {0xA661}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A662 = {.cps = (lxb_codepoint_t[]) {0xA663}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A664 = {.cps = (lxb_codepoint_t[]) {0xA665}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A666 = {.cps = (lxb_codepoint_t[]) {0xA667}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A668 = {.cps = (lxb_codepoint_t[]) {0xA669}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A66A = {.cps = (lxb_codepoint_t[]) {0xA66B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A66C = {.cps = (lxb_codepoint_t[]) {0xA66D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A680 = {.cps = (lxb_codepoint_t[]) {0xA681}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A682 = {.cps = (lxb_codepoint_t[]) {0xA683}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A684 = {.cps = (lxb_codepoint_t[]) {0xA685}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A686 = {.cps = (lxb_codepoint_t[]) {0xA687}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A688 = {.cps = (lxb_codepoint_t[]) {0xA689}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A68A = {.cps = (lxb_codepoint_t[]) {0xA68B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A68C = {.cps = (lxb_codepoint_t[]) {0xA68D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A68E = {.cps = (lxb_codepoint_t[]) {0xA68F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A690 = {.cps = (lxb_codepoint_t[]) {0xA691}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A692 = {.cps = (lxb_codepoint_t[]) {0xA693}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A694 = {.cps = (lxb_codepoint_t[]) {0xA695}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A696 = {.cps = (lxb_codepoint_t[]) {0xA697}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A698 = {.cps = (lxb_codepoint_t[]) {0xA699}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A69A = {.cps = (lxb_codepoint_t[]) {0xA69B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A69C = {.cps = (lxb_codepoint_t[]) {0x044A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A69D = {.cps = (lxb_codepoint_t[]) {0x044C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A722 = {.cps = (lxb_codepoint_t[]) {0xA723}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A724 = {.cps = (lxb_codepoint_t[]) {0xA725}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A726 = {.cps = (lxb_codepoint_t[]) {0xA727}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A728 = {.cps = (lxb_codepoint_t[]) {0xA729}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A72A = {.cps = (lxb_codepoint_t[]) {0xA72B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A72C = {.cps = (lxb_codepoint_t[]) {0xA72D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A72E = {.cps = (lxb_codepoint_t[]) {0xA72F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A732 = {.cps = (lxb_codepoint_t[]) {0xA733}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A734 = {.cps = (lxb_codepoint_t[]) {0xA735}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A736 = {.cps = (lxb_codepoint_t[]) {0xA737}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A738 = {.cps = (lxb_codepoint_t[]) {0xA739}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A73A = {.cps = (lxb_codepoint_t[]) {0xA73B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A73C = {.cps = (lxb_codepoint_t[]) {0xA73D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A73E = {.cps = (lxb_codepoint_t[]) {0xA73F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A740 = {.cps = (lxb_codepoint_t[]) {0xA741}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A742 = {.cps = (lxb_codepoint_t[]) {0xA743}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A744 = {.cps = (lxb_codepoint_t[]) {0xA745}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A746 = {.cps = (lxb_codepoint_t[]) {0xA747}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A748 = {.cps = (lxb_codepoint_t[]) {0xA749}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A74A = {.cps = (lxb_codepoint_t[]) {0xA74B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A74C = {.cps = (lxb_codepoint_t[]) {0xA74D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A74E = {.cps = (lxb_codepoint_t[]) {0xA74F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A750 = {.cps = (lxb_codepoint_t[]) {0xA751}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A752 = {.cps = (lxb_codepoint_t[]) {0xA753}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A754 = {.cps = (lxb_codepoint_t[]) {0xA755}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A756 = {.cps = (lxb_codepoint_t[]) {0xA757}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A758 = {.cps = (lxb_codepoint_t[]) {0xA759}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A75A = {.cps = (lxb_codepoint_t[]) {0xA75B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A75C = {.cps = (lxb_codepoint_t[]) {0xA75D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A75E = {.cps = (lxb_codepoint_t[]) {0xA75F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A760 = {.cps = (lxb_codepoint_t[]) {0xA761}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A762 = {.cps = (lxb_codepoint_t[]) {0xA763}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A764 = {.cps = (lxb_codepoint_t[]) {0xA765}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A766 = {.cps = (lxb_codepoint_t[]) {0xA767}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A768 = {.cps = (lxb_codepoint_t[]) {0xA769}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A76A = {.cps = (lxb_codepoint_t[]) {0xA76B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A76C = {.cps = (lxb_codepoint_t[]) {0xA76D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A76E = {.cps = (lxb_codepoint_t[]) {0xA76F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A770 = {.cps = (lxb_codepoint_t[]) {0xA76F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A779 = {.cps = (lxb_codepoint_t[]) {0xA77A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A77B = {.cps = (lxb_codepoint_t[]) {0xA77C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A77D = {.cps = (lxb_codepoint_t[]) {0x1D79}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A77E = {.cps = (lxb_codepoint_t[]) {0xA77F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A780 = {.cps = (lxb_codepoint_t[]) {0xA781}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A782 = {.cps = (lxb_codepoint_t[]) {0xA783}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A784 = {.cps = (lxb_codepoint_t[]) {0xA785}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A786 = {.cps = (lxb_codepoint_t[]) {0xA787}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A78B = {.cps = (lxb_codepoint_t[]) {0xA78C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A78D = {.cps = (lxb_codepoint_t[]) {0x0265}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A790 = {.cps = (lxb_codepoint_t[]) {0xA791}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A792 = {.cps = (lxb_codepoint_t[]) {0xA793}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A796 = {.cps = (lxb_codepoint_t[]) {0xA797}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A798 = {.cps = (lxb_codepoint_t[]) {0xA799}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A79A = {.cps = (lxb_codepoint_t[]) {0xA79B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A79C = {.cps = (lxb_codepoint_t[]) {0xA79D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A79E = {.cps = (lxb_codepoint_t[]) {0xA79F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7A0 = {.cps = (lxb_codepoint_t[]) {0xA7A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7A2 = {.cps = (lxb_codepoint_t[]) {0xA7A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7A4 = {.cps = (lxb_codepoint_t[]) {0xA7A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7A6 = {.cps = (lxb_codepoint_t[]) {0xA7A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7A8 = {.cps = (lxb_codepoint_t[]) {0xA7A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7AA = {.cps = (lxb_codepoint_t[]) {0x0266}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7AB = {.cps = (lxb_codepoint_t[]) {0x025C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7AC = {.cps = (lxb_codepoint_t[]) {0x0261}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7AD = {.cps = (lxb_codepoint_t[]) {0x026C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7AE = {.cps = (lxb_codepoint_t[]) {0x026A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B0 = {.cps = (lxb_codepoint_t[]) {0x029E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B1 = {.cps = (lxb_codepoint_t[]) {0x0287}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B2 = {.cps = (lxb_codepoint_t[]) {0x029D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B3 = {.cps = (lxb_codepoint_t[]) {0xAB53}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B4 = {.cps = (lxb_codepoint_t[]) {0xA7B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B6 = {.cps = (lxb_codepoint_t[]) {0xA7B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7B8 = {.cps = (lxb_codepoint_t[]) {0xA7B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7BA = {.cps = (lxb_codepoint_t[]) {0xA7BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7BC = {.cps = (lxb_codepoint_t[]) {0xA7BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7BE = {.cps = (lxb_codepoint_t[]) {0xA7BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C0 = {.cps = (lxb_codepoint_t[]) {0xA7C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C2 = {.cps = (lxb_codepoint_t[]) {0xA7C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C4 = {.cps = (lxb_codepoint_t[]) {0xA794}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C5 = {.cps = (lxb_codepoint_t[]) {0x0282}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C6 = {.cps = (lxb_codepoint_t[]) {0x1D8E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C7 = {.cps = (lxb_codepoint_t[]) {0xA7C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7C9 = {.cps = (lxb_codepoint_t[]) {0xA7CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7D0 = {.cps = (lxb_codepoint_t[]) {0xA7D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7D6 = {.cps = (lxb_codepoint_t[]) {0xA7D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7D8 = {.cps = (lxb_codepoint_t[]) {0xA7D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F2 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F3 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F4 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F5 = {.cps = (lxb_codepoint_t[]) {0xA7F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F8 = {.cps = (lxb_codepoint_t[]) {0x0127}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_A7F9 = {.cps = (lxb_codepoint_t[]) {0x0153}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB5C = {.cps = (lxb_codepoint_t[]) {0xA727}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB5D = {.cps = (lxb_codepoint_t[]) {0xAB37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB5E = {.cps = (lxb_codepoint_t[]) {0x026B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB5F = {.cps = (lxb_codepoint_t[]) {0xAB52}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB69 = {.cps = (lxb_codepoint_t[]) {0x028D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB70 = {.cps = (lxb_codepoint_t[]) {0x13A0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB71 = {.cps = (lxb_codepoint_t[]) {0x13A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB72 = {.cps = (lxb_codepoint_t[]) {0x13A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB73 = {.cps = (lxb_codepoint_t[]) {0x13A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB74 = {.cps = (lxb_codepoint_t[]) {0x13A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB75 = {.cps = (lxb_codepoint_t[]) {0x13A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB76 = {.cps = (lxb_codepoint_t[]) {0x13A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB77 = {.cps = (lxb_codepoint_t[]) {0x13A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB78 = {.cps = (lxb_codepoint_t[]) {0x13A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB79 = {.cps = (lxb_codepoint_t[]) {0x13A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7A = {.cps = (lxb_codepoint_t[]) {0x13AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7B = {.cps = (lxb_codepoint_t[]) {0x13AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7C = {.cps = (lxb_codepoint_t[]) {0x13AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7D = {.cps = (lxb_codepoint_t[]) {0x13AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7E = {.cps = (lxb_codepoint_t[]) {0x13AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB7F = {.cps = (lxb_codepoint_t[]) {0x13AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB80 = {.cps = (lxb_codepoint_t[]) {0x13B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB81 = {.cps = (lxb_codepoint_t[]) {0x13B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB82 = {.cps = (lxb_codepoint_t[]) {0x13B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB83 = {.cps = (lxb_codepoint_t[]) {0x13B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB84 = {.cps = (lxb_codepoint_t[]) {0x13B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB85 = {.cps = (lxb_codepoint_t[]) {0x13B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB86 = {.cps = (lxb_codepoint_t[]) {0x13B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB87 = {.cps = (lxb_codepoint_t[]) {0x13B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB88 = {.cps = (lxb_codepoint_t[]) {0x13B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB89 = {.cps = (lxb_codepoint_t[]) {0x13B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8A = {.cps = (lxb_codepoint_t[]) {0x13BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8B = {.cps = (lxb_codepoint_t[]) {0x13BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8C = {.cps = (lxb_codepoint_t[]) {0x13BC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8D = {.cps = (lxb_codepoint_t[]) {0x13BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8E = {.cps = (lxb_codepoint_t[]) {0x13BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB8F = {.cps = (lxb_codepoint_t[]) {0x13BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB90 = {.cps = (lxb_codepoint_t[]) {0x13C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB91 = {.cps = (lxb_codepoint_t[]) {0x13C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB92 = {.cps = (lxb_codepoint_t[]) {0x13C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB93 = {.cps = (lxb_codepoint_t[]) {0x13C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB94 = {.cps = (lxb_codepoint_t[]) {0x13C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB95 = {.cps = (lxb_codepoint_t[]) {0x13C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB96 = {.cps = (lxb_codepoint_t[]) {0x13C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB97 = {.cps = (lxb_codepoint_t[]) {0x13C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB98 = {.cps = (lxb_codepoint_t[]) {0x13C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB99 = {.cps = (lxb_codepoint_t[]) {0x13C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9A = {.cps = (lxb_codepoint_t[]) {0x13CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9B = {.cps = (lxb_codepoint_t[]) {0x13CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9C = {.cps = (lxb_codepoint_t[]) {0x13CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9D = {.cps = (lxb_codepoint_t[]) {0x13CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9E = {.cps = (lxb_codepoint_t[]) {0x13CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_AB9F = {.cps = (lxb_codepoint_t[]) {0x13CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA0 = {.cps = (lxb_codepoint_t[]) {0x13D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA1 = {.cps = (lxb_codepoint_t[]) {0x13D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA2 = {.cps = (lxb_codepoint_t[]) {0x13D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA3 = {.cps = (lxb_codepoint_t[]) {0x13D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA4 = {.cps = (lxb_codepoint_t[]) {0x13D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA5 = {.cps = (lxb_codepoint_t[]) {0x13D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA6 = {.cps = (lxb_codepoint_t[]) {0x13D6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA7 = {.cps = (lxb_codepoint_t[]) {0x13D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA8 = {.cps = (lxb_codepoint_t[]) {0x13D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABA9 = {.cps = (lxb_codepoint_t[]) {0x13D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAA = {.cps = (lxb_codepoint_t[]) {0x13DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAB = {.cps = (lxb_codepoint_t[]) {0x13DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAC = {.cps = (lxb_codepoint_t[]) {0x13DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAD = {.cps = (lxb_codepoint_t[]) {0x13DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAE = {.cps = (lxb_codepoint_t[]) {0x13DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABAF = {.cps = (lxb_codepoint_t[]) {0x13DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB0 = {.cps = (lxb_codepoint_t[]) {0x13E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB1 = {.cps = (lxb_codepoint_t[]) {0x13E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB2 = {.cps = (lxb_codepoint_t[]) {0x13E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB3 = {.cps = (lxb_codepoint_t[]) {0x13E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB4 = {.cps = (lxb_codepoint_t[]) {0x13E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB5 = {.cps = (lxb_codepoint_t[]) {0x13E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB6 = {.cps = (lxb_codepoint_t[]) {0x13E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB7 = {.cps = (lxb_codepoint_t[]) {0x13E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB8 = {.cps = (lxb_codepoint_t[]) {0x13E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABB9 = {.cps = (lxb_codepoint_t[]) {0x13E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBA = {.cps = (lxb_codepoint_t[]) {0x13EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBB = {.cps = (lxb_codepoint_t[]) {0x13EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBC = {.cps = (lxb_codepoint_t[]) {0x13EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBD = {.cps = (lxb_codepoint_t[]) {0x13ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBE = {.cps = (lxb_codepoint_t[]) {0x13EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_ABBF = {.cps = (lxb_codepoint_t[]) {0x13EF}, .length = 1};

static const lxb_unicode_entry_t lxb_unicode_entry_A66F = {.cp = 0xA66F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A674 = {.cp = 0xA674, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A675 = {.cp = 0xA675, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A676 = {.cp = 0xA676, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A677 = {.cp = 0xA677, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A678 = {.cp = 0xA678, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A679 = {.cp = 0xA679, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A67A = {.cp = 0xA67A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A67B = {.cp = 0xA67B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A67C = {.cp = 0xA67C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A67D = {.cp = 0xA67D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A69C[1] = {0x044A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A69C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A69C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A69C[1] = {0x044A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A69C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A69C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A69C[1] = {0x044A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A69C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A69C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A69C = {.cp = 0xA69C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A69C, .cde = &lxb_unicode_decomposition_c_A69C, .kde = &lxb_unicode_decomposition_k_A69C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A69D[1] = {0x044C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A69D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A69D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A69D[1] = {0x044C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A69D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A69D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A69D[1] = {0x044C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A69D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A69D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A69D = {.cp = 0xA69D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A69D, .cde = &lxb_unicode_decomposition_c_A69D, .kde = &lxb_unicode_decomposition_k_A69D};

static const lxb_unicode_entry_t lxb_unicode_entry_A69E = {.cp = 0xA69E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A69F = {.cp = 0xA69F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A6F0 = {.cp = 0xA6F0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A6F1 = {.cp = 0xA6F1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A770[1] = {0xA76F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A770 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A770, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A770[1] = {0xA76F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A770 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A770, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A770[1] = {0xA76F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A770 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A770, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A770 = {.cp = 0xA770, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A770, .cde = &lxb_unicode_decomposition_c_A770, .kde = &lxb_unicode_decomposition_k_A770};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A7F2[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A7F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A7F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A7F2[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A7F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A7F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A7F2[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A7F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A7F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A7F2 = {.cp = 0xA7F2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A7F2, .cde = &lxb_unicode_decomposition_c_A7F2, .kde = &lxb_unicode_decomposition_k_A7F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A7F3[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A7F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A7F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A7F3[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A7F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A7F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A7F3[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A7F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A7F3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A7F3 = {.cp = 0xA7F3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A7F3, .cde = &lxb_unicode_decomposition_c_A7F3, .kde = &lxb_unicode_decomposition_k_A7F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A7F4[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A7F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A7F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A7F4[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A7F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A7F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A7F4[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A7F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A7F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A7F4 = {.cp = 0xA7F4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A7F4, .cde = &lxb_unicode_decomposition_c_A7F4, .kde = &lxb_unicode_decomposition_k_A7F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A7F8[1] = {0x0126};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A7F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A7F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A7F8[1] = {0x0126};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A7F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A7F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A7F8[1] = {0x0126};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A7F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A7F8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A7F8 = {.cp = 0xA7F8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A7F8, .cde = &lxb_unicode_decomposition_c_A7F8, .kde = &lxb_unicode_decomposition_k_A7F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_A7F9[1] = {0x0153};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_A7F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_A7F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_A7F9[1] = {0x0153};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_A7F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_A7F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__A7F9[1] = {0x0153};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__A7F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__A7F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_A7F9 = {.cp = 0xA7F9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__A7F9, .cde = &lxb_unicode_decomposition_c_A7F9, .kde = &lxb_unicode_decomposition_k_A7F9};

static const lxb_unicode_entry_t lxb_unicode_entry_A806 = {.cp = 0xA806, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A82C = {.cp = 0xA82C, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8C4 = {.cp = 0xA8C4, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E0 = {.cp = 0xA8E0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E1 = {.cp = 0xA8E1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E2 = {.cp = 0xA8E2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E3 = {.cp = 0xA8E3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E4 = {.cp = 0xA8E4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E5 = {.cp = 0xA8E5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E6 = {.cp = 0xA8E6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E7 = {.cp = 0xA8E7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E8 = {.cp = 0xA8E8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8E9 = {.cp = 0xA8E9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8EA = {.cp = 0xA8EA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8EB = {.cp = 0xA8EB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8EC = {.cp = 0xA8EC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8ED = {.cp = 0xA8ED, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8EE = {.cp = 0xA8EE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8EF = {.cp = 0xA8EF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8F0 = {.cp = 0xA8F0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A8F1 = {.cp = 0xA8F1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A92B = {.cp = 0xA92B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A92C = {.cp = 0xA92C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A92D = {.cp = 0xA92D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A953 = {.cp = 0xA953, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A9B3 = {.cp = 0xA9B3, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_A9C0 = {.cp = 0xA9C0, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB0 = {.cp = 0xAAB0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB2 = {.cp = 0xAAB2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB3 = {.cp = 0xAAB3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB4 = {.cp = 0xAAB4, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB7 = {.cp = 0xAAB7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAB8 = {.cp = 0xAAB8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AABE = {.cp = 0xAABE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AABF = {.cp = 0xAABF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAC1 = {.cp = 0xAAC1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AAF6 = {.cp = 0xAAF6, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_AB5C[1] = {0xA727};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_AB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_AB5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_AB5C[1] = {0xA727};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_AB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_AB5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__AB5C[1] = {0xA727};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__AB5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__AB5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_AB5C = {.cp = 0xAB5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__AB5C, .cde = &lxb_unicode_decomposition_c_AB5C, .kde = &lxb_unicode_decomposition_k_AB5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_AB5D[1] = {0xAB37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_AB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_AB5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_AB5D[1] = {0xAB37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_AB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_AB5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__AB5D[1] = {0xAB37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__AB5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__AB5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_AB5D = {.cp = 0xAB5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__AB5D, .cde = &lxb_unicode_decomposition_c_AB5D, .kde = &lxb_unicode_decomposition_k_AB5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_AB5E[1] = {0x026B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_AB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_AB5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_AB5E[1] = {0x026B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_AB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_AB5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__AB5E[1] = {0x026B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__AB5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__AB5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_AB5E = {.cp = 0xAB5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__AB5E, .cde = &lxb_unicode_decomposition_c_AB5E, .kde = &lxb_unicode_decomposition_k_AB5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_AB5F[1] = {0xAB52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_AB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_AB5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_AB5F[1] = {0xAB52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_AB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_AB5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__AB5F[1] = {0xAB52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__AB5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__AB5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_AB5F = {.cp = 0xAB5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__AB5F, .cde = &lxb_unicode_decomposition_c_AB5F, .kde = &lxb_unicode_decomposition_k_AB5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_AB69[1] = {0x028D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_AB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_AB69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_AB69[1] = {0x028D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_AB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_AB69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__AB69[1] = {0x028D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__AB69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__AB69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_AB69 = {.cp = 0xAB69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__AB69, .cde = &lxb_unicode_decomposition_c_AB69, .kde = &lxb_unicode_decomposition_k_AB69};

static const lxb_unicode_entry_t lxb_unicode_entry_ABED = {.cp = 0xABED, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_AC00 = {.cp = 0xAC00, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_unicode_data_t lxb_unicode_data_A640 = {NULL, &lxb_unicode_idna_map_A640};
static const lxb_unicode_data_t lxb_unicode_data_A642 = {NULL, &lxb_unicode_idna_map_A642};
static const lxb_unicode_data_t lxb_unicode_data_A644 = {NULL, &lxb_unicode_idna_map_A644};
static const lxb_unicode_data_t lxb_unicode_data_A646 = {NULL, &lxb_unicode_idna_map_A646};
static const lxb_unicode_data_t lxb_unicode_data_A648 = {NULL, &lxb_unicode_idna_map_A648};
static const lxb_unicode_data_t lxb_unicode_data_A64A = {NULL, &lxb_unicode_idna_map_A64A};
static const lxb_unicode_data_t lxb_unicode_data_A64C = {NULL, &lxb_unicode_idna_map_A64C};
static const lxb_unicode_data_t lxb_unicode_data_A64E = {NULL, &lxb_unicode_idna_map_A64E};
static const lxb_unicode_data_t lxb_unicode_data_A650 = {NULL, &lxb_unicode_idna_map_A650};
static const lxb_unicode_data_t lxb_unicode_data_A652 = {NULL, &lxb_unicode_idna_map_A652};
static const lxb_unicode_data_t lxb_unicode_data_A654 = {NULL, &lxb_unicode_idna_map_A654};
static const lxb_unicode_data_t lxb_unicode_data_A656 = {NULL, &lxb_unicode_idna_map_A656};
static const lxb_unicode_data_t lxb_unicode_data_A658 = {NULL, &lxb_unicode_idna_map_A658};
static const lxb_unicode_data_t lxb_unicode_data_A65A = {NULL, &lxb_unicode_idna_map_A65A};
static const lxb_unicode_data_t lxb_unicode_data_A65C = {NULL, &lxb_unicode_idna_map_A65C};
static const lxb_unicode_data_t lxb_unicode_data_A65E = {NULL, &lxb_unicode_idna_map_A65E};
static const lxb_unicode_data_t lxb_unicode_data_A660 = {NULL, &lxb_unicode_idna_map_A660};
static const lxb_unicode_data_t lxb_unicode_data_A662 = {NULL, &lxb_unicode_idna_map_A662};
static const lxb_unicode_data_t lxb_unicode_data_A664 = {NULL, &lxb_unicode_idna_map_A664};
static const lxb_unicode_data_t lxb_unicode_data_A666 = {NULL, &lxb_unicode_idna_map_A666};
static const lxb_unicode_data_t lxb_unicode_data_A668 = {NULL, &lxb_unicode_idna_map_A668};
static const lxb_unicode_data_t lxb_unicode_data_A66A = {NULL, &lxb_unicode_idna_map_A66A};
static const lxb_unicode_data_t lxb_unicode_data_A66C = {NULL, &lxb_unicode_idna_map_A66C};
static const lxb_unicode_data_t lxb_unicode_data_A66F = {&lxb_unicode_entry_A66F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A674 = {&lxb_unicode_entry_A674, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A675 = {&lxb_unicode_entry_A675, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A676 = {&lxb_unicode_entry_A676, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A677 = {&lxb_unicode_entry_A677, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A678 = {&lxb_unicode_entry_A678, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A679 = {&lxb_unicode_entry_A679, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A67A = {&lxb_unicode_entry_A67A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A67B = {&lxb_unicode_entry_A67B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A67C = {&lxb_unicode_entry_A67C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A67D = {&lxb_unicode_entry_A67D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A680 = {NULL, &lxb_unicode_idna_map_A680};
static const lxb_unicode_data_t lxb_unicode_data_A682 = {NULL, &lxb_unicode_idna_map_A682};
static const lxb_unicode_data_t lxb_unicode_data_A684 = {NULL, &lxb_unicode_idna_map_A684};
static const lxb_unicode_data_t lxb_unicode_data_A686 = {NULL, &lxb_unicode_idna_map_A686};
static const lxb_unicode_data_t lxb_unicode_data_A688 = {NULL, &lxb_unicode_idna_map_A688};
static const lxb_unicode_data_t lxb_unicode_data_A68A = {NULL, &lxb_unicode_idna_map_A68A};
static const lxb_unicode_data_t lxb_unicode_data_A68C = {NULL, &lxb_unicode_idna_map_A68C};
static const lxb_unicode_data_t lxb_unicode_data_A68E = {NULL, &lxb_unicode_idna_map_A68E};
static const lxb_unicode_data_t lxb_unicode_data_A690 = {NULL, &lxb_unicode_idna_map_A690};
static const lxb_unicode_data_t lxb_unicode_data_A692 = {NULL, &lxb_unicode_idna_map_A692};
static const lxb_unicode_data_t lxb_unicode_data_A694 = {NULL, &lxb_unicode_idna_map_A694};
static const lxb_unicode_data_t lxb_unicode_data_A696 = {NULL, &lxb_unicode_idna_map_A696};
static const lxb_unicode_data_t lxb_unicode_data_A698 = {NULL, &lxb_unicode_idna_map_A698};
static const lxb_unicode_data_t lxb_unicode_data_A69A = {NULL, &lxb_unicode_idna_map_A69A};
static const lxb_unicode_data_t lxb_unicode_data_A69C = {&lxb_unicode_entry_A69C, &lxb_unicode_idna_map_A69C};
static const lxb_unicode_data_t lxb_unicode_data_A69D = {&lxb_unicode_entry_A69D, &lxb_unicode_idna_map_A69D};
static const lxb_unicode_data_t lxb_unicode_data_A69E = {&lxb_unicode_entry_A69E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A69F = {&lxb_unicode_entry_A69F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A6F0 = {&lxb_unicode_entry_A6F0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A6F1 = {&lxb_unicode_entry_A6F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A722 = {NULL, &lxb_unicode_idna_map_A722};
static const lxb_unicode_data_t lxb_unicode_data_A724 = {NULL, &lxb_unicode_idna_map_A724};
static const lxb_unicode_data_t lxb_unicode_data_A726 = {NULL, &lxb_unicode_idna_map_A726};
static const lxb_unicode_data_t lxb_unicode_data_A728 = {NULL, &lxb_unicode_idna_map_A728};
static const lxb_unicode_data_t lxb_unicode_data_A72A = {NULL, &lxb_unicode_idna_map_A72A};
static const lxb_unicode_data_t lxb_unicode_data_A72C = {NULL, &lxb_unicode_idna_map_A72C};
static const lxb_unicode_data_t lxb_unicode_data_A72E = {NULL, &lxb_unicode_idna_map_A72E};
static const lxb_unicode_data_t lxb_unicode_data_A732 = {NULL, &lxb_unicode_idna_map_A732};
static const lxb_unicode_data_t lxb_unicode_data_A734 = {NULL, &lxb_unicode_idna_map_A734};
static const lxb_unicode_data_t lxb_unicode_data_A736 = {NULL, &lxb_unicode_idna_map_A736};
static const lxb_unicode_data_t lxb_unicode_data_A738 = {NULL, &lxb_unicode_idna_map_A738};
static const lxb_unicode_data_t lxb_unicode_data_A73A = {NULL, &lxb_unicode_idna_map_A73A};
static const lxb_unicode_data_t lxb_unicode_data_A73C = {NULL, &lxb_unicode_idna_map_A73C};
static const lxb_unicode_data_t lxb_unicode_data_A73E = {NULL, &lxb_unicode_idna_map_A73E};
static const lxb_unicode_data_t lxb_unicode_data_A740 = {NULL, &lxb_unicode_idna_map_A740};
static const lxb_unicode_data_t lxb_unicode_data_A742 = {NULL, &lxb_unicode_idna_map_A742};
static const lxb_unicode_data_t lxb_unicode_data_A744 = {NULL, &lxb_unicode_idna_map_A744};
static const lxb_unicode_data_t lxb_unicode_data_A746 = {NULL, &lxb_unicode_idna_map_A746};
static const lxb_unicode_data_t lxb_unicode_data_A748 = {NULL, &lxb_unicode_idna_map_A748};
static const lxb_unicode_data_t lxb_unicode_data_A74A = {NULL, &lxb_unicode_idna_map_A74A};
static const lxb_unicode_data_t lxb_unicode_data_A74C = {NULL, &lxb_unicode_idna_map_A74C};
static const lxb_unicode_data_t lxb_unicode_data_A74E = {NULL, &lxb_unicode_idna_map_A74E};
static const lxb_unicode_data_t lxb_unicode_data_A750 = {NULL, &lxb_unicode_idna_map_A750};
static const lxb_unicode_data_t lxb_unicode_data_A752 = {NULL, &lxb_unicode_idna_map_A752};
static const lxb_unicode_data_t lxb_unicode_data_A754 = {NULL, &lxb_unicode_idna_map_A754};
static const lxb_unicode_data_t lxb_unicode_data_A756 = {NULL, &lxb_unicode_idna_map_A756};
static const lxb_unicode_data_t lxb_unicode_data_A758 = {NULL, &lxb_unicode_idna_map_A758};
static const lxb_unicode_data_t lxb_unicode_data_A75A = {NULL, &lxb_unicode_idna_map_A75A};
static const lxb_unicode_data_t lxb_unicode_data_A75C = {NULL, &lxb_unicode_idna_map_A75C};
static const lxb_unicode_data_t lxb_unicode_data_A75E = {NULL, &lxb_unicode_idna_map_A75E};
static const lxb_unicode_data_t lxb_unicode_data_A760 = {NULL, &lxb_unicode_idna_map_A760};
static const lxb_unicode_data_t lxb_unicode_data_A762 = {NULL, &lxb_unicode_idna_map_A762};
static const lxb_unicode_data_t lxb_unicode_data_A764 = {NULL, &lxb_unicode_idna_map_A764};
static const lxb_unicode_data_t lxb_unicode_data_A766 = {NULL, &lxb_unicode_idna_map_A766};
static const lxb_unicode_data_t lxb_unicode_data_A768 = {NULL, &lxb_unicode_idna_map_A768};
static const lxb_unicode_data_t lxb_unicode_data_A76A = {NULL, &lxb_unicode_idna_map_A76A};
static const lxb_unicode_data_t lxb_unicode_data_A76C = {NULL, &lxb_unicode_idna_map_A76C};
static const lxb_unicode_data_t lxb_unicode_data_A76E = {NULL, &lxb_unicode_idna_map_A76E};
static const lxb_unicode_data_t lxb_unicode_data_A770 = {&lxb_unicode_entry_A770, &lxb_unicode_idna_map_A770};
static const lxb_unicode_data_t lxb_unicode_data_A779 = {NULL, &lxb_unicode_idna_map_A779};
static const lxb_unicode_data_t lxb_unicode_data_A77B = {NULL, &lxb_unicode_idna_map_A77B};
static const lxb_unicode_data_t lxb_unicode_data_A77D = {NULL, &lxb_unicode_idna_map_A77D};
static const lxb_unicode_data_t lxb_unicode_data_A77E = {NULL, &lxb_unicode_idna_map_A77E};
static const lxb_unicode_data_t lxb_unicode_data_A780 = {NULL, &lxb_unicode_idna_map_A780};
static const lxb_unicode_data_t lxb_unicode_data_A782 = {NULL, &lxb_unicode_idna_map_A782};
static const lxb_unicode_data_t lxb_unicode_data_A784 = {NULL, &lxb_unicode_idna_map_A784};
static const lxb_unicode_data_t lxb_unicode_data_A786 = {NULL, &lxb_unicode_idna_map_A786};
static const lxb_unicode_data_t lxb_unicode_data_A78B = {NULL, &lxb_unicode_idna_map_A78B};
static const lxb_unicode_data_t lxb_unicode_data_A78D = {NULL, &lxb_unicode_idna_map_A78D};
static const lxb_unicode_data_t lxb_unicode_data_A790 = {NULL, &lxb_unicode_idna_map_A790};
static const lxb_unicode_data_t lxb_unicode_data_A792 = {NULL, &lxb_unicode_idna_map_A792};
static const lxb_unicode_data_t lxb_unicode_data_A796 = {NULL, &lxb_unicode_idna_map_A796};
static const lxb_unicode_data_t lxb_unicode_data_A798 = {NULL, &lxb_unicode_idna_map_A798};
static const lxb_unicode_data_t lxb_unicode_data_A79A = {NULL, &lxb_unicode_idna_map_A79A};
static const lxb_unicode_data_t lxb_unicode_data_A79C = {NULL, &lxb_unicode_idna_map_A79C};
static const lxb_unicode_data_t lxb_unicode_data_A79E = {NULL, &lxb_unicode_idna_map_A79E};
static const lxb_unicode_data_t lxb_unicode_data_A7A0 = {NULL, &lxb_unicode_idna_map_A7A0};
static const lxb_unicode_data_t lxb_unicode_data_A7A2 = {NULL, &lxb_unicode_idna_map_A7A2};
static const lxb_unicode_data_t lxb_unicode_data_A7A4 = {NULL, &lxb_unicode_idna_map_A7A4};
static const lxb_unicode_data_t lxb_unicode_data_A7A6 = {NULL, &lxb_unicode_idna_map_A7A6};
static const lxb_unicode_data_t lxb_unicode_data_A7A8 = {NULL, &lxb_unicode_idna_map_A7A8};
static const lxb_unicode_data_t lxb_unicode_data_A7AA = {NULL, &lxb_unicode_idna_map_A7AA};
static const lxb_unicode_data_t lxb_unicode_data_A7AB = {NULL, &lxb_unicode_idna_map_A7AB};
static const lxb_unicode_data_t lxb_unicode_data_A7AC = {NULL, &lxb_unicode_idna_map_A7AC};
static const lxb_unicode_data_t lxb_unicode_data_A7AD = {NULL, &lxb_unicode_idna_map_A7AD};
static const lxb_unicode_data_t lxb_unicode_data_A7AE = {NULL, &lxb_unicode_idna_map_A7AE};
static const lxb_unicode_data_t lxb_unicode_data_A7B0 = {NULL, &lxb_unicode_idna_map_A7B0};
static const lxb_unicode_data_t lxb_unicode_data_A7B1 = {NULL, &lxb_unicode_idna_map_A7B1};
static const lxb_unicode_data_t lxb_unicode_data_A7B2 = {NULL, &lxb_unicode_idna_map_A7B2};
static const lxb_unicode_data_t lxb_unicode_data_A7B3 = {NULL, &lxb_unicode_idna_map_A7B3};
static const lxb_unicode_data_t lxb_unicode_data_A7B4 = {NULL, &lxb_unicode_idna_map_A7B4};
static const lxb_unicode_data_t lxb_unicode_data_A7B6 = {NULL, &lxb_unicode_idna_map_A7B6};
static const lxb_unicode_data_t lxb_unicode_data_A7B8 = {NULL, &lxb_unicode_idna_map_A7B8};
static const lxb_unicode_data_t lxb_unicode_data_A7BA = {NULL, &lxb_unicode_idna_map_A7BA};
static const lxb_unicode_data_t lxb_unicode_data_A7BC = {NULL, &lxb_unicode_idna_map_A7BC};
static const lxb_unicode_data_t lxb_unicode_data_A7BE = {NULL, &lxb_unicode_idna_map_A7BE};
static const lxb_unicode_data_t lxb_unicode_data_A7C0 = {NULL, &lxb_unicode_idna_map_A7C0};
static const lxb_unicode_data_t lxb_unicode_data_A7C2 = {NULL, &lxb_unicode_idna_map_A7C2};
static const lxb_unicode_data_t lxb_unicode_data_A7C4 = {NULL, &lxb_unicode_idna_map_A7C4};
static const lxb_unicode_data_t lxb_unicode_data_A7C5 = {NULL, &lxb_unicode_idna_map_A7C5};
static const lxb_unicode_data_t lxb_unicode_data_A7C6 = {NULL, &lxb_unicode_idna_map_A7C6};
static const lxb_unicode_data_t lxb_unicode_data_A7C7 = {NULL, &lxb_unicode_idna_map_A7C7};
static const lxb_unicode_data_t lxb_unicode_data_A7C9 = {NULL, &lxb_unicode_idna_map_A7C9};
static const lxb_unicode_data_t lxb_unicode_data_A7D0 = {NULL, &lxb_unicode_idna_map_A7D0};
static const lxb_unicode_data_t lxb_unicode_data_A7D6 = {NULL, &lxb_unicode_idna_map_A7D6};
static const lxb_unicode_data_t lxb_unicode_data_A7D8 = {NULL, &lxb_unicode_idna_map_A7D8};
static const lxb_unicode_data_t lxb_unicode_data_A7F2 = {&lxb_unicode_entry_A7F2, &lxb_unicode_idna_map_A7F2};
static const lxb_unicode_data_t lxb_unicode_data_A7F3 = {&lxb_unicode_entry_A7F3, &lxb_unicode_idna_map_A7F3};
static const lxb_unicode_data_t lxb_unicode_data_A7F4 = {&lxb_unicode_entry_A7F4, &lxb_unicode_idna_map_A7F4};
static const lxb_unicode_data_t lxb_unicode_data_A7F5 = {NULL, &lxb_unicode_idna_map_A7F5};
static const lxb_unicode_data_t lxb_unicode_data_A7F8 = {&lxb_unicode_entry_A7F8, &lxb_unicode_idna_map_A7F8};
static const lxb_unicode_data_t lxb_unicode_data_A7F9 = {&lxb_unicode_entry_A7F9, &lxb_unicode_idna_map_A7F9};
static const lxb_unicode_data_t lxb_unicode_data_A806 = {&lxb_unicode_entry_A806, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A82C = {&lxb_unicode_entry_A82C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8C4 = {&lxb_unicode_entry_A8C4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E0 = {&lxb_unicode_entry_A8E0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E1 = {&lxb_unicode_entry_A8E1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E2 = {&lxb_unicode_entry_A8E2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E3 = {&lxb_unicode_entry_A8E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E4 = {&lxb_unicode_entry_A8E4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E5 = {&lxb_unicode_entry_A8E5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E6 = {&lxb_unicode_entry_A8E6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E7 = {&lxb_unicode_entry_A8E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E8 = {&lxb_unicode_entry_A8E8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8E9 = {&lxb_unicode_entry_A8E9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8EA = {&lxb_unicode_entry_A8EA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8EB = {&lxb_unicode_entry_A8EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8EC = {&lxb_unicode_entry_A8EC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8ED = {&lxb_unicode_entry_A8ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8EE = {&lxb_unicode_entry_A8EE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8EF = {&lxb_unicode_entry_A8EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8F0 = {&lxb_unicode_entry_A8F0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A8F1 = {&lxb_unicode_entry_A8F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A92B = {&lxb_unicode_entry_A92B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A92C = {&lxb_unicode_entry_A92C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A92D = {&lxb_unicode_entry_A92D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A953 = {&lxb_unicode_entry_A953, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A9B3 = {&lxb_unicode_entry_A9B3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_A9C0 = {&lxb_unicode_entry_A9C0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB0 = {&lxb_unicode_entry_AAB0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB2 = {&lxb_unicode_entry_AAB2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB3 = {&lxb_unicode_entry_AAB3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB4 = {&lxb_unicode_entry_AAB4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB7 = {&lxb_unicode_entry_AAB7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAB8 = {&lxb_unicode_entry_AAB8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AABE = {&lxb_unicode_entry_AABE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AABF = {&lxb_unicode_entry_AABF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAC1 = {&lxb_unicode_entry_AAC1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AAF6 = {&lxb_unicode_entry_AAF6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AB5C = {&lxb_unicode_entry_AB5C, &lxb_unicode_idna_map_AB5C};
static const lxb_unicode_data_t lxb_unicode_data_AB5D = {&lxb_unicode_entry_AB5D, &lxb_unicode_idna_map_AB5D};
static const lxb_unicode_data_t lxb_unicode_data_AB5E = {&lxb_unicode_entry_AB5E, &lxb_unicode_idna_map_AB5E};
static const lxb_unicode_data_t lxb_unicode_data_AB5F = {&lxb_unicode_entry_AB5F, &lxb_unicode_idna_map_AB5F};
static const lxb_unicode_data_t lxb_unicode_data_AB69 = {&lxb_unicode_entry_AB69, &lxb_unicode_idna_map_AB69};
static const lxb_unicode_data_t lxb_unicode_data_AB70 = {NULL, &lxb_unicode_idna_map_AB70};
static const lxb_unicode_data_t lxb_unicode_data_AB71 = {NULL, &lxb_unicode_idna_map_AB71};
static const lxb_unicode_data_t lxb_unicode_data_AB72 = {NULL, &lxb_unicode_idna_map_AB72};
static const lxb_unicode_data_t lxb_unicode_data_AB73 = {NULL, &lxb_unicode_idna_map_AB73};
static const lxb_unicode_data_t lxb_unicode_data_AB74 = {NULL, &lxb_unicode_idna_map_AB74};
static const lxb_unicode_data_t lxb_unicode_data_AB75 = {NULL, &lxb_unicode_idna_map_AB75};
static const lxb_unicode_data_t lxb_unicode_data_AB76 = {NULL, &lxb_unicode_idna_map_AB76};
static const lxb_unicode_data_t lxb_unicode_data_AB77 = {NULL, &lxb_unicode_idna_map_AB77};
static const lxb_unicode_data_t lxb_unicode_data_AB78 = {NULL, &lxb_unicode_idna_map_AB78};
static const lxb_unicode_data_t lxb_unicode_data_AB79 = {NULL, &lxb_unicode_idna_map_AB79};
static const lxb_unicode_data_t lxb_unicode_data_AB7A = {NULL, &lxb_unicode_idna_map_AB7A};
static const lxb_unicode_data_t lxb_unicode_data_AB7B = {NULL, &lxb_unicode_idna_map_AB7B};
static const lxb_unicode_data_t lxb_unicode_data_AB7C = {NULL, &lxb_unicode_idna_map_AB7C};
static const lxb_unicode_data_t lxb_unicode_data_AB7D = {NULL, &lxb_unicode_idna_map_AB7D};
static const lxb_unicode_data_t lxb_unicode_data_AB7E = {NULL, &lxb_unicode_idna_map_AB7E};
static const lxb_unicode_data_t lxb_unicode_data_AB7F = {NULL, &lxb_unicode_idna_map_AB7F};
static const lxb_unicode_data_t lxb_unicode_data_AB80 = {NULL, &lxb_unicode_idna_map_AB80};
static const lxb_unicode_data_t lxb_unicode_data_AB81 = {NULL, &lxb_unicode_idna_map_AB81};
static const lxb_unicode_data_t lxb_unicode_data_AB82 = {NULL, &lxb_unicode_idna_map_AB82};
static const lxb_unicode_data_t lxb_unicode_data_AB83 = {NULL, &lxb_unicode_idna_map_AB83};
static const lxb_unicode_data_t lxb_unicode_data_AB84 = {NULL, &lxb_unicode_idna_map_AB84};
static const lxb_unicode_data_t lxb_unicode_data_AB85 = {NULL, &lxb_unicode_idna_map_AB85};
static const lxb_unicode_data_t lxb_unicode_data_AB86 = {NULL, &lxb_unicode_idna_map_AB86};
static const lxb_unicode_data_t lxb_unicode_data_AB87 = {NULL, &lxb_unicode_idna_map_AB87};
static const lxb_unicode_data_t lxb_unicode_data_AB88 = {NULL, &lxb_unicode_idna_map_AB88};
static const lxb_unicode_data_t lxb_unicode_data_AB89 = {NULL, &lxb_unicode_idna_map_AB89};
static const lxb_unicode_data_t lxb_unicode_data_AB8A = {NULL, &lxb_unicode_idna_map_AB8A};
static const lxb_unicode_data_t lxb_unicode_data_AB8B = {NULL, &lxb_unicode_idna_map_AB8B};
static const lxb_unicode_data_t lxb_unicode_data_AB8C = {NULL, &lxb_unicode_idna_map_AB8C};
static const lxb_unicode_data_t lxb_unicode_data_AB8D = {NULL, &lxb_unicode_idna_map_AB8D};
static const lxb_unicode_data_t lxb_unicode_data_AB8E = {NULL, &lxb_unicode_idna_map_AB8E};
static const lxb_unicode_data_t lxb_unicode_data_AB8F = {NULL, &lxb_unicode_idna_map_AB8F};
static const lxb_unicode_data_t lxb_unicode_data_AB90 = {NULL, &lxb_unicode_idna_map_AB90};
static const lxb_unicode_data_t lxb_unicode_data_AB91 = {NULL, &lxb_unicode_idna_map_AB91};
static const lxb_unicode_data_t lxb_unicode_data_AB92 = {NULL, &lxb_unicode_idna_map_AB92};
static const lxb_unicode_data_t lxb_unicode_data_AB93 = {NULL, &lxb_unicode_idna_map_AB93};
static const lxb_unicode_data_t lxb_unicode_data_AB94 = {NULL, &lxb_unicode_idna_map_AB94};
static const lxb_unicode_data_t lxb_unicode_data_AB95 = {NULL, &lxb_unicode_idna_map_AB95};
static const lxb_unicode_data_t lxb_unicode_data_AB96 = {NULL, &lxb_unicode_idna_map_AB96};
static const lxb_unicode_data_t lxb_unicode_data_AB97 = {NULL, &lxb_unicode_idna_map_AB97};
static const lxb_unicode_data_t lxb_unicode_data_AB98 = {NULL, &lxb_unicode_idna_map_AB98};
static const lxb_unicode_data_t lxb_unicode_data_AB99 = {NULL, &lxb_unicode_idna_map_AB99};
static const lxb_unicode_data_t lxb_unicode_data_AB9A = {NULL, &lxb_unicode_idna_map_AB9A};
static const lxb_unicode_data_t lxb_unicode_data_AB9B = {NULL, &lxb_unicode_idna_map_AB9B};
static const lxb_unicode_data_t lxb_unicode_data_AB9C = {NULL, &lxb_unicode_idna_map_AB9C};
static const lxb_unicode_data_t lxb_unicode_data_AB9D = {NULL, &lxb_unicode_idna_map_AB9D};
static const lxb_unicode_data_t lxb_unicode_data_AB9E = {NULL, &lxb_unicode_idna_map_AB9E};
static const lxb_unicode_data_t lxb_unicode_data_AB9F = {NULL, &lxb_unicode_idna_map_AB9F};
static const lxb_unicode_data_t lxb_unicode_data_ABA0 = {NULL, &lxb_unicode_idna_map_ABA0};
static const lxb_unicode_data_t lxb_unicode_data_ABA1 = {NULL, &lxb_unicode_idna_map_ABA1};
static const lxb_unicode_data_t lxb_unicode_data_ABA2 = {NULL, &lxb_unicode_idna_map_ABA2};
static const lxb_unicode_data_t lxb_unicode_data_ABA3 = {NULL, &lxb_unicode_idna_map_ABA3};
static const lxb_unicode_data_t lxb_unicode_data_ABA4 = {NULL, &lxb_unicode_idna_map_ABA4};
static const lxb_unicode_data_t lxb_unicode_data_ABA5 = {NULL, &lxb_unicode_idna_map_ABA5};
static const lxb_unicode_data_t lxb_unicode_data_ABA6 = {NULL, &lxb_unicode_idna_map_ABA6};
static const lxb_unicode_data_t lxb_unicode_data_ABA7 = {NULL, &lxb_unicode_idna_map_ABA7};
static const lxb_unicode_data_t lxb_unicode_data_ABA8 = {NULL, &lxb_unicode_idna_map_ABA8};
static const lxb_unicode_data_t lxb_unicode_data_ABA9 = {NULL, &lxb_unicode_idna_map_ABA9};
static const lxb_unicode_data_t lxb_unicode_data_ABAA = {NULL, &lxb_unicode_idna_map_ABAA};
static const lxb_unicode_data_t lxb_unicode_data_ABAB = {NULL, &lxb_unicode_idna_map_ABAB};
static const lxb_unicode_data_t lxb_unicode_data_ABAC = {NULL, &lxb_unicode_idna_map_ABAC};
static const lxb_unicode_data_t lxb_unicode_data_ABAD = {NULL, &lxb_unicode_idna_map_ABAD};
static const lxb_unicode_data_t lxb_unicode_data_ABAE = {NULL, &lxb_unicode_idna_map_ABAE};
static const lxb_unicode_data_t lxb_unicode_data_ABAF = {NULL, &lxb_unicode_idna_map_ABAF};
static const lxb_unicode_data_t lxb_unicode_data_ABB0 = {NULL, &lxb_unicode_idna_map_ABB0};
static const lxb_unicode_data_t lxb_unicode_data_ABB1 = {NULL, &lxb_unicode_idna_map_ABB1};
static const lxb_unicode_data_t lxb_unicode_data_ABB2 = {NULL, &lxb_unicode_idna_map_ABB2};
static const lxb_unicode_data_t lxb_unicode_data_ABB3 = {NULL, &lxb_unicode_idna_map_ABB3};
static const lxb_unicode_data_t lxb_unicode_data_ABB4 = {NULL, &lxb_unicode_idna_map_ABB4};
static const lxb_unicode_data_t lxb_unicode_data_ABB5 = {NULL, &lxb_unicode_idna_map_ABB5};
static const lxb_unicode_data_t lxb_unicode_data_ABB6 = {NULL, &lxb_unicode_idna_map_ABB6};
static const lxb_unicode_data_t lxb_unicode_data_ABB7 = {NULL, &lxb_unicode_idna_map_ABB7};
static const lxb_unicode_data_t lxb_unicode_data_ABB8 = {NULL, &lxb_unicode_idna_map_ABB8};
static const lxb_unicode_data_t lxb_unicode_data_ABB9 = {NULL, &lxb_unicode_idna_map_ABB9};
static const lxb_unicode_data_t lxb_unicode_data_ABBA = {NULL, &lxb_unicode_idna_map_ABBA};
static const lxb_unicode_data_t lxb_unicode_data_ABBB = {NULL, &lxb_unicode_idna_map_ABBB};
static const lxb_unicode_data_t lxb_unicode_data_ABBC = {NULL, &lxb_unicode_idna_map_ABBC};
static const lxb_unicode_data_t lxb_unicode_data_ABBD = {NULL, &lxb_unicode_idna_map_ABBD};
static const lxb_unicode_data_t lxb_unicode_data_ABBE = {NULL, &lxb_unicode_idna_map_ABBE};
static const lxb_unicode_data_t lxb_unicode_data_ABBF = {NULL, &lxb_unicode_idna_map_ABBF};
static const lxb_unicode_data_t lxb_unicode_data_ABED = {&lxb_unicode_entry_ABED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_AC00 = {&lxb_unicode_entry_AC00, NULL};
static const lxb_unicode_data_t *lxb_unicode_table_8[5000] = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A640,
    NULL,
    &lxb_unicode_data_A642,
    NULL,
    &lxb_unicode_data_A644,
    NULL,
    &lxb_unicode_data_A646,
    NULL,
    &lxb_unicode_data_A648,
    NULL,
    &lxb_unicode_data_A64A,
    NULL,
    &lxb_unicode_data_A64C,
    NULL,
    &lxb_unicode_data_A64E,
    NULL,
    &lxb_unicode_data_A650,
    NULL,
    &lxb_unicode_data_A652,
    NULL,
    &lxb_unicode_data_A654,
    NULL,
    &lxb_unicode_data_A656,
    NULL,
    &lxb_unicode_data_A658,
    NULL,
    &lxb_unicode_data_A65A,
    NULL,
    &lxb_unicode_data_A65C,
    NULL,
    &lxb_unicode_data_A65E,
    NULL,
    &lxb_unicode_data_A660,
    NULL,
    &lxb_unicode_data_A662,
    NULL,
    &lxb_unicode_data_A664,
    NULL,
    &lxb_unicode_data_A666,
    NULL,
    &lxb_unicode_data_A668,
    NULL,
    &lxb_unicode_data_A66A,
    NULL,
    &lxb_unicode_data_A66C,
    NULL,
    NULL,
    &lxb_unicode_data_A66F,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A674,
    &lxb_unicode_data_A675,
    &lxb_unicode_data_A676,
    &lxb_unicode_data_A677,
    &lxb_unicode_data_A678,
    &lxb_unicode_data_A679,
    &lxb_unicode_data_A67A,
    &lxb_unicode_data_A67B,
    &lxb_unicode_data_A67C,
    &lxb_unicode_data_A67D,
    NULL,
    NULL,
    &lxb_unicode_data_A680,
    NULL,
    &lxb_unicode_data_A682,
    NULL,
    &lxb_unicode_data_A684,
    NULL,
    &lxb_unicode_data_A686,
    NULL,
    &lxb_unicode_data_A688,
    NULL,
    &lxb_unicode_data_A68A,
    NULL,
    &lxb_unicode_data_A68C,
    NULL,
    &lxb_unicode_data_A68E,
    NULL,
    &lxb_unicode_data_A690,
    NULL,
    &lxb_unicode_data_A692,
    NULL,
    &lxb_unicode_data_A694,
    NULL,
    &lxb_unicode_data_A696,
    NULL,
    &lxb_unicode_data_A698,
    NULL,
    &lxb_unicode_data_A69A,
    NULL,
    &lxb_unicode_data_A69C,
    &lxb_unicode_data_A69D,
    &lxb_unicode_data_A69E,
    &lxb_unicode_data_A69F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A6F0,
    &lxb_unicode_data_A6F1,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A722,
    NULL,
    &lxb_unicode_data_A724,
    NULL,
    &lxb_unicode_data_A726,
    NULL,
    &lxb_unicode_data_A728,
    NULL,
    &lxb_unicode_data_A72A,
    NULL,
    &lxb_unicode_data_A72C,
    NULL,
    &lxb_unicode_data_A72E,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A732,
    NULL,
    &lxb_unicode_data_A734,
    NULL,
    &lxb_unicode_data_A736,
    NULL,
    &lxb_unicode_data_A738,
    NULL,
    &lxb_unicode_data_A73A,
    NULL,
    &lxb_unicode_data_A73C,
    NULL,
    &lxb_unicode_data_A73E,
    NULL,
    &lxb_unicode_data_A740,
    NULL,
    &lxb_unicode_data_A742,
    NULL,
    &lxb_unicode_data_A744,
    NULL,
    &lxb_unicode_data_A746,
    NULL,
    &lxb_unicode_data_A748,
    NULL,
    &lxb_unicode_data_A74A,
    NULL,
    &lxb_unicode_data_A74C,
    NULL,
    &lxb_unicode_data_A74E,
    NULL,
    &lxb_unicode_data_A750,
    NULL,
    &lxb_unicode_data_A752,
    NULL,
    &lxb_unicode_data_A754,
    NULL,
    &lxb_unicode_data_A756,
    NULL,
    &lxb_unicode_data_A758,
    NULL,
    &lxb_unicode_data_A75A,
    NULL,
    &lxb_unicode_data_A75C,
    NULL,
    &lxb_unicode_data_A75E,
    NULL,
    &lxb_unicode_data_A760,
    NULL,
    &lxb_unicode_data_A762,
    NULL,
    &lxb_unicode_data_A764,
    NULL,
    &lxb_unicode_data_A766,
    NULL,
    &lxb_unicode_data_A768,
    NULL,
    &lxb_unicode_data_A76A,
    NULL,
    &lxb_unicode_data_A76C,
    NULL,
    &lxb_unicode_data_A76E,
    NULL,
    &lxb_unicode_data_A770,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A779,
    NULL,
    &lxb_unicode_data_A77B,
    NULL,
    &lxb_unicode_data_A77D,
    &lxb_unicode_data_A77E,
    NULL,
    &lxb_unicode_data_A780,
    NULL,
    &lxb_unicode_data_A782,
    NULL,
    &lxb_unicode_data_A784,
    NULL,
    &lxb_unicode_data_A786,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A78B,
    NULL,
    &lxb_unicode_data_A78D,
    NULL,
    NULL,
    &lxb_unicode_data_A790,
    NULL,
    &lxb_unicode_data_A792,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A796,
    NULL,
    &lxb_unicode_data_A798,
    NULL,
    &lxb_unicode_data_A79A,
    NULL,
    &lxb_unicode_data_A79C,
    NULL,
    &lxb_unicode_data_A79E,
    NULL,
    &lxb_unicode_data_A7A0,
    NULL,
    &lxb_unicode_data_A7A2,
    NULL,
    &lxb_unicode_data_A7A4,
    NULL,
    &lxb_unicode_data_A7A6,
    NULL,
    &lxb_unicode_data_A7A8,
    NULL,
    &lxb_unicode_data_A7AA,
    &lxb_unicode_data_A7AB,
    &lxb_unicode_data_A7AC,
    &lxb_unicode_data_A7AD,
    &lxb_unicode_data_A7AE,
    NULL,
    &lxb_unicode_data_A7B0,
    &lxb_unicode_data_A7B1,
    &lxb_unicode_data_A7B2,
    &lxb_unicode_data_A7B3,
    &lxb_unicode_data_A7B4,
    NULL,
    &lxb_unicode_data_A7B6,
    NULL,
    &lxb_unicode_data_A7B8,
    NULL,
    &lxb_unicode_data_A7BA,
    NULL,
    &lxb_unicode_data_A7BC,
    NULL,
    &lxb_unicode_data_A7BE,
    NULL,
    &lxb_unicode_data_A7C0,
    NULL,
    &lxb_unicode_data_A7C2,
    NULL,
    &lxb_unicode_data_A7C4,
    &lxb_unicode_data_A7C5,
    &lxb_unicode_data_A7C6,
    &lxb_unicode_data_A7C7,
    NULL,
    &lxb_unicode_data_A7C9,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A7D0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A7D6,
    NULL,
    &lxb_unicode_data_A7D8,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A7F2,
    &lxb_unicode_data_A7F3,
    &lxb_unicode_data_A7F4,
    &lxb_unicode_data_A7F5,
    NULL,
    NULL,
    &lxb_unicode_data_A7F8,
    &lxb_unicode_data_A7F9,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A806,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A82C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A8C4,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A8E0,
    &lxb_unicode_data_A8E1,
    &lxb_unicode_data_A8E2,
    &lxb_unicode_data_A8E3,
    &lxb_unicode_data_A8E4,
    &lxb_unicode_data_A8E5,
    &lxb_unicode_data_A8E6,
    &lxb_unicode_data_A8E7,
    &lxb_unicode_data_A8E8,
    &lxb_unicode_data_A8E9,
    &lxb_unicode_data_A8EA,
    &lxb_unicode_data_A8EB,
    &lxb_unicode_data_A8EC,
    &lxb_unicode_data_A8ED,
    &lxb_unicode_data_A8EE,
    &lxb_unicode_data_A8EF,
    &lxb_unicode_data_A8F0,
    &lxb_unicode_data_A8F1,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A92B,
    &lxb_unicode_data_A92C,
    &lxb_unicode_data_A92D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A953,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A9B3,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_A9C0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AAB0,
    NULL,
    &lxb_unicode_data_AAB2,
    &lxb_unicode_data_AAB3,
    &lxb_unicode_data_AAB4,
    NULL,
    NULL,
    &lxb_unicode_data_AAB7,
    &lxb_unicode_data_AAB8,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AABE,
    &lxb_unicode_data_AABF,
    NULL,
    &lxb_unicode_data_AAC1,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AAF6,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AB5C,
    &lxb_unicode_data_AB5D,
    &lxb_unicode_data_AB5E,
    &lxb_unicode_data_AB5F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AB69,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AB70,
    &lxb_unicode_data_AB71,
    &lxb_unicode_data_AB72,
    &lxb_unicode_data_AB73,
    &lxb_unicode_data_AB74,
    &lxb_unicode_data_AB75,
    &lxb_unicode_data_AB76,
    &lxb_unicode_data_AB77,
    &lxb_unicode_data_AB78,
    &lxb_unicode_data_AB79,
    &lxb_unicode_data_AB7A,
    &lxb_unicode_data_AB7B,
    &lxb_unicode_data_AB7C,
    &lxb_unicode_data_AB7D,
    &lxb_unicode_data_AB7E,
    &lxb_unicode_data_AB7F,
    &lxb_unicode_data_AB80,
    &lxb_unicode_data_AB81,
    &lxb_unicode_data_AB82,
    &lxb_unicode_data_AB83,
    &lxb_unicode_data_AB84,
    &lxb_unicode_data_AB85,
    &lxb_unicode_data_AB86,
    &lxb_unicode_data_AB87,
    &lxb_unicode_data_AB88,
    &lxb_unicode_data_AB89,
    &lxb_unicode_data_AB8A,
    &lxb_unicode_data_AB8B,
    &lxb_unicode_data_AB8C,
    &lxb_unicode_data_AB8D,
    &lxb_unicode_data_AB8E,
    &lxb_unicode_data_AB8F,
    &lxb_unicode_data_AB90,
    &lxb_unicode_data_AB91,
    &lxb_unicode_data_AB92,
    &lxb_unicode_data_AB93,
    &lxb_unicode_data_AB94,
    &lxb_unicode_data_AB95,
    &lxb_unicode_data_AB96,
    &lxb_unicode_data_AB97,
    &lxb_unicode_data_AB98,
    &lxb_unicode_data_AB99,
    &lxb_unicode_data_AB9A,
    &lxb_unicode_data_AB9B,
    &lxb_unicode_data_AB9C,
    &lxb_unicode_data_AB9D,
    &lxb_unicode_data_AB9E,
    &lxb_unicode_data_AB9F,
    &lxb_unicode_data_ABA0,
    &lxb_unicode_data_ABA1,
    &lxb_unicode_data_ABA2,
    &lxb_unicode_data_ABA3,
    &lxb_unicode_data_ABA4,
    &lxb_unicode_data_ABA5,
    &lxb_unicode_data_ABA6,
    &lxb_unicode_data_ABA7,
    &lxb_unicode_data_ABA8,
    &lxb_unicode_data_ABA9,
    &lxb_unicode_data_ABAA,
    &lxb_unicode_data_ABAB,
    &lxb_unicode_data_ABAC,
    &lxb_unicode_data_ABAD,
    &lxb_unicode_data_ABAE,
    &lxb_unicode_data_ABAF,
    &lxb_unicode_data_ABB0,
    &lxb_unicode_data_ABB1,
    &lxb_unicode_data_ABB2,
    &lxb_unicode_data_ABB3,
    &lxb_unicode_data_ABB4,
    &lxb_unicode_data_ABB5,
    &lxb_unicode_data_ABB6,
    &lxb_unicode_data_ABB7,
    &lxb_unicode_data_ABB8,
    &lxb_unicode_data_ABB9,
    &lxb_unicode_data_ABBA,
    &lxb_unicode_data_ABBB,
    &lxb_unicode_data_ABBC,
    &lxb_unicode_data_ABBD,
    &lxb_unicode_data_ABBE,
    &lxb_unicode_data_ABBF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_ABED,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_AC00,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_8_H */
