/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WrapperEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(WrapperEditor.class);
    private final PropertyEditor typeEditor;
    private final PropertyEditor guiEditor;
    private final boolean acceptsNull;
    private final boolean acceptsExpressions;
    private final boolean acceptsOther;
    private final Object defaultValue;
    private String lastValidValue = null;

    WrapperEditor(Object source, PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        if (source != null) {
            super.setSource(source);
        }
        this.typeEditor = typeEditor;
        this.guiEditor = guiEditor;
        this.acceptsNull = acceptsNull;
        this.acceptsExpressions = acceptsExpressions;
        this.acceptsOther = acceptsOther;
        this.defaultValue = defaultValue;
        this.initialize();
    }

    WrapperEditor(PropertyEditor typeEditor, PropertyEditor guiEditor, boolean acceptsNull, boolean acceptsExpressions, boolean acceptsOther, Object defaultValue) {
        this(null, typeEditor, guiEditor, acceptsNull, acceptsExpressions, acceptsOther, defaultValue);
    }

    final void resetValue() {
        this.setValue(this.defaultValue);
        this.lastValidValue = this.getAsText();
    }

    private void initialize() {
        this.resetValue();
        if (this.guiEditor instanceof ComboStringEditor) {
            String[] tags = this.guiEditor.getTags();
            String v = !this.acceptsOther ? "${}" : (this.isValidValue("") ? "" : (this.acceptsExpressions ? "${}" : (tags != null && tags.length > 0 ? tags[0] : this.getAsText())));
            ((ComboStringEditor)this.guiEditor).setInitialEditValue(v);
        }
        this.guiEditor.addPropertyChangeListener(this);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.guiEditor.getCustomEditor();
    }

    @Override
    public String[] getTags() {
        return this.guiEditor.getTags();
    }

    private boolean isATag(String text) {
        String[] tags = this.getTags();
        if (tags == null) {
            return false;
        }
        for (String tag : tags) {
            if (!tag.equals(text)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidValue(String text) {
        if (text == null) {
            return this.acceptsNull;
        }
        if (this.acceptsExpressions && WrapperEditor.isExpression(text)) {
            return true;
        }
        if (this.isATag(text)) {
            return true;
        }
        if (!this.acceptsOther) {
            return false;
        }
        try {
            this.typeEditor.setAsText(text);
        }
        catch (IllegalArgumentException e1) {
            return false;
        }
        return true;
    }

    private static void shouldNeverHappen(String msg) {
        throw new Error(msg);
    }

    private static void shouldNeverHappen(Exception e) {
        throw new Error(e.toString());
    }

    private static boolean isExpression(String text) {
        return text.contains("${");
    }

    private static boolean isExpression(Object text) {
        return text instanceof String && WrapperEditor.isExpression((String)text);
    }

    @Override
    public Object getValue() {
        Object value;
        String text = (String)this.guiEditor.getValue();
        if (text == null) {
            if (!this.acceptsNull) {
                WrapperEditor.shouldNeverHappen("Text is null but null is not allowed");
            }
            value = null;
        } else if (this.acceptsExpressions && WrapperEditor.isExpression(text)) {
            value = text;
        } else {
            block14: {
                if (!this.acceptsOther && !this.isATag(text)) {
                    WrapperEditor.shouldNeverHappen("Text is not a tag but other entries are not allowed");
                }
                try {
                    try {
                        this.typeEditor.setAsText(text);
                    }
                    catch (NumberFormatException e) {
                        if (text.length() == 0) {
                            text = "0";
                            this.typeEditor.setAsText(text);
                            break block14;
                        }
                        WrapperEditor.shouldNeverHappen(e);
                    }
                }
                catch (IllegalArgumentException e) {
                    WrapperEditor.shouldNeverHappen(e);
                }
            }
            value = this.typeEditor.getValue();
        }
        if (log.isDebugEnabled()) {
            if (value == null) {
                log.debug("->NULL:null");
            } else {
                log.debug("->{}:{}", (Object)value.getClass().getName(), value);
            }
        }
        return value;
    }

    @Override
    public final void setValue(Object value) {
        String text;
        if (log.isDebugEnabled()) {
            if (value == null) {
                log.debug("<-NULL:null");
            } else {
                log.debug("<-{}:{}", (Object)value.getClass().getName(), value);
            }
        }
        if (value == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException("Null is not allowed");
            }
            text = null;
        } else if (this.acceptsExpressions && WrapperEditor.isExpression(value)) {
            text = (String)value;
        } else {
            this.typeEditor.setValue(value);
            text = WrapperEditor.fixGetAsTextBug(this.typeEditor.getAsText());
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException("Value not allowed: '" + text + "' is not in " + Arrays.toString(this.getTags()));
            }
        }
        this.guiEditor.setValue(text);
    }

    private static String fixGetAsTextBug(String asText) {
        if (asText == null) {
            return null;
        }
        if (asText.equals("true")) {
            log.debug("true=>True");
            return "True";
        }
        if (asText.equals("false")) {
            log.debug("false=>False");
            return "False";
        }
        return asText;
    }

    @Override
    public String getAsText() {
        String text = WrapperEditor.fixGetAsTextBug(this.guiEditor.getAsText());
        if (text == null) {
            if (!this.acceptsNull) {
                WrapperEditor.shouldNeverHappen("Text is null, but null is not allowed");
            }
        } else if (!this.acceptsExpressions || !WrapperEditor.isExpression(text)) {
            try {
                this.typeEditor.setAsText(text);
            }
            catch (IllegalArgumentException e) {
                WrapperEditor.shouldNeverHappen(e);
            }
            text = WrapperEditor.fixGetAsTextBug(this.typeEditor.getAsText());
            if (!this.acceptsOther && !this.isATag(text)) {
                WrapperEditor.shouldNeverHappen("Text is not a tag, but other values are not allowed");
            }
        }
        log.debug("->\"{}\"", (Object)text);
        return text;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String value;
        if (log.isDebugEnabled()) {
            if (text == null) {
                log.debug("<-null");
            } else {
                log.debug("<-\"{}\"", (Object)text);
            }
        }
        if (text == null) {
            if (!this.acceptsNull) {
                throw new IllegalArgumentException("Null parameter not allowed");
            }
            value = null;
        } else if (this.acceptsExpressions && WrapperEditor.isExpression(text)) {
            value = text;
        } else {
            this.typeEditor.setAsText(text);
            value = this.typeEditor.getAsText();
            if (!this.acceptsOther && !this.isATag(text)) {
                throw new IllegalArgumentException("Value not allowed: " + text);
            }
        }
        this.guiEditor.setValue(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String text = WrapperEditor.fixGetAsTextBug(this.guiEditor.getAsText());
        if (this.isValidValue(text)) {
            this.lastValidValue = text;
            this.firePropertyChange();
        } else {
            if (GuiPackage.getInstance() == null) {
                log.warn("Invalid value: {} {}", (Object)text, (Object)this.typeEditor);
            } else {
                JOptionPane.showMessageDialog(this.guiEditor.getCustomEditor().getParent(), JMeterUtils.getResString("property_editor.value_is_invalid_message"), JMeterUtils.getResString("property_editor.value_is_invalid_title"), 2);
            }
            this.guiEditor.setAsText(this.lastValidValue);
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.guiEditor.addPropertyChangeListener(listener);
    }
}

