/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.NumericBreakFormatter;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.LinearBreaksGen;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Log10Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.SymlogTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "formatter", "Lkotlin/Function1;", "", "", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;Lkotlin/jvm/functions/Function1;)V", "defaultFormatter", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "labelFormatter", "Companion", "MultiFormatter", "plot-base"})
@SourceDebugExtension(value={"SMAP\nNonlinearBreaksGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1#2:138\n1559#3:139\n1590#3,4:140\n*S KotlinDebug\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen\n*L\n29#1:139\n29#1:140,4\n*E\n"})
public final class NonlinearBreaksGen
implements BreaksGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContinuousTransform transform;
    @Nullable
    private final Function1<Object, String> formatter;
    private static final int MIN_BREAKS_COUNT = 3;

    public NonlinearBreaksGen(@NotNull ContinuousTransform transform, @Nullable Function1<Object, String> formatter2) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.transform = transform;
        this.formatter = formatter2;
    }

    public /* synthetic */ NonlinearBreaksGen(ContinuousTransform continuousTransform, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(continuousTransform, (Function1<Object, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
        void $this$mapIndexedTo$iv$iv;
        List list2;
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        List breakValues = NonlinearBreaksGen.Companion.generateBreakValues(domain, NonlinearBreaksGen.Companion.recalculateBreaksCount(targetCount, domain, this.transform), this.transform);
        if (this.formatter != null) {
            int n = breakValues.size();
            ArrayList<Function1<Object, String>> arrayList = new ArrayList<Function1<Object, String>>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add((String)this.formatter);
            }
            list2 = arrayList;
        } else {
            list2 = NonlinearBreaksGen.Companion.createFormatters(breakValues);
        }
        List breakFormatters = list2;
        Iterable $this$mapIndexed$iv = breakValues;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void v;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv$iv).doubleValue();
            int n5 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)((Function1)breakFormatters.get((int)i)).invoke((Object)((double)v)));
        }
        List labels = (List)destination$iv$iv;
        return new ScaleBreaks(breakValues, breakValues, labels);
    }

    @Override
    @NotNull
    public Function1<Object, String> labelFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Function1<Object, String> function1 = this.formatter;
        if (function1 == null) {
            function1 = this.defaultFormatter(domain, targetCount);
        }
        return function1;
    }

    @Override
    @NotNull
    public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return NonlinearBreaksGen.Companion.createMultiFormatter(NonlinearBreaksGen.Companion.generateBreakValues(domain, targetCount, this.transform));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J(\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$Companion;", "", "()V", "MIN_BREAKS_COUNT", "", "createFormatter", "Lkotlin/Function1;", "", "domainValue", "", "step", "createFormatters", "", "breakValues", "createMultiFormatter", "generateBreakValues", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "recalculateBreaksCount", "breaksCount", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nNonlinearBreaksGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1559#2:138\n1590#2,4:139\n*S KotlinDebug\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$Companion\n*L\n88#1:138\n88#1:139,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Double> generateBreakValues(DoubleSpan domain, int targetCount, ContinuousTransform transform) {
            DoubleSpan transformedDomain = ScaleUtil.INSTANCE.applyTransform(domain, transform);
            List<Double> transformedBreakValues = LinearBreaksGen.Companion.generateBreakValues$plot_base(transformedDomain, targetCount);
            return CollectionsKt.filterNotNull((Iterable)transform.applyInverse(transformedBreakValues));
        }

        private final int recalculateBreaksCount(int breaksCount, DoubleSpan domain, ContinuousTransform transform) {
            DoubleSpan transformedDomain;
            int recalculatedBreaksCount;
            ContinuousTransform continuousTransform = transform;
            return (continuousTransform instanceof Log10Transform ? true : continuousTransform instanceof SymlogTransform) ? ((3 <= (recalculatedBreaksCount = MathKt.roundToInt((double)(Math.floor((transformedDomain = ScaleUtil.INSTANCE.applyTransform(domain, transform)).getUpperEnd()) - Math.ceil(transformedDomain.getLowerEnd()))) + 1) ? recalculatedBreaksCount <= breaksCount : false) ? recalculatedBreaksCount : breaksCount) : breaksCount;
        }

        private final Function1<Object, String> createMultiFormatter(List<Double> breakValues) {
            List<Function1<Object, String>> breakFormatters = this.createFormatters(breakValues);
            return (Function1)new Function1<Object, String>((Object)new MultiFormatter(breakValues, breakFormatters)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((MultiFormatter)this.receiver).apply(p0);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<Function1<Object, String>> createFormatters(List<Double> breakValues) {
            void $this$mapIndexedTo$iv$iv;
            if (breakValues.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            if (breakValues.size() == 1) {
                double domainValue = ((Number)breakValues.get(0)).doubleValue();
                double step = domainValue / (double)10;
                return CollectionsKt.listOf(this.createFormatter(domainValue, step));
            }
            Iterable $this$mapIndexed$iv = breakValues;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void currValue;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                double d = ((Number)item$iv$iv).doubleValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double step = Math.abs((double)(i == false ? currValue - ((Number)breakValues.get((int)(i + true))).doubleValue() : currValue - ((Number)breakValues.get((int)(i - true))).doubleValue()));
                collection.add(Companion.createFormatter((double)currValue, step));
            }
            List formatters = (List)destination$iv$iv;
            return formatters;
        }

        private final Function1<Object, String> createFormatter(double domainValue, double step) {
            return (Function1)new Function1<Object, String>((Object)new NumericBreakFormatter(domainValue, step, true)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((NumericBreakFormatter)this.receiver).apply(p0);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0001R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$MultiFormatter;", "", "breakValues", "", "", "breakFormatters", "Lkotlin/Function1;", "", "(Ljava/util/List;Ljava/util/List;)V", "getBreakFormatters", "()Ljava/util/List;", "getBreakValues", "apply", "v", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nNonlinearBreaksGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$MultiFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1559#2:138\n1590#2,4:139\n1726#2,3:143\n1#3:146\n*S KotlinDebug\n*F\n+ 1 NonlinearBreaksGen.kt\norg/jetbrains/letsPlot/core/plot/base/scale/transform/NonlinearBreaksGen$MultiFormatter\n*L\n119#1:138\n119#1:139,4\n120#1:143,3\n*E\n"})
    private static final class MultiFormatter {
        @NotNull
        private final List<Double> breakValues;
        @NotNull
        private final List<Function1<Object, String>> breakFormatters;

        /*
         * WARNING - void declaration
         */
        public MultiFormatter(@NotNull List<Double> breakValues, @NotNull List<? extends Function1<Object, String>> breakFormatters) {
            Intrinsics.checkNotNullParameter(breakValues, (String)"breakValues");
            Intrinsics.checkNotNullParameter(breakFormatters, (String)"breakFormatters");
            this.breakValues = breakValues;
            this.breakFormatters = breakFormatters;
            if (!(this.breakValues.size() == this.breakFormatters.size())) {
                boolean $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = false;
                String $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = "MultiFormatter: breakValues.size=" + this.breakValues.size() + " but breakFormatters.size=" + this.breakFormatters.size();
                throw new IllegalStateException($i$a$-check-NonlinearBreaksGen$MultiFormatter$32.toString());
            }
            if (this.breakValues.size() > 1) {
                boolean ordered;
                block8: {
                    boolean bl;
                    void $this$all$iv;
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapIndexed$iv;
                    Iterable $i$a$-check-NonlinearBreaksGen$MultiFormatter$32 = this.breakValues;
                    boolean $i$f$mapIndexed = false;
                    Iterator iterator = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void v;
                        void i;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        double d = ((Number)item$iv$iv).doubleValue();
                        int n2 = n;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(i == false ? 0.0 : v - ((Number)this.breakValues.get((int)(i - true))).doubleValue());
                    }
                    $this$mapIndexed$iv = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            double it = ((Number)element$iv).doubleValue();
                            boolean bl3 = false;
                            if (it >= 0.0) continue;
                            bl = false;
                            break block8;
                        }
                        bl = ordered = true;
                    }
                }
                if (!ordered) {
                    boolean bl = false;
                    String string = "MultiFormatter: values must be sorted in ascending order. Were: " + this.breakValues + '.';
                    throw new IllegalStateException(string.toString());
                }
            }
        }

        @NotNull
        public final List<Double> getBreakValues() {
            return this.breakValues;
        }

        @NotNull
        public final List<Function1<Object, String>> getBreakFormatters() {
            return this.breakFormatters;
        }

        @NotNull
        public final String apply(@NotNull Object v) {
            String string;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Double cfr_ignored_0 = (Double)v;
            if (this.breakValues.isEmpty()) {
                string = v.toString();
            } else {
                int i = Math.abs(CollectionsKt.binarySearch$default(this.breakValues, (Comparable)((Comparable)v), (int)0, (int)0, (int)6, null));
                int ii = Math.min(i, this.breakValues.size() - 1);
                string = (String)this.breakFormatters.get(ii).invoke(v);
            }
            return string;
        }
    }
}

