/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class DefaultLocalVariantGraphResolveState
implements LocalVariantGraphResolveState {
    private final long instanceId;
    private final LocalVariantGraphResolveMetadata metadata;
    private final CalculatedValue<VariantDependencyMetadata> dependencies;
    private final DefaultLocalVariantArtifactResolveState artifactState;
    private final ComponentIdGenerator idGenerator;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public DefaultLocalVariantGraphResolveState(long instanceId, ComponentIdentifier componentId, LocalVariantGraphResolveMetadata metadata, ComponentIdGenerator idGenerator, CalculatedValueContainerFactory calculatedValueContainerFactory, CalculatedValue<VariantDependencyMetadata> dependencies, Set<LocalVariantMetadata> artifactSets) {
        this.instanceId = instanceId;
        this.metadata = metadata;
        this.dependencies = dependencies;
        this.artifactState = new DefaultLocalVariantArtifactResolveState(componentId, artifactSets);
        this.idGenerator = idGenerator;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public LocalVariantGraphResolveState copyWithComponentId(ComponentIdentifier overrideComponentId) {
        Set<LocalVariantMetadata> artifactSets = this.artifactState.getArtifactVariants();
        ImmutableSet.Builder copiedArtifactSets = ImmutableSet.builderWithExpectedSize((int)artifactSets.size());
        for (LocalVariantMetadata oldArtifactSet : artifactSets) {
            CalculatedValueContainer newArtifacts = this.calculatedValueContainerFactory.create(Describables.of((Object)oldArtifactSet.asDescribable(), (Object)"artifacts"), c -> (ImmutableList)oldArtifactSet.getArtifacts().stream().map(originalArtifact -> new CompositeProjectComponentArtifactMetadata(overrideComponentId, (LocalComponentArtifactMetadata)originalArtifact)).collect(ImmutableList.toImmutableList()));
            copiedArtifactSets.add((Object)new LocalVariantMetadata(oldArtifactSet.getName(), (VariantResolveMetadata.Identifier)OverrideComponentIdArtifactSetIdentifier.of(overrideComponentId, oldArtifactSet.getIdentifier()), oldArtifactSet.asDescribable(), oldArtifactSet.getAttributes(), oldArtifactSet.getCapabilities(), (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)newArtifacts));
        }
        return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), this.artifactState.componentId, this.metadata, this.idGenerator, this.calculatedValueContainerFactory, this.dependencies, (Set<LocalVariantMetadata>)copiedArtifactSets.build());
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    public String toString() {
        return this.metadata.toString();
    }

    @Override
    public LocalVariantGraphResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.metadata.getAttributes();
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.metadata.getCapabilities();
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).files;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).dependencies;
    }

    @Override
    public List<? extends ExcludeMetadata> getExcludes() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).excludes;
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution() {
        return this.artifactState;
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState {
        private final ComponentIdentifier componentId;
        private final Set<LocalVariantMetadata> artifactSets;

        public DefaultLocalVariantArtifactResolveState(ComponentIdentifier componentId, Set<LocalVariantMetadata> artifactSets) {
            this.componentId = componentId;
            this.artifactSets = artifactSets;
        }

        @Override
        public ImmutableList<ComponentArtifactMetadata> getAdhocArtifacts(List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.getArtifactWithName(dependencyArtifact));
            }
            return artifacts.build();
        }

        private ComponentArtifactMetadata getArtifactWithName(IvyArtifactName ivyArtifactName) {
            for (VariantResolveMetadata variantResolveMetadata : this.getArtifactVariants()) {
                for (ComponentArtifactMetadata candidate : variantResolveMetadata.getArtifacts()) {
                    if (!candidate.getName().equals(ivyArtifactName)) continue;
                    return candidate;
                }
            }
            return new MissingLocalArtifactMetadata(this.componentId, ivyArtifactName);
        }

        public Set<LocalVariantMetadata> getArtifactVariants() {
            return this.artifactSets;
        }
    }

    private static class OverrideComponentIdArtifactSetIdentifier
    implements VariantResolveMetadata.Identifier {
        private final ComponentIdentifier overrideComponentId;
        private final VariantResolveMetadata.Identifier delegate;

        public OverrideComponentIdArtifactSetIdentifier(ComponentIdentifier overrideComponentId, VariantResolveMetadata.Identifier delegate) {
            this.overrideComponentId = overrideComponentId;
            this.delegate = delegate;
        }

        @Nullable
        public static OverrideComponentIdArtifactSetIdentifier of(ComponentIdentifier overrideComponentId, @Nullable VariantResolveMetadata.Identifier delegate) {
            if (delegate == null) {
                return null;
            }
            return new OverrideComponentIdArtifactSetIdentifier(overrideComponentId, delegate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverrideComponentIdArtifactSetIdentifier that = (OverrideComponentIdArtifactSetIdentifier)o;
            return this.overrideComponentId.equals(that.overrideComponentId) && this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            int result = this.overrideComponentId.hashCode();
            result = 31 * result + this.delegate.hashCode();
            return result;
        }
    }

    public static class VariantDependencyMetadata {
        public final List<LocalOriginDependencyMetadata> dependencies;
        public final Set<LocalFileDependencyMetadata> files;
        public final ImmutableList<ExcludeMetadata> excludes;

        public VariantDependencyMetadata(List<LocalOriginDependencyMetadata> dependencies, Set<LocalFileDependencyMetadata> files, List<ExcludeMetadata> excludes) {
            this.dependencies = dependencies;
            this.files = files;
            this.excludes = ImmutableList.copyOf(excludes);
        }
    }
}

