/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000fR\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineBodySimpleFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)V", "isInsideInlineContext", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isObject", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlineBodySimpleFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineBodySimpleFunctionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineBodySimpleFunctionChecker\n+ 2 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,42:1\n46#2:43\n*S KotlinDebug\n*F\n+ 1 FirInlineBodySimpleFunctionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineBodySimpleFunctionChecker\n*L\n40#1:43\n*E\n"})
public final class FirInlineBodySimpleFunctionChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirInlineBodySimpleFunctionChecker INSTANCE = new FirInlineBodySimpleFunctionChecker();

    private FirInlineBodySimpleFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.isInsideInlineContext(context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local functions", null, 16, null);
        }
    }

    public final boolean isInsideInlineContext(@NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (FirBasedSymbol it : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            Object object = context2.getInlineFunctionBodyContext();
            if (Intrinsics.areEqual((Object)it, object != null && (object = ((FirInlineDeclarationChecker.InlineFunctionBodyContext)object).getInlineFunction()) != null ? ((FirFunction)object).getSymbol() : null)) {
                return true;
            }
            if (!this.isObject(it)) continue;
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isObject(FirBasedSymbol<?> $this$isObject) {
        if ($this$isObject instanceof FirAnonymousObjectSymbol) return true;
        if (!($this$isObject instanceof FirRegularClassSymbol)) return false;
        ClassKind $this$isObject$iv = ((FirRegularClassSymbol)$this$isObject).getClassKind();
        boolean $i$f$isObject = false;
        if ($this$isObject$iv != ClassKind.OBJECT) return false;
        return true;
    }
}

