/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.ide.xcode.internal.xcodeproj.PBXContainer;
import org.gradle.ide.xcode.internal.xcodeproj.PBXGroup;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.internal.xcodeproj.XCConfigurationList;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;

public class PBXProject
extends PBXContainer {
    private final PBXGroup mainGroup;
    private final List<PBXTarget> targets;
    private final XCConfigurationList buildConfigurationList;
    private final String compatibilityVersion;
    private final String name;

    public PBXProject(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.mainGroup = new PBXGroup("mainGroup", null, PBXReference.SourceTree.GROUP);
        this.targets = new ArrayList<PBXTarget>();
        this.buildConfigurationList = new XCConfigurationList();
        this.compatibilityVersion = "Xcode 3.2";
    }

    public String getName() {
        return this.name;
    }

    public PBXGroup getMainGroup() {
        return this.mainGroup;
    }

    public List<PBXTarget> getTargets() {
        return this.targets;
    }

    public XCConfigurationList getBuildConfigurationList() {
        return this.buildConfigurationList;
    }

    public String getCompatibilityVersion() {
        return this.compatibilityVersion;
    }

    @Override
    public String isa() {
        return "PBXProject";
    }

    @Override
    public int stableHash() {
        return this.name.hashCode();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("mainGroup", this.mainGroup);
        Collections.sort(this.targets, Ordering.natural().onResultOf((Function)new Function<PBXTarget, String>(){

            public String apply(PBXTarget input) {
                return input.getName();
            }
        }));
        s.addField("targets", this.targets);
        s.addField("buildConfigurationList", this.buildConfigurationList);
        s.addField("compatibilityVersion", this.compatibilityVersion);
        NSDictionary d = new NSDictionary();
        d.put("LastUpgradeCheck", (Object)"0610");
        s.addField("attributes", (NSObject)d);
    }
}

