/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.row;

import datagraph.data.graph.panel.model.row.DataRowObject;
import ghidra.program.model.listing.Data;

public class ComponentDataRowObject
extends DataRowObject {
    static final int ARRAY_GROUP_SIZE = 100;
    protected Data data;

    public ComponentDataRowObject(int indentLevel, Data data, boolean isOpen) {
        super(indentLevel, isOpen);
        this.data = data;
    }

    @Override
    public boolean isExpandable() {
        return this.data.getNumComponents() > 0;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.data.getFieldName();
    }

    @Override
    public String getValue() {
        return this.data.getDefaultValueRepresentation();
    }

    @Override
    public String getDataType() {
        return this.data.getDataType().getDisplayName();
    }

    @Override
    public boolean hasOutgoingReferences() {
        if (this.data.isPointer()) {
            return true;
        }
        return this.data.getProgram().getReferenceManager().hasReferencesFrom(this.data.getAddress());
    }
}

