/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.vertex;

import com.google.common.base.Function;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VertexShapeProvider;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class VisualGraphVertexShapeTransformer<V extends VisualVertex>
implements Function<V, Shape> {
    public Shape transformToCompactShape(V v) {
        Shape s = this.getCompactShape(v);
        return this.centerShape(s);
    }

    public Shape transformToFullShape(V v) {
        Shape s = this.getFullShape(v);
        return this.centerShape(s);
    }

    public Shape apply(V vertex) {
        Shape s = this.getFullShape(vertex);
        return this.centerShape(s);
    }

    private Shape centerShape(Shape s) {
        Rectangle bounds = s.getBounds();
        Dimension size = bounds.getSize();
        int halfWidth = -(size.width / 2);
        int halfHeight = -(size.height / 2);
        int x = halfWidth - bounds.x;
        int y = halfHeight - bounds.y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        Shape movedShape = xform.createTransformedShape(s);
        return movedShape;
    }

    private Shape getFullShape(V v) {
        if (v instanceof VertexShapeProvider) {
            return ((VertexShapeProvider)v).getFullShape();
        }
        return this.getDefaultShape(v);
    }

    private Shape getCompactShape(V v) {
        if (v instanceof VertexShapeProvider) {
            return ((VertexShapeProvider)v).getCompactShape();
        }
        return this.getDefaultShape(v);
    }

    private Shape getDefaultShape(V v) {
        JComponent component = v.getComponent();
        return new Rectangle(new Point(0, 0), component.getPreferredSize());
    }
}

