/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.symbols;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.symbols.ExtSymbol;
import sarif.managers.SymbolTableSarifMgr;

public class SarifSymbolWriter
extends AbstractExtWriter {
    private List<Symbol> symbols = new ArrayList<Symbol>();

    public SarifSymbolWriter(List<Symbol> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.symbols = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genSymbols(monitor);
        this.root.add("definedData", (JsonElement)this.objects);
    }

    private void genSymbols(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.symbols.size());
        for (Symbol s : this.symbols) {
            SymbolType symbolType = s.getSymbolType();
            if (s.getSource() == SourceType.DEFAULT || symbolType != SymbolType.LABEL && symbolType != SymbolType.FUNCTION) continue;
            this.addSymbol(s);
            monitor.increment();
        }
    }

    private void addSymbol(Symbol s) {
        if (!s.getParentNamespace().isGlobal()) {
            Symbol p = s.getParentSymbol();
            this.addSymbol(p);
        }
        ExtSymbol lib = new ExtSymbol(s);
        SarifObject sarif = new SarifObject("Symbol", SymbolTableSarifMgr.KEY, this.getTree(lib), s.getAddress(), s.getAddress());
        this.objects.add(this.getTree(sarif));
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

