/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.IntWriteGen;
import ghidra.pcode.emu.jit.gen.type.LongWriteGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitStoreOp;
import ghidra.program.model.lang.Endian;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum StoreOpGen implements OpGen<JitStoreOp>
{
    GEN;


    @Override
    public void generateInitCode(JitCodeGenerator gen, JitStoreOp op, MethodVisitor iv) {
        gen.requestFieldForSpaceIndirect(op.space());
    }

    private void generateConvMpIntRunCodeLegBE(int off, int size, MethodVisitor rv) {
        rv.visitInsn(90);
        rv.visitLdcInsn((Object)off);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, IntWriteGen.BE.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
    }

    private void generateConvMpIntRunCodeLegLE(int off, int size, MethodVisitor rv) {
        rv.visitInsn(90);
        rv.visitLdcInsn((Object)off);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, IntWriteGen.LE.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
    }

    private void generateConvIntRunCode(Endian endian, JitType.IntJitType type, MethodVisitor rv) {
        switch (endian) {
            case BIG: {
                this.generateConvMpIntRunCodeLegBE(0, type.size(), rv);
                break;
            }
            case LITTLE: {
                this.generateConvMpIntRunCodeLegLE(0, type.size(), rv);
            }
        }
    }

    private String chooseWriteLongName(Endian endian, int size) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> LongWriteGen.BE.chooseName(size);
            case Endian.LITTLE -> LongWriteGen.LE.chooseName(size);
        };
    }

    private void generateConvLongRunCode(Endian endian, JitType.LongJitType type, MethodVisitor rv) {
        rv.visitInsn(91);
        rv.visitLdcInsn((Object)0);
        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseWriteLongName(endian, type.size()), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_LONGX, true);
    }

    private void generateConvFloatRunCode(Endian endian, JitType.FloatJitType type, MethodVisitor rv) {
        rv.visitInsn(95);
        TypeConversions.generateFloatToInt(type, JitType.IntJitType.I4, rv);
        rv.visitInsn(95);
        this.generateConvIntRunCode(endian, JitType.IntJitType.I4, rv);
    }

    private void generateConvDoubleRunCode(Endian endian, JitType.DoubleJitType type, MethodVisitor rv) {
        rv.visitInsn(91);
        rv.visitInsn(87);
        TypeConversions.generateDoubleToLong(type, JitType.LongJitType.I8, rv);
        rv.visitInsn(93);
        rv.visitInsn(88);
        this.generateConvLongRunCode(endian, JitType.LongJitType.I8, rv);
    }

    private void generateConvMpIntRunCodeBE(JitType.MpIntJitType type, MethodVisitor rv) {
        int countFull = type.legsWhole();
        int remSize = type.partialSize();
        int off = type.size();
        for (int i = 0; i < countFull; ++i) {
            this.generateConvMpIntRunCodeLegBE(off -= 4, 4, rv);
        }
        if (remSize > 0) {
            this.generateConvMpIntRunCodeLegBE(off -= remSize, remSize, rv);
        }
    }

    private void generateConvMpIntRunCodeLE(JitType.MpIntJitType type, MethodVisitor rv) {
        int countFull = type.legsWhole();
        int remSize = type.partialSize();
        int off = 0;
        for (int i = 0; i < countFull; ++i) {
            this.generateConvMpIntRunCodeLegLE(off, 4, rv);
            off += 4;
        }
        if (remSize > 0) {
            this.generateConvMpIntRunCodeLegLE(off, remSize, rv);
            off += remSize;
        }
    }

    private void generateConvMpIntRunCode(Endian endian, JitType.MpIntJitType type, MethodVisitor rv) {
        switch (endian) {
            case BIG: {
                this.generateConvMpIntRunCodeBE(type, rv);
                break;
            }
            case LITTLE: {
                this.generateConvMpIntRunCodeLE(type, rv);
            }
        }
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitStoreOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        gen.requestFieldForSpaceIndirect(op.space()).generateLoadCode(gen, rv);
        JitType offsetType = gen.generateValReadCode(op.offset(), op.offsetType(), TypeConversions.Ext.ZERO);
        TypeConversions.generateToLong(offsetType, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, rv);
        JitType valueType = gen.generateValReadCode(op.value(), op.valueType(), TypeConversions.Ext.ZERO);
        rv.visitLdcInsn((Object)op.value().size());
        rv.visitIntInsn(188, 8);
        Endian endian = gen.getAnalysisContext().getEndian();
        JitType jitType = valueType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iType = (JitType.IntJitType)jitType2;
                this.generateConvIntRunCode(endian, iType, rv);
                break;
            }
            case 1: {
                JitType.LongJitType lType = (JitType.LongJitType)jitType2;
                this.generateConvLongRunCode(endian, lType, rv);
                break;
            }
            case 2: {
                JitType.FloatJitType fType = (JitType.FloatJitType)jitType2;
                this.generateConvFloatRunCode(endian, fType, rv);
                break;
            }
            case 3: {
                JitType.DoubleJitType dType = (JitType.DoubleJitType)jitType2;
                this.generateConvDoubleRunCode(endian, dType, rv);
                break;
            }
            case 4: {
                JitType.MpIntJitType mpType = (JitType.MpIntJitType)jitType2;
                this.generateConvMpIntRunCode(endian, mpType, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        rv.visitLdcInsn((Object)0);
        rv.visitLdcInsn((Object)op.value().size());
        rv.visitMethodInsn(182, GenConsts.NAME_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE, "write", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE_SPACE__WRITE, false);
    }
}

