/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeView<V, E> {
    private static final Logger log = LoggerFactory.getLogger(TreeView.class);
    protected Predicate<V> rootPredicate;
    protected Comparator<V> rootComparator;
    protected Predicate<V> vertexPredicate;
    protected Predicate<E> edgePredicate;
    protected Comparator<V> vertexComparator;
    protected Comparator<E> edgeComparator;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    TreeView(Builder<V, E, ?, ?> builder) {
        this(builder.rootPredicate, builder.rootComparator, builder.vertexPredicate, builder.edgePredicate, builder.vertexComparator, builder.edgeComparator);
    }

    TreeView(Predicate<V> rootPredicate, Comparator<V> rootComparator, Predicate<V> vertexPredicate, Predicate<E> edgePredicate, Comparator<V> vertexComparator, Comparator<E> edgeComparator) {
        this.rootPredicate = rootPredicate;
        this.rootComparator = rootComparator;
        this.vertexPredicate = vertexPredicate;
        this.edgePredicate = edgePredicate;
        this.vertexComparator = vertexComparator;
        this.edgeComparator = edgeComparator;
    }

    public Graph<V, E> buildTree(Graph<V, E> graph) {
        Graph tree = GraphTypeBuilder.directed().buildGraph();
        HashSet seen = new HashSet();
        List<Object> roots = graph.vertexSet().stream().filter(this.rootPredicate).sorted(this.rootComparator).collect(Collectors.toList());
        roots.forEach(arg_0 -> ((Graph)tree).addVertex(arg_0));
        for (Object t : roots) {
            this.buildTree(graph, tree, seen, t);
        }
        return tree;
    }

    private void buildTree(Graph<V, E> graph, Graph<V, E> tree, Set<V> seen, V vertex) {
        if (seen.add(vertex)) {
            for (Object edge : graph.outgoingEdgesOf(vertex).stream().sorted(this.edgeComparator).collect(Collectors.toCollection(LinkedHashSet::new))) {
                Object v;
                if (!this.edgePredicate.test(edge) && !graph.incomingEdgesOf(graph.getEdgeTarget(edge)).stream().noneMatch(this.edgePredicate) || this.rootPredicate.test(v = graph.getEdgeTarget(edge)) || seen.contains(v)) continue;
                tree.addVertex(vertex);
                tree.addVertex(v);
                tree.addEdge(vertex, v, edge);
                this.buildTree(graph, tree, seen, v);
            }
        }
    }

    public static class Builder<V, E, T extends TreeView<V, E>, B extends Builder<V, E, T, B>> {
        protected Predicate<V> rootPredicate = v -> true;
        protected Comparator<V> rootComparator = (v1, v2) -> 0;
        protected Predicate<V> vertexPredicate = Layered.truePredicate;
        protected Predicate<E> edgePredicate = Layered.truePredicate;
        protected Comparator<V> vertexComparator = Layered.noopComparator;
        protected Comparator<E> edgeComparator = Layered.noopComparator;

        protected B self() {
            return (B)this;
        }

        public B rootPredicate(Predicate<V> rootPredicate) {
            this.rootPredicate = rootPredicate;
            return this.self();
        }

        public B rootComparator(Comparator<V> rootComparator) {
            this.rootComparator = rootComparator;
            return this.self();
        }

        public B vertexPredicate(Predicate<V> vertexPredicate) {
            this.vertexPredicate = vertexPredicate;
            return this.self();
        }

        public B edgePredicate(Predicate<E> edgePredicate) {
            this.edgePredicate = edgePredicate;
            return this.self();
        }

        public B vertexComparator(Comparator<V> vertexComparator) {
            this.vertexComparator = vertexComparator;
            return this.self();
        }

        public B edgeComparator(Comparator<E> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return this.self();
        }

        public T build() {
            return (T)new TreeView(this);
        }
    }
}

