/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.util.ComponentGrouping;
import org.jungrapht.visualization.layout.algorithms.util.NetworkSimplex;
import org.jungrapht.visualization.layout.algorithms.util.NetworkSimplexDevelopment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphLayers {
    private static final Logger log = LoggerFactory.getLogger(GraphLayers.class);

    private GraphLayers() {
    }

    public static <V, E> List<List<LV<V>>> assign(Graph<LV<V>, LE<V, E>> dag) {
        return GraphLayers.assign(dag, Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> assign(Graph<LV<V>, LE<V, E>> dag, Comparator<LE<V, E>> comparator) {
        int rank = 0;
        ArrayList<List<LV<V>>> sorted = new ArrayList<List<LV<V>>>();
        LinkedList<LE<V, LE>> edges = new LinkedList<LE<V, LE>>(dag.edgeSet());
        Set<LV<V>> vertices = GraphLayers.getVertices(dag, comparator);
        List<LV<V>> start = GraphLayers.getVerticesWithoutIncomingEdges(dag, edges, vertices);
        start = ComponentGrouping.groupByComponents(dag, start);
        while (start.size() > 0) {
            for (int i = 0; i < start.size(); ++i) {
                LV<V> v = start.get(i);
                v.setRank(rank);
                v.setIndex(i);
            }
            sorted.add(start);
            HashSet fstart = new HashSet(start);
            edges.removeIf(e -> fstart.contains(dag.getEdgeSource(e)));
            vertices.removeIf(fstart::contains);
            start = GraphLayers.getVerticesWithoutIncomingEdges(dag, edges, vertices);
            ++rank;
        }
        return sorted;
    }

    public static <V, E> void minimizeEdgeLength(Graph<LV<V>, LE<V, E>> dag, List<List<LV<V>>> layers) {
        for (int i = layers.size() - 1; i >= 0; --i) {
            List<LV<V>> layer = layers.get(i);
            HashMap<LV<V>, Integer> verticesToMove = new HashMap<LV<V>, Integer>();
            for (LV<V> lV : layer) {
                int minRank;
                if (dag.outDegreeOf(lV) == 0 || (minRank = dag.outgoingEdgesOf(lV).stream().mapToInt(e -> ((LV)dag.getEdgeTarget(e)).getRank() - 1).min().getAsInt()) == lV.getRank()) continue;
                verticesToMove.put(lV, minRank);
                if (!log.isTraceEnabled()) continue;
                log.trace("moving {} to rank {}", lV, (Object)minRank);
            }
            for (Map.Entry entry : verticesToMove.entrySet()) {
                LV v = (LV)entry.getKey();
                int oldRank = ((LV)entry.getKey()).getRank();
                int newRank = (Integer)entry.getValue();
                layers.get(oldRank).remove(v);
                layers.get(newRank).add(v);
                v.setRank(newRank);
            }
        }
    }

    private static <V> List<LV<V>> groupByComponentMembership(List<Set<LV<V>>> componentVertices, List<LV<V>> list) {
        ArrayList<LV<V>> groupedRow = new ArrayList<LV<V>>();
        for (Set<LV<V>> set : componentVertices) {
            groupedRow.addAll(list.stream().filter(set::contains).collect(Collectors.toList()));
        }
        return groupedRow;
    }

    private static <V, E> Set<V> getVertices(Graph<V, E> graph, Comparator<E> edgeComparator) {
        if (edgeComparator == Layered.noopComparator) {
            return new LinkedHashSet(graph.vertexSet());
        }
        LinkedHashSet sortedVertices = new LinkedHashSet();
        graph.edgeSet().stream().sorted(edgeComparator).forEach(e -> {
            sortedVertices.add(graph.getEdgeSource(e));
            sortedVertices.add(graph.getEdgeTarget(e));
        });
        graph.vertexSet().stream().filter(v -> graph.degreeOf(v) == 0).forEach(sortedVertices::add);
        return sortedVertices;
    }

    public static <V, E> List<List<LV<V>>> longestPath(Graph<LV<V>, LE<V, E>> dag) {
        return GraphLayers.longestPath(dag, new NeighborCache(dag), Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> longestPath(Graph<LV<V>, LE<V, E>> dag, Comparator<LE<V, E>> comparator) {
        return GraphLayers.longestPath(dag, new NeighborCache(dag), comparator);
    }

    public static <V, E> List<List<LV<V>>> longestPath(Graph<LV<V>, LE<V, E>> dag, NeighborCache<LV<V>, LE<V, E>> neighborCache, Comparator<LE<V, E>> comparator) {
        ArrayList<List<LV<V>>> list = new ArrayList<List<LV<V>>>();
        HashSet<LV> U = new HashSet<LV>();
        HashSet<LV> Z = new HashSet<LV>();
        Set<LV<V>> V = GraphLayers.getVertices(dag, comparator);
        int currentLayer = 0;
        list.add(new ArrayList());
        while (U.size() != dag.vertexSet().size()) {
            Optional<LV> optional = V.stream().filter(v -> !U.contains(v)).filter(v -> Z.containsAll(neighborCache.successorsOf(v))).findFirst();
            if (optional.isPresent()) {
                LV got = optional.get();
                ((List)list.get(currentLayer)).add(got);
                U.add(got);
                continue;
            }
            ++currentLayer;
            list.add(new ArrayList());
            Z.addAll(U);
        }
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            List layer = (List)list.get(i);
            for (int j = 0; j < layer.size(); ++j) {
                LV v2 = (LV)layer.get(j);
                v2.setRank(i);
                v2.setIndex(j);
            }
        }
        return list;
    }

    public static <V, E> List<List<LV<V>>> longestPathReverse(Graph<LV<V>, LE<V, E>> dag) {
        return GraphLayers.longestPathReverse(dag, new NeighborCache(dag), Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> longestPathReverse(Graph<LV<V>, LE<V, E>> dag, Comparator<LE<V, E>> comparator) {
        return GraphLayers.longestPathReverse(dag, new NeighborCache(dag), comparator);
    }

    public static <V, E> List<List<LV<V>>> longestPathReverse(Graph<LV<V>, LE<V, E>> dag, NeighborCache<LV<V>, LE<V, E>> neighborCache, Comparator<LE<V, E>> comparator) {
        ArrayList<List<LV<V>>> list = new ArrayList<List<LV<V>>>();
        HashSet<LV> U = new HashSet<LV>();
        HashSet<LV> Z = new HashSet<LV>();
        Set<LV<V>> V = GraphLayers.getVertices(dag, comparator);
        int currentLayer = 0;
        list.add(new ArrayList());
        while (U.size() != dag.vertexSet().size()) {
            Optional<LV> optional = V.stream().filter(v -> !U.contains(v)).filter(v -> Z.containsAll(neighborCache.successorsOf(v))).findFirst();
            if (optional.isPresent()) {
                LV got = optional.get();
                ((List)list.get(currentLayer)).add(got);
                U.add(got);
                continue;
            }
            ++currentLayer;
            list.add(new ArrayList());
            Z.addAll(U);
        }
        for (int i = 0; i < list.size(); ++i) {
            List layer = (List)list.get(i);
            for (int j = 0; j < layer.size(); ++j) {
                LV v2 = (LV)layer.get(j);
                v2.setRank(i);
                v2.setIndex(j);
            }
        }
        return list;
    }

    public static <V, E> List<List<LV<V>>> networkSimplex(Graph<LV<V>, LE<V, E>> dag) {
        return GraphLayers.networkSimplex(dag, Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> networkSimplex(Graph<LV<V>, LE<V, E>> dag, Comparator<LE<V, E>> comparator) {
        ArrayList<List<LV<V>>> layerList = new ArrayList<List<LV<V>>>();
        List<Graph<LV<V>, LE<V, Graph>>> componentList = ComponentGrouping.getComponentGraphs(dag);
        componentList.sort(Comparator.comparingInt(l -> -componentList.size()));
        for (Graph<LV<V>, LE<V, E>> graph : componentList) {
            Object ns = ((NetworkSimplex.Builder)NetworkSimplex.builder(graph).edgeComparator(comparator)).build();
            ((NetworkSimplex)ns).run();
            List layers = ((NetworkSimplex)ns).getLayerList();
            for (int i = 0; i < layers.size(); ++i) {
                List layer = layers.get(i);
                if (layerList.size() <= i) {
                    layerList.add(new ArrayList());
                }
                ((List)layerList.get(i)).addAll(layer);
            }
        }
        Collections.reverse(layerList);
        for (int i = 0; i < layerList.size(); ++i) {
            List list = (List)layerList.get(i);
            for (int j = 0; j < list.size(); ++j) {
                LV v = (LV)list.get(j);
                v.setRank(i);
                v.setIndex(j);
            }
        }
        return layerList;
    }

    public static <V, E> List<List<LV<V>>> coffmanGraham(Graph<LV<V>, LE<V, E>> dag, int width) {
        return GraphLayers.coffmanGraham(dag, new NeighborCache(dag), width, Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> coffmanGraham(Graph<LV<V>, LE<V, E>> dag, int width, Comparator<LE<V, E>> comparator) {
        return GraphLayers.coffmanGraham(dag, new NeighborCache(dag), width, comparator);
    }

    public static <V, E> List<List<LV<V>>> coffmanGraham(Graph<LV<V>, LE<V, E>> dag, NeighborCache<LV<V>, LE<V, E>> neighborCache, int width) {
        return GraphLayers.coffmanGraham(dag, neighborCache, width, Layered.noopComparator);
    }

    public static <V, E> List<List<LV<V>>> coffmanGraham(Graph<LV<V>, LE<V, E>> dag, NeighborCache<LV<V>, LE<V, E>> neighborCache, int width, Comparator<LE<V, E>> comparator) {
        if (width == 0) {
            width = dag.vertexSet().size() / 10;
        }
        List<Object> list = new ArrayList();
        HashSet Z = new HashSet();
        HashMap<LV, Integer> lambda = new HashMap<LV, Integer>();
        Set<LV<V>> V = GraphLayers.getVertices(dag, comparator);
        V.stream().forEach(v -> lambda.put((LV)v, Integer.MAX_VALUE));
        for (int i = 0; i < V.size(); ++i) {
            LV mv = V.stream().filter(v -> (Integer)lambda.get(v) == Integer.MAX_VALUE).min(Comparator.comparingInt(arg_0 -> dag.inDegreeOf(arg_0))).get();
            lambda.put(mv, i);
        }
        int k = 0;
        list.add(new ArrayList());
        HashSet<LV> U = new HashSet<LV>();
        while (U.size() != dag.vertexSet().size()) {
            LV got = V.stream().filter(v -> !U.contains(v)).filter(v -> U.containsAll(neighborCache.successorsOf(v))).max(Comparator.comparingInt(lambda::get)).get();
            if (((List)list.get(k)).size() < width && Z.containsAll(neighborCache.successorsOf((Object)got))) {
                ((List)list.get(k)).add(got);
            } else {
                Z.addAll((Collection)list.get(k));
                list.add(new ArrayList());
                ((List)list.get(++k)).add(got);
            }
            U.add(got);
        }
        list = list.stream().filter(l -> !l.isEmpty()).collect(Collectors.toList());
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            List layer = (List)list.get(i);
            for (int j = 0; j < layer.size(); ++j) {
                LV v2 = (LV)layer.get(j);
                v2.setRank(i);
                v2.setIndex(j);
            }
        }
        return list;
    }

    private static <V, E> int tightTree(Graph<V, E> dag) {
        NetworkSimplexDevelopment<V, E> networkSimplexDevelopment = new NetworkSimplexDevelopment<V, E>(dag);
        return networkSimplexDevelopment.getTheBestSpanningTree().vertexSet().size();
    }

    private static <V, E> List<LV<V>> getVerticesWithoutIncomingEdges(Graph<LV<V>, LE<V, E>> dag, Collection<LE<V, E>> edges, Collection<LV<V>> vertices) {
        Set targets = edges.stream().map(e -> (LV)dag.getEdgeTarget(e)).collect(Collectors.toSet());
        return vertices.stream().filter(v -> !targets.contains(v)).collect(Collectors.toList());
    }

    public static <V> void checkLayers(List<List<LV<V>>> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            List<LV<V>> layer = layers.get(i);
            for (int j = 0; j < layer.size(); ++j) {
                LV<V> LV2 = layer.get(j);
                if (i != LV2.getRank()) {
                    log.error("{} is not the rank of {}", (Object)i, LV2);
                    throw new RuntimeException("rank is wrong");
                }
                if (j == LV2.getIndex()) continue;
                log.error("{} is not the index of {}", (Object)j, LV2);
                throw new RuntimeException("index is wrong");
            }
        }
    }

    public static <V> void checkLayers(LV<V>[][] layers) {
        if (log.isTraceEnabled()) {
            for (int i = 0; i < layers.length; ++i) {
                for (int j = 0; j < layers[i].length; ++j) {
                    if (i != layers[i][j].getRank()) {
                        log.error("{} is not the rank of {}", (Object)i, layers[i][j]);
                        throw new RuntimeException(i + " is not the rank of " + layers[i][j]);
                    }
                    if (j == layers[i][j].getIndex()) continue;
                    log.error("{} is not the index of {}", (Object)j, layers[i][j]);
                    throw new RuntimeException(j + " is not the index of " + layers[i][j]);
                }
            }
        }
    }

    public static <V, E> boolean isLoopVertex(Graph<V, E> graph, V v) {
        return graph.outgoingEdgesOf(v).equals(graph.incomingEdgesOf(v));
    }

    public static <V, E> boolean isZeroDegreeVertex(Graph<V, E> graph, V v) {
        return graph.degreeOf(v) == 0;
    }

    public static <V, E> boolean isIsolatedVertex(Graph<V, E> graph, V v) {
        return GraphLayers.isLoopVertex(graph, v) || GraphLayers.isZeroDegreeVertex(graph, v);
    }

    public static <V, E> int vertexIsolationScore(Graph<V, E> graph, V v) {
        if (GraphLayers.isZeroDegreeVertex(graph, v)) {
            return 2;
        }
        if (GraphLayers.isLoopVertex(graph, v)) {
            return 1;
        }
        return 0;
    }
}

