/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.jar.ResourceFile;
import ghidra.docking.settings.Settings;
import ghidra.framework.Application;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.project.extensions.ExtensionInstaller;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.extensions.ExtensionDetails;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ExtensionTableModel
extends ThreadedTableModel<ExtensionDetails, Object> {
    static final int INSTALLED_COL = 0;
    static final int NAME_COL = 1;
    private Set<ExtensionDetails> extensions;
    private Map<String, Boolean> originalInstallStates = new HashMap<String, Boolean>();

    protected ExtensionTableModel(ServiceProvider serviceProvider) {
        super("Extensions", serviceProvider);
    }

    protected TableColumnDescriptor<ExtensionDetails> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionInstalledColumn(this), 0, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionNameColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionDescriptionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionVersionColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ExtensionInstallationDirColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new ExtensionArchiveFileColumn(this));
        return descriptor;
    }

    public int getPrimarySortColumnIndex() {
        return 1;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (Application.inSingleJarMode()) {
            return false;
        }
        ExtensionDetails extension = this.getSelectedExtension(rowIndex);
        if (extension.isInstalledInInstallationFolder()) {
            return false;
        }
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        ResourceFile installDir = (ResourceFile)Application.getApplicationLayout().getExtensionInstallationDirs().get(0);
        if (!installDir.exists() && !installDir.mkdir()) {
            Msg.showError((Object)((Object)this), null, (String)"Directory Error", (Object)"Cannot install/uninstall extensions: Failed to create extension installation directory.\nSee the \"Ghidra Extension Notes\" section of the Ghidra Installation Guide for more information.");
        }
        if (!installDir.canWrite()) {
            Msg.showError((Object)((Object)this), null, (String)"Permissions Error", (Object)"Cannot install/uninstall extensions: Invalid write permissions on installation directory.\nSee the \"Ghidra Extension Notes\" section of the Ghidra Installation Guide for more information.");
            return;
        }
        boolean install = (Boolean)aValue;
        ExtensionDetails extension = this.getSelectedExtension(rowIndex);
        if (!install) {
            if (extension.markForUninstall()) {
                this.refreshTable();
            }
            return;
        }
        if (extension.isPendingUninstall() && extension.clearMarkForUninstall()) {
            this.refreshTable();
            return;
        }
        if (extension.isFromArchive()) {
            if (ExtensionInstaller.installExtensionFromArchive(extension)) {
                this.refreshTable();
            }
            return;
        }
        Msg.error((Object)((Object)this), (Object)("Unable install an extension that no longer exists. Restart Ghidra and try manually installing the extension: '" + extension.getName() + "'"));
    }

    private boolean matchesGhidraVersion(ExtensionDetails details) {
        String ghidraVersion = Application.getApplicationVersion();
        String extensionVersion = details.getVersion();
        return ghidraVersion.equals(extensionVersion);
    }

    public Object getDataSource() {
        return null;
    }

    protected void doLoad(Accumulator<ExtensionDetails> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.extensions != null) {
            accumulator.addAll(this.extensions);
            return;
        }
        ExtensionUtils.reload();
        Set archived = ExtensionUtils.getArchiveExtensions();
        Set installed = ExtensionUtils.getInstalledExtensions();
        for (ExtensionDetails extension : installed) {
            if (!archived.remove(extension)) continue;
            Msg.trace((Object)((Object)this), (Object)("Not showing archived extension that has been installed.  Archive path: " + extension.getArchivePath()));
        }
        this.extensions = new HashSet<ExtensionDetails>();
        this.extensions.addAll(installed);
        this.extensions.addAll(archived);
        for (ExtensionDetails e : this.extensions) {
            String name = e.getName();
            if (this.originalInstallStates.containsKey(name)) continue;
            this.originalInstallStates.put(e.getName(), e.isInstalled());
        }
        accumulator.addAll(this.extensions);
    }

    public boolean hasModelChanged() {
        for (ExtensionDetails e : this.extensions) {
            Boolean wasInstalled = this.originalInstallStates.get(e.getName());
            if (wasInstalled == null) {
                return false;
            }
            if (e.isInstalled() == wasInstalled.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void setModelData(List<ExtensionDetails> model) {
        this.extensions = new HashSet<ExtensionDetails>(model);
        this.reload();
    }

    public void refreshTable() {
        this.extensions = null;
        this.reload();
    }

    private ExtensionDetails getSelectedExtension(int row) {
        return (ExtensionDetails)this.getRowObject(row);
    }

    private class ExtensionInstalledColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, Boolean, Object> {
        private ExtensionInstalledColumn(ExtensionTableModel extensionTableModel) {
        }

        public String getColumnName() {
            return "Installation Status";
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Boolean getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.isInstalled();
        }
    }

    private class ExtensionNameColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtRenderer renderer;

        private ExtensionNameColumn() {
            this.renderer = new ExtRenderer();
        }

        public String getColumnName() {
            return "Name";
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionDescriptionColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtRenderer renderer;

        private ExtensionDescriptionColumn() {
            this.renderer = new ExtRenderer();
        }

        public String getColumnName() {
            return "Description";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getDescription();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionVersionColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtRenderer renderer;

        private ExtensionVersionColumn() {
            this.renderer = new ExtRenderer();
        }

        public String getColumnName() {
            return "Version";
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            String version = rowObject.getVersion();
            if (version == null || version.equals("@extversion@")) {
                return "";
            }
            return version;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionInstallationDirColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtensionInstallationDirColumn(ExtensionTableModel extensionTableModel) {
        }

        public String getColumnName() {
            return "Installation Directory";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getInstallPath();
        }
    }

    private class ExtensionArchiveFileColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtensionArchiveFileColumn(ExtensionTableModel extensionTableModel) {
        }

        public String getColumnName() {
            return "Archive File";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getArchivePath();
        }
    }

    private class ExtRenderer
    extends AbstractGColumnRenderer<String> {
        private ExtRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component comp = super.getTableCellRendererComponent(data);
            ExtensionDetails extension = ExtensionTableModel.this.getSelectedExtension(data.getRowViewIndex());
            if (!ExtensionTableModel.this.matchesGhidraVersion(extension)) {
                comp.setForeground(this.getErrorForegroundColor(data.isSelected()));
            }
            return comp;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }
}

