/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import javax.swing.tree.TreePath;

public class ProjectDataCollapseAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    public ProjectDataCollapseAction(String owner, String group, Class<T> contextClass) {
        super("Collapse All", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"Collapse All"}, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        this.collapse(tree, paths[0]);
    }

    protected boolean isEnabledForContext(T context) {
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        TreePath[] paths = context.getSelectionPaths();
        GTreeNode node = (GTreeNode)paths[0].getLastPathComponent();
        if (node instanceof DomainFolderNode) {
            DomainFolderNode folderNode = (DomainFolderNode)node;
            return folderNode.isLoaded();
        }
        if (node instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)node;
            return fileNode.isFolderLink() && !fileNode.isLeaf() && fileNode.isLoaded();
        }
        return false;
    }

    private void collapse(DataTree tree, TreePath path) {
        tree.collapseAll((GTreeNode)path.getLastPathComponent());
    }
}

