/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;

public class NewSessionData {
    private Program sourceProgram;
    private Program destinationProgram;
    private DomainFile sourceFile;
    private DomainFile destinationFile;
    private DomainFolder sessionFolder;
    private String sessionName;
    private boolean preconditionChecksCompleted;

    public DomainFile getSourceFile() {
        return this.sourceFile;
    }

    public DomainFile getDestinationFile() {
        return this.destinationFile;
    }

    public Program getSourceProgram() {
        return this.sourceProgram;
    }

    public Program getDestinationProgram() {
        return this.destinationProgram;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DomainFolder getSessionFolder() {
        return this.sessionFolder;
    }

    public void setSourceFile(DomainFile file, PluginTool tool) {
        this.sourceFile = file;
        if (this.isProgramInvalidForFile(file, this.sourceProgram)) {
            this.sourceProgram.release((Object)tool);
            this.sourceProgram = null;
        }
    }

    private boolean isProgramInvalidForFile(DomainFile file, Program program) {
        if (program == null) {
            return false;
        }
        return !program.getDomainFile().equals((Object)file);
    }

    public void setDestinationFile(DomainFile file, PluginTool tool) {
        this.destinationFile = file;
        if (this.isProgramInvalidForFile(file, this.destinationProgram)) {
            this.sourceProgram.release((Object)tool);
            this.sourceProgram = null;
        }
    }

    public void setSourceProgram(Program program) {
        this.sourceProgram = program;
        this.preconditionChecksCompleted = false;
    }

    public void setDestinationProgram(Program program) {
        this.destinationProgram = program;
        this.preconditionChecksCompleted = false;
    }

    public void setSessionName(String name) {
        this.sessionName = name;
    }

    public void setSessionFolder(DomainFolder folder) {
        this.sessionFolder = folder;
    }

    public boolean hasPerformedPreconditionChecks() {
        return this.preconditionChecksCompleted;
    }

    public void setPerformedPreconditionChecks(boolean b) {
        this.preconditionChecksCompleted = b;
    }
}

